package com.gtis.oa.controller;

import cn.gtmap.common.utils.FileUtil;
import cn.gtmap.common.utils.RequestUtils;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.oa.model.StorageImage;
import com.gtis.oa.service.StorageImageService;
import com.gtis.oa.util.CommonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;

/**
 * @author 张顾培
 * @title UploadImageController
 * @projectName mineral
 * @description TODO
 * @date 2019/7/19 10:43
 */
@Slf4j
@Controller
@RequestMapping("/upload")
public class UploadController {

    @Autowired
    StorageClient storageClient;
    private static String rootPath = CommonUtil.getProjectPath();

    @Value("${app.storage}")
    private String storage;

    @Autowired
    StorageImageService storageImageService;

    @ResponseBody
    @RequestMapping(value = "/images")
    public Map<String, Object> images(@RequestParam(value = "file", required = false) MultipartFile multipartFile,
                                      HttpServletRequest request) {
        Map<String, Object> params = Maps.newHashMapWithExpectedSize(6);
        StorageImage storageImage = new StorageImage();
        if (multipartFile == null) {
            System.out.println("未获得上传文件!");
            return null;
        }

        String proid = RequestUtils.getParameter(request, "id");
        try {
            //文档中心
            MultipartDto multipartDto = new MultipartDto();
            multipartDto.setData(multipartFile.getBytes());
            multipartDto.setSpaceCode(proid);
            multipartDto.setClientId("officeAut");
            multipartDto.setName(multipartFile.getName());
            multipartDto.setSize(multipartFile.getSize());
            multipartDto.setContentType(multipartFile.getContentType());
            multipartDto.setOriginalFilename(multipartFile.getOriginalFilename());
            StorageDto storageDto=storageClient.multipartUpload(multipartDto);

            storageImage.setId(com.gtis.oa.common.utils.UUID.hex32());
            storageImage.setKeyId(proid);
            storageImage.setImageId(storageDto.getId());
            storageImageService.saveOrUpdate(storageImage);
            String fileName = multipartFile.getOriginalFilename();
            File file = FileUtil.getFileByMvc(multipartFile, request, "");
            //复制文件路径到服务器下,回显
//            String tempPath = "/static/temp/" + fileName;
//            String relativeUrl = rootPath + tempPath;
//            FileUtil.copyFile(file.toString(), relativeUrl);

            params.put("state", "SUCCESS");
            params.put("url",  storage+"/rest/files/download/"+storageDto.getId());
            params.put("size", multipartFile.getSize());
            params.put("original", fileName);
            params.put("type", multipartFile.getContentType());
            params.put("filename", multipartFile.getOriginalFilename());
            System.out.println(JSON.toJSON(params));
        } catch (Exception e) {
            params.put("state", "ERROR");
            log.error(e.getMessage());
        }
        return params;
    }
}
