package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.Telephone;
import com.gtis.oa.model.page.TelephonePage;
import com.gtis.oa.service.TelephoneService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 电话接听 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-15
 */
@Controller
@RequestMapping("/telephone")
public class TelephoneController {
    @Autowired
    TelephoneService telephoneService;

    /**
     * 跳转数据详情页
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Telephone telephone = null;
        if (StringUtils.isNotBlank(processInsId)) {
            telephone = telephoneService.getById(processInsId);
        }
        if(telephone == null){
            telephone = new Telephone();
            telephone.setId(processInsId);
        }
        model.addAttribute("telephone", telephone);
        model.addAttribute("view",view);
        return "officeapply/telephone/telephone_edit";
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/telephone/telephone_list";
    }


    /**
     * 根据查询条件分页查询
     * @param telephonePage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(TelephonePage telephonePage,long page,long limit){
        telephonePage.setCurrent(page);
        telephonePage.setSize(limit);
        IPage<Telephone> telephoneIPage = telephoneService.findByPage(telephonePage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",telephoneIPage.getRecords());
        resultMap.put("count",telephoneIPage.getTotal());
        return resultMap;
    }

    /**
     * 更新或新增
     * @param telephone
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<Telephone> save(Telephone telephone){
        return new ResponseMessage<Telephone>(telephoneService.saveOrUpdate(telephone),telephone);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Telephone> delete(String[] ids){
        return new ResponseMessage<>(telephoneService.removeByIds(Arrays.asList(ids)));
    }
}

