package com.gtis.oa.controller;


import com.gtis.oa.common.utils.Constants;
import com.gtis.oa.common.utils.MapUtils;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.Schedule;
import com.gtis.oa.model.dict.DictItem;
import com.gtis.oa.service.ScheduleService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-18
 */
@Controller
@RequestMapping("/schedule")
public class ScheduleController {

    @Autowired
    ScheduleService scheduleService;

    @RequestMapping(value="schedulePage")
    public String index(Model model) {
        model.addAttribute("userId", CommonUtil.getUserId());
        model.addAttribute("userName", CommonUtil.getUser().getAlias());
        return "management/schedule/schedule_page";
    }

    /**
     * 获取接收人的日程安排列表数据
     * @param beginTime
     * @param endTime
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/getScheduleList")
    @ResponseBody
    public Object getScheduleList(String beginTime, String endTime, String paramStr, String colorType) throws Exception {
        Map map = MapUtils.getMapFromStr(paramStr);
        if (map == null) {
            map = new HashMap();
        }
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        List<Schedule> scheduleList = scheduleService.getScheduleList(map);

        //DictItem dictItem = new DictItem();
        //测试颜色类型区分日程
        String colorValue = "";
        if(colorType.equals("canEdit")){
            colorValue = "#1883ff";
        }
        if(colorType.equals("partake")){
            colorValue = "green";
        }
        if(colorType.equals("public")){
            colorValue = "#e5e5e5";
        }

        Map resultMap = new HashMap();
        resultMap.put("scheduleList", scheduleList);
        resultMap.put("colorType", colorType);
        resultMap.put("colorValue", colorValue);
        resultMap.put("userId", CommonUtil.getUserId());
        resultMap.put("userName", CommonUtil.getUsername());
        return resultMap;
    }

    /**
     * 添加或者修改日程安排，id为空时则为添加
     * @param model
     * @param id
     * @return
     */
    @RequestMapping(value="/edit")
    public String edit(Model model, String id,String acceptView) {
        Schedule schedule = null;
        if (StringUtils.isNotBlank(id)) {
            HashMap map = new HashMap();
            map.put("id",id);
            schedule = scheduleService.findByMap(map);
        }
        if (schedule == null) {
            schedule = scheduleService.getNewSchedule(Constants.SCHEDULE_FLAG_PERSONAL);
        }
        model.addAttribute("schedule", schedule);

        if (StringUtils.isNotBlank(acceptView)) {
            model.addAttribute("acceptView", acceptView);
        }

        return "management/schedule/schedule_edit";
    }

    /**
     * 保存日程信息
     * @return schedule
     * @throws Exception
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Schedule> save(Schedule schedule){
        if(org.apache.commons.lang3.StringUtils.isNotBlank(schedule.getId())){
            HashMap map = new HashMap();
            map.put("id",schedule.getId());
            Schedule scheduleNew = scheduleService.findByMap(map);
            if (scheduleNew==null){
                return new ResponseMessage<Schedule>(scheduleService.save(schedule),schedule);
            }else {
                return new ResponseMessage<Schedule>(scheduleService.updateById(schedule),schedule);
            }
        }else{
            schedule.setId(UUID.hex32());
            return new ResponseMessage<Schedule>(scheduleService.save(schedule),schedule);
        }
    }

    /**
     * 删除日程记录
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/delete")
    @ResponseBody
    public ResponseMessage<Schedule> delete(String[] ids){
        return new ResponseMessage<>(scheduleService.removeByIds(Arrays.asList(ids)));
    }
}

