package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Receive;
import com.gtis.oa.model.Reimbursement;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.ReimbursementPage;
import com.gtis.oa.service.ReimbursementService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 费用报销申请 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-06-24
 */
@Controller
@RequestMapping("/reimbursement")
public class ReimbursementController {

    @Autowired
    private ReimbursementService reimbursementService;
    /**
     * 跳往编辑页面
     * @param processInsId
     * @return
     */
    @RequestMapping("/index")
    public String index(Model model, String processInsId,String view) {
        Reimbursement reimbursement = null;
        if (StringUtils.isNotBlank(processInsId)) {
            reimbursement = reimbursementService.getById(processInsId);
        }
        if (reimbursement == null){
            reimbursement = new Reimbursement();
            reimbursement.setReimId(processInsId);
            reimbursement.setApplyTime(new Date());
            reimbursement.setApplyPeople(CommonUtil.getUser().getAlias());
            reimbursement.setApplyUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
            reimbursementService.save(reimbursement);
        }
        model.addAttribute("view",view);
        model.addAttribute("reimbursement",reimbursement);
        return "officeapply/reimbursement/reimbursement_edit";
    }

    /**
     * 办理单列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/reimbursement/reimbursement_list";
    }

    /**
     * 分页查询
     * @param reimbursementPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(ReimbursementPage reimbursementPage,long page,long limit) {
        reimbursementPage.setCurrent(page);
        reimbursementPage.setSize(limit);
        IPage<Reimbursement> reimbursementIPage = reimbursementService.findByPage(reimbursementPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",reimbursementIPage.getRecords());
        resultMap.put("count",reimbursementIPage.getTotal());
        return resultMap;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Reimbursement> save(Reimbursement reimbursement) {
        return new ResponseMessage<Reimbursement>(reimbursementService.saveOrUpdate(reimbursement),reimbursement);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Reimbursement> delete(String[] ids){
        return new ResponseMessage<>(reimbursementService.removeByIds(Arrays.asList(ids)));
    }
}

