package com.gtis.oa.controller;


import cn.gtmap.gtc.portal.common.clients.UserRestClient;
import cn.gtmap.gtc.portal.common.dto.UserPortalDto;
import com.alibaba.fastjson.JSON;
import com.gtis.oa.model.PromulgatorUse;
import com.gtis.oa.service.PromulgatorUseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 用户选择参与人员 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-09-02
 */
@Controller
@RequestMapping("/promulgator")
public class PromulgatorUseController {
    @Autowired
    UserRestClient userRestClient;

    @Autowired
    PromulgatorUseService promulgatorService;

    @RequestMapping(value = "/index")
    public String index(Model model,String linkId,String peopleId){
        model.addAttribute("linkId",linkId);
        model.addAttribute("peopleId",peopleId);//此id动态获取业务表单的人员字段
        return "common/selectUser";
    }

    @RequestMapping(value = "/getUserZtree")
    @ResponseBody
    public String getUserZtree(){
        List<UserPortalDto> list = userRestClient.list(null,null);
        return JSON.toJSONString(list);
    }

    /**
     * 根据关联事件的ID获取参与用户列表数据
     * 该数据是
     *
     * @param linkId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/getUserListDataByLinkId")
    @ResponseBody
    public Object getUserListDataByLinkId(String linkId) {
        List<Map> data = new ArrayList<Map>();
        List<PromulgatorUse> promulgatorList = promulgatorService.getUserListDataByLinkId(linkId);
        if (promulgatorList != null) {
            for (PromulgatorUse promulgatorUse : promulgatorList) {
                Map map = new HashMap();
                map.put("id", promulgatorUse.getParticipantId());
                map.put("name", promulgatorUse.getPeopleName());
                map.put("pId", promulgatorUse.getOrganId());
                data.add(map);
            }
        }
        return data;
    }

    /**
     * 保存参与人员
     *
     * @param linkId
     * @param promulgatorListJson
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ResponseBody
    public Object save(String linkId, String promulgatorListJson) throws Exception {
        List<PromulgatorUse> promulgatorList = JSON.parseArray(promulgatorListJson, PromulgatorUse.class);
//        //去掉重复人员，属于多个部门
        List<PromulgatorUse> promulgatorListDis = new ArrayList<PromulgatorUse>();
        if (promulgatorList != null) {
            for (PromulgatorUse promulgatorUse : promulgatorList) {
                Boolean add = true;
                for (PromulgatorUse promulgatorListDi : promulgatorListDis) {
                    if (promulgatorListDi.getParticipantId().equals(promulgatorUse.getParticipantId())) {
                        add = false;
                        break;
                    }
                }
                if (add) {
                    promulgatorListDis.add(promulgatorUse);
                }

            }
        }
        return promulgatorService.saveOrUpdate(promulgatorListDis, linkId);
    }
}

