package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Outgoing;
import com.gtis.oa.model.Overtime;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.OvertimePage;
import com.gtis.oa.service.OvertimeService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 加班申请 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-06-27
 */
@Controller
@RequestMapping("/overtime")
public class OvertimeController {
    @Autowired
    OvertimeService overtimeService;

    /**
     * 发文办理单详情编辑页面
     *
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Overtime overtime = null;
        if (StringUtils.isNotBlank(processInsId)) {
            HashMap map = new HashMap();
            map.put("id",processInsId);
            overtime = overtimeService.findByMap(map);
        }
        if (overtime == null){
            overtime = new Overtime();
            overtime.setOvertimeId(processInsId);
            overtime.setApplyTime(new Date());
            overtime.setApplyPeople(CommonUtil.getUser().getAlias());
            overtime.setApplyUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
            overtimeService.save(overtime);
        }
        model.addAttribute("overtime",overtime);
        model.addAttribute("view",view);
        return "officeapply/overtime/overtime_edit";
    }

    /**
     * 办理单列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/overtime/overtime_list";
    }

    /**
     * 分页查询
     * @param overtimePage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(OvertimePage overtimePage,long page,long limit) {
        overtimePage.setCurrent(page);
        overtimePage.setSize(limit);
        IPage<Overtime> overtimeIPage = overtimeService.findByPage(overtimePage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",overtimeIPage.getRecords());
        resultMap.put("count",overtimeIPage.getTotal());
        return resultMap;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Overtime> save(Overtime overtime) {
        return new ResponseMessage<Overtime>(overtimeService.saveOrUpdate(overtime),overtime);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Overtime> delete(String[] ids){
        return new ResponseMessage<>(overtimeService.removeByIds(Arrays.asList(ids)));
    }
}

