package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Message;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MessagePage;
import com.gtis.oa.service.MessageService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-02
 */
@Controller
@RequestMapping("/message")
public class MessageController {

    @Autowired
    private MessageService messageService;

    /**
     * 跳往编辑页面
     * @return
     */
    @RequestMapping("/index")
    public String index(Model model, String proid,String accept) {
        Message message = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap map = new HashMap();
            map.put("id",proid);
            message = messageService.findByMap(map);
        }
        if (message == null){
            message = new Message();
            message.setId(UUID.hex32());
            message.setIsPublished("未发布");
            message.setCreateTime(new Date());
            messageService.save(message);
        }
        model.addAttribute("message", message);
        if (StringUtils.isNotBlank(accept)) {
            model.addAttribute("accept", accept);
        }
        return "management/message/message_edit";
    }

    /**
     * 列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(String type){
        if("manage".equals(type)){
            return "management/message/message_list";
        } else{
            return "management/message/message_list_view";
        }
    }

    /**
     * 列表
     *
     * @return
     */
    @RequestMapping(value = "/acceptList")
    public String acceptList(Model model,String type){
        model.addAttribute("userName", CommonUtil.getUsername());
        if("manage".equals(type)){
            return "management/message/message_acceptList";
        } else{
            return "management/message/message_acceptList_view";
        }
    }

    /**
     * 分页查询
     * @param messagePage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(MessagePage messagePage,long page,long limit) {
        messagePage.setCurrent(page);
        messagePage.setSize(limit);
        IPage<Message> messageIPage = messageService.findByPage(messagePage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",messageIPage.getRecords());
        resultMap.put("count",messageIPage.getTotal());
        return resultMap;
    }

    /**
     * 分页查询
     * @param messagePage
     * @return
     */
    @RequestMapping("/findViewByPage")
    @ResponseBody
    public IPage<Message> findViewByPage(MessagePage messagePage) {
        IPage<Message> messageIPage = messageService.findByPage(messagePage);
        return messageIPage;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Message> save(Message message) {
        if(org.apache.commons.lang3.StringUtils.isNotBlank(message.getId()) && (!"undefined".equals(message.getId()))){
            return new ResponseMessage<Message>(messageService.updateById(message), message);
        }else{
            message.setId(UUID.hex32());
            return new ResponseMessage<Message>(messageService.save(message), message);
        }
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/saveRead")
    @ResponseBody
    public ResponseMessage<Message> saveRead(String id) {
        HashMap map = new HashMap();
        map.put("id",id);
        Message message = messageService.findByMap(map);
        message.setIsRead("1");
        return new ResponseMessage<Message>(messageService.updateById(message), message);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Message> delete(String[] ids){
        return new ResponseMessage<>(messageService.removeByIds(Arrays.asList(ids)));
    }
}

