package com.gtis.oa.controller;


import cn.gtmap.common.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.DateUtils;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Meetroom;
import com.gtis.oa.model.MeetroomApply;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MeetroomApplyPage;
import com.gtis.oa.model.page.MeetroomPage;
import com.gtis.oa.service.MeetroomApplyService;
import com.gtis.oa.service.MeetroomService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 会议室申请 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-04
 */
@Controller
@RequestMapping("/meetroomApply")
public class MeetroomApplyController {

    @Autowired
    MeetroomApplyService meetroomApplyService;

    @Autowired
    MeetroomService meetroomService;

    /**
     * 进入会议室申请管理
     * @param model
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model) {
        MeetroomPage meetroomPage = new MeetroomPage();
        //获取所有的菜单
        IPage<Meetroom> list = meetroomService.findByPage(meetroomPage);
        List<Meetroom> meetroomList = list.getRecords();
        model.addAttribute("meetroomList",meetroomList);
        return "management/meet/meetroomApply_index";
    }

    /**
     * 进入会议室申请日历展示页面
     * @param model
     * @param roomId
     * @param roomName
     * @return
     */
    @RequestMapping(value = "/goCalendarMeeting")
    public String goCalendarMeeting(Model model,String roomId,String roomName) {
        model.addAttribute("roomId",roomId);
        model.addAttribute("roomName",roomName);
        return "management/meet/meetroomApply_calendar";
    }

    /**
     * 跳转会议室预定详情
     * @param model
     * @param id
     * @param roomId
     * @return
     */
    @RequestMapping(value = "/goMeetroomApply")
    public String goMeetroomApply(Model model,String id,String roomId,Date clickDate) {
        MeetroomApply meetroomApply = null;
        if (StringUtils.isNotBlank(id)) {
            meetroomApply = meetroomApplyService.getById(id);
        }
        if(meetroomApply == null){
            meetroomApply = new MeetroomApply();
            meetroomApply.setId(id);
            meetroomApply.setRoomId(roomId);
            meetroomApply.setMeetDate(CalendarUtil.formatDate(clickDate));
            meetroomApply.setRoomName(meetroomService.getById(roomId).getRoomName());
        }
        model.addAttribute("meetroomApply", meetroomApply);
        return "management/meet/meetroomApply_edit";
    }

    /**
     * 更新或新增
     * @param meetroomApply
     */
    @RequestMapping("/save")
    @ResponseBody
    public String save(MeetroomApply meetroomApply){
        HashMap<String, Object> result = new HashMap<>();
        result.put("msg", "预定成功！");
        result.put("result", true);
        String save = "true";
        try{
            //判断此段时间内会议室是否被使用
            HashMap map = new HashMap();
            map.put("ROOM_ID",meetroomApply.getRoomId());
            map.put("MEET_DATE",DateUtils.formatTime(meetroomApply.getMeetDate(),DateUtils.DATE_FORMAT));
            SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date beginTime =sdf.parse(DateUtils.formatTime(meetroomApply.getBeginTime(),DateUtils.DATEMIN_FORMAT));
            Date endTime = sdf.parse(DateUtils.formatTime(meetroomApply.getEndTime(),DateUtils.DATEMIN_FORMAT));
            List<MeetroomApply> oaMeetroomApplyList= meetroomApplyService.findByMap(map);
            if(CollectionUtils.isNotEmpty(oaMeetroomApplyList)){
                for(int i=0;i<oaMeetroomApplyList.size();i++){
                    Date startTime = oaMeetroomApplyList.get(i).getBeginTime();
                    Date finishTime = oaMeetroomApplyList.get(i).getEndTime();
                    if(((beginTime.after(startTime))&&(endTime.before(finishTime)))||((endTime.after(startTime))&&(endTime.before(finishTime)))
                            ||((beginTime.before(startTime))&&(endTime.after(finishTime)))||(beginTime.before(finishTime))){
                        result.put("msg", "此时间段该会议室已有预定！如遇预定冲突，及时管理员进行协调！");
                        result.put("result", false);
                        save = "false";
                    }
                }
            }
            if("true".equals(save)){
                if(StringUtils.isNotBlank(meetroomApply.getId())){
                    meetroomApplyService.updateById(meetroomApply);
                }else{
                    meetroomApply.setId(UUID.hex32());
                    meetroomApplyService.save(meetroomApply);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return JSON.toJSONString(result);
    }

    /**
     * 日历会议室页面根据roomId获取会议室使用情况
     * @param roomId
     * @return
     * @throws Exception
     */
    @RequestMapping(value="/getMeetroomApplyEvents")
    @ResponseBody
    public Object getMeetroomApplyEvents(String roomId) throws Exception{
        StringBuffer outStr = new StringBuffer();
        outStr.append("[");
        try{
            MeetroomApplyPage meetroomApplyPage = new MeetroomApplyPage();
            meetroomApplyPage.setRoomId(roomId);
            IPage<MeetroomApply> oaMeetroomApplyIPage = meetroomApplyService.findByPage(meetroomApplyPage);
            List<MeetroomApply> oaMeetroomApplyList = oaMeetroomApplyIPage.getRecords();
            if(CollectionUtils.isNotEmpty(oaMeetroomApplyList)){
                for(MeetroomApply oaMeetroomApply : oaMeetroomApplyList){
                    outStr.append("{");
                    outStr.append("title : \"会议室:"+oaMeetroomApply.getRoomName()+";");
                    outStr.append("\\n");
                    outStr.append("预定部门:"+oaMeetroomApply.getApplyUnit()+";");
                    outStr.append("\\n");
                    outStr.append("预订人:"+oaMeetroomApply.getApplyPeople()+";");
                    outStr.append("\\n");
                    outStr.append("会议主题:"+oaMeetroomApply.getMeetTheme()+";");
                    outStr.append("\",");

                    outStr.append("start : \""+ DateUtils.formatTime(oaMeetroomApply.getBeginTime(),DateUtils.DATEMIN_FORMAT)+"\",");
                    outStr.append("end: \""+DateUtils.formatTime(oaMeetroomApply.getEndTime(),DateUtils.DATEMIN_FORMAT)+"\",");
                    outStr.append("id: '"+oaMeetroomApply.getId()+"',");
                    outStr.append("allDay: false,");
                    outStr.append("meetroomId: '"+roomId+"'");
                    outStr.append("},");
                }
                outStr=outStr.deleteCharAt(outStr.lastIndexOf(","));
                outStr.append("]");
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return outStr.toString();
    }

    /**
     * 批量删除
     * @param id
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<MeetroomApply> delete(String id){
        return new ResponseMessage<>(meetroomApplyService.removeById(id));
    }
}

