package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Loan;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.LoanPage;
import com.gtis.oa.service.LoanService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 借款申请 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-06-27
 */
@Controller
@RequestMapping("/loan")
public class LoanController {
    @Autowired
    LoanService loanService;

    /**
     * 发文办理单详情编辑页面
     *
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Loan loan = null;
        if (StringUtils.isNotBlank(processInsId)) {
            loan = loanService.getById(processInsId);
        }
        if (loan == null){
            loan = new Loan();
            loan.setId(processInsId);
            loan.setApplyTime(new Date());
            loan.setApplyPeople(CommonUtil.getUser().getAlias());
            loan.setApplyUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
            loanService.save(loan);
        }
        model.addAttribute("loan",loan);
        model.addAttribute("view",view);
        return "officeapply/loan/loan_edit";
    }

    /**
     * 办理单列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/loan/loan_list";
    }

    /**
     * 分页查询
     * @param loanPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(LoanPage loanPage,long page,long limit) {
        loanPage.setCurrent(page);
        loanPage.setSize(limit);
        IPage<Loan> loanIPage = loanService.findByPage(loanPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",loanIPage.getRecords());
        resultMap.put("count",loanIPage.getTotal());
        return resultMap;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Loan> save(Loan loan) {
        return new ResponseMessage<Loan>(loanService.saveOrUpdate(loan),loan);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Loan> delete(String[] ids){
        return new ResponseMessage<>(loanService.removeByIds(Arrays.asList(ids)));
    }
}

