package com.gtis.oa.controller;


import com.alibaba.fastjson.JSON;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.LawsType;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.service.LawsTypeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 政策法规类型 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-02
 */
@Controller
@RequestMapping("/lawsType")
public class LawsTypeController {

    @Autowired
    LawsTypeService lawsTypeService;

    /**
     * 跳转法规类型ztree
     * @param model
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model) {
        return "management/laws/lawstype_tree";
    }

    /**
     * 获取所有政策法规类型
     * @return
     */
    @RequestMapping(value="getLawsTypeList")
    @ResponseBody
    public List<LawsType> getLawsTypeList(HttpServletRequest request, HttpServletResponse response){
        HashMap map = new HashMap();
        List<LawsType> lawsTypeList = lawsTypeService.getLawsTypeList(map);
        return lawsTypeList;
    }

    /**
     * 更新或新增
     * @param lawsType
     * @param ftypeParentId
     * @return
     */
    @RequestMapping(value="save")
    public ResponseMessage<LawsType> save(LawsType lawsType, String ftypeParentId, HttpServletRequest request, HttpServletResponse response) {
        ResponseMessage<LawsType> msg = null;
        try {
            Integer sort =0;
            String typeId = lawsType.getTypeId();
            if(StringUtils.isNotBlank(typeId)){
                LawsType temp = lawsTypeService.getById(typeId);
                temp.setFname(lawsType.getFname());
                temp.setFmemo(lawsType.getFmemo());
                temp.setIsUse(lawsType.getIsUse());
                List<String> nodeIdList = lawsTypeService.findNodeIdById(typeId);
                //更新所修改的id下面的子id对应的实体类
                if(CollectionUtils.isNotEmpty(nodeIdList)){
                    for(String nodeId : nodeIdList){
                        LawsType nodeTemp = lawsTypeService.getById(nodeId);
                        nodeTemp.setFtypeParentName(lawsType.getFname());
                        nodeTemp.setIsUse(lawsType.getIsUse());
                        lawsTypeService.updateById(nodeTemp);
                    }
                }
                msg = new ResponseMessage<LawsType>(lawsTypeService.updateById(temp),temp);
            } else {
                typeId = UUID.hex32();
                lawsType.setTypeId(typeId);
                HashMap map = new HashMap();
                if (StringUtils.isNotBlank(ftypeParentId)){
                    map.put("ftypeParentId",ftypeParentId);
                    sort = lawsTypeService.findMaxSort(map);
                    if (sort == null){
                        lawsType.setFtypeParentId(ftypeParentId);
                        lawsType.setSort(1);
                    }else{
                        lawsType.setFtypeParentId(ftypeParentId);
                        lawsType.setSort(++sort);
                    }
                }else {
                    map.put("ftypeParentId","-1");
                    sort = lawsTypeService.findMaxSort(map);
                    if (sort == null){
                        lawsType.setSort(1);
                        lawsType.setFtypeParentId("-1");
                    }else{
                        lawsType.setSort(++sort);
                        lawsType.setFtypeParentId("-1");
                    }
                }
                msg = new ResponseMessage<LawsType>(lawsTypeService.save(lawsType),lawsType);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    /**
     *  删除节点
     * @param typeId
     * @param ftypeParentId
     * @param sort
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public String delete(@RequestParam(name = "typeId", required = false)String typeId,
                             @RequestParam(name = "ftypeParentId", required = false)String ftypeParentId,
                             @RequestParam(name = "sort", required = false)Integer sort, HttpServletRequest request, HttpServletResponse response) {
        String result = "success";
        List<Map> listNode = new ArrayList<Map>();
        List<LawsType> lawsTypeList = new ArrayList<LawsType>();
        try {
            List<String> idList = lawsTypeService.findNodeIdById(typeId);
            //查询大于所删除的节点序号的节点
            listNode = lawsTypeService.findDyXh(ftypeParentId,sort);
            if (listNode.size() > 0) {
                //重新排序
                for (Map node : listNode) {
                    LawsType lawsType = new LawsType();
                    lawsType.setTypeId(node.get("TYPE_ID").toString());
                    BigDecimal nodesort = (BigDecimal) node.get("SORT");
                    int intNodeSort = nodesort.intValue();
                    lawsType.setSort(--intNodeSort);
                    lawsTypeList.add(lawsType);
                }
            }
            lawsTypeService.removeById(typeId);
            //重新排序
            if (lawsTypeList.size() > 0) {
                for (LawsType lawsType : lawsTypeList) {
                    lawsTypeService.saveOrUpdate(lawsType);
                }
            }
            //批量删除关联表信息
            lawsTypeService.removeByIds(idList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return JSON.toJSONString(result);
    }

    /**
     * 组织左边导航栏
     * @return
     */
    @RequestMapping("/getParentMeun")
    @ResponseBody
    public List<LawsType> getParentMeun() {
        HashMap map = new HashMap();
        map.put("isUse","是");
        //获取所有的菜单(包括子菜单和父级菜单)
        List<LawsType> list = lawsTypeService.getLawsTypeList(map);
        //创建一个集合用于保存所有的主菜单
        List<LawsType> rootMeun=new ArrayList<>();
        //遍历所有菜单集合,如果是主菜单的话直接放入rootMeun集合
        for (LawsType lawsType:list){
            //判断为-1是因为我的主菜单标识是-1
            if ("-1".equals(lawsType.getFtypeParentId())){
                rootMeun.add(lawsType);
            }
        }
        //这个是遍历所有主菜单,分别获取所有主菜单的所有子菜单
        for (LawsType temp:rootMeun){
            //获取所有子菜单 递归
            List<LawsType> childrenList=getchildrenMeun(temp.getTypeId(),list);
            //这个是实体类中的子菜单集合
            temp.setChildrenList(childrenList);
        }
        return rootMeun;
    }

    /**
     *    递归获取子菜单
     **/
    private List<LawsType> getchildrenMeun(String typeId,List<LawsType> allMeun) {
        //用于保存子菜单
        List<LawsType> childrenList = new ArrayList<>();
        for (LawsType lawsType : allMeun) {
            //判断当前的菜单标识是否等于主菜单的id
            if (lawsType.getFtypeParentId().equals(typeId)) {
                //如果是的话 就放入主菜单对象的子菜单集合
                childrenList.add(lawsType);
            }
        }

        //这里就是递归了，遍历所有的子菜单
        for (LawsType info : childrenList) {
            info.setChildrenList(getchildrenMeun(info.getTypeId(), allMeun));
        }

        //如果子菜单为空的话，那就说明某菜单下没有子菜单了，直接返回空,子菜单为空的话就不会继续
        //迭代了
        if (childrenList != null && childrenList.size() == 0) {
            return null;
        }
        return childrenList;
    }

    /**
     * 保存政策法规目录树
     */
    @RequestMapping("/saveTreeLawsType")
    public void saveTreeLawsType() {
        String url = "http://f.mnr.gov.cn/";
        try {
            Map<String, String> map = lawsTypeService.getLawsTypeWithUrl(url);
            for (String key : map.keySet()) {
                String value = map.get(key);
                String[] values = value.split(",");
                LawsType lawsType = lawsTypeService.getById(key);
                if(lawsType == null) {
                    LawsType lawsTypeNew = new LawsType();
                    lawsTypeNew.setTypeId(key);
                    lawsTypeNew.setFmemo(values[1]);
                    lawsTypeNew.setFname(values[1]);
                    lawsTypeNew.setFtypeParentId(values[0]);
                    lawsTypeNew.setIsUse("是");
                    lawsTypeNew.setSort(Integer.parseInt(key));
                    lawsTypeService.saveOrUpdate(lawsTypeNew);
                }
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }
}
