package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Laws;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.LawsPage;
import com.gtis.oa.service.LawsService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 政策法规 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-02
 */
@Controller
@RequestMapping("/laws")
public class LawsController {

    @Autowired
    LawsService lawsService;

    /**
     * 跳转法规类型导航栏
     * @param model
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model,String type) {
        model.addAttribute("type",type);
        return "management/laws/laws_index";
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String treeLinkId,String treeName,String type){
        model.addAttribute("treeLinkId",treeLinkId);
        if("588".equals(treeLinkId)) {
            model.addAttribute("fpubDpt",treeName);
        }else if("579".equals(treeLinkId)){
            model.addAttribute("treeName",treeName);
        }else if("569".equals(treeLinkId)){
            model.addAttribute("effectLeve",treeName);
        }else if("530".equals(treeLinkId)){
            model.addAttribute("userArea",treeName);
        }else {
            model.addAttribute("treeName",treeName);
        }
        if("manage".equals(type)){
            return "management/laws/laws_list";
        } else {
            return "management/laws/laws_list_view";
        }
    }

    /**
     * 根据查询条件分页查询
     * @param lawsPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(LawsPage lawsPage, HttpServletRequest request, HttpServletResponse response,long page,long limit){
        lawsPage.setCurrent(page);
        lawsPage.setSize(limit);
        IPage<Laws> lawsIPage = lawsService.findByPage(lawsPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",lawsIPage.getRecords());
        resultMap.put("count",lawsIPage.getTotal());
        return resultMap;
    }

    /**
     * 根据查询条件分页查询
     * @param lawsPage
     * @return
     */
    @RequestMapping("/findTempByPage")
    @ResponseBody
    public IPage<Laws> findTempByPage(LawsPage lawsPage, HttpServletRequest request, HttpServletResponse response){
        IPage<Laws> lawsIPage = lawsService.findByPage(lawsPage);
        return lawsIPage;
    }

    /**
     * 编辑数据详情页
     * @param model
     * @param lawId
     * @param treeLinkId
     * @param treeName
     * @return
     */
    @RequestMapping(value = "/edit")
    public String edit(Model model,String lawId,String treeLinkId,String treeName) {
        Laws laws = null;
        if ((StringUtils.isNotBlank(lawId)) && (!"undefined".equals(lawId))) {
            laws = lawsService.getById(lawId);
        }
        if(laws == null){
            laws = new Laws();
            laws.setLawId(UUID.hex32());
            laws.setTreeLinkId(treeLinkId);
            laws.setTreeName(treeName);
        }
        model.addAttribute("laws", laws);
        return "management/laws/laws_edit";
    }

    /**
     * 更新或新增
     * @param laws
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<Laws> save(Laws laws, HttpServletRequest request, HttpServletResponse response){
       return  new ResponseMessage<Laws>(lawsService.saveOrUpdate(laws),laws);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Laws> delete(String[] ids, HttpServletRequest request, HttpServletResponse response){
        return new ResponseMessage<>(lawsService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 跳转政策法规展示页
     * @param model
     * @param lawId
     * @return
     */
    @RequestMapping(value = "/showLaws")
    public String showLaws(Model model,String lawId) {
        Laws laws = lawsService.getById(lawId);
        model.addAttribute("laws",laws);
        return "management/laws/laws_show";
    }

    @RequestMapping(value = "/saveTreeLaws")
    public void saveTreeLaws() {
        String url = "http://f.mnr.gov.cn/index_3553.html";

        int s = 0;
        int i = 1;
		while (i<97) {
            int updataC = lawsService.getLawsWithUrl(url);
            s = s + updataC;
            System.out.print(url + s);
            url = "http://f.mnr.gov.cn/index_3553_" + i + ".html";
            i++;
		}
    }
}

