package com.gtis.oa.controller;


import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Dispatch;
import com.gtis.oa.model.Receive;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.DispatchPage;
import com.gtis.oa.service.DispatchService;
import com.gtis.oa.util.CommonUtil;
import com.gtis.oa.util.MacroUtil;
import com.gtis.oa.util.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * <p>
 * 发文 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-08
 */
@Controller
@RequestMapping("/dispatch")
public class DispatchController {
    @Autowired
    DispatchService dispatchService;
    @Autowired
    StorageClient storageClient;
    @Autowired
    UserManagerClient userManagerClient;
    /**
     * 发文办理单详情编辑页面
     *
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Dispatch dispatch = null;
        if (StringUtils.isNotBlank(processInsId)) {
            dispatch = dispatchService.getById(processInsId);
        }
        if (dispatch == null){
            dispatch = new Dispatch();
            dispatch.setDispatchId(processInsId);
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(Calendar.YEAR);
            dispatch.setDispatchYear(year + "");
            dispatch.setDraftDate(new Date());
            dispatchService.save(dispatch);
        }
        String clientId = "officeAut";
        StorageDto storageDto = storageClient.createRootFolder(clientId,processInsId,"发文正文",null);
        model.addAttribute("dispatch",dispatch);
        model.addAttribute("view",view);
        return "document/dispatch/dispatch_edit";
    }

    /**
     * 发文办理管理列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(){
        return "document/dispatch/dispatch_list";
    }

    /**
     * 发文办理查看列表
     *
     * @return
     */
    @RequestMapping(value = "/viewList")
    public String viewList(){
        return "document/dispatch/dispatch_list_view";
    }

    /**
     * 分页查询
     * @param dispatchPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(DispatchPage dispatchPage,long page,long limit) {
        Map<String,Object> resultMap = new HashMap<>();
        try{
            dispatchPage.setCurrent(page);
            dispatchPage.setSize(limit);
            IPage<Dispatch> dispatchIPage = dispatchService.findByPage(dispatchPage);

            resultMap.put("code","0");
            resultMap.put("data",dispatchIPage.getRecords());
            resultMap.put("count",dispatchIPage.getTotal());
        } catch (Exception e){
            e.printStackTrace();
        }
        return resultMap;
    }
    /**
     * 分页查询
     * @param dispatchPage
     * @return
     */
    @RequestMapping("/findTempByPage")
    @ResponseBody
    public IPage<Dispatch> findTempByPage(DispatchPage dispatchPage) {
        IPage<Dispatch> dispatchIPage = dispatchService.findByPage(dispatchPage);
        return dispatchIPage;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Dispatch> save(Dispatch dispatch) {
        return new ResponseMessage<Dispatch>(dispatchService.saveOrUpdate(dispatch),dispatch);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Dispatch> delete(String[] ids){
        return new ResponseMessage<>(dispatchService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 获取发文编号
     * @return
     */
    @RequestMapping(value="/dispatchNo")
    @ResponseBody
    public long dispatchNo(String name, String year){
        long no = 0;
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("dispatchName", name);
        map.put("dispatchYear", year);
        Object queryNo = dispatchService.getMaxDispatchNo(map);
        if (queryNo == null) {
            no = 1;
        } else {
            no = (Long) queryNo;
        }
        return no + 1;
    }

    /**
     * 发文正文
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value="/content")
    public String content(Model model, String processInsId,HttpServletRequest request) throws Exception {
        processInsId = "335891";
        String  unitName = "";
        String clientId = "officeAut";
        List<StorageDto> file = null;
        List<StorageDto> files = new ArrayList<>();
        //获取所有文件夹
        List<StorageDto> folders = storageClient.listAllRootStorages(clientId,processInsId,null,null,null,0);
        if (folders != null && !folders.isEmpty()) {
            //遍历文件下的文件
            for (StorageDto folder : folders) {
                if (folder.getName().equals("发文正文")){
                    file = storageClient.listAllSubsetStorages(folder.getId(),null, null, 1);
                    files.add(file.get(0));
                }
            }
        }

        String docfileName = "";
        String docfid = "";
        String cebfid = "";
        String cebfileName = null;
        if (files != null) {
            for (StorageDto f: files) {
                if ((f.getName().toLowerCase()).endsWith(".doc") || (f.getName().toLowerCase()).endsWith(".docx")) {
                    docfid = f.getId();
                    docfileName = f.getName();
                }
                if ((f.getName().toLowerCase()).endsWith(".ceb")) {
                    cebfid = f.getId();
                    cebfileName = f.getName();
                }
            }
        }
        //读取blank.doc模板路径
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
        model.addAttribute("basePath", basePath);
        model.addAttribute("unitName", unitName);
        model.addAttribute("docfileName", docfileName);
        model.addAttribute("docfid", docfid);
        model.addAttribute("cebfid", cebfid);
        model.addAttribute("cebfileName", cebfileName);

        Dispatch dispatch = dispatchService.getById(processInsId);
        if(dispatch==null){
            dispatch = new Dispatch();
        }
        model.addAttribute("dispatch", dispatch);
        model.addAttribute("macroStr", MacroUtil.parseTemplet(dispatch,basePath));

        String redhead = "";
        model.addAttribute("redhead", redhead);

        UserDto userDto = userManagerClient.getCurrentUser();
        String userName = userDto.getUsername();
        List<OrganizationDto> userDptList = userDto.getOrgRecordList();
        String userDpt = userDptList.get(0).getName();

        model.addAttribute("loginuser", userName);
        model.addAttribute("userDpt", userDpt);
        model.addAttribute("proid", processInsId);

        // 检查授权信息
        model.addAttribute("author", checkPlatformAuthor(processInsId));
        return "document/dispatch/dispatch_content";
    }

    /**
     * 获取页面控件的授权信息
     * @return
     */
    public Map checkPlatformAuthor(String proid) {
        Map<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("proid", proid);
        paraMap.put("saveCtrl", "TRUE");
        paraMap.put("canExecMacro", "TRUE");
        paraMap.put("canImport", "FALSE");
        paraMap.put("canTransCEB", "FALSE");
        paraMap.put("IsRecMark", "FALSE");  //痕迹一般不显示
        paraMap.put("canSaveas", "FALSE");   //另存为一般不显示
        return paraMap;
    }

    /**
     * 在线预览
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "onlyoffice")
    public String onlyoffice(Model model,String processInsId) throws Exception {
        String clientId = "officeAut";
        List<StorageDto> file = null;
        List<StorageDto> files = new ArrayList<>();
        //获取所有文件夹
        List<StorageDto> folders = storageClient.listAllRootStorages(clientId,processInsId,null,null,null,0);
        if (folders != null && !folders.isEmpty()) {
            //遍历文件下的文件
            for (StorageDto folder : folders) {
                if (folder.getName().equals("发文正文")){
                    file = storageClient.listAllSubsetStorages(folder.getId(),null, null, 1);
                    if(file.size()>0){
                        files.add(file.get(0));
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(files)){
            model.addAttribute("url",files.get(0).getDownUrl());
            String fileName = files.get(0).getName();
            String name = fileName.substring(0,fileName.lastIndexOf("."));
            String type = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            model.addAttribute("name",name);
            model.addAttribute("type",type);
        } else {
            model.addAttribute("url","http://192.168.8.118:7000/oa/static/blank.docx");
            String fileName = "blank.docx";
            model.addAttribute("name","blank");
            model.addAttribute("type","docx");
        }
        return "document/dispatch/only_office";
    }
}

