package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Car;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.CarPage;
import com.gtis.oa.service.CarService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-06-25
 */
@Controller
@RequestMapping("/car")
public class CarController {

    @Autowired
    CarService carService;

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/useCar/car_list";
    }

    /**
     * 根据查询条件分页查询
     * @param carPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(CarPage carPage, long page, long limit){
        carPage.setCurrent(page);
        carPage.setSize(limit);
        IPage<Car> carIPage = carService.findByPage(carPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",carIPage.getRecords());
        resultMap.put("count",carIPage.getTotal());
        return resultMap;
    }

    /**
     * 跳转数据详情页
     * @param model
     * @param id
     * @return
     */
    @RequestMapping(value = "/index")
    public String indexCar(Model model,String id,String view) {
        Car car = null;
        if (StringUtils.isNotBlank(id)) {
            car = carService.getById(id);
        }
        if(car == null){
            car = new Car();
            car.setCarId(UUID.hex32());
        }
        model.addAttribute("car", car);
        model.addAttribute("view",view);
        return "officeapply/useCar/car_edit";
    }

    /**
     * 更新或新增
     * @param car
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<Car> save(Car car){
        return new ResponseMessage<Car>(carService.saveOrUpdate(car),car);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Car> delete(String[] ids){
        return new ResponseMessage<>(carService.removeByIds(Arrays.asList(ids)));
    }
}

