package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.*;
import com.gtis.oa.model.page.AssetPage;
import com.gtis.oa.service.AssetAttachmentService;
import com.gtis.oa.service.AssetService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import org.springframework.stereotype.Controller;

import java.util.*;


/**
 * <p>
 * 固定资产 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-15
 */
@Slf4j
@Controller
@RequestMapping("/asset")
public class AssetController {
    @Autowired
    AssetService assetService;
    @Autowired
    AssetAttachmentService assetAttachmentService;

    /**
     * 详情编辑页面
     *
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Asset asset = null;
        if (StringUtils.isNotBlank(processInsId)) {
            HashMap map = new HashMap();
            map.put("id",processInsId);
            asset = assetService.findByMap(map);
        }
        if (asset == null){
            asset = new Asset();
            asset.setId(processInsId);
            asset.setApplyTime(new Date());
        }
        model.addAttribute("asset",asset);
        model.addAttribute("proid",processInsId);
        model.addAttribute("view",view);
        //测试展示
        OaDict oaDict = new OaDict();
        oaDict.setName("办公设备");
        OaDict oaDict1 = new OaDict();
        oaDict1.setName("办公电器");
        List<OaDict> wpType = new ArrayList();
        wpType.add(oaDict);
        wpType.add(oaDict1);
        model.addAttribute("wpType",wpType);

        OaDict oaDict2 = new OaDict();
        oaDict2.setId("办公设备");
        oaDict2.setName("电脑");
        OaDict oaDict3 = new OaDict();
        oaDict3.setId("办公设备");
        oaDict3.setName("考勤机");
        List<OaDict> sbmc = new ArrayList();
        sbmc.add(oaDict2);
        sbmc.add(oaDict3);
        model.addAttribute("sbmc",sbmc);

        OaDict oaDict4 = new OaDict();
        oaDict4.setId("办公电器");
        oaDict4.setName("电风扇");
        OaDict oaDict5 = new OaDict();
        oaDict5.setId("办公电器");
        oaDict5.setName("空调");
        List<OaDict> dqmc = new ArrayList();
        dqmc.add(oaDict4);
        dqmc.add(oaDict5);
        model.addAttribute("dqmc",dqmc);

        return "officeapply/asset/asset_edit";
    }

    /**
     * 测试查询后的下拉
     */
    @RequestMapping("/getDictByType")
    @ResponseBody
    public List<OaDict> getDictByType(String dictId) {
        List<OaDict> mc = new ArrayList();
        if (dictId.equals("办公电器")){
            OaDict oaDict4 = new OaDict();
            oaDict4.setId("办公电器");
            oaDict4.setName("电风扇");
            OaDict oaDict5 = new OaDict();
            oaDict5.setId("办公电器");
            oaDict5.setName("空调");
            mc.add(oaDict4);
            mc.add(oaDict5);
        }else {
            OaDict oaDict2 = new OaDict();
            oaDict2.setId("办公设备");
            oaDict2.setName("电脑");
            OaDict oaDict3 = new OaDict();
            oaDict3.setId("办公设备");
            oaDict3.setName("考勤机");
            mc.add(oaDict2);
            mc.add(oaDict3);
        }
        return mc;
    }

    /**
     * list
     */
    @RequestMapping(value ="/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/asset/asset_list";
    }

    /**
     * 分页查询
     * @param assetPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(AssetPage assetPage,long page,long limit) {
        assetPage.setCurrent(page);
        assetPage.setSize(limit);
        IPage<Object> AssetIPage = null;
        try{
            AssetIPage = assetService.findByPage(assetPage);
        }
        catch (Exception e){
            e.printStackTrace();
        }

        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",AssetIPage.getRecords());
        resultMap.put("count",AssetIPage.getTotal());
        return resultMap;
    }

    /**
     * 固定资产情况列表
     * @param proid
     * @return
     */
    @RequestMapping("/assetList")
    @ResponseBody
    public List<AssetAttachment> assetList(String proid){
        HashMap map = new HashMap();
        map.put("id",proid);
        List<AssetAttachment> assetAttachmentList = assetAttachmentService.findByMap(map);
        if (assetAttachmentList.size() == 0) {
            assetAttachmentList = new ArrayList<>(1);
        }
        return assetAttachmentList;
    }

    /**
     * 批量删除主表
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Asset> delete(String[] ids){
        return new ResponseMessage<>(assetService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 批量删除子表
     * @param ids
     * @return
     */
    @RequestMapping("/deleteAtt")
    @ResponseBody
    public ResponseMessage<AssetAttachment> deleteAtt(String[] ids){
        return new ResponseMessage<>(assetAttachmentService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 保存
     * @param assetModel
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public Map<String, Object> save(AssetModel assetModel) {
        boolean result = false;
        String msg = "操作失败！";
        if (assetModel != null) {
            try {
                assetAttachmentService.saveAsset(assetModel);
                result = true;
                msg = "操作成功！";
            } catch (Exception e) {
                e.getMessage();
            }
        }
        Map<String,Object> map = Maps.newHashMapWithExpectedSize(2);
        map.put("result",result);
        map.put("msg",msg);
        return  map;
    }
}

