package com.gtis.oa.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;
import java.util.Properties;


/**
 * MyBatis基础配置
 * @author zsj
 * @version v1.0, 2018/6/25
 */
@Configuration
@EnableTransactionManagement
@Order(1)
//public class MyBatisConfig implements TransactionManagementConfigurer {
public class MyBatisConfig {

    @Autowired
    private Environment env;

    @Autowired
    private PaginationInterceptor paginationInterceptor;


    @Bean
    public DataSource getDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(env.getProperty("spring.datasource.url"));
        dataSource.setUsername(env.getProperty("spring.datasource.username"));
        dataSource.setPassword(env.getProperty("spring.datasource.password"));
        return dataSource;
    }


    @Bean(name = "sqlSessionFactory")
    public SqlSessionFactory sqlSessionFactoryBean() {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(getDataSource());
        bean.setTypeAliasesPackage("com.gtis.oa.model");
        bean.setPlugins(new Interceptor[]{paginationInterceptor});
        Properties configurationProperties = new Properties();
        configurationProperties.setProperty("logImpl", "STDOUT_LOGGING");
        // 全局映射器启用缓存
        configurationProperties.setProperty("cacheEnabled", "false");
        // 将空值字段也映射到map中
        configurationProperties.setProperty("callSettersOnNulls", "true");

        // 延迟加载的全局开关。当开启时，所有关联对象都会延迟加载。 特定关联关系中可通过设置fetchType属性来覆盖该项的开关状态。
        configurationProperties.setProperty("lazyLoadingEnabled", "true");
        // 当启用时，对任意延迟属性的调用会使带有延迟加载属性的对象完整加载；反之，每种属性将会按需加载
        configurationProperties.setProperty("aggressiveLazyLoading", "false");
        //是否允许单一语句返回多结果集（需要兼容驱动）
        configurationProperties.setProperty("multipleResultSetsEnabled", "true");
        //
        configurationProperties.setProperty("useColumnLabel", "true");
        //
        configurationProperties.setProperty("useGeneratedKeys", "false");
        //指定 MyBatis 应如何自动映射列到字段或属性。 NONE 表示取消自动映射；PARTIAL 只会自动映射没有定义嵌套结果集映射的结果集。 FULL 会自动映射任意复杂的结果集（无论是否嵌套）。
        configurationProperties.setProperty("autoMappingBehavior", "PARTIAL");
        // 配置默认的执行器。SIMPLE 就是普通的执行器；REUSE 执行器会重用预处理语句（prepared statements）； BATCH 执行器将重用语句并执行批量更新。
        configurationProperties.setProperty("defaultExecutorType", "SIMPLE");
        // 设置超时时间，它决定驱动等待数据库响应的秒数。
        configurationProperties.setProperty("defaultStatementTimeout", "25000");
        // 允许在嵌套语句中使用分页（RowBounds）。 If allow, set the false.
        configurationProperties.setProperty("safeRowBoundsEnabled", "false");
        // 是否开启自动驼峰命名规则（camel case）映射，即从经典数据库列名 A_COLUMN 到经典 Java 属性名 aColumn 的类似映射。
        configurationProperties.setProperty("mapUnderscoreToCamelCase", "true");
        configurationProperties.setProperty("localCacheScope", "SESSION");
        // 插入或者更新操作的时候null值按照字符串的格式来转换为null
        configurationProperties.setProperty("jdbcTypeForNull", "NULL");
        // 指定哪个对象的方法触发一次延迟加载。
        configurationProperties.setProperty("lazyLoadTriggerMethods", "equals,clone,hashCode,toString");
        bean.setConfigurationProperties(configurationProperties);
//
        //添加XML目录
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
//
        try {
            bean.setMapperLocations(resolver.getResources("classpath*:mybatis/*.xml"));
            return bean.getObject();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

}