package com.gtis;

import cn.gtmap.gtc.starter.gcas.GTMapCloudApplication;
import cn.gtmap.gtc.starter.gscas.GTMapSecCloudApplication;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 *
 * @Author zsj
 * @Date 16:39 2019/6/10
 * @version 1.0
 **/
@GTMapSecCloudApplication(feignClientsPackages = {"cn.gtmap.gtc.clients",
        "cn.gtmap.gtc.storage.clients",
        "cn.gtmap.gtc.workflow.clients",
        "cn.gtmap.gtc.utilclient.common.client.rest",
        "cn.gtmap.gtc.portal.common.clients"
})
@EntityScan(basePackages = {"com.gtis.oa.model"})
@EnableSwagger2
//@EnableScheduling 定时任务
@RestController
@MapperScan("com.gtis.oa.mapper")
public class App {

    public static void main(String[] args) {
        SpringApplication.run(App.class, args);
    }

    @RequestMapping("/test")
    public String test () {
        return "11111";
    }

}
