/**
 * @class FR.WritePane
 * @class
 */
$.extend(FR.WritePane.prototype, function () {
    var P = {
        /*
         * alex:ʼContentPane
         */
        initContentPane: function () {
            this.currentSessionID = "";
            this.isWriteOfflinePage = true;
            if (this.options["writeCss"]) {
                $.each(this.options["writeCss"], function (i, item) {
                    FR.$import(item, 'css');
                });
            }
            var tabPane = this.$contentPane.data("TabPane");
            var self = this;
            if (tabPane) {//jamesTabPane
                tabPane.on(FR.Events.TABCHANGESTART, function () {
                    if (self.curLGP) {
                        self.stopEditing();
                        if ($('div.verify-error-info:visible', FR.$view_container).length > 0) {
                            $('div.verify-error-info:visible', FR.$view_container).hide();
                        }
                    }
                });
                //jamesTabPanetabchange¼
                tabPane.on(FR.Events.TABCHANGE, function (tabPane, tabIndex) {
                    self.selectedIndex = tabIndex;
                    self.fireEvent(FR.Events.TABCHANGE, tabPane, tabIndex);
                });
                //jamesǰFormPanetabchange¼ִtabchange
                this.on(FR.Events.TABCHANGE, function (tabPane, tabIndex) {
                    if (self.delay) {
                        return;
                    }

                    self.selectedIndex = tabIndex;
                    var lgp = self.lgps[tabIndex];
                    if (lgp.loaded === false) {
                        lgp.loadLGPPane();
                    } else {
                        // Carlôܲ
                        self.curLGP = lgp;
                        self.curLGP._selectFirstTD();
                        self.curLGP.onfocus();
                        if (!lgp.frozenModified && $('.frozen-center', lgp.$container).length > 0) {
                            if (lgp.$sheet_container.parent().isVisible()) {
                                FR.layoutFrozen(lgp.$sheet_container, lgp.$sheet_container.offset().top);
                                lgp.frozenModified = true;
                            }
                        }
                    }

//                    self.selectedIndex = lgp.idx;
                    // ҳ,ĿsheetҳϢݸwritePane,fire(afterload)Ϊ˸¹ҳ
                    if (self.options["cutpage"] == 'v' || self.options["cutpage"] == 'w') {
                        self.currentPageIndex = lgp.currentPageIndex;
                        self.reportTotalPage = lgp.reportTotalPage;
                        self.fireEvent(FR.Events.AFTERLOAD);
                    }
                });

                var tabs = tabPane.options.tabs;//jamesȡtabsĸ
                this.lgps = [];
                for (var i = 0, count = tabs.length; i < count; i++) {
                    this.lgps[i] = new FR.WLGP({
                        idx: i,
                        $container: $(tabs[i].content),
                        writePane: this,
                        selectMethod: this.selectMethod
                    });
                }
            } else {
                this.lgps = [new FR.WLGP({
                    idx: 0,
                    $container: this.$contentPane,
                    writePane: this,
                    selectMethod: this.selectMethod
                })];
            }

            // todo ҳϢ
            for (var key in FR.WE.config) {
                if (key == "lgps") {
                    continue;
                }
                this[key+""] = FR.WE.config[key+""];
            }
            FR.requestURL = FR.WE.config.requestURL;
            // sheetӱṹϢ Լñش洢ݸresultCells
            for (var i=0; i<this.lgps.length; i++) {
                // ̶
                this.lgps[i].refreshDataOnInit();
                // 
                this.lgps[i].refreshDataByLocal();
            }
            this.processNote = FR.WE.getProcessNote() || [];


            if (this.options['selectedColor']) {
                var color = '.test{background-color:' + this.options['selectedColor'] + '!important}';
                $('<style type="text/css">' + color + '</style>').appendTo('head');
            }

            // ʼճ
            $("body").append("<div style='position:absolute;left:-1000px;top:-1000px;'>" +
                "<textarea id='cpTextArea' onkeyup='this.blur()'></textarea></div>");

            /**
             * ҳתʱʾ,֧opera
             */
            window.onbeforeunload = this.beforeUnloadCheck.createDelegate(this);

            // ֹbackspaceת.
            $(document)[($.browser.mozilla || $.browser.opera)
                ? 'keypress'
                : 'keydown'](function (e) {
                self.banBackSpace(e);
            });

        },


        /**
         * ύ ҪѵǰϢ͵̨ȥƥ
         * õsessionID ִУĲ  todo
         */
        verifyAndWriteReport: function (isAllSheet, submitButton, successFn) {
            var self = this;
            var o = {
                overlay_immediately: true,
                text: FR.i18nText('Calculating') + "...."
            };
            FR.showLoadingDialog(o);
            if (submitButton) {
                submitButton.disable();
            }
            this.stopEditing();

            // jsonpajaxݵĿ
//            if (this.currentSessionID) {
//                // ʼʱcurrentSessionID
//                // ύʱ򵽺̨˸id Ͳü
//                // aύĵõsessionidһʱϿ˾ͻ
//                this.importReportData(isAllSheet, submitButton, successFn);
//            } else {
                this.registerReportSession({fn: function() {
                    self.importReportData(isAllSheet, submitButton, successFn);
                }, errorFn: function() {
                    FR.hideLoadingDialog();
                    submitButton && submitButton.enable();
                    FR.Msg.alert(FR.i18nText("Failed"), FR.i18nText('Offline-Connect_Failed'));
                }, submitButton: submitButton});
//            }

        },

        /**
         * עģsession ȡsessionID ִӦ
         * options.fnȷص
         * options.errorFnص
         * @param options
         */
        registerReportSession: function(options) {
            if (!options) {
                return;
            }
            var self = this;
            var success = false;
            var defaultError = function() {
                FR.hideLoadingDialog();
                FR.Msg.alert(FR.i18nText("Failed"), FR.i18nText('Offline-Connect_Failed'));
                options.submitButton &&  options.submitButton.enable();
            };
            FR.ajax({
                url: FR.requestURL,
                type: 'GET',
                async: false,
                dataType : "jsonp",
                jsonp: "callbackparam",
                jsonpCallback:"success_jsonpCallback",
                data: {
                    op: "write",
                    reportlet: self.reportlet,
                    isWriteOfflinePage: true
                },
                success: function(res) {
                    success = true;
                    if (res && res.sessionID) {
                        self.currentSessionID = res.sessionID;
                        if (options.fn) {
                            options.fn();
                        }
                    }
                },
                error: function(res) {
                    if (options.errorFn) {
                        options.errorFn();
                    } else {
                        defaultError();
                    }
                }
            });
            // jsonpͬ
            // ֪Ϊʲô޷ϵʱsuccesserrorִˣcompleteҲִ
            setTimeout(function() {
                if (!success) {
                    defaultError();
                }
            }, 3000);
        },

        /**
         * ȷ
         */
        importReportData: function(isAllSheet, submitButton, successFn) {
            var self = this;
            var config = [];
            for (var i=0; i<this.lgps.length; i++) {
                var cc = {};
                var lg = this.lgps[i];
                $.each(["resultCells", "colArray", "rowArray"], function(idx, item) {
                    cc[item] = lg[item];
                });
                cc["insertRowArr"] = lg.oriInsRowArr.concat(lg.insertRowArr);
                config.push(cc);
            }
            var params = {
                op: "fr_off_write",
                cmd: "write_offline_import",
                config: FR.jsonEncode(config)
            };

            doSave.call(this, {params: params, fn: function (res) {
                // ɺУ
                if (res && res["status"] != "success") {
                    FR.Msg.toast(res["status"]);
                    return false;
                }
                if (self.fireEvent(FR.Events.BVW, self) === false) {
                    return false;
                }
                self.preventNoVerifier = true;
                var verify = function () {
                    self._doVerify(
                        self.writeReport.createDelegate(self, [(isAllSheet ? null : self.selectedIndex),
                            submitButton ? submitButton : null, successFn]),
                        function (resultJSON) {
                            self.popup_error(resultJSON, submitButton);
                            submitButton && submitButton.enable();
                        },
                        isAllSheet ? null : self.selectedIndex, (submitButton ? submitButton : undefined));
                };
                setTimeout(verify, 10);
            }, errorFn: function() {
                FR.Msg.toast("error on import data");
                submitButton && submitButton.enable();
                FR.hideLoadingDialog();
            }});
        },


        // TODO ӵļ
        /**
         * shoc ߵwebټ
         * @param sheetIdx
         * @param location
         * @param cellValue
         */
        writeDirtyAndRemoteCal: function (sheetIdx, location, cellValue) {
            if (location == null) {
                return;
            }

            var self = this;

            var obj, cr, idx, oriCE, ceArr = {};
            // ǰȰصĸӵcalculatedλ
            // ռлڴ˸ӵĸ
            collectDeps(sheetIdx, location);

            function collectDeps(sheetIdx, location) {
                var depsArr = self.lgps[sheetIdx].whoDependOn[location];
                if (depsArr == null || !$.isArray(depsArr)) {
                    return;
                }
                for (var i=0; i<depsArr.length; i++) {
                    obj = depsArr[i].split('-');
                    cr = obj[0];
                    idx = obj[1];
                    oriCE = self.lgps[idx].getCEFrom(cr);
                    if (!ceArr[cr]) {
                        ceArr[cr] = {
                            ce_from: oriCE,
                            calculated: false,
                            idx: idx
                        };
                        collectDeps(idx, cr);
                    }
                }
            }

            try {
                for (cr in ceArr) {
                    this.calculateCertainCell(sheetIdx, ceArr, cr);
                }
            } catch(e) {

            } finally {
                for (cr in ceArr) {
                    delete ceArr[cr].calculated;
                    delete ceArr[cr].isCalculating;
                }
            }
        },

        calculateCertainCell: function(sheetIdx, ceArr, cr) {
            var self = this;
            var ce = ceArr[cr];

            if (ce == null) {
                return;
            }
            if (ce.calculated) {
                return;
            }
            if (ce.isCalculating) {
                FR.Msg.toast("Death Circle At " + cr);
                return;
            }
            ce.isCalculating = true;

            var oriCE = ce.ce_from;
            var sheetIndex = ce.idx == null ? sheetIdx : ce.idx;
            var curSheet = self.lgps[sheetIndex];
            var columnRow = FR.cellStr2ColumnRow(cr);
            var oriColumnRow = FR.cellStr2ColumnRow(oriCE.cr);

            var formula = oriCE.formula;
            // Ҫؼûؼĸ ôȼ
            var relatedCRs = FR.WE.getRelatedColumnRow(formula);
            for (var j=0; j<relatedCRs.length; j++) {
                // aطӦñָչǰ
                var relateCE = self.lgps[sheetIndex].getCE(relatedCRs[j]);
                if (relateCE == null || ceArr[relatedCRs[j]] == null) {
                    continue;
                } else if (relateCE.calculated === false) {
                    self.calculateCertainCell(sheetIdx, ceArr, relatedCRs[j]);
                }
            }
            // Ϳʼ
            var cellsForCal = curSheet.collectRelatedCellValues(columnRow, relatedCRs);

            var calConfig = {
                lgp: curSheet,
                relatedCells: cellsForCal,
                currentCell: columnRow,
                parameters: $.extend({}, self.parameters, {
                    $$$: curSheet.getCellValue(columnRow.col, columnRow.row)
                })
            };
            var result = new FR.CAL(calConfig).eval(formula);
            // ǲֵ֧ĹʽҪرԴ
            if (result == FR.WE.ERROR_NOT_SUPPORT) {
                self.setCellValueWithoutHistory(sheetIndex, columnRow.col, columnRow.row, "");
                var cell = this.lgps[sheetIndex]._get$TDCell(columnRow.col, columnRow.row);
                this.lgps[sheetIndex].makeNotSupportError(cell);
            } else {
                // ֵĸıҲҪ¼ fireCellValueChangeне
                // writePanesetCellValueŻᴥfireCellValueChange
                self.setCellValueWithoutHistory(sheetIndex, columnRow.col, columnRow.row, result);
            }

            ce.calculated = true;
            delete ce.isCalculating;
        },

        /**
         * Ĺ
         * øֵ ֵı¼ Ӽ ֵ
         * ǲʷ Ϊһβܻᴥֵ ֻҪһʷ
         * @param o
         */
        setCellValueWithoutHistory: function (o) {
            var config = {};
            if (arguments.length === 3) {
                config.columnIndex = arguments[0];
                config.rowIndex = arguments[1];
                config.value = arguments[2];
                config.reportIndex = this.selectedIndex;
            } else if (arguments.length === 4) {
                config.reportIndex = arguments[0];
                config.columnIndex = arguments[1];
                config.rowIndex = arguments[2];
                config.value = arguments[3];
            } else {
                config = o;
            }
            var lp = this.lgps[config.reportIndex];
            if (lp) {
                if (lp.loaded === false) {
                    lp.loadLGPPane(false);
                }
                lp.setCellValue(config.columnIndex, config.rowIndex, config.value);
                lp.fireCellValueChange(lp.getTDCell(config.columnIndex, config.rowIndex), config.value, null, false);
            }
        },

        reCalCurLGPPane: function() {
            if (this.lgps == null || this.curLGP == null) {
                return;
            }
            this.curLGP.recalculate();
        },

        refreshAllSheets: function() {
            if (this.lgps == null) {
                return;
            }
            for (var i=0; i<this.lgps.length; i++) {
                this.lgps[i].recalculate();
            }
        },

        writeReport: function (reportIndex, submitButton, successFn) {
            if (this.fireEvent(FR.Events.BW, this) === false) {
                return false;
            }
            var self = this;
            var params = {op: "fr_off_write", cmd: "write_offline_submit"};
            if (reportIndex != null) {
                params = $.extend(params, {reportIndex: reportIndex})
            }
            doSave.call(this, {params: params, fn: function (res) {
                var submitInfo = {};
                var json_array = res;
                if (json_array.length > 0) {
                    $.each(json_array, function (idx, item) {
                        if (item.fr_submitinfo) {
                            submitInfo = item.fr_submitinfo;
                        }
                    });
                }
                if (submitButton) {
                    // bug26782
                    setTimeout(function () {
                        submitButton.enable();
                    }, 10);
                }
                if (self.fireEvent(FR.Events.AVW, self, submitInfo) === false) {
                    return;
                }
                if (self.fireEvent(FR.Events.AW, submitInfo) === false) {
                    return;
                }
                var success = submitInfo.success;
                if (success !== true && success !== false) {
                    if (!self.preventNoWriter) {
                        // carl:ʾûãʾû
                        FR.Msg.toast(FR.i18nText("Report") + FR.i18nText("Report-Write_Attributes_Msg"));
                    } else {
                        successFn && successFn();
                        delete self.preventNoWriter;
                    }
                } else if (success === true) {
                    FR.Msg.toast(FR.i18nText("Successfully"));
                    self.fireEvent(FR.Events.WS);
                    successFn && successFn();
                } else if (success === false) {
                    FR.Msg.toast(FR.i18nText("Failed"));
                    self.fireEvent(FR.Events.WF);
                }
            }});
        },
        /*
         * fnǱ֮callback
         */
        saveReport: function (fn) {
//            doSave.call(this, {fn: fn || function (res) {
//                FR.Msg.toast(res.responseText);
//            }})
        },


        // TODO У
        /**
         * ߵУ
         */
        verifyReport: function () {
            var verifyButton = this.verifyButton = arguments[0];
            var successFn = function() {
                FR.Msg.toast(FR.i18nText('Verify-Verify_Success'));
                verifyButton && verifyButton.enable();
            }
            var self = this;
            var failFn = function(resultJSON) {
                 self.popup_error(resultJSON, verifyButton)
                 verifyButton && verifyButton.enable();
            }
            // У鰴ťִеverifyReport
            // _doVerifyҪύʱеУ

            this.stopEditing();
            this.remove_error();

            var resultJSON = [];
            this.validateWidgets(resultJSON, true);

            // ȱУ򿴿ûвֵ֧Ĺʽ ԶУ
            var notSupport = false;
            sdf: for (var idx=0; idx<this.lgps.length; idx++) {
                if (this.lgps[idx].verify) {
                    for (var i=0; i<this.lgps[idx].verify.length; i++) {
                        var curVerify = this.lgps[idx].verify[i];
                        if (curVerify.UNSUPPORT) {
                            notSupport = true;
                            break sdf;
                        }
                        var formula = curVerify.formula;
                        var fns = FR.WE.getFunctionNames(formula);
                        for (var ii=0; ii<fns.length; ii++) {
                            if (FR.FUN[fns[ii].toUpperCase()] == null) {
                                notSupport = true;
                                break sdf;
                            }
                        }
                    }
                }
            }
            if (notSupport) {
                FR.Msg.alert(FR.i18nText('Tooltips'), FR.i18nText('Offline-Verify_ToolTips'), function(result) {
                    if (result) {
                        verify();
                    }
                })
            } else {
                verify();
            }

            function verify() {
                for (var idx=0; idx<self.lgps.length; idx++) {
                    if (self.lgps[idx].verify) {
                        for (var i=0; i<self.lgps[idx].verify.length; i++) {
                            var curVerify = self.lgps[idx].verify[i];
                            if (curVerify.UNSUPPORT) {
                                continue;
                            }
                            var formula = curVerify.formula;
                            var relatedCRs = FR.WE.getRelatedColumnRow(formula);
                            var valueGroup = self.lgps[idx].getCellValueGroup(relatedCRs);
                            for (var j=0; j<valueGroup.length; j++) {
                                var baseCells = {};
                                for (var k=0; k<relatedCRs.length; k++) {
                                    baseCells[relatedCRs[k]] = valueGroup[j][k];
                                }
                                var config = {
                                    relatedCells: baseCells,
                                    parameters: self.parameters
                                }
                                var checkResult = new FR.CAL(config).eval(formula);
                                // Ϊfalse  ҪpushϢresultJSON
                                if (checkResult === false) {
                                    var currentCRs = [];
                                    for (k=0; k<relatedCRs.length; k++) {
                                        currentCRs.push(self.lgps[idx].getExpandColumnRowStr(relatedCRs[k], j));
                                    }
                                    var error = {
                                        columnrows: currentCRs,
                                        message: curVerify.message,
                                        reportIndex: idx
                                    }
                                    resultJSON.push(error);
                                }
                            }
                        }
                    }
                }
                if (resultJSON.length > 0) {
                    failFn(resultJSON);
                } else {
                    successFn();
                }
            }
        },

        /**
         * ںͷʱõУ
         */
        _doVerify: function (successFn, failureFn, reportIndex) {//˽з
            // Ҫstop editing
            this.stopEditing();
            // shoc:verifyǰƳȫ  bug28182
            this.remove_error(reportIndex);

            var resultJSON = [];

            var self = this;
            var params = {op: "fr_off_write", cmd: "write_offline_verify"};
            // richer:ǷҪWidgetinvalidate()У飿
            // jamesУǲвΪգûcvֵĸ
            if (reportIndex != null) {
                this.validateWidgets(resultJSON);
                params = $.extend(params, {reportIndex: reportIndex});
            } else {
                this.validateWidgets(resultJSON, true);
            }

            doSave.call(this, {params: params, fn: function (res) {
                var verifyInfo = {};
                var json_array = res;
                if (json_array.length > 0) {
                    $.each(json_array, function (idx, item) {
                        // pushreportIndexȫǵǰsheet  ں̨
                        //item.reportIndex = self.curLGP.idx;
                        if (item.fr_verifyinfo) {
                            verifyInfo = item.fr_verifyinfo;
                        } else {
                            resultJSON.push(item);
                        }
                    });
                }

                if (self.fireEvent(FR.Events.AV, verifyInfo) === false) {
                    if (self.verifyButton) {
                        self.verifyButton.enable();
                    }
                    return;
                }
                if (resultJSON.length > 0) {
                    $.isFunction(failureFn) && failureFn(resultJSON);
                } else {
                    if (verifyInfo.success === true || self.preventNoVerifier === true) {
                        $('div.verify-error-container', FR.$view_container).remove();
                        $('div.verify-error-number').remove();
                        $.isFunction(successFn) && successFn();
                    } else {
                        // ûУ  ҲԶ
                        // ʱУ鲻ʾ ֻеУʾ
                        FR.Msg.toast(verifyInfo.info);
                        self.verifyButton && self.verifyButton.enable();
                    }
                }
                delete self.preventNoVerifier;
            }});
        },

        // 
        clear: function() {
            this._dealOperate(arguments[0], 0);
        },

        // 
        undo: function() {
            this._dealOperate(arguments[0], 1);
        },

        // 
        redo: function() {
            this._dealOperate(arguments[0], 2);
        },

        _dealOperate: function(btn, t) {
            btn && btn.disable();
            try {
                if (t === 0) {
                    FR.WE.localData.clearLocalData();
                } else if (t === 1) {
                    FR.WE.localData.undo();
                } else if (t === 2) {
                    FR.WE.localData.redo();
                }
                this.curLGP.refreshDataOnInit();
                this.curLGP.refreshDataByLocal();
                this.reloadCurLGPPane();
            } catch(e) {

            } finally {
                btn && btn.enable();
            }
            this._checkBtnState();
        },

        _checkBtnState: function() {
            this.undoBtn && this.undoBtn.setEnable(FR.WE.localData.hasBeforeHistory());
            this.redoBtn && this.redoBtn.setEnable(FR.WE.localData.hasAfterHistory());
        },

        addHistory: function() {
            FR.WE.localData.addHistory();
            this._checkBtnState();
        },

        offlineSave: function(options) {
            var self = this;
            if (this.currentSessionID) {
                doSave.call(this, options, false);
            } else {
                this.registerReportSession({
                    fn: function() {
                        doSave.call(self, options, false);
                    }
                });
            }

        }

    }


    /*
     * TODO shoc ߵ ťɾ
     */
    $.each(['append', 'delete', 'undelete'], function (idx, it) {
        /*
         * appendReportRow appendReportColumn deleteReportRow deleteReportColumn
         */
        P[it + 'ReportRow'] = function () {
            if (this.fireEvent('before' + it) === false) {
                return;
            }

            this.stopEditing();
            // ǰע¼
            this.curLGP.unfocus();

            var location = FR.id2Location(arguments[0]);
            if (location == null) {
                return;
            }

            var btnCRStr = FR.columnRow2CellStr(location);
            var btnTD = $(this.curLGP.getTDCell(location.col, location.row));
            var fixCount = parseInt(btnTD.attr('fixCount')); // 
            var fixCR = this.curLGP.getFixCR(location);
            var fixTd = $(this.curLGP.getTDCell(fixCR.col, fixCR.row));
            var fixSpan = parseInt(fixTd.attr('rowspan')) || 1;

            if (it == 'append') {
                var tmpCells = {};
                this.curLGP.appendRowOnStructure(false, fixCR, fixCount, tmpCells);
                this.curLGP.appendRowOnData(false, fixCR, fixCount, fixSpan, btnCRStr, tmpCells);
            } else {
                this.curLGP.deleteRowOnStructure(false, fixCR);
                this.curLGP.deleteRowOnData(false, fixCR, btnCRStr);
            }

            this.curLGP.recalculate();

            this.addHistory();

            this.fireEvent('after' + it);
        }
    });


    $.each(['append', 'delete'], function (idx, it) {
        /*
         * appendReportRC deleteReportRC
         */
        P[it + 'ReportRC'] = function () {
            // arguments: count(append)1
            if (this.fireEvent('before' + it) === false) {
                return;
            }
            this.stopEditing();

            var count = arguments[0] || 1;
            // Ŀ
            var targetCells = arguments[1];
            if (!targetCells) {
                targetCells = $(this.curLGP.currentTDCell).attr("id");
            }
            if ($.isArray(targetCells)) {

            } else {
                var fixCR = targetCells ? FR.id2Location(targetCells) : null;
                if (fixCR == null) {
                    FR.Msg.toast(FR.i18nText('Invalid_Cell'));
                    return;
                }
                // ¼ ǷǺϲӶֻһвtd
                // ͬڰť ¼copyǽڿһtr
                var locStr = FR.columnRow2CellStr(fixCR);
                var fixTd = $(this.curLGP.getTDCell(fixCR.col, fixCR.row));
                var fixSpan = parseInt(fixTd.attr('rowspan')) || 1;

                if (it == 'append') {
                    var tmpCells = {};
                    this.curLGP.appendRowOnStructure(true, fixCR, count, tmpCells);
                    this.curLGP.appendRowOnData(true, fixCR, count, fixSpan, locStr, tmpCells);
                } else {
                    this.curLGP.deleteRowOnStructure(true, fixCR);
                    this.curLGP.deleteRowOnData(true, fixCR, locStr);
                }
            }

            this.curLGP.recalculate();

            this.addHistory();

            this.fireEvent('after' + it);
        }
    });



    /**
     * jsonpȡsessionõ
     *
     * jsonpֻgetʽύ getг
     * ͬԴiframeʽĻͬ Ҳ
     *
     * @param options
     * @param sendXML
     */
    function doSave(options, sendXML) {
        this.stopEditing();
        var self = this;

        // jsonpʽ
//        FR.ajax({
//            url: FR.requestURL,
//            type: 'GET',
//            async: false,
//            dataType : "jsonp",
//            jsonp: "callbackparam",
//            jsonpCallback:"success_jsonpCallback",
//            data: $.extend({
//                op: "fr_write",
//                cmd: "save_w_content",
//                sessionID: this.currentSessionID,
//                reportXML: this.generateReportXML(true),
//                cutPage: this.options.cutpage
//            }, options.params),
//            success: (options.fn || FR.emptyFn).createSequence(FR.hideLoadingDialog)
//        });


        // iframeʽ
//        $('#fr_proxy').remove();
//        var $p = $('<iframe src="" id="fr_proxy" style="display:none;" onload="loadData()"/>');
//        $p.attr('src', this.requestURL + '?reportlet=' + this.reportlet + '&isOfflineProxyPage=true');
//        $p.appendTo($('body'));
//        document.domain = "xxx.com";
//        function loadData() {
//            $p[0].contentWindow.FR.ajax({
//                type: "POST",
//                url: FR.requestURL,
//                data:$.extend({
//                    op: "fr_write",
//                    cmd: "save_w_content",
//                    sessionID: this.currentSessionID,
//                    reportXML: this.generateReportXML(true),
//                    cutPage: this.options.cutpage
//                }, options.params),
//                async: false,
//                dataType: 'json',
//                success: (options.fn || FR.emptyFn).createSequence(FR.hideLoadingDialog)
//            });
//        }


        // и
        var limit = 200 - FR.requestURL.length;
        var data = $.extend({
            op: "fr_off_write",
            cmd: "save_w_content",
            sessionID: this.currentSessionID,
            cutPage: this.options.cutpage
        }, options.params);
        if (sendXML !== false) {
            data.reportXML = this.generateReportXML(true);
            data.parameters = getParameters();
        }
        data = FR.cjkEncodeDO(data);
        var data_bak = $.extend({}, data);
        delete data_bak.sessionID;
        delete data_bak.op;
        delete data_bak.cmd;
        var str = FR.jsonEncode(data_bak);

        var count = Math.ceil(str.length / limit);
        var idx = 0;
        sendData();

        function sendData() {
            var sub = str.substring(idx * limit, (idx + 1) * limit);
            var fun = FR.emptyFn;
            var dData = {
                sessionID: self.currentSessionID,
                op: data.op,
                cmd: data.cmd,
                dataClip: sub
            };

            if (idx === count - 1) {
                dData.f_end = 1;
                fun = (options.fn || FR.emptyFn).createSequence(FR.hideLoadingDialog);
            }

            FR.ajax({
                url: FR.requestURL,
                type: 'GET',
                async: false,
                dataType : "jsonp",
                jsonp: "callbackparam",
                jsonpCallback:"success_jsonpCallback",
                data: dData,
                success: function(res) {
                    fun(res);
                    if (idx < count - 1) {
                        idx ++;
                        sendData();
                    }
                },
                error: function(res) {
                    if (options.errorFn) {
                        options.errorFn();
                    } else {
                        FR.Msg.toast("error");
                        FR.hideLoadingDialog();
                    }
                }
            });
        }

        function getParameters() {
            var paras = {};
            var skip = [
                "OP", "CMD", "REPORTLET", "REPORTNAME", "SESSIONID", "__LOCALE__"
            ];
            for (var pname in contentPane.parameters) {
                if ($.inArray(pname, skip) === -1) {
                    paras[pname] = contentPane.parameters[pname];
                }
            }
            return paras;
        }
    }

    return P;
}());




$.extend(FR.WLGP.prototype, function () {

    return {

        /**
         * ҪЩϢʵߵУ顢wedټ
         * Ҫ¼صĶ rowArray,deletedRowArr,insertRowArr(вɾв)
         *                      resultCells ¼ı
         */
        // column row չϢ [0,1,1,1,2,2]
        colArray : null,
        rowArray : null,
        //     ---
        // ͣ0-ť  1-ťɾ   3-¼   4-ɾ¼
        oriInsRowArr: null,
        insertRowArr: null,
        // dependence
        dependOnWho : null,
        whoDependOn : null,
        // cells չǰ  ֵ ʽ Ӹ ʾֵ в ؼ ̬
        baseCells : null,
        // չ ĸֵ ֻ¼ֵ "A1":"1234"  ʱı
        resultCells : null,



        gotoPage: function (page, async) {
            // TODO
            // ûload ݶѾɺ
            //this.$container.__load__({
            // ɵʱĳʼhtml
            this.$container.html(FR.WE.getHtml(this.idx));

            this.initLGPComponent();

            this.writePane.curLGP = this;
            // alex:this.$containerΪǰformPane.ContentContainer
            this.writePane.$currentContentContainer = this.$container;
            this.writePane.isLoadingPage = -1;
            delete this.loaded;

            //fire formPaneafterload¼,thisΪȥ
            this.writePane.fireEvent(FR.Events.AFTERLOAD, this);

            /*
             * alex:Ӧafterload֮ѡеԪ
             * Ϊͻܻafterload¼Ӽ,cellselectʱҪЩ
             */

            //¼غ󣬻ԭȵĺõ㣬򲻽˷Ѳ׳
            this.currentTDCell = null;
            this.editorEl = null;
            this.cellEditing = null;
            this._selectFirstTD();

            if (FR.isMobileApp() && !FR.isMobileAppNoZoom()) {
                $(".sheet-container", this.$container).css({
                    width:$(".sheet-container", this.$container).children().width(),
                    height:$(".x-table", this.$container).height()
                });

                //new iScroll(this.$container[0]);
                var contentContainer = $('.content-container');
                contentContainer.css('position', 'relative');

                var $sheetContainer = $(".sheet-container", this.$container);
                contentContainer.width($sheetContainer.width());
                contentContainer.height($sheetContainer.height());
                contentContainer.css('overflow', 'hidden');
            } else if (FR.isMobileBrowser() && !FR.isMobileBrowserNoZoom()) {
                FR.MobileTools.largeWidth($('.x-table', this.$container).width());
            }

            // ݱش洢ݸ
            this.populateByLocalData();

        },

        populateByLocalData: function() {
            // ɾ
            // ĬϾǰ˳
            // "---"
            for (var i=0; i<this.insertRowArr.length; i++) {
                var arr = this.insertRowArr[i].split('-');
                var type = parseInt(arr[3]);
                var isSimple = type >= 2;
                var isAppend = type % 2 === 0;
                var pos = arr[2];
                var posCR = FR.cellStr2ColumnRow(pos);
                var fixCR = isSimple ? posCR : this.getFixCR(posCR);
                var count = parseInt(arr[1]);
                if (isAppend) {
                    this.appendRowOnStructure(isSimple, fixCR, count, {});
                } else {
                    this.deleteRowOnStructure(isSimple, fixCR);
                    this.deletedRows.push(fixCR.row);
                }
            }

            // ֵ
            var cells = this.resultCells;
            for (var cr in cells) {
                if (typeof cr == 'string' && cr.match(/[A-Z]+[0-9]+/)) {
                    var columnRow = FR.cellStr2ColumnRow(cr);
                    var value = "";
                    if (typeof cells[cr] == 'string' || typeof cells[cr] == 'number') {
                        value = cells[cr];
                    } else if (cells[cr].value) {
                        value = cells[cr].value;
                    }
                    if (this.getCellValue(columnRow.col, columnRow.row) != value) {
                        this.setCellValue(columnRow.col, columnRow.row, value);
                    }
                }
            }
        },

        makeNotSupportError: function($errorCell) {
            var $errorImgHolder = $(".fx", $errorCell).length === 0 ? $errorCell : $("td", $(".fx", $errorCell));
            $('.verify-error-img', $errorCell).remove();
            if ($('.formula-error-img', $errorCell).length === 0) {
                $('<img border="0"/>').addClass('verify-error-img')
                    .appendTo($errorImgHolder).attr('title', FR.i18nText('Offline-Contain_Unsupport_Function'))
                    .attr('src', FR.servletURL + '?op=resource&resource=/com/fr/web/images/warning2.png');
            }
        },

        refreshDataOnInit: function() {
            var config = FR.WE.getSheetConfig(this.idx) || {};
            var cons = FR.WE.constant;
            this.colArray = config[cons.COL_ARRAY] || [];
            this.rowArray = config[cons.ROW_ARRAY] || [];
            this.oriInsRowArr = config[cons.ORI_INS_ROW_ARRAY] || [];
            this.deletedRows = config[cons.DELETED_ROWS] || [];
            this.insertRowArr = [];
            this.dependOnWho = config["dependOnWho"] || {};
            this.whoDependOn = config["whoDependOn"] || {};
            this.baseCells = config["baseCells"]     || {};
            this.resultCells = config["resultCells"] || {};
            this.verify = config["verify"]           || [];
        },

        refreshDataByLocal: function() {
            var data = FR.WE.localData.getSheetData(this.idx) || {};
            var localCon = FR.WE.localData.constant;
            if (data[localCon.COL_ARRAY]) {
                this.colArray = data[localCon.COL_ARRAY];
            }
            if (data[localCon.ROW_ARRAY]) {
                this.rowArray = data[localCon.ROW_ARRAY];
            }
            if (data[localCon.INS_ROW_ARRAY]) {
                this.insertRowArr = data[localCon.INS_ROW_ARRAY];
            }
            this.resultCells = $.extend(this.resultCells, data[localCon.RESULT_CELLS]);

            // ʼɾв
            if (data[localCon.ROW_OPERATE_COUNTER]) {
                this.rowOperateCounter = data[localCon.ROW_OPERATE_COUNTER];
            } else {
                this.rowOperateCounter = this.insertRowArr.length;
                FR.WE.storeRowOperateCounter(this.insertRowArr.length, this.idx);
            }
        },

        getWriteShortCuts: function () {
            return FR.WE.config.writeShortCuts;
        },

        /*
         * Ԫֵı
         */
        fireCellValueChange: function (tdCell, cv, fm, addHistory) {

            if (tdCell == null) {
                return;
            }

            var $tdCell = $(tdCell);
            FR.setCellValue($tdCell, cv);

            var cal = false;
            if (fm == null) {
                if ($tdCell.attr('fm') != null) {
                    cal = true;
                }
                $tdCell.removeAttr("fm");
            } else {
                $tdCell.attr('fm', fm);
                cal = true;
            }
            $(tdCell).addClass('dirty');

            // ֵı Ҫ¼
            var cr = FR.id2ColumnRow($tdCell.attr("id"));
            this.resultCells[FR.columnRow2CellStr(cr)] = cv;
            FR.WE.storeResultCells(this.resultCells, this.idx);

            this.dirtyCell.push(tdCell);
            if (cal || $tdCell.attr("frs") != null) {
                this.writePane.writeDirtyAndRemoteCal(this.idx, FR.id2ColumnRowStr($tdCell.attr("id")), cv, fm);
            }
            // richer:֪ͨԪı,
            this.fireEvent(FR.Events.CELLVALUECHANGE, $(tdCell), cv);

            if (addHistory !== false) {
                this.writePane.addHistory();
            }
        },

        /*
         * ̬
         */
        present: function ($tdCell, cv) {
            var cr = FR.id2ColumnRow($tdCell.attr('id'));
            var oriCE = this.getCEFrom(cr);
            var formula = oriCE.presentFormula;
            var relatedCRs = FR.WE.getRelatedColumnRow(formula);
            var cellsForCal = this.collectRelatedCellValues(cr, relatedCRs);

            var calConfig = {
                lgp: this,
                relatedCells: cellsForCal,
                parameters: $.extend({}, self.parameters, {
                    $$$: cv
                })
            }
            var result = new FR.CAL(calConfig).eval(formula);

            return result;
        },

        collectRelatedCellValues: function(cr, relatedCRs) {
            var oriCE = this.getCEFrom(cr);
            var oriCr = FR.cellStr2ColumnRow(oriCE.cr);
            var row_offset = this.getRowOffset(cr, oriCr);
            var col_offset = cr.col - this.colArray.indexOf(oriCr.col);

            var cellsForCal = {};
            for (var i=0; i<relatedCRs.length; i++) {
                var relatedValues = this.getExpandCellValues(relatedCRs[i]);
                // ǹȡӦεֵ
                if (this.isInCalLayer(oriCE, relatedCRs[i])) {
                    cellsForCal[relatedCRs[i]] = relatedValues[row_offset][col_offset];
                }
                // ûиӹϵ ȡֵ
                else {
                    if (relatedValues[0].length === 1) {
                        cellsForCal[relatedCRs[i]] = $.map(relatedValues, function(rv) {
                             return rv[0];
                        });
                    } else if (relatedValues.length === 1) {
                        cellsForCal[relatedCRs[i]] = relatedValues[0];
                    } else {
                        cellsForCal[relatedCRs[i]] = relatedValues;
                    }
                }
            }
            return cellsForCal;
        },

        /**
         * ؼ
         * ¼ʽ
         * ڲɾ
         * ܼи ԭʽ=range(2)˲
         * ͨؼ޸˸ֵ ؼʱñ
         */
        recalculate: function() {
            // ӵĸӶҳ
            var ceArr = {};
            for (var cell in this.dependOnWho) {
                if (!ceArr[cell]) {
                    ceArr[cell] = {
                        ce_from: this.getCEFrom(cell),
                        calculated: false,
                        idx: this.idx
                    };
                }
            }
            try {
                for (var cr in ceArr) {
                    this.writePane.calculateCertainCell(this.idx, ceArr, cr);
                }
            } catch(e) {

            } finally {
                for (cr in ceArr) {
                    delete ceArr[cr].calculated;
                    delete ceArr[cr].isCalculating;
                }
            }
        },


        appendRowOnStructure: function(isSimple, fixCR, fixCount, tmpCells) {
            var $table = this.$table;
            var colCount = this.table_width;

            var fixTd = $(this.getTDCell(fixCR.col, fixCR.row));
            var fixTr = fixTd.parent();
            var fixId = fixTd.attr('id');       // A1-0-0
            var fixSpan = parseInt(fixTd.attr('rowspan')) || 1;
            var td_suffix = fixId.substring(fixId.indexOf('-'), fixId.length); // tdĺ׺  -0-0

            for (var i=0; i<fixCount; i++) {
                var startIdx = fixCR.row + (i + 1) * fixSpan;
                var $tmpTable = $('<table/>');
                var $tmpTr;
                if (!isSimple) { //ť
                    // һβ뼸ԭʼǷǺϲӾ
                    for (var spanIdx=0; spanIdx<fixSpan; spanIdx++) {
                        // ԭtr
                        var tr = $('#'+FR.getOffsetTRID(fixTr, spanIdx), $table).clone(true);
                        var curRowIdx = parseInt(tr.attr('id').split('-')[1]);
                        FR.changeTRId(tr, (i + 1) * fixSpan);
                        tr.attr('tridx', parseInt(tr.attr('tridx')) + fixSpan);
                        // tdҪòǷǿչ rowspan1
                        // ҲҪid widget editor
                        for (var j=0; j<colCount; j++) {
                            var curCR = {col:j, row: curRowIdx};
                            var curStr = FR.columnRow2CellStr(curCR);
                            var td = $('td#'+curStr+td_suffix, tr);

                            if (j < fixCR.col && (td.length === 0 || parseInt(td.attr('rowspan')) > 1)) {
                                changeUpperTdRowSpan(fixCR, curCR);
                                // ırowspan ôòӦtd
                                td.remove();
                            } else {
                                if (!td || td.length === 0) {
                                    continue;
                                }
                                FR.changeTDId(td, fixSpan);
                                FR.changeTDWidget(td);
                                tmpCells[FR.id2ColumnRowStr(td.attr('id'))] = FR.changeTDValue(curCR, td);
                            }
                        }
                        tr.appendTo($tmpTable);
                    }
                }
                else {  //Ӽ¼
                    var tr = $('#'+FR.getOffsetTRID(fixTr, fixSpan-1), $table).clone(true);
                    var curRowIdx = parseInt(tr.attr('id').split('-')[1]);
                    FR.changeTRId(tr, 1);
                    tr.attr('tridx', parseInt(tr.attr('tridx')) + 1);
                    for (var j=0; j<colCount; j++) {
                        var curCR = {col:j, row: curRowIdx};
                        var curStr = FR.columnRow2CellStr(curCR);
                        var td = $('td#'+curStr+td_suffix, tr);
                        if (j < fixCR.col && (td.length === 0 || parseInt(td.attr('rowspan')) > 1)) {
                            changeUpperTdRowSpan(fixCR, curCR);
                            td.remove();
                        } else {
                            if (!td || td.length === 0) {
                                continue;
                            }
                            FR.changeTDId(td, parseInt(td.attr('rowspan') || 1));
                            td.removeAttr('rowspan');
                            FR.changeTDWidget(td);
                            tmpCells[FR.id2ColumnRowStr(td.attr('id'))] = FR.changeTDValue(curCR, td);
                        }
                    }
                    tr.appendTo($tmpTable);
                }
                $tmpTr = $('tr[tridx]', $tmpTable);
                var mergeCells = [];
                this.appendRow(startIdx, $tmpTr, mergeCells);
            }

            function changeUpperTdRowSpan(fixCR, curCR) {
                for (var k=fixCR.row; k>=0; k--) {
                    var curStr = FR.columnRow2CellStr({col: curCR.col, row: k});
                    var newtd = $('td#'+curStr+td_suffix, $table);
                    if (newtd.length > 0) {
                        FR.changeTDRowSpan(newtd, 1);
                        break;
                    }
                }
            }
        },

        deleteRowOnStructure: function(isSimple, fixCR) {
            var $table = this.$table;
            var colCount = this.table_width;

            var fixTd = $(this.getTDCell(fixCR.col, fixCR.row));
            var fixTr = fixTd.parent();
            var fixId = fixTd.attr('id');       // A1-0-0
            var fixSpan = fixTd.attr('rowspan') || 1;
            var td_suffix = fixId.substring(fixId.indexOf('-'), fixId.length); // tdĺ׺  -0-0

            var startIdx = fixCR.row;
            for (var spanIdx=0; spanIdx<fixSpan; spanIdx++) {
                var tr = $('#'+FR.getOffsetTRID(fixTr, spanIdx), $table);
                var curRowIdx = parseInt(tr.attr('id').split('-')[1]);
                // һҲɾ˵
                var nextOffset = 1;
                var nextRowIdx = curRowIdx + nextOffset;
                var nextTr = $('#'+FR.getOffsetTRID(fixTr, spanIdx+nextOffset), $table);
                var trCnt = 0;
                while(nextTr.length > 0 && !nextTr.isVisible()) {
                    trCnt ++;
                    nextTr = $('#'+FR.getOffsetTRID(fixTr, spanIdx+nextOffset+trCnt), $table);
                }
                for (var j=0; j<colCount; j++) {
                    var curCR = {col:j, row: curRowIdx};
                    var curStr = FR.columnRow2CellStr(curCR);
                    var td = $('td#'+curStr+td_suffix, tr);
                    if (j < fixCR.col) {
                        if (td.length === 0) {
                            //trû ǵϲ
                            var found = false;
                            for (var k=fixCR.row; k>=0; k--) {
                                curCR.row = k;
                                curStr = FR.columnRow2CellStr(curCR);
                                td = $('td#'+curStr+td_suffix, $table);
                                if (td.length > 0 && td.attr('rowspan') > 1) {
                                    FR.changeTDRowSpan(td, -1);
                                    found = true;
                                    break;
                                }
                            }
                            if (found) {
                                continue;
                            }
                        }
                    }
                    // صһĳtdrowSpan>1ô
                    // ҪһһrowSpanΪrowSpan-1td
                    if (parseInt(td.attr('rowSpan')) > 1) {
                        var nextTd = td.clone(true);
                        var nextCR = {col:j, row:nextRowIdx};
                        nextTd.attr('id', FR.columnRow2CellStr(nextCR) + td_suffix);
                        nextTd.attr('rowSpan', parseInt(td.attr('rowSpan'))-1);
                        if (j === 0) {
                            nextTr.prepend(nextTd);
                        } else {
                            // һǰһеҲû
                            for (var kk=j-1; kk>=0; kk--) {
                                var pretd = $('td#'+FR.columnRow2CellStr({col:kk, row:nextRowIdx})+td_suffix, tr);
                                if (pretd.length > 0) {
                                    pretd.after(nextTd);
                                    break;
                                }
                            }
                        }
                        td.removeAttr('rowSpan');
                    }
                }
            }
            var mergeCells = [];
            this.deleteRow(startIdx, fixSpan, mergeCells);
        },

        appendRowOnData: function(isSimple, fixCR, fixCount, fixSpan, locStr, tmpCells) {
            var self = this;
            // colArray rowArray
            var startIdx = fixCR.row + fixSpan;
            for (var jj=0; jj<fixCount; jj++) {
                for (var ii=0; ii<fixSpan; ii++) {
                    var oriRow = this.rowArray[fixCR.row + ii];
                    this.rowArray.splice(startIdx + ii, 0, oriRow);
                }
            }
            FR.WE.storeRowArray(this.rowArray, this.idx);


            // deletedRows
            for (var kk=0; kk<this.deletedRows.length; kk++) {
                if (this.deletedRows[kk] > fixCR.row) {
                    this.deletedRows[kk] = this.deletedRows[kk] + 1;
                }
            }


            // resultCells
            var offset = isSimple ? fixCount : fixCount * fixSpan;
            for (var crStr in this.resultCells) {
                var cr = FR.cellStr2ColumnRow(crStr);
                tmpCells[getChangedDepStr(crStr)] = this.resultCells[crStr];
            }
            this.resultCells = tmpCells;
            FR.WE.storeResultCells(tmpCells, this.idx);


            // dependence
            // ¼ӵĸӹϵ
            // ͬʱҪѺĶ޸ĵ
            this.whoDependOn = changeDependence(this.whoDependOn);
            this.dependOnWho = changeDependence(this.dependOnWho);

            for (var i=0; i<fixCount; i++) {
                if (!isSimple) {
                    for (var j=0; j<fixSpan; j++) {
                        addDependence((i+1) * fixSpan + j);
                    }
                } else {
                    addDependence((i+1) * fixSpan);
                }
            }

            function changeDependence(depend) {
                var tmpDependOn = {};
                for (var dCRStr in depend) {
                    var dCR = FR.cellStr2ColumnRow(dCRStr);
                    tmpDependOn[getChangedDepStr(dCRStr)] = getChangedDepArr(depend[dCRStr]);
                }
                return tmpDependOn;
            }

            function getChangedDepArr(arr) {
                var tmpArr = [];
                for (var m=0; m<arr.length; m++) {
                    var recArr = arr[m].split('-');
                    tmpArr.push(getChangedDepStr(recArr[0]) + '-' + recArr[1])
                }
                return tmpArr;
            }

            function getChangedDepStr(crStr) {
                var cr = FR.cellStr2ColumnRow(crStr);
                if (cr.row < fixCR.row + fixSpan) {
                    return crStr;
                } else {
                    return FR.columnRow2CellStr({col:cr.col, row: cr.row+offset});
                }
            }

            function addDependence(rowOffset) {
                var row = fixCR.row + rowOffset;
                for (var k=0; k<self.table_width; k++) {
                    var oriCrStr = FR.columnRow2CellStr({col:k, row: fixCR.row});
                    var newCrStr = FR.columnRow2CellStr({col:k, row: row});
                    addEachDependence(self.whoDependOn, oriCrStr, newCrStr, rowOffset);
                    addEachDependence(self.dependOnWho, oriCrStr, newCrStr, rowOffset);
                }
            }

            function addEachDependence(depend, oriCrStr, newCrStr, rowOffset) {
                if (depend[oriCrStr]) {
                    var depArr = depend[oriCrStr];
                    var newDepArr = [];
                    for (var p=0; p<depArr.length; p++) {
                        var depCRArray = depArr[p].split('-'); // 'A1-0'
                        var depCRStr = depCRArray[0];
                        var sheetIdx = depCRArray[1];
                        var depCR = FR.cellStr2ColumnRow(depCRStr);
                        if (self.isInFamily(oriCrStr, depCRStr) &&
                                    self.rowArray[depCR.row + rowOffset] == self.rowArray[depCR.row]) {
                            var newDepCRStr = FR.columnRow2CellStr({col:depCR.col, row:depCR.row+rowOffset});
                            newDepArr.push(newDepCRStr + "-" + sheetIdx);
                        } else {
                            newDepArr.push(depArr[p]);
                        }
                    }
                    depend[newCrStr] = newDepArr;
                }
            }

            // insertRowArr
            // "--㰴ťԪ-"
            var record = this.rowOperateCounter + "-" + fixCount + "-" + locStr + "-" + (isSimple ? "2" : "0");
            this.insertRowArr.push(record);
            FR.WE.storeInsertRowArr(this.insertRowArr, this.idx);
            this.updateRowOperateCounter();
        },

        deleteRowOnData: function(isSimple, fixCR, locStr) {
            this.deletedRows.push(fixCR.row);
            var record = this.rowOperateCounter + "-" + 1 + "-" + locStr + "-" + (isSimple ? "3" : "1");
            this.insertRowArr.push(record);
            FR.WE.storeInsertRowArr(this.insertRowArr, this.idx);
            this.updateRowOperateCounter();
        },

        updateRowOperateCounter: function() {
            this.rowOperateCounter ++;
            FR.WE.storeRowOperateCounter(this.rowOperateCounter, this.idx);
        },


        // TODO ЩWLGPĶ
        /**
         * shoc չлȡԭʼ
         * cr: "A1"    or   {col:0,row:0}
         */
        getCEFrom: function(cr) {
            if (typeof cr == 'string') {
                cr = FR.cellStr2ColumnRow(cr);
            }
            if (cr == null || cr.col == null || cr.row == null) {
                return null;
            }
            var oriCol = this.colArray[cr.col];
            var oriRow = this.rowArray[cr.row];
            var oriCR = FR.columnRow2CellStr({col:oriCol, row:oriRow});
            return this.baseCells[oriCR];
        },

        getCE: function(cr) {
            if (cr == null) {
                return null;
            }
            if (cr.col != null && cr.row != null) {
                cr = FR.columnRow2CellStr(cr);
            }
            return this.baseCells[cr];
        },

        getCEExpandDir: function(cell) {
            if (cell.direction != FR.WE.constant.DIRECTION_NONE) {
                return cell.direction;
            }
            var left = cell;
            while (left != null) {
                var leftCR = FR.cellStr2ColumnRow(left.cr);
                left = cell.leftDefault ? this.getCE(FR.columnRow2CellStr({col: leftCR.col-1, row: leftCR.row})) : this.getCE(left.left);
                if (left.direction != FR.WE.constant.DIRECTION_NONE) {
                    return left.direction;
                }
            }
            var up = cell;
            while (up != null) {
                var upCR = FR.cellStr2ColumnRow(up.cr);
                up = cell.upDefault ? this.getCE(FR.columnRow2CellStr({col: upCR.col-1, row: upCR.row})) : this.getCE(up.left);
                if (up.direction != FR.WE.constant.DIRECTION_NONE) {
                    return up.direction;
                }
            }
        },

        getFixCR: function(location) {
            var btnTD = $(this.getTDCell(location.col, location.row));
            var fixCell = btnTD.attr('fixCell'); // Ŀ'A1'
            // ƫ̨̫ 
            var offset = location.row - this.rowArray[location.row];
            var fixCR = FR.cellStr2ColumnRow(fixCell);
            fixCR.row += offset;
            return fixCR;
        },

        isInCalLayer: function(tar, related) {
            if (tar == null || related == null) {
                return false;
            }
            if (typeof tar == 'string') {
                tar = this.getCEFrom(tar);
            }
            if (typeof related == 'string') {
                related = this.getCEFrom(related);
            }
            if (!this.isInFamily(related, tar)) {
                return false;
            }
            var tarCR = FR.cellStr2ColumnRow(tar.cr);
            var relCR = FR.cellStr2ColumnRow(related.cr);
            if (this.isDefaultUpAncestor(related, tar)
                && this.getCEExpandDir(related) == FR.WE.constant.DIRECTION_TOP_TO_BOTTOM) {
                return false;
            }
            if (this.isLeftAncestor(related, tar)
                && this.getCEExpandDir(related) == FR.WE.constant.DIRECTION_LEFT_TO_RIGHT) {
                return false;
            }
            return true;
        },

        isInFamily: function(ce1, ce2) {
            if (ce1 == null || ce2 == null) {
                return false;
            }
            var ceA = ce1, ceB = ce2;
            if (typeof ce1 == 'string') {
                ceA = this.getCEFrom(ce1);
            }
            if (typeof ce2 == 'string') {
                ceB = this.getCEFrom(ce2);
            }
            return this.AisAncestorOfB(ceA, ceB) || this.AisAncestorOfB(ceB, ceA);
        },

        /**
         * жcellAǷcellBĸ
         * @param ceA : BaseCells Object
         * @param ceB
         * @return {boolean}
         * @private
         */
        AisAncestorOfB: function(ceA, ceB, types) {
            if (ceA == null || ceB == null) {
                return false;
            }
            var ceBcr = FR.cellStr2ColumnRow(ceB.cr);

            // ͨdefaultһֱôȥ
            // defaultĻ ͬһлͬһ
            // typesռ·
            // defaultľͼӸ"0" ԶӸ"1" default2 Զ3
            if (types == null) {
                types = "";
            }

            var leftB;
            if (ceB.leftDefault && ceA.direction != FR.WE.constant.DIRECTION_LEFT_TO_RIGHT) {
                if (ceBcr.col > 0) {
                    leftB = FR.columnRow2CellStr({col: ceBcr.col-1, row: ceBcr.row});
                }
            } else if (typeof ceB.left == 'string') {
                leftB = ceB.left;
            }
            if (leftB != null
                && (ceA.cr == leftB || this.AisAncestorOfB(ceA, this.getCE(leftB)))
                && rightTypes(true)) {
                return true;
            }

            var upB;
            if (ceB.upDefault && ceA.direction != FR.WE.constant.DIRECTION_TOP_TO_BOTTOM) {
                if (ceBcr.row > 0) {
                    upB = FR.columnRow2CellStr({col: ceBcr.col, row: ceBcr.row-1});
                }
            } else if (typeof ceB.up == 'string') {
                upB = ceB.up;
            }
            if (upB != null
                && (ceA.cr == upB || this.AisAncestorOfB(ceA, this.getCE(upB)))
                && rightTypes(false)) {
                return true;
            }

            function rightTypes(isLeft) {
                if (types.length > types.replace('0', '').length
                    && types.length > types.replace('2', '').length) {
                    return false;
                }
                if (isLeft) {
                    if (types.replace('0', '').length === 0
                        && FR.cellStr2ColumnRow(ceB.cr).row != FR.cellStr2ColumnRow(ceA.cr).row) {
                        return false;
                    }
                } else {
                    if (types.replace('2', '').length === 0
                        && FR.cellStr2ColumnRow(ceB.cr).col != FR.cellStr2ColumnRow(ceA.cr).col) {
                        return false;
                    }
                }
                return true;
            }

            return false;
        },

        ABOfSameAncestor: function(ceA, ceB) {

        },

        isLeftAncestor: function(ceA, ceB) {
            if (ceA == null || ceB == null) {
                return false;
            }
            var leftB;
            if (typeof ceB.left == 'string') {
                leftB = ceB.left;
            }
            return leftB != null && (ceA.cr == leftB || this.isLeftAncestor(ceA, this.getCE(leftB)));
        },

        isDefaultLeftAncestor: function(ceA, ceB) {
            if (ceA == null || ceB == null) {
                return false;
            }
            var ceBcr = FR.cellStr2ColumnRow(ceB.cr);
            var leftB;
            if (ceB.leftDefault && ceA.direction != FR.WE.constant.DIRECTION_LEFT_TO_RIGHT && ceBcr.col > 0) {
                leftB = FR.columnRow2CellStr({col: ceBcr.col-1, row: ceBcr.row});
            }
            return leftB != null && (ceA.cr == leftB || this.isDefaultLeftAncestor(ceA, this.getCE(leftB)));
        },

        isUpAncestor: function(ceA, ceB) {
            if (ceA == null || ceB == null) {
                return false;
            }
            var upB;
            if (typeof ceB.up == 'string') {
                upB = ceB.up;
            }
            return upB != null && (ceA.cr == upB || this.isUpAncestor(ceA, this.getCE(upB)));
        },

        isDefaultUpAncestor: function(ceA, ceB) {
            if (ceA == null || ceB == null) {
                return false;
            }
            var ceBcr = FR.cellStr2ColumnRow(ceB.cr);
            var upB;
            if (ceB.upDefault && ceA.direction != FR.WE.constant.DIRECTION_TOP_TO_BOTTOM && ceBcr.row > 0) {
                upB = FR.columnRow2CellStr({col: ceBcr.col, row: ceBcr.row-1});
            }
            return upB != null && (ceA.cr == upB || this.isDefaultUpAncestor(ceA, this.getCE(upB)));
        },

        /**
         * ԭʼcrչиֵ
         * չ չ ˫չ  Ƕά
         * ÿǱɾӵ
         * @param cr
         */
        getExpandCellValues: function(cr, in1DArr) {
            if (cr == null) {
                return null;
            }
            if (typeof cr == 'string') {
                cr = FR.cellStr2ColumnRow(cr);
            }
            if (cr == null || cr.col == null || cr.row == null) {
                return null;
            }
            var colStart = this.colArray.indexOf(cr.col);
            var colEnd = this.colArray.lastIndexOf(cr.col);
            var rowStart = this.rowArray.indexOf(cr.row);
            var rowEnd = this.rowArray.lastIndexOf(cr.row);
            var values = [];
            for (var row=rowStart; row<=rowEnd; row++) {
                if (this.isDeletedRow(row)) {
                    continue;
                }
                var idx = row - rowStart;
                if (in1DArr === true) {
                    for (var col=colStart; col<=colEnd; col++) {
                        values.push(this.getCellValue(col, row));
                    }
                } else {
                    var t = [];
                    for (var col=colStart; col<=colEnd; col++) {
                        t.push(this.getCellValue(col, row));
                    }
                    values.push(t);
                }
            }
            return values;
        },

        isDeletedRow: function(row) {
            return this.deletedRows.indexOf(row) !== -1;
        },

        /**
         * cr: {col:0, row:0}
         * @param cr
         */
        getExpandValueCount: function(cr) {
            return (this.colArray.lastIndexOf(cr.col) - this.colArray.indexOf(cr.col) + 1)
                * (this.rowArray.lastIndexOf(cr.row) - this.rowArray.indexOf(cr.row) + 1);
        },

        getExpandColCount: function(cr) {
            return this.colArray.lastIndexOf(cr.col) - this.colArray.indexOf(cr.col) + 1;
        },

        getExpandRowCount: function(cr) {
            return this.rowArray.lastIndexOf(cr.row) - this.rowArray.indexOf(cr.row) + 1;
        },

        getRowOffset: function(cr, oriCr) {
            var start = this.rowArray.indexOf(oriCr.row);
            var row_offset = cr.row - start;
            // ÿɾе
            for (var i=0; i<this.deletedRows.length; i++) {
                if (this.deletedRows[i] >= start && this.deletedRows[i] < cr.row) {
                    row_offset --;
                }
            }
            return row_offset;
        },

        getExpandColumnRowStr: function(cr, index) {
            if (typeof cr == 'string') {
                cr = FR.cellStr2ColumnRow(cr);
            }
            if (cr == null || cr.col == null || cr.row == null) {
                return null;
            }
            var colCnt = this.getExpandColCount(cr);
            var rowCnt = this.getExpandRowCount(cr);
            var resultCol = this.colArray.indexOf(cr.col) + (index % colCnt);
            var resultRow = this.rowArray.indexOf(cr.row) + Math.min(parseInt(index / colCnt), rowCnt);
            return FR.columnRow2CellStr({col: resultCol, row: resultRow});
        },

        /**
         * ͨһColumnRow ȡֵУ
         * Ҫע˫չ
         * [[A1ֵ,B1ֵ,C1ֵ]]
         * @param crs
         */
        getCellValueGroup: function(arr) {
            if (arr == null || !$.isArray(arr)) {
                return [];
            }

            var i, crs = [];
            // Ǹ ܸ˼Ҷ!
            for (i=0; i<arr.length; i++) {
                if (typeof arr[i] == 'string') {
                    crs[i] = FR.cellStr2ColumnRow(arr[i]);
                } else {
                    crs[i] = arr[i];
                }
            }
            // Ҫһ׼ ׼ҪչֵҪ
            // չĿͬĻȡ
            var baseCR = crs[0];
            var baseIdx = 0;
            var baseCnt = this.getExpandValueCount(baseCR);
            var cols = this.colArray, rows = this.rowArray;
            var counts = [];
            for (i=1; i<crs.length; i++) {
                var curCnt = counts[i] = this.getExpandValueCount(crs[i]);
                if ((baseCnt < curCnt) ||
                    (baseCnt == curCnt && this.AisAncestorOfB(this.getCE(baseCR), this.getCE(crs[i])))) {
                    baseCR = crs[i];
                    baseIdx = i;
                    baseCnt = curCnt;
                }
            }

            var result = [];
            var container = [];
            for (i=0; i<crs.length; i++) {
                if (i == baseIdx) {
                    container[i] = this.getExpandCellValues(baseCR, true);
                    continue;
                }
                if (counts[i] == baseCnt) {
                    container[i] = this.getExpandCellValues(crs[i], true);
                } else if (counts[i] === 1) {
                    container[i] = FR.WE.makeArray(this.getExpandCellValues(crs[i], true)[0], baseCnt);
                } else {
                    container[i] = this.getExpandCellValues(crs[i], true);
                }
            }
            for (i=0; i<baseCnt; i++) {
                result[i] = [];
                for (var j=0; j<crs.length; j++) {
                    result[i][j] = container[j][i];
                }
            }

            return result;
        }

    }
}())



$.extend(FR, {
    changeTDValue: function(curCR, td) {
        var ce = _g().curLGP.getCEFrom(curCR);
        if (!ce) {
            return;
        }
        var cons = FR.WE.constant;
        var ins = ce[cons.INSERT_POLICY_TAG];
        var value = td.val() || td.text();
        if (ins != cons.INSERT_POLICY_COPY) {
            if (ins == null || ins == cons.INSERT_POLICY_NULL) {
                value = "";
            } else if (ins == cons.INSERT_POLICY_DEFAULT) {
                value = ce[cons.INSERT_POLICY_DEFAULT_VALUE] || '';
            }
            FR.setCellValue(td, value);
            td.text(value);
        }
        return value;
    },

    changeTRId: function(tr, offset) {
        tr.attr('id', this.getOffsetTRID(tr, offset));
    },

    getOffsetTRID: function(tr, offset) {
        var id = tr.attr('id');
        if (!id) {
            return;
        }
        var arr = id.split("-");
        arr[1] = offset + parseInt(arr[1]);
        return arr.join("-");
    },

    changeTDId: function(td, offset) {
        var id = td.attr("id");
        if (!id) {
            return;
        }
        var cr = FR.id2ColumnRow(id);
        cr.row += offset;
        td.attr('id', FR.columnRow2CellStr(cr) + "-" + _g().curLGP.idx + "-" + _g().curLGP.tableID);
    },

    changeTDRowSpan: function(td, offset) {
        var span = parseInt(td.attr('rowspan')) || 1;
        span += parseInt(offset);
        td.attr('rowspan', span);
    },

    changeTDWidget: function(td) {
        var id = td.attr("id");
        if (!id) {
            return;
        }
        var cr = FR.id2ColumnRow(id);
        var widget = td.attr('widget'), editor = td.attr('editor');
        if (widget) {
            td.attr("widget", _g().curLGP._replaceEditorStr(widget, cr));
            td.empty();
        } else if (editor) {
            td.attr('editor', _g().curLGP._replaceEditorStr(editor, cr));
        }
    }

});



if (window.FR == null) {
    window.FR = {};
}
if (FR.WE == null) {
    FR.WE = {};
}
$.extend(FR.WE, {
    /**
     * FR.WE.configĽṹ
     * {
     *      reportlet:
     *      requertURL:
     *      lgps: [
     *           {
     *              baseCells:{}
     *           }
     *      ]
     * }
     * @return
     */
    getConfig: function() {
        return this.config;
    },

    // ⶫֵlgpsᵼobjectű
    // ʱתַŪµobjectֵ
    getConfigStr: function() {
        return FR.jsonEncode(this.config);
    },

    getSheetConfig : function(reportIdx) {
        var config = FR.jsonDecode(this.getConfigStr());
        var lgps = config["lgps"];
        return lgps[reportIdx];
    },

    getHtml: function(reportIdx) {
        var lgps = this.config["lgps"];
        var curConfig = lgps[reportIdx];
        return curConfig["html"];
    },

    getReportName: function() {
        return this.getConfig()["reportlet"];
    },

    /**
     * shoc:д
     * ݽṹ
     * [
     *  sheet1{
     *      cells {}
     *      colArr []
     *      rowArr []
     *      insRow []
     *      delRow []
     *      rowOperateCounter
     *      }
     * ]
     */
    localData: function() {
        var emptyRecord = "[]";
        // ieuserData0ͷ ͳһӸǰ׺
        // '/'
        // ֧
        var reportPath = FR.WE.config["reportlet"];
        reportPath.replace(/\//g, '');
        var name = FR.cjkEncode("fr" + reportPath), ld;
        // historyд洢ĸ0limit ǰǷ curPosΪ0ʾǰ һΪ-1
        var limit = 5, curPos = 0, history = [emptyRecord];
        // һα༭ܴ ʱ
        var lastTime = new Date().getTime();

        // IE8ʹuserData, IE5~IE8,IE9&IE9+֧userData
        // IE9+֧localStorage,ֻеҳ沿ڷϲʹlocalStorage
        var be = document.documentElement;
        var dbName = "frData";
        var isIE = /(msie\s|trident.*rv:)([\w.]+)/.exec(navigator.userAgent.toLowerCase()) != null;
        var version = $.browser.version;
        var isIEWithUserData = isIE && parseInt(version) < 9;
        if (isIEWithUserData) {
            var box = document.body || document.getElementsByTagName("head")[0] || document.documentElement;
            be = document.createElement('input');
            be.type = "hidden";
            be.addBehavior ("#default#userData");
            box.appendChild(be);
        }
        return {
            getLocalData: function() {
                if (ld) {
                    return ld;
                } else {
                    var s;
                    if (isIEWithUserData) {
                        be.load(dbName);
                        s = be.getAttribute(name);
                    } else if (window.localStorage) {
                        s = window.localStorage.getItem(name);
                    } else {
                        FR.Msg.toast("Browser Not Support!");
                    }
                    if (s == null) {
                        ld = [{
                            cells: {}
                        }];
                    } else {
                        ld = FR.jsonDecode(s);
                    }
                    if (!$.isArray(ld)) {
                        var arr = [];
                        arr.push(ld);
                        ld = arr;
                    }
                    for (var i=0; i<FR.WE.config.lgps.length; i++) {
                        if (!ld[i]) {
                            ld[i] = {
                                cells: {}
                            }
                        }
                    }
                    return ld;
                }
            },

            setLocalData: function(data) {
                ld = data;
                var value = FR.jsonEncode(data);
                this.setStrQuietly(value);
            },

            clearLocalData: function() {
                if (isIEWithUserData) {
                    be.load(dbName);
                    be.removeAttribute(name);
                    be.save(dbName);
                } else if (window.localStorage) {
                    window.localStorage.removeItem(name);
                } else {
                    FR.Msg.toast("Browser Not Support!");
                }
                ld = null;
                this.addHistory(emptyRecord);
            },

            undo: function() {
                this.moveHistory(-1);
            },

            redo: function() {
                this.moveHistory(1);
            },

            // setclear
            addHistory: function(value) {
                var str = value == null ? FR.jsonEncode(ld) : value + "";
                if (new Date().getTime() - lastTime > 100
                    && str != history[history.length - 1 + curPos]) {
                    // curPosΪʼ״̬
                    // historyм ݶҪĨ
                    // ǰλΪhistory.length - 1 + curPos Ҫһλʼɾ
                    if (curPos < 0) {
                        history.splice(history.length + curPos, -curPos);
                    } else {
                        if (history.length == limit) {
                            history.splice(0, 1);
                        }
                    }
                    history.push(str);
                    curPos = 0;
                    lastTime = new Date().getTime();
                }
            },

            // undoredo
            moveHistory: function(dir) {
                var t = history.length - 1 + curPos + dir;
                this.setStrQuietly(history[t]);
                ld = FR.jsonDecode(history[t]);
                curPos += dir;
            },

            // ñõstrdata ¼
            // historyм¼ Undoʱٱ
            setStrQuietly: function(value) {
                if (isIEWithUserData) {
                    be.setAttribute(name, value);
                    be.save(dbName);
                } else if (window.localStorage) {
                    window.localStorage.setItem(name, value);
                } else {
                    FR.Msg.toast("Browser Not Support!");
                }
            },

            getSheetData: function(sheetIdx) {
                var data = FR.WE.localData.getLocalData();
                return sheetIdx == null ? data[0] : data[sheetIdx];
            },

            // Ƿƶ
            hasBeforeHistory: function() {
                return -curPos < history.length - 1;
            },

            // Ƿƶ
            hasAfterHistory: function() {
                return -curPos > 0 && history.length > 0;
            },

            constant: {
                RESULT_CELLS: "cells",
                ROW_ARRAY: "rowArr",
                COL_ARRAY: "colArr",
                INS_ROW_ARRAY: "insRow",
                DEL_ROW_ARRAY: "delRow",
                ROW_OPERATE_COUNTER: "rowOperateCounter",

                PROCESS_NOTE: "processNote",
                PARAMETERS: "parameters"
            }
        }
    }(),

    storeSomeThing: function(type, value, sheetIndex) {
        if (type == null || value == null) {
            return;
        }
        if (sheetIndex == null) {
            sheetIndex = 0;
        }
        var data = FR.WE.localData.getLocalData();
        if (data == null || !$.isArray(data)) {
            data = [];
        }
        if (data[sheetIndex] == null) {
            data[sheetIndex] = {};
        }
        var con = FR.WE.localData.constant;
        for (var t in con) {
            if (type == con[t]) {
                data[sheetIndex][type] = value;
                FR.WE.localData.setLocalData(data);
                break;
            }
        }
    },

    storeResultCells: function(cells, idx) {
        this.storeSomeThing(FR.WE.localData.constant.RESULT_CELLS, cells, idx);
    },

    storeRowArray: function(rowArr, idx) {
        this.storeSomeThing(FR.WE.localData.constant.ROW_ARRAY, rowArr, idx);
    },

    storeColArray: function(colArr, idx) {
        this.storeSomeThing(FR.WE.localData.constant.COL_ARRAY, colArr, idx);
    },

    storeInsertRowArr: function(insRowArr, idx) {
        this.storeSomeThing(FR.WE.localData.constant.INS_ROW_ARRAY, insRowArr, idx);
    },

    storeRowOperateCounter: function(count, idx) {
        this.storeSomeThing(FR.WE.localData.constant.ROW_OPERATE_COUNTER, count, idx);
    },

    storeProcessNote: function(note) {
        this.storeSomeThing(FR.WE.localData.constant.PROCESS_NOTE, note);
    },

    getProcessNote: function() {
        var data = this.localData.getSheetData();
        return data[FR.WE.localData.constant.PROCESS_NOTE];
    },

    setParameter: function(name, value) {
        var data = this.localData.getSheetData();
        var ps = data[FR.WE.localData.constant.PARAMETERS];
        if (ps == null) {
            ps = {};
        }
        ps[name] = value;
        this.storeSomeThing(FR.WE.localData.constant.PARAMETERS, ps);
    },

    getParameter: function(name) {
        var data = this.localData.getSheetData();
        var ps = data[FR.WE.localData.constant.PARAMETERS];
        return ps == null ? null : ps[name];
    },

    getResultCells: function(idx) {
        var data = this.localData.getSheetData(idx);
        return data[FR.WE.localData.constant.RESULT_CELLS];
    },

    getRowArray: function(idx) {
        var data = this.localData.getSheetData(idx);
        return data[FR.WE.localData.constant.ROW_ARRAY];
    },

    getColArray: function(idx) {
        var data = this.localData.getSheetData(idx);
        return data[FR.WE.localData.constant.COL_ARRAY];
    },

    getInsertRowArr: function(dix) {
        var data = this.localData.getSheetData(idx);
        return data[FR.WE.localData.constant.INS_ROW_ARRAY];
    },

    getRowOperateCounter: function(idx) {
        var data = this.localData.getSheetData(idx);
        return data[FR.WE.localData.constant.ROW_OPERATE_COUNTER];
    },

    constant: {
        DIRECTION_TAG: "direction",
        DIRECTION_TOP_TO_BOTTOM: 0,
        DIRECTION_LEFT_TO_RIGHT: 1,
        DIRECTION_NONE: 2,

        INSERT_POLICY_TAG: "insertPolicy",
        INSERT_POLICY_NULL: "null",
        INSERT_POLICY_DEFAULT: "default",
        INSERT_POLICY_COPY: "copy",
        INSERT_POLICY_DEFAULT_VALUE: "defaultInsertValue",

        BASE_CELLS: "baseCells",
       	RESULT_CELLS: "resultCells",
       	ROW_ARRAY: "rowArray",
       	COL_ARRAY: "colArray",

        ORI_INS_ROW_ARRAY: "oriInsRowArr",
        INS_ROW_ARRAY: "insertRowArr",
        DELETED_ROWS: "deletedRows"


    }
});

