$.extend(window.jQuery.prototype, {
    setEnabled:function (flag) {
        flag ? this.removeAttr('disabled') : this.attr('disabled', 'disabled');
        flag ? this.addClass('ui-state-enabled').removeClass('ui-state-disabled') : this.removeClass('ui-state-enabled').addClass('ui-state-disabled')
    },

    isEnabled:function () {
        return !this.attr('disabled');
    }
});
FR.DragList = FR.extend(FR.ListEditor, {
        _defaultConfig:function () {
            return $.extend(FR.DragList.superclass._defaultConfig.apply(), {
            });
        },

        _init:function () {
            FR.DragList.superclass._init.apply(this, arguments);
        },

        initData:function () {
            FR.DragList.superclass.initData.apply(this);
        },

        initLiEvent:function (li) {
            FR.DragList.superclass.initLiEvent.apply(this, arguments);
            var self = this;
            li.unbind('click').bind('click', function (e) {
                $('li', self.connectWith.element).removeClass('fr-list-node-selected');
                $('li', self.element).removeClass('fr-list-node-selected');
                $(this).addClass('fr-list-node-selected');
            })
        },

        popData:function (item) {
            FR.DragList.superclass.popData.apply(this, arguments);
        },

        setConnectWith:function (list) {
            this.connectWith = list;
        },

        __getResult__:function () {
            //this.connectWithлȡԪ,popdata
            var self = this;
            var items = $('.fr-list-node', this.element);
            var all = [];
            var textlength = (this.connectWith.id + this.connectWith.options.cpPrefix).length
            $.each(items, function (idx, item) {
                var id = $(item).attr('id');
                id = id.substr(textlength);
                all.push(self.connectWith.getValueByIndex(id));
            });
            return all;
        },

        __setSelectedIndex4Drag__:function (id) {
            var ulContent = $('ul.fr-list-content', this.element);
            var li = $('li', ulContent);
            if (!li) {
                this.fireEvent(FR.Events.NOSELECT);
            } else {
                li.removeClass('fr-list-node-selected');
                $(li[id]).addClass('fr-list-node-selected');
            }
            $('li', this.connectWith.element).removeClass('fr-list-node-selected');
        },

        __doAddItem4Drag__:function (li) {
            //ɾ޸dataеݣ϶ʱʹ
            var ul = $('ul', this.element);
            ul.append(li.removeClass('fr-list-node-selected'));
            this.initLiEvent(li);
        },

        __getSelectedLi__:function () {
            return $("li.fr-list-node-selected", this.element);
        },

        __removeSelectedItem4Drag__:function () {
            //ɾ޸dataеݣ϶ʱʹ
            $("li.fr-list-node-selected", this.element).remove();
        }
    }
)

//view.js
;
$.extend(FR.AnalysisPane.prototype, function () {
    var P = {
        isLoadingPage:-1,
        selectedIndex:-1,

        /*
         * alex:ʼContentPane
         */
        initContentPane:function () {
            //alex:write.css
            FR.$defaultImport('/com/fr/view/web/css/view.css', 'css');
            if (this.options.writeCss) {
                $.each(this.options.writeCss, function (i, item) {
                    FR.$import(item, 'css');
                });
            }

            //FR.$import('css/write.css', 'css');
            var tabPane = this.$contentPane.data("TabPane");
            var self = this;
            if (tabPane) {//jamesTabPane
                //jamesTabPanetabchange¼
                tabPane.on(FR.Events.TABCHANGE, function (tabPane, tabIndex) {
                    self.fireEvent(FR.Events.TABCHANGE, tabPane, tabIndex);
                });
                //jamesǰFormPanetabchange¼ִtabchange
                this.on(FR.Events.TABCHANGE, function (tabPane, tabIndex) {
                    var lgp = self.lgps[tabIndex];
                    if (lgp.reloaded == true) {
                        lgp.loadLGPPane(true);
                        lgp.reloaded = false;
                    } else if (lgp.loaded === false) {
                        lgp.loadLGPPane();
                    } else {
                        // Carlôܲ
                        self.curLGP = lgp;
                    }

                    self.selectedIndex = lgp.idx;
                });

                var tabs = tabPane.options.tabs;//jamesȡtabsĸ
                this.lgps = [];
                for (var i = 0, count = tabs.length; i < count; i++) {
                    this.lgps[i] = new FR.ALGP({idx:i, $container:$(tabs[i].content), viewPane:this, selectMethod:this.selectMethod});
                }

                //tabPane.invisible();
            } else {
                this.lgps = [new FR.ALGP({idx:0, $container:this.$contentPane, viewPane:this, selectMethod:this.selectMethod})];
            }
        },

        /*
         * ʼContentPane
         */
        loadContentPane:function () {
            var tabPane = this.$contentPane.data("TabPane");
            if (tabPane) {
                tabPane.visible();
            }

            if (this.lgps == null || this.lgps.length == 0) {
                return;
            }
            $.each(this.lgps, function (idx, lgp) {
                lgp.loaded = false;
            });
            if (this.curLGP == null) {
                this.curLGP = this.lgps[0];
                this.selectedIndex = 0;
            }
            this.curLGP.loadLGPPane();
        },

        pageSetup:function () {
            FR.showIframeDialog({
                title:FR.i18nText("PageSetup-Page_Setup"),
                width:540,
                height:415,
                url:FR.servletURL + "?op=fr_dialog&cmd=page_setup_dialog&sessionID=" + this.currentSessionID + "&reportIndex=" + this.curLGP.idx
            });
        },
        printReportServer:function () {
            FR.showIframeDialog({
                title:FR.i18nText("ReportServerP-Print[Server]"),
                width:540,
                height:300,
                url:FR.servletURL + "?op=fr_dialog&cmd=read_print_server_dialog&sessionID=" + this.currentSessionID + "&pn=" + this.currentPageIndex
            });
        },
        emailReport:function () {
            if (this.fireEvent(FR.Events.BEMAIL) === false) {
                return;
            }
            var self = this;
            FR.showEmailDialog({sessionID:this.currentSessionID, onFinish : function(){
                self.fireEvent(FR.Events.AEMAIL);
            }});
        },
        pdfPrint:function (isPopup) {
            if (this.fireEvent(FR.Events.BPDFPRINT) === false) {
                return;
            }
            if ($.browser.msie) {
                FR.doPDFPrint(this.currentSessionID, isPopup);
            } else {
                // jamespdfPrintҪformat=pdfPrintʶΪǴӡ״̬
                window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&isPDFPrint=true&extype=ori";
                this.fireEvent(FR.Events.APDFPRINT);
            }
        },
        appletPrint:function () {
            FR.doAppletPrint(this.currentSessionID);
        },
        flashPrint:function () {
            FR.doFlashPrint(this.currentSessionID, this.currentPageIndex);
        },
        exportReportToPDF:function (extype) {
            if (this.fireEvent(FR.Events.BTOPDF) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&extype=" + extype;
            this.fireEvent(FR.Events.ATOPDF);
        },
        exportReportToImage:function (extype) {
            if (this.fireEvent(FR.Events.BTOIMAGE) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=image&extype=" + extype;
            this.fireEvent(FR.Events.ATOIMAGE);
        },
        exportReportToExcel:function (extype) {
            if (this.fireEvent(FR.Events.BTOEXCEL) === false) {
                return;
            }
            // carl:Ūʾ
            if (extype == 'ldpage') {
                FR.Msg.alert(FR.i18nText("Tooltips"), FR.i18nText("Export-Excel-LargeData-Page-Info"));
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=excel&extype=" + extype;
            this.fireEvent(FR.Events.ATOEXCEL);
        },
        exportReportToWord:function () {
            if (this.fireEvent(FR.Events.BTOWORD) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=word";
            this.fireEvent(FR.Events.ATOWORD);
        },
        exportReportToHtml:function () {
            if (this.fireEvent(FR.Events.BTOHTML) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=html";
            this.fireEvent(FR.Events.ATOHTML);
        },
        printPreview:function () {
            window.open(FR.servletURL + "?op=print_preview&cmd=pw_init_page&__pi__=false&__singlesheet__=true&reportIndex=" + this.curLGP.idx + "&sessionID=" + this.currentSessionID, "_blank", "Scrollbar=yes,Resizable=yes,fullscreean=yes");
        },

        // alex:frozen
        frozen:function (column, row) {
            this.curLGP.frozen(column, row);
        },

        SetPrinterOffset:function () {
            FR.showIframeDialog({
                title:FR.i18nText("SetPrinterOffset"),
                width:420,
                height:300,
                url:FR.servletURL + "?op=printer_offset&cmd=pt_open&sessionID=" + this.currentSessionID
            });
        }
    }

    return P;
}());

FR.TreeNode = {
    initNode:function (el) {
        var $el = $(el);

        var treenode = this.createTreeNode($el.parent());

        treenode.treeNodeClick();
    },

    createTreeNode:function ($dom) {
        var editorConfig = FR.jsonDecode($dom.attr('tree'));
        editorConfig.width = $dom.attr("width");
        editorConfig.height = $dom.attr("height");

        $dom.html("");
        $editor = $("<div/>").appendTo($dom);
        editorConfig.renderEl = $editor;
        if (editorConfig.jspath) {
            var arr = editorConfig.jspath.split(";");
            $.each(arr, function (i, item) {
                FR.$import(item, "js");
            });
        }
        if (editorConfig.csspath) {
            var arr = editorConfig.csspath.split(";");
            $.each(arr, function (i, item) {
                FR.$import(item, "css");
            });
        }

        var editorEl = FR.createWidget(editorConfig);

        return editorEl;
    }
};

/*
 * alex:FormLoGicalPane
 */
FR.ALGP = function (config) {
    config = config || {};
    this.initialConfig = config;
    $.extend(this, config);

    this.loaded = false;
}

FR.extend(FR.ALGP, FR.OB, function () {
    //default IE
    var tadjst = -1, ladjst = -1, wadjst = 3, hadjst = 3, etadjst = 0, eladjst = 1, ewadjst = -1, ehadjst = +2;
    if ($.browser.mozilla || $.browser.opera) {//firefox or opera
        tadjst = -2, ladjst = -2, wadjst = -3, hadjst = -3, etadjst = 0, eladjst = 0, ewadjst = -1, ehadjst = +1;
    } else if ($.browser.safari || $.browser.chrome) {//for safari and chrome
        tadjst = -1, ladjst = -1, wadjst = -3, hadjst = -3, etadjst = 0, eladjst = 0, ewadjst = +1, ehadjst = +3;
    }
    var UP = 1, DOWN = 2, LEFT = 3, RIGHT = 4, EE = FR.keyCode;// KeyCodeд
    function isCell(dom) {
        var $dom = $(dom);
        return $dom.is('td') && $dom.attr('id') && $dom.attr('id').match(/^[A-Z]+\d+-\d+-\d+$/);
    }

    return {
        /**
         * $container, content actually be added, which is a jQuery Object, the contentPane or the selected tab of the TabPane
         */
        $container:null,
        /**
         * writePane:FR.WritePane this lgp belongs to
         */
        viewPane:null,
        /*
         * idx in writePane
         */
        idx:0,

        keyevent:null,

        viewArray:{},
        /*
         * Panel
         */
        loadLGPPane:function (recal) {
            if (this.viewPane.isLoadingPage == this.idx) {
                return;
            }

            this.viewPane.fireEvent(FR.Events.STARTLOAD, this);
            this.viewPane.isLoadingPage = this.idx;

            // alex:ǿinnerHTMLΪַ,jQuery.html()empty(),ܷʱ
            // ͻˢ·ȹ˰
//	    	this.$container[0].innerHTML = "";
            var ps = {op:"fr_analysis", cmd:'write_as_content', sessionID:this.viewPane.currentSessionID, reportIndex:this.idx, iid:Math.random()};
            if (recal) {
                ps.recal = 'true';
            }
            this.$container.__load__({
                url:FR.servletURL,
                timeout:600000,
                // richerһ⻺Ӱ
                params:ps,
                callback:function (el, success, res, options) {
                    if (success) {
                        this.initLGPComponent();
                    } else {
                        //ɹĻ,ҲҪѱϢдҳ
                        this.$container.html(res.responseText);
                    }

                    this.viewPane.curLGP = this;

                    //fire formPaneafterload¼,thisΪȥ
                    this.viewPane.fireEvent(FR.Events.AFTERLOAD, this);

                    // alex:this.$containerΪǰformPane.ContentContainer
                    this.viewPane.$currentContentContainer = this.$container;

                    this.viewPane.isLoadingPage = -1;

//                    if (FR.isMobile()) {
//                        var $fc = this.$sheet_container.children(":first"), my = this;
//                        var recal = function () {
//                            my.$sheet_container.css({width:$fc.width(), height:$fc.height()});
//                            if (my.myScroll) {
//                                my.myScroll.refresh();
//                            } else {
//                                my.myScroll = new iScroll(my.$container[0]);
//                            }
//                        }
//                        recal();
//                        this.viewPane.on("refresh", function () {
//                            recal();
//                        })
//                    }
                    delete this.loaded;
                }.createDelegate(this)
            });
        },

        /*
         * ʼLGPComponent
         */
        initLGPComponent:function () {
            this.$sheet_container = $('.sheet-container', this.$container);
            this.$sheet_container.css('position', 'absolute').css('left', '29px').css('top', '21px');
            var config = {
                type:"fr_form",
                selector:'td[widget]'
            }
            this.form = this.$sheet_container.asComponent(config);

            this.$scrollable = this.$container; // ùΪ$container
            var $center = $('.frozen-center', this.$container);
            // richer:жŰlayout
            if ($center.length > 0) {
                if ($.browser.safari || $.browser.chrome) {
                    $center.css("margin-left", "-2px");
                }

                // alex:doLayout
                this.$container.asComponent({type:"border", items:[
                    {
                        region:'center',
                        el:this.$sheet_container
                    }
                ]});
                FR.layoutFrozen(this.$sheet_container);
                //wei : bug5374
                this.$container.css({
                    overflow:'hidden'
                });
                // alex:겼ֺһdoLayout
                this.$container.doLayout();
                this.$scrollable = $center;

                if ($.browser.msie && parseInt($.browser.version) < 8) {
                    var initCell = function (element, ano_row_ranges) {
                        var row_ranges = [];
                        row_ranges[0] = 0;
                        var $trs = element.find('tbody:eq(0)').children();
                        var $tr;
                        var row_size = row_ranges.length;
                        $.each($trs, function (idx, tr) {
                            $tr = $(tr);
                            if (ano_row_ranges) {
                                var h = ano_row_ranges[idx + row_size] - ano_row_ranges[idx + row_size - 1];
                                if (tr.offsetHeight != h) {
                                    $tr.css("height", parseInt($tr.css("height")) + h - tr.offsetHeight);
                                }
                            } else {
                                row_ranges[idx + row_size] = row_ranges[idx + row_size - 1] + tr.offsetHeight;
                            }
                        });
                        return row_ranges;
                    };

                    var f_corner = $('.frozen-corner', this.$container);
                    if (f_corner.length > 0) {
                        var row_ranges = initCell($('.frozen-north', this.$container));
                        initCell(f_corner, row_ranges);
                    }

                    var row_ranges = initCell($center);
                    initCell($('.frozen-west', this.$container), row_ranges);
                }
            }
            var self = this;

            this.$table = $('.x-table', this.$container);
            // denny: tableID, ʶԪΨһԡ
            this.tableID = this.$table.attr("id");
            this.$fD = {};
            this.$fD.ftop = $('.fDtop', this.$container);
            this.$fD.fleft = $('.fDleft', this.$container);
            this.$fD.fbottom = $('.fDbottom', this.$container);
            this.$fD.fright = $('.fDright', this.$container);
            this.$fD.fdot = $('.fDdot', this.$container);
            //༭
            this.$editor = $('.x-editor', this.$container);
            this.editorEl = $("<textarea style='position:absolute;'></textarea>").addClass('fr-analysis-editor-input').appendTo(this.$editor);
            this.editorEl.bind('blur', function (e) {
                self.stopCellEditing();
            });
            this.editor_fontCheckBox = $("<div style='position:absolute;top:-2000px;'></div>").addClass('fr-edit-editor-input').appendTo(this.$sheet_container);
            // Ӽ¼
            // ΪҪkeyup¼첻ͳһ__onKeyDown
            this.editorEl.valuechange = function () {
                var value = self.editorEl.val();
                // 4ֵĳ
                self.editor_fontCheckBox.text(value + "-ʶ-");
                if (value.startWith('=')) {
                    value = value.substring(1, value.length);
                }
                var width = self.editor_fontCheckBox[0].offsetWidth;

                if (width < self.editorEl.defaultWidth) {
                    self.$editor.width(self.editorEl.defaultWidth);
                    self.editorEl.width(self.editorEl.defaultWidth);
                } else {
                    self.$editor.width(width);
                    self.editorEl.width(width);
                }
            };
            this.editorEl.keyup(function (e) {
                self.editorEl.valuechange();
            });
            //ѡ
            this.$fD.fRect = $("<div><a style='width:5px;height:5px;overflow:hidden;'></a></div>").addClass('fRect').appendTo(this.$sheet_container);

            this.table_width = this.$table.find("colgroup:eq(0)").children().length;
            this.table_height = this.$table.find('tbody:eq(0)').children().length;

            var self = this;

            // Ϊ$sheet¼
            // alex:ѡеĳӽ༭״̬,ԭmousedown¼,$editorComponent.focus
            this.$sheet_container.click(function (e) {
                self.getSelectTDCellFromMouseEvent(e);
            });
            $('td[cef]', this.$sheet_container).hover(function (e) {
                var key = $(this).attr('cef');
                if (!self.isChartCell(key)) {
                    $('td[cef=' + key + ']').addClass('fr-analysis-hover');
                }
            }, function (e) {
                var key = $(this).attr('cef');
                if (!self.isChartCell(key)) {
                    $('td[cef=' + key + ']').removeClass('fr-analysis-hover');
                }
            })
            this.contextMenu = this.createContextMenu();
            this.contextMenu.containerPane = this;
            this.contextMenu.reset();
            this.menuExpand = null;

//            // carl:û趨Ҫѡĸ
//            if (this.fec) {
//                self.selectTDCell(this.getTDCell(this.fec));
//            }

            //parentȷЩҪѡ
            var selectedCells = this.getSelectedCellsFromFrame();
            if (selectedCells) {
                $.each(selectedCells, function (idx, item) {
                    var cell = $('td[cef=' + item + ']')[0];
                    self.selectTDCell(cell, true);
                })
            }
        },

        getSelectedCellsFromFrame:function () {
            var designParent = parent.FR.ADANALY;
            if (designParent) {
                return designParent._getCurrentTDCells();
            }
            return null;
        },

        isChartCell:function (cef) {
            var designParent = parent.FR.ADANALY;
            return designParent ? (designParent.chart ? (cef === 'A3') : false) : false
        },

        getEditTDCellFromMouseEvent:function (e) {
            var src = e.target;
            var secell;
            if (!isCell(src)) {
                var $td = $(src).parents('td:eq(0)')
                if ($td.length > 0 && isCell($td[0])) {
                    secell = $td[0];
                }
            } else {
                secell = src;
            }
            //ֻбԱ༭ΪA1-ΪA2-
            if (secell && secell.id && (secell.id.startWith('A1-') || secell.id.startWith('A2-'))) {
                this.editTDCell(secell);
            } else {
                this.stopCellEditing();
            }
            if (this.contextMenu) {
                if ($(src).parents('.fr-ui-core-menu:eq(0)').length <= 0) {
                    this.contextMenu.close();
                }
            }
        },

        getCellFromEvent:function (e) {
            var src = e.target;
            var secell;
            // ܵ˸ڲʲôĬѡ

            if (!isCell(src)) {
                var $td = $(src).parents('td:eq(0)')
                if ($td.length > 0 && isCell($td[0])) {
                    secell = $td[0];
                }
            } else {
                secell = src;
            }
            return secell;
        },

        getSelectTDCellFromMouseEvent:function (e) {
            var src = e.target;
            var secell = this.getCellFromEvent(e);
            if (secell) {
                if (secell.id && (secell.id.startWith('A1-') || secell.id.startWith('A2-'))) {
                    this.editTDCell(secell);
                } else {
                    this.selectTDCell(secell, e.ctrlKey);
                }
            }
            if (this.contextMenu) {
                if ($(src).parents('.fr-ui-core-menu:eq(0)').length <= 0) {
                    this.contextMenu.close();
                }
            }
        },

        createContextMenu:function () {
            return {
                minWidth:220,
                cur_fi:null,
                containerPane:null,
                container:null,
                submenus:{},
                cItems:{},
                MENU:{
                    SORT_V:'sort_ver',
                    SORT_H:'sort_hor',
                    CLEAR_G:'clear_group',
                    SORT_G:'sort_group',
                    FILTER_C:'filter_condition',
                    CLEAR_C:'clear_condition',
                    FILTER_L:'filter_list'
                },

                reset:function () {
                    this.container = null;
                    this.submenus = {};
                    this.cItems = {};
                    this.cur_fi = null;
                },

                init:function (lgp) {
                    this.container = $("<div class='fr-ui-core-menu view-menu'>").css('display', 'none').css("z-index", 10).appendTo(lgp.$sheet_container);

                    var self = this;
                    var menu = [];
                    var submenu = [];
                    submenu[0] = {showTextSrc:true, src:' ', handler:function () {
                        lgp.sort(0, 0);
                        self.close();
                    }};
                    submenu[1] = {showTextSrc:true, src:' ', handler:function () {
                        lgp.sort(1, 0);
                        self.close();
                    }};
                    submenu[2] = {showTextSrc:true, src:"Զ...", handler:function () {
                        lgp.popCustomSortPane(0);
                        self.close();
                    }};
                    menu[0] = {iconSrc:"css:x-emb-sort", showIconSrc:true, showTextSrc:true, src:' ', handler:function () {
                    }};
                    menu[0].submenu = submenu;

                    this.addItem(menu[0], this.MENU.SORT_V);

                    submenu = [];
                    submenu[0] = {showTextSrc:true, src:' ', handler:function () {
                        lgp.sort(0, 1);
                        self.close();
                    }};
                    submenu[1] = {showTextSrc:true, src:' ', handler:function () {
                        lgp.sort(1, 1);
                        self.close();
                    }};
                    submenu[2] = {showTextSrc:true, src:"Զ...", handler:function () {
                        lgp.popCustomSortPane(1);
                        self.close();
                    }};
                    menu[1] = {iconSrc:"css:x-emb-sort", showIconSrc:true, showTextSrc:true, src:'򣨺 ', handler:function () {
                    }};
                    menu[1].submenu = submenu;

                    this.addItem(menu[1], this.MENU.SORT_H);
                    menu[2] = {showTextSrc:true, src:"ȡ", handler:function () {
                        if ($(this).isEnabled()) {
                            lgp.group(null);
                            self.close();
                        }
                    }};
                    this.addItem(menu[2], this.MENU.CLEAR_G);

                    menu[3] = {iconSrc:"css:x-emb-filter", showIconSrc:true, showTextSrc:true, src:"...", handler:function () {
                        if ($(this).isEnabled()) {
                            var type = self.ajaxCurCellType().type;
                            var loading = {
                                overlay_immediately:true,
                                text:"..."
                            };
                            FR.showLoadingDialog(loading);
                            lgp.popGroupPane(type, self.cur_fi, self.ajaxListItem());
                            self.close();
                            FR.hideLoadingDialog();
                        }
                    }};
                    this.addItem(menu[3], this.MENU.SORT_G);
                    menu[4] = {showTextSrc:true, src:"ɸѡ", handler:function () {
                        if ($(this).isEnabled()) {
                            self.containerPane.doFilter(false, true);
                            self.close();
                        }
                    }};
                    this.addItem(menu[4], this.MENU.CLEAR_C);

                    menu[5] = {iconSrc:"css:x-emb-filter", showIconSrc:true, showTextSrc:true, src:"ɸѡ...", handler:function () {
                        if ($(this).isEnabled()) {
                            lgp.popFilterPane(self.cur_fi);
                            self.close();
                        }
                    }};

                    this.addItem(menu[5], this.MENU.FILTER_C);

                    //        		this.addItem({type : 'seq'});

                    menu[6] = {iconSrc:"css:x-emb-filter", showIconSrc:true, showTextSrc:true, src:"бɸѡ", handler:function (e) {

                    }};
                    this.addItem(menu[6], this.MENU.FILTER_L);

                    this.listPane = $('<div/>').css('display', 'none').appendTo(this.container);
                    this.listSearchPane = $('<div/>').height(22).css("margin-left", "20px").css("margin-bottom", "1px").appendTo(this.listPane);
                    this.initSearchPane();
                    this.flPane = $('<div/>').css("overflow-y", "auto").appendTo(this.listPane);

                    var buttonok = $('<div/>').css({'margin-left':80, 'float':'left'}).appendTo(this.listPane);
                    var buttonCancel = $('<div/>').css('float', 'left').appendTo(this.listPane);
                    var listener = {};
                    listener.eventName = FR.Events.CLICK;
                    listener.action = function () {
                        self.containerPane.doFilter(true);
                    };
                    config = {
                        type:"button",
                        name:'flok',
                        tablable:true,
                        width:60,
                        height:23,
                        text:FR.i18nText("OK"),
                        listeners:[listener]
                    };
                    buttonok.asComponent(config);
                    config = {
                        type:"button",
                        tablable:true,
                        width:60,
                        height:23,
                        text:FR.i18nText("Cancel")
                    };
                    buttonCancel.asComponent(config);
                    buttonCancel.unbind('click').bind('click', function (e) {
                        self.close();
                    })
                    this.container.width(this.minWidth);
                    this.container.children("div").width(this.minWidth - 8);
                },

                initSearchPane:function () {
                    var searchIcon = $('<div/>').addClass('fr-analysis-listsearch').addClass('fr-view-group-string-search-icon');
                    searchIcon.appendTo(this.listSearchPane);
                    var inputField = new FR.TextEditor({
                        renderEl:$('<div/>').css('float', "right").appendTo(this.listSearchPane),
                        width:171,
                        height:22
                    });
                    var self = this;
                    searchIcon.unbind('click').bind('click', function (e) {
                        inputField.setValue('');
                        inputField.fireEvent(FR.Events.AFTEREDIT);
                    })
                    inputField.on(FR.Events.AFTEREDIT, function (e) {
                        var searchText = this.getValue().toUpperCase();
                        var isNotClear = searchText && searchText.length > 0;
                        if (isNotClear) {
                            searchIcon.addClass('fr-view-group-string-clear-search-icon').removeClass("fr-view-group-string-search-icon");
                        } else {
                            searchIcon.addClass('fr-view-group-string-search-icon').removeClass("fr-view-group-string-clear-search-icon");
                        }
                        $.each(self.curLP.elArray, function (idx, item) {
                            item.setVisible(item.options.text.toUpperCase().indexOf(searchText) > -1)
                        })
                    })
                },

                ajaxCurCellType:function () {
                    return this.ajaxItem("view_group_gettype")
                },

                ajaxListItem:function () {
                    return this.ajaxItem("view_get_filter_item");
                },

                ajaxCurrentParent:function (cef) {
                    return this.ajaxItem("get_sort_parent", 'fr_analysis', cef);
                },

                ajaxGroupColName:function (cef) {
                    return this.ajaxItem("get_group_colName", 'fr_analysis', cef);
                },

                ajaxItem:function (cmd, op, cef) {
                    var fi = this.cur_fi;
                    // TODO carl: find out why?
                    // ҳ֮lpָdivڵ㲻ˣٴμصʱ¼Ӧ
                    if (fi || cef) {
                        cef = cef ? cef : fi.cef;
                        var loc = FR.cellStr2ColumnRow(cef);
                        var self = this;
                        var result;
                        FR.ajax({
                            async:false,
                            type:'POST',
                            url:FR.servletURL,
                            data:{
                                op:op ? op : 'fr_view',
                                cmd:cmd,
                                sessionID:self.containerPane.viewPane.currentSessionID,
                                col:loc.col,
                                row:loc.row,
                                reportIndex:self.containerPane.idx
                            },
                            complete:function (res, status) {
                                var text = res.responseText;
                                var ro = FR.jsonDecode(text);
                                if (ro.error) {
                                    FR.Msg.toast(ro.error);
                                } else {
                                    result = ro;
                                }
                            }
                        });
                        return result;
                    }
                },

                //һִй˻ڸбеlistItem,
                _getFilterListFromParent:function (cef) {
                    var filter = this._getFilterFromParent(cef);
                    if (filter) {
                        return filter.filterList;
                    }
                    return null;
                },

                _getGroupFromParent:function (cef) {
                    var reportDesigner = parent.FR.ADANALY;
                    if (reportDesigner) {
                        var columnname = this.ajaxGroupColName(cef);
                        if (columnname) {
                            var groupSetting = reportDesigner._getGroupSettingFromFrame(columnname.name);
                            if (groupSetting && groupSetting.group) {
                                return groupSetting.group;
                            }
                        }
                    }
                    return null;
                },

                _getFilterFromParent:function (cef) {
                    return this._getCellSettingFromParent(cef, 'filter');
                },

                _getCellSettingFromParent:function (cef, option) {
                    var reportDesigner = parent.FR.ADANALY;
                    if (reportDesigner) {
                    	var index = reportDesigner.getCellIndex(cef);
                        var cellSetting = reportDesigner.getCellSetting(index);
                        if (cellSetting && cellSetting[option]) {
                            return cellSetting[option];
                        }
                    }
                    return null;
                },

                showList:function () {
                    if (this.cur_fi) {
                        var fi = this.cur_fi;
                        var result = this.ajaxListItem();
                        var items = this._getFilterListFromParent(this.cur_fi.cef);
                        if (items) {
                            lp = this.createViewListPane(items);
                        } else if (result != null && result.items != null) {
                            lp = this.createViewListPane(result.items);
                        } else {
                            lp = this.createViewListPane(fi.items);
                        }
                        lp.filter(fi.items);
                        this.curLP = lp;

                        this.flPane.html('');
                        this.flPane.append(lp.pane);
                        if (lp.elArray.length > 9) {
                            this.flPane.height(200);
                        } else {
                            //Ҫȫť
                            this.flPane.height((lp.elArray.length + 1) * 22);
                        }
                        this.listPane.css('display', 'block');
                        var top = parseInt(this.container.css('top'));
                        if (this.containerPane.$scrollable != this.containerPane.$container) {
                            if (top + this.container.height() > this.containerPane.$sheet_container.height()) {
                                this.container.css({top:top - this.listPane.height() - 10});
                            }
                        } else {
                            if (top + this.container.height() - this.containerPane.$scrollable.scrollTop() > this.containerPane.$container.height()) {
                                this.container.css({top:top - this.listPane.height() - 10});
                            }
                        }
                    }
                },

                addItem:function (menu, idx) {
                    var self = this;
                    var $item = $("<div style='width:80px'>").appendTo(this.container);

                    if (menu.type === "sep") {
                        $item.addClass("menu-sep").html("'&nbsp;'");
                    } else {
                        $item.addClass("view-menu-item")
                            .click(function (e, item) {
                                menu.handler.call(this, e, item);
                            });
                        self.bindMenuItemEvent($item, menu);
                        var $menu_text = $('<div class="menu-text"></div>').html(menu.src).appendTo($item);
                        var text_width = $menu_text.position().left * 2 + $menu_text.width();
                        if (this.minWidth < text_width) {
                            this.minWidth = text_width;
                        }
                        var icon = menu.iconSrc ? menu.iconSrc.replace("css:", "") : "";
                        if (icon) {
                            $('<div class="menu-icon"></div>').addClass(icon).appendTo($item);
                        }
                        if (menu.submenu) {
                            $('<div class="menu-rightarrow"></div>').appendTo($item);	// has sub menu
							if ($.isArray(menu.submenu)) {
								if (!$item.$submenu) {
									var config = {
										destroyOnClose:false,
										minWidth:120,
										items:menu.submenu
									};
									$item.$submenu = new FR.frMenu(config);
									$item.$submenu.close();
									self.submenus[idx] = $item.$submenu;
								}
							}
                        }
                        if ($.support.boxModel == true) {
                            var height = $item.height() || 22;
                            $item.height(height - ($item.outerHeight() - $item.height()));
                        }
                    }

                    this.cItems[idx] = $item;
                },

                bindMenuItemEvent:function ($item, menu) {
                    var self = this;
                    $item.hover(
                        function () {
                            self.closeSub();
                            $item.siblings().each(function () {
                                $(this).removeClass('menu-active');
                            });
                            if ($item.isEnabled()) {
                                $item.addClass('menu-active');
                            }
                            if ($item.$submenu) {
                                $item.$submenu.close(false);
                                $item.$submenu.$menuRoot.removeClass('menu').addClass('view-menu');
                                $.each($item.$submenu.children(), function (idx, it) {
                                            it.removeClass('menu-item').addClass('view-menu-item');
                                });
                                var left = $item.offset().left + $item.outerWidth() - 2;
                                if (left + $item.$submenu.$menuRoot.outerWidth() > $(window.document).width()) {
                                    left = $item.offset().left - $item.$submenu.$menuRoot.outerWidth() + 2;
                                }
                                $item.$submenu.position(left, $item.offset().top - 3);
                                if ($item.isEnabled()) {
                                    $item.$submenu.show();
                                }
                            }
                        },
                        function (e) {
                            $item.removeClass('menu-active');
                            if ($item.$submenu) {
                                if (e.pageX >= parseInt($item.$submenu.$menuRoot.css('left'))) {
                                    $item.addClass('menu-active');
                                } else {
                                    $item.$submenu.close();
                                }

                            }
                        }
                    );
                },

                show:function (lgp, ast, at, l, t, cef) {
                    if (!this.container) {
                        this.init(lgp);
                    }

                    if (lgp.menuExpand.attr('conv') == 'true') {
                        l -= 168;
                    }

                    this.listPane.css('display', 'none');

                    var items = this.cItems;
                    var il = 0;
                    if (ast == 0) {
                        items[this.MENU.SORT_V].setEnabled(true);
                        items[this.MENU.SORT_H].setEnabled(false);
                        il += 2;
                    } else if (ast == 1) {
                        items[this.MENU.SORT_V].setEnabled(false);
                        items[this.MENU.SORT_H].setEnabled(true);
                        il += 2;
                    } else if (ast == 2) {
                        items[this.MENU.SORT_V].setEnabled(true);
                        items[this.MENU.SORT_H].setEnabled(true);
                        il += 2;
                    }

                    // ֶͨΣɸѡ
                    if (at <= 2) {

                        lgp.$sheet_container.__loading__(true, false, {left:l, top:t});
                        if (cef) {
                            var fi;
                            if (!lgp.fiArray) {
                                lgp.fiArray = {};
                                fi = null;
                            } else {
                                fi = lgp.fiArray[cef];
                            }
                            if (!fi) {
                                fi = {};
                                var loc = FR.cellStr2ColumnRow(cef);
                                FR.ajax({
                                    async:false,
                                    type:'POST',
                                    url:FR.servletURL,
                                    data:{
                                        op:'fr_view',
                                        cmd:'view_get_filter_info',
                                        sessionID:lgp.viewPane.currentSessionID,
                                        col:loc.col,
                                        row:loc.row,
                                        reportIndex:lgp.idx
                                    },
                                    complete:function (res, status) {
                                        var text = res.responseText;
                                        var ro = FR.jsonDecode(text);
                                        if (ro.error) {
                                            FR.Msg.toast(ro.error);
                                        } else {
                                            fi = ro;
                                        }
                                    }
                                });
                                lgp.fiArray[cef] = fi;
                                fi.cef = cef;
                            }
                            //analysissupport!only support cols
                            var supportFilterAndGroup = fi.analysissupport && fi.isnotresult;
                            items[this.MENU.FILTER_L].setEnabled(fi.islist && supportFilterAndGroup);
                            il += 1;
                            var filter = this._getFilterListFromParent(cef);
                            items[this.MENU.FILTER_C].setEnabled(supportFilterAndGroup);
                            il += 1;
                            items[this.MENU.SORT_G].setEnabled(supportFilterAndGroup);
                            il += 1;
                            items[this.MENU.CLEAR_C].setEnabled(filter);
                            il += 1;
                            var group = this._getGroupFromParent(cef);
                            items[this.MENU.CLEAR_G].setEnabled(group);
                            il += 1;

                            this.cur_fi = fi;
                        } else {
                            this.cur_fi = null;
                            FR.Msg.toast('Unknown Error.');
                        }
                        lgp.$sheet_container.__loading__(false);
                        // ֶֻ
                    } else {
                        items[this.MENU.SORT_G].setEnabled(false);
                        items[this.MENU.CLEAR_G].setEnabled(false);
                        items[this.MENU.FILTER_C].setEnabled(false);
                        items[this.MENU.CLEAR_C].setEnabled(false);
                        items[this.MENU.FILTER_L].setEnabled(false);
                        il += 5;
                    }

					var type = this.ajaxCurCellType();
					//ûԶ
					if (type && type.type == 0) {
						this.submenus[this.MENU.SORT_V].cItems[2].setEnabled(false);
						this.submenus[this.MENU.SORT_H].cItems[2].setEnabled(false);
					} else {
						this.submenus[this.MENU.SORT_V].cItems[2].setEnabled(true);
						this.submenus[this.MENU.SORT_H].cItems[2].setEnabled(true);
					}

                    if (lgp.$scrollable != lgp.$container) {
                        if (t + il * 22 + 4 > lgp.$sheet_container.height()) {
                            t -= il * 22 - 10;
                        }
                    } else {
                        if (t + il * 22 + 4 - lgp.$scrollable.scrollTop() > lgp.$container.height()) {
                            t -= il * 22 - 10;
                        }
                    }
                    this.container.css({left:l, top:t});
                    this.container.css('display', 'block');
                    if (items[this.MENU.FILTER_L].isEnabled()) {
                        this.showList();
                    }
                },

                close:function () {
                    if (this.container) {
                        this.closeSub();
                        this.container.css('display', 'none');
                    }
                },

                closeSub:function () {
					var self = this;
					$.each(self.submenus, function(idx){
							self.submenus[idx].close();
						});
                },

                createViewListPane:function (items) {
                    var O = {
                        init:function (items) {
                            var $view = $("<div/>").addClass('fr-analysis-combo-list-inner')
                                .css({width:'auto', overflow:'auto'});

                            items = items || [];
                            //1Ǹȫ
                            var h = (items.length + 1) * 20;
                            $view.css('height', h).css('margin-left', 20);

                            this.elArray = [];
                            var self = this;

                            var sH = 18;
                            listener = {};
                            listener.eventName = FR.Events.STATECHANGE;
                            listener.action = function () {
                                self.checkAll();
                            };
                            this.allCheckBox = $('<div/>').appendTo($view).height(sH)
                                .attr("title", "ȫ")
                                .addClass('fr-combo-list-item')
                                .css('border', 0)
                                .asComponent({type:'checkbox', text:"ȫ", value:true});
                            this.allCheckBox.on(FR.Events.STATECHANGE, function (e) {
                                $.each(self.elArray, function (idx, item) {
                                    item.setValue(self.allCheckBox.getValue());
                                });
                            });
                            $.each(items, function (idx, it) {
                                self.elArray[idx] = $('<div/>').appendTo($view).height(sH)
                                    .attr("title", it.text)
                                    .addClass('fr-combo-list-item')
                                    .css('border', 0)
                                    .asComponent({type:'checkbox', text:it.text + ' (' + it.count + ')', value:true, listeners:[listener]});
                                self.elArray[idx].options.it = it;
                            });

                            this.pane = $view;
                        },

                        checkAll:function () {
                            var isAllSelected = true;
                            $.each(this.elArray, function (idx, item) {
                                if (!item.selected()) {
                                    isAllSelected = false;
                                    return false;
                                }
                            });
                            this.allCheckBox.setValue(isAllSelected);
                        },

                        filter:function (filters) {
                            var self = this;
                            if (filters) {
                                $.each(self.elArray, function (index, item) {
                                    var hasValue = false;
                                    if (filters) {
                                        $.each(filters, function (idx, it) {
                                            if (item.options.it.text === it.text) {
                                                hasValue = true;
                                            }
                                        });
                                    }
                                    item.setValue(hasValue);
                                })
                            }
                            self.checkAll();
                        }
                    };

                    O.init(items);

                    return O;
                }
            }
        },

        popContextMenu:function () {
            var $cell = $(this.currentTDCell);
            var cef = $cell.attr('cef');
            var filter = this.contextMenu._getFilterFromParent(cef)
            if ($cell.attr("at") != null || (filter && filter.at != null)) {
                var at = filter && (filter.at || filter.at === 0) ? filter.at : parseInt($cell.attr("at"));
                if (at <= 0) {
                    return;
                }
                var ast = filter && (filter.ast || filter.ast === 0) ? filter.ast : parseInt($cell.attr("ast"));
                if (ast >= 0 && ast <= 2) {
                    var left = parseInt(this.menuExpand.css('left'));
                    var top = parseInt(this.menuExpand.css('top'));
                    this.menuExpand.hide();
                    this.contextMenu.show(this, ast, at, left, top, cef);
                }
            }
        },

        sort:function (sort, dir, reg) {
            var $cell = $(this.currentTDCell);
            var cef = $cell.attr('cef');
            var parentBoxs = this.contextMenu.ajaxCurrentParent(cef);
            if (parentBoxs) {
                var parentBox = (dir == 0 ? parentBoxs['left'] : parentBoxs['up']);
                if (parentBox) {
                    var formula = cef;
                    if (reg || reg === 0) {
                        formula = 'INDEX(' + cef + ',' + reg + ')';
                    }
                    var config = {
                        sortType:sort,
                        dir:dir,
                        parentBox:parentBox,
                        formula:formula
                    }
                    var o = {
                        sort:config
                    }
                    this._sort(o);
                }
            }
        },

        group:function (config) {
            var $cell = $(this.currentTDCell);
            var cef = $cell.attr('cef');
            var columnname = this.contextMenu.ajaxGroupColName(cef);
            if (columnname || columnname === 0) {
                var o = {
                    ast:$cell.attr("ast"),
                    cef:cef,
                    columnname:columnname.name,
                    group:config ? FR.jsonEncode(config) : null
                }
                this._group(o);
            }
        },

        _group:function (config) {
            this.setGroupOptions(config);
        },

        setGroupOptions:function (config) {
            var reportDesigner = parent.FR.ADANALY;
            if (reportDesigner) {
                reportDesigner._setGroupSettingFromFrame(config);
            } else {
                alert('analysis can use only under data analysis')
            }
        },
        _sort:function (config) {
            this.setReportOptions(config);
        },

        setReportOptions:function (config) {
            var reportDesigner = parent.FR.ADANALY;
            if (reportDesigner) {
                reportDesigner._setCellConfigFromFrame(config);
            } else {
                alert('analysis can use only under data analysis')
            }
        },

        setReportcurrentTDCells:function (cell) {
            var reportDesigner = parent.FR.ADANALY;
            if (reportDesigner) {
                reportDesigner._setCurrentTDCells(cell)
            } else {
                alert('analysis can use only under data analysis')
            }
        },

        popCustomSortPane:function (dir) {
            if (!this.regDialog) {
                var contentDiv = $('<div/>');
                var inputField = $('<div/>').appendTo(contentDiv);
                var list = $('<div style="padding-left:4px"></div>').appendTo(contentDiv);
                var buttonField = $('<div style="float:right"></div>').appendTo(contentDiv);
                var self = this;

                new FR.Button({
                    text:FR.i18nText("Cancel"),
                    width:60,
                    render:false,
                    renderEl:$('<div/>').appendTo($('<div style="float:right;padding-right:20px;"></div>').appendTo(buttonField)),
                    handler:function () {
                        self.regDialog.setVisible(false);
                    }
                });

                new FR.Button({
                    text:FR.i18nText("OK"),
                    width:60,
                    render:false,
                    renderEl:$('<div/>').appendTo($('<div style="float:right;padding-right:20px;"></div>').appendTo(buttonField)),
                    handler:function () {
                        var item = input.getValue();
                        if (item) {
                            var regs = item.split(',');
                            var res = "";
                            if (item.length == 0) {
                                res = '""'
                            }
                            $.each(regs, function (idx, item) {
                                res += '"'
                                res += item;
                                res += '"';
                                if (idx != regs.length - 1) {
                                    res += ','
                                }
                            })
                            self.sort(0, dir, res);
                            self.regDialog.setVisible(false);
                            regList.clearSelected();
                        } else {
                            alert('ѡ');
                        }
                    }
                });

                var input = new FR.TextEditor({
                    renderEl : inputField,
                    width:340
                });
                var regList = new FR.ListEditor({
                    width:450,
                    height:280,
                    widgetUrl:FR.servletURL + "?op=fr_adhoc&cmd=ac_custom_reg",
                    renderEl:list
                });
				regList.on(FR.Events.CLICK, function(){
					input.setValue(this.getSelectedData().text);
				});
                var o = {
                    title:'Զ',
                    width:480,
                    height:370,
                    contentHtml:contentDiv
                };

                this.regDialog = new FR.Dialog(o);
                this.regDialog.win.on(FR.Events.RESIZE, function () {
                    regList.doResize({width:self.regDialog.element.width() - 18, height:self.regDialog.element.height() - 81})
                });
                this.regDialog.element.addClass('fr-user-select-disable');
            }
            this.regDialog.doResize({width:480, height:370});
            this.regDialog.setVisible(true);
        },

        popGroupPane:function (type, cur_fi, listItem) {
            var ro = cur_fi;
            if (!ro) {
                FR.Msg.toast('Unknown Error.');
                return;
            }
            var self = this;
            self.cellGroupType = type;
            if (!this.groupDialog) {
                this.groupCard = [];
                var contentDiv = $('<div/>');
                var o = {
                    title:'',
                    width:480,
                    height:370,
                    contentHtml:contentDiv
                };
                var numberCard = $('<div/>').appendTo(contentDiv);
                var dateCard = $('<div/>').appendTo(contentDiv);
                var stringCard = $('<div style="padding-left:18px;padding-top:8px;height:260px;"></div>').appendTo(contentDiv);
                var buttonField = $('<div style="float:right;padding-top:10px;"></div>').appendTo(contentDiv);
                new FR.Button({
                    text:FR.i18nText("Cancel"),
                    width:60,
                    render:false,
                    renderEl:$('<div/>').appendTo($('<div style="float:right;padding-right:20px;"></div>').appendTo(buttonField)),
                    handler:function () {
                        self.groupDialog.setVisible(false);
                    }
                });

                new FR.Button({
                    text:FR.i18nText("OK"),
                    width:60,
                    render:false,
                    renderEl:$('<div/>').appendTo($('<div style="float:right;padding-right:20px;"></div>').appendTo(buttonField)),
                    handler:function () {
                        var config = {};
                        switch (self.cellGroupType) {
                            case 0 :
                            {
                                config = {
                                    sCheckBox:nsCheckBox.getValue(),
                                    sValue:nsValue.getValue(),
                                    dCheckBox:ndCheckBox.getValue(),
                                    dValue:ndValue.getValue(),
                                    stepValue:nstepValue.getValue()
                                }
                                if (config.sCheckBox) {
                                    if (!config.sValue && config.sValue !== 0) {
                                        alert('ʼֵ,ѡĬΪСֵ');
                                        return false;
                                    }
                                }
                                if (config.dCheckBox) {
                                    if (!config.dValue && config.dValue !== 0) {
                                        alert('ֵֹ,ѡĬΪֵ');
                                        return false;
                                    }
                                }
                                if (!config.stepValue) {
                                    alert('벽Ҵ');
                                    return false;
                                }
                                break;
                            }
                            case 1 :
                            {
                                config = {
                                    sCheckBox:dsCheckBox.getValue(),
                                    sValue:dsValue.getValue(),
                                    dCheckBox:ddCheckBox.getValue(),
                                    dValue:ddValue.getValue(),
                                    stepValue:{
                                        year:yearCheckBox.getValue(),
                                        season:seasonCheckBox.getValue(),
                                        month:monthCheckBox.getValue(),
                                        day:dayCheckBox.getValue(),
                                        days:daysValue.getValue()
                                    }
                                }
                                if (config.sCheckBox) {
                                    if (!config.sValue && config.sValue !== 0) {
                                        alert('ʼֵ,ѡĬΪСֵ');
                                        return false;
                                    }
                                }
                                if (config.dCheckBox) {
                                    if (!config.dValue && config.dValue !== 0) {
                                        alert('ֵֹ,ѡĬΪֵ');
                                        return false;
                                    }
                                }
                                if (!config.stepValue.year
                                    && !config.stepValue.season
                                    && !config.stepValue.month
                                    && !config.stepValue.day) {
                                    alert('ѡ񲽳!')
                                    return false;
                                }
                                if (config.stepValue.day) {
                                    if (!config.stepValue.days
                                        || config.stepValue.days < 1
                                        || config.stepValue.days > 31) {
                                        alert('ȷڲ!');
                                        return false;
                                    }
                                }
                                break;
                            }
                            case 2 :
                            {
                                config = {
                                    name:sgName.getValue(),
                                    group:groupResultList.__getResult__(),
                                    showLast:isShowLastValue.getValue(),
                                    showLastValue:{
                                        asAGroup:putLastAsAGroup[0].checked,
                                        name:lastGroupName.getValue()
                                    }
                                }
                                if (!config.name) {
                                    alert('붨');
                                    return false;
                                }
                                if (config.group.length < 1) {
                                    alert('ѡֵ');
                                    return false;
                                }
                                if (config.showLast) {
                                    if (config.showLastValue.asAGroup) {
                                        if (!config.showLastValue.name) {
                                            alert('');
                                            return false;
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        config.type = self.cellGroupType;
                        self.group(config);
                        self.groupDialog.setVisible(false);
                    }
                });
                var numberTable = $('<table style="padding-top:8px;"><tr><td class="fr-view-group-name fr-view-group-number-start-name"></td>' +
                    '<td class="fr-view-group-value fr-view-group-number-start-value"></td></tr>' +
                    '<tr><td class="fr-view-group-name fr-view-group-number-end-name" ></td>' +
                    '<td class="fr-view-group-value fr-view-group-number-end-value"></td></tr>' +
                    '<tr><td class="fr-view-group-name">:</td>' +
                    '<td class="fr-view-group-value fr-view-group-number-step-value"></td></tr></table>').appendTo(numberCard);
                var nsCheckBox = new FR.CheckBox({
                    renderEl:$('.fr-view-group-number-start-name', numberTable),
                    text:'ʼ:',
                    value:true
                });

                var nsValue = new FR.NumberEditor({
                    renderEl:$('.fr-view-group-number-start-value', numberTable),
                    height:20,
                    width:120
                });

                var ndCheckBox = new FR.CheckBox({
                    renderEl:$('.fr-view-group-number-end-name', numberTable),
                    text:'ֹ:',
                    value:true
                });

                var ndValue = new FR.NumberEditor({
                    renderEl:$('.fr-view-group-number-end-value', numberTable),
                    height:20,
                    width:120
                });

                var nstepValue = new FR.NumberEditor({
                    renderEl:$('.fr-view-group-number-step-value', numberTable),
                    height:20,
                    width:120,
                    value:10
                });
                var dateTable = $('<table  style="padding-top:8px;"><tr><td class="fr-view-group-name fr-view-group-date-start-name"></td>' +
                    '<td class="fr-view-group-value fr-view-group-date-start-value"></td></tr>' +
                    '<tr><td class="fr-view-group-name fr-view-group-date-end-name"></td>' +
                    '<td class="fr-view-group-value fr-view-group-date-end-value"></td></tr>' +
                    '<tr><td class="fr-view-group-name">:</td>' +
                    '<td class="fr-view-group-value fr-view-group-date-step-value"></td></tr>' +
                    '<tr><td class="fr-view-group-name"><div style="height:22px;"></div></td>' +
                    '<td class="fr-view-group-value fr-view-group-date-day-value"></td></tr></table>').appendTo(dateCard);
                var dsCheckBox = new FR.CheckBox({
                    renderEl:$('.fr-view-group-date-start-name', dateTable),
                    text:'ʼ:',
                    value:true
                });

                var dsValue = new FR.DateTimeEditor({
                    renderEl:$('<div/>').appendTo($('.fr-view-group-date-start-value', dateTable)),
                    height:20,
                    width:120,
                    returnDate:true
                });

                var ddCheckBox = new FR.CheckBox({
                    renderEl:$('.fr-view-group-date-end-name', dateTable),
                    text:'ֹ:',
                    value:true
                });

                var ddValue = new FR.DateTimeEditor({
                    renderEl:$('<div/>').appendTo($('.fr-view-group-date-end-value', dateTable)),
                    height:20,
                    width:120,
                    returnDate:true
                });

                var dstepValue = $('<div style="height:100px;border:1px solid #99BBE8;overflow:hidden;text-align:left;line-height:22px"></div>').appendTo($('.fr-view-group-date-step-value', dateTable))
                var yearCheckBox = new FR.CheckBox({
                    renderEl:$('<div/>').appendTo(dstepValue),
                    text:'',
                    value:false
                });
                var seasonCheckBox = new FR.CheckBox({
                    renderEl:$('<div/>').appendTo(dstepValue),
                    text:'',
                    value:false
                });
                var monthCheckBox = new FR.CheckBox({
                    renderEl:$('<div/>').appendTo(dstepValue),
                    text:'',
                    value:false
                });
                var dayCheckBox = new FR.CheckBox({
                    renderEl:$('<div/>').appendTo(dstepValue),
                    text:'',
                    value:true
                });
                var dayPane = $('<div><div style="float:right;padding-left:5px;"></div><div style="float:right" class="fr-view--group-step-days"></div></div>').appendTo($('.fr-view-group-date-day-value', dateTable))
                var daysValue = new FR.NumberEditor({
                    renderEl:$('.fr-view--group-step-days', dayPane),
                    width:24,
                    height:20,
                    minValue:1,
                    maxValue:31,
                    value:7
                })
                dayCheckBox.on(FR.Events.CLICK, function (e) {
                    if (this.getValue()) {
                        dayPane.show();
                    } else {
                        dayPane.hide();
                    }
                })
                var stringTitle = $('<div class="fr-view-group-table-name"><div style="float:left;">:</div><div style="float:left;" class="fr-view-group-string-name"></div></div>')
                var sgName = new FR.TextEditor({
                    renderEl:$('.fr-view-group-string-name', stringTitle),
                    height:20,
                    width:120
                });

                var stringTable = $('<table cellpadding="0" cellspacing="0" border="0" >' +
                    '<colgroup><col style="width:120px;"><col style="width:40px;"><col style="width:120px;"></colgroup>' +
                    '<tr><td class="fr-view-group-table-name">ֵ:</td>' +
                    '<td></td>' +
                    '<td class="fr-view-group-table-name fr-view-group-string-search"></td></tr>' +
                    '<tr><td class="fr-view-group-list-result"></td>' +
                    '<td><div>' +
                    '<div class="fr-view-group-string-delete"></div>' +
                    '<div class="fr-view-group-string-add"></div></div></td>' +
                    '<td class="fr-view-group-list-all"></td></tr></table>');
                var searchField = $('<div class="fr-view-group-string-search">' +
                    '<div style="float:left;" class="fr-view-group-string-search-icon"></div>' +
                    '<div style="float:left;padding-top:1px;" class="search-input"></div></div>').appendTo($('td.fr-view-group-string-search', stringTable));
                var searchValue = new FR.TextEditor({
                    renderEl:$('.search-input', searchField),
                    width:93,
                    height:18,
                    watermark:"search"
                });
                searchValue.on(FR.Events.AFTEREDIT, function (e) {
                    groupStringList.doFilter(this.getValue());
                })
                var groupResultList = new FR.DragList({
                    renderEl:$('<div/>').appendTo($('.fr-view-group-list-result', stringTable)),
                    width:120,
                    height:130,
                    draggable:true,
                    outside:true,
                    items:[]
                });
                var groupStringList = new FR.DragList({
                    renderEl:$('<div/>').appendTo($('.fr-view-group-list-all', stringTable)),
                    width:120,
                    height:130,
                    draggable:true,
                    outside:true,
                    items:[]
                });
                groupResultList.setConnectWith(groupStringList);
                groupStringList.setConnectWith(groupResultList);
                $('.fr-view-group-string-add', stringTable).click(function (e) {
                    groupResultList.__doAddItem4Drag__(groupStringList.__getSelectedLi__());
                    groupStringList.__removeSelectedItem4Drag__();
                    groupStringList.__setSelectedIndex4Drag__(0);
                    e.stopEvent();
                });
                $('.fr-view-group-string-delete', stringTable).click(function (e) {
                    groupStringList.__doAddItem4Drag__(groupResultList.__getSelectedLi__());
                    groupResultList.__removeSelectedItem4Drag__();
                    groupResultList.__setSelectedIndex4Drag__(0);
                    e.stopEvent();
                });

                var stringBottom = $('<div><div class="fr-view-group-string-showlastvalue"></div>' +
                    '<div  class="fr-view-group-string-childname"><div style="float:left;">' +
                    '<input type="radio" class="fr-view-group-string-putLast-agroup" id="fr-view-group-string-putLast" name="fr-view-group-string-putLast" checked>ʣֵΪһ:</input></div>' +
                    '<div style="float:left;" class="fr-view-group-lastname"></div></div>' +
                    '<div class="fr-view-group-string-childname"><input type="radio" class="fr-view-group-string-putLast-single" id="fr-view-group-string-putLast" name="fr-view-group-string-putLast">ʣֱֵ𴴽Ϊ</input></div></div>')
                var isShowLastValue = new FR.CheckBox({
                    renderEl:$('.fr-view-group-string-showlastvalue', stringBottom),
                    text:"ʾʣֵ:",
                    value:false
                });
                isShowLastValue.on(FR.Events.CLICK, function (e) {
                    var showLast = this.getValue();
                    putLastAsAGroup.setEnabled(showLast);
                    $('.fr-view-group-string-putLast-single', stringBottom).setEnabled(showLast);
                    if (showLast) {
                        lastGroupName.enable();
                        $('.fr-view-group-string-childname', stringBottom).removeClass("ui-state-disabled");
                    } else {
                        lastGroupName.disable();
                        $('.fr-view-group-string-childname', stringBottom).addClass("ui-state-disabled");
                    }
                })
                var putLastAsAGroup = $('.fr-view-group-string-putLast-agroup', stringBottom);
                var lastGroupName = new FR.TextEditor({
                    renderEl:$('.fr-view-group-lastname', stringBottom),
                    width:120,
                    watermark:'д'
                });
                isShowLastValue.fireEvent(FR.Events.CLICK);
                var stringField = $('<div style="height:260px;width:430px;"></div>').appendTo(stringCard);
                stringField.asComponent({type:'border', items:[
                    {region:"north", el:stringTitle, height:24},
                    {region:"center", el:$('<div/>').append(stringTable)},
                    {region:"south", el:stringBottom, height:72}
                ]});
                this.groupDialog = new FR.Dialog(o);
                numberCard.give = {height:180, width:340};
                dateCard.give = {height:280, width:340};
                stringCard.give = {height:360, width:440};
                numberCard.popluate = function (fi, result) {
                    if (result == null) {
                        FR.Msg.toast('Unknown Error.');
                        return;
                    }
                    if (result.start == null) {
                        FR.Msg.toast('get start error.');
                    } else {
                        nsValue.setValue(result.start);
                    }
                    if (result.end == null) {
                        FR.Msg.toast('get end error.');
                    } else {
                        ndValue.setValue(result.end);
                    }
                };
                dateCard.popluate = function (fi, result) {
                    if (result == null) {
                        FR.Msg.toast('Unknown Error.');
                        return;
                    }
                    if (result.start == null) {
                        FR.Msg.toast('get start error.');
                    } else {
                        dsValue.setValue(result.start);
                    }
                    if (result.end == null) {
                        FR.Msg.toast('get end error.');
                    } else {
                        ddValue.setValue(result.end);
                    }
                }
                stringCard.popluate = function (fi, result) {
                    var items;
                    if (result != null && result.items != null) {
                        items = result.items;
                    } else {
                        items = fi.items;
                    }
                    groupStringList.clear();
                    groupResultList.clear();
                    groupStringList.popData(items);
                    groupStringList.__setSelectedIndex4Drag__(0);
                    searchValue.setValue('')
                    //֪ͨsearchValueˮӡҪ
                    searchValue.editComp.trigger('blur');
                    stringField.doLayout();
                    $('ul', stringTable).sortable("option", "connectWith", 'ul');
                }
                this.groupCard[0] = numberCard;
                this.groupCard[1] = dateCard;
                this.groupCard[2] = stringCard;
                this.groupDialog.element.addClass('fr-user-select-disable');
            }
            $.each(this.groupCard, function (idx, item) {
                if (idx === type) {
                    this.show();
                    self.groupDialog.doResize(this.give);
                    this.popluate(cur_fi, listItem);
                } else {
                    this.hide();
                }
            })
            this.groupDialog.setVisible(true);
        },

        popFilterPane:function (cur_fi) {
            var ro = cur_fi;
            if (!ro) {
                FR.Msg.toast('Unknown Error.');
                return;
            }

            if (!this.dialog) {
                this.filterPane = $("<div/>").css("width", 300).css("height", 'auto');
                this.formulaPane = this.filterFace.getContent().appendTo(this.filterPane);

                var self = this;
                var save_table = $('<table cellpadding="0" cellspacing="0" border="0" style="width:100%;height:100%"><colgroup><col width="260"/><col width="70"/><col width="70"/></colgroup></table>');
                tr = $('<tr>').appendTo(save_table);
                td = $('<td  colspan="3">').appendTo(tr);
                td.append(this.filterPane);

                tr = $('<tr>').appendTo(save_table);
                td = $('<td>').appendTo(tr);
                td = $('<td>').appendTo(tr);
                new FR.Button({
                    text:FR.i18nText("OK"),
                    width:60,
                    render:false,
                    renderEl:$("<div/>").appendTo(td),
                    handler:function () {
                    	var compare = self.filterFace.createCompare();
                    	if (compare.value == "" && compare.value !== 0) {
                    		FR.Msg.toast('Ϊ');
                    		return;
                    	}
                        self.doFilter(false);
                        self.dialog.setVisible(false);
                    }
                });
                td = $('<td>').appendTo(tr);
                new FR.Button({
                    text:FR.i18nText("Cancel"),
                    width:60,
                    render:false,
                    renderEl:$("<div/>").appendTo(td),
                    handler:function () {
                        self.dialog.setVisible(false);
                    }
                });

                var o = {
                    title:'',
                    width:450,
                    height:160,
                    contentHtml:save_table
                };

                this.dialog = new FR.Dialog(o);
            }
            var filter = this.contextMenu._getFilterFromParent(cur_fi.cef);
            var compare = filter && filter.info ? FR.jsonDecode(filter.info).compare : null;
            this.filterFace.popCompare(compare);
            this.dialog.setVisible(true);       
			this.dialog.doResize();
        },

        doFilter:function (islist, clearCompare) {
            var $cell = $(this.currentTDCell);
            var cef = $cell.attr('cef');
            var ro = this.fiArray[cef];
            if (!ro) {
                FR.Msg.toast('Unknown Error.');
                return;
            }

            if (clearCompare) {
                this.transInfo(false, null);
                return;
            }
            var filter = this.contextMenu._getFilterFromParent(cef);
            var at = filter && (filter.at || filter.at === 0) ? filter.at : parseInt($cell.attr("at"));
            var ast = filter && (filter.ast || filter.ast === 0) ? filter.ast : parseInt($cell.attr("ast"));
            if (islist) {
                var result = [];
                var filterList = [];
                $.each(this.contextMenu.curLP.elArray, function (idx, it) {
                    var value = it.options.it;
                    if (!it.selected()) {
                        result.push(value.text);
                    }
                    filterList.push(value);
                });
                if (result.length > 0) {
                    this.transInfo(true, FR.jsonEncode(result), filterList, at, ast);
                } else {
                    //
                    this.transInfo(false, null);
                }
            } else {
                var result = {};
                var filterList = [];
                var curLP = this.contextMenu.curLP;
                if (curLP && curLP.elArray) {
	                $.each(curLP.elArray, function (idx, it) {
	                    filterList.push(it.options.it);
	                })
                }
                var compare = this.filterFace.createCompare();
                result.compare = compare;
                this.transInfo(false, FR.jsonEncode(result), filterList, at, ast);
            }
        },

        transInfo:function (islist, info, filterList, at, ast) {
            var o = {
                overlay_immediately:true,
                text:"..."
            };
            FR.showLoadingDialog(o);
            var postInfo = {
                filter:{
                    islist:islist,
                    info:info,
                    filterList:filterList,
                    at:at,
                    ast:ast
                }
            };
            this.setReportOptions(postInfo);
            FR.hideLoadingDialog();
        },

        filterFace:{
            _init:function () {
                this.content = $('<div/>').addClass('fr-adanaly-fileterface');
                this.content.append(this.createDesignTable());
            },

            getContent:function () {
                if (!this.content) {
                    this._init();
                }
                return this.content;
            },

            createDesignTable:function () {
                var table = $('<table/>').addClass('fr-adanaly-filterface-table');
                table.append(this.generateExplanTR());
                table.append(this.generateFilterTR());
                return table;
            },

            generateExplanTR:function () {
                return $('<tr/>')
                    .append($('<td/>').text(':'))
                    .append($('<td/>').text(':'))
                    .append($('<td/>').text('ֵ:'))
                    .append($('<td/>'));
            },

            generateFilterTR:function () {
                return $('<tr/>')
                    .append($('<td/>').append(this.generateOPCombo()))
                    .append($('<td/>').append(this.generateTypeCombo()))
                    .append($('<td/>').append(this.valuePane.getContent()))
            },

            generateOPCombo:function () {
                var config = {
                    type:"combo",
                    width:120,
                    height:20,
                    popupWidth:120,
                    directEdit:false,
                    allowBlank:true,
                    mode:'local'
                };
                config.items = this.opData();
                var combo = $('<div/>');
                this.opCombo = combo.asComponent(config);
                return combo;
            },

            opData:function () {
                var item = [];
                item.push({text:FR.i18nText("ConditionB-equals"), value:0});
                item.push({text:FR.i18nText("ConditionB-does_not_equal_to"), value:1});
                item.push({text:FR.i18nText("ConditionB-is_greater_than"), value:2});
                item.push({text:FR.i18nText("ConditionB-is_greater_than_or_equal_to"), value:3});
                item.push({text:FR.i18nText("ConditionB-is_less_than"), value:4});
                item.push({text:FR.i18nText("ConditionB-is_less_than_or_equal_to"), value:5});
                item.push({text:FR.i18nText("ConditionB-begins_with"), value:6});
                item.push({text:FR.i18nText("ConditionB-does_not_begin_with"), value:7});
                item.push({text:FR.i18nText("ConditionB-ends_with"), value:8});
                item.push({text:FR.i18nText("ConditionB-does_not_end_with"), value:9});
                item.push({text:FR.i18nText("ConditionB-contains"), value:10});
                item.push({text:FR.i18nText("ConditionB-does_not_contain"), value:11});
                item.push({text:FR.i18nText("ConditionB-in"), value:12});
                item.push({text:FR.i18nText("ConditionB-does_not_in"), value:13});
                return item;
            },

            generateTypeCombo:function () {
                var listener = {};
                var self = this;
                listener.eventName = FR.Events.AFTEREDIT;
                listener.action = function () {
                    self.valuePane.showTypePane(self.typeCombo.getValue());
                };
                var config = {
                    type:"combo",
                    width:120,
                    height:20,
                    popupWidth:120,
                    directEdit:false,
                    allowBlank:true,
                    mode:'local',
                    listeners:[listener]
                };
                config.items = this.typeData();
                var combo = $('<div/>');
                this.typeCombo = combo.asComponent(config);
                return combo;
            },

            typeData:function () {
                var item = [];
                item.push({text:FR.i18nText("Parameter-String"), value:'string'});
                item.push({text:FR.i18nText("Number"), value:'number'});
                item.push({text:FR.i18nText("Date"), value:'date'});
                return item;
            },

            valuePane:{
                _init:function () {
                    this.content = $('<div/>');
                    this.content.append(this.generateText())
                        .append(this.generateNumber())
                        .append(this.generateDate());
                },

                getContent:function () {
                    if (!this.content) {
                        this._init();
                    }
                    return this.content;
                },

                generateText:function () {
                    var config = {type:"text"};
                    config.disabled = false;
                    var text = $('<div/>');
                    this.text = text.asComponent(config);
                    this.text.setVisible(false);
                    return text;
                },

                generateNumber:function () {
                    var config = {type:"number"};
                    config.disabled = false;
                    var number = $('<div/>');
                    this.number = number.asComponent(config);
                    this.number.setVisible(false);
                    return number;
                },

                generateDate:function () {
                    var config = {type:"datetime"};
                    config.directEdit = true;
                    var date = $('<div/>');
                    this.date = date.asComponent(config);
                    this.date.setVisible(false);
                    return date;
                },

                showTypePane:function (type) {
                    //b:0-string, 1-number, 2-date
                    if (type == "string") {
                        this.text.setVisible(true);
                        this.number.setVisible(false);
                        this.date.setVisible(false);
                    } else if (type == "number") {
                        this.text.setVisible(false);
                        this.number.setVisible(true);
                        this.date.setVisible(false);
                    } else if (type == "date") {
                        this.text.setVisible(false);
                        this.number.setVisible(false);
                        this.date.setVisible(true);
                    } else {
                        this.text.setVisible(false);
                        this.number.setVisible(false);
                        this.date.setVisible(false);
                    }
                },

                getValue:function () {
                    if (this.text.isVisible()) {
                        return this.text.getValue();
                    } else if (this.number.isVisible()) {
                        return this.number.getValue();
                    } else if (this.date.isVisible()) {
                        return this.date.getValue();
                    }
                },

                setTypeAndValue:function (type, value) {
                    this.showTypePane(type);
                    this.text.setValue('');
                    this.number.setValue('');
                    if (type == "string") {
                        this.text.setValue(value);
                    } else if (type == "number") {
                        this.number.setValue(value);
                    } else if (type == "date") {
                        this.date.setValue(value);
                    }
                },

                getType:function () {
                    if (this.text.isVisible()) {
                        return "string";
                    } else if (this.number.isVisible()) {
                        return "number";
                    } else if (this.date.isVisible()) {
                        return "date";
                    }
                }
            },

            popCompare:function (compare) {
                if (compare == null) {
                    this.opCombo.setValue('');
                    this.typeCombo.setValue('');
                    this.valuePane.setTypeAndValue('', null);
                } else {
                    if (compare.op != null) {
                        this.opCombo.setValue(compare.op);
                    } else {
                        this.opCombo.setValue(-1);
                    }
                    this.typeCombo.setValue(compare.type);
                    this.valuePane.setTypeAndValue(compare.type, compare.value);
                }
            },

            createCompare:function () {
                var compare = {};
                compare.op = this.opCombo.getValue();
                compare.type = this.valuePane.getType();
                compare.value = this.valuePane.getValue();
                return compare;
            }
        },

        /*
         * һTDColumnRowString
         */
        cut2ColumnRowString:function (td) {
            if (td == null) {
                return null;
            }

            var iid = $(td).attr("id");
            return iid.substring(0, iid.length - ('-' + this.idx).length - ('-' + this.tableID).length)
        },

//        setCellShowValue : function(cellInfo, value) {
//        	if (cellInfo && cellInfo.cell) {
//        		cellInfo.cell.cv = value;
//        		// ԶʽҲˣҪʱrecalculateʱ
//        		cellInfo.cell.dirty = true;
//        	}
//        },

        getCellRealValue:function (cellInfo) {
            if (cellInfo == null) {
                return null;
            }
            return cellInfo.textContent ? cellInfo.textContent : cellInfo.innerText;
        },

        setCellValue:function (cell, value) {
            if (cell.id) {
                //title
                var config = {};
                if (cell.id.startWith("A1-")) {
                    config = { titleValue:value};
                    cell.textContent = value;
                } else if (cell.id.startWith("A2-")) {
                    config = {subTitleValue:value};
                    cell.textContent = value;
                }
                this.setReportOptions(config);
            }
        },

        stopCellEditing:function () {
            if (this.editorEl != null) {
                this.$editor.hide();
            }

            if (this.cellEditing != null) {
                var value = this.editorEl.val();
                value = $.trim(value);
                this.setCellValue(this.cellEditing, value);
                this.shrink2FitRowHeight(this.cellEditing);
            }

            this.cellEditing = null;

            this.editorEl.val('');

            return true;
        },

        shrink2FitRowHeight:function (tdCell) {
            // и, ݹŴӣҪи
            var tr = $(tdCell).parent();
            tr.height(32);
        },

        editTDCell:function (tdCell) {
            //alex:must be TD; check out if the cell in editing; check out editable
            if (this.cellEditing && tdCell == this.cellEditing) {
                return;
            }

            this.stopCellEditing();

            /*
             * ȡñ༭Ҫ༭
             * ҵ˳Ϊ
             * fm(formula) -> cv(Cell.Value) -> text(TD.text())
             * ༭͵Ļ,Ҫתֵ(TODO ǷԿǰתŵ༭ڲȥ)
             */
            var editContent = this.getCellRealValue(tdCell);
            if (editContent == null) {
                editContent = tdCell.cell.text()
            }
            var val = editContent;

            if (typeof val == 'string') {
                val = val.replace(/<br>/g, "\n");
            }

            // ȡtr,safarichrometdtopȽңtrĻǱȽһµ
            var $tr = $(tdCell).parent();
            var top = $tr[0].offsetTop - 2;
            var left = tdCell.offsetLeft - 2;

            this.$editor.css({top:top + etadjst, left:left + eladjst});

            var el_width = tdCell.offsetWidth + ewadjst;
            var el_height = tdCell.offsetHeight + ehadjst;
            el_width = el_width > 70 ? el_width + 5 : 75;
            el_height = el_height > 20 ? el_height + 3 : 23;

            this.$editor.css({width:el_width, height:el_height});
            this.editorEl.css({width:el_width, height:el_height});

            this.editorEl.defaultWidth = el_width + 2;

            this.editorEl.val(val);//jamesǰԪı༭Ѿ˵£Ҫֵı༭Ĭֵ

            this.$editor.show();
//            if (!nofocus) {
            // carl:࣬chromeвappendһ£ֻfocusһΣڶα༭ȡ㡣
            if ($.browser.safari || $.browser.chrome) {
                if (this.frozenPane) {
                    this.frozenPane.append(this.$editor);
                } else {
                    this.$sheet_container.append(this.$editor);
                }
            }
            this.editorEl.focus();
//            }
            this.editorEl.valuechange();

            this.cellEditing = tdCell;
        },

        registSelectClass:function () {
            $('td', this.$sheet_container).removeClass('fr-analysis-selected-first').removeClass('fr-analysis-selected-second');
            var self = this;
            $.each(this.currentTDCells, function (idx, item) {
                if (!self.isChartCell(item)) {
                    $('td[cef=' + item + ']', self.$sheet_container).addClass(idx == 0 ? 'fr-analysis-selected-first' : 'fr-analysis-selected-second');
                }
            })
        },

        pushCurrentTDCells:function ($cell, multiSelect) {
            if (!multiSelect || !this.currentTDCells) {
                this.currentTDCells = [];
            }
            var key = $cell.attr('cef');
            var hasValue = false;
            var self = this;
            $.each(this.currentTDCells, function (idx, item) {
                if (item == key) {
                    hasValue = true;
                    if (self.currentTDCells.length > 1) {
                        self.currentTDCells.splice(idx, 1);
                    }
                    return false;
                }
            })
            if (!hasValue) {
                this.currentTDCells.push(key);
            }
            this.registSelectClass();
        },

        /*
         * ѡdom tdCell,ҲǼӸڱ߿,tdCellȷĻʾΧ
         */
        selectTDCell:function (tdCell, multiSelect) {
            if (tdCell) {
                this.stopCellEditing();
                var $cell = $(tdCell);
                this.pushCurrentTDCells($cell, multiSelect);
                this.currentTDCell = tdCell;
                this.setReportcurrentTDCells(this.currentTDCells);
                // ȡtr,safarichrometdtopȽңtrĻǱȽһµ
                var $tr = $cell.parent();
                var $table = $tr.parent().parent();
                var top = $tr[0].offsetTop + $table[0].offsetTop;
                var f_top = top + tadjst;
                var f_left = tdCell.offsetLeft + parseInt($table.css("left")) + ladjst;

                if (tdCell.offsetWidth <= 0 || tdCell.offsetHeight <= 0) {
                    return;
                }

                //alex:ע,fire viewPane.event,this.event
                this.viewPane.fireEvent("cellselect", tdCell);

                var f_width = tdCell.offsetWidth + wadjst + ($.browser.msie ? 0 : 6);
                var f_height = tdCell.offsetHeight + hadjst + +($.browser.msie ? 0 : 6);
                // carl:5
                this.$fD.ftop.css({top:f_top, left:f_left, width:f_width});
                this.$fD.fleft.css({top:f_top + 3, left:f_left, height:f_height - 6});
                this.$fD.fbottom.css({top:f_top + f_height - 3, left:f_left, width:f_width});
                this.$fD.fright.css({top:f_top + 3, left:f_left + f_width - 3, height:f_height - 6});
                this.$fD.fdot.css({top:f_top + f_height - 5, left:f_left + f_width - 5});


                // ҪfDoffsetParentcurrentTDCells.offsetParentͬ
                var $current_offset_c = $(tdCell).parents(".offset-c:eq(0)");
                if ($current_offset_c.length > 0) {
                    // carl:ʱ粻мûҪŶ
                    if (!$current_offset_c.hasClass("frozen-center")) {
                        this.expandmenu_no_scrollable = true;
                    } else {
                        this.expandmenu_no_scrollable = false;
                    }

                    var $last_offset_c = this.$fD.ftop.parents(".offset-c:eq(0)");
                    if ($last_offset_c.length <= 0 || $last_offset_c.attr("class") != $current_offset_c.attr("class")) {
                        // carl:ŪˣһŪȥһж
                        $current_offset_c.append(this.$fD.ftop);
                        $current_offset_c.append(this.$fD.fleft);
                        $current_offset_c.append(this.$fD.fbottom);
                        $current_offset_c.append(this.$fD.fright);
                        $current_offset_c.append(this.$fD.fdot);
                    }
                }

                var self = this;
                if (!this.menuExpand) {
                    this.menuExpand = $('<div/>').addClass('menu-expand').appendTo(this.$sheet_container).click(function (e) {
                        self.popContextMenu();
                        self.menuExpand.hide();

                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    });

                    if (this.$scrollable != this.$container) {
                        self.scroll_with_scrollbox = function (e) {
                            if (self.expandmenu_no_scrollable) {
                                return;
                            }

                            var st = self.$scrollable.scrollTop();
                            var sl = self.$scrollable.scrollLeft();
                            if (self.menuExpand.css('display') != 'none') {
                                var left = parseInt(self.menuExpand.css('left'));
                                var top = parseInt(self.menuExpand.css('top'));
                                top = top + self.st_mark - st;
                                left = left + self.sl_mark - sl;

                                if (self.menuExpandHide == true) {
                                    self.menuExpandHide = false;
                                    top += 9999;
                                }
                                var loffset = 2;
                                if (self.menuExpand.attr('conv') == 'true') {
                                    loffset += 16;
                                }
                                if (top + 2 < self.$scrollable[0].offsetTop || left + loffset < self.$scrollable[0].offsetLeft) {
                                    self.menuExpandHide = true;
                                    top -= 9999;
                                }
                                self.menuExpand.css({top:top, left:left});
                                self.st_mark = st;
                                self.sl_mark = sl;
                            }
                            var c = self.contextMenu.container;
                            if (c && c.css('display') != 'none') {
                                var left = parseInt(c.css('left'));
                                var top = parseInt(c.css('top'));
                                c.css({top:top + self.st_mark - st, left:left + self.sl_mark - sl});
                                self.st_mark = st;
                                self.sl_mark = sl;

                                self.contextMenu.closeSub();
                            }
                        };

                        this.$scrollable.bind('scroll', self.scroll_with_scrollbox);
                    }
                }

                var l = 0;
                var t = 0;
                if ($current_offset_c.length > 0) {
                    l += $current_offset_c[0].offsetLeft;
                    t += $current_offset_c[0].offsetTop;
                }

                var cef = $cell.attr('cef');
                var filter = this.contextMenu._getFilterFromParent(cef)
                if ($cell.attr("at") != null || (filter && filter.at != null)) {
                    var at = filter && (filter.at || filter.at === 0) ? filter.at : parseInt($cell.attr("at"));
                    if (at <= 0) {
                        this.menuExpand.hide();
                    } else {
                        var ast = filter && (filter.ast || filter.ast === 0) ? filter.ast : parseInt($cell.attr("ast"));
                        if (ast >= 0 && ast < 2) {
                            t = f_top + t;
                            l = f_left + f_width + l;

                            this.st_mark = this.$scrollable.scrollTop();
                            this.sl_mark = this.$scrollable.scrollLeft();
                            if (this.$scrollable != this.$container) {
                                t -= this.st_mark;
                                l -= this.sl_mark;
                                // жǷҪ
                                if (l + 180 > this.$sheet_container.width()) {
                                    l -= f_width + 16;
                                    this.menuExpand.attr('conv', 'true');
                                    this.menuExpand.removeClass('menu-expand');
                                    this.menuExpand.addClass('menu-expand-conv');
                                } else {
                                    this.menuExpand.attr('conv', 'false');
                                    this.menuExpand.removeClass('menu-expand-conv');
                                    this.menuExpand.addClass('menu-expand');
                                }
                            } else {
                                // жǷҪ
                                if (l - this.sl_mark + 180 > this.$container.width()) {
                                    l -= f_width + 16;
                                    this.menuExpand.attr('conv', 'true');
                                    this.menuExpand.removeClass('menu-expand');
                                    this.menuExpand.addClass('menu-expand-conv');
                                } else {
                                    this.menuExpand.attr('conv', 'false');
                                    this.menuExpand.removeClass('menu-expand-conv');
                                    this.menuExpand.addClass('menu-expand');
                                }
                            }


                            this.menuExpand.css({top:t, left:l});
                            this.menuExpandHide = false;
                            this.menuExpand.show();
                        } else {
                            this.menuExpand.hide();
                        }
                    }
                } else {
                    this.menuExpand.hide();
                }

                if (FR.isMobile()) {

                } else {
                    // alex:$scrollable
                    $(tdCell).__scroll2View__(this.$scrollable);
                }
            }
        },
        /*
         * 
         * (1,1)
         * ({col:1, row:1})
         * ("B2")
         */
        _get$TDCell:function (col, row) {
            if (row != null) {
                col = {col:col, row:row};
            }
            if (typeof col == 'object') {
                col = FR.columnRow2CellStr(col);
            }

            // alex:̫,ȫȡȻȴthis.$tableȡҪ~~ TODO to find out why~
            // carlȫ֣ѵparameterPaneȥ
            // denny: tracker@953, ȫֱidЧʸߵԭǿֱgetElementById,Ҫ
            var cell = $('#' + col + "-" + this.idx + "-" + this.tableID);
            if (cell == null) {
                cell = $('td[position*=' + '\'' + col + "-" + this.idx + '\']', this.$table);
            }

            return cell;
        },

        getTDCell:function (col, row) { //alex:Դһ{col:1,row:2}"A1",ҲԴ1,2
            var $res = this._get$TDCell(col, row);
            if ($res != null && $res.length > 0) {
                return $res[0];
            }

            return null;
        }
    }
}());
