if (window.FS == null) {
	window.FS = {};
}

FS.TypeFunMap = (function() {
	var nameFunSpace = {};
	return {
		put : function(name, Function) {
			if (!nameFunSpace[name]) {
				nameFunSpace[name] = Function;
			}		
		},
		
		createProcessOb : function(properties) {
			var name = properties.type;
			if (name == null) {
				throw Error("Need Type!");
			}
			if (!nameFunSpace[name]) {
				throw Error("No Function typed" + name + "!");
			}
			return new nameFunSpace[name](properties);
		}
	};
})();

FS.getPosition = function(e) {
	if (e.offsetX != null) {
		return {
			x : e.offsetX,
			y : e.offsetY
		}
	} else if (e.layerX != null) {
		return {
			x : e.layerX,
			y : e.layerY
		}
	}
},


FS.ProcessColor = {
	activedPointColor : '#66FF66',
	
	forbiddenColor : 'red',
	
	borderStartColor : 'silver',
	
	borderStopColor : 'gray',
	
	normalBackground : '#FFFFE0',
	
	rectBackground : '#DAE4F1',
	
	transitionCircle : '#4195C8',
	
	transitionCircleBG : '#DEF1FD'
};

FS.ProcessStyle = {
	type1 : {
		width : 80,
		height : 45,
		radius : 22.5,
		widthScale : 1.4,
		heightScale : 1.6,
		fontSize : 12
	},
	
	type2 : {
		width : 80,
		height : 60,
		radius : 30,
		widthScale : 1.4,
		heightScale : 1.4,
		fontSize : 12
	}
};

FS.ProcessMananger = (function() {
	var allprocess = {};
	var activeprocess = null;
	var allprocessname = [];
	return {
		getActiveProcess : function() {
			return activeprocess;
		},
		
		setActiveProcess : function(process) {
			activeprocess = process;
			if (!allprocess[process.name]) {
				this.addProcess(process);
			}
		},
		
		isRepeatName : function(name) {
			return allprocess[process.name] != null;
		},
		
		addProcess : function(process) {;
			allprocess[process.name] = process;
		},
		
		removeProcess : function(name) {
			if (activeprocess.name == name) {
				activeprocess = null;
			}
			delete allprocess.name;
		},
		
		getProcessByName : function(name) {
			return allprocess[name];
		},
		
		getNewProcess : function(name) {
			var name = name != null ? name : this.createUnRepeatName();
			allprocess[name] = new FS.ProcessDefine({
				name : name
			});
			allprocessname.push(name);
			return allprocess[name];
		},
		
		createUnRepeatName : function(name) {
			if(allprocessname.length === 0) {
				return FR.i18nText("WF-Process")+"1";
			}
			if (name == null) {
				name = FR.i18nText("WF-Process");
			}
			for(var i = 1; i < 1000; i ++) {
				var tempname = name + i;
				for(var m = 0; m < allprocessname.length; m ++) {
					if(allprocessname[m] == tempname) {
						break;
					}
					if((m == allprocessname.length-1) && (allprocessname[m] != tempname)) {
						return tempname;
					}
				}
			}
		},
		
		clear : function() {
			allprocess = {};
			activeprocess = null;
		},
		
		addProcessName : function(name) {
			allprocessname.push(name);
		}
	};
})();


FS.UndoManager = function() {
	this.init();
}

$.extend(FS.UndoManager.prototype, {
	init : function() {
		this.unObs = [];
		this.currentIndex = 0;
		//this.finished = true;
	},
	
	canUndo : function() {
		return this.unObs.length > 0 && this.currentIndex <= this.unObs.length && this.currentIndex > 0;
	},
	
	canRedo : function() {
		return this.unObs.length > 0 && this.currentIndex < this.unObs.length && this.currentIndex > -1;
	},
	
	undo : function() {
		var cu = this.getCurrentUnOb();
		if (cu) {
			cu.undo();
		}
		this.currentIndex--;
	},
	
	redo : function() {
		var cr = this.getCurrentReOb();
		if (cr) {
			cr.redo();
		}
		this.currentIndex++;
	},
	
	getCurrentUnOb : function() {
		return this.unObs[this.currentIndex - 1];
	},
	
	getCurrentReOb : function() {
		return this.unObs[this.currentIndex];
	},
	
	//b:˹addպunobs,dead
	addUnOb : function(unob) {
		if (unob == null) {
			return;
		}
		if (this.unObs.length > 0 && this.currentIndex != this.unObs.length) {
			this.unObs.splice(this.currentIndex);
		}
		this.unObs.push(unob);
		this.currentIndex++;
	}
});



FS.UnOb = function() {
	this.init.apply(this, arguments);
};

$.extend(FS.UnOb.prototype, {
	init : function() {},
	
	undo : function() {},
	
	redo : function() {}
});

FS.SetNameUnOb = FS.extend(FS.UnOb, {
	init : function(processob, name) {
		this.scope = processob;
		this.oldname = name;
		this.newname = processob.getName();
	},
	
	undo : function() {
		this.scope.name = this.oldname;
	},
	
	redo : function() {
		this.scope.name = this.newname;
	}
});

FS.TaskAddConditionUnOb = FS.extend(FS.UnOb, {
	init : function(task, condition) {
		this.scope = task;
		this.condition = condition;
	},
	
	undo : function() {
		this.scope._removeCondition(this.condition);
	},
	
	redo : function() {
		this.scope._addCondition(this.condition);
	}
});

FS.TaskRemoveConditionUnOb = FS.extend(FS.UnOb, {
	init : function(task, condition) {
		this.scope = task;
		this.condition = condition;
	},
	
	undo : function() {
		this.scope._addCondition(this.condition);
	},
	
	redo : function() {
		this.scope._removeCondition(this.condition);
	}
});

FS.TaskEditConditionUnOb = FS.extend(FS.UnOb, {
	init : function(task, condition, oldcondition) {
		this.scope = task;
		this.oldcondition = oldcondition;
		this.newcondition = condition;
	},
	
	undo : function() {
		this.scope.conditiontransitions[this.scope.indexOf(this.newcondition)] = this.oldcondition;
	},
	
	redo : function() {
		this.scope.conditiontransitions[this.scope.indexOf(this.oldcondition)] = this.newcondition;
	}
});

FS.SetReportUnOb = FS.extend(FS.UnOb, {
	init : function(task, reportname) {
		this.scope = task;
		this.oldname = reportname;
		this.newname = task.getForm();
	},
	
	undo : function() {
		this.scope.form = this.oldname;
	},
	
	redo : function() {
		this.scope.form = this.newname;
	}
});

FS.SetJoinModeUnOb = FS.extend(FS.UnOb, {
	init : function(task, joinmode) {
		this.scope = task;
		this.oldmode = joinmode;
		this.newmode = task.getJoinMode();
	},
	
	undo : function() {
		this.scope.joinmode = this.oldmode;
	},
	
	redo : function() {
		this.scope.joinmode = this.newmode;
	}
});

FS.SetTaskUserUnOb = FS.extend(FS.UnOb, {
	init : function(task, taskuser) {
		this.scope = task;
		this.olduser = taskuser;
		this.newuser = task.getUsers();
	},
	
	undo : function() {
		this.scope.users = this.olduser;
	},
	
	redo : function() {
		this.scope.users = this.newuser;
	}
});

FS.SetSubNameUnOb = FS.extend(FS.UnOb, {
	init : function(task, subname) {
		this.scope = task;
		this.oldsubname = subname;
		this.newsubname = task.getSubName();
	},
	
	undo : function() {
		this.scope.subname = this.oldsubname;
	},
	
	redo : function() {
		this.scope.subname = this.newsubname;
	}
});



FS.ProcessAddTaskUnOb = FS.extend(FS.UnOb, {
	init : function(process, task) {
		this.scope = process;
		this.task = task;
	},
	
	undo : function() {
		this.scope._removeTask(this.task);
	},
	
	redo : function() {
		this.scope._addTask(this.task);
	}
});

FS.ProcessRemoveTaskUnOb = FS.extend(FS.UnOb, {
	init : function(process, task) {
		this.scope = process;
		this.task = task;
	},
	
	undo : function() {
		this.scope._addTask(this.task);
	},
	
	redo : function() {
		this.scope._removeTask(this.task);
	}
});

FS.TaskMoveUnOb = FS.extend(FS.UnOb, {
	init : function(task, point) {
		this.scope = task;
		this.point = point;
	},
	
	undo : function() {
		this.scope.centerPoint = this.point;
	},
	
	redo : function() {
		this.scope.centerPoint = this.point;
	}
});

FS.TaskAddTransitionUnOb = FS.extend(FS.UnOb, {
	init : function(task, transition) {
		this.scope = task;
		this.transition = transition;
	},
	
	undo : function() {
		this.scope._removeTransition(this.transition);
	},
	
	redo : function() {
		this.scope._addTransition(this.transition);
	}
});

FS.TaskRemoveTransitionUnOb = FS.extend(FS.UnOb, {
	init : function(task, transition) {
		this.scope = task;
		this.transition = transition;
	},
	
	undo : function() {
		this.scope._addTransition(this.transition);
	},
	
	redo : function() {
		this.scope._removeTransition(this.transition);
	}
});

FS.ProcessExpandAreaUnOb = FS.extend(FS.UnOb, {
	init : function(process, direct) {
		this.scope = process;
		this.direct = direct;
	},
	
	undo : function() {
		this.scope.collapseArea(this.direct);
	},
	
	redo : function() {
		this.scope.expandArea(this.direct);
	}
});

FS.TriggerUnOb = FS.extend(FS.UnOb, {
	init : function(process, oldtrigger) {
		this.scope = process;
		this.oldtrigger = oldtrigger;
		this.newtrigger = process.trigger;
	},
	
	undo : function() {
		this.scope.trigger = this.oldtrigger;
	},
	
	redo : function() {
		this.scope.trigger = this.newtrigger;
	}
});

FS.ParameterUnOb = FS.extend(FS.UnOb, {
	init : function(process, oldparameters) {
		this.scope = process;
		this.oldparameters = oldparameters;
		this.newparameters = process.parameters;
	},
	
	undo : function() {
		this.scope.parameters = this.oldparameters;
	},
	
	redo : function() {
		this.scope.parameters = this.newparameters;
	}	
});

FS.CenterPointUnOb = FS.extend(FS.UnOb, {
	init : function(task, cp) {
		this.scope = task;
		this.oldcenterpoint = cp;
		this.newcenterpoint = task.centerPoint;
	},
	
	undo : function() {
		this.scope.centerPoint = this.oldcenterpoint;
	},
	
	redo : function() {
		this.scope.centerPoint = this.newcenterpoint;
	}
});

$.extend(FS.Events, {
        PROPERTYCHANGE : 'propertyChange',
        
        PROPERTYADD : 'propertyAdd',
        
        PROPERTYREMOVE : 'propertyRemove',
        
        PROPERTYEDIT : 'propertyEdit',
        
        UNDO : 'undo',
        
        REDO : 'redo',
        
        PROCESSSTARTSAVE : 'startsave',
        
        PROCESSSAVE : 'save',
        
        PROCESSSAVEFINISH : 'savefinish'
    });

FS.ProcessPaintObject = function(properties) {
	this.properties = properties;
	this.init();
}

$.extend(FS.ProcessPaintObject.prototype, {
	init : function() {
		//do nothing
	},
	
	setProperty : function(name, newval, oldval, novalue) {
		if (!novalue) {
			this[name] = newval;
		}
		
		//if (!FR.equals(newval, oldval) || novalue) {
			this.fireEvent(FS.Events.PROPERTYCHANGE, arguments);
		//}
	},
	
	addProperty : function(name, val) {
		this[name].push(val);
		this.fireEvent(FS.Events.PROPERTYADD, arguments);
	},
	
	removeProperty : function(name, val) {
		this[name].remove(val);
		this.fireEvent(FS.Events.PROPERTYREMOVE, arguments);
	},
	
	//b:̫
	editProperty : function(name, val, oldval) {
		if (FR.equals(val, oldval)) {
			return;
		}
		var array = this[name];
		array[array.indexOf(oldval)] = val;
		this.fireEvent(FS.Events.PROPERTYEDIT, arguments);
	},
			
	addEvent : function(name, fun) {
		if (!this.eventManager) {
			this.eventManager = {};
		}
		if (!this.eventManager[name]) {
			this.eventManager[name] = [fun];
		} else {
			this.eventManager[name].unshift(fun);
		}		
	},
	
	addNoRepeatEvent : function(name, fun) {
		if (!this.eventManager) {
			this.eventManager = {};
		}
		this.eventManager[name] = [fun];
	},
	
	removeEvent : function(name) {
		
	},
	
	fireEvent : function(name, scope) {
		if (!this.eventManager || !this.eventManager[name]) {
			return;
		}
		var fns = this.eventManager[name];
		if (scope != null && !$.isArray(scope) && scope.length == null) {
			scope = [scope];
		}
		for (var i = 0, len = fns.length; i < len; i++) {
			fns[i].apply(this, scope);
		}
	},
	
	paint : function(processdefine) {
		//paint state
	}
});

FS.CanvasEvent = FR.extend(FS.ProcessPaintObject, {
	init : function() {
		//do nothing
	},
	
	setMouseOverOb : function(ob) {
		this.mouseOverOb = ob;
	},
	
	getMouseOverOb : function() {
		return this.mouseOverOb;
	},
	
	removeMouseOverOb : function() {
		this.mouseOverOb = null;
	},
	
	setMouseClickOb : function(ob) {
		this.mouseClickOb = ob;
	},
	
	getMouseClickOb : function() {
		return this.mouseClickOb;
	},
	
	removeMouseClickOb : function() {
		this.mouseClickOb = null;
	},
	
	setMouseDragOb : function(ob) {
		this.mouseDragOb = ob;
	},
	
	getMouseDragOb : function() {
		return this.mouseDragOb;
	},
	
	removeMouseDragOb : function() {
		this.mouseDragOb = null;
	},
	
	triggerMouseMove : function(e) {},
	
	triggerMouseOver : function(e) {},
	
	triggerMouseOut : function(e) {},
	
	triggerMouseDown : function(e) {},
	
	triggerMouseUp : function(e) {},
	
	triggerClick : function(e) {},
	
	triggerDoubleClick : function(e) {},
	
	triggerKeyEvent : function(e) {},
	
	triggerDrag : function(e) {},
	
	triggerDrop : function(e) {}
});

FS.ProcessOb = FR.extend(FS.CanvasEvent, {
	init : function() {
		FS.ProcessOb.superclass.init.apply(this, arguments);
		this.parseJSON(this.properties);
		this._initPropertiesChangeEvent();
	},
	
	_initPropertiesChangeEvent : function() {},
	
	setName : function(name) {
		this.setProperty('name', name, this.name);
	},
	
	getName : function() {
		return this.name;
	},
	
	parseJSON : function(properties) {
		if(properties.name) {
			this.setName(properties.name);
		}
		this.setParameters(properties.parameters);
	},
	
	addParameter : function(parameter) {
//		this.parameters.push(parameter);
	},
	
	//b:༭ʱchange
	setParameters : function(parameters) {
		this.setProperty('parameters', parameters, this.parameters);
	},
	
	getParameters : function() {
		return this.parameters;
	},
	
	toJSON : function() {}
});

FS.ProcessDefine = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.ProcessDefine.superclass.init.apply(this, arguments);
		this._initCanvas();
		this._initUndoManager();
//		this._initImg();
	},
	
	_initUndoManager : function() {
		if (this.undoManager) {
			return;
		}
		this.undoManager = new FS.UndoManager();
	},
	
	//b: prototype can add fs.undomanager
	canUndo : function() {
		return this.undoManager.canUndo();
	},
	
	canRedo : function() {
		return this.undoManager.canRedo();
	},
	
	undo : function() {
		if (!this.canUndo()) {
			return;
		}
		this.undoManager.undo();
		this.repaint();
		this.saveProcess();
		this.fireEvent(FS.Events.UNDO);
		//b:Ƚ϶
		if (this.getMouseClickOb()) {
			this.fireEvent("click", this.getMouseClickOb());
		}	
	},
	
	redo : function() {
		if (!this.canRedo()) {
			return;
		}
		this.undoManager.redo();
		this.repaint();
		this.saveProcess();
		this.fireEvent(FS.Events.UNDO);
				if (this.getMouseClickOb()) {
			this.fireEvent("click", this.getMouseClickOb());
		}	
	},
	
	//b:when trigger repaint, to do 
	_initPropertiesChangeEvent : function() {
		this.addEvent(FS.Events.PROPERTYCHANGE, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var proper = arguments[0], nv = arguments[1], ov = arguments[2];
			if (proper == 'name') {
				this.undoManager.addUnOb(new FS.SetNameUnOb(this, ov));
			} else if (proper == 'trigger') {
				this.undoManager.addUnOb(new FS.TriggerUnOb(this, ov));
			} else if (proper == 'parameters') {
				this.undoManager.addUnOb(new FS.ParameterUnOb(this, ov));
			} else if (proper == 'area') {
				this.undoManager.addUnOb(new FS.ProcessExpandAreaUnOb(this, nv));
			} else {
				//b:ߵдܸоŤfireevent
				return;
			}
			this.saveProcess();
			this.fireEvent(FS.Events.UNDO);
		});
		this.addEvent(FS.Events.PROPERTYADD, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var propers = arguments[0], val = arguments[1];
			if (propers == 'tasks') {
				this.undoManager.addUnOb(new FS.ProcessAddTaskUnOb(this, val));
			} else {
				return;
			}
			this.saveProcess();
			this.fireEvent(FS.Events.UNDO);
		});
		this.addEvent(FS.Events.PROPERTYREMOVE, function() {
			if (!arguments || !arguments.length) {
				return;
			}	
			var propers = arguments[0], val = arguments[1];
			if (propers == 'tasks') {
				this.undoManager.addUnOb(new FS.ProcessRemoveTaskUnOb(this, val));
			} else {
				return;
			}
			this.saveProcess();
			this.fireEvent(FS.Events.UNDO);
		});
		this.addEvent(FS.Events.PROCESSSAVE, function() {
			if (FS.Trans.saveProcess) {
				this.id = FS.Trans.saveProcess(this);
			}
		});
	},
	
	
	saveProcess : function() {
		this.fireEvent(FS.Events.PROCESSSTARTSAVE);
		if (this.saveid != null) {
			clearTimeout(this.saveid);
			this.saveid = null;
		}
		var sep = this.sepTime ? this.sepTime : 6000;
		this.saveid = setTimeout(function() {
			this.fireEvent(FS.Events.PROCESSSAVE);
			this.fireEvent(FS.Events.PROCESSSAVEFINISH);
			this.saveid = null;
		}.createDelegate(this), sep);
	},
	
	_initCanvas : function() {
		this.shapeContext = $('canvas#fs_processdesign_shape')[0].getContext("2d");
		this.transitionContext = $('canvas#fs_processdesign_transition')[0].getContext("2d");
		this.nameContext = $('canvas#fs_processdesign_name')[0].getContext("2d");
		this.cellContext = $('canvas#fs_processdesign_cell')[0].getContext("2d");
		this.overContext = $('canvas#fs_processdesign_over')[0].getContext("2d");
		this.stateContext = $('canvas#fs_processdesign_state')[0].getContext("2d");
		this.clickedObj = null;
		this.dragObj = null;
	},
	
	_initImg : function() {
		if ($('#fs_processremoveicon').length > 0) {
			return;
		}
		$('<img/>').attr({'id' : 'fs_processremoveicon', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/nremove.png"}).css('display', 'none').appendTo($('body'));
		$('<img/>').attr({'id': 'fs_circletask', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/circletask.png"}).css('display', 'none').appendTo($('body'));
		$('<img/>').attr({'id': 'fs_recttask', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/recttask.png"}).css('display', 'none').appendTo($('body'));					
	},
	
	resizeCanvas : function(canvas, type) {
		canvas.attr({
			width : this.width,
			height : this.height
		});
		canvas.parent().css({
			width : this.width,
			height : this.height
		});
		var wrap = canvas.parent().parent();
		if(type == "top") {
			wrap.scrollTop(0);
		} else if(type == "left") {
			wrap.scrollLeft(0);
		} else if(type == "right") {
			wrap.scrollLeft(this.width);
		} else if(type == "bottom") {
			wrap.scrollTop(this.height);
		}
	},
		
	setActiveTaskName : function(name) {
		if (!this.getMouseClickOb()) {
			this.getMouseClickOb().setName(name);
			this.repaint();
		}
	},
	
	//b:processdefine
	registerEvent : function() {
		var canvasContent = $('canvas#fs_processdesign_state'), self = this;
		canvasContent.unbind();
		canvasContent.mousemove(function(e) {
			self.triggerMouseMove(e);
		}).mouseover(function(e) {
			self.triggerMouseOver(e);
		}).mouseout(function(e) {
			self.triggerMouseOut(e);
		}).mousedown(function(e) {
			self.triggerMouseDown(e);
		}).mouseup(function(e) {
			self.triggerMouseUp(e);
		}).dblclick(function(e) {
			self.triggerDoubleClick(e);
		}).click(function(e) {
			self.triggerClick(e);
		});

	},
	
	//b:קob߽ʱлӦ
	scrollAllCanvas : function(e) {
		
	},
	
	/**
	 * b:drag in(start,task...drag in canvas)--ӦⲿcanvasʱΪdemoʱ
	 *   ͨƶûǰ¼
	 *   ƶקԺƶ
	 * */
	triggerMouseMove : function(e) {
		e.processdefine = this;
		var oldOb = this.getMouseOverOb();
		if (oldOb && !oldOb.triggerMouseMove(e)) {
//			if (this.getMouseClickOb() == this.getMouseOverOb()) {
//				this.removeMouseClickOb();
//			}
			oldOb.triggerMouseOut(e);
			this.removeMouseOverOb();
		}
		var newOb = this.getMouseOverOb();
		if (oldOb != null && oldOb != newOb) {
			oldOb.triggerMouseOut(e);
			if (newOb) {
				newOb.triggerMouseOver(e);
			}
		}

		if (!newOb && this.tasks){
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				if (this.tasks[i].triggerMouseMove(e)) {
					this.getMouseOverOb().triggerMouseOver(e);			
					break;
				}
			}
		}	

		if (!newOb) {
			var tns = this.getTransitionNames();
			for (var i = 0, len = tns.length; i < len; i++) {
				if (tns[i].triggerMouseMove(e)) {
					this.getMouseOverOb().triggerMouseOver(e);
					break;
				}	
			}			
		}	
		if (this.getMouseDragOb() != null) {
			this.getMouseDragOb().triggerDrag(e, this.getMouseOverOb());
		}
		if (!this.getMouseOverOb() && !this.getMouseDragOb()) {
			var point = FS.getPosition(e);
			if (this.isInExpandArea(point)) {
				this.expandIcons = this.createExpandIcons(point);
				for (var i = 0, len = this.expandIcons.length; i < len; i++) {
					this.expandIcons[i].paint(this.overContext);
				}
			} else {
				this.expandIcons = [];
				this.clearOver();
			}
		}
	},
	
	//b:ԺûĽ߽
	isInExpandArea : function(position) {
		//b:ȡڵdomĽ
		if (!this.indep) {
			this.indep = $('canvas#fs_processdesign_state').parent().parent();
		}
		//b:scrollpane 17px
		var child = $(this.indep.children()[0]);
		var iw = this.indep.width(), cw = child.width(), ih = this.indep.height(),
			ch = child.height();
		var wa = 0, ha = 0;
		if (iw < cw || (ih < ch && iw <= cw + 17)) {
			wa = 20;
		}
		if (ih < ch || (iw < cw && ih <= ch + 17)) {
			ha = 20;
		}
		

		if (position.x <= 20 || position.x >= this.width - 20 - wa || position.y <= 20 || position.y >= this.height - 20 - ha) {
			return true;
		}
		return false;
	},
	
	createExpandIcons : function(point) {
		var icons = [];
		if (!this.indep) {
			return;
		}
		
		var width = this.indep.width(), height = this.indep.height(), top = this.indep.scrollTop(), left = this.indep.scrollLeft();
		var child = $(this.indep.children()[0]);
		var cw = child.width(), ch = child.height();
		var wa = 0, ha = 0;
		if (width < cw || (height < ch && width <= cw + 17)) {
			wa = 20;
		}
		if (height < ch || (width < cw && height <= ch + 17)) {
			ha = 20;
		}
		if (point.x <= 20 || point=='left') {
			icons.push(new FS.ExpandIcon({
				type : 'left',
				factory : this,
				centerPoint : {
					x : left + 10,
					y : top + height/2
				}
			}));
		}
		if ((point.x >= this.width - 20 - wa) || (point=='right')) {
			icons.push(new FS.ExpandIcon({
				type : 'right',
				factory : this,
				centerPoint : {
					x : left + (this.width < width ? this.width : width) - 10 - wa,
					y : top + height/2
				}
			}));			
		}
		if (point.y <= 20 || point=='top') {
			icons.push(new FS.ExpandIcon({
				type : 'top',
				factory : this,
				centerPoint : {
					x : left + width/2,
					y : top + 10
				}
			}));			
		}
		if ((point.y >= this.height - 20) || point=='bottom') {
			icons.push(new FS.ExpandIcon({
				type : 'bottom',
				factory : this,
				centerPoint : {
					x : left + width/2,
					y : top + (this.height < height ? this.height : height) - 10 - ha
				}
			}));			
		}
		return icons;
	},
	
	//b:200, 120
	expand : function(type) {
		this._expand(type);
		this.expandIcons = [];
		this.clearOver();
		this.expandIcons = this.createExpandIcons(type);
		for (var i = 0, len = this.expandIcons.length; i < len; i++) {
			this.expandIcons[i].paint(this.overContext);
		}
		this.setProperty('area', type, type, true);
	},
	
	_expand : function(type, width, height) {
		var width = width != null ? width : 200, height = height != null ? height : 120;
		if (type == "top") {
			this.height = this.height + height;
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				this.tasks[i].centerPoint = this.checkPoint({
					x : this.tasks[i].centerPoint.x,
					y : this.tasks[i].centerPoint.y + height
				});
			}
		} else if (type == "left") {
			this.width = this.width + width;
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				this.tasks[i].centerPoint = this.checkPoint({
					x : this.tasks[i].centerPoint.x + width,
					y : this.tasks[i].centerPoint.y
				});
			}
		} else if (type == "right") {
			this.width = this.width + width;
		} else if (type == "bottom") {
			this.height = this.height + height;
		}
		this.resizeContainer(type);			
	},
	
	collapseArea : function(direct) {
		this._expand(direct, -200, -120);
	},
	
	expandArea : function(direct) {
		this._expand(direct);
	},
	
	triggerMouseOver : function(e) {
		this.registerKeyEvent(e);
	},
	
	triggerMouseOut : function(e) {
		this.clickPoint = null;
		this.expandIcons = null;
		this.removeMouseOverOb();
		this.unregisterKeyEvent();
		this.clearOver();
		if (this.getMouseDragOb()) {
			this.removeMouseClickOb();
			this.removeMouseDragOb();
			this.repaint();
		}	
	},
	
	triggerMouseDown : function(e) {
		this.clickPoint = FS.getPosition(e);
		e.processdefine = this;
//		if (this.getMouseClickOb() && !this.getMouseClickOb().triggerMouseDown(e)) {
//			this.removeMouseClickOb();
//			this.removeMouseDragOb();
//		} else {
//			this.setMouseDragOb(this.getMouseClickOb());
//		}

		if (!this.getMouseDragOb()){
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				if (this.tasks[i] && this.tasks[i].triggerMouseDown(e)) {
					return;
				}
			}
		}	
		
		if (!this.getMouseDragOb()) {
			var tns = this.getTransitionNames();
			for (var i = 0, len = tns.length; i < len; i++) {
				if (tns[i].triggerMouseDown(e)) {
					return;
				}
			}							
		}
		
		if (this.expandIcons && !this.getMouseDragOb()) {
			for (var i = 0, len = this.expandIcons.length; i < len; i++) {
				if (this.expandIcons[i].triggerMouseDown(e)) {
					return;
				}
			}
		}
	},

	
	triggerMouseUp : function(e) {
		e.processdefine = this;
		if (this.getMouseDragOb() != null) {
			if (this.getMouseDragOb() != this.getMouseOverOb()) {
				this.getMouseDragOb().triggerDrop(e, this.getMouseOverOb());				
			}
			
			this.removeMouseDragOb();
		}
		this.clickPoint = null;		
		this.repaint(e);	
	},
	
	triggerClick : function(e) {
		e.processdefine = this;
		//b:name editor blur
		var te = $('div#fs_tasknameeditor'), tt = $('div#fs_transitionnameeditor');
		if (te.length > 0 && te.is(':visible')) {
			te.children().blur();
		} else if (tt.length > 0 && tt.is(':visible')) {
			tt.children().blur();
		}
		if (this.getMouseClickOb() && this.getMouseClickOb().triggerClick(e)) {
			return;
		} else {
			this.removeMouseClickOb();
		}
		if (!this.getMouseClickOb()) {
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				if (this.tasks[i].triggerClick(e)) {
					break;
				}
			}
		}
		this.repaint(e);
		this.fireEvent("click", this.getMouseClickOb());
	},
	
	//b:edit name, only support taskname now
	triggerDoubleClick : function(e) {
		e.processdefine = this;
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			if (this.tasks[i].triggerDoubleClick(e)) {
				return;
			}
		}
		var tns = this.getTransitionNames();
		for (var i = 0, len = tns.length; i < len; i++) {
			if (tns[i].triggerDoubleClick(e)) {
				return;
			}
		}
	},
	
	registerKeyEvent : function() {
		if (!this.keyEvent) {
			this.keyEvent = function(e) {
				this.triggerKeyEvent(e);
			}.createDelegate(this);
		}
		FR.Keys.reg(this.keyEvent);
	},
	
	unregisterKeyEvent : function() {
		if (this.keyEvent) {
			FR.Keys.unreg(this.keyEvent);
		}		
	},
	
	triggerKeyEvent : function(e) {
		e.processdefine = this;
		if (this.stateOb && this.stateOb.triggerKeyEvent(e)) {
			this.clearFore();
			this.repaint();			
		}
	},
	
	triggerDrag : function(e) {
		//do nothing
	},
	
	triggerDrop : function(e) {
		//do nothing
	},
	
	checkStateOb : function(ob) {
		if (this.getMouseOverOb() == ob) {
			this.removeMouseOverOb();
		}
		if (this.getMouseClickOb() == ob) {
			this.removeMouseClickOb();
		}
		if (this.getMouseDragOb() == ob) {
			this.removeMouseDragOb();
		}
	},
	
	//b:ܿ_addtask, _removetask
	addTask : function(task) {
		this.addProperty('tasks', task);
	},
	
	_addTask : function(task) {
		this.tasks.push(task);
	},
	
	removeTask : function(task) {
		this.removeRelativeTransition(task.getName());
		this.removeProperty('tasks', task);
		this.checkStateOb(task);
	},
		
	_removeTask : function(task) {
		this.removeRelativeTransition(task.getName());
		this.tasks.remove(task);
		this.checkStateOb(task);
	},
	
	removeRelativeTransition : function(name) {
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			var transitions = this.tasks[i].transitions;
			if (!transitions || transitions.length === 0) {
				continue;
			}
			//b:ɾtransitionȲǻָ
			for (var j = 0, jen = transitions.length; j < jen; j++) {
				if (transitions[j].getToTaskName() == name) {
					this.tasks[i]._removeTransition(transitions[j]);
				}
			}
		}
	},
	
	getTransitionRepeatLine : function(line, tran) {
		var transitions = this.getTransitions();
		for (var i = 0, len = transitions.length; i < len; i++) {
			if (transitions[i] == tran) {
				continue;
			}
			if (transitions[i].isRepeatLine(line)) {
				return true;
			}
		}
		return 0;
	},
	
	getTransitionBeforeRepeatLine : function(line, tran) {
		var transitions = this.getTransitions(), repeat = 0;
		for (var i = 0, len = transitions.length; i < len; i++) {
			if (transitions[i] == tran) {
				break;
			}
			if (transitions[i].isRepeatLine(line)) {
				repeat++;
			}
		}
		return repeat;
	},
	
	getTask : function(name) {
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			if (this.tasks[i].getName() == name) {
				return this.tasks[i];
			}
		}
	},
	
	addNewTask : function(position, type, e) {
		if (!this.tasks) {
			this.tasks = [];
		}
		var name = this.createCN4Type(type);
		var nt = FS.TypeFunMap.createProcessOb({
			type : type,
			centerPoint : this.createNotRepeatPoint(this.checkPoint(position)),
			processDefine : this,
			name : this.createNotRepeatName4Task(name)
		});
		this.addTask(nt);
		this.repaint(e);
	},
	
	createCN4Type : function(type) {
		var name = 'Active';
		if (type == 'endtask') {
			name = 'End';
		} else if (type == 'formtask') {
			name = 'FormTask';
		} else if (type == 'subprotask') {
			name = 'SubTask';
		} else if (type == 'starttask') {
			name = 'Start';
		}
		return name;
	},
	
	createNotRepeatPoint : function(point) {
		if (this.hasTaskCenter(point)) {
			if (point.x + this.style.width*this.style.widthScale < this.width) {
				point.x = point.x + this.style.width*this.style.widthScale;
			} else {
				point.y = point.y + this.style.height*this.style.heightScale
			}
			return this.createNotRepeatPoint(point);
		}
		return point;
	},
	
	hasTaskCenter : function(center) {
		if (!center) {
			return false;
		}
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			if (FR.equals(this.tasks[i].centerPoint, center)) {
				return true;
			}
		}
		return false;
	},
	
	checkPoint : function(point) {
		var style = this.style;
		var ew = style.width*style.widthScale, eh = style.height*style.heightScale;
		if (point.x % ew != ew/2) {
			point.x = Math.floor(point.x/ew)*ew + ew/2;
		}
		if (point.y % eh != eh/2) {
			point.y = Math.floor(point.y/eh)*eh + eh/2;
		}
		return point;
	},
	
	createNotRepeatName4Task : function(name) {
		if (name == null) {
			name = "ta";
		}
		var num = name.match(/\d+$/);
		var newname = name;
		if (num != null && num[0].length > 0) {
			newname = name.substr(0, name.length - num[0].length);
			num = parseInt(num[0]);
		}
		var repeat = false;
		if (this.tasks) {
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				if (this.tasks[i].getName() == name) {
					name = newname + (num != null ? num + 1 : 1);
					repeat = true;
					break;
				}
			}	
		}

		return repeat ? this.createNotRepeatName4Task(name) : name;
	},
	
	createNotRepeatName4Transition : function(name) {
		if (name == null) {
			name = "FenZhi";
		}
		var num = name.match(/\d+$/);
		var newname = name;
		if (num != null && num[0].length > 0) {
			newname = name.substr(0, name.length - num[0].length);
			num = parseInt(num[0]);
		}
		var repeat = false, transitions = this.getTransitions();
		for (var i = 0, len = transitions.length; i < len; i++) {
			if (transitions[i].getName() == name) {
				name = newname + (num != null ? num + 1 : 1);
				repeat = true;
				break;
			}
		}
		return repeat ? this.createNotRepeatName4Transition(name) : name;
	},
	
	setTrigger : function(trigger) {
		this.setProperty('trigger', trigger, this.trigger);
	},
	
	removeTrigger : function(trigger) {
		this.trigger = null;
	},
	
	getTransitionNames : function() {
		return $.map(this.getTransitions(), function(transition) {
			return transition.nameText;
		});
	},
	
	getTransitions : function() {
		var transitions = [];
		if (this.tasks) {
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				Array.prototype.push.apply(transitions, this.tasks[i].transitions);
			}			
		}

		return transitions;
	},
	
	removeTransition : function(transition) {
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			var transitions = this.tasks[i].transitions;
			if (transitions && transitions.length > 0) {
				for (var j = 0, jen = transitions.length; j < jen; j++) {
					if (transitions[j] == transition) {
						this.tasks[i].removeTransition(transition);
						return;
					}
				}
			}
		}
	},
	
	setShareProcessName : function(shareProcessName) {
		this.setProperty('shareProcessName', shareProcessName, this.shareProcessName);
	},
	
	getShareProcessName : function() {
		return this.shareProcessName;
	},
	
	resizeContainer : function(type) {
		this.resizeCanvas($('canvas#fs_processdesign_shape'), type);
		this.resizeCanvas($('canvas#fs_processdesign_transition'), type);
		this.resizeCanvas($('canvas#fs_processdesign_name'), type);
		this.resizeCanvas($('canvas#fs_processdesign_cell'), type);
		this.resizeCanvas($('canvas#fs_processdesign_over'), type);
		this.resizeCanvas($('canvas#fs_processdesign_state'), type);
	},
	
	parseJSON : function(properties) {
		if (properties.id > -1) {
			this.id = properties.id;
		}
		this.width = properties.width ? properties.width : 900;
		this.height = properties.height ? properties.height : 500;
		
		var tasks = properties.tasks;
		if (properties.style != null) {
			this.style = FS.ProcessStyle["type" + properties.style];
		} else {
			this.style = FS.ProcessStyle.type1;
		}
		if(properties.shareProcessName) {
			this.shareProcessName = properties.shareProcessName; 
		}
		this.tasks = [];
		if (tasks) {
			for (var i = 0, len = tasks.length; i < len; i++) {
				this.addTask(FS.TypeFunMap.createProcessOb($.extend(tasks[i], {
					processDefine : this
				})));
			}
		} 
		else {
			this.addTask(new FS.StartTask({
				processDefine : this,
				centerPoint : {
					x : 40,
					y : 20
				},
				name : this.createCN4Type('starttask')
			}));
		}
		if (properties.trigger) {
			this.trigger = properties.trigger;
		}
		if (properties.name != null) {
			this.name = properties.name;
		}
		if (properties.parameters) {
			this.parameters = properties.parameters;
		} else {
			this.parameters = [];
		}
		if (properties.shareProcessName) {
			this.shareProcessName = properties.shareProcessName;
		}
	},
		
	toJSON : function() {
		var processdefine = {};
		if (this.id != null) {
			processdefine.id = this.id;
		}
		processdefine.name = this.getName();		
		processdefine.width = this.width;
		processdefine.height = this.height;
		if (this.parameters.length > 0) {
			processdefine.parameters = this.getParameters();	
		}
		if(this.itemChanged) {
			processdefine.itemChanged = this.itemChanged;
		}
		if(this.shareProcessName) {
			processdefine.shareProcessName = this.getShareProcessName();
		}
		if (this.trigger) {
			processdefine.trigger = this.trigger;
		}
		if(this.originalShareProcessName) {
			processdefine.originalShareProcessName = this.originalShareProcessName;
		}
		processdefine.tasks = [];
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			processdefine.tasks.push(this.tasks[i].toJSON());
		}
		return processdefine;
	},
	
	//b:Ȼtaskٻtransition
	paint : function(e) {
		this.clearState();	
		
		if (this.tasks != null && this.tasks.length > 0) {
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				this.tasks[i].paint(this);
			}
			this.paintTransitions();
		}
		if (e && !e.processdefine) {
			e.processdefine = this;
		}
		if (this.getMouseOverOb() != null) {
			this.getMouseOverOb().triggerMouseOver(e);
		}
		if (this.getMouseClickOb() != null) {
			//click trigger paint
			this.getMouseClickOb().drawSelectedRect(this);		
		}
		if (this.expandIcons && this.expandIcons.length > 0) {
			for (var i = 0, len = this.expandIcons.length; i < len; i++) {
				this.expandIcons[i].paint(this.overContext);
			}
		}
	},
	
	paintTransitions : function() {
		this.clearTransition();
		var transitions = this.getTransitions();
		for (var i = 0, len = transitions.length; i < len; i++) {
			transitions[i].paint(this);
		} 	
	},
	
	repaint : function(e) {
		this.paint(e);
	},
	
	clearState : function() {
		this.clearBack();
		this.clearTransition();
		this.clearName();
		this.clearCell();
		this.clearOver();
		this.clearFore();
	}, 
	
	clearTransition : function() {
		this.transitionContext.clearRect(0, 0, this.width, this.height);
	},
	
	clearName : function() {
		this.nameContext.clearRect(0, 0, this.width, this.height);
	},
	
	//b: transition to be added
	drawAllName : function() {
		this.clearName();
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			this.tasks[i].drawName(this);
		}
		var tns = this.getTransitionNames();
		for (var i = 0, len= tns.length; i < len; i++) {
			tns[i].paint(this);
		}
	},
	
	drawCell : function() {
		var ctx = this.cellContext;
		ctx.save();
		ctx.lineWidth = 1;
		ctx.strokeStyle = 'gray';
		var ew = this.style.width*this.style.widthScale, eh = this.style.height*this.style.heightScale;
		for (var i = 0, len = Math.floor(this.width/ew); i < len; i++) {
			ctx.beginPath();
			ctx.moveTo((i + 1)*ew, 0);
			ctx.lineTo((i + 1)*ew, this.height);
			ctx.stroke();
			ctx.closePath();
		}
		for (var i = 0, len = Math.floor(this.height/eh); i < len; i++) {
			ctx.beginPath();
			ctx.moveTo(0, (i + 1)*eh);
			ctx.lineTo(this.width,(i + 1)*eh);
			ctx.stroke();
			ctx.closePath();
		}
		ctx.restore();
	},
	
	clearCell : function() {
		this.cellContext.clearRect(0, 0 , this.width, this.height);
	},
	
	clearOver : function() {
		this.overContext.clearRect(0, 0 , this.width, this.height);
	},
	
	clearBack : function() {
		this.shapeContext.clearRect(0, 0 , this.width, this.height);
	},
	
	clearFore : function() {	
		this.stateContext.clearRect(0, 0, this.width, this.height);
	}
});
FS.TypeFunMap.put("processdefine", FS.ProcessDefine);


FS.ProcessTask = FR.extend(FS.ProcessOb, {	
	init : function() {
		FS.ProcessTask.superclass.init.apply(this, arguments);
	},
	
	_initPropertiesChangeEvent : function() {
		this.addEvent(FS.Events.PROPERTYCHANGE, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var proper = arguments[0], nv = arguments[1], ov = arguments[2];
			if (proper == 'name') {
				this.processDefine.undoManager.addUnOb(new FS.SetNameUnOb(this, ov));
			} else if (proper == 'joinmode') {
				this.processDefine.undoManager.addUnOb(new FS.SetJoinModeUnOb(this, ov));
			} else if (proper == 'centerPoint') {
				this.processDefine.undoManager.addUnOb(new FS.CenterPointUnOb(this, ov));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);				
		});
		this.addEvent(FS.Events.PROPERTYADD, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var propers = arguments[0], val = arguments[1];
			if (propers == 'transitions') {	
				this.processDefine.undoManager.addUnOb(new FS.TaskAddTransitionUnOb(this, val));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);	
		});
		this.addEvent(FS.Events.PROPERTYREMOVE, function() {
			if (!arguments || !arguments.length) {
				return;
			}	
			var propers = arguments[0], val = arguments[1];
			if (propers == 'transitions') {
				this.processDefine.undoManager.addUnOb(new FS.TaskRemoveTransitionUnOb(this, val));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);
		});
	},
	
	parseJSON : function(properties) {
		if (properties.processDefine) {
			this.processDefine = properties.processDefine;
			var style = this.processDefine.style;
			this.width = style.width;
			this.height = style.height;
			this.radius = style.radius;
		}
		if (!properties.centerPoint) {
			throw Error("Task Need Position to be created!");
		} else {
			this.centerPoint = this.processDefine.checkPoint(properties.centerPoint);
		}
		if (properties.name != null) {
			this.name = properties.name;
			//b:4 edit
			this.oldname = properties.name;
		}

		var transitions = properties.transitions;
		this.transitions = [];
		if (transitions) {
			for (var i = 0, len = transitions.length; i < len; i++) {
				this._addTransition(new FS.ProcessTransition($.extend(transitions[i], {
					fromTask : this
				})));
			}
		}
		if (properties.joinmode) {
			this.joinmode = properties.joinmode;
		} else {
			this.joinMode = 1;
		}
	},
	
	toJSON : function() {
		var task = {};
		task.name = this.getName();
		if (this.oldname != this.getName()) {
			task.oldname = this.oldname;
		}
		task.type = this.getType();
		task.centerPoint = this.getCenterPoint();
		if (this.getType() != "starttask") {
			task.joinMode = this.joinMode;
		}
		task.transitions = [];
		for (var i = 0, len = this.transitions.length; i < len; i++) {
			task.transitions.push(this.transitions[i].toJSON());
		}
		return task;
	},
	
	removeSelf : function() {
		this.processDefine.removeTask(this);
	},
	
	copySelf : function() {
		var cp = this.getCenterPoint();
		var style = this.processDefine.style;
		var ew = style.width*style.widthScale, eh = style.height*style.heightScale;
		this.processDefine.addTask(FS.TypeFunMap.createProcessOb({
			type : this.getType(),
			name : this.processDefine.createNotRepeatName4Task(this.getName()),
			processDefine : this.processDefine,
			centerPoint : {
				x : cp.x + ew,
				y : cp.y + eh
			}
			}));
	},
	
	getType : function() {
		return "formtask";
	},
	
	getBounds : function() {
		var style = this.processDefine.style;
		return {
			x : this.centerPoint.x - style.width/2,
			y : this.centerPoint.y - style.height/2,
			height : this.height,
			width : this.width
		};
	},
	
	getCenterPoint : function() {
		return this.centerPoint;
	},
	
	setCenterPoint : function(point) {
		this.setProperty('centerPoint', point, this.centerPoint);
	},
	
	addTransition : function(transition) {
		this.addProperty('transitions', transition);
	},
	
	_addTransition : function(transition) {
		this.transitions.push(transition);
	},
	
	removeTransition : function(transition) {
		transition.isActived = false;
		this.removeProperty('transitions', transition);
	},
	
	_removeTransition : function(transition) {
		transition.isActived = false;
		this.transitions.remove(transition);
	},
	
	removeTransitionByName : function(name) {
		for (var i = 0, len = this.transitions.length; i < len; i++) {
			if (this.transitions[i].getName() == name) {
				this.transitions.splice(i, 1);
				break;
			}
		}
	},
	
	setJoinMode : function(joinmode) {
		this.setProperty('joinmode', joinmode, this,joinmode);
	},
	
	getJoinMode : function() {
		return this.joinMode;
	},
	
	toJSONString : function() {
		
	},
	
	paint : function(processdefine) {
		this.drawName(processdefine);
	},
	
	//b:circlerectnameӦǲһģʱôݣҪȷ
	drawName : function(processdefine) {
		if (!this.getName()) {
			return;
		}
		var ctx = processdefine.nameContext;
		ctx.save();

		this.nameText = new FS.Name4Task({
			name : this.getName(),
			bounds : this.getBounds(),
			limitLength : this.getLimitLength4Name(),
			autoLine : 2,
			task : this
		});
		this.nameText.paint(ctx);
		ctx.restore();		
	},
	
	getLimitLength4Name : function() {
		return this.processDefine.style.width - 10;
	},
	
	drawSelectedRect : function(processdefine) {
		var ctx = processdefine.stateContext;
		ctx.save();

		var bounds = this.getBounds();
		this.drawDotLine(ctx, bounds);
		ctx.restore();
	},
	
	//b: 3px
	drawDotLine : function(ctx, bounds) {
		var sep = 3;
		ctx.lineWidth = 1;
		ctx.strokeStyle = '#9C9C9C';
		var wc = Math.ceil(bounds.width/(2*sep)), hc = Math.ceil(bounds.height/(2*sep));
		for (var i = 0, len = wc; i < len; i++) {
			ctx.beginPath();
			ctx.moveTo(bounds.x + i*2*sep, bounds.y);
			if (i == len - 1 && bounds.width - len*2*sep <= sep) {				
				ctx.lineTo(bounds.x + bounds.width, bounds.y);
			} else {
				ctx.lineTo(bounds.x + i*2*sep + sep, bounds.y);
			}
			ctx.stroke();
		}
		for (var i = 0, len = wc; i < len; i++) {
			ctx.beginPath();
			ctx.moveTo(bounds.x + i*2*sep, bounds.y + bounds.height);
			if (i == len - 1 && bounds.width - len*2*sep <= sep) {				
				ctx.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
			} else {
				ctx.lineTo(bounds.x + i*2*sep + sep, bounds.y + bounds.height);
			}
			ctx.stroke();
		}
		for (var i = 0, len = hc; i < len; i++) {
			ctx.beginPath();
			ctx.moveTo(bounds.x, bounds.y + i*2*sep);
			if (i == len - 1 && bounds.height - len*2*sep <= sep) {				
				ctx.lineTo(bounds.x, bounds.y + bounds.height);
			} else {
				ctx.lineTo(bounds.x, bounds.y + i*2*sep + sep);
			}
			ctx.stroke();
		}
		for (var i = 0, len = hc; i < len; i++) {
			ctx.beginPath();
			ctx.moveTo(bounds.x + bounds.width, bounds.y + i*2*sep);
			if (i == len - 1 && bounds.height - len*2*sep <= sep) {				
				ctx.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
			} else {
				ctx.lineTo(bounds.x + bounds.width, bounds.y + i*2*sep + sep);
			}
			ctx.stroke();
		}
	},
	
	isInArea : function(point) {
		var bounds = this.getBounds();
		if (point.x >= bounds.x && point.x - bounds.width <= bounds.x && point.y >= bounds.y && point.y <= bounds.y + bounds.height) {
			return true;
		}
		return false;
	},
	
	
	//b: stateob to supply
	triggerMouseMove : function(e) {
		if (this.stateOb && this.stateOb.triggerMouseMove(e)) {
			return true;
		}
		if (this.isInArea(FS.getPosition(e))) {
			e.processdefine.setMouseOverOb(this);
			return true;
		}
		return false;
	},
	
	triggerMouseOver : function(e) {
		this.stateOb = this.getTaskState();
		this.stateOb.paint(this.processDefine.overContext);
	},
	
	getTaskState : function() {
		return new FS.RectTaskState({
			width : this.width,
			height : this.height,
			centerPoint : this.getCenterPoint(),
			task : this
		});
	},
	
	triggerMouseOut : function(e) {
		if (!this.isInArea(FS.getPosition(e))) {
			this.stateOb = null;
			e.processdefine.clearOver();
		}
	},
	
	triggerMouseDown : function(e) {
		if (this.stateOb && this.stateOb.triggerMouseDown(e)) {
			return true;
		}
		if (this.isInArea(FS.getPosition(e))) {
//			e.processdefine.setMouseClickOb(this);
			e.processdefine.setMouseDragOb(this);
			return true;
		}
		return false;
	},
	
	triggerMouseUp : function(e) {
		//processdefine deal
	},
	
	triggerClick : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			e.processdefine.setMouseClickOb(this);
			this.drawSelectedRect(e.processdefine);
			return true;
		}
		return false;
	},
	
	triggerDoubleClick : function(e) {
		if (this.nameText) {
			return this.nameText.triggerDoubleClick(e);
		}
	},
	
	triggerKeyEvent : function(e) {
		
	},
	
	triggerDrag : function(e) {
		e.processdefine.drawCell();
		var point = this.getCenterPoint();
		if (e.processdefine.clickPoint) {
			point = e.processdefine.clickPoint;
		}
		var bounds = this.getBounds();
		var position = FS.getPosition(e);
		var rp = {
			x : position.x - point.x + bounds.x,
			y : position.y - point.y + bounds.y
		};
		var ctx = e.processdefine.stateContext;
		e.processdefine.clearFore();
		ctx.save();
		ctx.globalAlpha = 0.6;
		this.drawImage(ctx, rp.x, rp.y);
		ctx.restore();			
	},
	
	drawImage : function(ctx, x, y) {
		ctx.lineWidth = 1;
		ctx.strokeStyle = '#E2FC50';
		var bounds = this.getBounds();
		ctx.strokeRect(x, y, bounds.width, bounds.height);
	},
	
	triggerDrop : function(e) {
//		var point = this.getCenterPoint();
//		if (e.processdefine.clickPoint) {
//			point = e.processdefine.clickPoint;
//		}
//		var bounds = this.getBounds();
//		var position = FS.getPosition(e);
//		var rp = {
//			x : position.x - point.x + bounds.x + 20,
//			y : position.y - point.y + bounds.y + 20
//		};
//		this.setCenterPoint(rp);
		var style = this.processDefine.style;
		var ew = style.width*style.widthScale, eh = style.height*style.heightScale;	
		var droppoint = FS.getPosition(e);	
		var np = {
			x : Math.floor(droppoint.x/ew)*ew + ew/2,
			y : Math.floor(droppoint.y/eh)*eh + eh/2
		};
		if (this.processDefine.hasTaskCenter(np)) {
			return;
		}
		this.setCenterPoint(np);
		this.processDefine.repaint();
	}
});

FS.Name4Task = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.Name4Task.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		if (properties.name == null) {
			throw Error("Name can't be null!");
		}
		this.task = properties.task;
		this.name = properties.name;
		this.bounds = properties.bounds;
		this.limitLength = properties.limitLength;
		this.autoLine = properties.autoLine;
		if (!this.autoLine) {
			this.autoLine = 2;
		}
	},
	
	getParent : function() {
		return this.task;
	},
	
	isInArea : function(point) {
		return point.x >= this.bounds.x && point.x - this.bounds.x <= this.bounds.width 
			&& point.y >= this.bounds.y && point.y <= this.bounds.y + this.bounds.height;
	},
	
	//b:scrolltop & scrollleft scroll Ӻ
	triggerDoubleClick : function(e) {
		var position = FS.getPosition(e);
		if (!this.isInArea(position)) {
			return false;
		}
		var os = $('canvas#fs_processdesign_state').offset();
		var nameeditor = $('div#fs_tasknameeditor'), realeditor = nameeditor.children();
		var self = this;
		if (nameeditor.length === 0) {
			realeditor = $('<textarea/>').attr('id', 'fs_tasknamearea').css({
				height : this.bounds.height,
				width : this.bounds.width,
				'font-size' : 12,
				overflow : 'hidden',
				background : FS.ProcessColor.normalBackground
			}).val(this.name);
			$('<div/>').attr('id', 'fs_tasknameeditor').css({
				position : 'absolute',
				top : os.top + this.bounds.y,
				left : os.left + this.bounds.x,
				height : this.bounds.height,
				width : this.bounds.width,
				'z-index' : 100,
				overflow : 'hidden'
			}).append(realeditor).appendTo($('body'));
		} else {
			nameeditor.css({
				top : os.top + this.bounds.y,
				left : os.left + this.bounds.x,
				height : this.bounds.height,
				width : this.bounds.width
			}).show();
			realeditor.css({
				height : this.bounds.height,
				width : this.bounds.width
			});
			realeditor.val(this.name);
		}
		realeditor.focus();
		realeditor.unbind('blur');
		realeditor.blur(function(e) {
				$(this).parent().hide();
				self.getParent().setName($(this).val());
				self.getParent().processDefine.drawAllName();
			})
		return true;
	},
	
	//b:ڱ߾
	paint : function(ctx) {
		ctx.save();
		ctx.font = this.task.processDefine.style.fontSize + "px" + ctx.font.split(/\d+px/)[1];
		var text = this.name;
		var width = ctx.measureText(text).width;
		var realLine = width/this.limitLength;
		if (realLine < this.autoLine) {
			this.realLine = realLine > Math.floor(realLine) ? Math.floor(realLine) + 1 : realLine;
		} else {
			this.realLine = this.autoLine;
		}
		var sep = (this.bounds.width - this.limitLength)/2;
		if (this.realLine === 1) {
			ctx.fillText(text, this.bounds.x + sep + this.bounds.width/2 - width/2, this.bounds.y + this.bounds.height/2 + 4);
		} else {
			var indexs = [0], al = 0;
			for (var i = 0, len = text.length; i < len; i++) {
				if (indexs.length > 2) {
					break;
				}
				al += ctx.measureText(text.charAt(i)).width;
				if (al > this.limitLength) {
					indexs.push(i);
					al = ctx.measureText(text.charAt(i)).width;
				}
			}
			for (var i = 0, len = this.realLine; i < len; i++) {
				ctx.fillText(text.substring(indexs[i], indexs[i + 1] == null ? text.length : ((i === 1 && indexs[i + 1] < text.length) ? indexs[i + 1] - 3 : indexs[i + 1])) + ((i > 0 && indexs[i + 1] < text.length) ? "..." : ""), this.bounds.x + sep, this.bounds.y + this.bounds.height/2 + 12*i, this.limitLength);
			}
		}

		ctx.restore();
	}
});


FS.CircleTask = FR.extend(FS.ProcessTask, {
	init : function() {
		FS.CircleTask.superclass.init.apply(this, arguments);
	},
	
	getBounds : function() {
		return {
			x : this.centerPoint.x - this.radius,
			y : this.centerPoint.y - this.radius,
			height : this.radius*2,
			width : this.radius*2
		};
	},
	
	getLimitLength4Name : function() {
		return this.radius*2 - 6;
	},
	
	getTaskState : function() {
		return new FS.CircleTaskState({
			radius : this.radius,
			centerPoint : this.getCenterPoint(),
			task : this
		});
	},
	
	isInArea : function(point) {
		var center = this.getCenterPoint();
		var xd = point.x - center.x, yd = point.y - center.y;
		return Math.sqrt(xd*xd + yd*yd) <= this.radius; 
	},
		
	paint : function(processdefine) {
		FS.CircleTask.superclass.paint.call(this, processdefine);
		var ctx = processdefine.shapeContext;
		ctx.save();
		ctx.beginPath();
		var point = this.getBounds();
//		var gradient = ctx.createRadialGradient(point.x, point.y, 18, point.x, point.y, 20);
//		var gradient = ctx.createLinearGradient(point.x - 20, point.y - 20, point.x + 20,  point.y - 20);
//		gradient.addColorStop(0, 'silver');
//		gradient.addColorStop(1, 'gray')
//
//		ctx.strokeStyle = gradient;
//		ctx.lineWidth = 2;
//		ctx.fillStyle = FS.ProcessColor.normalBackground;
//		ctx.arc(point.x, point.y, 18, 0, Math.PI*2, false);
//		ctx.stroke();
//		ctx.fill();
		var img = $('img#fs_circletask'), self = this;
		if (img.length === 0) {
			img = $('<img/>').attr({'id': 'fs_circletask', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/circletask.png"}).css('display', 'none').appendTo($('body'));
			var self = this;
			img[0].onload = function() {
				self.drawImage(ctx, point.x, point.y);
				FS.CircleTask.prototype.imageLoaded = true;
			}
		} else {
			if (FS.CircleTask.prototype.imageLoaded) {
				this.drawImage(ctx, point.x, point.y);
			} else {
				var oldonload = img[0].onload;
				img[0].onload = function() {
					oldonload();
					self.drawImage(ctx, point.x, point.y);
				}	
			}
		}
		ctx.closePath();
		ctx.restore();
	},
	
	drawImage : function(ctx, x, y) {
		ctx.drawImage($('img#fs_circletask')[0], x, y, this.radius*2, this.radius*2);
	}
});

FS.ExpandIcon = FR.extend(FS.ProcessOb, {
	width : 16,
	
	init : function() {
		FS.ExpandIcon.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		this.type = properties.type;
		this.centerPoint = properties.centerPoint;
		this.factory = properties.factory;
	},
	
	getFactory : function() {
		return this.factory;
	},
	
	paint : function(ctx) {
		ctx.save();
		var img = $('#fs_processexpandicon' + this.type, 'body');
		var self = this;
		if (img.length === 0) {
			img = $('<img/>').attr({'id' : 'fs_processexpanicon' +  + this.type, 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/expandicon" + this.type + ".png"}).css('display', 'none').appendTo($('body'));
			img[0].onload = function() {
				self.drawImage(ctx, img[0]);
			}
		} else {
			this.drawImage(ctx, img[0]);
		}
		ctx.restore();
	},
	
	drawImage : function(ctx, img) {
		var bounds = {
			x : this.centerPoint.x - this.width/2,
			y : this.centerPoint.y - this.width/2
		};
		ctx.save();
		ctx.drawImage(img, bounds.x, bounds.y, this.width, this.width);
		ctx.restore();
	},
	
	isInArea : function(point) {
		var x = this.centerPoint.x, y = this.centerPoint.y, w = this.width/2;
		if (point.x >= x - w && point.x <= x + w && point.y >= y - w && point.y <= y + w) {
			return true;
		}
		return false;
	},
	
	triggerMouseDown : function(e) {
		var point = FS.getPosition(e);
		if (this.isInArea(point)) {
			this.factory.expand(this.type);	
			return true;
		}
		return false;		
	}
});

FS.RemoveIcon = FR.extend(FS.ProcessOb, {
	radius : 6,
	
	init : function() {
		FS.RemoveIcon.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		this.centerPoint = properties.centerPoint;
		this.factory = properties.factory;
	},
	
	getFactory : function() {
		return this.factory;
	},
	
	paint : function(ctx) {
		ctx.save();
		var img = $('#fs_processremoveicon', 'body');
		var self = this;
		if (img.length === 0) {
			img = $('<img/>').attr({'id' : 'fs_processremoveicon', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/nremove.png"}).css('display', 'none').appendTo($('body'));
			img[0].onload = function() {
				self.drawImage(ctx, img[0]);
				FS.RemoveIcon.prototype.imageLoaded = true;
			}
		} else {
			if (FS.RemoveIcon.prototype.imageLoaded) {
				this.drawImage(ctx, img[0]);
			} else {
				var oldonload = img[0].onload;
				img[0].onload = function() {
					oldonload();
					self.drawImage(ctx, img[0]);
				}	
			}
		}
		ctx.restore();
	},
	
	drawImage : function(ctx, img) {
		var bounds = {
			x : this.centerPoint.x - this.radius,
			y : this.centerPoint.y - this.radius
		};
		ctx.save();
		ctx.drawImage(img, bounds.x, bounds.y, 2*this.radius, 2*this.radius);
		ctx.restore();
	},
	
	highLight : function(ctx) {
		ctx.save();
		var img = $('#fs_processinremoveicon', 'body');
		var self = this;
		if (img.length === 0) {
			img = $('<img/>').attr({'id' : 'fs_processinremoveicon', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/iremove.png"}).css('display', 'none').appendTo($('body'));
			img[0].onload = function() {
				self.drawImage(ctx, this);
			}
		} else {
			self.drawImage(ctx, img[0]);
		}
		ctx.restore();
	},
	
	restore : function(ctx) {
		this.drawImage(ctx, $('#fs_processremoveicon', 'body')[0]);
	},
	
	isInArea : function(point) {
		var cp = this.centerPoint;
		return Math.sqrt((cp.x - point.x)*(cp.x - point.x) + (cp.y - point.y)*(cp.y - point.y)) <= this.radius;
	},
	
	triggerMouseMove : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			e.processdefine.setMouseOverOb(this);
			return true;
		}
		return false;
	},
	
	triggerMouseOver : function(e) {
		this.highLight(e.processdefine.overContext);
		//b:¼עƴ
		if (this.factory.activeFactory) {
			this.factory.activeFactory(e);
		}
	},
	
	triggerMouseOut : function(e) {
		this.restore(e.processdefine.overContext);
		this.getFactory().judgeClear(e);
	},
	
	triggerMouseDown : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			e.processdefine.removeMouseOverOb();
			this.factory.removeSelf(e);	
			return true;
		}
		return false;
	}
});

FS.TaskTransitionOb = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.TaskTransitionOb.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		this.type = properties.type;
		this.centerPoint = properties.centerPoint;
		this.factory = properties.factory;
	},
	
	paint : function(ctx) {
		ctx.save();
		ctx.beginPath();
		ctx.strokeStyle = FS.ProcessColor.transitionCircle;
		ctx.fillStyle = FS.ProcessColor.transitionCircleBG;
		ctx.lineWidth = 2;
		ctx.arc(this.centerPoint.x, this.centerPoint.y, this.radius, 0, 2*Math.PI, false);
		ctx.stroke();
		ctx.fill();
		ctx.restore();
	},
	
	isInArea : function(point) {
		var cp = this.centerPoint;
		return Math.sqrt((point.x - cp.x)*(point.x - cp.x) + (point.y - cp.y)*(point.y - cp.y)) <= this.radius;
	},
	
	getFactory : function() {
		return this.factory;
	},
	
	//bʱһΣ
	highLight : function(ctx) {
		ctx.save();
		ctx.beginPath();
		ctx.strokeStyle = FS.ProcessColor.borderStopColor;
		ctx.fillStyle = FS.ProcessColor.activedPointColor;
		ctx.lineWidth = 2;
		ctx.arc(this.centerPoint.x, this.centerPoint.y, this.radius, 0, 2*Math.PI, false);
		ctx.stroke();
		ctx.fill();
		ctx.restore();
	},
	
	restore : function(ctx) {
		ctx.save();
		ctx.beginPath();
		ctx.strokeStyle = FS.ProcessColor.borderStopColor;
		ctx.fillStyle = FS.ProcessColor.normalBackground;
		ctx.lineWidth = 2;
		ctx.arc(this.centerPoint.x, this.centerPoint.y, this.radius, 0, 2*Math.PI, false);
		ctx.stroke();
		ctx.fill();
		ctx.restore();
	},
	
	triggerMouseMove : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			e.processdefine.setMouseOverOb(this);
			return true;
		}
		return false;
	},
	
	triggerMouseOver : function(e) {
		this.highLight(e.processdefine.overContext);
	},
	
	triggerMouseOut : function(e) {
		this.restore(e.processdefine.overContext);
		this.getFactory().judgeClear(e);
	},
	
	triggerMouseDown : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
//			e.processdefine.setMouseClickOb(this);
			e.processdefine.setMouseDragOb(this);	
			return true;
		}
		return false;
	},
	
	triggerDrag : function(e, overOb) {
		var position = FS.getPosition(e);
		if (!position) {
			return;
		}
		var point = position;

		var center = this.centerPoint;	
		if (e.processdefine.clickPoint) {
			point = e.processdefine.clickPoint;
		}
		var rp = {
			x : position.x - point.x + center.x,
			y : position.y - point.y + center.y
		};
		var ctx = e.processdefine.stateContext;
		e.processdefine.clearFore();
		ctx.fillStyle = FS.ProcessColor.forbiddenColor;
		var ttob = null;
		if (overOb instanceof FS.TaskTransitionOb && overOb.getFactory().task != this.getFactory().task) {
			ctx.fillStyle = FS.ProcessColor.activedPointColor;
			ttob = overOb;
		}
		this.paintLine(ctx, ctx.fillStyle, rp, ttob);
		ctx.save();
		ctx.globalAlpha = 0.4;
		ctx.beginPath();
		ctx.strokeStyle = FS.ProcessColor.borderStopColor;
		
		ctx.arc(rp.x, rp.y, this.radius, 0, 2*Math.PI, false);
		ctx.stroke();
		ctx.fill();
		ctx.restore();
	},
	
	paintLine : function(ctx, color, ep, tasktransitionob) {
		ctx.save()
		ctx.beginPath();
		var ap = [];
		var style = this.factory.task.processDefine.style;
		var ew = style.width*style.widthScale, eh = style.height*style.heightScale;
		var fts = FS.ProcessTransition.prototype.exeTwoPoints4Task(this.getFactory().task, this.type, style),
			lts = [{
				x : ep.x,
				y : ep.y
			}, {
				x : ep.x,
				y : Math.floor(ep.y/eh)*eh
			}];	
		if (tasktransitionob) {
			lts = FS.ProcessTransition.prototype.exeTwoPoints4Task(tasktransitionob.getFactory().task, tasktransitionob.type, style);
		}		
		Array.prototype.push.apply(ap, fts);
		if (fts[1] != lts[1]) {
			var inner = FS.ProcessTransition.prototype.exeInnerPoints(fts[1], lts[1], style);
			Array.prototype.push.apply(ap, inner);
			ap.push(lts[1]);
		}
		
		ap.push(lts[0]);
		ctx.strokeStyle = color;
		for (var i = 0, len = ap.length; i < len; i++) {
			if (i === 0) {
				ctx.moveTo(ap[0].x, ap[0].y);
			} else {
				ctx.lineTo(ap[i].x, ap[i].y);
			}
		}
		ctx.stroke();
		ctx.restore();
	},
	
	triggerDrop : function(e, onOb) {
		if (!onOb || !(onOb instanceof FS.TaskTransitionOb) || this.getFactory().task == onOb.getFactory().task) {
			return;
		}
		var fromtask = this.getFactory().getTask();
		if (fromtask.getType() == 'endtask') {
			return;
		}
		var totask = onOb.getFactory().getTask();
		if (totask.getType() == 'starttask') {
			return;
		}
		fromtask.addTransition(new FS.ProcessTransition({
			name : e.processdefine.createNotRepeatName4Transition(),
			fromTask : fromtask,
			fromPoint : this.type,
			toTask : totask.getName(),
			toPoint : onOb.type
		}));
	}
});

$.extend(FS.TaskTransitionOb.prototype, {
	radius : 6
});

FS.TaskState = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.TaskState.superclass.init.apply(this, arguments);
		this.createTaskTransitionObs();
		this.createRemoveIcon();
	},
	
	parseJSON : function(properties) {
		if (!properties.centerPoint) {
			throw Error("CenterPoint can't be null to create taskstate!");
		}
		this.centerPoint = properties.centerPoint;
		if (properties.radius) {
			this.radius = properties.radius;
		}
		if (properties.width) {
			this.width = properties.width;
		}
		if (properties.height) {
			this.height = properties.height;
		}
		if (properties.task) {
			this.task = properties.task;
		}
	},
	
	createRemoveIcon : function() {
		if (this.task.getType() == "starttask") {
			return;
		}
		this.removeIcon = new FS.RemoveIcon({
			factory : this,
			centerPoint : this.removeCenter()
		});
	},
	
	createTaskTransitionObs : function() {
		var center = this.centerPoint, radius = this.radius;
		this.ttobs = [new FS.TaskTransitionOb({
			centerPoint : {x : center.x, y : center.y - radius},
			type : 'top',
			factory : this
		}), new FS.TaskTransitionOb({
			centerPoint : {x : center.x + radius, y : center.y},
			type : 'right',
			factory : this
		}), new FS.TaskTransitionOb({
			centerPoint : {x : center.x, y : center.y + radius},
			type : 'bottom',
			factory : this
		}), new FS.TaskTransitionOb({
			centerPoint : {x : center.x - radius, y : center.y},
			type : 'left',
			factory : this
		})];
	},
	
	getTask : function() {
		return this.task;
	},
	
	paint : function(ctx) {
		for (var i = 0, len = this.ttobs.length; i < len; i++) {
			this.ttobs[i].paint(ctx);
		}
		if (this.removeIcon) {
			this.removeIcon.paint(ctx);
		}		
	},
	
	isInArea : function(point) {
		return this.task.isInArea(point);
	},
	
	animate : function(ctx) {
		var i = 0;
		var id = setInterval(function() {			
			if (i === 3) {
				clearInterval(id);
			}			
						
		}, 25);
	},
	
	triggerMouseMove : function(e) {
		if (this.ttobs) {
			if (this.removeIcon && this.removeIcon.triggerMouseMove(e)) {
				return true;
			}
			for (var i = 0, len = this.ttobs.length; i < len; i++) {
				if (this.ttobs[i].triggerMouseMove(e)) {
					return true;
				}
			}
		}
		return false;
	},
	
	judgeClear : function(e) {
		if (!this.isInArea(FS.getPosition(e))) {
			this.getTask().stateOb = null;
			e.processdefine.clearOver();
		}
	},
	
	removeSelf : function(e) {
		this.ttobs = null;
		e.processdefine.clearOver();
		e.processdefine.removeTask(this.getTask());
		e.processdefine.repaint();
		return;
	},
	
	triggerMouseDown : function(e) {
		var point = FS.getPosition(e);
		if (this.removeIcon && this.removeIcon.triggerMouseDown(e)) {
			return;
		}
		for (var i = 0, len = this.ttobs.length; i < len; i++) {
			if (this.ttobs[i].triggerMouseDown(e)) {
				return true;
			}
		}

		return false;
	},
	
	triggerDrag : function(e) {
		
	},
	
	triggerDrop : function(e) {
		
	}
});

FS.CircleTaskState = FR.extend(FS.TaskState, {
	init : function() {
		FS.CircleTaskState.superclass.init.apply(this, arguments);
	},
	
	//b:ͼƬϵλãrectͬ
	removeCenter : function() {
		var center = this.centerPoint;
		return {
			x : center.x + Math.sqrt(2)*this.radius/2 - 2,
			y : center.y - Math.sqrt(2)*this.radius/2 + 2
		};
	}
});

FS.RectTaskState = FR.extend(FS.TaskState, {
	init : function() {
		FS.RectTaskState.superclass.init.apply(this, arguments);
	},
	
	removeCenter : function() {
		var center = this.centerPoint;
		return {
			x : center.x + this.width/2 - 2,
			y : center.y - this.height/2 + 2
		};
	},
	
	createTaskTransitionObs : function() {
		var center = this.centerPoint;
		this.ttobs = [new FS.TaskTransitionOb({
			centerPoint : {x : center.x, y : center.y - this.height/2},
			type : 'top',
			factory : this
		}), new FS.TaskTransitionOb({
			centerPoint : {x : center.x + this.width/2, y : center.y},
			type : 'right',
			factory : this
		}), new FS.TaskTransitionOb({
			centerPoint : {x : center.x, y : center.y + this.height/2},
			type : 'bottom',
			factory : this
		}), new FS.TaskTransitionOb({
			centerPoint : {x : center.x - this.width/2, y : center.y},
			type : 'left',
			factory : this
		})];
	}
});

FS.RectangleTask = FR.extend(FS.ProcessTask, {
	init : function() {
		FS.RectangleTask.superclass.init.apply(this, arguments);
	},
	
	paint : function(processdefine) {
		FS.RectangleTask.superclass.paint.call(this, processdefine);
		var ctx = processdefine.shapeContext;
		ctx.save();
		ctx.beginPath();
//		var bounds = this.getBounds();
//		ctx.lineWidth = 2;
//		var x = bounds.x + ctx.lineWidth, y = bounds.y + ctx.lineWidth, height = width = 40 - 2*ctx.lineWidth, arcHeight = arcWidth = 4;
//		var gradient = ctx.createLinearGradient(x , y, x + 20, y);
//		gradient.addColorStop(0, 'silver');
//		gradient.addColorStop(1, 'gray')
//		ctx.strokeStyle = gradient;
//
//		ctx.moveTo(x, y + arcHeight);
//		ctx.lineTo(x, y + height - arcHeight);
//		ctx.quadraticCurveTo(x, y + height, x + arcWidth, y + height);
//		ctx.lineTo(x + width - arcWidth, y + height);
//		ctx.quadraticCurveTo(x + width, y + height, x + width, y + height - arcHeight);
//		ctx.lineTo(x + width, y + arcHeight);
//		ctx.quadraticCurveTo(x + width, y, x + width - arcWidth, y);
//		ctx.lineTo(x + arcWidth, y);
//		ctx.quadraticCurveTo(x, y, x, y + arcHeight);
//		ctx.stroke();
//		ctx.fillStyle = FS.ProcessColor.normalBackground;
//		ctx.fill();
		var bounds = this.getBounds(), self = this;
		var imgtype = this.imgtype ? this.imgtype : 'recttask';
		var img = $('img#fs_' + imgtype);
		if (img.length === 0) {
			img = $('<img/>').attr({'id': 'fs_' + imgtype, 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/" + imgtype + ".png"}).css('display', 'none').appendTo($('body'));
			img[0].onload = function() {
				self.drawImage(ctx, bounds.x, bounds.y);
				FS.RectangleTask.prototype.imageLoaded = true;
			}
		} else {
			if (FS.RectangleTask.prototype.imageLoaded) {
				this.drawImage(ctx, bounds.x, bounds.y);
			} else {
				var oldonload = img[0].onload;
				img[0].onload = function() {
					oldonload();
					self.drawImage(ctx, bounds.x, bounds.y);
				}	
			}
		}
		ctx.closePath();
		ctx.restore();
	},
	
	drawImage : function(ctx, x, y) {
		var img = $('img#fs_' + (this.imgtype ? this.imgtype : 'recttask'))[0];
		ctx.drawImage(img, x, y, this.width, this.height);
	}
});

FS.StartTask = FR.extend(FS.CircleTask, {
	init : function() {
		FS.StartTask.superclass.init.apply(this, arguments);
	},
	
	copySelf : function() {
		//do nothing
	},
	
	getType : function() {
		return "starttask";
	},
	
	paint : function(processdefine) {
		FS.StartTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("starttask", FS.StartTask);

FS.EndTask = FR.extend(FS.CircleTask, {
	init : function() {
		FS.EndTask.superclass.init.apply(this, arguments);
	},
	
	getType : function() {
		return "endtask";
	},
	
	paint : function(processdefine) {
		FS.EndTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("endtask", FS.EndTask);

FS.SubProcessTask = FR.extend(FS.RectangleTask, {
	init : function() {
		FS.SubProcessTask.superclass.init.apply(this, arguments);
		this.setParentName(this.processDefine.properties.name);
	},
	
	_initPropertiesChangeEvent : function() {
		FS.SubProcessTask.superclass._initPropertiesChangeEvent.apply(this, arguments);
		this.addEvent(FS.Events.PROPERTYCHANGE, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var proper = arguments[0], nv = arguments[1], ov = arguments[2];
			if (proper == 'subname') {
				this.processDefine.undoManager.addUnOb(new FS.SetSubNameUnOb(this, ov));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);	
		});
		this.addEvent(FS.Events.PROPERTYADD, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var propers = arguments[0], val = arguments[1];
			if (propers == 'conditiontransitions') {
				this.processDefine.undoManager.addUnOb(new FS.TaskAddConditionUnOb(this, val));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);	
		});
		this.addEvent(FS.Events.PROPERTYREMOVE, function() {
			if (!arguments || !arguments.length) {
				return;
			}	
			var propers = arguments[0], val = arguments[1];
			if (propers == 'conditiontransitions') {
				this.processDefine.undoManager.addUnOb(new FS.TaskRemoveConditionUnOb(this, val));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);	
		});
		this.addEvent(FS.Events.PROPERTYEDIT, function() {
			if (!arguments || !arguments.length) {
				return;
			}	
			var propers = arguments[0], val = arguments[1], oldval = arguments[2];
			if (propers == 'conditiontransitions') {
				this.processDefine.undoManager.addUnOb(new FS.TaskEditConditionUnOb(this, val, oldval));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);							
		});
	},
	
	parseJSON : function(properties) {
		FS.SubProcessTask.superclass.parseJSON.call(this, properties);
		if (properties.subname != null) {
			this.subname = properties.subname;
		}
		if(properties.parentname != null) {
			this.parentname = properties.parentname;
		}
		if (properties.conditiontransitions) {
			this.conditiontransitions = properties.conditiontransitions;
		} else {
			this.conditiontransitions = [];
		}
		this.imgtype = 'subprotask';
	},
	
	toJSON : function() {
		var subtask = FS.SubProcessTask.superclass.toJSON.apply(this, arguments);
		subtask.subname = this.subname;
		subtask.parentname = this.parentname;
		subtask.conditiontransitions = this.getTriggerTransition();
		return subtask;
	},
		
	setSubName : function(subname) {
		this.setProperty('subname', subname, this.subname);
	},
	
	getSubName : function() {
		return this.subname;
	},
	
	setParentName : function(parentname) {
		this.setProperty('parentname', parentname, this.parentname);
	},
	
	getParentName : function() {
		return this.parentname;
	},
	
	addCondition : function(condition) {
		this.addProperty('conditiontransitions', condition);
	},
	
	_addCondition : function(condition) {
		this.conditiontransitions.push(condition);
	},
	
	editCondition : function(condition, oldcondition) {
		this.editProperty('conditiontransitions', condition, oldcondition);
	},
	
	removeCondition : function(condition) {
		this.removeProperty('conditiontransitions', condition);
	},
	
	_removeCondition : function(condition) {
		this.conditiontransitions.remove(condition);
	},
	
	setTriggerTransition : function(triggertransitions) {
		this.conditiontransitions = triggertransitions;
	},
	
	getTriggerTransition : function() {
		return this.conditiontransitions;
	},
	
	getType : function() {
		return "subprotask";
	},
	
	paint : function(processdefine) {
		FS.SubProcessTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("subprotask", FS.SubProcessTask);

FS.FormTask = FR.extend(FS.RectangleTask, {
	init : function() {
		FS.FormTask.superclass.init.apply(this, arguments);
	},
	
	_initPropertiesChangeEvent : function() {
		FS.FormTask.superclass._initPropertiesChangeEvent.apply(this, arguments);
		this.addEvent(FS.Events.PROPERTYCHANGE, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var proper = arguments[0], nv = arguments[1], ov = arguments[2];
			if (proper == 'form') {
				this.processDefine.undoManager.addUnOb(new FS.SetReportUnOb(this, ov));
			} else if (proper == 'users') {
				this.processDefine.undoManager.addUnOb(new FS.SetTaskUserUnOb(this, ov));
			} else {
				return;
			}
			this.processDefine.saveProcess();
			this.processDefine.fireEvent(FS.Events.UNDO);	
		});
	},
	
	parseJSON : function(properties) {
		FS.FormTask.superclass.parseJSON.call(this, properties);
		if (properties.users) {
			this.users = properties.users;
		}
		//b:oldform 4 edit
		if (properties.form) {
			this.form = this.oldform = properties.form;			 
		}
	},
	
	toJSON : function() {
		var formtask = FS.FormTask.superclass.toJSON.apply(this, arguments);
		formtask.users = this.getUsers();
		formtask.form = this.getForm();
		if (this.oldform) {
			formtask.oldform = this.oldform;
		}
		return formtask;
	},
	
	setUsers : function(users) {
		this.setProperty('users', users, this.users);
	},
	
	getUsers : function() {
		return this.users;
	},
	
	setForm : function(form) {
		this.setProperty('form', form, this.form);
	},
	
	getForm : function() {
		return this.form;
	},
	
	getType : function() {
		return "formtask";
	},
	
	paint : function(processdefine) {
		FS.FormTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("formtask", FS.FormTask);

FS.JavaTask = FR.extend(FS.RectangleTask, {
	init : function(properties) {
		FS.JavaTask.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		if (properties.className){
			this.setClassName(properties.className);
		}
	},
	
	toJSON : function() {
		var javatask = FS.JavaTask.superclass.toJSON.apply(this, arguments);
		javatask.className = this.getClassName();
		return javatask;
	},
	
	getClassName : function() {
		return this.className;
	},
	
	setClassName : function(name) {
		this.className = name;
	},
	
	getType : function() {
		return "javatask";
	},
	
	paint : function(processdefine) {
		FS.JavaTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("javatask", FS.JavaTask);


FS.ProcessTransition = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.ProcessTransition.superclass.init.apply(this, arguments);
		//b:Խɾ
		this.points = [];
	},
	
	_initPropertiesChangeEvent : function() {
		this.addEvent(FS.Events.PROPERTYCHANGE, function() {
			if (!arguments || !arguments.length) {
				return;
			}
			var proper = arguments[0], nv = arguments[1], ov = arguments[2];
			if (proper == 'name') {
				this.fromTask.processDefine.undoManager.addUnOb(new FS.SetNameUnOb(this, ov));
			} else {
				return;
			}
			this.fromTask.processDefine.saveProcess();
			this.fromTask.processDefine.fireEvent(FS.Events.UNDO);
		});
	},
	
	parseJSON : function(properties) {
		if (properties.name != null) {
			this.name = properties.name;
		}
		if (properties.fromTask) {
			this.fromTask = properties.fromTask;
		}
		if (properties.toTask) {
			this.toTaskName = properties.toTask;
		}
		if (properties.fromPoint) {
			this.fromPoint = properties.fromPoint;
		}
		if (properties.toPoint) {
			this.toPoint = properties.toPoint;
		}
		if (properties.back) {
			this.back = properties.back;
		}
	},
	
	getStyle : function() {
		if (!this.fromTask) {
			return;
		}
		return this.fromTask.processDefine.style;
	},
	
	toJSON : function() {
		var transition = {};
		transition.name = this.getName();
		transition.fromTask = this.getFromTask().getName();
		transition.toTask = this.getToTask().getName();
		transition.fromPoint = this.fromPoint;
		transition.toPoint = this.toPoint;
		if (this.back) {
			transition.back = this.back;
		}
		return transition;
	},
	
	removeSelf : function() {
		this.fromTask.removeTransition(this);
	},
	
	copySelf : function() {
		//do nothing
	},
	
	setFromTask : function(task) {
		this.fromTask = task;
	},
	
	getFromTask : function() {
		return this.fromTask;
	},
	
	removeFromTask : function() {
		this.fromTask.removeTransition(this);
		this.fromTask = null;
	},
	
	setToTaskName : function(name) {
		this.toTaskName = name;
	},
	
	setToTask : function(task) {
		this.toTask = task;
	},
	
	getToTask : function() {
		if (!this.toTask && this.toTaskName != null) {
			this.toTask = this.fromTask.processDefine.getTask(this.toTaskName);
		}
		return this.toTask;
	},
	
	getToTaskName : function() {
		if (this.toTaskName != null) {
			return this.toTaskName;
		}
		if (this.toTask) {
			return this.toTask.getName();
		}
	},
	
	removeToTask : function() {
		this.toTaskName = null;
		this.toTask = null;
	},
	
	getAllPoints : function() {
		var ap = [];
//		if (this.fromTask) {
//			Array.prototype.push.apply(ap, this.exeStartPoint());
//		}
//		Array.prototype.push.apply(ap, this.points);
//		if (this.toTask) {
//			Array.prototype.push.apply(ap, this.exeEndPoint());
//		}
//		return ap;
		var fts = this.exeTwoPoints4Task(this.getFromTask(), this.fromPoint),
			lts = this.exeTwoPoints4Task(this.getToTask(), this.toPoint);			
		Array.prototype.push.apply(ap, fts);
		if (fts[1] != lts[1]) {
			var inner = this.exeInnerPoints(fts[1], lts[1]);
			Array.prototype.push.apply(ap, inner);
			ap.push(lts[1]);
		}
		
		ap.push(lts[0]);
		return ap;
	},
	

	
//	exeStartPoint : function() {
//		if (!this.fromTask) {
//			return;
//		}
//		var sp = this.fromTask.getCenterPoint();
//		var ep = this.points[0];
//		if (!ep) {
//			ep = this.getToTask().getCenterPoint();
//		}
//		//b:ʽƵóresult
//		var cross;
//		if (this.fromTask instanceof FS.CircleTask) {
//			cross = this.circleCross(sp, ep);
//		} else if (this.fromTask instanceof FS.RectangleTask) {
//			cross = this.rectangleCross(sp, ep);
//		}
//		return cross;
//	},
	
//	circleCross : function(sp, ep) {
//		var x = 0, y = 0;
//		var dep = 20/Math.sqrt((sp.y - ep.y)*(sp.y - ep.y)/((sp.x - ep.x)*(sp.x - ep.x)) + 1);
//		if (ep.x <= sp.x && ep.y <= sp.y) {
//			if (sp.x == ep.x) {
//				x = sp.x;
//				y = sp.y - 20;
//			} else {
//				x = sp.x - dep;
//				y = sp.y - dep*(sp.y - ep.y)/(sp.x - ep.x);
//			}
//		} else if (ep.x >= sp.x && ep.y >= sp.y) {
//			if (sp.x == ep.x) {
//				x = sp.x;
//				y = sp.y + 20;
//			} else {
//				x = sp.x + dep;
//				y = sp.y + dep*(sp.y - ep.y)/(sp.x - ep.x);
//			}
//		} else if (ep.x < sp.x && ep.y > sp.y) {
//			x = sp.x - dep;
//			y = sp.y + dep*(ep.y - sp.y)/(sp.x - ep.x);
//		} else if (ep.x > sp.x && ep.y < sp.y) {
//			x = sp.x + dep;
//			y = sp.y - dep*(sp.y - ep.y)/(ep.x - sp.x);
//		}
//		return {
//			x : Math.round(x),
//			y : Math.round(y)
//		};
//	},
//	
//	rectangleCross : function(sp, ep) {
//		var x = 0, y = 0;
//		if (ep.x <= sp.x && ep.y <= sp.y) {
//			if (sp.x - ep.x >= sp.y - ep.y) {
//				x = sp.x - 20;
//				y = sp.y - 20*(sp.y - ep.y)/(sp.x - ep.x);
//			} else {
//				x = sp.x - 20*(sp.x - ep.x)/(sp.y - ep.y);
//				y = sp.y - 20;
//			}
//		} else if (ep.x >= sp.x && ep.y >= sp.y) {
//			if (ep.x - sp.x >= ep.y - sp.y) {
//				x = sp.x + 20;
//				y = sp.y + 20*(sp.y - ep.y)/(sp.x - ep.x);
//			} else {
//				x = sp.x + 20*(sp.x - ep.x)/(sp.y - ep.y);
//				y = sp.y + 20;
//			}
//		} else if (ep.x < sp.x && ep.y > sp.y) {
//			if (sp.x - ep.x >= ep.y - sp.y) {
//				x = sp.x - 20;
//				y = sp.y + 20*(ep.y - sp.y)/(sp.x - ep.x);
//			} else {
//				x = sp.x - 20*(sp.x - ep.x)/(ep.y - sp.y);
//				y = sp.y + 20;
//			}
//		} else if (ep.x > sp.x && ep.y < sp.y) {
//			if (ep.x - sp.x >= sp.y - ep.y) {
//				x = sp.x + 20;
//				y = sp.y - 20*(ep.y - sp.y)/(sp.x - ep.x);
//			} else {
//				x = sp.x + 20*(sp.x - ep.x)/(ep.y - sp.y);
//				y = sp.y - 20;
//			}	
//		}
//		return {
//			x : Math.round(x),
//			y : Math.round(y)
//		};
//	},
	
//	exeEndPoint : function() {
//		if (!this.getToTask()) {
//			return;
//		}
//
//		var sp = this.points.length > 0 ? this.points[this.points.length - 1] : this.fromTask.getCenterPoint();
//		var ep = this.toTask.getCenterPoint();
//		var cross;
//		if (this.toTask instanceof FS.CircleTask) {
//			cross = this.circleCross(ep, sp);
//		} else if (this.toTask instanceof FS.RectangleTask) {
//			cross = this.rectangleCross(ep, sp);
//		}
//		return cross;
//	},
	
	//b:ͷλ,ֱ36
	exeArrowPoints : function(sp, ep, dis, vis) {
		var x = 0, y = 0;
		if (!dis) {
			dis = 6;
		}
		//ep.x === sp.x isnan
		var dep = dis/Math.sqrt(1 + (ep.y - sp.y)*(ep.y - sp.y)/((ep.x - sp.x)*(ep.x - sp.x)));
		if (sp.x >= ep.x && sp.y >= ep.y) {
			if (sp.x == ep.x) {
				x = ep.x;
				y = ep.y + dis;
			} else {
				x = ep.x + dep;
				y = ep.y + (ep.y - sp.y)/(ep.x - sp.x)*dep;
			}

		} else if (sp.x <= ep.x && sp.y <= ep.y) {
			if (sp.x == ep.x) {
				x = ep.x;
				y = ep.y - dis;
			} else {
				x = ep.x - dep;
				y = ep.y - (ep.y - sp.y)/(ep.x - sp.x)*dep;
			}

		} else if (sp.x < ep.x && sp.y > ep.y) {
			x = ep.x - dep;
			y = ep.y + (sp.y - ep.y)/(ep.x - sp.x)*dep;
		} else if (sp.x > ep.x && sp.y < ep.y) {
			x = ep.x + dep;
			y = ep.y - (sp.y - ep.y)/(ep.x - sp.x)*dep;
		}

		return this.apexPoints({
			x : x,
			y : y
		}, ep, dis, vis);
	},
	
	apexPoints : function(cross, end, dis, vis) {
		if (!vis) {
			vis = 3;
		}
		if (cross.y == end.y) {
			return [{
				x : Math.round(cross.x),
				y : Math.round(cross.y + vis)
			}, {
				x : Math.round(cross.x),
				y : Math.round(cross.y - vis)
			}];
		}
		var c1 = (end.x*end.x + end.y*end.y - dis*dis - cross.x*cross.x - cross.y*cross.y)/(2*(end.y - cross.y)) - cross.y,
			c2 = (end.x - cross.x)/(end.y - cross.y);
		var a = c2*c2 + 1, b = -2*(cross.x + c1*c2), c = cross.x*cross.x + c1*c1 - vis*vis;
		var x1 = (-b + Math.sqrt(b*b - 4*a*c))/(2*a);
		var y1 = c1 + cross.y - c2*x1;
		var x2 = (-b - Math.sqrt(b*b - 4*a*c))/(2*a); 
		var y2 = c1 + cross.y - c2*x2;
		return [{
			x : Math.round(x1),
			y : Math.round(y1)
		}, {
			x : Math.round(x2),
			y : Math.round(y2)
		}];
	},
	
	paintArrow : function(ctx, sp, ep) {
		var points = this.exeArrowPoints(sp, ep);
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(ep.x, ep.y);
		ctx.lineTo(points[0].x, points[0].y);
		ctx.lineTo(points[1].x, points[1].y);
		ctx.lineTo(ep.x, ep.y);
		ctx.fillStyle = 'purple';
		ctx.fill();
		ctx.closePath();
		ctx.restore()
	},
	
	getPoints : function() {
		return this.points;
	},
	
	setNormalPoint : function(index, point) {
		this.points[index] = point;
	},
	
	addStart : function(point) {
		this.removeFromTask();
		this.points.unshift(point);
	},
	
	addEnd : function(point) {
		if (this.toTask) {
			this.points.push(point);
		} else {
			this.points[this.points.length - 1] = point;
		}
		this.removeToTask();	
	},
	
	removeStart : function() {
		this.points.shift();
	},
	
	removeEnd : function() {
		this.points.pop();
	},
	
	//bĬ
//	insertPoint : function() {
//		var points = this.getAllPoints();
//		var len = points.length;
//		var point = {
//			x : (points[len - 1].x + points[len - 2].x)/2,
//			y : (points[len - 1].y + points[len - 2].y)/2
//		};
//		if (this.getToTask() != null) {
//			this.points.push(point);
//		} else {
//			this.points = this.points.pop().push(point).push(points[len - 1]);
//		}		
//	},
//	
//	removeNormalPoint : function() {
//		var points = this.getAllPoints();
//		if (points.length < 3) {
//			return;
//		} else {
//			this.points.pop();
//		}
//	},
	
	paint : function(processdefine) {
		var ctx = processdefine.transitionContext;
		ctx.save();
		ctx.lineWidth = 1;
		ctx.beginPath();
		var points = this.getAllPoints();
		this.paintLine(ctx, points);
		var len = points.length;
		this.paintArrow(ctx, points[len - 2], points[len - 1]);
		
		this.drawName(processdefine, points[0], points[1]);
	},
	
	paintLine : function(ctx, points) {
		ctx.save();
		ctx.beginPath();
		if (points == null) {
			points = this.getAllPoints();
		}
		var len = points.length;
		for (var i = 0; i < len; i++) {
			if (i === 0) {
				ctx.moveTo(points[0].x, points[0].y);
			} else {
				ctx.lineTo(points[i].x, points[i].y);
			}
		}
		if (this.isActived) {
			ctx.strokeStyle = FS.ProcessColor.forbiddenColor;
			ctx.lineWidth = 2;
		}
		ctx.stroke();
		ctx.closePath();
		ctx.restore();
	},
	
	setActive : function(active) {
		this.isActived = active;
	},
	
	drawName : function(processdefine, sp, ep) {
		if (!this.getName()) {
			return;
		}
//		var point = sp;
//		
//		
//		ctx.save();
//		ctx.font = "8px" + ctx.font.split(/\d+px/)[1];
//		var pointRotate = this.calTextRotate(sp, ep);
//		ctx.translate(pointRotate.point.x, pointRotate.point.y);
//		ctx.rotate(pointRotate.radian);
//		ctx.fillText(this.getName(), 0, 0, 100);
//		
//		ctx.restore();	
//		ctx.restore();		
		
		var ap = this.getAllPoints();
		var line = [ap[0], ap[1]];
		var recount = processdefine.getTransitionRepeatLine(line, this);
		if (recount) {
			line = [ap[ap.length - 2], ap[ap.length - 1]];
			recount = processdefine.getTransitionBeforeRepeatLine(line, this);
		}
		var apex;
		if (line[0].x > line[1].x) {
			apex = line[1];
		} else if (line[0].x < line[1].x) {
			apex = line[0];
		} else if (line[0].y > line[1].y) {
			apex = line[0];
		} else {
			apex = line[1];
		}
		this.nameText = new FS.Name4Transition({
			name : this.getName(),
			direct : line[0].x == line[1].x ? 'horizontal' : 'vertical',
			expand : line[0].x < line[1].x || line[0].y < line[1].y,
			repeat : recount,
			apex : apex,
			factory : this
		});
		this.nameText.paint(processdefine);
	},
	
	isRepeatLine : function(tp) {
		var ap = this.getAllPoints();
		for (var i = 0, len = ap.length; i < len - 1; i++) {
			if (FR.equals(tp[0], ap[i]) && FR.equals(tp[1] == ap[i + 1])) {
				return true;
			}
		}
	},
	
	//b:5px
	calTextRotate : function(sp, ep) {
		var points = this.exeArrowPoints(ep, sp, 20, 8);
		var radian = 0, point = points[0];
		var tan = Math.abs((sp.y - ep.y)/(sp.x - ep.x));
		if(sp.x >= ep.x && sp.y >= ep.y) {
			point.y = point.y - 4;
			if (sp.x == ep.x) {
				radian = 1.5*Math.PI;
			} else {
				radian = Math.PI + Math.atan(tan);
			}
		} else if (sp.x <= ep.x && sp.y <= ep.y) {
			if (sp.x == ep.x) {
				radian = 0.5*Math.PI;
			} else {
				radian = Math.atan(tan);
			}
		
		} else if (sp.x > ep.x && sp.y < ep.y) {
			point = points[1];
			point.y = point.y - 4;
			radian = Math.PI - Math.atan(tan);
		} else if (sp.x < ep.x && sp.y > ep.y) {
			point = points[1];
			radian = 2*Math.PI - Math.atan(tan);
		}
		return {
			point : point,
			radian : radian
		};
	},
	
		
	calTextLength : function(ctx, text, fontsize, vertical) {
		var tm = ctx.measureText(text);
		if (!vertical) {
			return tm.width;
		} else {
			return Math.max(fontsize*text.length, tm.height*text.length);
		}
	},
	
	paintState : function(processdefine) {
		processdefine.stateOb = new FS.TransitionState({
			factory : this
		});
		processdefine.stateOb.paint(processdefine);		
	},
	
	
	isInArea : function(point) {
		var points = this.getAllPoints();
		for (var i = 0, len = points.length; i < len - 1; i++) {
			if (this.judgePoint(point, points[i], points[i + 1])) {
				return true;
			}
		}
		return false;
	},
	
	//b:Ǿȷж
	judgePoint : function(point, sp, ep) {	
		if (sp.x == ep.x && point.x > sp.x - 4 && point.x < sp.x + 4 && point.y >= Math.min(sp.y, ep.y) && point.y <= Math.max(sp.y, ep.y)) {
			return true;
		} else if (sp.y == ep.y && point.y > sp.y - 4 && point.y < sp.y + 4 && point.x >= Math.min(sp.x, ep.x) && point.x <= Math.max(sp.x, ep.x)) {
			return true;
		} else if (point.x < Math.min(sp.x, ep.x) || point.x > Math.max(sp.x, ep.x) || point.y < Math.min(sp.y, ep.y) || point.y > Math.max(sp.y, ep.y)) {
			return false;
		}
		if (ep.x == sp.x && (point.x == ep.x || point.x == ep.x + 1 || point.x == ep.x - 1)) {
			return true;
		}

		var slope = Math.abs(ep.y - sp.y) > Math.abs(ep.x - sp.x) ? Math.abs((ep.x - sp.x)/(ep.y - sp.y)) : Math.abs((ep.y - sp.y)/(ep.x - sp.x))
		var ns = Math.abs(ep.y - sp.y) > Math.abs(ep.x - sp.x) ? Math.abs((point.x - sp.x)/(point.y - sp.y)) : Math.abs((point.y - sp.y)/(point.x - sp.x));
		if (ns < slope + 0.3 && ns > slope - 0.3) {
			return true;
		} 
		return false;
	},
	
	//b:transition غҪ⴦
	triggerMouseMove : function(e) {
//		if (this.isInArea(FS.getPosition(e))) {
//			e.processdefine.setMouseOverOb(this);
//			return true;
//		}
//		return false;
	},
	
	triggerMouseOver : function(e) {
		//b:Ժʾ	
	},
	
	triggerMouseOut : function(e) {
		//do nothing now
	},
	
	triggerMouseDown : function(e) {
//		if (this.isInArea(FS.getPosition(e))) {
//			e.processdefine.setMouseOverOb(this);
//			return true;
//		}
//		return false;
	},
	
	triggerMouseUp : function(e) {
		//nothing
	},
	
	triggerKeyEvent : function(e) {
		
	},
	
	triggerDrag : function(e) {
		//nothing now
	},
	
	triggerDrop : function(e) {
		
	}
});

$.extend(FS.ProcessTransition.prototype, {
	exeInnerPoints : function(sp, ep, style) {
		var style = this.getStyle() ? this.getStyle() : style;
		var ew = style.width*style.widthScale, eh = style.height*style.heightScale;
		if ((sp.x === ep.x && sp.x%ew === 0) || (sp.y === ep.y && sp.y%eh === 0)) {
			return;
		}
		if (sp.x == ep.x && sp.x%ew > 0) {
			return [{x : Math.floor(sp.x/ew)*ew + ew, y : sp.y}, 
				{x : Math.floor(sp.x/ew)*ew + ew, y : ep.y}];
		}
		if (sp.y == ep.y && sp.y%eh > 0) {
			return [{x : sp.x, y : Math.floor(sp.y/eh)*eh}, 
				{x : ep.x, y : Math.floor(sp.y/eh)*eh}];
		}
		var inner = [];
		if (sp.x > ep.x && sp.y > ep.y) {
			if (sp.x%ew > 0) {
				if (ep.x%ew === 0) {
					inner = [{x : ep.x, y : sp.y}];
				} else {
					inner = [{x : Math.floor(ep.x/ew)*ew + ew,y : sp.y}, 
						{x : Math.floor(ep.x/ew)*ew + ew, y : ep.y}];
				}
			} else {
				if (ep.x%ew === 0) {
					inner = [{x : sp.x, y : Math.floor(sp.y/eh)*eh}, 
						{x : ep.x, y : Math.floor(sp.y/eh)*eh}];
				} else {
					inner = [{x : sp.x, y : Math.floor(sp.y/eh)*eh}, 
						{x : Math.floor(ep.x/ew)*ew + ew, y : Math.floor(sp.y/eh)*eh}, 
						{x : Math.floor(ep.x/ew)*ew + ew, y : ep.y}];
				}
			}
		} else if (sp.x < ep.x && sp.y < ep.y) {
			if (ep.x%ew > 0) {
				if (sp.x%ew === 0) {
					inner = [{x : sp.x, y : ep.y}];
				} else {
					inner = [{x : Math.floor(sp.x/ew)*ew + ew, y : sp.y},
						{x : Math.floor(sp.x/ew)*ew + ew,y : ep.y}];
				}
			} else {
				if (sp.x%ew === 0) {
					inner = [{x : sp.x, y : Math.floor(ep.y/eh)*eh},
						{x : ep.x, y : Math.floor(ep.y/eh)*eh}];
				} else {
					inner = [{x : Math.floor(sp.x/ew)*ew + ew, y : sp.y}, 
						{x : Math.floor(sp.x/ew)*ew + ew, y : Math.floor(ep.y/eh)*eh}, 
						{x : ep.x, y : Math.floor(ep.y/eh)*eh}];
				}
			}
		} else if (sp.x < ep.x && sp.y > ep.y) {
			if (sp.x%ew > 0) {
				if (ep.x%ew === 0) {
					inner = [{x : ep.x, y : sp.y}];
				} else {
					inner = [{x : Math.floor(ep.x/ew)*ew, y : sp.y}, 
						{x : Math.floor(ep.x/ew)*ew, y : ep.y}];
				}
			} else {
				if (ep.x%ew === 0) {
					inner = [{x : sp.x, y : Math.floor(sp.y/eh)*eh}, 
						{x : ep.x, y : Math.floor(sp.y/eh)*eh}];
				} else {
					inner = [{x : sp.x, y : Math.floor(sp.y/eh)*eh}, 
						{x : Math.floor(ep.x/ew)*ew, y : Math.floor(sp.y/eh)*eh},
						{x : Math.floor(ep.x/ew)*ew, y : ep.y}];
				}
			}
		} else if (sp.x > ep.x && sp.y < ep.y) {
			if (sp.x%ew === 0) {
				if (ep.x%ew > 0) {
					inner = [{x : sp.x, y : ep.y}];
				} else {
					inner = [{x : sp.x, y : Math.floor(ep.y/eh)*eh},
						{x : ep.x, y : Math.floor(ep.y/eh)*eh}];
				}
			} else {
				if (ep.x%ew > 0) {
					inner = [{x : Math.floor(sp.x/ew)*ew, y : sp.y},
						{x : Math.floor(sp.x/ew)*ew, y : ep.y}];
				} else {
					inner = [{x : Math.floor(sp.x/ew)*ew, y : sp.y}, 
						{x : Math.floor(sp.x/ew)*ew, y : Math.floor(ep.y/eh)*eh}, 
						{x : ep.x, y : Math.floor(ep.y/eh)*eh}];
				}
			}
		}
		
		return inner;
		
	},
	
	exeTwoPoints4Task : function(task, pointtype, style) {
		var cp = task.getCenterPoint();
		var style = this.getStyle() ? this.getStyle() : style;
		var ew = style.width*style.widthScale, eh = style.height*style.heightScale;
		var apex = {
			x : Math.floor(cp.x/ew)*ew,
			y : Math.floor(cp.y/eh)*eh
		};
		var width = style.radius*2, height = style.height; 
		if (task instanceof FS.RectangleTask) {
			width = style.width; 
		}
		var fp = {}, sp = {};
		if (pointtype == 'top') {
			fp = {
				x : cp.x,
				y : cp.y - height/2
			};
			sp = {
				x : cp.x,
				y : apex.y
			};
		} else if (pointtype == 'right') {
			fp = {
				x : cp.x + width/2,
				y : cp.y
			};
			sp = {
				x : apex.x + ew,
				y : cp.y
			};
		} else if (pointtype == 'bottom') {
			fp = {
				x : cp.x,
				y : cp.y + height/2
			};
			sp = {
				x : cp.x,
				y : apex.y + eh
			};
		} else if (pointtype == 'left') {
			fp = {
				x : cp.x - width/2,
				y : cp.y
			};
			sp = {
				x : apex.x,
				y : cp.y
			};
		}
		return [fp, sp];
	}
});

FS.TypeFunMap.put("transition", FS.ProcessTransition);

FS.Name4Transition = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.Name4Transition.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		this.name = properties.name;
		this.direct = properties.direct;
		this.expand = properties.expand;
		this.repeat = properties.repeat;
		this.apex = properties.apex;
		this.factory = properties.factory;
	},
	
	isInArea : function(point) {
		if (point.x >= this.x - 1 && point.x <= this.x + this.width && point.y >= this.y - 1 && point.y <= this.y + this.height
			&& !this.removeIcon.isInArea(point)) {
			return true;
		}
		return false;
	},
	
	getTransition : function() {
		return this.factory;
	},
	
	triggerMouseMove : function(e) {
		if (this.removeIcon && this.removeIcon.triggerMouseMove(e)) {
			return true;
		}
		if (this.isInArea(FS.getPosition(e))) {
			e.processdefine.setMouseOverOb(this);
			return true;
		}
		return false;
	},
	
	triggerMouseOver : function(e) {
		this.activeFactory(e);
	},
	
	activeFactory : function(e) {
		this.factory.setActive(true);
		this.factory.paintLine(e.processdefine.transitionContext);
	},
	
	judgeClear : function(e) {
		if (!this.isInArea(FS.getPosition(e))) {
			this.factory.setActive(false);
			e.processdefine.clearOver();
			e.processdefine.paintTransitions();
		}
	},
	
	triggerMouseOut : function(e) {	
		if (!this.isInArea(FS.getPosition(e))) {
			this.factory.setActive(false);
			e.processdefine.clearOver();
			e.processdefine.paintTransitions();
		}	
	},
	
	triggerMouseDown : function(e) {
		if (this.removeIcon) {
			this.removeIcon.triggerMouseDown(e);
		}
	},
	
	removeSelf : function(e) {
		this.factory.removeSelf();
		e.processdefine.repaint();
	},
	
	removeCenter : function() {
		return {
			x : this.x + this.width + 3,
			y : this.y + 4
		};
	},
	
	//b:༭ɾname4taskظ
	triggerDoubleClick : function(e) {
		var position = FS.getPosition(e);
		if (!this.isInArea(position)) {
			return false;
		}
		var os = $('canvas#fs_processdesign_state').offset();
		var nameeditor = $('div#fs_transitionnameeditor'), realeditor = nameeditor.children();
		var self = this;
		if (nameeditor.length === 0) {
			realeditor = $('<textarea/>').attr('id', 'fs_tasknamearea').css({
				height : this.height + 30,
				width : this.width + 30,
				'font-size' : 12,
				overflow : 'hidden',
				background : FS.ProcessColor.normalBackground
			}).val(this.name);
			$('<div/>').attr('id', 'fs_transitionnameeditor').css({
				position : 'absolute',
				top : os.top + this.y - 2,
				left : os.left + this.x - 2,
				height : this.height + 32,
				width : this.width + 32,
				'z-index' : 99,
				overflow : 'hidden'
			}).append(realeditor).appendTo($('body'));
		} else {
			realeditor.css({
				height : this.height + 30,
				width : this.width + 30
			});
			nameeditor.css({
				top : os.top + this.y - 2,
				left : os.left + this.x - 2,
				height : this.height + 32,
				width : this.width + 32
			}).show();
			
			realeditor.val(this.name);
		}
		realeditor.focus();
		realeditor.unbind('blur');
		realeditor.blur(function(e) {
				$(this).parent().hide();
				self.factory.setName($(this).val());
				self.factory.setActive(false);
				self.factory.fromTask.processDefine.repaint(e);
			})
		return true;
	},
	
	paint : function(processdefine) {
		var ctx = processdefine.nameContext;
		ctx.save();
		ctx.font = "12px" + ctx.font.split(/\d+px/)[1];
		this.showName = this.name;
		if (this.name.length > 8) {
			this.showName = this.name.substring(0, 6) + "..";
		}
		this.direct == 'horizontal' ? this.paintHorName(ctx) : this.paintVerName(ctx);
		ctx.restore();	
		this.removeIcon = new FS.RemoveIcon({
			factory : this,
			centerPoint : this.removeCenter()
		});		
		this.removeIcon.paint(ctx);	
	},
	
	dh : 10,
	
	paintVerName : function(ctx) {
		this.height = this.showName.length*this.dh;
		var aw = [10];
		for (var i = 0, len = this.showName.length; i < len; i++) {
			aw.push(ctx.measureText(this.showName.charAt(i)).width);
		}
		this.width = Math.max.apply(this, aw);
		this.x = this.apex.x + this.repeat*5 + 3, this.y = this.apex.y - (this.expand ? this.height + 4: -4);
		this.paintShape(ctx, this.x - 1, this.y - 1, this.width, this.height + 1);
		for (var i = 0, len = this.showName.length; i < len; i++) {			
			ctx.fillText(this.showName.charAt(i), this.x, this.y + (i + 1)*this.dh);
		}		
	},
	
	paintHorName : function(ctx) {
		this.height = this.dh;
		this.width = Math.max(ctx.measureText(this.showName).width + 2, 8);
		this.x = this.apex.x - (this.expand ? this.width + 4 : -4 );
		this.y = this.apex.y + (this.repeat - 1)*this.dh - 2;
		this.paintShape(ctx, this.x - 2, this.y - 1, this.width + 2, this.height + 1);
		ctx.fillText(this.showName, this.x, this.y + this.dh);
	},
	
	paintRemoveArea : function(ctx) {
		ctx.save();
		ctx.fillStyle = FS.ProcessColor.forbiddenColor;
		ctx.fillRect(this.x - 1, this.y - 1, 5, 5);
		ctx.restore();
	},
	
	paintShape : function(ctx, x, y, width, height) {
		ctx.save();
		ctx.beginPath();
		ctx.strokeStyle = FS.ProcessColor.borderStartColor;
		ctx.fillStyle = FS.ProcessColor.normalBackground;
		ctx.strokeRect(x, y, width, height);
		ctx.fillRect(x, y, width, height);
		ctx.restore();
	}
});