$.extend(FR.Events, {
	CollapseOrExpand : 'collapseexpand'
});
FS.RemoveSelfButton = FR.extend(FR.Button, {
    _defaultConfig : function() {
        return $.extend(FS.RemoveSelfButton.superclass._defaultConfig.apply(), {
            width : 60,
            height : 20
        });
    },
    _init : function() {
        FS.RemoveSelfButton.superclass._init.apply(this, arguments);
        this.element.addClass('fs_removeself');
        //b:float
        var self = this;
        var removeIcon = $('<span>&nbsp;</span>').addClass('fs_buttonremoveself').css('float', 'right').click(function() {
            self.fireEvent(FS.Events.REMOVESELF);
            self.element.remove();
        });
        $('em', this.element).parent().prepend(removeIcon);
    }
});

FS.ButtonsTable = FS.extend(FS.Widget, {
    init : function(config) {
        this.element = $('<table/>').attr('id', 'fs_auth_role_userstable');
        this.tb = $('<tbody/>').appendTo(this.element);
        this.container = config.container;
        if (config.items) {
            this.generateUserButtons(config.items);
        }
    },

    generateUserButtons : function(items) {
        this.items = items;
        var leng = items.length;
        var self = this;
        for(var i = 0, len = Math.ceil(leng/6); i < len; i++) {
            var tr = $('<tr/>');
            for (var j = 6; j--;) {
                var b = 6*i + 6 - j - 1;
                if (b >= leng) {
                    break;
                }
                var rb = new FS.RemoveSelfButton({
                    text : items[b].text
                });
                rb.element.data('item', items[b]);
                rb.on(FS.Events.REMOVESELF, function() {
                    var user = this.element.data('item');
                    self.container.removeSelf(user);
                    self.removeUser(user);
                });
                $('<td/>').append(rb.element).appendTo(tr);
            }
            tr.appendTo(this.tb);
        }
    },


    popUsers : function(users){
        if (FR.equals(users, this.items)) {
            return;
        }
        this.clearContent();
        this.generateUserButtons(users);
    },

    getUsers : function() {
        return this.items;
    },

    getUsersID : function() {
        return $.map(this.items, function(item) {
            return item.id;
        });
    },

    removeUser : function(user) {
        this.items.remove(user);
        this.reBuildTable();
    },

    reBuildTable : function() {
        this.clearButtons();
        this.generateUserButtons(this.items);
    },

    clearButtons : function() {
        this.tb.empty();
    },

    clearContent : function() {
        this.tb.empty();
        this.items = null;
    }
});

FS.ProcessTab = FR.extend(FR.TabPane, {
	_defaultConfig : function() {
		return $.extend(FS.ProcessTab.superclass._defaultConfig.apply(this, arguments), {
			tabPosition : 'top',
			noControl : true
		});
	},
	
	_init : function() {
		FS.ProcessTab.superclass._init.apply(this, arguments);
		this.element.addClass('fs_process_tabs');
		this.expandCollapsePane();
	},
	
	//b:dolayout use fireevent
	expandCollapsePane : function() {
		var self = this;
		this.switchIcon = new FS.IconButton({
			imgsrc : 'fs_process_tabcollapse',
			switchImgsrc : 'fs_process_tabexpand',
			renderEl : $('<div/>'),
			handler : function() {
				self.fireEvent(FR.Events.CollapseOrExpand);
			}
		});
		this.tabsContent.append(this.switchIcon.element.css({
			position : 'absolute',
			top : 0,
			right : 20
		}));
	}
});

/*
 * wei : Сؼʾ֣ͣʱı༭֡
 */
FS.ShowHideWidget = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').addClass('fs_showhidetexteditor');
		var width = config.width || config.widgetConfig.width;
		var height = config.height || config.widgetConfig.height;
		if(width > -1) {
			this.element.width(width);
		}
		if(height > -1) {
			this.element.height(height);
		}
		if(config.style) {
			this.element.css(config.style);
		}
		this.textField = $('<span/>')
			.css('white-space', 'nowrap').appendTo(this.element);
		this.textField.text(config.value || config.widgetConfig.value);
		this.widget = FR.createWidget(config.widgetConfig);
		this.widget.element.css({
			'position' : 'absolute',
			'top' : 0,
			'left' : 0
		});
		var self = this;
		this.widget.on(FR.Events.AFTEREDIT, function() {
			self.textField.text(self.widget.getText());
			if(self.widget.getValue() != self.oldValue) {
				self.triggerValueChange();
			}
		});
		this.widget.invisible();
		this.element.append(this.widget.element);
		this.element.hover(function() {
			self.oldValue = self.widget.getValue();
			self.widget.visible();
			//self.widget.setValue(self.textField.text());
		}, function(e) {
			if(self.widget.$view && self.widget.$view.is(':visible')) {
				return ;
			}
			self.widget.invisible();
		});
	}, 
	setValue : function(value) {
		this.widget.setValue(value);
		this.textField.text(this.widget.getText());
	},
	getValue : function() {
		return this.widget.getValue();
	},
	showWidget : function() {
		this.widget.visible();
	},
	triggerValueChange : function() {
		if(this.valueChange) {
			this.valueChange.apply(this, arguments);
		}
	}
});

$.extend(FS, {
	startProcessQuery : function(entry) {
 		var conditions = entry.conditions;
		var processid = entry.processid;
		var showname = entry.showname;
		var result;
		var conditonJson = FR.jsonDecode(conditions);
		if(conditonJson[0].name && conditonJson[0].parameter) {
			//˵ͨòѯ
			var el = this._createGeneralQueryPane(processid, conditions, showname);
			FS.tabPane.addItem({
				title : entry.text,
				contentEl : el,
				css : {
					background : 'none repeat scroll 0 0 #E0FBF9',
					'overflow' : 'auto'
				}
			});
			return;
		}
		FR.ajax({
			url : FR.servletURL + "?op=process_task&cmd=querytask",
			data : {
				conditions : encodeURIComponent(conditions),
				showname : showname,
				processid : processid
			},
			complete : function(res, status) {
				result = FR.jsonDecode(res.responseText);
				result.text = entry.text;
				FS.Process.showTaskInfo(result);
				return ;
			}
		});
 	},
 	
 	_createGeneralQueryPane : function(processid, conditions, showname) {
 		var generalQueryMainPane = $('<div/>').css({
			'padding-top' : 30,
			'padding-left' : 50,
			'padding-right' : 50,
			'height' : '100%',
            'overflow' : 'auto'
		});
		FR.ajax({
			async : false,
			url : FR.servletURL + "?op=process_task&cmd=preparegeneralquery",
			data : {
				conditions : conditions,
				processid : processid
			},
			complete : function(res, status) {
				result = FR.jsonDecode(res.responseText);
				var generalQueryPane = $('<div/>').addClass('fs_processgeneralquery').appendTo(generalQueryMainPane);
				var queryArray = [];
				$.each(result, function(idx, item) {
					var queryDiv = $('<div/>').addClass('fs_processgeneralquerylabelandcheckbox').appendTo(generalQueryPane);
					var showLabel = $('<div/>').addClass('fs_processgeneralquerylabel').text(item.showname + ":")
						.appendTo(queryDiv);
					var items = [];
					var paraName = "";
					$.each(item, function(idx, para) {
						if(idx == "showname") {
							return ;
						}
						paraName = idx;
						//items = FR.jsonDecode(para);
					});
					var checkBox = new FR.CheckBoxEditor({
						widgetUrl : FR.servletURL + "?op=process_task&cmd=getparaitems&paraName=" + paraName + "&processid=" + processid,
						width : 100,
						height : 16,
						directEdit : true
					});
					queryArray.push({
						paraName : paraName,
						paraWidget : checkBox
					});
					queryDiv.append(checkBox.element.addClass('fs_processgeneralquerycheck'));
				});
				var keywordQueryPane = $('<div/>').addClass('fs_processkeywordquerypane').appendTo(generalQueryPane);
				var wrapDiv = $('<div/>').addClass('fs_processkeywordwrappane').appendTo(keywordQueryPane);
				var textEditor = new FR.TextEditor({
					watermark : FR.i18nText("Input_Keyword"),
					height : 20,
					width : 180
				});
				var button = new FR.Button({
					width : 80,
					height : 20,
					text : FR.i18nText("Query"),
					hotkeys:'enter',
					listeners:[{
						eventName : 'click',
						action : function() {
							var paraValueJson = [];
							$.each(queryArray, function(idx, item) {
								paraValueJson.push({
									paraName : item.paraName,
									paraValue : item.paraWidget.getValue()
								});
							});
							if(textEditor.getValue() != '' && textEditor.getValue() != null) {
								paraValueJson.push({"queryKeyWord" : textEditor.getValue()});
							}
							var generalQueryResult = [];
							FR.ajax({
								async : false,
								url : FR.servletURL + "?op=process_task&cmd=generalquery",
								data : {
									paraValue : FR.jsonEncode(paraValueJson),
									processid : processid,
									showname : showname
								},
								complete : function(res, status) {
									generalQueryResult = FR.jsonDecode(res.responseText);
								}
							});
							if($('.fs_process_tasksgrid', generalQueryMainPane)) {
								$('.fs_process_tasksgrid', generalQueryMainPane).parent().remove();
							}
							if($('.fs_process_querytaskinfo', generalQueryMainPane)) {
								$('.fs_process_querytaskinfo', generalQueryMainPane).remove();
							}
                            var taskPaneHeight = 470;
							if(FS.Process.createTaskPane(generalQueryResult, taskPaneHeight) == null) {
								generalQueryMainPane.append($('<div/>').addClass("fs_process_querytaskinfo").text(FR.i18nText("No_Wanted_Result")+"."));
							} else {
								generalQueryMainPane.append(FS.Process.createTaskPane(generalQueryResult, taskPaneHeight).css({
									'position' : 'relative',
									'text-align' : 'left',
									'margin-left' : 'auto',
									'margin-right' : 'auto',
									'margin-top' : 0
								}));
							}
							generalQueryMainPane.children().last().height(taskPaneHeight + 50);
						}
				}]
				});
				wrapDiv.append(textEditor.element.css({
					'float' : 'left',
					'margin-right' : '20px'				
				})).append(button.element.css('float', 'left'));				
			}
		});
		return generalQueryMainPane;
 	}
});

$.extend(FS.Trans, {
	saveProcess : function(process) {
		//wei : ̵ʱͼ
		var maxX = 0;
		var maxY = 0;
		$.each(process.tasks, function(idx, item) {
			if(item.centerPoint.x > maxX) {
				maxX = item.centerPoint.x;
			}
			if(item.centerPoint.y > maxY) {
				maxY = item.centerPoint.y;
			}
		})
		var tempCanvas = document.createElement("canvas");
		tempCanvas.width = maxX + 50;
		tempCanvas.height = maxY + 30;
		var ctx = tempCanvas.getContext("2d");
		var processCanvas = $('canvas', $('#fs_process_designArea'));
		$.each(processCanvas, function(idx, item){
            ctx.drawImage(item, 0, 0);
        })
        var imageData = tempCanvas.toDataURL();
        var processJSON = process.toJSON();
        processJSON.imageData = imageData;
		return this.ajax({
			data : {
				process : processJSON
			},
			returnString : true,
			url : FR.servletURL + "?op=process_ob&cmd=save"
		});
	},
	
	removeProcess : function(name) {
		return this.ajax({
			data : {processname : name},
			url : FR.servletURL + "?op=process_ob&cmd=remove"
		});		
	},
	
	getAllProcess : function() {
		return this.ajax({
			url : FR.servletURL + "?op=process_ob&cmd=all"
		});		
	},
	
	startProcessById : function(processid, paraMap) {
    	var result;
		FR.ajax({
			async : false,
			url : FR.servletURL + "?op=process_task&cmd=start",
			data : {
				id : processid
			},
			complete : function(res, status) {
				result = FR.jsonDecode(res.responseText);
			}
		});
		if (result.start) {
			FR.Msg.toast(FR.i18nText("Server-Start") + FR.i18nText("Successfully"));
		} else {
			FS.Process.refreshTask();
			var src = "?op=process_exe&cmd=showbook&taskname=" + FR.cjkEncode(result.name) + "&processexecutorid=" + result.processexecutorid;
			if(paraMap) {
				src += ("&paraMap=" + FR.jsonEncode(paraMap));
			}

			FS.tabPane.addItem({
				'title' : FR.i18nText("Handle_Affairs") + result.processexecutorid,
				src : src
			});
		}
		return result.processexecutorid;
    },
    
    continueProcess : function(parameters) {
    	FR.activeBranches(parameters.branches, parameters.parameters, parameters.processid, 
    		parameters.taskName, parameters.serverURL, parameters.needClose);
    }
});

/*
 * wei : ʾͼ
 */
FS.ProcessDiagramPane = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_processdiagrampane');
		this.intiTitle();
		this.initMainPane();
		this.resize(config);
	},
	intiTitle : function() {
		this.element.append($('<div/>').addClass('fs_processdiagrampanetitle').text(FR.i18nText("has_saved")+FR.i18nText("WF-Process")));
	},
	initMainPane : function() {
		var self = this;
		var properties = FS.Trans.getAllProcess();
		var processNames = [];
		$.each(properties, function(idx, item) {
			processNames.push({
				text : item.name,
				value : item.name
			});
		});
		var processes = [];
		this._addProcessDiagram();
		for (var i = 0, len = properties.length; i < len; i++) {
			//var process = new FS.ProcessDefine(properties[i]);
			//process.text = process.name;
			//processes.push(process);
			(function(property) {
				FS.ProcessMananger.addProcessName(property.name);
				var process = new FS.ProcessOb(property);
				FS.ProcessMananger.addProcess(process);
				var img = $('<img src=\"' + property.imageData + '\"/>').css({
					left : '999px',
					top : '999px'
				}).appendTo($('body'));
				var width = img.width();
				var height = img.height();
				img.remove();
				var maxWidth = 150*width/height;
				if(isNaN(maxWidth)) {
					var diagramWidth = 225;
				} else if(maxWidth > 225) {
					var diagramWidth  =225;
				} else {
					var diagramHeight = 145;
				}
				var processDiagram = new FS.ProcessDiagram({
					'title' : property.name,
					content : $('<div/>').css({
					}).append($('<img src=\"' + property.imageData + '\"/>').css({
						width : diagramWidth,
						height : diagramHeight
					})),
					css : {
						width : 225,
						height : 150,
						'margin-top' : 40,
						'margin-left': 40
					},
					needClose : function(e) {
						FR.showAsyncDialog({
							title : FR.i18nText("Delete")+FR.i18nText("WF-Process"),
							text : FR.i18nText("fs_process_delete_tip"),
							width : 240,
						 	callback : function(value) {
						 		processDiagram.element.remove();
								FS.Trans.removeProcess(property.name);				 		
						 	}
						});		
						e.stopPropagation();
					}
				});
				processDiagram.element.css({
					'float' : 'left',
					'cursor' : 'pointer'
				})
					.click(function() {
						var processPane = new FS.ProcessEditPane({
							width : FS.center.width(),
							height : FS.center.height() - 30
						});
						processPane.element.data('container', processPane);
						FS.tabPane.activePane.children().detach();
						FS.tabPane.activePane.append(processPane.element);
						var process = new FS.ProcessDefine(property);
						processPane.showProcess(process);
						processPane.allProcessNames = processNames;
						self.processPane = processPane;
					});
				self.element.append(processDiagram.element);
			})(properties[i]);
				//FS.ProcessMananger.addProcess(process);
		}
		//self.processList.popData(processes);
	},
	
	_addProcessDiagram : function() {
		var processDiagram = new FS.ProcessDiagram({
			title : ' '+FR.i18nText("add")+FR.i18nText("SingleNew")+FR.i18nText("WF-Process"),
			content : this._createNewProcessButton(),
			css : {
				width : 225,
				height : 150,
				'margin-top' : 40,
				'margin-left': 40,
				'border-style' : 'dashed'
			}
		});
		processDiagram.element.css('float', 'left');
		this.element.append(processDiagram.element);	
	},
	
	_createNewProcessButton : function() {
		this.addProcessButton =  $('<div onselectstart="return false"/>').text('+').css({
			'font-size' : '140px',
			width : 177,
			height : 110,
			color : '#6CA7BB',
			'line-height' : '120px',
			'text-align' : 'center',
			'margin-top' : '12px',
			'margin-left' : '22px',
			'-moz-user-select' : 'none'
		})
		.hover(function() {
			$(this).css('background', '#E6EFF2');
		}, function() {
			$(this).css('background', '');
		}).mousedown(function() {
			$(this).css('background', '#A9CBD6');
		}).mouseup(function() {
			$(this).css('background', '#E6EFF2');
		});
		return this.addProcessButton;
	},
	
	resize : function(rec) {
		this.element.css("width", $.boxModel ? rec.width - FR.fixBoxModelWidth(this.element) : rec.width);
        this.element.css("height", $.boxModel ? rec.height - FR.fixBoxModelHeight(this.element) : rec.height); // alex:ȥ±߿ĸ߶
	}
});

/*
 * wei : ̵ͼ
 */
FS.ProcessDiagram = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<fieldset/>').addClass('fs_processdiagram');
		if(config.css) {
			this.element.css(config.css);
		}
		if(config.title) {
			$('<legend/>').html('&nbsp;&nbsp;' + config.title + '&nbsp;&nbsp;').addClass('fs_processtitle')
				.appendTo(this.element);
		}
		if(config.content) {
			this.element.append(config.content);
		}
		var self = this;
		if(config.needClose) {
			this.closeButton = $('<div>').addClass('fs_processdiagramclose').text('x');
			this.closeButton.hide().appendTo(this.element.hover(function() {
				self.closeButton.show();
			}, function() {
				self.closeButton.hide();
			})).click(function() {
				config.needClose.apply(this, arguments);
			});
		}
	}
});

/**
 * wei : ̹϶̽ڵԪص壬ͳָť
 */
FS.ProcessDragPane = FS.extend(FS.Widget, {
	init : function() {
		this.element = $('<div/>').attr('id', 'fs_processdragpane');
		var title = $('<div/>').addClass('fs_processdesignpanetitle').text(FR.i18nText("WF-Process")+FR.i18nText("Draw")).appendTo(this.element);
		this.processParaNumberBar = new FS.NumberBar({
			text : FR.i18nText("WF-Process")+FR.i18nText("FormulaD-Data_Fields"),
			number : 0,
			width : 88,
			height : 24
		});
		var self = this;
		this.processParaNumberBar.textField.click(function() {
			//༭Ի
			self.generateParametersPane();
		});
		this.element.append(this.processParaNumberBar.element);
		var dragField = $('<fieldset/>').addClass('fs_processdesignpanedragfield')
			.css({
				'padding-left' : '7px',
				'padding-right' : '7px'
			}).appendTo(this.element);
		$('<legend/>').html('&nbsp;'+FR.i18nText("DrawChart")+'&nbsp;').appendTo(dragField);
		//3̰ť
		var taskButtonField = $('<div/>').addClass('fs_processdesignpanedragbuttonfield').appendTo(dragField);
		
		this.circle = $('<div/>').addClass('fs_processdesignpanetaskbutton')
			.attr('title',FR.i18nText("fs_process_endtask_tip")).attr('id', 'fs_processdesignpanecircletask').appendTo(taskButtonField);
		this.square = $('<div/>').addClass('fs_processdesignpanetaskbutton')
			.attr('title', FR.i18nText("fs_process_reporttask_tip")).attr('id', 'fs_processdesignpanesquaretask').appendTo(taskButtonField);
		this.sub = $('<div/>').addClass('fs_processdesignpanetaskbutton')
			.attr('title', FR.i18nText("fs_process_sontask_tip")).attr('id', 'fs_processdesignpanesubprotask').appendTo(taskButtonField);
	},
	generateParametersPane : function() {
		//if (!this.parametersPane) {
			this.parametersPane = new FS.ParametersPane({});
			var self = this;
			function confire() {
				self.process.itemChanged = self.parametersPane.parasTable.itemChanged;
				if(self.parametersPane.isShareProcessName()) {
					var shareProcessName = self.parametersPane.getShareProcessName();
					self.process.setShareProcessName(shareProcessName);
					var shareProcess = FS.ProcessMananger.getProcessByName(shareProcessName);
					if(shareProcess) {
						self.process.setParameters(shareProcess.getParameters());
					}	
				} else {
					self.process.setParameters(self.parametersPane.getParameters());
					self.process.setShareProcessName('');
				}
				self.processParaNumberBar.setNumberValue(self.process.getParameters().length);
			}
			this.paraDialog = new FR.Dialog({
				title : FR.i18nText("Edit")+FR.i18nText("WF-Process")+FR.i18nText("FormulaD-Data_Fields"),
                contentWidget : this.parametersPane,
				confire : true,
				height : 365,
				width : 430
			});

		//}
		if (this.process) {
			this.parametersPane.popParameters(this.process.parameters);
			this.parametersPane.popShareProcessName(this.process.shareProcessName);
			this.process.setProperty('originalShareProcessName', this.parametersPane.getShareProcessName());
		}
		this.paraDialog.setVisible(true);
	},
	setProcess : function(process) {
		this.process = process;
	}
});

/**
 * wei : һСؼϽʾ
 */
FS.NumberBar = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div>').addClass('fs_numberbar')
		this.textField = $('<div/>').addClass('fs_numberbartextfield').appendTo(this.element);
		this.numberField = $('<div/>').addClass('fs_numberbar_numdiv').appendTo(this.element);
		if(config.text) {
			this.textField.text(config.text);
		}
		if(config.number) {
			this.numberField.text(config.number);
		}
		if(config.width > -1) {
			this.element.width(config.width);
			this.textField.width(config.width - 8);
		}
		if(config.height > -1) {
			this.element.height(config.height);
		}
		
	},
	setNumberValue : function(number) {
		this.numberField.text(number);
	}
});

/*
 * wei : ͨ̽ڵ
 */
FS.NormalTaskPane = FS.extend(FS.Widget, {
	init : function() {
		var self = this;
		this.element = $('<div/>').attr('id', 'fs_processnormaltaskpane');
		var title = $('<div/>').addClass('fs_processdesignpanetitle').text(FR.i18nText("WF-Process")+FR.i18nText("Activity")+FR.i18nText("Set")).appendTo(this.element);
		var attrSetField = $('<div/>').addClass('fs_processnormaltaskattrdiv').appendTo(this.element);
		$('<div/>').addClass('fs_processnormaltasktitle').text(FR.i18nText("Basic")+FR.i18nText("Attribute")).appendTo(attrSetField);
		this.taskname = new FR.TextEditor({
			width : 113,
			height : 18
		});
		this.taskname.on(FR.Events.AFTEREDIT, function() {
			if(self.task) {
				self.task.setName(self.taskname.getValue());
				self.task.processDefine.repaint();
			}
		});
		$("<div/>").append($("<span/>").text(FR.i18nText("Activity")+FR.i18nText("WF-Name")+FR.i18nText("colon")).css({
			"float" : "left",
			"padding-left" : "5px"
		})).append(this.taskname.element.css('float', 'left'))
			.css({
				width : '180px',
				height : '18px',
				'padding-top' : '5px'
			}).appendTo(attrSetField);
		this.reportPath = new FR.TextEditor({
			width : 88,
			height : 18
		});
		this.reportPath.on(FR.Events.AFTEREDIT, function() {
			if(self.task) {
				self.task.setForm(self.reportPath.getValue());
			}
		});
		this.viewReportButton = $('<div/>').addClass('fs_processnormaltaskviewbutton').text('...')
			.appendTo(attrSetField).css('float', 'left').click(function() {
				if(self.reportTree.is(':visible')) {
					self.reportTree.hide();
					return ;
				}
				self.reportTree.show();
				self.createReportsTree();
			});
		this.reportTree = $('<div/>').addClass('fs_processnormaltaskreporttree').hide();
		$("<div/>").append($("<span/>").text(FR.i18nText("Form")+FR.i18nText("Path")+FR.i18nText("colon")).css({
			"float" : "left",
			"padding-left" : "5px"
		})).append(this.reportPath.element.css('float', 'left'))
			.append(this.viewReportButton).css({
				width : '180px',
				height : '18px',
				'padding-top' : '5px',
				position : 'relative'
			}).append(this.reportTree).appendTo(attrSetField);
		$(document).bind('mousedown', this, this.collapseIf).bind('mousewheel', this, this.collapseIf);
		var participantField = $('<div/>').addClass('fs_processnormaltaskparticipantdiv').appendTo(this.element);
		$('<div/>').addClass('fs_processnormaltasktitle').text(FR.i18nText("Activity")+FR.i18nText("Participants")).appendTo(participantField);
		this.starter = this.createRadio().click(function(e){
			self.datas.setEnable(false);
			self.roleCombo.setEnable(false);
			if (self.task) {
				self.task.setUsers({
					type : 'parameterusers',
					paraname : 'processStarter'
				});
			}

			e.stopPropagation();
		});
		this.processpara = this.createRadio().click(function(e){
			self.roleCombo.setEnable(false);
			self.datas.setEnable(true);
			if (self.task) {
				self.task.setUsers({
					type : 'parameterusers'
				});
			}
			e.stopPropagation();			
		});
		this.roles = this.createRadio().click(function(e){
			self.roleCombo.setEnable(true);
			self.datas.setEnable(false);
			if (self.task) {
				self.task.setUsers({
					type : 'roleusers'
				});
			}
			e.stopPropagation();
		});
		var datas = this.datas = new FS.Combobox({
			width : 135,
			height : 18,
			items : [],
			directEdit : true
		});
		datas.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getProcessParas());
		});
		datas.on(FR.Events.AFTEREDIT, function() {
			var users = $.extend({}, self.task.users, {
				paraname : this.getValue()
			});
			self.task.setUsers(users);
		});
		var roleCombo = this.roleCombo = new FR.CheckBoxEditor({
			items : this.getRoles(),
			returnArray : true,
			height : 18,
			width : 135
		});
		roleCombo.on(FR.Events.AFTEREDIT, function() {
			var roles = roleCombo.getValue();
			self.changeRoles(roles);
		});
		participantField.append(this.starter).append($('<span/>').text(FR.i18nText("WF-Process")+FR.i18nText("Server-Start")+FR.i18nText("SingleMan")))
			.append($('<div/>').append(this.processpara).append($('<span/>').text(FR.i18nText("hasRelation")+FR.i18nText("Role")+FR.i18nText("FormulaD-Data_Fields"))))
			.append(datas.element.css({
				'padding-left' : '5px'
			})).append($('<div/>').append(this.roles).append($('<span/>').text(+FR.i18nText("Specify")+FR.i18nText("Role"))))
			.append(roleCombo.element.css({
				'padding-left' : '5px'
			}));
	},
	createRadio : function() {
		var radio =  $('<input/>').attr({
			type : 'radio',
			checked : false,
			name : 'users'
		});
		return radio;
	},
	setProcess : function(process) {
		this.process = process;
	},
	getProcessParas : function() {
		var paranames = [];
		$.each(this.process.parameters, function(idx, item) {
			paranames.push({
				text : item.name,
				value : item.name
			});
		})
		return paranames;
	},
	getRoles : function(jids, sids) {
		var roles = FS.Trans.getRoles();
 		for (var i = 0, len = roles.length; i < len; i++) {
 			if (roles[i].departmentname != null) {
 				roles[i].text = roles[i].departmentname + roles[i].postname;
 				roles[i].value = 'jr'+roles[i].id
 			} else {	
 				roles[i].value = roles[i].id;	
 			}		
 		}
 		if (jids || sids) {
 			var rs = [];
 			for (var i = 0, len = roles.length; i < len; i++) {
 				if (jids.indexOf(roles[i].id) > -1 && roles[i].departmentname != null) {
 					rs.push('jr' + roles[i].id);
 				}
 				if (sids.indexOf(roles[i].id) > -1 && roles[i].departmentname == null) {
 					rs.push(roles[i].id);
 				}
 			}
 			return rs;
 		}
 		return roles;
	},
	changeRoles : function(roles) {
		if (!this.task || !roles || roles.length < 1) {
			return;
		}
		var jr = [], sr = [];
		for (var i = 0, len = roles.length; i < len; i++) {
			if ((roles[i]+"").startWith('jr')) {
				jr.push(roles[i].substring(2, roles[i].length));
			} else {
				sr.push(roles[i]);
			}
		}
		var users = $.extend({}, this.task.users, {
			jroles : jr.join(','),
			sroles : sr.join(',')
		});
		this.task.setUsers(users);
	},
	popTask : function(task) {
		this.clearAll();
		this.task = task;
		if (!this.task.users) {
			this.task.users = {};
		}
		this.taskname.setValue(task.name);
		this.reportPath.setValue(task.form);
		var users = task.users;
		if (users.type == "roleusers") {
			this.roles.attr('checked', true);
			this.roleCombo.setEnable(true);
			var js = users.jroles ? users.jroles : "", ss = users.sroles ? users.sroles : "";
			this.roleCombo.setValue(this.getRoles(js.split(','), ss.split(',')));
		} else if (users.type == "parameterusers") {
			if (users.paraname == 'processStarter') {
				this.starter.attr('checked', true);
			} else {
				this.processpara.attr('checked', true);
				this.datas.setValue(users.paraname);
			}
		} 
//		else if (users.type == "formulausers") {
//			this.formula.attr('checked', true);
//			this.formulaText.setValue(users.exp);	
//		}
		this.task.users = users;
	},
	clearAll : function() {
		this.taskname.setValue('');
		this.reportPath.setValue('');
		this.roles.attr('checked', false);
		this.starter.attr('checked', false);
		this.processpara.attr('checked', false);
//		this.formula.attr('checked', false);
//		this.formulaText.setValue('');
		this.roleCombo.setValue('', false);
		this.datas.setValue('', false);
	},
	show : function() {
		this.element.show();
	},
	hide : function() {
		this.element.hide();
	},
//	chooseReport : function(path) {
//		if (this.treeTR.is(':visible')) {
//			this.treeTR.hide();
//			return;
//		}
//		if (!this.treecontent) {
//			this.treecontent = $('<div/>').addClass('fs_reportadd_tree').appendTo($('td:eq(1)', this.treeTR));
//			this.treeTR.css('display', 'table-row');
//			this.createReportsTree();
//		}
//		this.treeTR.css('display', 'table-row');
//		this.treeTR.show();
//	},
	createReportsTree : function() {
		var self = this;
		if(!this.reportsTree) {
			this.reportsTree = new FS.Tree({
				height : 100,
				width : 160,
				renderEl : this.reportTree,
				expand : false,
				widgetUrl : FR.servletURL + "?op=fs_entry&cmd=getreports&form=true&file=frm,cpt"
			});
			this.reportsTree.on(FR.Events.CLICK, function() {
				self.reportPath.setValue(this.getSelectedData().getContent().path);
				self.reportPath.fireEvent("afteredit");
			});
		}
	},
	collapseIf : function(e) {
        var target = e.target, self = e.data;
        //b:λ
        if ((e.pageX < self.reportTree.offset().left || e.pageX > self.reportTree.offset().left + self.reportTree.width()
            || e.pageY < self.reportTree.offset().top || e.pageY > self.reportTree.offset().top + self.reportTree.height())
            && (e.pageX < self.viewReportButton.offset().left || e.pageX > self.viewReportButton.offset().left + self.viewReportButton[0].offsetWidth
            || e.pageY < self.viewReportButton.offset().top || e.pageY > self.viewReportButton.offset().top + self.viewReportButton[0].offsetheight)) {
            self.reportTree.hide();
        }
    }
});

/*
 * wei : ̽ڵ
 */
FS.SubTaskPane = FS.extend(FS.Widget, {
	init : function() {
		var self = this;
		this.element = $('<div/>').attr('id', 'fs_processsubtaskpane');
		var title = $('<div/>').addClass('fs_processdesignpanetitle').text(FR.i18nText("Son")+FR.i18nText("WF-Process")+FR.i18nText("Set")).appendTo(this.element);
		this.taskname = new FR.TextEditor({
			width : 113,
			height : 18
		});
		this.taskname.on(FR.Events.AFTEREDIT, function() {
			if(self.task) {
				self.task.setName(self.taskname.getValue());
				self.task.processDefine.repaint();
			}
		});
		$("<div/>").append($("<span/>").text(FR.i18nText("Activity")+FR.i18nText("WF-Name")+FR.i18nText("colon")).css({
			"float" : "left",
			"padding-left" : "5px"
		})).append(this.taskname.element.css('float', 'left'))
			.css({
				width : '180px',
				height : '18px',
				'padding-top' : '5px'
			}).appendTo(this.element);
		this.process = new FS.Combobox({
			width : 113,
			height : 18,
			items : [],
			directEdit : true
		});
		this.process.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getProcessNames());
		});
		this.process.on(FR.Events.AFTEREDIT, function() {
			self.task.setSubName(self.process.getValue());
		});
		$("<div/>").append($("<span/>").text(FR.i18nText("Select")+FR.i18nText("WF-Process")+FR.i18nText("colon")).css({
			"float" : "left",
			"padding-left" : "5px"
		})).append(this.process.element.css('float', 'left'))
			.css({
				width : '180px',
				height : '18px',
				'padding-top' : '5px'
			}).appendTo(this.element);
	},
	getProcessNames : function() {
		return FS.Design.processDiagramPane.processPane.getAllNames(this.task.processDefine.getName());
	},
	popTask : function(task) {
		this.clearAll();
		this.task = task;
		this.taskname.setValue(task.name);
		this.process.setValue(task.subname);
	},
	clearAll : function() {
		this.taskname.setValue('');
		this.process.setValue('', false);
	},
	show : function() {
		this.element.show();
	},
	hide : function() {
		this.element.hide();
	}
});

/*
 * wei : չʾϢ壬ɲأϢ
 */
FS.ProcessInfoPane = FS.extend(FS.Widget, {
	init : function() {
		this.element = $('<div/>').attr('id', 'fs_processinfopane');
		this.showhideText = new FS.ShowHideWidget({
			widgetConfig : {
				style : {
					'color' : '#00618A',
					'font-weight' : 'bold'
				},
				width : 100,
				height : 20,
				type : 'text'
			},
			style : {
				'font' : 'bold 15px arial,tahoma,verdana,helvetica',
				'color' : '#00618A',
				'text-overflow' : 'ellipsis',
				'overflow' : 'hidden',
				'white-space' : 'nowrap'
			}
		});
		var self = this;
		this.showhideText.valueChange = function() {
			self.triggerNameChange();
		}
		this.showhideText.element.css('float', 'left').appendTo(this.element);	
		this.showPane = $('<div/>').addClass('fs_processbar_show').appendTo(this.element);
		$('<div/>').text(FR.i18nText("Finish")+FR.i18nText("And")+FR.i18nText("Back")).css({
			font : '14px arial,tahoma,verdana,helvetica',
			color : '#368DAC',
			'text-decoration' : 'underline',
			cursor : 'pointer'
		}).appendTo(this.element).click(function() {
			FS.Design.showDesign({
				text : FR.i18nText("WF-Process")+FR.i18nText("Management"),
				id : 13
			});
		});	
	},
	setValue : function(value) {
		this.showhideText.setValue(value);
	},
	getValue : function() {
		return this.showhideText.getValue();
	},
	triggerNameChange : function() {
		var self = this;
		if(this.nameChange) {
			self.nameChange.apply();
		}
	}
});

FS.ProcessEditPane = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_processedit');
		//this.initNamePane();
		this.initMainPane();
		//this.generatePrevent();
		this.layout();
		this.resize(config);
	},
	
	initNamePane : function() {
		//b:bar copy from auth
			var positionbar = $('<div/>').attr('id', 'fs_auth_officebar');

			var self = this;
			this.addprocess = new FS.IconButton({
				title : FR.i18nText("add")+FR.i18nText("WF-Process"),
 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
 				baseClass : 'fr_auth_addposition',
 				handler : function() {
 					FS.showPromoteDialog({
 						title : FR.i18nText("add")+FR.i18nText("WF-Process"),
                        contentText : FR.i18nText("WF-Process")+FR.i18nText("SingleName")+FR.i18nText("colon"),
 						callback : function(name) {
 							self.addNewProcessDefine(name);
 						}
 					});
 				}
 			});
 			var editprocess = new FS.IconButton({
 				title : FR.i18nText("Edit")+FR.i18nText("Name"),
 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
 				baseClass : 'fr_auth_editposition',
 				handler : function() {
 					FR.showAsyncDialog({
 						title : FR.i18nText("Edit")+FR.i18nText("WF-Process"),
                        text : FR.i18nText("WF-Process")+FR.i18nText("SingleName")+FR.i18nText("colon")+self.getSelectedName(),
 						callback : function(name) {
 							self.setNewName(name);
 						}
 					});	
 				},
 				disabled : true
 			}), removeprocess = new FS.IconButton({
 				title : FR.i18nText("Delete")+FR.i18nText("WF-Process"),
 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
 				baseClass : 'fr_auth_removeposition',
 				handler : function() {
 					FR.showAsyncDialog({
 						callback : function() {
 							self.removeSelectedProcessDefine();
 						}
 					});					
 				},
 				disabled : true
 			}), saveprocess = new FS.IconButton({
 				title : FR.i18nText("Save")+FR.i18nText("WF-Process"),
 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
 				baseClass : 'fs_process_save',
 				handler : function() {
 					self.saveProcessDefine();					
 				},
 				disabled : true
 			});

			this.processList = new FS.BarList({
				barcontent : positionbar,
				items : [],
				width : 150,
				height : 560
			});
			
			this.processList.on(FR.Events.CLICK, function() {
				editprocess.setEnable(true);
				removeprocess.setEnable(true);
				saveprocess.setEnable(true);	
				self.setEnable(true);
				self.showProcess();
			});
//			this.processList.list.on(FR.Events.BEFORESTATECHANGE, function() {
//				var process = this.getSelectedData();
//				
//			});
			this.processList.on(FR.Events.NOSELECT, function() {
				editprocess.setEnable(false);
				removeprocess.setEnable(false);	
				saveprocess.setEnable(false);	
				self.setEnable(false);
			});
			this.processList.on(FR.Events.APPENDDATA, function(process) {
				if (!process.text) {
					process.text = process.name;
				}
			});
			this.processList.on(FR.Events.EDITDATA, function(process) {
//				FS.Trans.saveProcess(process);
//				process.text = process.name;
			});
			this.processList.on(FR.Events.REMOVEDATA, function(process) {
				var process = process.getContent();
				process.clearState();
				FS.Trans.removeProcess(process.name);
				if (FS.Process && FS.Process.refreshProcess){
					FS.Process.refreshProcess();
					FS.Process.refreshTask();
				}
			});
			
			setTimeout(function() {
				var properties = FS.Trans.getAllProcess();
				var processes = [];
				for (var i = 0, len = properties.length; i < len; i++) {
					var process = new FS.ProcessDefine(properties[i]);
					process.text = process.name;
					processes.push(process);
					FS.ProcessMananger.addProcess(process);
				}
				self.processList.popData(processes);
			}, 50);
	},
	
	getProcessPara : function(name) {
		var data = this.processList.list.options.data;
		for (var i = 0, len = data.getLength(); i < len; i++) {
			var record = data.getRecord(i);
			if (record.getShowValue() == name) {
				var ps = [], paras = record.getContent().parameters;
				for (var j = 0, jen = paras.length; j < jen; j++) {
					ps[j] = {
						text : paras[j].name,
						value : paras[j].name
					};
				}
				return ps;
			}
		}
		return null;
	},
	
	//b:ʱ򵥴
	getAllNames : function(name) {
		var alldata = this.allProcessNames;
		if(!alldata) {
			return [];
		}
		for (var i = 0, len = alldata.length; i < len; i++) {
			if (name == alldata[i].text) {
				alldata.remove(alldata[i]);
				break;
			}
		}
		return alldata;
	},
	
	getSelectedName : function() {
		//return this.processList.getSelectedData().name;
		return this.process.name;
	},
	
	generatePrevent : function() {
		this.prevent = $('<div/>').addClass('fr-window-mask').css('z-index', 10);
		this.element.append(this.prevent);
	},
	
	setEnable : function(enable) {
		if (enable) {
			this.prevent.hide();
		} else {
			this.prevent.show();
		}
	},
	
	showProcess : function(process) {
		process.registerEvent();
		process.resizeContainer();
		process.paint();		
		this.mainPane.showProcess(process);
		this.process = process;
		process.fireEvent('click', process.getMouseClickOb());
	},
	
	addNewProcessDefine : function(name) {
		this.process = FS.ProcessMananger.getNewProcess(name);
		//this.processList.addData(process);
	},
	
	//b:ɾ
	saveProcessDefine : function() {
		//var process = this.processList.getSelectedData();

		var id = FS.Trans.saveProcess(this.process);
		var message = FR.i18nText("WF-Process")+FR.i18nText("Saved_successfully")+FR.i18nText("Exclamation_mark");
		if (!/^\d+$/.test(id)) {
			message = FR.i18nText("WF-Process")+FR.i18nText("Save")+FR.i18nText("Failed")+FR.i18nText("Exclamation_mark");
		} else if (FS.Process && FS.Process.refreshProcess){
			FS.Process.refreshProcess();
		}
		this.process.id = id;
		FR.Msg.toast(message);
	},
	
	setNewName : function(name) {
		//var process = this.processList.getSelectedData();
		this.process.text = name;
		this.process.setName(name);
		//this.processList.list.editItem(process);
	},
	
//	removeSelectedProcessDefine : function() {
//		this.processList.removeSelectedData();
//	},
	
	initMainPane : function() {
		this.mainPane = new FS.ProcessMainPane();
	},
	
	//b:fsָ߲죬ṹ򵥣ظ
	layout : function() {
		//var pe = this.processList.element; 
		var mp = this.mainPane.element;
//		pe.css({
//			position : 'absolute',
//			left : 10,
//			top : 10
//		});
		mp.css({
			position : 'absolute',
			left : 0,
			top : 10
		});
//		this.prevent.css({
//			position : 'absolute',
//			left : 170,
//			top : 10
//		})
		this.element
		.append(mp)
		//.append(pe);
	},
	
	resize : function(rec) {
		this.element.width(rec.width).height(rec.height);
//		this.processList.element.height(rec.height - 10);
//		this.processList.list.element.height(rec.height - 35);
//		if (rec) {
//			rec.width = rec.width - 170;
//			rec.height = rec.height - 10;
//		} else {
//			rec = {
//				width : this.element.width() - 170,
//				height : this.element.height()
//			};
//		}
		this.mainPane.resize(rec);
		//this.prevent.width(rec.width).height(rec.height);
	}
});

FS.ProcessMainPane = FS.extend(FS.Widget, {
	init : function() {
		this.element = $('<div/>').attr({id : 'fs_process_mainpane'});	
		//this.initProcessBasePane();	
		this.initProcessPane();
		this.initTaskPane();
		this.initProcessInfoPane();
		this.initProcessDragPane();
		this.initNormalTaskPane();
		this.initSubTaskPane();
		this.layout();
	},
	
	initProcessInfoPane : function() {
		this.processInfoPane = new FS.ProcessInfoPane();
		var self = this;
		this.processInfoPane.nameChange = function() {
			var name = self.processInfoPane.getValue();
			self.process.text = name;
			self.process.setName(name);
			self.process.saveProcess();
		}
	},
	
	initProcessDragPane : function() {
		this.processDragPane = new FS.ProcessDragPane();
		this.regDrag(this.processDragPane.circle, 'endtask');
		this.regDrag(this.processDragPane.square, 'formtask');  
		this.regDrag(this.processDragPane.sub, 'subprotask');
	},
	initNormalTaskPane : function() {
		this.normalTaskPane = new FS.NormalTaskPane();
		this.normalTaskPane.hide();
	},
	initSubTaskPane : function() {
		this.subTaskPane = new FS.SubTaskPane();
		this.subTaskPane.hide();
	},
	
	initProcessBasePane : function() {
		this.processBase = new FS.ProcessBase();
	},
	
	initProcessPane : function() {
		this.processPane = new FS.ProcessPane();
	},
	
	initTaskPane : function() {
		this.taskPane = new FS.TaskPane({
			container : this
		});
	},
	regDrag : function(el, type) {
		if (!el) {
			return;
		}
		el.draggable({
			//containment : this.element,
			helper : "clone",
			revert: "invalid"
		});
	},
	showProcess : function(process) {
		//this.processBase.popProcess(process);
		this.processInfoPane.setValue(process.name);
		this.processPane.popProcess(process);
		this.normalTaskPane.setProcess(process);
		this.processDragPane.processParaNumberBar.setNumberValue(process.getParameters().length);
		this.processDragPane.setProcess(process);
		this.process = process;
		var self = this;
		this.taskPane.designer = this.processPane.designer;
		this.processPane.designer.addEvent('click', function(task) {
			if(!task) {
				return ;
			}
			var type = task.getType();
			if (type == 'formtask') {
				self.subTaskPane.hide();
				self.normalTaskPane.show();
				self.normalTaskPane.popTask(task);
			}
			if (type == 'subprotask') {
				self.normalTaskPane.hide();
				self.subTaskPane.show();
				self.subTaskPane.popTask(task);
			}
		});
	},
	
	getProcess : function() {
		this.processPane.getProcess();
	},
	
	//b:ѡеһtask
	initState : function() {
		
	},
	
	layout : function() {
		var 
		//be = this.processBase.element, 
			pe = this.processPane.element, te = this.taskPane.element,
			de = this.processDragPane.element, ne = this.normalTaskPane.element,
			se = this.subTaskPane.element, pie = this.processInfoPane.element;
//		this.absoluteLayout(be, {
//			top : 0,
//			left : 0,
//			height : 20
//		});
		this.absoluteLayout(pe, {
			top : 0,
			left : 210
		});
		this.absoluteLayout(te, {
			bottom : 0,
			left : 0,
			height : 10
		});
		this.absoluteLayout(de, {
			top : 70,
			left : 5
		});
		this.absoluteLayout(ne, {
			top : 235,
			left : 5
		});
		this.absoluteLayout(se, {
			top : 235,
			left : 5
		});
		this.absoluteLayout(pie, {
			top : 10,
			left : 25
		});
		//ne.hide();
		this.element.append(de).append(ne).append(pe).append(se).append(pie);
	},
	
	absoluteLayout : function(el, config) {
		el.css($.extend({
			position : 'absolute'
		}, config));
	},
	
	resize : function(rec) {
		this.element.height(rec.height).width(rec.width);
		//this.processBase.element.width(rec.width);
		this.taskPane.resize(rec);
		//204 : this.processDragPane.element.outerWidth()
		this.processPane.resize({
			width : rec.width - 204 - 20,
			height : rec.height
			// - this.processBase.element.height()
		});
		
	}
});

FS.ProcessPane = FS.extend(FS.Widget, {
	init : function() {
		this.element = $('<div/>').attr({
			id : 'fs_process_pane'
		}).mousedown(function(e) {
			//b:opera onselect 
			return false;
		});
		//this.initDragBar();
		this.initDesignArea();
		this.layout();
	},
	
	initDragBar : function() {
		this.dragBar = $('<div/>').attr('id', 'fs_process_dragbar').appendTo(this.element);
		var circle = $('<div/>').attr('id', 'fs_process_dragcircle').attr('title', FR.i18nText("fs_initDragBar_circle_tip")),
			rect = $('<div/>').attr('id', 'fs_process_dragrect').attr('title', FR.i18nText("fs_initDragBar_rect_tip")),
			subpro = $('<div/>').attr('id', 'fs_process_dragsubpro').attr('title', FR.i18nText("fs_initDragBar_subpro_tip"));
		this.dragBar.append(circle).append(rect).append(subpro);		
		this.regDrag(circle, 'endtask');
		this.regDrag(rect, 'formtask');  
		this.regDrag(subpro, 'subprotask');
		this.dragBar.attr('title', FR.i18nText("fs_initDragBar_title_tip"));
		//b:¾ todo
		circle.mousedown(function() {
			circle.addClass('fs_process_selectedtask');
			rect.removeClass('fs_process_selectedtask');
			subpro.removeClass('fs_process_selectedtask');
		});
		rect.mousedown(function() {
			circle.removeClass('fs_process_selectedtask');
			rect.addClass('fs_process_selectedtask');
			subpro.removeClass('fs_process_selectedtask');
		});
		subpro.mousedown(function() {
			circle.removeClass('fs_process_selectedtask');
			subpro.addClass('fs_process_selectedtask');
			rect.removeClass('fs_process_selectedtask');
		});
		this.showPane = $('<div/>').addClass('fs_processbar_show').appendTo(this.dragBar);
		this.initUndoButton();
	},
	
	initUndoButton : function() {
		var self = this;
		this.undo = new FS.IconButton({
			title : FR.i18nText("undo"),
 			renderEl : $('<div/>'),
 			width : 24,
 			height : 24,
 			baseClass : 'fs_process_undo',
 			disabled : true,
 			handler : function() {
 				self.designer.undo();
 			}
 		});
 		this.redo = new FS.IconButton({
			title : FR.i18nText("revert"),
 			renderEl : $('<div/>'),
 			width : 24,
 			height : 24,
 			disabled : true,
 			baseClass : 'fs_process_redo',
 			handler : function() {
 				self.designer.redo();
 			}
 		});
 		//this.dragBar.append($('<div/>').addClass('fs_processbar_tools').append(this.undo.element).append(this.redo.element));
	},
	
	regDrag : function(el, type) {
		if (!el) {
			return;
		}
		el.draggable({
			containment : this.element,
			helper : 'clone',
			revert: "invalid"
		});
	},
	
	initDesignArea : function() {
		this.designArea = $('<div/>').attr('id', 'fs_process_designArea').appendTo(this.element);
		var outcan = this.createCanvasContent(6, "fs_processdesign_state");
		this.designArea.append(this.createCanvasContent(1, "fs_processdesign_shape"))
			.append(this.createCanvasContent(2, "fs_processdesign_transition"))
			.append(this.createCanvasContent(3, "fs_processdesign_name"))
			.append(this.createCanvasContent(4, "fs_processdesign_cell"))
			.append(this.createCanvasContent(5, "fs_processdesign_over"))
			.append(outcan);
		var self = this;
		outcan.droppable({
			drop : function(e, ui) {
				var id = ui.draggable.attr('id');
				if(!id) {
					return ;
				}
				$('.ui-draggable-dragging').remove();
				if (!self.designer) {
					return;
				}
				var type = 'endtask';
				if (id.indexOf('square') > 0) {
					type = 'formtask';
				} else if (id.indexOf('sub') > 0) {
					type = 'subprotask';
				}
				self.designer.addNewTask(FS.getPosition(e), type);
			}
		});
	},
	
	createCanvasContent : function(zdx, id) {
		return $('<div/>').css({
			position : 'absolute',
			left : 0,
			top : 0,
			height : 500,
			width : 900,
			'z-index' : zdx
		}).append($('<canvas/>').attr('id', id).attr({
			height : 500,
			width : 900
		}));
	},
	
	expandOrCollapseDesigner : function(height) {
		this.element.height(height);
		this.designArea.height(height);
		this.dragBar.height(height);
	},
	
	layout : function() {
//		this.absoluteLayout(this.dragBar, {
//			top : 0,
//			left : 0,
//			height : 30
//		});
		this.absoluteLayout(this.designArea, {
			top : 0,
			left : 0
		});
	},
	
	absoluteLayout : function(el, config) {
		el.css($.extend({
			position : 'absolute'
		}, config));
	},
	
	resize : function(rec) {
		this.element.width(rec.width).height(rec.height);
		//this.dragBar.width(rec.width);
		this.designArea.height(rec.height - 30);
		this.designArea.width(rec.width - 10);
	},
	
	popProcess : function(process) {
		this.designer = process;
		var self = this;
		//this.undo.setEnable(this.designer.canUndo());
		//this.redo.setEnable(this.designer.canRedo());
		this.designer.addNoRepeatEvent(FS.Events.UNDO, function() {
//			self.undo.setEnable(this.canUndo());
//			self.redo.setEnable(this.canRedo());
		});
		this.designer.addNoRepeatEvent(FS.Events.PROCESSSTARTSAVE, function() {
			self.showStartSave();
		});
		this.designer.addNoRepeatEvent(FS.Events.PROCESSSAVEFINISH, function() {
			self.showSaveFinish();
		});			
	},
	
	//b:interval
	showStartSave : function() {
		//this.showPane.text('.');
		FS.Design.processDiagramPane.processPane.mainPane.processInfoPane.showPane.text(FR.i18nText("Saving")+'.');
	},
	
	showSaveFinish : function() {
		FS.Design.processDiagramPane.processPane.mainPane.processInfoPane.showPane.text(FR.i18nText("Finish_Save")+'.');
		//this.showPane.text('.');
	},
	
	getProcess : function() {
		return this.designer ? this.designer.getProcess() : null;
	}
});

//FS.ProcessBase = FS.extend(FS.Widget, {
//	limitParaLength : 3,
//	
//	init : function() {
//		this.element = $('<div/>').attr('id', 'fs_process_base').height(20);
//		this.initPane();
//	},
//	
//	initPane : function() {
//		var self = this;
//		this.paraPane = $('<div/>').addClass('fs_process_basepara').append($('<span/>').text(':')).append(this.createAddParaText());
//		
//		this.triText = $('<span/>').addClass('fs_process_basetext').text('ֶ').click(function(e) {
//			self.generateTriggerPane();
//		});
//		this.triPane = $('<div/>').addClass('fs_process_basetrigger').append($('<span/>').text(':')).append(this.triText);
//		this.element.append(this.paraPane).append(this.triPane);
//	},
//	
//	popProcess : function(process) {
//		this.process = process;
//		this.checkParameters4Base();
//		this.checkTrigger4Base();
//	},
//	
//	checkParameters4Base : function() {
//		$($('span', this.paraPane)[0]).siblings().remove();
//		var paras = this.process.parameters;
//		if (this.process && paras && paras.length > 0) {
//			var len = Math.min(this.limitParaLength, paras.length);
//			for (var i = 0; i < len; i++) {
//				this.paraPane.append(this.createParaText(paras[i].name));				
//			}
//			if (paras.length > len) {
//				this.paraPane.append(this.createParaText("..."));
//			}
//		}
//		this.paraPane.append(this.createAddParaText());
//	},
//	
//	createAddParaText : function() {
//		return this.createParaText('').css('margin-left', 12);
//	},
//	
//	//b:removeʱպϰܲͷ
//	createParaText : function(text) {
//		var self = this;
//		return $('<span/>').addClass('fs_process_basetext').text(text).click(function() {
//			self.generateParametersPane();
//		});
//	},
//	
//	checkTrigger4Base : function() {
//		var text = 'ֶ';
//		if (this.process && this.process.trigger) {
//			text = 'Զ';
//		}
//		this.triText.text(text);
//	},
//	
//	generateParametersPane : function() {
//		//if (!this.parametersPane) {
//			this.parametersPane = new FS.ParametersPane({});
//			var self = this;
//			function confire() {
//				self.process.itemChanged = self.parametersPane.parasTable.itemChanged;
//				self.process.setParameters(self.parametersPane.getParameters());
//				if(self.parametersPane.isShareProcessName()) {
//					var shareProcessName = self.parametersPane.getShareProcessName();
//					self.process.setShareProcessName(shareProcessName);
//					var shareProcess = FS.ProcessMananger.getProcessByName(shareProcessName);
//					if(shareProcess) {
//						self.process.setProperty('parameters', shareProcess.getParameters());
//					}	
//				} else {
//					self.process.setShareProcessName('');
//				}
//				self.checkParameters4Base();
//			}
//		//}
//		if (this.process) {
//			this.parametersPane.popParameters(this.process.parameters);
//			this.parametersPane.popShareProcessName(this.process.shareProcessName);
//			this.process.setProperty('originalShareProcessName', this.parametersPane.getShareProcessName());
//		}
//		this.paraDialog.setVisible(true);
//	},
//	
//	generateTriggerPane : function() {
//		if (!this.triggerPane) {
//			this.triggerPane = new FS.TriggerPane({
//				
//			});
//			var self = this;
//			function confire() {
//				self.process.setTrigger(self.triggerPane.getTrigger());
//				self.checkTrigger4Base();
//			}
//		}
//		
//		if (this.process) {
//			this.triggerPane.popTrigger(this.process.trigger);
//		}
//		this.triggerDialog.setVisible(true);
//	}
//});

//b: reportwidgetظȡΪؼ
FS.ParametersPane = FS.extend(FS.Widget, {
	init : function() {
		this.element = $('<div/>').addClass('fs_process_addpara');
		this.initPane();
	},
	
	initPane : function() {
		this.paraChanged = false;
		var bar = $('<div/>').attr('id', 'fs_reportadd_opbar'), self = this;
		var parasTable;
		var self = this;
		var addPara = new FR.IconButton({
				text : FR.i18nText("add")+FR.i18nText("Parameters"),
				renderEl : $('<span>&nbsp;</span>'),
				baseClass : 'fs_reportadd_addpara',
				height : 21,
				width : 21,
				handler : function() {
					parasTable.uiAddData();
				}
		}), editPara = new FR.IconButton({
				text : FR.i18nText("Edit")+FR.i18nText("Parameters"),
				renderEl : $('<span>&nbsp;</span>'),
				baseClass : 'fs_reportadd_editpara',
				disabled : true,
				height : 21,
				width : 21,
				handler : function() {
					parasTable.uiEditData();
				}
		}), removePara = new FR.IconButton({
				text : FR.i18nText("Delete")+FR.i18nText("Parameters"),
				renderEl : $('<span>&nbsp;</span>'),
				height : 21,
				width : 21,
				baseClass : 'fs_reportadd_removepara',
				disabled : true,
				handler : function() {
					parasTable.uiRemoveData();
				}
		});
		this.refreshPara = new FR.IconButton({
				text : FR.i18nText("Import2")+FR.i18nText("Parameters"),
				renderEl : $('<span>&nbsp;</span>'),
				baseClass : 'fs_reportadd_loadpara',
				disabled : true,
				height : 21,
				width : 21,
				handler : function() {
					parasTable.popData(FS.Trans.getReportParas(self.path.getValue()));
				}
		});
		//bar.append(addPara.element).append(editPara.element).append(removePara.element).append(this.refreshPara.element);
		parasTable = this.parasTable = new FS.LGrid({
				cls : 'fs_reportadd_parasTable',
				height : 220,
				columnsconfig : [{
					text : 'name',
					showValue : FR.i18nText("FormulaD-Data_Fields")+FR.i18nText("WF-Name"),
					width : 180,
					sort : false,
					widget : {type : 'text', allowBlank : false, errorMsg :  FR.i18nText("FormulaD-Data_Fields")+FR.i18nText("SingleName")+FR.i18nText("NOT_NULL_Des")+FR.i18nText("Exclamation_mark"),
						style : {
							'color' : '#00618A',
							'text-align' : 'center'						
						}
					}
				}, {
					text : 'type',
					showValue : FR.i18nText("Type"),
					width : 180,
					widget : {type : 'combo', items : [{text:FR.i18nText("Parameter-String"), value : 'String'},
														 {text:FR.i18nText("Number"), value : 'Double'},
														 {text:'Long', value : ' Long'},
														  {text:FR.i18nText("Date"), value : 'Date'},
														  {text:FR.i18nText("Parameter-Boolean"), value : 'Boolean'},
														  {text:FR.i18nText("Formula"), value : 'Formula'},
														  {text:FR.i18nText("SingleMulti")+FR.i18nText("Field"), value : 'Multi'}], allowBlank : false, errorMsg : FR.i18nText("Type")+FR.i18nText("NOT_NULL_Des")+FR.i18nText("Exclamation_mark") ,
								listeners : [{eventName : 'afteredit', action : function(){
									if(this.getValue() == 'Multi') {
										self._createMultiEditors(this);
									}
								}}]
							 },
							  style : {
								  'color' : '#00618A',
								  'text-align' : 'center'						
							  }
				}
				],
				items : []
		});
		parasTable.itemChanged = false;
		parasTable.loading(true);
		parasTable.on(FS.Events.SELECTDATA, function() {
				editPara.setEnable(true);
				removePara.setEnable(true);
		});
			
		parasTable.on(FS.Events.NOSELECT, function() {
				editPara.setEnable(false);
				removePara.setEnable(false);
		});
		this.createShareProcessDiv();
		this.element.append(parasTable.element);
		$('<div/>').addClass('fs_para_message').text(FR.i18nText("fs_process_para_message_tip")).appendTo(this.element);
	},
	
	_createParaTextEditor : function(widget) {
		var self = this;
		return new FR.TextEditor({
			allowBlank : false, 
			errorMsg :  FR.i18nText("FormulaD-Data_Fields")+FR.i18nText("SingleName")+FR.i18nText("NOT_NULL_Des")+FR.i18nText("Exclamation_mark"),
			style : {
				'color' : '#00618A',
				'text-align' : 'center'						
			},
			width : 170,
			height : 18
//			,
//			listeners : [{eventName : 'stopedit', action : function() {
//				if(this.getValue() != '') {
//					self._createMultiEditors(widget);
//				}
//			}}]
		});
	},
	
	_createParaComboBoxEditor : function(widget) {
		var self = this;
		return new FR.ComboBoxEditor({
			items : [{text:FR.i18nText("Parameter-String"), value : 'String'},
						 {text:FR.i18nText("Number"), value : 'Double'},
						 {text:'Long', value : ' Long'},
						  {text:FR.i18nText("Date"), value : 'Date'},
						  {text:FR.i18nText("Parameter-Boolean"), value : 'Boolean'},
						  {text:FR.i18nText("Formula"), value : 'Formula'}],
			allowBlank : false, errorMsg :  FR.i18nText("Type")+FR.i18nText("NOT_NULL_Des")+FR.i18nText("Exclamation_mark"), width : 170, height : 18,
			listeners : [{eventName : 'afteredit', action : function() {
				if(this.getValue() != '') {
					self._createMultiEditors(widget);
				}
			}}]
		});
	},
	
	_createMultiEditors : function(widget) {
		var paraNameTextEditor = this._createParaTextEditor(widget);
		$($('.fs_gridlist_td', this.parasTable.activedTR)[0]).append(paraNameTextEditor.element);
		var paraTypeComboEditor = this._createParaComboBoxEditor(widget);
		$($('.fs_gridlist_td', this.parasTable.activedTR)[1]).append(paraTypeComboEditor.element);
		if(widget.element.data('multidata')) {
			widget.element.data('multidata').push({
				'name' : paraNameTextEditor,
				'type' : paraTypeComboEditor
			});
		} else {
			widget.element.data('multidata', [{
				'name' : paraNameTextEditor,
				'type' : paraTypeComboEditor
			}]);
		}
	},
	
	createShareProcessDiv : function() {
		var self = this;
		var shareParaDiv = $('<div/>').addClass('fs_para_shareprocess');
		var paraCheckBoxDiv = ($('<div/>')).addClass('fs_shareprocesscontainer').appendTo(shareParaDiv);
		var paraComboBoxDiv = ($('<div/>')).addClass('fs_shareprocesscontainer').appendTo(shareParaDiv);
		var items = FS.Design.processDiagramPane.processPane.getAllNames(FS.Design.processDiagramPane.processPane.getSelectedName());
		this.processComboBox = new FR.ComboBoxEditor({
			renderEl : paraComboBoxDiv,
			items : items,
			height : 18,
			width : 130,
			disabled : true
		});
		this.shareParaCheckBox = new FR.CheckBox({
			renderEl : paraCheckBoxDiv,
			text :FR.i18nText("quote")+FR.i18nText("already_has")+FR.i18nText("WF-Process")+FR.i18nText("FormulaD-Data_Fields")+FR.i18nText("colon"),
			value : false,
			width : 160
		});
		
		this.processComboBox.on(FR.Events.AFTEREDIT, function() {
			self.parasTable.itemChanged = true;	
		});
		this.shareParaCheckBox.on(FR.Events.STATECHANGE, function() {
            self.parasTable.itemChanged = true;
            var isSharePara = self.shareParaCheckBox.isSelected();
            if (isSharePara) {
             	self.processComboBox.enable();
            } else{
            	self.processComboBox.disable();
            }
        });
		this.element.append(shareParaDiv);
	},
	
	popParameters : function(parameters) {
		this.parasTable.popData(parameters);
	},
	
	popShareProcessName : function(shareProcessName) {
		this.processComboBox.setValue(shareProcessName);
		if(shareProcessName) {
			this.shareParaCheckBox.setValue(true);
		}
	},
	
	getParameters : function() {
		var self = this;
		$.each(this.parasTable.options.items, function(idx, item) {
			if(item.type == 'Multi') {
				item.value = [];
				var multis = self.parasTable.options.widgets[idx][1].element.data('multidata');
				for(var i = 0; i < multis.length; i ++) {
					item.value.push({
						name : multis[i].name.getValue(),
						type : multis[i].type.getValue()
					})
				}
			}
		});
		return this.parasTable.options.items;
	},
	
	getShareProcessName : function() {
		return this.processComboBox.getValue();
	},
	
	isShareProcessName : function() {
		return this.shareParaCheckBox.getValue();
	}
});

//b:ʱǱtriggerý棬Ҫͳһtodo
FS.TriggerPane = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').addClass('fs_process_trigger').css('margin', '0 12px');
		this.createPane();
	},
	
	popTrigger : function(trigger) {
		if (!trigger) {
			this.usetrigger.attr('checked', false);
			return;
		}
		this.setEnable(true);
		this.usetrigger.attr('checked', true);
		if (trigger.startType === 2) {
			$('#on', this.element).attr('checked', true);
			this.startTime.setValue(trigger.startTime);
		} else if (trigger.startType === 1) {
			$('#immediately', this.element).attr('checked', true);
		}
		if(trigger.recurrenceType == "once"){
			this.onceRadio.triggerHandler('click');
			this.onceRadio.attr('checked', true);
		} else if(trigger.recurrenceType == "simple"){
			this.simpleRadio.triggerHandler('click');
			this.simpleRadio.attr('checked', true);
			$('#recurrenceInterval', this.simplePane).val(trigger.recurrenceInterval);
			this.frequenceCombo.setValue(trigger.recurrenceIntervalUnit);
			if (trigger.repeatCount === -1) {
				$('#indifinitely', this.simplePane).attr('checked',true);
				$('#repeatCount', this.simplePane).val("");
				this.untiltime.setValue("");
			} else if (trigger.endTime) {
				$('#until', this.simplePane).attr('checked',true);
				$('#repeatCount', this.simplePane).val("");
				this.untiltime.setValue(trigger.endTime);
			} else if (trigger.repeatCount > -1) {
				$('#repeat', this.simplePane).attr('checked',true);
				$('#repeatCount', this.simplePane).val(trigger.repeatCount);
				this.untiltime.setValue("");
			}
		} else if(trigger.recurrenceType == "calendar"){
			this.calendarRadio.triggerHandler('click');
			this.calendarRadio.attr('checked', true);
			$('#minutes', this.calendarPane).val(trigger.minutes);
			$('#hours', this.calendarPane).val(trigger.hours);
			if(!trigger.dayType || trigger.dayType === 1){
				$('#everyday', this.calendarPane).attr('checked',true);
				for(var i = 0; i < this.weekdays.length; i++){
					this.weekdays[i][0].checked = false;
				}
				$('#monthdays', this.calendarPane).val("");
			} else if(trigger.dayType === 2){
					$('#weekday', this.calendarPane).attr('checked',true);
					weekdaystable.show();
					var checkeddays = trigger.weekDays.split(",");
					for(var j = 0; j < checkeddays.length; j++){
						for(var i = 0; i < this.weekdays.length; i++){
							if(checkeddays[j] === i+1){
								this.weekdays[i][0].checked = true;
								break;
							}
						}
					}
					$('#monthdays', this.calendarPane).val("");
				} else if(trigger.dayType === 3){
					$('#monthday', this.calendarPane).attr('checked',true);
					for(var i = 0; i < this.weekdays.length; i++){
						this.weekdays[i][0].checked = false;
					}
					$('#monthdays', this.calendarPane).val(trigger.monthDays);
				}
				if (trigger.months) {
					var checkedmonths = trigger.months.split(",");
					this.allmonths[0].checked = (checkedmonths.length === this.months.length);
					for(var j = 0; j< checkedmonths.length; j++){
						for(var i = 0; i < this.months.length; i++){
							if(checkedmonths[j] === i + 1){
								this.months[i][0].checked = true;
								break;
							}
						}
					}
				} else {
					this.allmonths[0].checked = false;
					for(var i = 0; i < this.months.length; i++){
						this.months[i][0].checked = false;
					}
				}
	
				if (iTrigger.endTime) {
					this.endtime.setValue(iTrigger.endTime);
				} else {
					$('#indifi', this.calendarPane).attr('checked',true);
					this.endtime.setValue("");
				}
		}
	},
	
	getTrigger : function() {
		if (!this.usetrigger[0].checked) {
			return;
		}
		if (!this.checkValue()) {
			return;
		}
		var trigger = {};
		if ($('#on', this.element).attr('checked')) {
			trigger.startType = 2;
			trigger.startTime = this.startTime.getValue();
		} else {
			trigger.startType = 1;
		}
		if ($('#once', this.element).attr('checked')) {
			trigger.recurrenceType = 'once';
		} else if ($('#simple', this.element).attr('checked')) {
			trigger.recurrenceType = 'simple';
			trigger.recurrenceInterval = $('#recurrenceInterval', this.simplePane).val();
			trigger.recurrenceIntervalUnit = this.frequenceCombo.getValue();

			if ($('#indifinitely', this.simplePane).attr('checked')) {
				trigger.repeatCount = -1;
			} else if ($('#until', this.simplePane).attr('checked')) {
				trigger.endTime = this.untiltime.getValue();
			} else if ($('#repeat', this.simplePane).attr('checked')) {
				trigger.repeatCount = $('#repeatCount', this.simplePane).val();
			}
		} else if ($('#carlendar', this.element).attr('checked')) {
			trigger.recurrenceType = 'calendar';
			trigger.minutes = $('#minutes', this.calendarPane).val();
			trigger.hours = $('#hours', this.calendarPane).val();
			if($('#everyday', this.calendarPane).attr('checked')){
				trigger.dayType = 1;
			} else if($('#weekday', this.calendarPane).attr('checked')){
				trigger.dayType = 2;
				var checkeddays = [];
				for(var i = 0; i < this.weekdays.length; i++){
					if(this.weekdays[i][0].checked){
						checkeddays.push(i+1);
					}
				}
				trigger.weekDays = checkeddays.toString();
			} else if($('#monthday', this.calendarPane).attr('checked')){
				trigger.dayType = 3
			}
			var checkedmonths = [];
			for(var i = 0; i < this.months.length; i++){
				if(this.months[i][0].checked){
					checkedmonths.push(i+1);
				}
			}
			trigger.months = checkedmonths.toString();
	
			trigger.endTime = $('#indifi', this.calendarPane).attr('checked') ? "" : this.endtime.getValue();
		}
		return trigger;
	},
	
	checkValue : function() {
		if (!$('#on', this.element).attr('checked') && !$('#immediately', this.element).attr('checked')) {
			return;	
		}
		if (!$('#once', this.element).attr('checked') && !$('#simple', this.element).attr('checked') && !$('#carlendar', this.element).attr('checked')) {
			return;
		}
		return true;
	},
	
	generatePrevent : function() {
		this.prevent = $('<div/>').addClass('fr-window-mask').css('z-index', 10).css({
			position : 'absolute',
			top : 20,
			width : 520,
			height : 480
		});
		this.element.append(this.prevent);
	},
	
	setEnable : function(enable) {
		if (enable) {
			this.prevent.hide();
		} else {
			this.prevent.show();
		}
	},
	
	createPane : function() {
		var self = this;
		this.generatePrevent();
		this.usetrigger = $('<input type="checkbox" id="usetrigger">').click(function(e) {
			if (this.checked) {
				self.setEnable(true);
			} else {
				self.setEnable(false);
			}
		});
		
		$('<div/>').append(this.usetrigger).append($('<span/>').text(FR.i18nText("Use")+FR.i18nText("fixedTime")+FR.i18nText("trigger"))).appendTo(this.element);
		this.startTime = new FR.DateTimeEditor(this.timeConfig());
        var table_tip= FR.i18nText("Task")+FR.i18nText("FS_Start_Time")+FR.i18nText("Set")+FR.i18nText("colon");
        var immediately_tip = FR.i18nText("Task")+FR.i18nText("Set")+FR.i18nText("Finish")+FR.i18nText("SingleAfter")+FR.i18nText("start_immidiately")+FR.i18nText("period");
        var on_tip=FR.i18nText("Set")+FR.i18nText("FS_Start_Time")+FR.i18nText("colon");
        var p_tip =FR.i18nText("fs_process_p_tip");
        var frequentTitle_tip = FR.i18nText("Task")+FR.i18nText("ExecuteFrequency")+FR.i18nText("colon");
        var table_tipJqueryName='<tr><td><p>'+table_tip+'</p></td></tr></table>';
        var immediately_tipJqueryName='<tr><td><input type="radio" name="start" value=1 id="immediately"/>'+immediately_tip+'</td></tr>';
        var on_tipJqueryName = '<tr><td><input type="radio" name="start" value=2 id="on"/>'+on_tip+'</td></tr>';
        var p_tipJqueryName = '<p>'+p_tip+'</p>';
        var frequentTitle_tipJqueryName =  '<p class="frequentTitle">'+frequentTitle_tip+'</p>';
		this.element.append($('<table/>').append($(table_tipJqueryName))
			.append($(immediately_tipJqueryName))
			.append($(on_tipJqueryName).append($('<td/>').append(this.startTime.element))));
		$(p_tipJqueryName).appendTo(this.element);
		var recurrenceType = $(frequentTitle_tipJqueryName).appendTo(this.element);
		var recurrenceRadios = $('<div/>').appendTo(this.element);
		var recurrencePane = $('<div></div>').appendTo(this.element);

		var oncePane = this.createOncePane();
		oncePane.appendTo(recurrencePane).hide();
		var simplePane = this.createSimplePane();
		simplePane.appendTo(recurrencePane).hide();
		var calendarPane = this.createCalendarPane();
		calendarPane.appendTo(recurrencePane).hide();
		
		this.onceRadio = $('<input type="radio" name="recurrenceType" value="once" id="once">')
		.click(function(){
			oncePane.show();
			simplePane.hide();
			calendarPane.hide();
		}).appendTo(recurrenceRadios);
		var tip1 =FR.i18nText("fs_process_one_time_task_tip");
        var tip2 =FR.i18nText("Only")+FR.i18nText("ExecuteOneTime");
        var one_time_task_jquery_name='<span title='+tip1+' style="padding-right:5px">'+tip2+'</span>'
		$(one_time_task_jquery_name).appendTo(recurrenceRadios);
		this.simpleRadio = $('<input type="radio" name="recurrenceType" value="simple" id="simple">')
		.click(function(){
			oncePane.hide();
			simplePane.show();
			calendarPane.hide();
		}).appendTo(recurrenceRadios);
        var simpleRepeatJqueryName =  '<span title='+FR.i18nText("fs_process_log_tip")+' style="padding-right:5px">'
            +FR.i18nText("ExecuteSimpleRepeat")+'</span>';
		$(simpleRepeatJqueryName).appendTo(recurrenceRadios);
		this.calendarRadio = $('<input type="radio" name="recurrenceType" value="calendar" id="calendar">')
		.click(function(){
			oncePane.hide();
			simplePane.hide();
			calendarPane.show();
		}).appendTo(recurrenceRadios);
        var selfDefineJqueryName = '<span title='+FR.i18nText("FrequencySet")+' style="padding-right:5px">'
            +FR.i18nText("Custom")+FR.i18nText("Repeat")+FR.i18nText("Execute")+'</span>';
		$(selfDefineJqueryName).appendTo(recurrenceRadios);
		
	},
	
	createOncePane : function() {
        var oncePaneJqueryName ="<div><p class='frequentTitle'>"+FR.i18nText("Task")+FR.i18nText("FS_End_Time")+FR.i18nText("Set")+FR.i18nText("colon")+"</p></div>";
		var oncePane = this.oncePane = $(oncePaneJqueryName);
        var tipJqueryName =  "<div><input type='checkbox' checked disabled></input>"
            +FR.i18nText("Task")+FR.i18nText("Task")+FR.i18nText("ExecuteOneTime")+FR.i18nText("SingleAfter")+FR.i18nText("After")+"</div>";
		$(tipJqueryName).appendTo(oncePane);
		return oncePane;
	},
	
	createSimplePane : function() {
			var simplePane = this.simplePane = $("<div/>");		
			var frequencetable = $('<table/>').appendTo(simplePane);
            var frequencetrJqueryName ='<tr><td><p>'+FR.i18nText("ExecuteFrequency")+FR.i18nText("colon")+FR.i18nText("Every")
                +'<input id="recurrenceInterval"/></p></td></tr>';
			var frequencetr = $(frequencetrJqueryName).appendTo(frequencetable);
			this.frequenceCombo = new FR.ComboBoxEditor({
				directEdit : true,
				allowBlank : false,
				width: 70,
				items: [{value: 1, text: FR.i18nText("Sche-Minute")},
						{value: 2, text: FR.i18nText("Sche-Hour")},
						{value: 3, text: FR.i18nText("Sun")},
						{value: 4, text: FR.i18nText("Week")}]
			});
			$('<td/>').append(this.frequenceCombo.element).appendTo(frequencetr);
			var occurtable = $('<table></table>').appendTo(simplePane);
            var occurtableJqueryName = '<tr><td><p class="frequentTitle">'+
                FR.i18nText("Task")+FR.i18nText("FS_End_Time")+FR.i18nText("Set")+FR.i18nText("colon")+'</p></td></tr>';
			$(occurtableJqueryName).appendTo(occurtable);
            var indifinitelyJqueryName = '<tr><td><input type="radio" name="occur" value="indifinitely" id="indifinitely"/>'
                +FR.i18nText("NoLimit")+'</td><td></td></tr>';
			var indifinitely = $(indifinitelyJqueryName).appendTo(occurtable);
            var untilJqueryName ='<tr><td><input type="radio" name="occur" value="until" id="until"/>'
                +FR.i18nText("FS_End_Time")+FR.i18nText("colon")+'</td></tr>';
			var until =  $(untilJqueryName).appendTo(occurtable);
			this.untiltime = new FR.DateTimeEditor(this.timeConfig());
			($('<td/>').append(this.untiltime.element)).appendTo(until);
            var ExtraExecuteTimeJqueryName = '<tr><td><input type="radio" name="occur" value="repeat" id="repeat"/>'
                +FR.i18nText("ExtraRepeatTime")+FR.i18nText("colon")+'</td><td><input id="repeatCount"/></td></tr>';
			$(ExtraExecuteTimeJqueryName).appendTo(occurtable);
			return simplePane;		
	},
	
	createCalendarPane : function() {
		var self = this;
		var calendarPane = this.calendarPane = $("<div/>");
		var timeTable = $('<table/>').appendTo(calendarPane);
        var mhJqueryName ='<tr><td><p>'+FR.i18nText("timePoint")+FR.i18nText("Set")+FR.i18nText("colon")
            +'</p></td><td><div><input id="hours"/>'+'('+FR.i18nText("Sche-Hour")+')'
            +'</div></td><td><div><input id="minutes"/>'+'('+FR.i18nText("Sche-Minute")+')'+'</div></td></tr>';
		var mh = $(mhJqueryName).appendTo(timeTable);
		var daystable = $('<table/>').appendTo(calendarPane);
		var dayCheckBox = $('<input type="radio" name="days" value=1 id="everyday"/>').click(function() {
			if (this.checked) {
				weekdaystable.hide();
			}
		});
		var dayTr = '<tr><td>'+FR.i18nText("Sun")+FR.i18nText("colon")+'</td></tr>';
        var everydaytd = '<td>'+FR.i18nText("Every")+FR.i18nText("Sun")+'</td>';
		var everyday = $(dayTr).append($('<td/>').append(dayCheckBox)).append(everydaytd).appendTo(daystable);
			
			
		var weekdaystr1 = $('<tr><td></td></tr>').appendTo(daystable);
		var weekdayCheckBox = $('<input type="radio" name="days" value=2 id="weekday"/>')
			.click(function() {
				if (this.checked) {
					weekdaystable.show();
				}
			});
		weekdaystr1.append($('<td valign="top"></td>').append(weekdayCheckBox));
        var weekdaystableJqueryName = '<table><tr><td>'+FR.i18nText("Week")+FR.i18nText("Short-Jan")+'</td><td>'
            +FR.i18nText("Week")+FR.i18nText("Short-Feb")+'</td><td>'
            +FR.i18nText("Week")+FR.i18nText("Short-Mar")+'</td><td>'
            +FR.i18nText("Week")+FR.i18nText("Short-Apr")+'</td><td>'
            +FR.i18nText("Week")+FR.i18nText("Short-May")+'</td><td>'
            +FR.i18nText("Week")+FR.i18nText("Short-Jun")+'</td><td>'
            +FR.i18nText("Week")+FR.i18nText("Short-Jul")+'</td></tr></table>';
		var weekdaystable = $();
        var weeklytdJqueryName = '<td>'+FR.i18nText("Every")+FR.i18nText("Week")+FR.i18nText("De")+'</td>';
		weekdaystable.wrap($(weeklytdJqueryName)).parent().appendTo(weekdaystr1);
		var weekdaystr2 = $('<tr></tr>').appendTo(weekdaystable);
		this.weekdays = [];
		for(var i=0; i < 7; i++){
			this.weekdays[i] = $('<input type="checkbox"/>');
			this.weekdays[i].wrap($('<td></td>')).parent().appendTo(weekdaystr2);
		}
		weekdaystable.hide();
			
		var monthCheckBox = $('<input type="radio" name="days" value=3 id="monthday"/>').click(function() {
			if (this.checked) {
				weekdaystable.hide();
			}
		});
        var monthlyJqueryName = '<td>'+FR.i18nText("Every")+FR.i18nText("Month")+FR.i18nText("De")+'<input id="monthdays"/>'+FR.i18nText("Sun")+'</td>';
		var monthdays = $('<tr><td></td></tr>').append($('<td/>').append(monthCheckBox)).append($(monthlyJqueryName)).appendTo(daystable);
		var monthstable = $('<table></table>').appendTo(calendarPane);
        var monthTipJqueryName = '<tr><td>'+FR.i18nText("Month")+FR.i18nText("colon")+'</td></tr>';
		var allmonthstr = $(monthTipJqueryName).appendTo(monthstable);
		this.allmonths = $('<input class="test" type="checkbox"/>')
			.click(function(){
				if(this.checked){
					for(var i = 0; i < self.months.length; i++){
						self.months[i][0].checked = true;
					}
				}
			});

			$('<td></td>').append(this.allmonths).appendTo(allmonthstr);
            var allJqueryName = '<td>'+FR.i18nText("All")+'</td>';
			$(allJqueryName).appendTo(allmonthstr);
			var monthstr = $('<tr><td></td></tr>').appendTo(monthstable);
			this.months = [];
			for(var i = 0; i < 12; i++){
				this.months[i] = $('<input type="checkbox"/>')
				.click(function(){
					if(!this.checked){
						self.allmonths[0].checked = false;
					}
				});
				this.months[i].wrap($('<td></td>')).parent().appendTo(monthstr);
			}
			
			var endtimeTable = $('<table></table>').appendTo(calendarPane);
            var endTimeSetJqueryName = '<tr><td><p class="frequentTitle">'+FR.i18nText("Task")+FR.i18nText("FS_End_Time")+FR.i18nText("Set")+FR.i18nText("colon")+'</p></td></tr>';
			$(endTimeSetJqueryName).appendTo(endtimeTable);
			var endtimeTRJqueryName = '<tr><td><input type="radio" name="occurcalendar" value="endtimeRadio" id="endtimeRadio"/>'
                +FR.i18nText("FS_End_Time")+FR.i18nText("colon")+'</td></tr>';
			var endtimeTR = $(endtimeTRJqueryName).appendTo(endtimeTable);
			var endtimediv = $('<div></div>').wrap($('<td></td>')).parent().appendTo(endtimeTR);
			this.endtime = new FR.DateTimeEditor(this.timeConfig());
			$('<td/>').append(this.endtime.element).appendTo(endtimeTR);
			return calendarPane;
	},
	
	timeConfig : function() {
		return {
			width : 180,
			disable : false,
			directEdit : true,
			format : "yyyy-MM-dd HH:mm:ss"
		};
	}
});

FS.NameReportChoose = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').addClass('fs_namereport');
		this.generateShowName(config);
		this.generateReportBlock(config);
	},
	
	generateShowName : function(config) {
		this.table = $('<table/>').attr({id : 'fs_reportadd_table', cellSpacing : 8}).appendTo(this.element);
		this.tbody = $('<tbody/>').appendTo(this.table);
		this.name = new FR.TextEditor({
			width : 120,
			height : 24
		});
		if (config.changeName) {
			this.name.on(FR.Events.AFTEREDIT, function() {
				config.changeName(this.getValue());
			});			
		}
		$('<tr/>').append($('<td/>').text((config.nameText ? config.nameText : FR.i18nText("WF-Name")) + ":")).append($('<td/>').width(150).append(this.name.element)).append($('<td/>').width(60)).appendTo(this.tbody);
	},
	
	
	generateReportBlock : function(config) {
		this.path = new FR.TextEditor({
			width : 150,
			height : 24,
			readonly : true
		});
		
		if (config.changeReport) {
			this.path.on(FR.Events.CHANGE, function(value, oldvalue) {
				if (value && value != oldvalue) {
					config.changeReport(value);
				}			
			});
		}
		var self = this;
		var viewButton = new FR.Button({
			text : FR.i18nText("Privilege_View"),
			width : 60,
			height : 20,
			handler : function() {
				self.chooseReport(self.path.getValue());
			}
		});
		$('<tr/>').append($('<td/>').text((config.reportName ? config.reportName : FR.i18nText("Path")+" ") + ":")).append($('<td/>').append(this.path.element)).append($('<td/>').append(viewButton.element)).appendTo(this.tbody);
		this.treeTR = $('<tr/>').height(90).append($('<td/>')).append($('<td/>').attr('colSpan', 2)).append($('<td/>')).hide().appendTo(this.tbody);
	},
	
	hidePath : function() {
		this.path.element.parent().parent().hide();
	},
	
	showPath : function() {
		this.path.element.parent().parent().show();
	},
	
	chooseReport : function(path) {
		if (this.treeTR.is(':visible')) {
			this.treeTR.hide();
			return;
		}
		if (!this.treecontent) {
			this.treecontent = $('<div/>').addClass('fs_reportadd_tree').appendTo($('td:eq(1)', this.treeTR));
			this.treeTR.css('display', 'table-row');
			this.createReportsTree();
		}
		this.treeTR.css('display', 'table-row');
		this.treeTR.show();
	},
	
	//b:tree fontĵheightҪı
	createReportsTree : function() {
		var self = this;
		this.reportsTree = new FS.Tree({
			height : 90,
			width : 220,
			renderEl : this.treecontent,
			expand : false,
			widgetUrl : FR.servletURL + "?op=fs_entry&cmd=getreports&form=true&file=frm,cpt"
		});
		this.reportsTree.on(FR.Events.CLICK, function() {
			self.path.setValue(this.getSelectedData().getContent().path);
		});
	},
	
	setName : function(name) {
		this.name.setValue(name);
	},
	
	setReport : function(report) {
		this.path.setValue(report);
	},
	
	getName : function() {
		return this.name.getValue();
	},
	
	getReport : function() {
		return this.path.getValue();
	}
});

FS.TaskBasic = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_process_designtask');
		this.initPane();
	},
	
	initPane : function() {
		this.nameReportPart();
		this.joinmodePart();
//		this.taskTagPane();
		this.processNamePane();
	},
	
	nameReportPart : function() {
		this.namereport = new FS.NameReportChoose({
			nameText : FR.i18nText("Activity")+FR.i18nText("WF-Name"),
			reportText : FR.i18nText("Activity")+FR.i18nText("Template"),
			changeName : function(name) {
				if (this.task) {
					this.task.setName(name);
					this.task.processDefine.repaint();
				}				
			}.createDelegate(this),
			changeReport : function(report) {
				if (this.task) {
					this.task.setForm(report);
				}
			}.createDelegate(this)
		});
		this.namereport.element.addClass('fs_process_tasknamereport');
		this.element.append(this.namereport.element);
	},
	
	joinmodePart : function() {
		this.joinContent = $('<div/>').addClass('fs_process_taskjoin');
		$('<span/>').text(FR.i18nText("Activity")+FR.i18nText("trigger")+FR.i18nText("ruleSet")+":").appendTo(this.joinContent);
		this.radioOne = this.createRadio();
		this.radioOne.click(function(e) {
			if (this.task) {
				this.task.setJoinMode(1);
			}
			e.stopPropagation();
		}.createDelegate(this));
		this.radioAll = this.createRadio().click(function(e) {
			if (this.task) {
				this.task.setJoinMode(2);
			}
			e.stopPropagation();
		}.createDelegate(this));
		$('<div/>').css('cursor', 'pointer').append(this.radioOne).append($('<span/>').addClass('fs_process_taskonejoin')
                .text(FR.i18nText("SingleOne")+FR.i18nText("Short-Jun")+FR.i18nText("Transition")+FR.i18nText("trigger"))).click(function() {
			this.radioOne.click();
		}.createDelegate(this)).appendTo(this.joinContent);
		$('<div/>').css('cursor', 'pointer').append(this.radioAll).append($('<span/>').addClass('fs_process_taskalljoin')
                .text(FR.i18nText("All")+FR.i18nText("Transition")+FR.i18nText("trigger"))).click(function() {
			this.radioAll.click();
		}.createDelegate(this)).appendTo(this.joinContent);
		this.element.append(this.joinContent);
	},
	
	createRadio : function() {
		var self = this;
		var radio =  $('<input/>').attr({
			type : 'radio',
			checked : false,
			name : 'joinmode'
		});
		return radio;
	},
	
	taskTagPane : function() {
		this.tagpane = $('<div/>').addClass('fs_process_tagpane');

		this.multicombo = new FR.CheckBoxEditor({
			width : 120,
			height : 24,
			items : [],
			directEdit : true,
			delimiter : ','
		});
		var self = this;
		this.multicombo.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getProcessPara());
		});
		this.multicombo.on(FR.Events.AFTEREDIT, function() {
			self.task.setParameters(this.getValue());
		});
		this.tagpane.append($('<span/>').text(FR.i18nText("Select")+FR.i18nText("Label")+FR.i18nText("colon"))).append(this.	multicombo.element).appendTo(this.element);
		
	},
	
	processNamePane : function() {
		this.processComboPane = $('<div/>').addClass('fs_process_processcombo').append($('<span/>').text(FR.i18nText("Select")+FR.i18nText("WF-Process")+FR.i18nText("colon")));
		this.processcombo = new FS.Combobox({
			width : 120,
			height : 24,
			items : [],
			directEdit : true
		});
		this.processcombo.element.css({
			position : 'absolute',
			top : 0,
			left : 60
		});
		var self = this;
		this.processcombo.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getProcessNames());
		});
		this.processcombo.on(FR.Events.AFTEREDIT, function() {
			self.task.setSubName(this.getValue());
		});
		this.processComboPane.hide().append(this.processcombo.element).appendTo(this.element);
	},
	
	getProcessNames : function() {
		return FS.Design.processPane.getAllNames(this.task.processDefine.getName());
	},
	
	getProcessPara : function() {
		if (!this.task) {
			return;
		}
		var paras = this.task.processDefine.parameters;
		paras = paras ? paras : [];
		var data = [];
		for (var i = 0, len = paras.length; i < len; i++) {
			data[i] = {
				text : paras[i].name,
				value : paras[i].name
			};
		}
		return data;
	},
	
	popTask : function(task) {
		this.task = task;
		var type = task.getType();
		if (type == "formtask") {
			this.namereport.showPath();
//			this.tagpane.show();
			this.setReport(task.form);
//			this.setTags(task.parameters);
		} else {
			this.namereport.hidePath();
//			this.tagpane.hide();
		}
		if (type == "starttask" || type == "subprotask") {
			this.joinContent.hide();
		} else {
			this.joinContent.show();
			this.setJoinMode(task.joinMode);
		}
		if (type == "subprotask") {
			this.processComboPane.show();
			this.setSubProcessName(task.subname);
		} else {
			this.processComboPane.hide();
		}
		this.setName(task.name);
	},
	
	setSubProcessName : function(subname) {
		this.processcombo._dealValueWithEvents(subname);
	},
	
	setTags : function(parameters) {
		if (parameters == null) {
			parameters = "";
		}
		parameters = parameters.split(",");
		if (parameters[parameters.length - 1] == "") {
			parameters.pop();
		}
		this.multicombo._dealValueWithEvents(parameters);
	},
	
	setName : function(name) {
		this.namereport.setName(name);
	},
	
	getName : function() {
		this.namereport.getName();
	},
	
	setReport : function(path) {
		this.namereport.setReport(path);
	},
	
	getReport : function() {
		this.namreport.getReport();
	},
	
	setJoinMode : function(mode) {
		if (mode === 1) {
			this.radioOne.attr('checked', true);
		} else {
			this.radioAll.attr('checked', true);
		}
	},
	
	getJoinMode : function() {
		return this.radioAll.attr('checked') ? 2 : 1;
	},
	
	hideJoinMode : function() {
		this.joinContent.hide();
	},
	
	hideReport : function() {
		this.namereport.element.hide();
	},
	
	hide : function() {
		this.element.hide();
	}
});

FS.TaskUser = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_process_taskuser');
		this.generateUserPane();	
	},
	
	generateUserPane : function() {
		$('<div/>').addClass('fs_process_taskuserexplain').text(FR.i18nText("fs_process_user_pane_tip")+FR.i18nText("colon")).appendTo(this.element);
		
		this.mainpane = $('<div/>').addClass('fs_process_taskuserpane');
		var self = this;
		this.starter = this.createRadio().click(function(e){
			self.button.setEnable(false);
			self.datas.setEnable(false);
			self.formulaText.setEnable(false);
			self.rolesTable.clearContent();
			if (self.task) {
				self.task.setUsers({
					type : 'parameterusers',
					paraname : 'processStarter'
				});
			}

			e.stopPropagation();
		});	
		this.formula = this.createRadio().click(function(e){
			self.button.setEnable(false);
			self.datas.setEnable(false);
			self.formulaText.setEnable(true);
			self.rolesTable.clearContent();
			if (self.task) {
				self.task.setUsers({
					type : 'formulausers'
				});
			}
			e.stopPropagation();
		});	
		this.processpara = this.createRadio().click(function(e){
			self.button.setEnable(false);
			self.datas.setEnable(true);
			self.formulaText.setEnable(false);
			self.rolesTable.clearContent();
			if (self.task) {
				self.task.setUsers({
					type : 'parameterusers'
				});
			}
			e.stopPropagation();			
		});	
		this.roles = this.createRadio().click(function(e){
			self.button.setEnable(true);
			self.datas.setEnable(false);
			self.formulaText.setEnable(false);
			if (self.task) {
				self.task.setUsers({
					type : 'roleusers'
				});
			}
			e.stopPropagation();
		});	
		this.rolesTable = new FR.ButtonsTable({
			width : 320,
			height : 120,
			container : this
		});
		var self = this;
		var button = this.button = new FR.Button({
			text : FR.i18nText("Preview"),
			height : 20,
			disabled : true,
			handler : function() {
				self.showRolesDialog(self.rolesTable.getUsers());
			}
		});
		var datas = this.datas = new FS.Combobox({
			width : 120,
			height : 24,
			items : [],
			directEdit : true
		});
		datas.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getProcessPara());
		});
		datas.on(FR.Events.AFTEREDIT, function() {
			var users = $.extend({}, self.task.users, {
				paraname : this.getValue()
			});
			self.task.setUsers(users);
		});
		this.formulaText = new FR.TextEditor({
			width : 120,
			height : 24,
			directEdit : true
		});
		this.formulaText.on(FR.Events.AFTEREDIT, function() {
			var users = $.extend({}, self.task.users, {
				exp : this.getValue()
			});
			self.task.setUsers(users);
		});
		datas.setEnable(false);
		this.formulaText.setEnable(false);
		this.mainpane.append($('<table/>').append($('<tbody/>').append($('<tr/>').append($('<td/>').append(this.starter).append($('<span/>')
                        .text(FR.i18nText("WF-Process")+FR.i18nText("Server-Start")+FR.i18nText("SingleMan")))).append($('<td/>')))
			.append($('<tr/>').append($('<td/>').append($('<div/>').append(this.processpara).append($('<span/>')
                            .text(FR.i18nText("WF-Process")+FR.i18nText("hasRelation")+FR.i18nText("Data")))))
				.append($('<td/>').append(datas.element))))	
				//wei : ȥ¼ʽ		
			//.append($('<tr/>').append($('<div/>').append(this.formula).append($('<span/>').text('¼ʽ:'))).append($('<td/>').append(this.formulaText.element)))
			.append($('<tr/>').append($('<td/>').append($('<div/>').append(this.roles).append($('<span/>').text(FR.i18nText("Select")+FR.i18nText("Role")))))
				.append($('<td/>').append(button.element))))
			.append(this.rolesTable.element).appendTo(this.element);
		this.starter.parent().css('cursor', 'pointer').click(function() {
			self.starter.click();
		});
		this.processpara.parent().css('cursor', 'pointer').click(function() {
			self.processpara.click();
		});
		this.formula.parent().css('cursor', 'pointer').click(function() {
			self.formula.click();
		});
		this.roles.parent().css('cursor', 'pointer').click(function() {
			self.roles.click();
		});
	},
	
	popTask : function(task) {
		this.clearAll();
		this.task = task;
		if (!this.task.users) {
			this.task.users = {};
		}
		
		var users = task.users;
		if (users.type == "roleusers") {
			this.roles.attr('checked', true);
			this.button.setEnable(true);
			var js = users.jroles ? users.jroles : "", ss = users.sroles ? users.sroles : "";
			this.rolesTable.popUsers(this.getRoles(js.split(','), ss.split(',')));
		} else if (users.type == "parameterusers") {
			if (users.paraname == 'processStarter') {
				this.starter.attr('checked', true);
			} else {
				this.processpara.attr('checked', true);
				this.datas.setValue(users.paraname);
			}
		} else if (users.type == "formulausers") {
			this.formula.attr('checked', true);
			this.formulaText.setValue(users.exp);	
		}
		this.task.users = users;
	},
	
	clearAll : function() {
		this.roles.attr('checked', false);
		this.starter.attr('checked', false);
		this.processpara.attr('checked', false);
		this.formula.attr('checked', false);
		this.formulaText.setValue('');
		this.rolesTable.clearContent();
		this.datas.setValue('');
	},
	
	removeSelf : function(user) {
		if(this.task.users.jroles) {
			js = this.task.users.jroles.split(',');
		} else {
			js = [];
		}
		if(this.task.users.sroles) {
			ss = this.task.users.sroles.split(',');
		} else {
			ss = [];
		}
		
		if (user.postid != null || user.departmentid != null) {
			js.remove(user.id);
		} else {
			ss.remove(user.id);
		}
		var users = $.extend({}, this.task.users, {
			jroles : js.join(','),
			sroles : ss.join(',')
		});
		this.task.setUsers(users);
	},
	
	getProcessPara : function() {
		if (!this.task) {
			return;
		}
		var paras = this.task.processDefine.parameters;
		paras = paras ? paras : [];
		var data = [];
		for (var i = 0, len = paras.length; i < len; i++) {
			data[i] = {
				text : paras[i].name,
				value : paras[i].name
			};
		}
		return data;
	},
	
	getRoles : function(jids, sids) {
		var roles = FS.Trans.getRoles();
 		for (var i = 0, len = roles.length; i < len; i++) {
 			if (roles[i].departmentname != null) {
 				roles[i].text = roles[i].departmentname + roles[i].postname;
 			}				
 		}
 		if (jids || sids) {
 			var rs = [];
 			for (var i = 0, len = roles.length; i < len; i++) {
 				if (jids.indexOf(roles[i].id) > -1 && roles[i].departmentname != null) {
 					rs.push(roles[i]);
 				}
 				if (sids.indexOf(roles[i].id) > -1 && roles[i].departmentname == null) {
 					rs.push(roles[i]);
 				}
 			}
 			return rs;
 		}
 		return roles;
	},
	
	string2Ids : function(s) {
		
	},
	
	setRoleIDS : function(roles) {
		var roles = roles ? roles : this.rolesTable.getUsers();
		if (!roles) {
			return;
		}
		for (var i = 0, len = roles.length; i < len; i++) {
			this.rolesList.selecteByID([roles[i].id], 'departmentname', roles[i].departmentname != null);
		}
	},
	
	changeRoles : function(roles) {
		if (!this.task || !roles || roles.length < 1) {
			return;
		}
		var jr = [], sr = [];
		for (var i = 0, len = roles.length; i < len; i++) {
			if (roles[i].departmentname) {
				jr.push(roles[i].id);
			} else {
				sr.push(roles[i].id);
			}
		}
		var users = $.extend({}, this.task.users, {
			jroles : jr.join(','),
			sroles : sr.join(',')
		});
		this.task.setUsers(users);
	},
	
	showRolesDialog : function(roles) {
		if (this.rolesDialog) {
			this.setRoleIDS(roles);
			this.rolesDialog.setVisible(true);
			return;
		}

		this.rolesList = new FS.List({
			width : 140,
			height : 280,
			multi : true,
			items : this.getRoles()
		});
		var self = this;

		this.rolesList.element.attr('id', 'fs_process_roleslist');
		var confire = function() {
			var roles = self.rolesList.getSelectedDatas();
			self.rolesTable.popUsers(roles);	
			self.changeRoles(roles);
		};
		
		var content = $('<div/>').addClass('fs_process_rolepane').append(this.rolesList.element);
		this.setRoleIDS(roles);
		this.usersDialog = new FR.Dialog({     //δõ
			title : FR.i18nText("Select")+FR.i18nText("Role"),
		 	width : 240,
		 	height : 360,
		 	confire : true,
            contentHtml : content
		});
	},
	
	createRadio : function() {
		var self = this;
		var radio =  $('<input/>').attr({
			type : 'radio',
			checked : false,
			name : 'users'
		});
		return radio;
	},
	
	setUesr : function() {
		
	},
	
	getUser : function() {
		
	},
	
	hide : function() {
		
	}
});

FS.TaskShift = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_process_taskshift');
		this.generateShiftPane();	
	},
	
	generateShiftPane : function() {		
		this.trancombo  = new FS.Combobox({
			width : 120,
			height : 24,
			items : [],
			directEdit : true,
			allowBlank : false
		});
		var self = this;
		this.trancombo.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getTranNames());
		});
		this.trancombo.element.css({
			position : 'absolute',
			left : 100,
			top : 0
		});
		$('<div/>').css({
			position : 'absolute',
			left : 10,
			top : 10
		}).append($('<span/>').text(FR.i18nText("Select")+FR.i18nText("Son")+FR.i18nText("WF-Process")+FR.i18nText("Transition")+':')).append(this.trancombo.element).appendTo(this.element);
		$('<span/>').css({
			position : 'absolute',
			top : 40,
			left : 10
		}).text(FR.i18nText("Transition")+FR.i18nText("turn")+FR.i18nText("Condition")+FR.i18nText("Set")+FR.i18nText("colon")).appendTo(this.element);
		$('<div/>').css({
			position : 'absolute',
			top : 60,
			left : 10
		}).append(this.createDesignTable()).appendTo(this.element);
		this.createOPButtons();
		this.createConditionPane();
	},
	
	getTranNames : function() {
		var trans = [];
		if (this.task.transitions) {
			for (var i = 0, len = this.task.transitions.length; i < len; i++) {
				trans[i] = {
					text : this.task.transitions[i].getName(),
					value : this.task.transitions[i].getName()
				};
			}
		}
		return trans;
	},

									
	createDesignTable : function() {
		return $('<table/>').append(this.generateExplanTR()).append(this.generateFilterTR());
	},
									
	generateExplanTR : function() {
		return $('<thead/>').append($('<th/>').text(FR.i18nText("Select")+FR.i18nText("WF-Process")+FR.i18nText("Parameters")+FR.i18nText("colon")))
			.append($('<th/>').text(FR.i18nText("FormulaD-Operations")+FR.i18nText("colon")))
			.append($('<th/>').text(FR.i18nText("Data")+FR.i18nText("Type")+FR.i18nText("colon")))
			.append($('<th/>').text(FR.i18nText("ChartF-Values")));
	},
									
	generateFilterTR : function() {
		return $('<tr/>').addClass('adhoc_design_filterdata_filtertr')
			.append($('<td/>').append(this.generateParaCombo()))
			.append($('<td/>').append(this.generateOPCombo()))
			.append($('<td/>').append(this.generateTypeCombo()))
			.append($('<td/>').append(this.valuePane()));
	},
									
	generateParaCombo : function() {
		this.paracombo  = new FS.Combobox({
			width : 100,
			height : 24,
			items : [],
			directEdit : true,
			allowBlank : false
		});
		var self = this;
		this.paracombo.on(FR.Events.CLICK,  function() {
			this.reBuild(self.getProcessPara());
		});
		return this.paracombo.element;
	},
	
	getProcessPara : function() {
		if (!this.task) {
			return;
		}
		var paras = this.task.processDefine.parameters;
		paras = paras ? paras : [];
		var data = [];
		for (var i = 0, len = paras.length; i < len; i++) {
			data[i] = {
				text : paras[i].name,
				value : paras[i].name
			};
		}
		//b:ֱӿͻȡ̲
		if (this.task.subname != null) {
			Array.prototype.push.apply(data, FS.Design.processPane.getProcessPara(this.task.subname));
		}
		
		return data;
	},
									
									
	generateOPCombo : function() {	
		this.opcombo  = new FS.Combobox({
			width : 80,
			height : 24,
			items : this.opData(),
			directEdit : false,
			allowBlank : false
		});	
		return this.opcombo.element;
	},
									
	opData : function() {
		var item = [];
		item.push({text: FR.i18nText("ConditionB-equals"), value: 0});
		item.push({text: FR.i18nText("ConditionB-does_not_equal_to"), value: 1});
		item.push({text: FR.i18nText("ConditionB-is_greater_than"), value: 2});
		item.push({text: FR.i18nText("ConditionB-is_greater_than_or_equal_to"), value: 3});	
		item.push({text: FR.i18nText("ConditionB-is_less_than"), value: 4});
		item.push({text: FR.i18nText("ConditionB-is_less_than_or_equal_to"), value: 5});
//		item.push({text: FR.i18nText("ConditionB-begins_with"), value: 6});
//		item.push({text: FR.i18nText("ConditionB-does_not_begin_with"), value: 7});
//		item.push({text: FR.i18nText("ConditionB-ends_with"), value: 8});
//		item.push({text: FR.i18nText("ConditionB-does_not_end_with"), value: 9});
//		item.push({text: FR.i18nText("ConditionB-contains"), value: 10});
//		item.push({text: FR.i18nText("ConditionB-does_not_contain"), value: 11});
//		item.push({text: FR.i18nText("ConditionB-in"), value: 12});
//		item.push({text: FR.i18nText("ConditionB-does_not_in"), value: 13});
		return item;
	},
									
	generateTypeCombo : function() {
		this.typecombo  = new FS.Combobox({
			width : 80,
			height : 24,
			items : this.typeData(),
			directEdit : false,
			allowBlank : false
		});	
		return this.typecombo.element;
	},
																		
	typeData : function() {
		var item = [];
		item.push({text: FR.i18nText("Parameter-String"), value: 'string'});
		item.push({text: FR.i18nText("Number"), value: 'number'});
//		item.push({text: FR.i18nText("Date"), value: 'date'});
		return item;
	},
	
	valuePane : function() {
		this.valueText = new FR.TextEditor({
			width : 100,
			height : 24,
			allowBlank : false
		});
		return this.valueText.element;
	},
	
	createOPButtons : function() {
		var self = this;
		this.addcondition = new FS.IconButton({
			baseClass : 'fr_auth_addposition',
			renderEl : $('<div/>'),
			title : FR.i18nText("Add"),
			handler : function() {
				self.addNewCondition();	
			}
		});
		
		this.addcondition.element.css({
			position : 'absolute',
			top : 50,
			left : 400
		});
		
		this.editcondition = new FS.IconButton({
			baseClass : 'fr_auth_editposition',
			renderEl : $('<div/>'),
			title : FR.i18nText("Modify"),
			disabled : true,
			handler : function() {
				self.changeCondition();	
			}
		});
		
		this.editcondition.element.css({
			position : 'absolute',
			top : 80,
			left : 400
		});
		this.element.append(this.addcondition.element).append(this.editcondition.element);
	},
	
	addNewCondition : function() {
		var condition = this.getCondition();
		if (condition) {
			this.addCondition(condition);
			this.task.addCondition(condition);
		}
	},
	
	addCondition : function(condition) {
		condition.text = this.generateName4Condition(condition);
		this.conditionList.addSimpleData(condition);
	},
	
	createConditionPane : function() {
		this.conditionList = new FS.RemoveList({
 			width : 320,
 			height : 160,	
 			items : this.getConditions()
 		});
 		this.conditionList.element.css({
 			position : 'absolute',
 			top : 10,
 			left : 440
 		});
 		var self = this;
 		this.conditionList.on(FR.Events.REMOVEDATA, function(record) {
			self.task.removeCondition(record.getContent());
 		});
 		this.conditionList.on(FR.Events.CLICK, function() {
			self.showCondition();
			self.editcondition.setEnable(true);
 		});
 		this.conditionList.on(FR.Events.NOSELECT, function() {	
			self.editcondition.setEnable(false);
		});
 		this.element.append(this.conditionList.element);
	},
	
	showCondition : function() {
		var condition = this.conditionList.getSelectedData();
		this.trancombo.setValue(condition.transitionname);
		this.paracombo.setValue(condition.paraname);
		var comp = condition.comp;
		this.opcombo.setValue(comp.op);
		this.typecombo.setValue(comp.type);
		this.valueText.setValue(comp.value);
	},
	
	generateName4Condition : function(condition) {

		return FR.i18nText("Transition")+':' + condition.transitionname +' '+FR.i18nText("satisfy") +FR.i18nText("Condition")+':'+FR.i18nText("Parameters")
            + condition.paraname + this.getOPName(condition.comp.op) + condition.comp.value + FR.i18nText("triggered");
	},
	
	getOPName : function(value) {
		var ops = this.opData();
		for (var i = 0, len = ops.length; i < len; i++) {
			if (ops[i].value == value) {
				return ops[i].text;
			}
		}
	},
	
	changeCondition : function() {
		var condition = this.getCondition(), selecteddata = this.conditionList.getSelectedData();
		if (condition && selecteddata) {
			condition.text = this.generateName4Condition(condition);
			condition = $.extend({}, selecteddata, condition);
			this.task.editCondition(condition, selecteddata);
			this.conditionList.editItem(condition);	
		}
	},
	
	getCondition : function() {
		if (!this.checkCondition()) {
			return;
		}
		return {
			transitionname : this.trancombo.getValue(),
			paraname : this.paracombo.getValue(),
			comp : {
				op : this.opcombo.getValue(),
				type : this.typecombo.getValue(),
				value : this.valueText.getValue()
			}
		};
	},
	
	checkCondition : function() {
		if (!this.trancombo.checkValidate()) {
			return;
		}
		if (!this.paracombo.checkValidate()) {
			return;
		}
		if (!this.opcombo.checkValidate()) {
			return;
		}
		if (!this.typecombo.checkValidate()) {
			return;
		}
		if (!this.valueText.checkValidate()) {
			return;
		}
		return true;
	},
	
	getConditions : function() {
		if (!this.task) {
			return [];
		}
	},
	
	popTask : function(task) {
		this.task = task;
		if (task.conditiontransitions) {
			var conditions = task.conditiontransitions;
			for (var i = 0, len = conditions.length; i < len; i++) {
				conditions[i].text = this.generateName4Condition(conditions[i]);
			}
			this.conditionList.reBuild(conditions);
		}
	}
});

FS.TaskPane = FS.extend(FS.Widget, {
	paneHeight : 180,
	
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_process_taskpane').css('z-index', 8);
		this.container = config.container;
		this.initPane();
		this.collapse = true;
	},
	
	//b:ؼԷطʹãfs buttontabpane
	initPane : function() {
		var self = this;
		this.expandicon = $('<div/>').css({
			position : 'absolute',
			top : 1,
			left : 0,
			width : 12,
			height : 8
		});
		this.expandContent = $('<div/>').addClass('fs_taskpane_expand').css('height', 10).click(function() {
			self.collapseOrExpand();
			if (self.collapse) {
				$(this).switchClass('fs_taskpane_expand', 'fs_taskpane_collapse');
			} else {
				$(this).switchClass('fs_taskpane_collapse', 'fs_taskpane_expand');
			}
		}).mouseover(function() {
			$(this).addClass('fs_taskpane_active');
		}).mouseout(function() {
			$(this).removeClass('fs_taskpane_active');
		}).append(this.expandicon).appendTo(this.element);
		
		
		this.toolbar = $('<div/>').attr('id', 'fs_taskpane_toolbar').css({
			position : 'absolute',
			top : 10,
			left : 0,
			width : 120,
			background : '#BEE5FD'
		});
		this.basebutton = new FS.ToolbarButton({
			text : FR.i18nText("Basic"),
			height : 24,
			width : 116,			
			handler : function() {
				self.showPane();								
			}
		});
		this.basebutton.element.css({
			position : 'absolute',
			left : 1,
			top : 1
		}).appendTo(this.toolbar);
		this.userbutton = new FS.ToolbarButton({
			text : FR.i18nText("Participants"),
			height : 24,
			width : 116,			
			handler : function() {
				self.showPane('user');								
			}
		});
		this.userbutton.element.css({
			position : 'absolute',
			left : 1,
			top : 27
		}).appendTo(this.toolbar);
		this.shiftbutton = new FS.ToolbarButton({
			text :FR.i18nText("turn")+FR.i18nText("Set"),
			height : 24,
			width : 116,			
			handler : function() {
				self.showPane('shift');								
			}
		});
		this.shiftbutton.element.css({
			position : 'absolute',
			left : 1,
			top : 27
		}).appendTo(this.toolbar);
		this.toolbar.appendTo(this.element);
		
		this.paneContainer = $('<div/>').addClass('fs_taskpane_container').css({
			position : 'absolute',
			left : 120,
			top : 10
		}).appendTo(this.element);
		
		//b:Ҫʱcreateto do
		this.basepane = new FS.TaskBasic();
		this.userpane = new FS.TaskUser();
		this.shiftpane = new FS.TaskShift();
		this.basepane.element.hide().appendTo(this.paneContainer);
		this.userpane.element.hide().appendTo(this.paneContainer);
		this.shiftpane.element.hide().appendTo(this.paneContainer);
		
		
//		this.tab = new FS.ProcessTab({
//			items : [{
//				title : ''
//			}, {
//				title : ''
//			}]
//		});
//		this.taskBasic = new FS.TaskBasic();
//		this.taskUser = new FS.TaskUser();
//		var self = this;
//		this.tab.on(FR.Events.TABCHANGE, function(tabpane, index) {
//			var container = tabpane.options.tabs[index].content;
//			if (container.children().length > 0) {
//				return;
//			}
//			var rp = null;
//			if (index == 0) {
//				rp = self.taskBasic.element;
//			} else {
//				rp = self.taskUser.element;
//			}
//			container.append(rp);
//		});
//		this.tab.on(FR.Events.CollapseOrExpand, function() {
//			self.collapseOrExpand();	
//		});
//		this.element.append(this.tab.element);
//		setTimeout(function(){
//			self.tab.fireEvent(FR.Events.TABCHANGE, self.tab, 0);
//		}, 25);
	},
	
	showPane : function(type) {
		var base = true, user = false, shift = false;
		if (type == 'user') {
			base = false, user = true;
		} else if (type == 'shift') {
			base = false, shift = true;
		}
		this.basebutton.element[base ? 'addClass' : 'removeClass']('fs_button_selected');
		this.userbutton.element[user ? 'addClass' : 'removeClass']('fs_button_selected');
		this.shiftbutton.element[shift ? 'addClass' : 'removeClass']('fs_button_selected');

		this.basepane.element[base ? 'show' : 'hide']();
		this.userpane.element[user ? 'show' : 'hide']();
		this.shiftpane.element[shift ? 'show' : 'hide']();
	},
	
	resize : function(rec) {
		this.element.width(rec.width);
		this.expandContent.width(rec.width);
		this.expandicon.css('left', rec.width/2 - 5);
		this.paneContainer.width(rec.width - this.toolbar.width());
		var height = this.collapse ? 0 : this.paneHeight;
		this.element.height(this.expandContent.height() + height);
		this.toolbar.height(height);
		this.paneContainer.height(height);
	},
	
	collapseOrExpand : function() {
		if (this.collapse) {
			this.expandPane();
		} else {
			this.collapsePane();
		}
	},
	
	collapsePane : function() {
		this.element.height(this.expandContent.height());
		this.collapse = true;
		this.confirmContainer();
	},
	
	expandPane : function() {
		this.element.height(this.expandContent.height() + this.paneHeight);
		this.collapse = false;
		this.confirmContainer();
	},
	
	hideContent : function() {		
		this.toolbar.hide();
		this.paneContainer.hide();
	},
	
	showContent : function(task) {
		this.toolbar.show();
		if (task.getType() == "formtask") {
			this.userbutton.setVisible(true);
		} else {
			this.userbutton.setVisible(false);
		}
		if (task.getType() == "subprotask" ) {
			this.shiftbutton.setVisible(true);
		} else {
			this.shiftbutton.setVisible(false);
		}

		this.paneContainer.show();
	},
	
	confirmContainer : function() {
		if (this.container) {
			var el = this.container.element;
			this.container.resize({
				width : el.width(),
				height : el.height()
			});
		}
	},
	
	isCollapse : function() {
		return this.collapse;
	},
	
	fireContentByTask : function(task) {
		if (!task) {
			this.hideContent();
			this.collapsePane();
		} else {
			this.showContent(task);
			this.expandPane();
			return true;
		}
	},
		
	popTask : function(task) {
		if (!this.fireContentByTask(task)) {
			return;
		}
		var type = task.getType();
		this.basebutton.fireEvent(FR.Events.CLICK);
		
		this.basepane.popTask(task);
		if (type == 'formtask') {
			this.userpane.popTask(task);
		}
		if (type == 'subprotask') {
			this.shiftpane.popTask(task);
		}
	}
});