/* b:grid ʱֻṩҳӺadd
 * ʾϢ͵Grid
 * ֧ףͷҳײʾ
 *
 */
FS.LGrid = FR.extend(FR.Widget, {
    _defaultConfig : function() {
        return $.extend(FS.LGrid.superclass._defaultConfig.call(), {
            cls : '',
            headtrcls : 'fs_lgrid_headtr',
            headthcls : 'fs_lgrid_headth',
            bodyId:'fs_grid_check_tbody',
            selectedtrCls : 'fs_lgrid_selectedtr',
            drag : false,
            resize : false,
            page : true,
            multi : false,
            pagecount : 10,
            columnsconfig : [],
            items : [],
            width : 721,
            height : 0,
            headHeight : 28,
            itemHeight :25,
            intervalcolor : false,
            isFootShow :true,
            isFootShowAutomatic :false,
            isHeadShow  : true,
            isHorizontal : false,
            firstColumnPaddingLeft : 51,
            lastColumnPaddingRight :0,
            style : null

        });
    },

    _init : function() {
        FS.LGrid.superclass._init.apply(this, arguments);
        this.element.addClass('fs_grid').addClass(this.options.cls)
        FR.$defaultImport('/com/fr/fs/web/css/fs_light_grid.css', 'css');
        if(this.options.multi) {
        	this.initMultiColumn();
        }
        	
        this.confireWidth();	
        
        this.headPane();
        
        this.tablePane();
        
        this.footPane();
        this.element.append(this.tableContainer).append(this.foot ? this.foot : '');
    },

	//wei:ԵüؼĿ
    confireWidth : function() {
        var width = 0;
        for(var i = 0, len = this.options.columnsconfig.length; i < len; i++) {
            width += this.options.columnsconfig[i].width;
        }
        width+=this.options.firstColumnPaddingLeft;
        width+=this.options.lastColumnPaddingRight;
        this.options.width = width;
        this.element.width(width);
    },

	//wei:ʼؼıͷ
    headPane : function() {
        var h = (this.options.page ? 22 : 0);
        if(!this.options.isFootShow){
            h = 0;
        }
        if(this.options.height ===0){       //ʹauto
            this.tableContainer = $('<div/>').attr('id', 'fs_lgrid_tablecontainer').css({'width':this.options.width,'height':'auto'});
        }else{
            this.tableContainer = $('<div/>').attr('id', 'fs_lgrid_tablecontainer').width(this.options.width).height(this.options.height - h);
        }
        this.table = $('<table/>').attr({id : 'fs_lgrid_table', cellPadding : 0, cellSpacing : 0}).appendTo(this.tableContainer);
        this.head = $('<thead/>').attr('id', 'fs_lgrid_head');
        this.buildHead();
        this.table.append(this.head);
        if(!this.options.isHeadShow){
           this.head.hide();
        }
    },

	//wei:ͷ
    buildHead : function() {
        var tr = $('<tr/>').height(this.options.headHeight).appendTo(this.head);
        tr.addClass(this.options.headtrcls);
        if (this.options.multi) {
            this.multiHead();
        }
        var cc = this.options.columnsconfig;
        for (var i = 0, len = cc.length; i < len; i++) {
            var th = $('<th/>').addClass(this.options.headthcls), config = cc[i];
            if(i===0){
                th.css('padding-left',this.options.firstColumnPaddingLeft);
            }
            if(i=== len-1){
                th.css('padding-right',this.options.lastColumnPaddingRight);
            }
            if(this.options.widthAdjust !== true) {
                th.width(config.width);
            }
            if(config.textAlignCenter === true){
                th.css('text-align','center');            
            }else{
                th.css('text-align','left');
            }
            th.text(config.showValue ? config.showValue : config.text);
            tr.append(th);
        }
        if (config.sort) {
            this.sortHead(th);
        }
    },

    /*b:ʱȫ*/
    //wei:
    tablePane : function() {
        this.tbody = $('<tbody/>').attr('id', this.options.bodyId);
        this.renderActivePage();
        this.table.append(this.tbody);
    },

	//wei:ײķҳ
    footPane : function() {
        if (!this.options.page) {
            return;
        }
        this.foot = $('<div/>').attr('id', 'fs_lgrid_foot');
        this.totalpages = Math.ceil(this.options.items.length/this.options.pagecount);
        var table = $('<table/>').attr({id : 'fs_lgrid_foot_table', cellPadding : 0, cellSpacing : 0});
        var self = this;
        //һҳ
        this.mf = new FS.IconButton({
            renderEl : $('<div/>'),
            imgsrc : 'fs_lgrid_foot_movefirst',
            handler : function() {
                self.move2FirstPage();
            }
        });
        //ǰһҳ
        this.mp = new FS.IconButton({
            renderEl : $('<div/>'),
            imgsrc : 'fs_lgrid_foot_movepre',
            handler : function() {
                self.move2PrePage();
            }
        });
        //һҳ
        this.mn = new FS.IconButton({
            renderEl : $('<div/>'),
            imgsrc : 'fs_lgrid_foot_movenext',
            handler : function() {
                self.move2NextPage();
            }
        });
        //һҳ
        this.ml = new FS.IconButton({
            renderEl : $('<div/>'),
            imgsrc : 'fs_lgrid_foot_movelast',
            handler : function() {
                self.move2LastPage();
            }
        });
            
        this.activedPage = this.totalpages ? 1 : 0;
        this.pageLoader = $('<input id="fs_lgrid_foot_loader" type="text"/>').val(this.activedPage).keydown(function(e) {
            if (e.keyCode === 13) {
                self.move2AppointPage($(this).val());
                e.stopEvent();
            }
        });
        var showPage = this.totalpages;
        if(showPage === 0){
            showPage = 1;
        }
        this.totalPane = $('<span></span>').css({'font-size':'15px'}).text(" /"+showPage +" "+ FR.i18nText("Page_Number"));
        $('<tr/>').append($('<td/>').append(this.mf.element)).append($('<td>').append(this.mp.element))
            .append($('<td/>').addClass('fs_grid_foot_pageshow').append(this.pageLoader).append(this.totalPane))
            .append($('<td/>').append(this.mn.element)).append($('<td/>').append(this.ml.element)).appendTo(table);
        this.foot.append(table);
        this.checkFootButtonState();
        if(!this.options.isFootShow){
            this.foot.hide();
        }
    },
    
    //wei:ǷҪݶ٣ʾ/طҳť
    checkIsFootShowAutomatic:function(){
       if(!this.options.isFootShowAutomatic){      //Ƿݶ٣жǷʾҳ
           return;
       }else{
           if(this.options.items==null){
               this.foot.hide();
               return;
           }
           var itemsLength = this.options.items.length;
           var pageLength = this.options.pagecount;
           if(itemsLength>pageLength){
               this.foot.show();
           }else{
               this.foot.hide();
           }
       }
    },

	//wei:µײҳť״̬
    checkFootButtonState : function() {
        if (!this.mf) {
            return;
        }
        if (this.activedPage < 2) {
            this.mf.setEnable(false);
            this.mp.setEnable(false);
        } else {
            this.mf.setEnable(true);
            this.mp.setEnable(true);
        }
        if (this.activedPage == this.totalpages) {
            this.mn.setEnable(false);
            this.ml.setEnable(false);
        } else if (this.activedPage < this.totalpages && this.totalpages > 1) {
            this.mn.setEnable(true);
            this.ml.setEnable(true);
        }
        this.checkIsFootShowAutomatic();
    },

	//wei:һҳ
    move2NextPage : function() {
        ++this.activedPage;
        this.renderActivePage();
    },

	//wei:һҳ
    move2PrePage : function() {
        --this.activedPage;
        this.renderActivePage();
    },
	
	//wei:һҳ
    move2FirstPage : function() {
        this.activedPage = 1;
        this.renderActivePage();
    },
	
	//wei:һҳ
    move2LastPage : function() {
        this.activedPage = this.totalpages;
        this.renderActivePage();
    },

	//ָҳ
    move2AppointPage : function(index) {
        if (index < 1 || index > this.totalpages) {
            FR.Msg.toast(FR.i18nText("Page_Unexist_Please_Input_Again")+"!");
            return;
        }
        if (this.activedPage == index) {
            return;
        }
        this.activedPage = index;
        this.renderActivePage();
    },

	//wei:ʾǰҳ
    renderActivePage : function() {
        this.clearBody();
        this.selectedIndexs = [];
		this.multiCheckboxs = [];	
        if (!this.activedPage) {
            this.activedPage = 1;
        }
        if (this.pageLoader) {
            this.pageLoader.val(this.activedPage);
        }
        
        var startIndex = (this.activedPage - 1)*this.options.pagecount;
        var self = this, ilen = this.options.items.length;
        var trHeight = this.options.itemHeight;
        
        for (var i = startIndex, len = Math.min(this.options.pagecount + startIndex,  ilen); i < len; i++) {
            var self = this;
            //wei:ʼTR
            var initTR = function(i) {
                var item = self.options.items[i];
                var tr = $('<tr/>').addClass('fs_grid_tr').click(function() {  //˸classԱʶһеtrؼڵtrܻ
                    //ģõ¼
                    if(self.options.multi){
                    	var checkbox = self.multiCheckboxs[i];
                    	checkbox.boxClick();
                    }
                });
                //wei:ʼTD
                var initTD = function(index) {
                    var cc = self.options.columnsconfig[index];
                    var proper = cc.colname || cc.text;
                    if(proper == 'password') {
                        var val = '********';
                    } else if(proper) {
                        var val = item[proper];
                    } else {
                        var val = '';
                    }
                    var td = $('<td/>').addClass('fs_grid_td');
                    if(cc.isBold){
                         td.css('font-weight','bold');
                    }
                    if(self.options.widthAdjust !== true) {
                    	td.css('width',cc.width);
		            }
                    if(index === 0){
                        td.css({'padding-left':self.options.firstColumnPaddingLeft});
                    }
                    if(index === self.options.columnsconfig.length-1){
                        td.css('padding-right',self.options.lastColumnPaddingRight);
                    }
                    if(cc.valueToHtml && $.isFunction(cc.valueToHtml)) {
                    	var value = cc.valueToHtml(val, item, i);
                    	if(value === 'hidden'){
                    		tr.css('display', 'none');
                    	}else{
                        	td.append(value);
                    	}
                    } 
                    else {
                        td.text(val);
                    }
                    if(cc.clickFunc && $.isFunction(cc.clickFunc)) {
                        td.click(function(e) {
                            cc.clickFunc(item, td.children(), e, i);
                        });
                    }
                    if(cc.textAlignCenter === true){
                        td.css('text-align','center');
                    }
                    if(i === len-1){
                        td.css('border-bottom','0px');
                    }
                    td.appendTo(tr);
                }
                for (var j = 0, jen = self.options.columnsconfig.length; j < jen; j++) {
                    initTD(j);
                }
                if (self.options.intervalcolor && (i - startIndex)%2 === 0) {
                    tr.addClass('fs_grid_intervaltr');
                }
                tr.mouseover(function(){
                    tr.addClass('fs_lgrid_hovertr');
                });
                tr.mouseleave(function(){
                    tr.removeClass('fs_lgrid_hovertr');
                });
                tr.height(trHeight);
                tr.appendTo(self.tbody);
            }
            initTR(i);
        }
        this.checkFootButtonState();
        if(this.options.renderFunc instanceof Function) {
            this.options.renderFunc.call();
        }
    },

	//wei:
    clearBody : function() {
        this.tbody.empty();
        this.activedTR = null;
        this.fireEvent(FS.Events.NOSELECT);
    },

	//wei:ȡλindex
    getDataAtIndex : function(index) {
        return this.options.items[index];
    },
    
    //wei:ȡ
    getAllData : function(){
       return this.options.items;
    },

	//wei:ȡǰѡе
    getSelectedData : function() {
    	var selectedIndex = this.getSelectedIndex();
    	
        if (!this.options.multi) {
            return [this.options.items[selectedIndex]];
        } else {
	        var items = [];
	        for(var i = 0, len = selectedIndex.length; i < len; i++){
	            items.push(this.options.items[selectedIndex[i]]);
	        }
	        return items;
        }
    },
	
	//wei:ȡǰѡݵ±
    getSelectedIndex : function() {
        if (!this.options.multi) {
            if (!this.activedTR) {
                return;
            }
            var trs = $('tr.fs_grid_tr', this.tbody);
            for (var i = 0, len = trs.length; i < len; i++) {
                if (trs[i] == this.activedTR[0]) {
                    return this.options.pagecount*(this.activedPage - 1) + i;
                }
            }
        } else {
        	return this.selectedIndexs;
        }
    },

	//wei:¼
    reCalculator : function() {
        var pages = Math.ceil(this.options.items.length/this.options.pagecount);
        if (this.totalpages != pages) {
            this.totalpages = pages;
            if(this.totalPane) {
            	this.totalPane.text(" /" + this.totalpages+" "+ FR.i18nText("Page_Number"));
            }
        }

        if (this.activedPage > this.totalpages) {
            this.activedPage = this.totalpages;
        }
        if (!this.activedPage && this.totalpages) {
            this.activedPage = 1;
        }
        this.renderActivePage();
    },
    
	 //wei:
    addData : function(item) {
        if (item == null) {
            return;
        }
        if (!this.fireEvent(FS.Events.APPENDDATA, item)) {
            return;
        }
        if (!$.isArray(item)) {
            item = [item];
        }
        Array.prototype.unshift.apply(this.options.items, item);
        var si = this.getSelectedIndex();
        this.reCalculator();
        if (!this.options.multi) {
            this.activedTR = $('tr.'+this.options.selectedtrCls, this.tbody).eq((si ? si[0] : 0) + item.length);
            /*b:ѡҪע*/
            if (!this.activedTR[0]) {
                this.fireEvent(FS.Events.NOSELECT);
            } else {
                this.activedTR.addClass(this.options.selectedtrCls);
            }
        }
        this.checkIsFootShowAutomatic();

    },
    
    //wei:ɾѡе
    removeSelectedData : function() {
        var rs = this.getSelectedData();
        /*b:ɾʱ*/
        if (!this.fireEvent(FS.Events.REMOVEDATA, rs[0])) {
            FR.Msg.toast("Grid removedata failed!");
            return;
        }
        /*b:Ƚϸӵķʽto improve*/
        for (var i = 0, len = rs.length; i < len; i++) {
            this.options.items.remove(rs[i]);
        }
        this.selectedIndexs = [];
        this.reCalculator();
        this.activedTR = null;
        this.fireEvent(FS.Events.NOSELECT);
    },
    
    //wei : ɾ±Ϊi
    removeDataAtIndex : function(i) {
		this.options.items.splice(i, 1);
        this.reCalculator();
	},
    
    //wei : ı±Ϊi
    changeDataAtIndex : function(item, i) {
    	this.options.items[i] = $.extend(this.options.items[i], item);
        if (!this.fireEvent(FS.Events.EDITDATA, this.options.items[i])) {
            FR.Msg.toast("Grid editdata failed!");
            return;
        }
        this.reCalculator();
        if (!this.options.multi) {
            this.fireEvent(FS.Events.SELECTDATA);
        }
    },
	
	//wei:ѡ±Ϊi
    setSelectIndex : function(i) {
        if (this.activedTR) {
            this.activedTR.removeClass(this.options.selectedtrCls);
        }
        var tr = $('tr', this.tbody).eq(i);
        $(tr).addClass(this.options.selectedtrCls);
        this.activedTR = $(tr);
        this.fireEvent(FS.Events.SELECTDATA);
    },
    
	//չʾ
    popData : function(items) {
        if (items == null) {
            this.clearBody();
            this.options.items = [];
            return;
        }

        this.options.items = items;
        this.reCalculator();
    },

    loading : function(load) {

    },

	//wei:ͷ
    sortHead : function(th) {
        var self = this;
        th.click(function() {
            var columnName = th.text();
            var items = self.options.items;
            if(items.length < 2) {
                return ;
            }
            if(th.data('desc') !== false) {
                for(var len = items.length; len > 1; len --) {
                    for(var m = 0; m < len - 1; m ++) {
                        var needTransposition = false;
                        if(!isNaN(items[m][columnName]) && !isNaN(items[m+1][columnName])) {
                            needTransposition = (items[m][columnName] - items[m + 1][columnName] > 0)
                        } else {
                            needTransposition = items[m][columnName] > items[m + 1][columnName];
                        }
                        if(needTransposition) {
                            var temp = items[m];
                            items[m] = items[m + 1];
                            items[m+1] = temp;
                        }
                    }
                }
                th.data('desc', false);
            } else {
                for(var len = items.length; len > 1; len --) {
                    for(var m = 0; m < len - 1; m ++) {
                        var needTransposition = false;
                        if(!isNaN(items[m][columnName]) && !isNaN(items[m+1][columnName])) {
                            needTransposition = (items[m][columnName] - items[m + 1][columnName] < 0)
                        } else {
                            needTransposition = items[m][columnName] < items[m + 1][columnName];
                        }
                        if(needTransposition) {
                            var temp = items[m];
                            items[m] = items[m+1];
                            items[m+1] = temp;
                        }
                    }
                }
                th.data('desc', true);
            }
            self.renderActivePage();
        });
    },
    
    //ѡе
    getMultiColumnConfig : function() {
    	if(this.multiColumnConfig) {
    		return this.multiColumnConfig;
    	}
    	var o = this.options;
    	var self = this;
    	this.multiColumnConfig = {
            text: '',
            showValue: '',
            width: 50,
            multiColumn : true,
            valueToHtml:function(val, item, i) {
            	var checkbox = new FS.LCheckBox({
            		listeners : [{
            			eventName : FR.Events.CLICK,
            			action : function() {
            				self._clickItemAtIndex(i);
            			}
            		}]
            	});
            	self.multiCheckboxs.push(checkbox);
            	return checkbox.element;
            }
        };
        return this.multiColumnConfig;
    },
    
    //wei:ѡɶѡ
    initMultiColumn : function() {
    	var self = this;
    	var o = this.options;
    	o.firstColumnPaddingLeft = 0;
    	o.lastColumnPaddingRight = 0;
    	var multiColumnConfig = this.getMultiColumnConfig();
    	if(!o.columnsconfig[0].multiColumn) {
    		//ӹ˾Ͳټ
    		o.columnsconfig.unshift(multiColumnConfig);	
    	}
    },

    multiHead : function() {

    },
    
    _getTRAtIndex : function(trindex) {
    	return $("tr.fs_grid_tr:eq("+trindex+")", this.tbody);
    },
    
    //ѡʱĿʱִУidx±ꣻisSelectedǷѡ
    _clickItemAtIndex : function(idx) {
    	var o = this.options;
		var trindex = (idx - o.pagecount*(this.activedPage - 1));
		var selectedTR = this._getTRAtIndex(trindex);
		var checkbox = this.multiCheckboxs[idx];
		if(checkbox.getValue()) {
			selectedTR.addClass(o.selectedtrCls);
			this.selectedIndexs.push(idx);
		} else {
			selectedTR.removeClass(o.selectedtrCls);
			for(var m = 0; m < this.selectedIndexs.length; m ++) {
				if(idx === this.selectedIndexs[m]) {
					this.selectedIndexs.splice(m, 1);
					break ;
				}
			}
		}
    }
});
$.shortcut("lgrid", FS.LGrid);

//wei : ѡ
FS.LCheckBox = FR.extend(FR.Widget, {
	_defaultConfig : function() {
		return $.extend(FS.LCheckBox.superclass._defaultConfig.apply(this, arguments), {
			normalCls : 'checkable',
			clickCls : 'checkbox_clicked',
			value : false
		});
	},
	
	_init : function() {
		FS.LCheckBox.superclass._init.apply(this, arguments);
		this.checkbox = $("<div/>").addClass(this.options.normalCls);
		this.checkbox.appendTo(this.element);
		this.registerEvent();
	},
	
	//ע¼
	registerEvent : function() {
		var o = this.options;
		var self = this;
		this.checkbox.click(function(e) {
			self.boxClick();
			e.stopEvent();
		});
	},
	
	boxClick : function() {
		if(this.getValue()) {
			this.setValue(false);
		} else {
			this.setValue(true);
		}
		this.fireEvent(FR.Events.CLICK);
	},
	
	getValue : function() {
		return this.options.value;
	},
	
	setValue : function(value) {
		var o = this.options;
		this.options.value = value;
		if(value) {
			this.checkbox.addClass(o.clickCls);
		} else {
			this.checkbox.removeClass(o.clickCls);
		}
	}
});