(function($){
    FS.Tree = FR.extend(FR.SynchronBaseEditor, {
        _defaultConfig : function () {
            return $.extend(FS.Tree.superclass._defaultConfig.apply(), {
                width : 120,
                height : 200,
                expand : true,
                limitData : 1000,
                opentreenodeclass : 'fr-tree-elbow-plus',
                opentreenodeendclass : 'fr-tree-elbow-end-plus',
                closetreenodeclass : 'fr-tree-elbow-minus',
                closetreenodeendclass : 'fr-tree-elbow-end-minus',
                style : 'black'
            });
        },

        ShowStyle : {
            //ֶַ֧fsdtϵĿ¼accordionַʽ
            "FSDT" : "FSDT",
            "ACCORDION" : "ACCORDION"
        },

        _init : function() {
            FS.Tree.superclass._init.apply(this, arguments);

            FR.$defaultImport("/com/fr/fs/web/css/" + this.options.style.toLowerCase() + "/fs.widget.tree.css", "css");

            this._initClassName();

            this.element.addClass('fs_tree');
            this.initData();
            if (this.options.widgetName != null) {
                this.element.attr("id", this.options.widgetName);
            }
            if (this.options.width > -1 || this.options.width == 'auto') {
                this.element.css("width", this.options.width);
            }
            if (this.options.height > -1 || this.options.height == 'auto') {
                this.element.css("height", this.options.height);
            }

            this.element.css('overflow-y', 'auto').css('overflow-x', 'hidden');
            this.allTreeView();
        },

        _initClassName : function() {
            if(this.options.showstyle) {
                var showstyle = this.options.showstyle.toLowerCase();
                this.options.opentreenodeclass = this.options.opentreenodeclass + "-" + showstyle;
                this.options.opentreenodeendclass = this.options.opentreenodeendclass + "-" + showstyle;
                this.options.closetreenodeclass = this.options.closetreenodeclass + "-" + showstyle;
                this.options.closetreenodeendclass = this.options.closetreenodeendclass + "-" + showstyle;
            }
        },

        initData : function() {
            if (this.options.data) {
                return;
            }
            if (this.options.rootLoader) {
                this.options.data = new FR.SynchronTreeData({
                    treeLoader : this.options.rootLoader
                });
            } else if (this.options.treedata) {
                this.options.data = new FR.SynchronTreeData({
                    dataSource : new FR.SynchronTreeSource({
                        treedata : this.options.treedata
                    })
                });
            } else {
                this.options.data = new FR.SynchronTreeData({
                    url : this.options.widgetUrl
                });
            }
        },

        reBuild : function(treedata) {
            this.options.data = null;
            this.element.empty();
            this.options.treedata = treedata;
            this.initData();
            this.allTreeView();
        },

        reBulidWidgetUrl : function (widgetUrl) {
            this.options.data = null;
            this.element.empty();
            this.options.widgetUrl = widgetUrl;
            this.initData();
            this.allTreeView();
        },

        allTreeView : function() {
            var dfop = {
//	            cbiconpath: FR.servletURL + "?op=resource&resource=/com/fr/web/core/js/jquerytree/images/icons/",
//	            icons: ["checkbox_0.gif", "checkbox_1.gif", "checkbox_2.gif"],
//	            showcheck: false,
//	            oncheckboxclick: false,
//	            onnodeclick: false,
//	            cascadecheck: true,
//	            clicktoggle: true,
//	            theme: "fr-tree-no-lines"//fr-tree-lines ,fr-tree-no-lines,fr-tree-arrows
            };
            this.options = $.extend(dfop, this.options);
            var treedata = this.options.data;
            this.alwaysLoad = true;
            this.isLoadingData = false;

            var me = this.element;
            this.id = me.attr("id");
            if (this.id == null || this.id == "") {
                this.id = "bbtree" + new Date().getTime();
                me.attr("id", this.id);
            }
            me.addClass("fr-tree");
//	        if (dfop.showcheck) {
//	            for (var i = 0; i < 3; i++) {
//	                var im = new Image();
//	                im.src = dfop.cbiconpath + dfop.icons[i];
//	            }
//	        }
            me.unbind('scroll');
            var self = this;
            treedata.afterRead(function(nodes) {
                self.nodes = nodes;
                self.createTree(nodes);
                self.isLoadingData = false;
                me.__loadingMoreData__(false);
                self.scrollEvent();
            });
            treedata.appendDataEvent(function(nodes) {
                self.insertNodes(nodes);
                self.isLoadingData = false;
                me.__loadingMoreData__(false);
            });
            treedata.resetStatus(this.allPara());
            this.isLoadingData = true;
            me.__loadingMoreData__(true);
            treedata.loadData();

        },

        addNode : function(node) {
            if (this.fireEvent(FR.Events.APPENDDATA, node)) {
                this.options.data.updateData(node);
            }
        },

        getSelectedData : function() {
            return this.getCurrentItem();
        },

        editNode : function(node) {
            if (this.fireEvent(FR.Events.EDITDATA, node.getContent())) {
                $('#' + this.id + '_' + node.getID() + ' > a > span', this.element).text(node.getShowValue());
            }
            ;
        },

        removeNode : function() {
            var cn = this.getCurrentItem();
            if (!cn || cn.getID() < 0) {
                return;
            }
            if (this.fireEvent(FR.Events.REMOVEDATA, cn)) {
                cn.ui.remove();
                this.options.data.removeData(cn);
            }
        },

        scrollEvent : function () {
            var self = this;
            this.element.scroll(function(e) {
                if (self.alwaysLoad && $(this).scrollTop() + $(this).height() == this.scrollHeight && !self.isLoadingData) {
                    self.isLoadingData = true;
                    self.element.__loadingMoreData__(true);
                    var data = self.options.data;
                    data.resetStatus(self.allPara(data.getAllNodesLength()));
                    data.loadData();
                }
            });
        },

        checkState : function(nodes) {
            var al = this.getAllNodesLength(nodes);
            if (al != this.options.limitData) {
                this.alwaysLoad = false;
            }
            if (this.options.data.resetStatus(this.allPara())) {
                return false;
            }
            return true;
        },

        getAllNodesLength : function(nodes) {
            var al = nodes.length;
            for (var i = 0, len = nodes.length; i < len; i++) {
                al += this.executeLength(nodes[i]);
            }
            return al;
        },

        executeLength : function(node) {
            var al = node.getChildrenLength();
            for (var i = 0, len = node.getChildrenLength(); i < len; i++) {
                al += this.executeLength(node.getChild(i));
            }
            return al;
        },

        allPara : function(start, limit) {
            var para = this.createDependencePara4Data();
            para.parameter.startIndex = start ? start : 0;
            para.parameter.limitIndex = limit ? limit : this.options.limitData;
            if (this.searchText) {
                parameter.filter = this.searchText;
            }
            return para;
        },

        addSimpleData : function (data) {
            this.options.data.updateData(data);
        },

        insertNodes : function (nodes) {
            if (!this.checkState(nodes)) {
                return;
            }
            if (nodes.length < 1) {
                return;
            }
            var rootul = $('ul.fr-tree-root', this.element);
            for (var i = 0, len = nodes.length; i < len; i++) {
                var parent = nodes[i].getParent();
                if (parent) {
                    var ul;
                    var isShow = parent.ui.is(":visible");

                    if (parent.ui.children('ul').length > 0) {
                        ul = parent.ui.children('ul');
                    } else {
                        ul = $("<ul/>").addClass('fr-tree-node-ct');
                        parent.ui.append(ul);
                        var pd = parent.ui.children('div');
                        var self = this;
                        var ecicon = this.createEmptyIcon().addClass(this.generateExpandIconClass(parent)).click(function(e) {
                            self.expandOrCloseNode(pd, $(this), parent, e)
                        });
                        var img = $($(pd).children('img')[0]);
                        ecicon.insertAfter(img);
                        img.remove();
                    }
                    if (!isShow) {
                        ul.hide();
                    }
                    var li = this.createTreeNode(nodes[i], 1);
                    if (!isShow) {
                        li.hide();
                    }
                    ul.append(li);
                } else {
                    rootul.append(this.createTreeNode(nodes[i], 0));
                }
            }
        },

        createTree : function(nodes) {
            if (!this.checkState(nodes)) {
                return;
            }
            var rootul = $('<ul/>').addClass('fr-tree-root ' + this.options.theme);
            var content = $('<div/>').addClass('bbit-filtertree-body');
            content.append($('<div/>').addClass('fr-tree-bwrap').append(rootul));
            for (var i = 0, len = nodes.length; i < len; i++) {
                rootul.append(this.createTreeNode(nodes[i], 0));
            }
            this.element.append(content);
//	        if(this.options.showstyle === 'FSDT' && !this.options.expand) {
//	        	$('.fs-tree-node-content', this.element).addClass('fs-tree-node-lastnode');
//	        }
        },

        createTreeNode :  function(node, layer) {
            var li = $('<li/>').addClass('fr-tree-node');
            var div = $('<div/>').attr({id : this.id + '_' + node.getID(), unselectable : 'on'}).addClass(this.generateClass(node))
                .attr('title', node.getShowValue());
            this.generatePlaceAndIcon(node, div);
            div.append(this.generateValue(node, layer));
            li.append(div);
            var self = this;
            var showstyle = self.options.showstyle;
            div.hover(function() {
                    if(showstyle) {
                        if($(this).hasClass('fr-tree-node-el-'+ showstyle.toLowerCase() +'-root')) {
                            $(this).addClass("fr-tree-node-"+ showstyle.toLowerCase() +"-over-root");
                        } else {
                            $(this).addClass("fr-tree-node-"+ showstyle.toLowerCase() +"-over");
                        }
                    } else {
                        $(this).addClass("fr-tree-node-over");
                    }
                },
                function() {
                    if(showstyle) {
                        $(this).removeClass("fr-tree-node-"+ showstyle.toLowerCase() +"-over");
                        $(this).removeClass("fr-tree-node-"+ showstyle.toLowerCase() +"-over-root");
                    } else {
                        $(this).removeClass("fr-tree-node-over");
                    }
                });
            var self = this;
            div.click(
                function(e) {
                    var dfop = self.options;
//	                if (dfop.showcheck) {
//	                    return;
//	                }
                    if (dfop.currentnode != node && !self.fireEvent(FR.Events.BEFORESTATECHANGE)) {
                        return;
                    }
                    if(self.options.showstyle) {
                        if (dfop.currentnode) {
                            self._removeSelect(dfop.currentnode);
                        }
                        if(dfop.currentnode) {
                            self._selectNode(node);
                            dfop.currentnode = node;
                        } else {
                            dfop.currentnode = null;
                        }
                        var hideDiv = null;
                        if(div.hasClass('fr-tree-node-el-'+ self.options.showstyle.toLowerCase() +'-root')) {
                            hideDiv = $(".fr-tree-"+ self.options.showstyle.toLowerCase() +"-selected", self.element);
                        } else {
                            if(dfop.currentleafnode && dfop.currentleafnode != node) {
                                var sd = $("#" + self.id + "_" + dfop.currentleafnode.getID(), self.element);
                                sd.removeClass("fr-tree-node-el-" + self.options.showstyle.toLowerCase() + "-selected-leaf");
                            }
                            var sd = $("#" + self.id + "_" + node.getID(), self.element);
                            sd.addClass("fr-tree-node-el-" + self.options.showstyle.toLowerCase() + "-selected-leaf");
                            dfop.currentleafnode = node;
                        }
                        self.expandOrCloseNode(div, $(div.children('img')[0]), node, e, hideDiv);
                    } else {
                        if (dfop.currentnode) {
                            self._removeSelect(dfop.currentnode);
                        }
                        dfop.currentnode = node;
                        self._selectNode(node);
                    }
                    self.fireEvent(FR.Events.CLICK, node);
                    self.fireEvent(FR.Events.AFTEREDIT);
                    e.stopEvent();
                }).dblclick(function(e) {
                    if(!self.options.showstyle) {
                        self.expandOrCloseNode(div, $(div.children('img')[0]), node, e);
                    }
                });
            node.ui = li;
            if (node.isLoadComplete() && node.getChildrenLength() > 0 && this.options.expand) {
                var ul = $("<ul/>").addClass('fr-tree-node-ct');
                div.parent('li').append(ul);
                layer ++;
                for (var i = 0, len = node.getChildrenLength(); i < len; i++) {
                    ul.append(this.createTreeNode(node.getChild(i), layer));
                }
                if (!node.isexpand() && !this.options.expand) {
                    ul.hide();
                }
            }
            return li;
        },

        _selectNode : function(node) {
            var sd = $("#" + this.id + "_" + node.getID(), this.element);
            if(!this.options.showstyle) {
                sd.addClass("fr-tree-selected");
            }
//	    	while(node.getParent()) {
//	    		node = node.getParent();
//	    		var sd = $("#" + this.id + "_" + node.getID(), this.element);
//	    		if(this.options.showstyle === "FSDT") {
//	    			$('.fs-tree-node-content', sd).addClass("fr-tree-fsdt-selected");
//	    		} else {
//	            	sd.addClass("fr-tree-selected");
//	    		}
//	    	}
        },

        _removeSelect : function(node) {
            var sd = $("#" + this.id + "_" + node.getID(), this.element);
            sd.removeClass("fr-tree-selected");
//	    	while(node.getParent()) {
//	    		node = node.getParent();
//	    		var sd = $("#" + this.id + "_" + node.getID(), this.element);
//	    		if(this.options.showstyle === "FSDT") {
//	    			$('.fs-tree-node-content', sd).removeClass("fr-tree-fsdt-selected");	
//	    		} else {
//	            	sd.removeClass("fr-tree-selected");
//	    		}
//	    	}
        },

        generateClass : function(node) {
            var classes = ['fr-tree-node-el'];
            (this.options.folderMode || node.hasChild()) ? (classes.push((node.isexpand() || this.options.expand) ? "fr-tree-node-expanded" : "fr-tree-node-collapsed")) :
                (classes.push(node.data.nodeicon ? 'fr-tree-node-' + node.data.nodeicon : "fr-tree-node-leaf"));
            classes.push(node.getclasses());
            if(this.options.showstyle) {
                var showstyle = this.options.showstyle.toLowerCase();
                if((this.options.folderMode || node.hasChild()) && !node.getParent()) {
                    classes.push('fr-tree-node-el-'+ showstyle +'-root');
                } else {
                    classes.push('fr-tree-node-el-' + showstyle);
                }
            }
            return classes.join(' ');
        },

        expandOrCloseNode : function(div, $expandIcon, node, e, hideDiv) {
            if (!$expandIcon) {
                return;
            }
            var ul = div.next();
            if ($expandIcon.hasClass(this.options.opentreenodeclass) || $expandIcon.hasClass(this.options.opentreenodeendclass)) {
                if (!this.options.expand && ul.length === 0 && node.isLoadComplete() && node.getChildrenLength() > 0) {
                    ul[0] = $("<ul/>").addClass('fr-tree-node-ct');
                    div.parent('li').append(ul[0]);
                    for (var i = 0, len = node.getChildrenLength(); i < len; i++) {
                        ul[0].append(this.createTreeNode(node.getChild(i), node.getAncestorsLength()+1));
                    }
                }
                if(hideDiv && hideDiv.length > 0) {
                    hideDiv.removeClass("fr-tree-"+this.options.showstyle.toLowerCase()+"-selected");
                    var $imgClass = $(hideDiv.children('img')[0]);
                    if($imgClass.hasClass(this.options.closetreenodeendclass)){
                        $imgClass.swapClass(this.options.closetreenodeendclass,this.options.opentreenodeendclass);
                    }else{
                        $imgClass.swapClass(this.options.closetreenodeclass, this.options.opentreenodeclass);
                    }
                    hideDiv.swapClass("fr-tree-node-expanded", "fr-tree-node-collapsed");
                    this.collapseAndExpand(hideDiv.next(), ul);
                } else {
                    if (ul.length > 0) {
                        ul.slideDown(300);
                    }
                }

                if ($expandIcon.hasClass(this.options.opentreenodeclass)) {
                    $expandIcon.swapClass(this.options.opentreenodeclass, this.options.closetreenodeclass);
                } else {
                    $expandIcon.swapClass(this.options.opentreenodeendclass, this.options.closetreenodeendclass);
                }
                div.swapClass("fr-tree-node-collapsed", "fr-tree-node-expanded");
                if(this.options.showstyle) {
                    if(div.hasClass('fr-tree-node-el-'+ this.options.showstyle.toLowerCase() +'-root')) {
                        div.addClass("fr-tree-"+this.options.showstyle.toLowerCase()+"-selected");
                    }
                }
            } else if ($expandIcon.hasClass(this.options.closetreenodeclass) || $expandIcon.hasClass(this.options.closetreenodeendclass)) {  //- Ҫ
                ul.slideUp(300);
                if ($expandIcon.hasClass(this.options.closetreenodeclass)) {
                    $expandIcon.swapClass(this.options.closetreenodeclass, this.options.opentreenodeclass);
                } else {
                    $expandIcon.swapClass(this.options.closetreenodeendclass, this.options.opentreenodeendclass);
                }
                div.swapClass("fr-tree-node-expanded", "fr-tree-node-collapsed");
                if(this.options.showstyle) {
                    div.removeClass("fr-tree-"+this.options.showstyle.toLowerCase()+"-selected");
                }
            }
            if($.isFunction(this.options.expandOrClose)) {
                this.options.expandOrClose(node);
            }
            e.stopEvent();
        },

        collapseAndExpand : function(hc, sc) {
            hc.slideUp(300);
            sc.slideDown(300);
        },

        _addOddAndEvenStyle : function(node) {
            var nodeEls = $('.fr-tree-node-el:not(.fr-tree-node-el-accordion-root:visible)', this.element);
            for(var i = 0, len = nodeEls.length; i < len; i ++) {
                if(i % 2 === 0) {
                    $(nodeEls[i]).removeClass('fs-tree-node-el-odd');
                    $(nodeEls[i]).addClass('fs-tree-node-el-even');
                } else {
                    $(nodeEls[i]).removeClass('fs-tree-node-el-even');
                    $(nodeEls[i]).addClass('fs-tree-node-el-odd');
                }
            }
        },

        generatePlaceAndIcon : function(node, div) {
            var self = this;
            //b:ļд
            if(this.options.showstyle) {
                var rightspan = $('<span/>').addClass('fr-tree-node-right');
                div.append(rightspan);
            }
            //0,ļУisModuleģ
            if (this.options.favorite && (""+node.getID()).substring(0, 1) != "0" && node.data.isModule !== true && node.data.isFavorite !== true) {
                $('<span>&nbsp;</span>').attr('title', node.getContent().favoriteid != null ? FR.i18nText("Subscribed") : FR.i18nText("Subscribe")).addClass(node.getContent().favoriteid != null ? 'fs_tree_favorite' : 'fs_tree_favorite fs_tree_favorite_nochoose').click(
                    function(e) {
                        if ($(this).hasClass('fs_tree_favorite_nochoose')) {
                            $(this).removeClass('fs_tree_favorite_nochoose').attr('title', FR.i18nText("Subscribed"));
                        } else {
                            //ȡղ
                            $(this).addClass('fs_tree_favorite_nochoose').attr('title', FR.i18nText("Subscribe"));
                        }
                        self.fireEvent(FS.Events.FAVORITECHOOSE, node);
                        e.stopEvent();
                    }
                ).appendTo(div);
            }

            if(this.options.showstyle) {
                var leftspan = $('<span/>').addClass('fr-tree-node-left');
                div.append(leftspan);
            }

            var span = $('<span/>').addClass('fr-tree-node-indent');
            var len = node.getAncestorsLength();
            for (var i = 0; i < len; i++) {
                var cs = 'fr-tree-elbow-line';
                if (i === 0) {
                    cs = 'fr-tree-icon';
                }
                span.append(this.createEmptyIcon().addClass(cs));
            }
            div.append(span);

            if (!this.options.simpleMode) {
                var emptyIcon = this.createEmptyIcon();
                if(this.options.showstyle) {
                    emptyIcon.css("float", "left");
                }
                var $expandIcon = emptyIcon.addClass(this.generateExpandIconClass(node));


                if(node.data.icon) {
                    $expandIcon.attr("id", node.data.icon);
                }

                $expandIcon.click(function(e) {
                    self.expandOrCloseNode(div, $expandIcon, node, e)
                });

                div.append($expandIcon);

                if(!this.options.showstyle) {
                    var $folderIcon = this.createEmptyIcon().addClass('fr-tree-node-icon');
                    div.append($folderIcon);
                }
            }

//	        var dfop = this.options;
//	        if (dfop.showcheck) {
//	            if (node.getcheckstate() == null) {
//	                node.setcheckstate(0);
//	            }
//	            var checkIcon = $('<img/>').addClass('fr-tree-node-cb').attr({id : this.id + '_' + node.getID() + '_cb',
//	                src : dfop.cbiconpath + dfop.icons[node.getcheckstate() ? node.getcheckstate() : 0]})
//	            div.append(checkIcon);
//	            checkIcon.click(function(e) {
//	                var s = node.getcheckstate() !== 1 ? 1 : 0;
//	                var r = true;
//	                if (dfop.oncheckboxclick) {
//	                	//et undefind!whats this
//	                    r = dfop.oncheckboxclick.call(et, node, s);
//	                }
//	                if (r !== false) {
//	                    if (dfop.f2scascade) {
//	                        self.cascade(function() {
//	                            self.check(arguments[0], arguments[1], arguments[2]);
//	                        }, node, s);
//	                    }
//	                    if (dfop.s2fcascade) {
//	                        self.bubble(function() {
//	                            self.check(arguments[0], arguments[1], arguments[2]);
//	                        }, node, s);
//	                    }
//	                    if (!dfop.f2scascade && !dfop.s2fcascade) {
//	                        self.check(node, s, 1);
//	                    }
//	                }
//	                if (dfop.onnxodeclick) {
//	                    dfop.onnxodeclick.call(this);
//	                }
//	                e.stopEvent();
//	            });
//	        }
        },

        createEmptyIcon : function() {
//	    	if(this.options.showstyle) {
//	    		return $("<div/>").addClass('fr-tree-emptyimg');
//	    	} else {
            return $('<img/>').attr('src', FR.servletURL + '?op=resource&resource=/com/fr/web/core/js/jquerytree/images/s.gif');
//	    	}
        },

        generateExpandIconClass :function(node) {
            var cs = [];
            var isend = !node.getParent() ? this.options.data.getLastRootNode() == node : node.getParent().getChild(node.getParent().getChildrenLength() - 1) == node;
            if (node.hasChild()) {
                if (node.isexpand() || this.options.expand) {
                    cs.push(isend ? this.options.closetreenodeendclass : this.options.closetreenodeclass);
                } else {
                    cs.push(isend ? this.options.opentreenodeendclass : this.options.opentreenodeclass);
                }
            } else {
//	        	if(this.options.showstyle !== "FSDT") {
//	            	cs.push(isend ? "fr-tree-elbow-end" : "fr-tree-elbow");
//	        	} else {
                cs.push(isend ? "fr-tree-elbow-end" : "fr-tree-elbow");
                if(!node.hasChild()) {
                    switch(node.data.type) {
                        case '5' :
                            cs.push('fr-tree-leaf-processicon');
                            break;
                        case '2' :
                            if(node.data.nodeicon == 'frm') {
                                cs.push('fr-tree-leaf-frmicon');
                            } else {
                                cs.push('fr-tree-leaf-cpticon');
                            }
                            break;
                        case '3' :
                            cs.push('fr-tree-leaf-urlicon');
                            break;
                        case '7' :
                            cs.push('fr-tree-leaf-biicon');
                            break;
                        default :
                            cs.push('fr-tree-leaf-defaulticon');
                    }
//	        		}
                }
            }
            return cs.join(" ");
        },

        generateValue : function(node, layer) {
//            var subLength = layer ? layer*18 : 0;
//            var showValue = node.getShowValue();
//            if($.browser.msie && $.browser.version < '8.0') {
//                showValue = FS.getShowText(showValue, 95 - subLength);
//            }
            var contentSpan = $('<span/>').addClass('fs-tree-node-content').attr('unselectable', 'on').attr('title', node.getShowValue()).text(node.getShowValue());
//            if(this.options.showstyle === 'FSDT') {
//                contentSpan.css({
//                    'display':'inline-block',
//                    'height':'17px'
//                });
//                contentSpan.width(Math.max(this.element.width()-27, 160)-(layer+1)*18);
//            }
            if(this.options.showstyle) {
                var $text = $("<div/>").addClass("fr-tree-node-textwrap").append(contentSpan);
                //Sean: IE6Ҫʹtext-overflowЧΪwidth
                //    ǵgenerateValueſborder϶ٴδ
                //    IE6УĿ¼ӿ󣬳ʼʡԵֲֳҪĽ
                if(FR.Browser.isIE6()){
                    $text.width(180 - FS.leftMargin - (layer + 1)*20);
                }
                return $text;
            } else {
                return $('<a hideFocus/>').addClass('fr-tree-node-anchor').attr('tabIndex', 1).append(contentSpan);
            }

        },

        check : function(node, state, type) {
            var pstate = node.getcheckstate();
            if (type === 1) {
                node.setcheckstate(state);
            } else {// 
                var cs = [];
                if (node.isLoadComplete()) {
                    cs = node.getChildren();
                }
                var l = cs.length;
                var ch = true;
                for (var i = 0; i < l; i++) {
                    if ((state === 1 && cs[i].getcheckstate() !== 1) || state === 0 && cs[i].getcheckstate() !== 0) {
                        ch = false;
                        break;
                    }
                }
                if (ch) {
                    node.setcheckstate(state);
                } else {
                    node.setcheckstate(2);
                }
            }
            //change show
            if (pstate != node.getcheckstate()) {
                var et = $("#" + this.id + "_" + node.getID() + "_cb");
                if (et.length === 1) {
                    et.attr("src", this.options.cbiconpath + this.options.icons[node.getcheckstate()]);
                }
            }
        },
        //ӽ
        cascade : function(fn, node, args) {
            if (fn(node, args, 1) !== false) {
                if (node.isLoadComplete() && node.getChildrenLength() > 0) {
                    var cs = node.getChildren();
                    for (var i = 0, len = cs.length; i < len; i++) {
                        this.cascade(fn, cs[i], args);
                    }
                }
            }
        },
        //ðݵ
        bubble : function(fn, node, args) {
            fn(node, args, 1);
            var p = node.getParent();
            while (p) {
                if (fn(p, args, 0) === false) {
                    break;
                }
                p = p.getParent();
            }
        },

        /**
         * carl
         * ӸparentLimit,ָʾڵ㱻ѡʱֻظڵOK
         */
        getck : function(nodes, parentLimit, c, fn) {
            for (var i = 0, l = nodes.length; i < l; i++) {
                if (nodes[i].getcheckstate() === 1) {
                    c.push(fn(nodes[i]));
                    if (parentLimit) {
                        continue;
                    }
                }
                if (nodes[i].isLoadComplete() && nodes[i].getChildrenLength() > 0) {
                    this.getck(nodes[i].getChildren(), parentLimit, c, fn);
                }
            }
        },

        limitedNodes : function(layer, nodes, ln) {
            if (!layer || !nodes) {
                return;
            }
            if (layer === 1) {
                for (var i = 0, len = nodes.length; i < len; i++) {
                    if (nodes[i].getcheckstate() === 1) {
                        ln.push(nodes[i]);
                    }
                }
            } else {
                for (var i = 0, len = nodes.length; i < len; i++) {
                    if (!nodes[i].isLoadComplete()) {
                        continue;
                    }
                    var ns = nodes[i].getChildren();
                    --layer;
                    limitedNodes(layer, ns, ln);
                }
            }
        },

        /**
         * carl
         * ӸparentLimit,ָʾڵ㱻ѡʱֻظڵOK
         */
        getSelectedNodes: function(parentLimit) {
            if (this.options.limitedNode) {
                return this.getLimitedNodes();
            }
            var s = [];
            this.getck(this.options.data.nodes, parentLimit, s, function(node) {
                return node
            });
            return s;
        },

        getLimitedNodes : function() {
            var lns = [];
            this.limitedNodes(this.options.limitedNode, this.options.data.nodes, lns);
            return lns;
        },

        getSelectedValues: function() {
            var nodes = this.getSelectedNodes();
            return $.map(nodes, function(node) {
                return node.getValue();
            });
        },

        getSelectedTexts: function() {
            var nodes = this.getSelectedNodes();
            return $.map(nodes, function(node) {
                return node.getShowValue();
            });
        },

        getCurrentItem: function() {
            return this.options.currentnode;
        },

        getValue : function() {
            return this.getCurrentItem().getValue();
        },

        setValue : function(value) {
            //ñ༭ֵ
        },

        reset : function() {
            // ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
            this.setValue("");
        },
        doResize : function(give) {
            FR.TreeEditor.superclass.doResize.call(this, give);
        },

        clearChoose : function() {
            var nodes = this.options.data.nodes;
            this.clearNodes(this.options.data.nodes);

        },

        clearNodes : function(nodes) {
            for (var i = 0, l = nodes.length; i < l; i++) {
                if (nodes[i].getcheckstate()) {
                    var node = nodes[i];
                    node.setcheckstate(0);
                    var et = $("#" + this.id + "_" + node.getID() + "_cb", this.element);
                    if (et.length === 1) {
                        et.attr("src", this.options.cbiconpath + this.options.icons[0]);
                    }
                }

                if (nodes[i].getChildrenLength() > 0) {
                    this.clearNodes(nodes[i].getChildren());
                }
            }
        },

        selecteItems : function(items) {

        },

        selecteByID : function(ids) {
            this.clearChoose();
            this.selecteID(this.options.data.nodes, ids);
        },

        selecteID : function(nodes, ids) {
            var dfop = this.options;
            var self = this;
            for (var i = 0, l = nodes.length; i < l; i++) {
                var node = nodes[i];
                if (ids.indexOf(node.getID()) > -1) {
                    node.setcheckstate(1);
                    var et = $("#" + this.id + "_" + node.getID() + "_cb", this.element);
                    if (et.length === 1) {
                        et.attr("src", this.options.cbiconpath + this.options.icons[1]);
                    }
                    if (dfop.f2scascade) {
                        this.cascade(function() {
                            self.check(arguments[0], arguments[1], arguments[2]);
                        }, node, 1);
                    }
                    if (dfop.s2fcascade) {
                        this.bubble(function() {
                            self.check(arguments[0], arguments[1], arguments[2]);
                        }, node, 1);
                    }
                    //danielѡѡ
                    if (dfop.currentnode) {
                        var sd = $("#" + this.id + "_" + dfop.currentnode.getID());
                        if (sd[0]) {
                            sd.removeClass("fr-tree-selected");
                        } else {
                            $('li > div', this.element).removeClass("fr-tree-selected");
                        }
                    }
                    dfop.currentnode = node;
                    var div = $("#" + this.id + "_" + node.getID());
                    div.addClass("fr-tree-selected");
                    self.fireEvent(FR.Events.CLICK, node);
                    self.fireEvent(FR.Events.AFTEREDIT);
                }

                if (ids.indexOf(node.getID()) < 0
                    || (!dfop.f2scascade && !dfop.s2fcascade)
                    && nodes[i].getChildrenLength() > 0) {
                    this.selecteID(nodes[i].getChildren(), ids);
                }
            }
        },

        getSelectedID: function(parentLimit) {
            var nodes = this.getSelectedNodes(parentLimit);
            return $.map(nodes, function(node) {
                return node.getID();
            });
        },

        getSelectedItems : function() {
            return this.getSelectedNodes();
        }
    });
})(jQuery);