/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-4-3
 * Time: 3:26
 */
FS.SYSMONITOR = {
    init : function(renderer){
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_sysmonitor.css', 'css');
        var items=[
            this.logInfoModule(),
            this.visitMgrModule(),
            this.sysStateModule(),
            this.sysExamModule()
        ];
        this.sysmonitor = new FS.LTabPane({
            width:'100%',
            height:'100%',
            items: items,
            style: 'blue',
            marginLeft: 40,
            vgap:21,
            renderEl: renderer
        });
        this.createSetPane(renderer);
    },
    /**
     * ý
     * @param anchor ̶dom
     */
    createSetPane: function(anchor){
        var self = this;
        var floatPane = FR.createWidget({
            type: 'floatpane',
            anchor: anchor,
            contentHieght: 220,
            contentWidget: {
                type: 'confirm',
                fit: true,
                doSize: true,
                closeAfterAction: false,
                btnsAlignment: 'left',
                needSeparate: 8,
                onOK: function(){
                    var logData = {
                        iserrorrecord : floatPane.getWidgetByName("LOGSTATE").getValue(),
                        loglevel : floatPane.getWidgetByName("LOGLEVEL").getValue()
                    };
                    FR.ajax({
                        url: FR.servletURL + '?op=fr_server&cmd=sc_log_set',
                        type: 'POST',
                        data: logData,
                        async : false,
                        complete : function(res, status) {
                            if (status === 'success') {
                                FR.Msg.toast(FR.i18nText("Successfully"));
                            }
                        }
                    });
                    var visitItemsData = {
                        delimiter:',',
                        visititems: floatPane.getWidgetByName("OPTSTATIC").getValue().join(',')
                    };
                    FR.ajax({
                        url: FR.servletURL + '?op=fr_log&cmd=fg_config',
                        data: visitItemsData,
                        type: 'POST',
                        complete : function(res, status) {
                            if (status === 'success') {
                                floatPane.doSlide();
                                FR.Msg.toast(FR.i18nText("Successfully"));
                            }
                        }
                    });
                },
                onCancel: function(){
                    self.popSetData(floatPane);
                    floatPane.doSlide();
                },
                contentWidget: {
                    type: 'tablelayout',
                    rowSize: [0,60,50],
                    columnSize: [20, 660],
                    vgap: 20,
                    items: [
                        [null,{el: $('<div/>')}],
                        [
                            null,
                            {el: {
                                widgetName: 'LOGSETTABLE',
                                type: 'tablelayout',
                                columnSize : [75, 131, 140],
                                rowSize : [25, 23],
                                vgap : 8,
                                items: [
                                    [
                                        {el : {type: 'llabel',value: FR.i18nText("Log_Setting")}},
                                        {el : {type: 'llabel',value: FR.i18nText("Log_Statistics")}},
                                        {el : {type: 'switch', widgetName: 'LOGSTATE'}}
                                    ],
                                    [
                                        null,
                                        {el : {type: 'llabel', value: FR.i18nText("Log_Level")}},
                                        {el : {
                                            type: 'combo',
                                            widgetName: 'LOGLEVEL',
                                            items : [{text : 'SEVERE',value : 'SEVERE'},
                                                {text : 'WARNING',value : 'WARNING'},
                                                {text : 'INFO',value : 'INFO'},
                                                {text : 'DEBUG',value : 'DEBUG'}]
                                        }}
                                    ]
                                ]
                            }}
                        ],[
                            null,
                            {el: {
                                widgetName: 'STATICSETTABLE',
                                type: 'tablelayout',
                                columnSize : [75, 360],
                                rowSize : [50],
                                vgap : 8,
                                items: [
                                    [
                                        {el : {type: 'llabel',value: FR.i18nText("Options_Static"), verticalcenter: false}},
                                        {el : {
                                            type: 'checkboxgroup',
                                            widgetName: 'OPTSTATIC',
                                            returnArray: true,
                                            items: [
                                                {text: FR.i18nText("M-Page_Preview"),value:'page'},
                                                {text:FR.i18nText("M-Data_Analysis"),value:'view'},
                                                {text: FR.i18nText("M-Form_Preview"),value:'form'},
                                                {text:FR.i18nText("Face_Write"),value:'write'},
                                                {text: FR.i18nText("ExportAndOutput"),value:'export'},
                                                {text: FR.i18nText("Print"),value:'print'}
                                            ],
                                            columnsInRow: 3
                                        }}
                                    ]
                                ]
                            }}
                        ]
                    ]
                }
            }
        });
        this.popSetData(floatPane);
    },
    popSetData: function(pane){
        var self = this;
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_get_loginfo',
            type: 'POST',
            complete : function(res, status) {
                if(status == 'success'){
                    var basicAttr = FR.jsonDecode(res.responseText);
                    pane.getWidgetByName("LOGSTATE").setValue(basicAttr.iserrorrecord);
                    pane.getWidgetByName("LOGLEVEL").setValue(basicAttr.loglevel);
                }

            }
        });
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_visit_info',
            type: 'POST',
            complete : function(res, status) {
                if(status == "success") {
                    var config = FR.jsonDecode(res.responseText);
                    var result = [];
                    $.each(config, function(idx, itm) {
                        if(itm === true) {
                            result.push(idx);
                        }
                    });
                    pane.getWidgetByName('OPTSTATIC').setValue(result);
                }
            }
        });
    },
    /*************־Ϣ*************/
    logInfoModule : function(){
    	var self = this;
        var logviewPanel = {
            title: FR.i18nText("Log_View"),
            content: {
                type: 'absolute',
                items: [
                    {el: {
                        type: 'panel',
                        width: 500,
                        height: 25,
                        doSize: true,
                        contentWidget: {
                            type: 'tablepane',
                            colSize: [22, 165, 35, 165, 20, 60],
                            rowSize: [21],
                            items: [
                                [
                                    {type: 'llabel', value: FR.i18nText("Date_From")},
                                    {type: 'datetime', value: new Date(), format: 'yyyy-MM-dd', widgetName: 'STARTDATE'},
                                    {type: 'llabel', value: FR.i18nText("Date_To"), textalign: 'center'},
                                    {type: 'datetime', value: new Date(), format: 'yyyy-MM-dd', widgetName: 'ENDDATE'},
                                    $('<div/>'),
                                    {type: 'quickbutton', text: FR.i18nText("Query"), style: 'blue',
                                        handler: function () {
                                            var errorgrid = self.sysmonitor.getWidgetByName('ERRORGRID');
                                            var startTime = self.sysmonitor.getWidgetByName('STARTDATE').getValue(),
                                                endTime = self.sysmonitor.getWidgetByName('ENDDATE').getValue();
                                            FR.ajax({
                                                url: FR.servletURL + '?op=fr_server&cmd=sc_get_loginfo',
                                                type: 'POST',
                                                async: false,
                                                data: {
                                                    startTime: startTime,
                                                    endTime: endTime
                                                },
                                                complete: function (res, status) {
                                                    if (status == 'success') {
                                                        var result = FR.jsonDecode(res.responseText);
                                                        errorgrid.refresh(result.loginfo)
                                                    }

                                                }
                                            });
                                        }
                                    }
                                ]
                            ]
                        }
                    }, x: 40, y: 70},
                    {el:{
                        type: 'quickgrid',
                        isInitWithData: false,
                        widgetName: 'ERRORGRID',
                        page: true,
                        pageCount: 15,
                        columnsConfig: [
                            {
                                key: 'error',
                                value: FR.i18nText("Simple_Error_Message"),
                                width: 260
                            },{
                                key: 'detailError',
                                value: ' ',
                                width: 40,
                                onCellCreate : function(rowIdx, colIdx, item, colCfg) {
                                    var $cell = $('<div class="fs-sysmonitor-detail"/>').
                                        text(FR.i18nText("Detail_Info"))
                                        .hover(
                                        function(){
                                            $(this).addClass('fs-sysmonitor-detail-hover')
                                        },
                                        function(){
                                            $(this).removeClass('fs-sysmonitor-detail-hover')
                                        }
                                    )
                                        .click(function () {
                                            var tip1 = $('<span/>').text(item.detailError);
                                            var $tipContext = $('<div class="fs-sysmonitor-detailmsg"/>');
                                            $tipContext.append(tip1);
                                            var left = $(this).offset().left + $(this).width();
                                            var top = $(this).offset().top + $(this).height() - 120;
                                            $tipContext.appendTo($('body')).css({
                                                position: 'absolute',
                                                left: left,
                                                top: top
                                            });
                                            $(document).bind('mousedown.tip', function(e){
                                                var target = e.target;
                                                if(!$(target).isChildAndSelfOf('.fs-sysmonitor-detailmsg')){
                                                    $tipContext.remove();
                                                    $(document).unbind('mousedown.tip');
                                                }
                                            });
                                        });
                                    return $cell;
                                }
                            },{
                                key: 'logtime',
                                value: FR.i18nText("Error_Time"),
                                width: 190
                            },{
                                key: 'reportname',
                                value: FR.i18nText("Error_Template"),
                                width: 200
                            }
                        ]
                    }, x:40, y: 100}
                ]
            }
        };
        return logviewPanel;
    },
    /*************ͳƲ鿴*************/
    visitMgrModule: function(){
        var  visitMgrCfg = {
            title:FR.i18nText("Platform_Module_AccessInfo"),
            content:{
                type: 'panel',
                width: 750,
                height: 750,
                doSize: true,
                contentWidget: this._createVisitorViewTable()
            }
        };
        return visitMgrCfg;
    },
    _createVisitorViewTable : function(){
        var  visitorViewConfig = {
            widgetName: 'visitorViewModel',
            type: 'tablelayout',
            items: [
                [{el : {type: 'llabel',levelStyle:1,value: FR.i18nText("FS-System_Visit_Times")}},null],
                [{el : this._createTimePaneForChart()},null],
                [{el : this._createTimeChartPane()},null],
                [{el : {type: 'llabel',levelStyle:1,value: FR.i18nText("FS-System_Report_Visit_Detail")}},null],
                [{el : this._createTimeQueryPane()},null],
                [{el : this._createVisitorInfoShowTable()},null],
                [{el : this._createVisitorDetailInfoShowTable()},null]
            ],
            columnSize : [731,'fill'],
            rowSize : [28,28,245,28,40,460,460],
            vgap : 10
        };
        return visitorViewConfig;
    },
    _createTimePaneForChart:function(){
        var self = this;
        var date =new Date();
        var config ={
            widgetName:'timePaneForChart',
            type: 'panel',
            width: 730,
            height: 35,
            doSize: true,
            contentWidget: {
                widgetName: 'timePaneAbsolute',
                type: 'absolute',
                items: [
                    {x:250,y:0,type:'iconbutton',width:25,baseClass:'fr-grid-foot-first',handler:function(){
                        var widget = self.sysmonitor.getWidgetByName('statisticChartTime');
                        var value = widget.getValue();
                        self.chartTime =  self.getDateByFormat(value,0);
                        widget.setValue(self.chartTime);
                        self._refreshIframe();
                    }},
                    {x:290,y:0,type:'iconbutton',width:25,baseClass:'fr-grid-foot-prev',handler:function(){
                        var widget = self.sysmonitor.getWidgetByName('statisticChartTime');
                        var value = widget.getValue();
                        self.chartTime =  self.getDateByFormat(value,1);
                        widget.setValue(self.chartTime);
                        self._refreshIframe();
                    }},
                    {x:320, y: 0,type: 'datetime', value: date,  format: 'yyyy-MM',  height: 21, width: 140, widgetName: "statisticChartTime",
                        listeners : [{
                            eventName : "afteredit",
                            action: function() {
                                self.chartTime = this.getValue();
                                self._refreshIframe();
                            }
                        }]},
                    {x:460,y:0,type:'iconbutton',width:25,baseClass:'fr-grid-foot-next',handler:function(){
                        var widget = self.sysmonitor.getWidgetByName('statisticChartTime');
                        var value = widget.getValue();
                        self.chartTime =  self.getDateByFormat(value,2);
                        widget.setValue(self.chartTime);
                        self._refreshIframe();
                    }},
                    {x:495,y:0,type:'iconbutton',width:25,baseClass:'fr-grid-foot-last',handler:function(){
                        var widget = self.sysmonitor.getWidgetByName('statisticChartTime');
                        var value = widget.getValue();
                        self.chartTime =  self.getDateByFormat(value,3);
                        widget.setValue(self.chartTime);
                        self._refreshIframe();
                    }}
                ]
            }
        }
        return config;

    },
    _createTimeQueryPane : function(){
        var self = this;
        var date = new Date();
        var timeQueryPaneConfig = {
            type: 'panel',
            width: 730,
            height: 35,
            doSize: true,
            renderEl:$('<div/>'),
            contentWidget: {
                widgetName: 'timeQueryAbsolute',
                type: 'absolute',
                items: [
                    {type: 'llabel', value: FR.i18nText("Date_From"), x: 0, y: 4, height: 21, width: 22},
                    {type: 'datetime', value: new Date(date.getTime()-1000*60*60*24),  format: 'yyyy-MM-dd', x: 22, y: 4, height: 21, width: 165, widgetName: "startdate"},
                    {type: 'llabel', value: FR.i18nText("Date_To"), textalign: 'center', x: 187, y: 4, height: 21, width: 35},
                    {type: 'datetime', value: date, format: 'yyyy-MM-dd', x: 222, y: 4, height: 21, width: 165, widgetName: "enddate"},
                    {type: 'quickbutton', text: FR.i18nText("Query"), x: 406, y: 4, height: 21, width: 60, handler: function() {
                        var startTime =  self.sysmonitor.getWidgetByName('startdate').getValue();
                        var endTime =  self.sysmonitor.getWidgetByName('enddate').getValue();
                        self.getVisitorInfo(startTime,endTime);
                        self.popOrRefreshData();
                    }},
                    {type: 'checkbox',widgetName: "isShowDetail",text: FR.i18nText("Face_View")+FR.i18nText("Detail"),value:true, x: 496, y: 4, height: 28, width: 100, handler: function() {
                        var value = self.sysmonitor.getWidgetByName('isShowDetail').getValue();
                        if(value === true){
                            var visitorViewTable = self.sysmonitor.getWidgetByName('visitorViewModel');
                            visitorViewTable.setRowVisible(5,true);
                            visitorViewTable.setRowVisible(6,false);
                            visitorViewTable.doLayout();
                            return;
                        }else{
                            var visitorViewTable = self.sysmonitor.getWidgetByName('visitorViewModel');
                            visitorViewTable.setRowVisible(5,false);
                            visitorViewTable.setRowVisible(6,true);
                            visitorViewTable.doLayout();
                            return;
                        }
                    }}
                ]
            }
        }
        return timeQueryPaneConfig;
    },
    _refreshIframe:function(){
        var timeParameter;
        timeParameter = this.chartTime+'-01';
        var src = FR.servletURL +'?op=fr_server&cmd=sc_report_op_timemap&__showtoolbar__=false&chartTime='+timeParameter;
        $('#fs_visitor_manager_iframe').attr('src',src);
    },
    _createTimeChartPane : function(){
        var timeParameter;
        var date = new Date();
        timeParameter = FR.date2Str(date,'yyyy-MM')+'-01';
        var timeChartPane = {
            type: 'panel',
            width: 730,
            height: 245,
            renderEl:$('<div/>'),
            doSize: true,
            contentHtml:$('<iframe id="fs_visitor_manager_iframe" ' +
                'style="height:245px;width:730px;border:0px" ' +
                'src='+FR.servletURL +'?op=fr_server&cmd=sc_report_op_timemap&__showtoolbar__=false&chartTime='+timeParameter+
                '/>')
        };
        return  timeChartPane;
    },
    _createVisitorDetailInfoShowTable:function(){
        var visitorInfoShowTableConfig = {
            widgetName:'infoTable',
            renderEl:$('<div/>'),
            page: true,
            pageCount: 10,
            type:'quickgrid',
            columnsConfig : [{key : 'path',value : FR.i18nText("VisitTemplate"),width : 278},
                {key : 'opType',value : FR.i18nText("InDetail")+FR.i18nText("Form-Action"),width : 200},
                {key : 'times',value : FR.i18nText("VisitTimes"),width :242}],
            items : []
        };
        return visitorInfoShowTableConfig;
    },
    _createVisitorInfoShowTable:function(){
        var visitorInfoShowTableConfig = {
            widgetName:'detailTable',
            type:'quickgrid',
            page: true,
            pageCount: 10,
            columnsConfig : [{key : 'path',value : FR.i18nText("FS-System_Visit_Template"),width : 140},
                {key : 'logtime',value : FR.i18nText("FS-System_Visit_Time"),width : 150},
                {key : 'ip',value : FR.i18nText("FS-System_Visit_IP"),width : 130},
                {key : 'opType',value : FR.i18nText("Form-Action"),width : 100},
                {key : 'userrole',value : FR.i18nText("Role"),width : 100},
                {key : 'username',value : FR.i18nText("User"),width : 100}],
            items : []
        };
        return visitorInfoShowTableConfig;
    },
    getVisitorInfo:function(startTime,endTime){
        var self = this;
        var url = FR.servletURL + '?op=fs_manager&cmd=getVisitorInfo';
        var visitorInfoData = {
            startTime:startTime+' 00:00:00',      //ʼʱʱ
            endTime:endTime+' 23:59:59'          //ʱ24ʱ
        };
        FR.ajax({
            url: url,
            type: 'POST',
            data:visitorInfoData,
            async : false,
            complete : function(res, status) {
                if(status == "success") {
                    var config = FR.jsonDecode(res.responseText);
                    self.infos = config.infos;
                    self.statisticsInfos = config.statisticsInfos;
                    for(var i= 0,len=self.infos.length;i<len;i++){
                        var opType = parseInt(self.infos[i]['opType']);
                        self.infos[i]['opType'] = self.convertOpType(opType);
                    }
                    for(var i= 0,len=self.statisticsInfos.length;i<len;i++){
                        var opType = parseInt(self.statisticsInfos[i]['opType']);
                        self.statisticsInfos[i]['opType'] = self.convertOpType(opType);
                    }
                }
            }
        });
    },
    convertOpType:function(opType){
        var opName;
        switch(opType){
            case 0:
                opName = FR.i18nText("Pagination")+FR.i18nText("Privilege_View");
                break;
            case 1:
                opName =FR.i18nText("Privilege_View");
                break;
            case 2:
                opName = FR.i18nText("Face_Write")+FR.i18nText("Privilege_View");
                break;
            case 3:
                opName = FR.i18nText("Form")+FR.i18nText("Privilege_View");
                break;
            default :
                opName = FR.i18nText("Privilege_View");
        }
        return opName;
    },
    popOrRefreshData:function(){
        var visitorViewTable = this.sysmonitor.getWidgetByName('visitorViewModel');
        visitorViewTable.getWidgetByName('detailTable').refresh(this.infos);
        visitorViewTable.getWidgetByName('infoTable').refresh(this.statisticsInfos);
        var isShowDetail = this.sysmonitor.getWidgetByName('isShowDetail').getValue();
        if(isShowDetail === true){
            var visitorViewTable = this.sysmonitor.getWidgetByName('visitorViewModel');
            visitorViewTable.setRowVisible(5,true);
            visitorViewTable.setRowVisible(6,false);
            visitorViewTable.doLayout();
            return;
        }else{
            var visitorViewTable = this.sysmonitor.getWidgetByName('visitorViewModel');
            visitorViewTable.setRowVisible(5,false);
            visitorViewTable.setRowVisible(6,true);
            visitorViewTable.doLayout();
            return;
        }
    },
    getDateByFormat:function(str,index){    //indexΪbuttonҳλ
        var resStr;
        var strs = str.split('-');
        var year = parseInt(strs[0]);
        var month = parseInt(strs[1]);
        switch(index){
            case 0:     //һ
                resStr = (--year)+'-'+(month<10?'0':'')+month;
                break;
            case 1:  //һ
                if(month===1){
                    resStr =(--year)+'-'+'12';
                    break;
                }else{
                    resStr=year+'-'+(--month<10?'0':'')+month;     //ǸλҪ0
                    break;
                }
                break;
            case 2: //һ
                if(month===12){
                    resStr =(++year)+'-'+'01';
                    break;
                }else{
                    resStr=year+'-'+(++month<10?'0':'')+month;
                    break;
                }

            case 3:
                resStr = (++year)+'-'+(month<10?'0':'')+month;
                break;
        }
        return resStr;
    },
    /*************ϵͳ״̬*************/
    sysStateModule: function(){
        return {
            title:FR.i18nText('System_Status'),
            content: {
                type: 'accordion',
                items: [
                    {
                        menu: FR.i18nText('Server_Usage'),
                        content: {
                            type: 'tablepane',
                            colSize: [140, 540, 24],
                            vgap: 5,
                            rowSize: [21, 'auto'],
                            items: [
                                [
                                    {
                                        type: 'llabel',
                                        value: FR.i18nText("Current_Number_of_Users_Online"),
                                        levelStyle: 0,
                                        fontfamily: 'SimSun',
                                        fontsize: '14px',
                                        color: '#1483FF',
                                        fontweight: 'bold'
                                    },
                                    {
                                        type: 'llabel',
                                        value: '0',
                                        widgetName: 'CURUSERNUMBER',
                                        levelStyle: 0,
                                        fontfamily: 'SimSun',
                                        fontsize: '14px',
                                        color: '#1483FF',
                                        fontweight: 'bold'
                                    },
                                    {
                                        type: 'iconbutton',
                                        width: 24,
                                        height: 24,
                                        imgsrc: 'fs-sysmonitor-refresh',
                                        handler: function () {
                                            this.getWidgetByName('VISITINFOGRID').refresh();
                                        }
                                    }
                                ],
                                [
                                    null,
                                    {
                                        type: 'quickgrid',
                                        widgetName: 'VISITINFOGRID',
                                        page: true,
                                        pageCount: 15,
                                        async: {
                                            url: FR.servletURL + '?op=fs_set&cmd=sc_get_monitorinfo',
                                            type: 'POST'
                                        },
                                        columnsConfig: [
                                            {
                                                key: 'reportName',
                                                value: FR.i18nText("Visited_Report"),
                                                width: 200
                                            },{
                                                key: 'userIP',
                                                value: FR.i18nText("Visitor_IP"),
                                                width: 170
                                            },{
                                                key: 'userName',
                                                value: FR.i18nText("Visitor_User"),
                                                width: 160
                                            },{
                                                key: 'visitStartTime',
                                                value: FR.i18nText("Visit_Start_Time"),
                                                width: 160
                                            }
                                        ],
                                        onAsyncSuccess: function(res, status){
                                            var result = FR.jsonDecode(res);
                                            this.options.items = result.visitinfo;
                                            this.getWidgetByName('CURUSERNUMBER').setValue(result.userCount);
                                        }
                                    },
                                    null
                                ]
                            ]
                        }
                    },
                    {
                        menu: FR.i18nText('Memory_Usage'),
                        content: {
                            type: 'quickgrid',
                            marginLeft: 20,
                            marginRight: 20,
                            isHeadShow: false,
                            async: {
                                url: FR.servletURL +'?op=fr_server&cmd=sc_get_memoryinfo',
                                type: 'POST'
                            },
                            onAsyncSuccess: function(res, status){
                                var result = FR.jsonDecode(res);
                                this.options.items = [
                                    {
                                        key: FR.i18nText("Free_Memory"),
                                        value: result.freeMemory + 'MB'
                                    },{
                                        key: FR.i18nText("Total_Memory"),
                                        value: result.totalMemory + 'MB'
                                    },{
                                        key: FR.i18nText("Max_Memory"),
                                        value: result.maxMemory + 'MB'
                                    }
                                ];
                            },
                            columnsConfig: [
                                {
                                    key: 'key',
                                    value: 'key',
                                    width: 160,
                                    css: {'font-weight': 'bold'}
                                },
                                {
                                    key: 'value',
                                    value: 'value',
                                    width: 160
                                }
                            ]
                        }
                    },{
                        menu: FR.i18nText("Configuration_File_Detection"),
                        content: {
                            type:'quickgrid',
                            marginLeft: 20,
                            marginRight: 20,
                            isHeadShow: false,
                            async: {
                                url: FR.servletURL + '?op=fs_sysexam&cmd=configfile',
                                type: 'POST'
                            },
                            onAsyncSuccess: function(res, status){
                                var result = FR.jsonDecode(res);
                                this.options.items = [
                                    {
                                        key: FR.i18nText("Deploy_Type"),
                                        value: result.deploy_type
                                    },{
                                        key: FR.i18nText("Resource_Path_Is"),
                                        value: result.resource_path
                                    }
                                ];
                            },
                            columnsConfig: [
                                {
                                    key: 'key',
                                    value: 'key',
                                    width: 220,
                                    css: {'font-weight': 'bold'}
                                },
                                {
                                    key: 'value',
                                    value: 'value',
                                    width: 400
                                }
                            ]
                        }
                    },{
                        menu: FR.i18nText("ConnectionPool"),
                        content: {
                            type:'quickgrid',
                            marginLeft: 20,
                            marginRight: 20,
                            isHeadShow: false,
                            async: {
                                url: FR.servletURL + '?op=fs_set&cmd=sc_get_monitorinfo',
                                type: 'POST'
                            },
                            onAsyncSuccess: function(res, status){
                                var result = FR.jsonDecode(res);
                                var items = [];
                                for(var i = 0, len = result.poolinfo.length; i < len; i ++) {
                                    for(var item in result.poolinfo[i]){
                                        items.push({
                                            key: item,
                                            value: result.poolinfo[i][item]
                                        });
                                    }
                                }
                                this.options.items = items;
                            },
                            onAfterRowCreate: function($row, rowIdx, item){
                                if(rowIdx % 5 === 0 && rowIdx !== 0){
                                    $row.css({'border-top': '2px solid #1C8AD0'})
                                }
                            },
                            columnsConfig: [
                                {
                                    key: 'key',
                                    value: 'key',
                                    width: 220,
                                    css: {'font-weight': 'bold'}
                                },
                                {
                                    key: 'value',
                                    value: 'value',
                                    width: 400
                                }
                            ]
                        }
                    }
                ]
            }
        };
    },
    /*************ϵͳ*************/
    sysExamModule: function(){
        var  sysExamCfg = {
            title:FR.i18nText('Platform_Module_SysExam'),
            content:{
                type: 'accordion',
                items: [
                    {
                        menu: FR.i18nText("Server_Setting_Detection"),
                        content: {
                            type: 'quickgrid',
                            marginLeft: 20,
                            marginRight: 20,
                            async:{
                                url: FR.servletURL + '?op=fs_sysexam&cmd=server',
                                type: 'POST'
                            },
                            onAsyncSuccess: function(res, status){
                                var result = FR.jsonDecode(res);
                                this.options.items = [];
                                if(result.currentMemory) {
                                    this.options.items.push({
                                        problem : FR.i18nText("MemoryLow"),
                                        suggestion : FR.i18nText("ServerMaxMemoryIs")
                                            +result.currentMemory+'M' + FR.i18nText("NotLessThan") +result.idealMemory + 'M'
                                    });
                                }
                            },
                            columnsConfig: [
                                {
                                    key: 'problem',
                                    value: FR.i18nText("Problem"),
                                    width: 220
                                },{
                                    key: 'suggestion',
                                    value: FR.i18nText("Suggestion"),
                                    width: 400
                                },{
                                    key: 'refresh',
                                    value: '',
                                    width: 30,
                                    onHeadCellCreate: function(colIdx, itemcfg){
                                        var grid = this;
                                        var refreshBtn = new FR.IconButton({
                                            width: 24,
                                            height: 24,
                                            imgsrc: 'fs-sysmonitor-refresh',
                                            handler: function () {
                                                grid.refresh();
                                            }
                                        });
                                        return refreshBtn.element;
                                    }
                                }
                            ]
                        }
                    },{
                        menu: FR.i18nText("Report_Manager_Detection"),
                        content: {
                            type: 'quickgrid',
                            marginLeft: 20,
                            marginRight: 20,
                            async:{
                                url: FR.servletURL + '?op=fs_sysexam&cmd=report',
                                type: 'POST'
                            },
                            onAsyncSuccess: function(res, status){
                                var result = FR.jsonDecode(res);
                                var items = [];
                                $.each(result.unExistFiles, function(idx, item) {
                                    items.push({
                                        problem : result.workDirectory + '/' + item+ FR.i18nText("Not_Exist"),
                                        suggestion : FR.i18nText("SuggestionFSReport")
                                    });
                                });
                                this.options.items = items;
                            },
                            columnsConfig: [
                                {
                                    key: 'problem',
                                    value: FR.i18nText("Problem"),
                                    width: 220
                                },{
                                    key: 'suggestion',
                                    value: FR.i18nText("Suggestion"),
                                    width: 400
                                },{
                                    key: 'refresh',
                                    value: '',
                                    width: 30,
                                    onHeadCellCreate: function(colIdx, itemcfg){
                                        var grid = this;
                                        var refreshBtn = new FR.IconButton({
                                            width: 24,
                                            height: 24,
                                            imgsrc: 'fs-sysmonitor-refresh',
                                            handler: function () {
                                                grid.refresh();
                                            }
                                        });
                                        return refreshBtn.element;
                                    }
                                }
                            ]
                        }
                    },{
                        menu: FR.i18nText("Global_Properties_detection"),
                        content: {
                            type: 'quickgrid',
                            marginLeft: 20,
                            marginRight: 20,
                            async:{
                                url: FR.servletURL + '?op=fs_sysexam&cmd=globalattr',
                                type: 'POST'
                            },
                            onAsyncSuccess: function(res, status){
                                var result = FR.jsonDecode(res);
                                var items = [];
                                $.each(result, function(idx, item) {
                                    if(item !== false) {
                                        items.push({
                                            problem : item.cpt_name + FR.i18nText("NoGlobalStyle") + "\"" + item.style_name + '\"',
                                            suggestion : FR.i18nText("SuggestionAddName") + "\""+item.style_name+"\"" + FR.i18nText("SuggestionOfGlobalStyle")
                                        });
                                    } else {
                                        items.push({
                                            problem : item.cpt_name + FR.i18nText("HasError"),
                                            suggestion : FR.i18nText("ErrorWhenReadTemplate")
                                        });
                                    }
                                });
                                this.options.items = items;
                            },
                            columnsConfig: [
                                {
                                    key: 'problem',
                                    value: FR.i18nText("Problem"),
                                    width: 220
                                },{
                                    key: 'suggestion',
                                    value: FR.i18nText("Suggestion"),
                                    width: 400
                                },{
                                    key: 'refresh',
                                    value: '',
                                    width: 30,
                                    onHeadCellCreate: function(colIdx, itemcfg){
                                        var grid = this;
                                        var refreshBtn = new FR.IconButton({
                                            width: 24,
                                            height: 24,
                                            imgsrc: 'fs-sysmonitor-refresh',
                                            handler: function () {
                                                grid.refresh();
                                            }
                                        });
                                        return refreshBtn.element;
                                    }
                                }
                            ]
                        }
                    }
                ]
            }
        };
        return sysExamCfg
    }
};