/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: sean
 * Date: 13-10-19
 * Time: 1:38
 */
FS.SYSMGR = {
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_sysmgr.css', 'css');
        var self = this;
        this.initData();
        var items = [this.basicSetModule(),
            this.printSetModule(),
            this.mailSetModule(),
            this.cacheSetModule(),
            this.connSetModule()
        ];
        //ǹƽ̨Ա˺Ź͵¼ùģ
        if(FS.isPlatForm()){
            items.push(FS.adminPwdModule());
            items.push(this.loginMgrModule())
        }
        this.serverConfig = new FS.LTabPane({
            width: '100%',
            height: '100%',
            items: items,
            style: 'blue',
            renderEl: renderer,
            marginLeft: 40,
            initAfterActions : [
        		function() {
        	        self.popData(0, this);
        		},function () {
        			self.popData(1, this);
        		},function () {
        			self.popData(2, this);
        		},function () {
        			self.popData(3, this);
        		},FR.emptyFn(),
                function(){
                    self.popData(5, this);
                },function(){
                    self.popData(6, this);
                }

        	]
        });
    },
    
    setWidgetValue : function(widgetName, value) {
    	if(this.tabPane.getWidgetByName(widgetName)) {
        	this.tabPane.getWidgetByName(widgetName).setValue(value);	
    	}
    },
    
    getWidgetValue : function(widgetName) {
    	if(this.tabPane.getWidgetByName(widgetName)) {
        	return this.tabPane.getWidgetByName(widgetName).getValue();	
    	}
    },

    sendTestMail : function() {   
    	var self = this;
    	var testEmailTablelayout = {
                widgetName: 'testEmailTablelayout',
                type: 'tablelayout',
                items: [
					[
					 {el: $('<div/>')}
					],
                    [
                        {el: $('<div/>')},
                        {el: {type: 'llabel', value: FR.i18nText("FS-System_Email_Receiver") + ":", textalign: 'right'}},
                        {el: $('<div/>')},
                        {el: {type: 'text', widgetName: 'emailReceiver'}}
                    ]
                ],
                columnSize: [20, 100, 10, 230],
                rowSize: [30, 21],
                vgap: 20
            };
    	
    	var testEmailDialog = new FR.Dialog({
    		title : FR.i18nText("ReportServerP-Send_Test_Mail"),
            onOK : function() {
            	var toAddress = this.getWidgetByName('emailReceiver').getValue();
            	var serverName = self.serverConfig.getWidgetByName('host').getValue();
            	var userName = self.serverConfig.getWidgetByName('username').getValue();
            	var passWord = self.serverConfig.getWidgetByName('password').getValue();
            	var fromAddress = self.serverConfig.getWidgetByName('address').getValue();
            	var emailToAttr = {
        			serverName: serverName,
        			fromAddress: fromAddress,
        			userName: userName,
        			passWord: passWord,
        			toAddress: toAddress
        		};
                FR.showLoadingDialog({width : 310, height : 80, title : FR.i18nText("Email"), text : FR.i18nText("Sending")});
                FR.ajax({
                    url : '${servletURL}?op=fr_server&cmd=sc_test_mail',
                    type : 'POST',
                    data : {
                        type : 'POST',
                        __parameters__ : emailToAttr
                    },
                    complete : function(res, status) {
                        FR.hideLoadingDialog();
                        var result = FR.jsonDecode(res.responseText);
                        if(result.status == "success"){
                            FR.Msg.alert(FR.i18nText("HJS-Send_Successfully"),FR.i18nText("EmailHasSendTo") + toAddress);
                        }else{
                            FR.Msg.alert(FR.i18nText("HJS-Send_Failed"),FR.i18nText("EmailSendFailed") +"!\n"+ FR.i18nText("PleaseCheckEmailAttr"));
                        }
                    }
                });
            },		
            destroyOnClose: true,
            width: 400,
            height: 200,
            doSize: true,
            confirm: true,  
            contentWidget: testEmailTablelayout
    	}).setVisible(true);
    },

    /**************************/
    basicSetModule: function () {
        var self = this;
    	var charsetitems = [];
		for(var i = 0, len = this.data.encodingArray.length; i < len ; i ++) {
			charsetitems.push({
				value : this.data.encodingArray[i],
				text : this.data.encodingArray[i]
			})
		}
        var basicTablelayout = {
            widgetName: 'basicTablelayout',
            type: 'tablelayout',
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("ReportServerP-Reportlets_root_directory_name")}},
                    {el: {type: 'text', widgetName: 'reportlets', disabled: true}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("ReportServerP-Resources_root_directory_name")}},
                    {el: {type: 'text', widgetName: 'resources', disabled: true}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("ReportServerP-Server_character_encoding")}},
                    {el: {type: 'combo', widgetName: 'charset', items : charsetitems}}
                ],
                [
                    {el: {type: 'llabel',value: FR.i18nText("ServletMapping_name")}},
                    {el: {type: 'text', widgetName: 'servlet'}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("ReportServerP-Unlock_Gzip")}},
                    {el: {type: 'switch', widgetName: 'gzip'}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Sign_Dongle")}},
                    {el: {type: 'switch', widgetName: 'dongle'}}
                ]
            ],
            columnSize: [131, 122],
            rowSize: [21, 21, 21, 21, 25, 25],
            vgap: 20
        };
        var basicSetPanel = {
            title: FR.i18nText("FS-System_Basic_Description"),
            content: {
                widgetName: 'basicSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                text4OK:FR.i18nText("Save_With_Whitespace"),
                text4Cancel:null,
                width: 400,
                height: 300,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK : function() {
                	self.saveBasicData();
                },
                contentWidget: basicTablelayout
            }
        };
        return basicSetPanel;
    },

    /*************ӡ*************/
    printSetModule: function () {
    	var self = this;
    	var pintlistitems = [];
		for(var i = 0, len = this.data.serverPrinterList.length; i < len ; i ++) {
			pintlistitems.push({
				value : this.data.serverPrinterList[i],
				text : this.data.serverPrinterList[i]
			})
		}
		//wei : ΪӦtablelayout֣ҪһdivŽȥȻ졣tabpaneȡ
		//ؼˣԵһ
		this.printerCombo = FR.createWidget({type: 'combocheckbox', supportTag:false, widgetName: 'printer', width: 122, height: 21, items : pintlistitems});
        var printTablelayout = {
            widgetName: 'printTablelayout',
            type: 'tablelayout',
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("Activated_Printer")}},
                    {el: $('<div/>').append(this.printerCombo.element)}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Flash_Print")}},
                    {el: {type: 'checkbox', marginleft: 0,widgetName: 'flash_page', text: FR.i18nText("FlashP-Need_Page_Selection")}}
                ],
                [
                    {el: $('<div/>')},
                    {el: {type: 'checkbox', marginleft: 0,widgetName: 'flash_setting', text: FR.i18nText("FlashP-Need_Settings"), selected: true, disabled: true}}
                ],
                [
                    {el: $('<div/>')},
                    {el: {type: 'checkbox', marginleft: 0,widgetName: 'flash_size', text: FR.i18nText("FlashP-Default_Size")}}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("PDF_Print")}},
                    {el: {type: 'checkbox', marginleft: 0,widgetName: 'pdf_page', text: FR.i18nText("PDFP-Need_Settings")}}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Applet_Print")}},
                    {el: {type: 'checkbox', marginleft: 0,widgetName: 'applet_page', text: FR.i18nText("AppletP-Need_Settings")}}
                ]
            ],
            columnSize: [131, 'fill'],
            rowSize: [21, 0, 16, 16, 16,0, 16,0, 16],
            vgap: 10
        };
        var printSetPanel = {
            title: FR.i18nText("Print"),
            content: {
                widgetName: 'printSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                text4OK:FR.i18nText("Save_With_Whitespace"),
                text4Cancel:null,
                width: 500,
                height: 256,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK : function() {
                	self.savePrintData();
                },
                contentWidget: printTablelayout
            }
        };
        return printSetPanel;
    },

    /*************ʼ*************/
    mailSetModule: function () {
    	var self = this;
        var senderLLabel = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("Mail-Sender_Account")
        };
        var host_items = [{value: "SMTP.gmail.com", text: "SMTP.gmail.com"},{value: "SMTP.sina.com",text: "SMTP.sina.com"}, 
        				{value: "SMTP.163.com",text: "SMTP.163.com"},{value: "SMTP.qq.com",text: "SMTP.qq.com"}, 
        				{value: "SMTP.sohu.com",text: "SMTP.sohu.com"}, {value: "SMTP.live.com",text: "SMTP.live.com"},
        				{value: "SMTP.mail.yahoo.com", text: "SMTP.mail.yahoo.com"}, {value: "SMTP.netease.com",text: "SMTP.netease.com"}, 
        				{value: "SMTP.sina.com.cn",text: "SMTP.sina.com.cn"},{value: "SMTP.263.net",text: "SMTP.263.net"},
        				{value: "SMTP.126.com",text: "SMTP.126.com"}];
        var senderTablelayout = {
            widgetName: 'senderTablelayout',
            type: 'tablelayout',
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("ReportServerP-Mail_Host(SMTP)")}},
                    {el: {type: 'combo', widgetName: 'host', directEdit: true, items: host_items}}, null
                ],
                [
                	{el: {type: 'llabel', value: FR.i18nText("Sender_Address")}},
                    {el: {type: 'text', widgetName: 'address', listeners: [
                    {	eventName: 'afteredit',
                		action: function(){
                			var showFullName = this.getWidgetByName('username');
                			var mail_address = this.getValue();
                			if (mail_address){
                				var namePosition = mail_address.indexOf("@");
                				var mail_fullname = namePosition === -1 ? mail_address : mail_address.substring(0, namePosition) ;
                				showFullName.setValue(mail_fullname);
                			}
                		}
                	}
                    ]}}, null
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Password")}},
                    {el: {type: 'text', widgetName: 'password', passwordText: true}}, null
                ],
                [
                   	{el: {type: 'llabel', value: FR.i18nText("FS-System_Email_Show_Full_Name")}},
	                {el: {type: 'text', widgetName: 'username'}},
	                {el: {
	                    type: 'iconbutton',
	                    text: FR.i18nText("ReportServerP-Send_Test_Mail"),
	                    baseClass: 'fs-servercfg-test',
	                    handler : function() {
	                        self.sendTestMail();
	                    }
	                }}
                ]
            ],
            columnSize: [131, 122, 120],
            rowSize: [21, 21, 21, 21],
            vgap: 20
        };
        var mailSetPanel = {
            title: FR.i18nText("Email"),
            content: {
                widgetName: 'mailSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                width: 750,
                height: 260,
                text4OK: FR.i18nText("Save_With_Whitespace"),
                text4Cancel:null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK : function() {
                	self.saveEmailData();
                },
                contentWidget: {
                    type: 'tablelayout',
                    columnSize: ['fill'],
                    rowSize: [25, 195],
                    vgap: 10,
                    items: [
                        [
                            {el: senderLLabel}
                        ],
                        [
                            {el: senderTablelayout}
                        ]
                    ]
                }
            }
        };
        return mailSetPanel;
    },

    /**************************/
    cacheSetModule: function () {
    	var self = this;
        var datasetShare = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("Cache-Dataset_Share")
        };
        var cptCache = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("FS-System_Cache_Template_Settings")
        };
        var dsShareTablelayout = {
            type: 'tablelayout',
            columnSize: [131, 122, 8, 'fill'],
            rowSize: [21, 15, 78, 15, 21, 20 , 21],
            vgap: 0,
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("Cache-Maximum_Number_Of_Shared_Datasets")}},
                    {el: {type: 'text', widgetName: 'maximum'}}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', verticalcenter: false,lineheight: 26, value: FR.i18nText("Cache-Cache_Principle")}},
                    {el: {type: 'radiogroup',
                        items: [
                            {text: FR.i18nText("MSEP-Least-Recently-Used"), value : 'LRU'},
                            {text: FR.i18nText("MSEP-Least-Frequently-Used"), value : 'LFU'},
                            {text: FR.i18nText("MSEP-First-In-First-Out"), value : 'FIFO'}
                        ],
                        columnsInRow: 1,
                        adaptive: true,
                        widgetName: 'principle' }}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Cache-TimeToIdleSeconds")}},
                    {el: {type: 'text', widgetName: 'idle'}},
                    {el: $('<div/>')},
                    {el: {type: 'llabel', value: FR.i18nText("Sche-Second")}}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Cache-TimeToLiveSeconds")}},
                    {el: {type: 'text', widgetName: 'live'}},
                    {el: $('<div/>')},
                    {el: {type: 'llabel', value: FR.i18nText("Sche-Second")}}
                ]
            ]
        };
        var cptCacheTablelayout = {
            type: 'tablelayout',
            columnSize: [131, 122],
            rowSize: [25],
            vgap: 20,
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-System_Cache_Reload_Template_Policy")}},
                    {el: {type: 'switch', widgetName: 'reload'}}
                ]
            ]
        };
        var cacheSetPanel = {
            title: FR.i18nText("M-Cache"),
            content: {
                widgetName: 'cacheSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                width: 750,
                height: 393,
                text4OK:FR.i18nText("Save_With_Whitespace"),
                text4Cancel:null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK: function() {
                	self.saveCacheData();
                },
                contentWidget: {
                    type: 'tablelayout',
                    columnSize: ['fill'],
                    rowSize: [25, 213, 25, 25],
                    vgap: 10,
                    items: [
                        [
                            {el: datasetShare}
                        ],
                        [
                            {el: dsShareTablelayout}
                        ],
                        [
                            {el: cptCache}
                        ],
                        [
                            {el: cptCacheTablelayout}
                        ]
                    ]
                }
            }
        };
        return cacheSetPanel;
    },
    /**************************/
    connSetModule: function(){
        var self = this, items = [];
        var connParas = {};
        var connNames = [];
        var connSize = 0;
        FR.ajax({
            url: FR.servletURL+"?op=fs_set&cmd=sc_getconnectioninfo",
            type: 'POST',
            async: false,
            complete: function(res, status){
                if(status == 'success' && !FR.isEmpty(res.responseText)){
                    var result = FR.jsonDecode(res.responseText);
                    connSize = result.length
                    for(var i= 0; i< connSize ;i++){
                        var conn = result[i];
                        connNames.push(conn.name);
                        items.push({
                            menu: FR.i18nText("DashBoard-ConnectionList")+(i+1)+": "+conn.name,
                            content: {
                                type: 'tablepane',
                                colSize: [130, 380],
                                rowSize: [21, 21, 21, 21],
                                vgap: 8,
                                hgap: 0,
                                items: [
                                    [
                                        {type: 'llabel', value: FR.i18nText("Driver")},
                                        {type: 'text', widgetName: 'DRIVER'+i, value: conn.driver}
                                    ],[
                                        {type: 'llabel', value: 'url'},
                                        {type: 'text', widgetName: 'URL'+i, value: conn.url}
                                    ],[
                                        {type: 'llabel', value: FR.i18nText("Username")},
                                        {type: 'text', widgetName: 'USERNAME'+i, value: conn.user, width: 190}
                                    ],[
                                        {type: 'llabel', value: FR.i18nText("Password")},
                                        {type: 'text', widgetName: 'PASSWORD'+i, passwordText: true, value: conn.password, width: 190}
                                    ]
                                ]
                            }
                        });
                    }
                }
            }
        });
        var connSetPanel = {
            title: FR.i18nText("FS-System_Connection_Description"),
            content: {
                widgetName: 'CONNSETPANE',
                type: 'tablepane',
                colSize: [80, 750],
                rowSize: ['auto', 30],
                vgap: 25,
                items: [
                    [
                        null,
                        {
                            type: 'accordion',
                            items: items
                        }
                    ],[
                        {
                            type: 'quickbutton',
                            style: 'blue',
                            text: FR.i18nText("Save_With_Whitespace"),
                            handler: function() {
                                for(var i = 0;i<connSize;i++){
                                    connParas[connNames[i]] = {
                                        driver: this.getWidgetByName('DRIVER'+i).getValue(),
                                        url: this.getWidgetByName('URL'+i).getValue(),
                                        user: this.getWidgetByName('USERNAME'+i).getValue(),
                                        password: this.getWidgetByName('PASSWORD'+i).getValue()
                                    }
                                }
                                FR.ajax({
                                    url : '${servletURL}?op=fs_set&cmd=sc_connection_attrset',
                                    type : 'POST',
                                    data : {
                                        __parameters__ : connParas,
                                        changedConName : connNames
                                    },
                                    complete : function(res, status) {
                                        var conAttrStatus = res.responseText;
                                        if (conAttrStatus == -1) {
                                            FR.Msg.toast(FR.i18nText("Event-submitfailure"));
                                        } else if(conAttrStatus=="success"){
                                            FR.Msg.toast(FR.i18nText("Event-submitsuccess"));
                                        }else{
                                            FR.Msg.toast(FR.i18nText("Event-submitfailure"));
                                        }
                                    }
                                });
                            }
                        },
                        null
                    ]
                ]
            }
        };
        return connSetPanel;
    },
    /****************** ݲ *******************/
    initData : function() {
    	var self = this;
    	FR.ajax({
			url: FR.servletURL + '?op=fr_server&cmd=sc_get_configinfo',
			type: 'POST',
			async : false,
			complete : function(res, status) {
				self.data = FR.jsonDecode(res.responseText);
			}
		});
    },
    
    popData : function(index, pane) {
    	this.tabPane = pane;
    	if(index === 0) {
			this._popBasicSetData();
		} else if(index === 1) {
			this._popPrintSetData();
		} else if(index === 2) {
			this._popEmailData();
		} else if(index === 3) {
			this._popCacheData();
        } else if(index === 5){
            this._popAdminData();
		} else if(index === 6) {
            this._popURLData();
        }
    },
    
    _popBasicSetData : function() {
    	var basicAttr = this.data;
    	this.setWidgetValue("reportlets", basicAttr.reportletsName);
    	this.setWidgetValue("resources", basicAttr.resourcesName);
    	this.setWidgetValue("charset", basicAttr.serverCharSet);
    	this.setWidgetValue("servlet", basicAttr.serverletMapping);
    	this.setWidgetValue("gzip", basicAttr.isSupportGzip);
    	this.setWidgetValue("dongle", basicAttr.isLicUseLock);
    },
    
    _popPrintSetData : function() {
    	var basicAttr = this.data;
    	this.printerCombo.setValue(basicAttr.serverActivePrinterList);
    	
    	this.setWidgetValue("flash_page", basicAttr.isPopupFlashPrintSetting);
    	this.setWidgetValue("flash_size", basicAttr.isFitPaper);
    	this.setWidgetValue("pdf_page", basicAttr.isPopupPdfPrintSetting);
    	this.setWidgetValue("applet_page", basicAttr.isPopupAppletPrintSetting);
    },
    
    _popEmailData : function() {
    	var basicAttr = this.data;
    	this.setWidgetValue("host", basicAttr.serverName);
    	this.setWidgetValue("username", basicAttr.userName);
    	this.setWidgetValue("password", basicAttr.passWord);
    	this.setWidgetValue("address", basicAttr.fromAddress);
    },
    
    _popCacheData : function() {
    	var basicAttr = this.data;
    	this.setWidgetValue("maximum", basicAttr.maxElementsInMemory);
    	this.setWidgetValue("principle", basicAttr.memoryStoreEvictionPolicy);
    	this.setWidgetValue("idle", basicAttr.timeToIdleSeconds);
    	this.setWidgetValue("live", basicAttr.timeToLiveSeconds);
    	this.setWidgetValue("reload", basicAttr.alwaysReloadTpl);
    	
    },

    _popAdminData: function(){
        var sc = this.serverConfig;
        FR.ajax({
            url: FR.servletURL + "?op=fs_main&cmd=user_getinfo",
            complete: function (res, status) {
                if (status == 'success') {
                    var user = FR.jsonDecode(res.responseText);
                    sc.getWidgetByName("fullnameText").setValue(user.realname);
                    sc.getWidgetByName("emailText").setValue(user.email);
                    sc.getWidgetByName("MobilePhoneText").setValue(user.mobile);
                }
            }
        });
    },

    _popURLData: function(){
        var sc = this.serverConfig;
        FR.ajax({
            url: FR.servletURL+"?op=fr_p_e&cmd=pe_login_option_get",
            complete: function(res, status){
                if(status == 'success'){
                    var re = FR.jsonDecode(res.responseText);
                    if(re.useEmb){
                        sc.getWidgetByName("USEEMBSWITCH").setValue(false, true);
                    }else{
                        sc.getWidgetByName("USEEMBSWITCH").setValue(true, true);
                        sc.getWidgetByName("CUSTOMURLTEXT").setValue(re.customUrl);
                    }
                }
            }
        });
    },
    /*************  ***********/
    saveBasicData : function() {
    	var basicData = {
    		serverCharSet : this.getWidgetValue("charset"),
    		serverletMapping : this.getWidgetValue("servlet"),
    	    isSupportGzip : this.getWidgetValue("gzip"),
    	    isLicUseLock : this.getWidgetValue("dongle")
    	};
    	FR.ajax({
			url: FR.servletURL + '?op=fr_server&cmd=sc_basic_set',
			type: 'POST',
			data: basicData,
			complete : function(res, status) {
				if (status === 'success') {
					FR.Msg.toast(FR.i18nText("Successfully"));
				} 
			}
		});
    },
    
    savePrintData : function() {
    	var printData = {
    		serverActivePrinterList	:this.printerCombo.getValue(),
    		isPopupFlashPrintSetting : this.getWidgetValue("flash_page"),
    		isFitPaper : this.getWidgetValue("flash_size"),
    		isPopupPdfPrintSetting : this.getWidgetValue("pdf_page"),
    		isPopupAppletPrintSetting : this.getWidgetValue("applet_page")
    	};
    	FR.ajax({
			url: FR.servletURL + '?op=fr_server&cmd=sc_print_set',
			type: 'POST',
			data: printData,
			complete : function(res, status) {
				if (status === 'success') {
					FR.Msg.toast(FR.i18nText("Successfully"));
				} 
			}
		});
    },
    
    saveEmailData : function() {
    	var emailData = {
        		host : this.getWidgetValue("host"),
        		username : this.getWidgetValue("username"),
        		password : this.getWidgetValue("password"),
        		address : this.getWidgetValue("address")
        		
        	};
        	FR.ajax({
    			url: FR.servletURL + '?op=fr_server&cmd=sc_email_set',
    			type: 'POST',
    			data: emailData,
    			complete : function(res, status) {
    				if (status === 'success') {
    					FR.Msg.toast(FR.i18nText("Successfully"));
    				} 
    			}
    		});
    },
    
    saveCacheData : function() {
    	var cacheData = {
			maximum : this.getWidgetValue("maximum"),
			principle : this.getWidgetValue("principle"),
			idle : this.getWidgetValue("idle"),
			live : this.getWidgetValue("live"),
			reload : this.getWidgetValue("reload")
    	};
    	FR.ajax({
			url: FR.servletURL + '?op=fr_server&cmd=sc_cache_set',
			type: 'POST',
			data: cacheData,
			complete : function(res, status) {
				if (status === 'success') {
					FR.Msg.toast(FR.i18nText("Successfully"));
				} 
			}
		});
    },
    /*************¼*************/
    loginMgrModule: function(){
        var self = this;
        var loginMgrPane = {
            title: FR.i18nText("Login_Setting"),
            content: {
                widgetName: 'LOGINSETPANE',
                type: 'confirm',
                firstBtnMargin: 0,
                width: 500,
                height: 120,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                text4OK: FR.i18nText("Save_With_Whitespace"),
                text4Cancel: null,
                onOK: function(){
                    FR.ajax({
                        url: FR.servletURL+"?op=fr_p_e&cmd=pe_login_option_save",
                        data:{
                            useEmb: !this.getWidgetByName("USEEMBSWITCH").getValue(),
                            customUrl: this.getWidgetByName("CUSTOMURLTEXT").getValue()
                        },
                        complete: function(res, status){
                            if(status == 'success'){
                                var re = FR.jsonDecode(res.responseText);
                                if(re.success){
                                    FR.Msg.toast(FR.i18nText("Successfully"));
                                }else{
                                    FR.Msg.toast(FR.i18nText("Failed"));
                                }
                            }
                        }
                    });
                },
                contentWidget: {
                    type: 'tablelayout',
                    widgetName: 'LOGINMGRTABLE',
                    columnSize: [130, 310],
                    rowSize: [25, 21],
                    vgap: 15,
                    items: [
                        [
                            {el: {type: 'llabel', value: FR.i18nText("Custom_Login_Page")}},
                            {el:{
                                type: 'switch',
                                widgetName:'USEEMBSWITCH',
                                onTurnOn: function(){
                                    self.serverConfig.getWidgetByName("LOGINMGRTABLE").setRowVisible(1, true);
                                },
                                onTurnOff: function(){
                                    self.serverConfig.getWidgetByName("LOGINMGRTABLE").setRowVisible(1, false);
                                }
                            }}
                        ],
                        [
                            null,
                            {el: {
                                type: 'text',
                                widgetName: 'CUSTOMURLTEXT',
                                watermark: FR.i18nText("Enter_Login_Page_URL")
                            }}
                        ]
                    ]
                }
            }
        };
        return loginMgrPane;
    }
}