/**
 * Coder: Sean
 * Date: 13-10-29
 * Time: 2:31
 */
FS.REPORTMGR = {
    CONSTS: {
        //ӦEntryConstants.java
        FOLDER: '0',
        FILE: '1',
        REPORTLET: '2',
        URL: '3',
        ANALYSIS: '4',
        PROCESS: '5',
        FASTQUERY: '6',
        BIREPORT: '7',
        REPORTPROCESS: '8',
        PROCESSTYPE:{
            1: FR.i18nText("RP_TaskMgr"),
            2: FR.i18nText("RP_ProcessMgr"),
            3: FR.i18nText("RP_MyTask")
        }
    },
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_reportmgr.css', 'css');
		FR.$defaultImport('/com/fr/web/core/js/ui/jquery.ui.sortable.js', 'js');
        var self = this;
        //Ŀ¼
        var dirMgrPane = {
            type: 'panel',
            doSize: true,
            y: 25,
            x: 30,
            width: 236,
            height: 450,
            title: FR.i18nText("Directory_Management"),
            border: true,
            contentHtml: $('<div/>').addClass('fs_reportmgr_dir_panel_content'),
            tools: [
                {
                    //Ŀ¼ť¼
                    iconCls: 'fs-module-add-white',
                    width: 24,
                    height: 24,
                    handler: function () {
                        	if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0]) {
	                            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("DoSelectDir"));
	                            return;
	                        }
                            $(this).removeClass('fs_reportmgr_add_icon_white_click');
                            var title = FR.i18nText("Add_Directory");
                            var onOK = function () {
                                var dirname = addDirDialog.getWidgetByName("nameText").getValue();
                                var description = addDirDialog.getWidgetByName("descriptionText").getValue();
                                if (!self.DIR._checkValid(dirname, true)) {
                                    return;
                                }
                                self.DIR._addFolder(dirname, description);
                            };
                            var onCancel = function () {
                            };
                            var data = null;
                            var addDirDialog = self.createDirDialog(title, onOK, onCancel, data);
                            addDirDialog.setVisible(true);
                    }
                }
            ]
        };
        var tools = [
            {
                //ģICON¼
                iconCls: 'fs_reportmgr_cpt_icon',
                width: 21,
                height: 21,
                hover:[function(){
                    $(this).addClass('fs_reportmgr_cpt_icon_hover');
                },function(){
                    $(this).removeClass('fs_reportmgr_cpt_icon_hover');
                }],
                handler: {
                    mousedown: function () {
                        $(this).addClass('fs_reportmgr_cpt_icon_click');
                    },
                    mouseleave: function () {
                        $(this).removeClass('fs_reportmgr_cpt_icon_hover');
                        $(this).removeClass('fs_reportmgr_cpt_icon_click');
                    },
                    mouseup: function () {
                        $(this).removeClass('fs_reportmgr_cpt_icon_click');
                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
                            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NoDirSelected"));
                            return;
                        }

                        var title = FR.i18nText("Add_Cpt");
                        var onOK = function () {
                            return self.DIR._addOrEditCpt();
                        };
                        var onCancel = function () {
                        };
                        var data = null; //༭dialogĳʼ
                        self.cptDialog = self.createCptDialog(title, onOK, onCancel, data);
                        self.cptDialog.setVisible(true);
                    }
                }
            },
            {
                //ICON¼
                iconCls: 'fs_reportmgr_link_icon',
                width: 21,
                height: 21,
                hover:[function(){
                    $(this).addClass('fs_reportmgr_link_icon_hover');
                },function(){
                    $(this).removeClass('fs_reportmgr_link_icon_hover');
                }],
                handler: {
                    mousedown: function () {
                        $(this).addClass('fs_reportmgr_link_icon_click');
                    },
                    mouseleave: function () {
                        $(this).removeClass('fs_reportmgr_link_icon_hover');
                        $(this).removeClass('fs_reportmgr_link_icon_click');
                    },
                    mouseup: function () {
                        $(this).removeClass('fs_reportmgr_link_icon_click');
                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
                            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NoDirSelected"));
                            return;
                        }
                        var title = FR.i18nText("Add_Link");
                        var onOK = function () {
                            return self.DIR._addOrEditLink();
                        };
                        var onCancel = function () {
                        };
                        var data = null; //༭dialogĳʼ
                        self.linkDialog = self.createLinkDialog(title, onOK, onCancel, data);
                        self.linkDialog.setVisible(true);
                    }
                }
            }
        ];
        var addToolIconByPlate = function(tools) {
        	//ݷ BS
        	if(FS.config.hasAnalysis === "true") {
        		var addAnalysisIcon = {
	                //ݷICON¼
	                iconCls: 'fs_reportmgr_analy_icon',
	                width: 21,
	                height: 21,
	                hover:[function(){
	                    $(this).addClass('fs_reportmgr_analy_icon_hover');
	                },function(){
	                    $(this).removeClass('fs_reportmgr_analy_icon_hover');
	                }],
	                handler: {
	                    mousedown: function () {
	                        $(this).addClass('fs_reportmgr_analy_icon_click');
	                    },
	                    mouseleave: function () {
	                        $(this).removeClass('fs_reportmgr_analy_icon_hover');
	                        $(this).removeClass('fs_reportmgr_analy_icon_click');
	                    },
	                    mouseup: function () {
	                        $(this).removeClass('fs_reportmgr_analy_icon_click');
	                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
	                            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NoDirSelected"));
	                            return;
	                        }
	                        var title = FR.i18nText("Add_Analysis");
	                        var onOK = function () {
	                            return self.DIR._addOrEditAnalysis();
	                        };
	                        var onCancel = function () {
	                        };
	                        var data = null; //༭dialogĳʼ
	                        self.analysisDialog = self.createAnalysisDialog(title, onOK, onCancel, data);
	                        self.analysisDialog.setVisible(true);
	                    }
	                }
	            };
	            tools.push(addAnalysisIcon);
        	}
        	//ϱ since 706
	        if(FS.config.hasReportProcess == "true"){
	            //ϱICON¼
	            var addRPBtn = {
	                iconCls: 'fs_reportmgr_rp_icon',
	                width: 21,
	                height: 21,
	                hover: [function () {
	                    $(this).addClass('fs_reportmgr_rp_icon_hover');
	                }, function () {
	                    $(this).removeClass('fs_reportmgr_rp_icon_hover');
	                }],
	                handler: {
	                    mousedown: function () {
	                        $(this).addClass('fs_reportmgr_rp_icon_click');
	                    },
	                    mouseleave: function () {
	                        $(this).removeClass('fs_reportmgr_rp_icon_hover');
	                        $(this).removeClass('fs_reportmgr_rp_icon_click');
	                    },
	                    mouseup: function () {
	                        $(this).removeClass('fs_reportmgr_rp_icon_click');
	                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
	                            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NoDirSelected"));
	                            return;
	                        }
	                        var title = FR.i18nText("RP_AddLabel");
	                        var onOK = function () {
	                            return self.DIR._addOrEditRP();
	                        };
	                        var onCancel = function () {
	                        };
	                        var data = null; //༭dialogĳʼ
	                        self.rpDialog = self.createRPDialog(title, onOK, onCancel, data);
	                        self.rpDialog.setVisible(true);
	                    }
	                }
	            };
	            tools.push(addRPBtn);
	        }
	        if(FS.config.hasbi === "true") {
	        	var addbibtn = {
	        		//BIICON¼
	                iconCls: 'fs_reportmgr_analy_icon',
	                width: 21,
	                height: 21,
	                hover:[function(){
	                    $(this).addClass('fs_reportmgr_analy_icon_hover');
	                },function(){
	                    $(this).removeClass('fs_reportmgr_analy_icon_hover');
	                }],
	                handler: {
	                    mousedown: function () {
	                        $(this).addClass('fs_reportmgr_analy_icon_click');
	                    },
	                    mouseleave: function () {
	                        $(this).removeClass('fs_reportmgr_analy_icon_hover');
	                        $(this).removeClass('fs_reportmgr_analy_icon_click');
	                    },
	                    mouseup: function () {
	                        $(this).removeClass('fs_reportmgr_analy_icon_click');
	                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
	                            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NoDirSelected"));
	                            return;
	                        }
	                        var title = FR.i18nText("Add_BI");
	                        var onOK = function () {
	                            return self.DIR._addOrEditBI();
	                        };
	                        var onCancel = function () {
	                        };
	                        var data = null; //༭dialogĳʼ
	                        self.biDialog = self.createBIDialog(title, onOK, onCancel, data);
	                        self.biDialog.setVisible(true);
	                    }
	                }
	        	};
	        	tools.push(addbibtn);
	        }
        };
        addToolIconByPlate(tools);
        //
        var cptMgrPane = {
            type: 'panel',
            widgetName:'cptMgrPane',
            doSize: true,
            border: true,
            title: FR.i18nText("Platform_Module_ReportManager"),
            x: 291,
            y: 25,
            width: 602,
            height: 450,
            tools: tools,
            contentHtml: self.cptMgrInit()
        };
        self.reportMgr = FR.createWidget({
            type: 'absolute',
            scrollable: true,
            width: '100%',
            height: '100%',
            top: 15,
            left: 20,
            renderEl: renderer,
            items: [dirMgrPane, cptMgrPane]
        });
        self.dirMgrInit();
        self.reportMgr.doLayout();
        $('.fs_reportmgr_cpt_icon').attr('title',FR.i18nText("Add_Cpt"));
        $('.fs_reportmgr_link_icon').attr('title',FR.i18nText("Add_Link"));
        $('.fs_reportmgr_analy_icon').attr('title',FR.i18nText("Add_Analysis"));
        $('.fs_reportmgr_rp_icon').attr('title',FR.i18nText("RP_AddLabel"));
        self.reportMgr.getWidgetByName("cptMgrPane").panelBody.css('overflow','auto');
    },

    DIR: {
        //File
    	_editFile : function(id, sortindex) {
    		if(!this._isFileValid()) {
    			return false;
    		}
    		var file = this._getFileDialogValue(id);
    		if(!file) {
    			return false;
    		}
            if(sortindex) {
                file.sortindex = sortindex;
            }
    		FR.get(
				FR.servletURL,
				{
					type : 'POST',
					op: "fr_schedule",
					cmd : "se_setfilename",
					setScheduleFileName: file
				},
				function callback(jason){
					 var item = FR.jsonDecode(jason);
                    //DOM
                    var tName = 'file';
                    var catalogWidths = [156, 340];
                    var data = [item.text, item.path, item.id];
                    var originaldata = item;
                    if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                        $('.fs_reportmgr_table_' + tName).show();
                    }
                    FS.REPORTMGR.addTableData(tName, catalogWidths, -1, data, originaldata);
                    FS.Cache.updateCache();
                    if(!FS.config.hasnavigation) {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
				}//callback
			);
    	},
    	
    	_isFileValid : function() {
    		var name = FS.REPORTMGR.fileDialog.getWidgetByName("nameText").getValue();
            if (!name) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Enter_File_Name"));
                return false;
            }
            return true;
    	},
    	
    	_getFileDialogValue : function(id) {
    		var name = FS.REPORTMGR.fileDialog.getWidgetByName("nameText").getValue();
            var path = FS.REPORTMGR.fileDialog.getWidgetByName("fileposition").getValue();
            var description = FS.REPORTMGR.fileDialog.getWidgetByName("descriptionText").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);

            var file = {parentId: pd, description: description, path: path, text: name};
            if (id != null && id != undefined) {
                file.id = id;
            }
            return file;
    	},

        //Analysis
    	_addOrEditAnalysis : function(id, sortindex) {
    		if(!this._isAnalysisValid()) {
    			return false;
    		}
    		var analysis = this._getAnalysisDialogValue(id);
    		if(!analysis) {
    			return false;
    		}
            if(sortindex) {
                analysis.sortindex = sortindex;
            }
    		FR.get(
				FR.servletURL,
				{
					type : 'POST',
					op: "fs_entry",
					cmd : "addanaly",
					adJason: analysis
				},
				function callback(jason){
                    if(jason == "-1") {
                        //ûȨ
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                        return ;
                    }
					 var item = FR.jsonDecode(jason);
                    //DOM
                    var tName = 'analy';
                    var catalogWidths = [156, 340];
                    var hyperLinkIndex = 1;
                    var data = [item.text, item.tdname, item.id];
                    var originaldata = item;
                    if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                        $('.fs_reportmgr_table_' + tName).show();
                    }
                    FS.REPORTMGR.addTableData(tName, catalogWidths, hyperLinkIndex, data, originaldata);
                    FS.Cache.updateCache();
                    if(!FS.config.hasnavigation) {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
				}//callback
			);
    	},
    	
    	_isAnalysisValid : function() {
    		var name = FS.REPORTMGR.analysisDialog.getWidgetByName("nameText").getValue();
            var tdname = FS.REPORTMGR.analysisDialog.getWidgetByName("analysisdata").getValue();
            if (!tdname) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Choose_AnalysisData"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Enter_Analysis_Name"));
                return false;
            }
            return true;
    	},
    	
    	_getAnalysisDialogValue : function(id) {
    		var name = FS.REPORTMGR.analysisDialog.getWidgetByName("nameText").getValue();
            var tdname = FS.REPORTMGR.analysisDialog.getWidgetByName("analysisdata").getValue();
            var description = FS.REPORTMGR.analysisDialog.getWidgetByName("descriptionText").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);

            var analysis = {parentId: pd, description: description, tdname: tdname, text: name};
            if (id != null && id != undefined) {
                analysis.id = id;
            }
            return analysis;
    	},

        //BI
    	_addOrEditBI : function(id, sortindex) {
    		if(!this._isBIValid()) {
    			return false;
    		}
    		var bi = this._getBIDialogValue(id);
    		if(!bi) {
    			return false;
    		}
            if(sortindex) {
                bi.sortindex = sortindex;
            }
    		FR.get(
				FR.servletURL,
				{
					type : 'POST',
					op: "fs_entry",
					cmd : "addbireport",
					report: bi
				},
				function callback(jason){
					 var item = FR.jsonDecode(jason);
                    //DOM
                    var tName = 'bi';
                    var catalogWidths = [156, 300];
                    var hyperLinkIndex = 1;
                    var data = [item.text, 
                    {
                    	reportName:item.reportName,
                    	reportId:item.reportId
                    }, item.id];
                    var originaldata = item;
                    if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                        $('.fs_reportmgr_table_' + tName).show();
                    }
                    FS.REPORTMGR.addTableData(tName, catalogWidths, hyperLinkIndex, data, originaldata);
                    FS.Cache.updateCache();
                    if(!FS.config.hasnavigation) {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
				}//callback
			);
    	},
    	
    	_isBIValid : function() {
    		var name = FS.REPORTMGR.biDialog.getWidgetByName("nameText").getValue();
            var tdname = FS.REPORTMGR.biDialog.getWidgetByName("bidata").getValue();
            if (!tdname) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NeedSelectBI"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NeedInputName"));
                return false;
            }
            return true;
    	},
    	
    	_getBIDialogValue : function(id) {
    		var name = FS.REPORTMGR.biDialog.getWidgetByName("nameText").getValue();
            var reportName = FS.REPORTMGR.biDialog.getWidgetByName("bidata").getText();
            var reportId = FS.REPORTMGR.biDialog.getWidgetByName("bidata").getValue();
            var description = FS.REPORTMGR.biDialog.getWidgetByName("descriptionText").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);

            var bi = {parentId: pd, description: description, reportName: reportName, text: name, reportId:reportId};
            if (id != null && id != undefined) {
                bi.id = id;
            }
            return bi;
    	},

        //Link
        _addOrEditLink: function (id, sortindex) {
            if (!this._isLinkValid()) {
                return false;
            }
            var url = this._getLinkDialogValue(id);
            if (!url) {
                return false;
            }
            if(sortindex) {
                url.sortindex = sortindex;
            }
            FR.get(
                FR.servletURL,
                {
                    type: 'POST',
                    op: "fs_entry",
                    cmd: "addurl",
                    urlJason: url
                },
                function callback(jason) {
                    if(jason == "-1") {
                        //ûȨ
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                        return ;
                    }
                    var item = FR.jsonDecode(jason);
                    //DOM
                    var tName = 'link';
                    var catalogWidths = [156, 340];
                    var hyperLinkIndex = 1;
                    var data = [item.text, item.url, item.id];
                    var originaldata = item;
                    if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                        $('.fs_reportmgr_table_' + tName).show();
                    }
                    FS.REPORTMGR.addTableData(tName, catalogWidths, hyperLinkIndex, data, originaldata);
                    FS.Cache.updateCache();
                    if(!FS.config.hasnavigation) {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
                }//callback
            );
        },

        _isLinkValid: function () {
            var path = FS.REPORTMGR.linkDialog.getWidgetByName("pathText").getValue();
            var name = FS.REPORTMGR.linkDialog.getWidgetByName("nameText").getValue();
            if (!path) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("InputLinkURL"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("InputLinkName"));
                return false;
            }
            return true;
        },

        _getLinkDialogValue: function (id) {
            var path = FS.REPORTMGR.linkDialog.getWidgetByName("pathText").getValue();
            var name = FS.REPORTMGR.linkDialog.getWidgetByName("nameText").getValue();
            var description = FS.REPORTMGR.linkDialog.getWidgetByName("descriptionText").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);

            var url = {parentId: pd, description: description, url: path, text: name};
            if (id != null && id != undefined) {
                url.id = id;
            }
            return url;
        },

        //Cpt
        _addOrEditCpt: function (id, sortindex) {
            if (!this._isCptValid()) {
                return false;
            }
            var report = this._getCptDialogValue(id);
            if (!report) {
                return false;
            }
            if(sortindex) {
                report.sortindex = sortindex;
            }
            FR.get(
                FR.servletURL,
                {
                    type: 'POST',
                    op: "fs_entry",
                    cmd: "addreport",
                    reportJason: report
                },
                function callback(jason) {//غ
                    if(jason == "-1") {
                        //ûȨ
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                        return ;
                    }
                    var item = FR.jsonDecode(jason);
                    //DOM
                    var tName = 'report';
                    var catalogWidths = [156, 161, 100, 80];
                    var hyperLinkIndex = 1;
                    var showType = (item.showType === 2 ? FR.i18nText("Preview") : (item.showType === 0 ? FR.i18nText("Face_Write") : FR.i18nText("Analysis")));
                    var hasParameters = (item.transmitParameters ? FR.i18nText("Have") : FR.i18nText("None"));
                    var data = [item.text, item, showType, hasParameters, item.id];
                    var originaldata = item;
                    if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                        $('.fs_reportmgr_table_' + tName).show();
                    }
                    FS.REPORTMGR.addTableData(tName, catalogWidths, hyperLinkIndex, data, originaldata);
                    FS.Cache.updateCache();
                    if(!FS.config.hasnavigation) {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
                }
            );
        },

        _isCptValid: function () {
            var path = FS.REPORTMGR.cptDialog.getWidgetByName("pathCombo").getValue().join('/');
            var name = FS.REPORTMGR.cptDialog.getWidgetByName("nameText").getValue();
            var showtype = FS.REPORTMGR.cptDialog.getWidgetByName("typeRadioGroup").getValue();
            if (!path) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("InputCptPath"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("InputCptName"));
                return false;
            }
            if(showtype === "") {
            	FR.Msg.alert(FR.i18nText("Choose_ViewType"));
                return false;
            }
            return true;
        },

        _getCptDialogValue: function (id) {
            var path = FS.REPORTMGR.cptDialog.getWidgetByName("pathCombo").getValue().join('/');
            var name = FS.REPORTMGR.cptDialog.getWidgetByName("nameText").getValue();
            var description = FS.REPORTMGR.cptDialog.getWidgetByName("descriptionText").getValue();
            var showType = FS.REPORTMGR.cptDialog.getWidgetByName("typeRadioGroup").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);
            var transmitParameters = FS.REPORTMGR.cptDialog.getWidgetByName("paraSetGrid").getData();
            var report = {parentId: pd, description: description, path: path, text: name, showType: showType, transmitParameters:transmitParameters};
            if (id != null && id != undefined) {
                report.id = id;
            }
            return report;
        },

        //ReportProcess
        _addOrEditRP: function(id, sortindex){
            if (!this._isRPValid()) {
                return false;
            }
            var rp = this._getRPDialogValue(id);
            if (!rp) {
                return false;
            }
            if(sortindex) {
                rp.sortindex = sortindex;
            }
            FR.get(
                FR.servletURL,
                {
                    type : 'POST',
                    op: "fs_entry",
                    cmd : "addreportprocess",
                    processJason: rp
                },
                function callback(jason){
                    if(jason == "-1") {
                        //ûȨ
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                        return ;
                    }
                    var item = FR.jsonDecode(jason);
                    //DOM
                    var tName = 'rp';
                    var catalogWidths = [156, 340];
                    var data = [item.text, item.processType, item.id];
                    var originaldata = item;
                    if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                        $('.fs_reportmgr_table_' + tName).show();
                    }
                    FS.REPORTMGR.addTableData(tName, catalogWidths, 1, data, originaldata);
                    FS.Cache.updateCache();
                    if(!FS.config.hasnavigation) {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
                }//callback
            );
        },

        _isRPValid: function(){
            var label = FS.REPORTMGR.rpDialog.getWidgetByName("LABELCOMBO").getValue();
            var name = FS.REPORTMGR.rpDialog.getWidgetByName("RPNAME").getValue();
            if (!label) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("RP_SelectLabel"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("RP_InputName"));
                return false;
            }
            return true;
        },

        _getRPDialogValue: function(id){
            var label = FS.REPORTMGR.rpDialog.getWidgetByName("LABELCOMBO").getValue();
            var text = FS.REPORTMGR.rpDialog.getWidgetByName("RPNAME").getValue();
            var description = FS.REPORTMGR.rpDialog.getWidgetByName("RPDESCRIPTION").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);
            var rp = {
                parentId : pd,
                processType: label,
                text: text,
                description: description
            };
            if (id != null && id != undefined) {
                rp.id = id;
            }
            return rp;
        },

        _makeZTreeData: function (treedata, result) {
            if (!result) {
                result = [];
            }
            for (var i = 0, len = treedata.length; i < len; i++) {
                var item = treedata[i];
                var zitem = {};
                zitem.name = item.text;
                if (item.ChildNodes && item.ChildNodes.length > 0) {
                    this._makeZTreeData(item.ChildNodes, result);
                }
                zitem.id = item.id;
                zitem.pId = item.parentId;
                zitem.open = true;
                zitem.description = item.description;
                zitem.sortindex = item.sortindex;
                result.push(zitem);
            }
            return result;
        },

        _getReportData: function (reports) {
            var result = [];
            for (var i = 0, len = reports.length; i < len; i++) {
                var report = reports[i];
                var showType = (report.showType === 2 ? FR.i18nText("Preview") : (report.showType === 0 ? FR.i18nText("Face_Write") : FR.i18nText("Analysis")));
                var hasParameters = (report.transmitParameters ? FR.i18nText("Have") : FR.i18nText("None"));
                var reportdata = [report.text, report, showType, hasParameters, report.id];
                result.push(reportdata);
            }
            return result;
        },

        _getLinkData: function (urls) {
            var result = [];
            for (var i = 0, len = urls.length; i < len; i++) {
                var url = urls[i];
                var urldata = [url.text, url.url, url.id];
                result.push(urldata);
            }
            return result;
        },
        
        _getBIData : function(bireports){
        	var result = [];
            for (var i = 0, len = bireports.length; i < len; i++) {
                var file = bireports[i];
                var filedata = [file.text, {reportName:file.reportName, reportId:file.reportId}, file.id];
                result.push(filedata);
            }
            return result;
        },

        _getRPData: function(rps){
            var result = [];
            for (var i = 0, len = rps.length; i < len; i++) {
                var rp = rps[i];
                var rpdata = [rp.text, rp.processType, rp.id];
                result.push(rpdata);
            }
            return result;
        },

        _getFileData : function(files) {
        	var result = [];
            for (var i = 0, len = files.length; i < len; i++) {
                var file = files[i];
                var filedata = [file.text, file.path, file.id];
                result.push(filedata);
            }
            return result;
        },

        _getAnalyData: function (ads) {
            var result = [];
            for (var i = 0, len = ads.length; i < len; i++) {
                var ad = ads[i];
                var addata = [ad.text, ad.tdname, ad.id];
                result.push(addata);
            }
            return result;
        },

        _initFileData: function (files) {
        	if(!files) {
        		files = [];
        	}
            var reports = [];
            var urls = [];
            var ads = [];
            var outfiles = [];
            var processes = [];
            var queryProcesses = [];
            var BIReports = [];
            var reportProcesses = [];
            for (var i = 0, len = files.length; i < len; i++) {
                if (files[i].url != null) {
                    urls.push(files[i]);
                } else if (files[i].tdname != null) {
                    ads.push(files[i]);
                } else if (files[i].type === FS.REPORTMGR.CONSTS.REPORTLET) {
                    reports.push(files[i]);
                } else if (files[i].type === FS.REPORTMGR.CONSTS.FILE) {
                    outfiles.push(files[i]);
                } else if (files[i].type === FS.REPORTMGR.CONSTS.PROCESS) {
                    processes.push(files[i]);
                } else if (files[i].type === FS.REPORTMGR.CONSTS.FASTQUERY) {
                    queryProcesses.push(files[i]);
                } else if (files[i].type === FS.REPORTMGR.CONSTS.BIREPORT) {
                    BIReports.push(files[i])
                } else if (files[i].type === FS.REPORTMGR.CONSTS.REPORTPROCESS) {
                    reportProcesses.push(files[i]);
                }
            }

            var reportsdata = this._getReportData(reports);
            FS.REPORTMGR.reportTable.popTableData(reportsdata, reports);
            var linkdata = this._getLinkData(urls);
            FS.REPORTMGR.LinkTable.popTableData(linkdata, urls);
            var analydata = this._getAnalyData(ads);
            FS.REPORTMGR.analyTable.popTableData(analydata, ads);
            var filedata = this._getFileData(outfiles);
            FS.REPORTMGR.fileTable.popTableData(filedata, outfiles);
            var bidata = this._getBIData(BIReports);
            FS.REPORTMGR.biTable.popTableData(bidata, BIReports);
            var rpdata = this._getRPData(reportProcesses);
            FS.REPORTMGR.rpTable.popTableData(rpdata, reportProcesses);
        },

        _showFiles: function (e, treeId, treeNode) {
            /**
             * wei : TODO ﻹǰȡĿ¼ĵطûҪ̨ڵ¼FS
             * ȡĿ¼Ϣ󣬾ѾЩˣֻҪڸ//ɾʱ»ͺˡ
             */
             //ǸĿ¼ֱreturn
             if(!treeNode.getParentNode()) {
             	FS.REPORTMGR.DIR._initFileData();
             	return ;
             }
            var nodeid = treeNode.id;
            FR.ajax({
                url: FR.servletURL + '?op=fs_entry&cmd=getfiles',
                type: 'POST',
                data: {folderID: nodeid},
                complete: function (res, status) {
                    if (!res.responseText) {
                        return;
                    }
                    var files = FR.jsonDecode(res.responseText);
                    FS.REPORTMGR.DIR._initFileData(files);
                }
            });
        },

        _checkValid: function (dirName, isAdd) {
            if (!dirName) {
                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("InputFolderName"));
                return false;
            }
            var dirTabletree = FS.REPORTMGR.DIR.dirTabletree;
            var selectedNode = dirTabletree.getSelectedNodes()[0];
            var siblings;
            if (isAdd === true) {
                siblings = selectedNode.children || [];
            } else {
                //޸
                siblings = selectedNode.getParentNode() ? (selectedNode.getParentNode().children || []) : [];
            }
            for (var i = 0, len = siblings.length; i < len; i++) {
                var node = siblings[i];
                if (node.name === dirName && node != selectedNode) {
                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Named") + dirName + FR.i18nText("FolderAlreadyExist"));
                    return false;
                }
            }
            return true;
        },

        _editFolder: function () {
            var dirTabletree = FS.REPORTMGR.DIR.dirTabletree;
            var selectedNode = dirTabletree.getSelectedNodes()[0];
            var dirName = this.getWidgetByName("nameText").getValue();
            var description = this.getWidgetByName("descriptionText").getValue();
            if (!FS.REPORTMGR.DIR._checkValid(dirName, false)) {
                return;
            }
            var folder = {};
            var parentId = selectedNode.pId.substr(1);
            if (parentId == null && parentId == undefined) {
                parentId = -1;
            }
            if (selectedNode.id != null && selectedNode.id != undefined) {
                folder.id = selectedNode.id;
            }
            folder.parentId = parentId;
            folder.text = dirName;
            folder.hasChildren = true;
            folder.isexpand = true;
            folder.complete = true;
            folder.description = description;
            folder.sortindex = selectedNode.sortindex;
            FR.ajax({
                url : FR.servletURL,
                data : {
                    op: "fs_entry",
                    cmd: "editfolder",
                    folderJason: folder
                },
                type : 'POST',
                complete : function(res) {
                    if(res.responseText == "-1") {
                        //ûȨ
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                        return ;
                    }
                    selectedNode.name = dirName;
                    selectedNode.description = description;
                    dirTabletree.updateNode(selectedNode);
                    FS.Cache.updateCache();
                    //ˢĿ¼
                    if(FS.config.hasnavigation) {
                        if(parentId+"" === "-1") {
                            FS.refreshAllNavigation();
                        }
                    } else {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
                }
            });
        },

        _addFolder: function (dirname, description) {
            var self = this;
            var selectedNode = this.dirTabletree.getSelectedNodes()[0];
            var folder = {};
            var parentId = selectedNode.pId.substr(1);
            if (FR.isEmpty(parentId)) {
                parentId = -1;
            }
            folder.parentId = selectedNode.id.substr(1);
            folder.text = dirname;
            folder.description = description;
            FR.ajax({
                url : FR.servletURL,
                data : {
                    op: "fs_entry",
                    cmd: "addfolder",
                    folderJason: folder
                },
                type : 'POST',
                complete : function(res) {
                    if(res.responseText == "-1") {
                        //ûȨ
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                        return ;
                    }
                    var newnode = FR.jsonDecode(res.responseText);
                    var node = {};
                    node.id = newnode.id;
                    node.name = dirname;
                    node.pId = selectedNode.id;
                    node.description = description;
                    node.open = true;
                    FS.Cache.updateCache();
                    self.dirTabletree.addSingleNode(selectedNode, node, selectedNode.open);
                    //ˢĿ¼
                    if(FS.config.hasnavigation) {
                        if(node.pId.substr(1) === "-1") {
                            FS.refreshAllNavigation();
                        }
                    } else {
                        var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                        FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                    }
                    self.dirTabletree.sortable(self.sortDir);
                }
            });
        },

        _createTableTree: function (zTreedata) {
            var self = this;
            var dirMgrSetting = {
                view: {
                    showIcon: false  //ʾÿڵǰICON
                },
                data: {
                    simpleData: {
                        enable: true,
                        idKey: "id",
                        pidKey: "pId",
                        rootPId: "0-2"
                    }
                },
                callback: {
                    onClick: this._showFiles
                }
            };
            //Ŀ¼tabletree
            this.dirTabletree = new FS.TableTree({
                treeID: 'dirmgrTableTree',
                renderEl: $('.fs_reportmgr_dir_panel_content'),
                setting: dirMgrSetting,
                height: '100%',
                width: '100%',
                fit: true,
                alwaysShowTools:false,
                Nodes: zTreedata,
                itemHoverCls: 'fs_reportmgr_tabletree_item_hover',
                tools: [
                    {
                        iconCls: 'fs-module-edit-white',
                        hoverCls: 'fs-module-edit-white-over',
                        rootToolHide: true,
                        //༭ť¼
                        onToolClick: function (e) {
                            var title = FR.i18nText("Edit_Directory");
                            var onOK = self._editFolder;
                            var onCancel = function () {
                            };
                            var nodeID = $(this).data('nodeID'); //༭dialogĳʼ
                            var preEditNode = self.dirTabletree.getNodeById(nodeID);
                            self.dirTabletree.selectNode(preEditNode);
                            var editDirDialog = FS.REPORTMGR.createDirDialog(title, onOK, onCancel);
                            editDirDialog.setVisible(true);
                            editDirDialog.getWidgetByName("nameText").setValue(preEditNode.name);
                            editDirDialog.getWidgetByName("descriptionText").setValue(preEditNode.description);
                            e.stopEvent();
                        }
                    },
                    {
                        rootToolHide: true,
                        iconCls: 'fs-module-delete-white',
                        hoverCls: 'fs-module-delete-white-over',
                        //ɾť¼
                        onToolClick: function (e) {
                            var nodeID = $(this).data('nodeID');
                            var preDeleteNode = self.dirTabletree.getNodeById(nodeID);
                            self.dirTabletree.selectNode(preDeleteNode);
                            FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete") + '?', function (result) {
                                if (result) {
                                    //̨ɾݣɹwebɾ
                                    var folderId = self.dirTabletree.getSelectedNodes()[0].id;
                                    $.get(
                                        FR.servletURL,
                                        {
                                            op: "fs_entry",
                                            cmd: "removefolder",
                                            folderId: folderId
                                        },
                                        function callback(result) {//Ӧ
                                            if(result == "-1") {
                                                //ûȨ
                                                FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                                                return ;
                                            }
                                        	var selectedNode = self.dirTabletree.getSelectedNodes()[0];
                                        	FS.Cache.updateCache();
                                        	if(FS.config.hasnavigation) {
                                        		//ɾϵİť
                                        		if(selectedNode.pId.substr(1) === "-1") {
                                                    FS.refreshAllNavigation();
									                //Ŀ¼ʾɾĿ¼лĿ¼ȥ
									                if((!FS.navigationTree.treefolderid) || (FS.navigationTree.treefolderid+"" === selectedNode.id+"")) {
									                	var managerItem = FS.navigationBar.getManagerItem();
									                	 var managerTree = managerItem._createTreeContent();
									                	managerItem.bar.removeSelect();
	                									managerItem.select();	
									                	FS.REPORTMGR.DIR._refreshNavigationTree(managerItem.options.text, managerTree);
									                }
									            }
                                        	} else {
                                        		var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
												FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                                        	}
											self.dirTabletree.removeSelectedNodes();
                                            var root = self.dirTabletree.getTreeObj().getNodes()[0];
                        					self.dirTabletree.selectNode(root);
                        					FS.REPORTMGR.reportMgr.getWidgetByName("cptMgrPane").panelBody.children().hide();
                                        }
                                    );
                                }
                            });
                            e.stopEvent();
                        }
                    }
                ]
            });
            this.dirTabletree.sortable(this.sortDir);
        },

        sortDir : function(beforeDragNode, afterDragNode, beforeDragIndex, afterDragIndex) {

			var beforeDragID = beforeDragNode.id;
			var beforeIndex = beforeDragIndex;
			var afterIndex = afterDragIndex;
			
			FR.ajax({
				url :FR.servletURL + "?op=fs_entry&cmd=modifyforfoldersort",
				type : 'POST',
				data : {sortid : beforeDragID, sortindex : afterDragIndex},
				complete : function(res, status) {
					if(status === "success") {
                        //cache˳
                        var rootFolders = FS.Cache.getRootFolder();
                        var dragFolder = rootFolders[beforeIndex];
                        rootFolders.splice(beforeIndex, 1);
                        rootFolders.splice(afterIndex, 0, dragFolder);
						if(FS.config.hasnavigation) {
							if(beforeDragNode.level === 1) {
								//ˢµ
								//λbeforeIndexƵafterIndexλ
								FS.refreshAllNavigation();
							}
						} else {
							var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
							FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
						}
					}
				}
			});	
        },
        
        //ѡеnodeĿ¼չʾ
        _selectFolder:function(selectedNode) {
			while(selectedNode.pId.substr(1) !== "-1") {
            	selectedNode = selectedNode.getParentNode();
            }
            var treeFolderItem = FS.navigationBar.getItemByFolderID(selectedNode.id);
            var reportTree = treeFolderItem._createTreeContent();
            treeFolderItem.bar.removeSelect();
            treeFolderItem.select();
			FS.REPORTMGR.DIR._refreshNavigationTree(treeFolderItem.options.text, reportTree, selectedNode.id);
        },
        
        _refreshNavigationTree : function(topText, reportTree, treefolderid) {
        	var navigationTree = FS.navigationTree;
			navigationTree._setTopText(topText);
            navigationTree._refreshContent(reportTree.element, treefolderid);
			reportTree._addOddAndEvenStyle();
        },
        
        initData: function () {
            var self = this;
            FR.ajax({
                url: FR.servletURL + '?op=fs_entry&cmd=getfolder',
                type: 'POST',
                complete: function (res, status) {
                    if (status === 'success') {
                        var treedata = FR.jsonDecode(res.responseText);
                        var zTreedata = self._makeZTreeData(treedata);
                        self._createTableTree(zTreedata);
                        var root = self.dirTabletree.getTreeObj().getNodes()[0];
                        self.dirTabletree.selectNode(root);
                    }
                }
            });
        }
    },

    //Ŀ¼ݳʼ
    dirMgrInit: function () {
        this.DIR.initData();
    },

    //ݳʼ
    cptMgrInit: function () {
        var catalogs = [FR.i18nText("WF-Name"), FR.i18nText("FS_Using_Templates"), FR.i18nText("Way"), FR.i18nText("FS_Parameter_Binding")];
        var catalogWidths = [156, 161, 100, 80];
        var tName = 'report';
        var hyperLinkIndex = 1; //гӵк
        this.reportTable = this.createTable(catalogs, catalogWidths, tName, hyperLinkIndex).hide();
        
        catalogs = [FR.i18nText("WF-Name"), FR.i18nText("Link_Address")];
        catalogWidths = [156, 340];
        tName = 'link';
        this.LinkTable = this.createTable(catalogs, catalogWidths, tName, hyperLinkIndex).hide();
        
        catalogs = [FR.i18nText("WF-Name"), FR.i18nText("Browser_Address")];
        catalogWidths = [156, 340];
        tName = 'analy';
        this.analyTable = this.createTable(catalogs, catalogWidths, tName, hyperLinkIndex).hide();
        
        catalogs = [FR.i18nText("WF-Name"), FR.i18nText("Layout")];
        catalogWidths = [156, 340];
        tName = 'file';
        this.fileTable = this.createTable(catalogs, catalogWidths, tName, -1).hide();

        catalogs = [FR.i18nText("WF-Name"), FR.i18nText("Label")];
        catalogWidths = [156, 300];
        tName = 'rp';
        this.rpTable = this.createTable(catalogs, catalogWidths, tName, 1).hide();

        catalogs = [FR.i18nText("WF-Name"), FR.i18nText("BI_Analysis")];
        catalogWidths = [156, 300];
        tName = 'bi';
        this.biTable = this.createTable(catalogs, catalogWidths, tName, hyperLinkIndex).hide();
        
        
        return [this.reportTable, this.LinkTable, this.analyTable, this.fileTable, this.rpTable, this.biTable];
    },
    //½ûжӦݵ
    createTable: function (catalogs, catalogWidths, tName, hyperLinkIndex) {
        var self = this;
        var tableCls = 'fs_reportmgr_table_' + tName;
        var catalogCls = 'fs_reportmgr_table_catalog';
        var contentCls = 'fs_reportmgr_table_content_' + tName;
        var foldCls = 'fs_reportmgr_fold_opts';
        var table = $('<div/>').addClass(tableCls);
        //˵DIV
        var catalogDiv = $('<div/>').addClass(catalogCls);
        for (var i = 0; i < catalogs.length; i++) {
            $('<div/>').text(catalogs[i])
                .css({width: catalogWidths[i], 'float': 'left'})
                .appendTo(catalogDiv);
        }
        var fold = $('<div/>').addClass(foldCls)
            .attr('content', contentCls)
            .addClass(foldCls + '_unfold')
            .appendTo(catalogDiv);
        catalogDiv.appendTo(table);
        fold.click(function () {
            var content = $(this).attr('content');
            if ($(this).hasClass(foldCls + '_fold')) {
                //$('.' + content).css({display:'block'});
                $('.' + content).slideDown('fast');
                $(this).removeClass(foldCls + '_fold').addClass(foldCls + '_unfold');
            } else {
                //$('.' + content).css({display:'none'});
                $('.' + content).slideUp('fast');
                $(this).removeClass(foldCls + '_unfold').addClass(foldCls + '_fold');
            }
        });

        //
        var contentDiv = $('<div/>').addClass(contentCls);
        //
        contentDiv.appendTo(table);

        var popTableData = function (data, originaldata) {
            contentDiv.empty();
            if (data.length > 0) {
                table.show();
            } else {
                table.hide();
            }

            for (var i = 0; i < data.length; i++) {
                self.addTableData(tName, catalogWidths, hyperLinkIndex, data[i], originaldata[i]);
            }
            self.makeTableSortable(table, tName);
        };

        $.extend(table, {
            popTableData: popTableData
        });

        this.makeTableSortable(table, tName);
        return table;
    },
    
    makeTableSortable : function(table, tName) {
		var self = this;
		var beforeDrag = 0;
		var afterDrag = 0;
		var beforeDragID;
		var itemcls = ".fs_reportmgr_table_content_line";
		table.sortable({
			items : itemcls,
			axis : 'y',
			opacity : '0.8',
			helper : 'clone',
			start : function(event, ui) {
				beforeDrag = $(itemcls, table).index(ui.item[0]);
				beforeDragID = ui.item.attr(tName+'id');
			},
			stop : function(event, ui) {
				afterDrag = $(itemcls, table).index(ui.item[0]);
				if((beforeDrag != afterDrag) && (beforeDrag >= 0) && (afterDrag >= 0)) {
					//wei : קͬʱˢop=fsչʾı
					FR.ajax({
						url :FR.servletURL + "?op=fs_entry&cmd=modifyforsort",
						type : 'POST',
						data : {sortid : beforeDragID, sortindex : afterDrag},
						complete:function() {
                            //cache˳
                            var selectedNode = FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0];
                            var entrys = FS.Cache.getFolder(selectedNode.id);
                            var dragEntry = entrys[beforeDrag];
                            entrys.splice(beforeDrag, 1);
                            entrys.splice(afterDrag, 0, dragEntry);
							//ıĿ¼Ľṹ
                            if(!FS.config.hasnavigation) {
                                var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                                FS.REPORTMGR.DIR._refreshNavigationTree(FR.i18nText("SystemMenu"), reportTree);
                            }
						}
					});
				}
			}
		}).disableSelection();
	},

    //һ,֮ǰͬid޸֮ǰ
    addTableData: function (tName, catalogWidths, hyperLinkIndex, data, originaldata) {
        var self = this;
        var tableCls = 'fs_reportmgr_table_' + tName;
        var contentCls = 'fs_reportmgr_table_content_' + tName;
        var lineCls = 'fs_reportmgr_table_content_line';
        var contentDiv = $('.' + contentCls);
        var lineDiv = $('<div/>').addClass(lineCls).data('tCls', tableCls);
        var j = 0;
        for (var len = catalogWidths.length; j < len; j++) {
    		var $oneDataDiv = $('<div/>').css({
    			width: catalogWidths[j],
    			'float': 'left'
    		}).appendTo(lineDiv);
            //ӳ
            if (hyperLinkIndex === j) {
                this.addHyperLink(tName, data[j], $oneDataDiv);
            } else {
                $oneDataDiv.text(FS.getShowText(data[j],132,12,'SimSun')).attr('title', data[j]);
            }
        }
        //IDжǷѾݣѴڣΪ༭¼
        var id = data[j];
        if (id) {
            var $find = $('.' + lineCls + '[' + tName + 'id=' + id + ']');
            if ($find && $find.length > 0) {
                $find.after(lineDiv);
                $find.remove();
            } else {
                lineDiv.appendTo(contentDiv);
            }
            lineDiv.attr(tName+'id',id);
        }
        //༭ťɾť
        var deleteDiv = $('<div/>').addClass('fs-module-delete-white')
        	.attr('title', FR.i18nText("Remove")).css({'display': 'none', float:'right'})
            .hover(function () {
                $(this).addClass('fs-module-delete-white-hover');
            }, function () {
                $(this).removeClass('fs-module-delete-white-hover');
            }).click(function () {
                //ɾťĵ¼
                var preDeleteDiv = $(this);
                FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete") + '?', function (result) {
                    if (result) {
                        var entryid = preDeleteDiv.parent().attr(tName + 'id');
                        FR.ajax({
                            url: FR.servletURL + "?op=fs_entry&cmd=removereport",
                            type: 'POST',
                            data: {entryIds: entryid},
                            complete: function (res, status) {
                                if (status === 'success') {
                                    if(res.responseText == "-1") {
                                        //ûȨ
                                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS_ReportManager_NoFolderEditPrivilege"));
                                        return ;
                                    }
                                    //DOMϵɾ
                                    var $table = $('.' + preDeleteDiv.parent().data('tCls'));
                                    preDeleteDiv.parent().remove();
                                    if ($table.find('.' + contentCls).children().length <= 0) {
                                        $table.hide();
                                    }
                                    FS.Cache.updateCache();
                                }
                            }
                        });
                    }
                });
            });
        var editDiv = $('<div/>').addClass('fs-module-edit-white')
            .attr('title', FR.i18nText("Edit")).css({'display': 'none', float:'right'})
            .data('tName', tName)
            .hover(function () {
                $(this).addClass('fs-module-edit-white-hover');
            }, function () {
                $(this).removeClass('fs-module-edit-white-hover');
            }).click(function () {
                //༭ťĵ¼
                var type = $(this).data('tName');
                if (type === 'link') {
                    //ӱ༭¼
                    var title = FR.i18nText("Edit_Link");
                    var data = FR.clone(originaldata);
                    var onOK = function () {
                        return self.DIR._addOrEditLink(data.id.substr(1), data.sortindex);
                    };
                    var onCancel = function () {
                    };
                    self.linkDialog = self.createLinkDialog(title, onOK, onCancel, data);
                    self.linkDialog.setVisible(true);
                } else if (type === 'report') {
                    //ģ༭¼
                    var title = FR.i18nText("Edit_Cpt");
                    var data = FR.clone(originaldata);
                    var onOK = function () {
                        return self.DIR._addOrEditCpt(data.id.substr(1), data.sortindex);
                    };
                    var onCancel = function () {
                    };
                    self.cptDialog = self.createCptDialog(title, onOK, onCancel, data);
                    self.cptDialog.setVisible(true);
                } else if(type === 'analy') {
                	//ģ༭¼
                    var title = FR.i18nText("Edit_Analysis");
                    var data = FR.clone(originaldata);
                    var onOK = function () {
                        return self.DIR._addOrEditAnalysis(data.id.substr(1), data.sortindex);
                    };
                    var onCancel = function () {
                    };
                    self.analysisDialog = self.createAnalysisDialog(title, onOK, onCancel, data);
                    self.analysisDialog.setVisible(true);
                } else if(type === 'file') {
                	var title = FR.i18nText("Edit_File");
                	var data = FR.clone(originaldata);
                	var onOK = function() {
                		return self.DIR._editFile(data.id.substr(1), data.sortindex);
                	};
                	var onCancel = function() {
                		
                	};
                	self.fileDialog = self.createFileDialog(title, onOK, onCancel, data);
                	self.fileDialog.setVisible(true);
                } else if(type === 'bi') {
                	var title = FR.i18nText("Edit_BI");
                	var data = FR.clone(originaldata);
                	var onOK = function() {
                		return self.DIR._addOrEditBI(data.id.substr(1), data.sortindex);
                	};
                	var onCancel = function() {
                		
                	};
                	self.biDialog = self.createBIDialog(title, onOK, onCancel, data);
                	self.biDialog.setVisible(true);
                } else if(type === 'rp'){
                    var title = FR.i18nText("RP_EditLabel");
                    var data = FR.clone(originaldata);
                    var onOK = function() {
                        return self.DIR._addOrEditRP(data.id.substr(1), data.sortindex);
                    };
                    var onCancel = function() {

                    };
                    self.rpDialog = self.createRPDialog(title, onOK, onCancel, data);
                    self.rpDialog.setVisible(true);
                }
            });
        lineDiv.hover(function () {
            $(this).addClass('fs_reportmgr_table_content_line_hover');
            editDiv.show();
            deleteDiv.show();
        }, function () {
            $(this).removeClass('fs_reportmgr_table_content_line_hover');
            editDiv.hide();
            deleteDiv.hide();
        });
        deleteDiv.appendTo(lineDiv);
        editDiv.appendTo(lineDiv);
    },
    //ӳ
    addHyperLink: function (tName, data, obj) {
        var $oneDataDiv = obj;
        var url = '#';
        //ģ
        if (tName === 'report') {
            var report = data;
            var ps = report.path.split("/");
            var reportName = ps[ps.length - 1];
            var parameters = {}, tps = report.transmitParameters;
            //ģֻͣж.cpt.frmϰ汾ûǡ
            if (report.nodeicon === 'cpt') {
                $.extend(parameters, {reportlet: report.path});
            } else if (report.nodeicon === 'frm') {
                $.extend(parameters, {formlet: report.path});
            }
            //Ԥʽop
            if (report.showType === 0) {
                $.extend(parameters, {op: 'write'});
            } else if (report.showType === 1) {
                parameters.op = 'view';
            }
            //url
            for (var index = 0, len = tps ? tps.length : 0; index < len; index++) {
                parameters[tps[index].name] = tps[index].value;
            }
            url = FR.buildServletUrl(parameters);
            $('<a target="_blank" href=' + url + '/>')
                .text(FS.getShowText(reportName,140,12,'SimSun'))
                .attr('title', reportName)
                .appendTo($oneDataDiv);
        }
        //ַ
        else if (tName === 'link') {
            var address = data;
            //ַ
            if (address.match(/[a-zA-Z]+:\/\/[^\s]*/)) {
                url = address;
            } else {
                url = FR.server + '/' + address;
            }
            $('<a target="_blank" href=' + encodeURI(url) + '/>')
                .text(FS.getShowText(address,320,12,'SimSun'))
                .attr('title', address)
                .appendTo($oneDataDiv);
        }
        //ݷ
        else if(tName === 'analy') {
        	var tdname = data;
        	
        	url = FR.buildServletUrl({op: 'fr_adhoc', cmd:'ac_init_analysispane', viewname: tdname})
            
            $('<a target="_blank" href=' + url + '/>')
                .text(FS.getShowText(tdname,320,12,'SimSun'))
                .attr('title', tdname)
                .appendTo($oneDataDiv);
        }
        //bi
        else if(tName === 'bi') {
        	var tdname = data.reportName;
        	var url = FR.buildServletUrl({op: 'fr_bi', cmd:'bi_init', id: data.reportId, openFromShare: true, systemManager: true, createby :"-999"})	;
        	$('<a target="_blank" href=' + url + '/>')
                .text(FS.getShowText(tdname,280,12,'SimSun'))
                .attr('title', tdname)
                .appendTo($oneDataDiv);
        }
        //ϱ(ݲ)
        else if(tName === 'rp'){
            var tdname = FS.REPORTMGR.CONSTS.PROCESSTYPE[data];
            $('<a/>').text(FS.getShowText(tdname,280,12,'SimSun'))
                .attr('title', tdname)
                .appendTo($oneDataDiv);
        }
    },
//Ŀ¼dialog
    createDirDialog: function (title, okCallback, cancelCallback, data) {
        var hGap = 10;//ǩı֮ļ϶
        var labelWidth = parseInt(FR.i18nText("FS-Create_Dir_Dialog_Label_width") || 58);

        var dirDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            animate: false,
            width: 300,
            height: 220,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("WF-Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 130,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 16
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        multiline: true,
                        x: hGap + labelWidth,
                        y: 47
                    }
                ]
            }
        });
        return dirDialog;
    },
//dialog
    createLinkDialog: function (title, okCallback, cancelCallback, data) {
        var hGap = 10, labelWidth = parseInt(FR.i18nText("FS-Report_Manager_Add_Template_Width") || 58);
        var linkDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            animate: false,
            width: 300,
            height: 260,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("WF-Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 130,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 16
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        multiline: true,
                        x: hGap + labelWidth,
                        y: 47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Link_Path"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 142
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 130,
                        widgetName: 'pathText',
                        x: hGap + labelWidth,
                        y: 142
                    }
                ]
            }
        });
        if (data) {
            linkDialog.getWidgetByName("pathText").setValue(data.url);
            linkDialog.getWidgetByName("nameText").setValue(data.text);
            linkDialog.getWidgetByName("descriptionText").setValue(data.description);
        }
        return linkDialog;
    },
    
    //ݷdialog
     createAnalysisDialog : function(title, okCallback, cancelCallback, data) {
    	var self = this;
        var hGap = 10, labelWidth = parseInt(FR.i18nText("FS-Report_Manager_Add_Analysis_Width") || 58);
    	var analysisDialog = new FR.Dialog({
    		title: title,
            text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            animate: false,
            width: 320,
            height: 300,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("Analysis_Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 16
                    },
                    {
                    	type: 'llabel',
                        value: FR.i18nText("Choose_Data"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                    	type:'combo',
                    	items:[],
                    	height: 21,
                    	width: 185,
                    	widgetName: 'analysisdata',
                    	x: hGap + labelWidth,
                    	y:47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 78
                    },
                    {
                        type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        multiline: true,
                        x: hGap + labelWidth,
                        y: 78
                    }
                ]
            }
    	});
    	
    	//ȡݷ
    	var getAnalysisData = function() {
    		var ran = new Date().getTime() + "" + (Math.random() * 1000);
			$.get(
				FR.servletURL,
				{	
					type : 'POST',
					op : "fr_adhoc",
					cmd : "ac_get_data_name",
					_ran : ran
				},
				function callback(jasonA){
					var names = FR.jsonDecode(jasonA);
					var datas = [];
					$.each(names, function(idx, item){
						datas[idx] = {value : item.text, text : item.text};
					});
					var analysisCombo = analysisDialog.getWidgetByName("analysisdata");
					analysisCombo.options.renderEl = analysisCombo.element;
					analysisCombo.rebuild(datas);
					if (data) {
			            analysisDialog.getWidgetByName("nameText").setValue(data.text);
			            analysisDialog.getWidgetByName("analysisdata").setValue(data.tdname);
			            analysisDialog.getWidgetByName("descriptionText").setValue(data.description);
			        }
				}
			);
    	};
    	
    	getAnalysisData();
    	
        return analysisDialog;
     },
     
     //bi dialog
     createBIDialog : function(title, okCallback, cancelCallback, data) {
     	var self = this;
     	var biDialog = new FR.Dialog({
     		title:title,
     		text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 320,
            height: 300,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("Analysis_Name"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'nameText',
                        x: 68,
                        y: 16
                    },
                    {
                    	type: 'llabel',
                        value: FR.i18nText("Choose_Data"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                    	type:'combo',
                    	items:[],
                    	height: 21,
                    	width: 230,
                    	widgetName: 'bidata',
                    	x:68,
                    	y:47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Description"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 78
                    },
                    {
                        type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        multiline: true,
                        x: 68,
                        y: 78
                    }
                ]
            }
     	});
     	//ȡݷ
    	var getBIData = function() {
    		var ran = new Date().getTime() + "" + (Math.random() * 1000);
			$.get(
				FR.servletURL,
				{	
					type : 'POST',
					op : "fr_bi_configure",
					cmd : "get_all_template_made_by_admin",
					_ran : ran
				},
				function callback(jasonA){
					var names = FR.jsonDecode(jasonA);
					var datas = [];
					$.each(names, function(idx, item){
						datas[idx] = {value : item.id, text : item.text};
					});
					var biCombo = biDialog.getWidgetByName("bidata");
					biCombo.options.renderEl = biCombo.element;
					biCombo.rebuild(datas);
					if (data) {
			            biCombo.getWidgetByName("nameText").setValue(data.text);
			            biCombo.getWidgetByName("bidata").setValue(data.reportId);
			            biCombo.getWidgetByName("descriptionText").setValue(data.description);
			        }
				}
			);
    	};
    	
    	getBIData();
    	
        return biDialog;
     },
     
     //ļdialog 
     createFileDialog : function(title, okCallback, cancelCallback, data) {
     	var self = this;
     	var fileDialog = new FR.Dialog({
     		title: title,
            text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 320,
            height: 300,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("File_Name"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'nameText',
                        x: 68,
                        y: 16
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Description"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        multiline: true,
                        x: 68,
                        y: 47
                    },
                    {
                    	type: 'llabel',
                        value: FR.i18nText("Layout"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 141
                    },
                    {
                    	type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'fileposition',
                        multiline: true,
                    	x:68,
                    	disabled:true,
                    	y:141
                    }
                ]
            }
     	});
     	if (data) {
            fileDialog.getWidgetByName("nameText").setValue(data.text);
            fileDialog.getWidgetByName("fileposition").setValue(data.path);
            fileDialog.getWidgetByName("descriptionText").setValue(data.description);
        }
     	return fileDialog;
     },
     
	//ģdialog
    createCptDialog: function (title, okCallback, cancelCallback, data) {
        var self = this;
        var hGap = 10, labelWidth = parseInt(FR.i18nText("FS-Report_Manager_Add_Template_Width") || 58);
        var cptDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 500,
            height: 400,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                widgetName: 'cptAbsolute',
                scrollable: true,
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("Path"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                    	width:280,
			        	height:21,
			        	loadByLayer :  true,
			        	widgetUrl :  FR.servletURL + "?op=fs_entry&cmd=getreports&form=true&file=cpt,frm",
			        	type: 'treecombobox',
                        returnFullPath: true,
                        directEdit: false,
			        	x: hGap + labelWidth,
			        	widgetName:'pathCombo',
			        	selectLeafOnly:true,
			        	y:16,
			        	listeners:[{
			        		eventName:'afteredit',
			        		action:function() {
			        			var path = this.getValue();
            					var reportName = path[path.length - 1];
                                //Sean: ǱֻѡԤһ
                                if(reportName.endWith('.frm')){
                                    cptDialog.getWidgetByName("typeRadioGroup").setValue('2');
                                    cptDialog.getWidgetByName("typeRadioGroup").setEnable(false);
                                    cptDialog.getWidgetByName("reportType").setEnable(false);
                                }else{
                                    cptDialog.getWidgetByName("typeRadioGroup").setEnable(true);
                                    cptDialog.getWidgetByName("reportType").setEnable(true);
                                }
            					cptDialog.getWidgetByName("nameText").setValue(reportName);
            					cptDialog.getWidgetByName("paraSetGrid").reportletPath = path.join('/');
			        		}
			        	}]
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("WF-Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 78
                    },
                    {
                        type: 'text',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        multiline: true,
                        x: hGap + labelWidth,
                        y: 78
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS_Report_Type"),
                        textalign: 'right',
                        widgetName: 'reportType',
                        height: 21,
                        width: labelWidth,
                        x: 0,
                        y: 173
                    },
                    {
                        type: 'radiogroup',
                        assureSelect:true,
                        columnsInRow: 3,
                        items: [
                            {value: '0', text: FR.i18nText("Face_Write")},
                            {value: '1', text: FR.i18nText("Analysis")},
                            {value: '2', text: FR.i18nText("Preview")}
                        ],
                        height: 21,
                        width: 200,
                        value:'2',
                        widgetName: 'typeRadioGroup',
                        x: hGap + labelWidth,
                        y: 173
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("Parameter_Setting"),
                        textalign: 'right',
                        height: 21,
                        width: labelWidth,
                        x: 0,
                        y: 204
                    },
                    {
                    	type : "parametergrid",
						widgetName : "paraSetGrid",
						width : 385,
						x: hGap + labelWidth,
                        y: 204
                    }
                ]
            }
        });
        this.reportTreeDiv = $('<div/>').addClass('fs_reportmgr_treewrap').appendTo(cptDialog.win.$contentPane).hide();
        cptDialog.getWidgetByName('cptAbsolute').doLayout();
        //༭Ŀ¼ʱгʼ
        if (data) {
            cptDialog.getWidgetByName("pathCombo").setValue(data.path);
            cptDialog.getWidgetByName("nameText").setValue(data.text);
            cptDialog.getWidgetByName("descriptionText").setValue(data.description);
            cptDialog.getWidgetByName("typeRadioGroup").setValue(data.showType);
            cptDialog.getWidgetByName("paraSetGrid").popData(data.transmitParameters);
        }
        return cptDialog;
    },

    //ϱDialog
    createRPDialog: function(title, okCallback, cancelCallback, data){
        var rpDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("OK"),
            text4Cancel: FR.i18nText("Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 400,
            height: 300,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: "tablelayout",
                widgetName: "RPTABLE",
                columnSize : [60, 10, 250],
                rowSize : [10, 21, 21, 85],
                vgap : 10,
                items: [
                    [
                        {el:$('<div/>')}
                    ],
                    [
                        {el:{type: "llabel", value: FR.i18nText("Label"), textalign: "right"}},
                        {el: $('<div/>')},
                        {el:{type: "combo", widgetName: "LABELCOMBO", directEdit: false, items: [
                            {text : FS.REPORTMGR.CONSTS.PROCESSTYPE[1], value : 1},
                            {text : FS.REPORTMGR.CONSTS.PROCESSTYPE[2], value : 2},
                            {text : FS.REPORTMGR.CONSTS.PROCESSTYPE[3], value : 3}
                        ],listeners: [{
                            eventName:FR.Events.AFTEREDIT,
                            action:function() {
                                var label = this.getText();
                                rpDialog.getWidgetByName('RPNAME').setValue(label);
                            }
                        }],width: 185}}
                    ],
                    [
                        {el:{type: "llabel", value: FR.i18nText("WF-Name"), textalign: "right"}},
                        {el: $('<div/>')},
                        {el:{type: "text", widgetName: "RPNAME", width: 185}}
                    ],
                    [
                        {el:{type: "vertical", hgap: 0, vgap: 0, items: [
                            {el:{type: 'llabel', value: FR.i18nText("Description"), textalign: "right"}, height: 21}
                        ]}},
                        {el: $('<div/>')},
                        {el:{type: 'text', widgetName: "RPDESCRIPTION", multiline: true}}
                    ]
                ]
            }
        });
        rpDialog.getWidgetByName('RPTABLE').doLayout();
        //༭Ŀ¼ʱгʼ
        if (data) {
            rpDialog.getWidgetByName("LABELCOMBO").setValue(data.processType);
            rpDialog.getWidgetByName("RPNAME").setValue(data.text);
            rpDialog.getWidgetByName("RPDESCRIPTION").setValue(data.description);
        }
        return rpDialog;
    }
}