/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 * author wei
 * 2014-04-08
 */

//FSȨ޹

var Constants = {
    privilegeConfigTableWD : "privilegeConfigTableWD",
    privilegeConfigPanelWD : "privilegeConfigPanelWD",
    entryPrivilegeConfigTableWD : "entryPrivilegeConfigTableWD",
    entryPrivilegeConfigPanelWD : "entryPrivilegeConfigPanelWD",
    userPrivilegeViewHorizontalWD : "userPrivilegeViewHorizontalWD",
    entryAndModulePrivilegeViewHorizontalWD : "entryAndModulePrivilegeViewHorizontalWD",
    entryTableTreeNoCheckWD: "entryTableTreeNoCheckWD",
    entryTableTreeNoCheckInPanelWD: "entryTableTreeNoCheckInPanelWD",
    entryTableTreeWD: "entryTableTreeWD",
    entryTableTreeViewOnlyWD: "entryTableTreeViewOnlyWD",
    departmentTableTreeWD: "departmentTableTreeWD",
    departmentTableTreeNoCheckWD: "departmentTableTreeNoCheckWD",
    depAndCRoleTableTreeWD: "depAndCRoleTableTreeWD",
    customRoleListWD: "customRoleListWD",
    customRoleListNoCheckWD: "customRoleListNoCheckWD",
    positionAndCustomRoleInsideTabNoCheckWD: "positionAndCustomRoleInsideTabNoCheckWD",
    positionAndCustomRoleInsideTabWD: "positionAndCustomRoleInsideTabWD",
    entryAndModuleInsideTabWD: "entryAndModuleInsideTabWD",
    entryAndModuleViewOnlyTabWD: "entryAndModuleViewOnlyTabWD",
    moduleListViewOnlyWD: "moduleListViewOnlyWD",
    moduleListWD: "moduleListWD",
    moduleListNoCheckWD: "moduleListNoCheckWD",
    userListViewOnlyWD: "userListViewOnlyWD",
    userListNoCheckWD: "userListNoCheckWDL",
    addCustomRoleButtonCls: 'fs_privilege_manager_addCustomRole_button',
    postIdPrefix: "10086",
    floatPaneTableLayoutWD: "floatPaneTableLayoutWD",
    customRoleNameTextWD: "customRoleNameTextWD",
    templateControlCardWD: "templateControlCardWD",
    templateTableTreeWD: "templateTableTreeWD",
    templateTableTreeInPanelWD: "templateTableTreeInPanelWD",
    settingRadioGroupWD: "settingRadioGroupWD",
    keyURLTextEditorWD: "keyURLTextEditorWD",
    gradeAuthoritySwitchWD: "gradeAuthoritySwitchWD",
    editReportSwitchWD: "editReportSwitchWD",
    dataConnectionSwitchWD: "dataConnectionSwitchWD",
    dataConnectionListWD: "dataConnectionListWD",
    customRoleListSyncItemCls: "fs_privilege_manager_customRoleSyncItem",
    templatePrivileges: {
        NO_VERIFY_NEEDED : -1,
        USER_PASSWORD_VERIFY_NEEDED : 0,
        ROLE_VERIFY_NEEDED : 1,
        DIGITAL_URL : 2
    },
    depAndCRolePaneCls: "fs_privilege_manager_depAndCRolePane",
    depAndCRolePaneTitleCls: "fs_privilege_manager_depAndCRolePaneTitle",
    templateAndDataConnectionInsideTabWD: "templateAndDataConnectionInsideTabWD",
    departmentAllID: FS.config.departmentAllID ? FS.config.departmentAllID : 0,    //вŵID
    postAllID: FS.config.postAllID ? FS.config.postAllID : 0  //ְID
}

FS.PRIVILEGEMANAGER = FSPM = {
    init : function(renderEl) {
//        FR.$defaultImport('/com/fr/fs/web/js/widget/fs.tabletree.js', 'js');
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_privilegemanager.css', 'css');

        this.VIEW.createTabPane(renderEl);
        this.VIEW.createSetPane(renderEl);
    },

    //705ǹѡȨ޺ʵʱ棬706ĳɵ水ťһԱ档Ҫ֮ǰö
    CACHE : {
        clearCache: function() {
            this.clearEntryCache();
            this.clearRoleCache();
        },

        clearEntryCache: function () {
            this.entryCache = {};
            this.originalEntryCache = {};
        },

        clearRoleCache: function () {
            this.roleCache = {};
            this.originalPrivilege = {};
        },


        /*********** Ȩû ************/
        getEntryCache : function() {
            if(!this.entryCache) {
                this.entryCache = {};
            }
            return this.entryCache;
        },

        dealWithEntryCache : function(roles) {
            var entryCache = [];
            for(var i = 0, len = roles.length; i < len; i ++) {
                var item = {};
                //getCompanyRoleAuthһ£ȥtype
                item.id = roles[i].id;
                item.view = roles[i].view;
                if(FS.isGradeAuthorityOpen()) {
                    item.design = roles[i].design;
                } else if(item.view === 1) {
                    item.design = 1;
                }
                if(FS.isEditReportAuthorityOpen()) {
                    item.edit = roles[i].edit;
                } else if(item.view === 1 && (!FS.isGradeAuthorityOpen() || item.design == 1)) {
                    item.edit = 1;
                }
                entryCache.push(item);
            }
            return entryCache;
        },

        setEntryCache : function(entryId, roles, isCompanyRole) {
            entryId = entryId + "";
            if(!this.getEntryCache()[entryId]) {
                this.getEntryCache()[entryId] = {
                };
            }
            if(isCompanyRole) {
                //ְλ
                this.getEntryCache()[entryId]["companyRole"] = this.dealWithEntryCache(roles);
            } else {
                //Զɫ
                this.getEntryCache()[entryId]['customRole'] = this.dealWithEntryCache(roles);
            }
        },

        keepOriginalEntryCache: function(entryId, roles, isCompanyRole) {
            if(!this.originalEntryCache) {
                this.originalEntryCache = {};
            }
            if(!this.originalEntryCache[entryId]) {
                this.originalEntryCache[entryId] = {};
            }
            if(isCompanyRole) {
                if(this.originalEntryCache[entryId]["companyRole"]) {
                    return ;
                } else {
                    this.setEntryCache(entryId, roles, true);
                    this.originalEntryCache[entryId]["companyRole"] = FR.clone(roles);
                }
            } else {
                if(this.originalEntryCache[entryId]["customRole"]) {
                    return ;
                } else {
                    this.setEntryCache(entryId, roles, false);
                    this.originalEntryCache[entryId]["customRole"] = FR.clone(roles);
                }
            }
        },

        getOriginalEntryCache : function() {
            if(!this.originalEntryCache) {
                this.originalEntryCache = {};
            }
            return this.originalEntryCache;
        },

        refreshOriginalEntryCache: function(entryCache) {
             this.originalEntryCache = entryCache;
        },

        /************* Ȩû ****************/

        getRoleCache : function() {
            if(!this.roleCache) {
                this.roleCache = {};
            }
            return this.roleCache;
        },

        delecteCache : function(roleId) {
            roleId = roleId + "";
            if(roleId) {
                delete this.getRoleCache()[roleId];
                delete this.getOriginalPrivilege()[roleId];
            }
        },

        dealWithEntryPrivilege: function(roleId, entries, hasType) {
            var entryCache = [];
            for(var i = 0, len = entries.length; i < len; i ++) {
                var item = {};
                //getCompanyRoleAuthһ£ȥtype
                if(hasType) {
                    item.id = entries[i].id.substr(1);
                } else {
                    item.id = entries[i].id;
                }
                item.view = entries[i].view;
                if(!FS.isGradeAuthorityOpen()) {
                    item.design = item.view;
                    if(!FS.isEditReportAuthorityOpen()) {
                        item.edit = item.view;
                    }
                } else {
                    item.design = entries[i].design;
                    if(!FS.isEditReportAuthorityOpen()) {
                        item.edit = item.design;
                    }
                }
                if(FS.isEditReportAuthorityOpen()) {
                    item.edit = entries[i].edit;
                }
                item.type = entries[i].type;
                entryCache.push(item);
            }
            return entryCache;
        },

        setEntryPrivilege : function(roleId, entries, hasType) {
            roleId = roleId + "";
            if(!this.getRoleCache()[roleId]) {
                this.getRoleCache()[roleId] = {};
            }
            var entryCache = this.dealWithEntryPrivilege(roleId, entries, hasType);
            this.getRoleCache()[roleId]['entries'] = FR.clone(entryCache);
        },

        dealWithModulePrivilege: function(roleId, modules) {
            var moduleCache = [];
            for(var i = 0; i < modules.length; i ++) {
                var item = {};
                if(!modules[i].view) {
                    continue ;
                } else {
                    item.view = 1;
                    if(!FS.isGradeAuthorityOpen()) {
                        item.design = 1;
                    } else {
                        item.design = modules[i].design;
                    }
                    item.id = modules[i].id;
                }
                moduleCache.push(item);
            }
            return moduleCache;
        },

        setModulePrivilege : function(roleId, modules) {
            roleId = roleId + "";
            if(!this.getRoleCache()[roleId]) {
                this.getRoleCache()[roleId] = {};
            }
            var moduleCache = this.dealWithModulePrivilege(roleId, modules);
            this.getRoleCache()[roleId]['modules'] = FR.clone(moduleCache);
        },

        dealWithTemplatePrivilege : function(roleId, templates) {
            var templateCache = [];
            for(var i = 0, len = templates.length; i < len; i ++) {
                var template = templates[i];
                var item = {};
                item.path = template.path;
                item.page = template.page;
                item.write = template.write;
                item.design = template.design;
                templateCache.push(item);
            }
            return templateCache;
        },

        dealWithDepAndCRolePrivilege : function(roleId, depandcroles) {
            var depAndCRoleCache = [];
            for(var i = 0, len = depandcroles.length; i < len; i ++) {
                var depandcrole = depandcroles[i].id ? depandcroles[i].id : depandcroles[i];
                depAndCRoleCache.push(depandcrole);
            }
            return depAndCRoleCache;
        },

        setTemplatePrivilege : function(roleId, templates) {
            roleId = roleId + "";
            if(!this.getRoleCache()[roleId]) {
                this.getRoleCache()[roleId] = {};
            }
            var templateCache = this.dealWithTemplatePrivilege(roleId, templates);
            this.getRoleCache()[roleId]['templates'] = FR.clone(templateCache);
        },

        setDepAndCRolePrivilege: function(roleId, depandcroles) {
            roleId = roleId + "";
            if(!this.getRoleCache()[roleId]) {
                this.getRoleCache()[roleId] = {};
            }
            var depAndCRoleCache = this.dealWithDepAndCRolePrivilege(roleId, depandcroles);
            this.getRoleCache()[roleId]['depandcroles'] = FR.clone(depAndCRoleCache);
        },

        dealWithDataConnectionPrivilege: function(roleId, dataConnections) {
            var dataConnectionRoleCache = [];
            for(var i = 0, len = dataConnections.length; i < len; i ++) {
                if(dataConnections[i].value && dataConnections[i].view === 1) {
                    dataConnectionRoleCache.push(dataConnections[i].value);
                } else if(!dataConnections[i].value) {
                    dataConnectionRoleCache.push(dataConnections[i]);
                }
            }
            return dataConnectionRoleCache;
        },

        setDataConnectionPrivilege: function(roleId, dataConnections) {
            roleId = roleId + "";
            if(!this.getRoleCache()[roleId]) {
                this.getRoleCache()[roleId] = {};
            }
            var dataConnectionCache = this.dealWithDataConnectionPrivilege(roleId, dataConnections);
            this.getRoleCache()[roleId]['dataconnections'] = FR.clone(dataConnectionCache);
        },

        getRolePrivilege: function(roleId) {
            return this.getRoleCache()[roleId];
        },

        getEntryPrivilege: function(roleId) {
            if(!this.getRoleCache()[roleId]) {
                return ;
            }
            return this.getRoleCache()[roleId]['entries'];
        },

        getModulePrivilege: function(roleId) {
            if(!this.getRoleCache()[roleId]) {
                return ;
            }
            return this.getRoleCache()[roleId]['modules'];
        },

        getTemplatePrivilege: function(roleId) {
            if(!this.getRoleCache()[roleId]) {
                return ;
            }
            return this.getRoleCache()[roleId]['templates'];
        },

        getDepAndCRolePrivilege: function(roleId) {
            if(!this.getRoleCache()[roleId]) {
                return ;
            }
            return this.getRoleCache()[roleId]['depandcroles'];
        },

        getDataConnectionPrivilege: function(roleId) {
            if(!this.getRoleCache()[roleId]) {
                return ;
            }
            return this.getRoleCache()[roleId]['dataconnections'];
        },

        //ӷ˻ȡȨϢ
        cachePrivilege: function(roleId, privilege) {
            this.keepOriginalPrivilege(roleId, privilege);
            var entries = FR.jsonDecode(privilege.reports);
            var modules = FR.jsonDecode(privilege.modules);
            var templates = FR.jsonDecode(privilege.templates);
            var depAndCRoles = privilege.depandcroles ? privilege.depandcroles.slice(0) : [];
            var dataConnections = privilege.dataconnections ? privilege.dataconnections.slice(0) : [];
            //ѾˣͲ
            if(!this.getEntryPrivilege(roleId)) {
                this.setEntryPrivilege(roleId, entries, false);
            }
            if(!this.getModulePrivilege(roleId)) {
                this.setModulePrivilege(roleId, modules);
            }
            if(!this.getTemplatePrivilege(roleId)) {
                this.setTemplatePrivilege(roleId, templates);
            }
            if(!this.getDepAndCRolePrivilege(roleId)) {
                this.setDepAndCRolePrivilege(roleId, depAndCRoles);
            }
            if(!this.getDataConnectionPrivilege(roleId)) {
                this.setDataConnectionPrivilege(roleId, dataConnections);
            }
        },

        //¼¸ȨǰϢ汣ʱԱȱ䶯
        keepOriginalPrivilege: function(roleId, privilege, hasType) {
            //ѾˣͲ
            if(!this.originalPrivilege) {
                this.originalPrivilege = {};
            }
            if(this.originalPrivilege[roleId]) {
                return ;
            } else {
                this.originalPrivilege[roleId] = {};
            }
            var entries = FR.jsonDecode(privilege.reports);
            var modules = FR.jsonDecode(privilege.modules);
            var templates = FR.jsonDecode(privilege.templates);
            var depAndCRoles = privilege.depandcroles ? privilege.depandcroles.slice(0) : [];
            var dataConnections = privilege.dataconnections ? privilege.dataconnections.slice(0) : [];
            this.originalPrivilege[roleId]['entries'] = this.dealWithEntryPrivilege(roleId, entries, hasType);
            this.originalPrivilege[roleId]['modules'] = this.dealWithModulePrivilege(roleId, modules);
            this.originalPrivilege[roleId]['templates'] = this.dealWithTemplatePrivilege(roleId, templates);
            this.originalPrivilege[roleId]['depandcroles'] = this.dealWithDepAndCRolePrivilege(roleId, depAndCRoles);
            this.originalPrivilege[roleId]['dataconnections'] = this.dealWithDataConnectionPrivilege(roleId, dataConnections);
        },

        getOriginalPrivilege: function() {
            if(!this.originalPrivilege) {
                this.originalPrivilege = {};
            }
            return this.originalPrivilege;
        },

        refreshOriginalPrivilege: function(privileges) {
            this.originalPrivilege = privileges;
        }
    },

    TABLETREESETTINGS : {
        getEntryTableTreeSetting : function(clickFunc, toolLength) {
            function filter(parentNode, node, newNodes, result) {
                if (!newNodes) {
                    return null;
                }

                if(!result) {
                    result = [];
                }
                for (var i = 0, l = newNodes.length; i < l; i++) {
                    var item = newNodes[i];
                    //department/entry
                    var zItem = {};
                    zItem.id = item.id;
                    zItem.pId = item.parentID || item.parentId;
                    zItem.name = item.text;
                    zItem.open = false;
                    zItem.type = item.type;
                    zItem.description = item.description;
                    if(item.edit !== 1) {
                        zItem.toolDisAbleIndex = toolLength - 1;
                    }
                    if(item.ChildNodes && item.ChildNodes.length > 0) {
                        filter(parentNode, node, item.ChildNodes, result);
                    }
                    if(FSPM.CONTROL._alreadyExists(zItem.id, result)) {
                        continue;
                    }
                    result.push(zItem);
                }
                return result;
            };
            return {
                async: {
                    enable: true,
                    url: FR.servletURL + "?op=fs_set&cmd=auth_getallreports",
                    dataFilter: filter
                },
                view: {
                    showIcon: false,  //ʾÿڵǰICON
                    selectedMulti: true
                },
                data: {
                    simpleData: {
                        enable: true,
                        idKey: "id",
                        pidKey: "pId",
                        rootPId: "0-1"
                    }
                },
                callback: {
                    onClick: clickFunc,
                    beforeClick: function() {
                        if(toolLength > 0) {
                            return false;
                        }
                    }
                }
            };
        },

        getTemplateTableTreeSetting: function() {
            function filter(parentNode, node, newNodes) {
                if (!newNodes) {
                    return null;
                }
                for (var i = 0, l = newNodes.length; i < l; i++) {
                    if(newNodes[i].hasChildren && newNodes[i].ChildNodes.length > 0) {
                        filter(null, null, newNodes[i].ChildNodes);
                    }
                    if(newNodes[i].page !== 1) {
                        newNodes[i].toolDisAbleIndex = 0;
                    }
                    if(newNodes[i].write !== 1) {
                        newNodes[i].toolDisAbleIndex = 1;
                    }
                    if(newNodes[i].design !== 1) {
                        newNodes[i].toolDisAbleIndex = 2;
                    }
                    delete newNodes[i].page;
                    delete newNodes[i].write;
                    delete newNodes[i].design;
                }
                return newNodes;
            }
            return {
                async: {
                    enable: true,
                    url: FR.servletURL + "?op=fs_entry&cmd=get_user_reports",
                    dataFilter: filter
                },
                data: {
                    key: {
                        children: "ChildNodes",
                        name: 'value'
                    },
                    simpleData: {
                        pIdKey: "pId"
                    }
                },
                view: {
                    showIcon: false,
                    selectedMulti: true
                },
                callback: {
                    beforeClick: function() {
                        return false;
                    }
                }
            };
        }
    },

    showEntryAuth : function(e, treeId, treeNode) {
        if(!treeNode) {
            return ;
        }
        var filterNodes = function(isDep, entryRoles) {
            var depNodes = [];
            var customRoleNodes = [];
            for(var i = 0, len = entryRoles.length; i < len; i ++) {
                if(entryRoles[i].departmentId != undefined) {
                    if(!isDep) {
                        continue ;
                    }
                    if(entryRoles[i].postId != undefined) {
                        entryRoles[i].id = entryRoles[i].departmentId + entryRoles[i].id;
                    }
                    depNodes.push(entryRoles[i]);
                } else {
                    customRoleNodes.push(entryRoles[i]);
                }
            }
            if(isDep) {
                return depNodes;
            } else {
                return customRoleNodes;
            }
        }
        var entryId = treeNode.id;
        var cacheEntryRolePrivilege = FSPM.CACHE.getEntryCache()[entryId];
        if(!cacheEntryRolePrivilege) {
            //ûл棬Ҫȥȡ
            var entryRoles = FS.Trans.getEntryRoles(entryId);
            //
            var companyRoles = filterNodes(true, entryRoles);
            var customRoles = filterNodes(false, entryRoles);
            FSPM.CACHE.keepOriginalEntryCache(entryId, companyRoles, true);
            FSPM.CACHE.keepOriginalEntryCache(entryId, customRoles, false);
            cacheEntryRolePrivilege = FSPM.CACHE.getEntryCache()[entryId];
        }
        FSPM.VIEW.reportTableTree.clearState();

        var authTabPane = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
        var nodes = [];
        if(authTabPane.getActiveIndex() === 0) {
            //
            FSPM.VIEW.departmentTableTree.clearState();
            FSPM.VIEW.departmentTableTree.selectNodesByData(cacheEntryRolePrivilege["companyRole"]);
        } else {
            var customRoleList = authTabPane.getWidgetByName(Constants.customRoleListWD);
            customRoleList.clearState();
            customRoleList.selectByData(cacheEntryRolePrivilege["customRole"]);
        }

    },

    showUserAuth : function(auth) {
        if(!auth) {
            return;
        }
        var entryAndModuleTabPane = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleViewOnlyTabWD);
        if(entryAndModuleTabPane.getActiveIndex() === 0) {
            //
            var entryTableTreeViewOnly = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryTableTreeViewOnlyWD);
            entryTableTreeViewOnly.clearState();
            entryTableTreeViewOnly.selectNodesByData(auth.entries);
        } else {
            //ƽ̨
            var moduleListViewOnly = FSPM.VIEW.tabPane.getWidgetByName(Constants.moduleListViewOnlyWD);
            moduleListViewOnly.clearState();
            moduleListViewOnly.selectByData(auth.modules);
        }
    },

    showEntryUser : function(e, treeId, treeNode) {
        var userListViewOnly = FSPM.VIEW.tabPane.getWidgetByName(Constants.userListViewOnlyWD);
        var entryId = treeNode.id;
        userListViewOnly.refresh({
            async: {
                url: FR.servletURL + "?op=fs_set&cmd=auth_getEntryUsers",
                data: {
                    entryId: entryId
                }
            }
        });
    },

    showModuleUser: function() {
        var moduleId = this.getValue();
        var userListViewOnly = FSPM.VIEW.tabPane.getWidgetByName(Constants.userListViewOnlyWD);
        userListViewOnly.refresh({
            async: {
                url: FR.servletURL + "?op=fs_set&cmd=auth_getModuleUsers",
                    data: {
                        moduleId: moduleId
                    }
            }
        });
    },

    VIEW : {
        //ý
        createSetPane: function(anchor) {
            var rowSize, contentHeight;
            if(FS.isPlatForm()) {
                rowSize = [0, 21, 25];
                contentHeight = 135;
            } else {
                rowSize = [0, 65, 21, 25];
                contentHeight = 215;
            }
            var items = [
                [
                    null,null,{el:$('<div/>')}
                ],
                [
                    null,
                    {
                        el: {
                            type: 'llabel',
                            value: FR.i18nText("Template-Privilege_Control")
                        }
                    },
                    {
                        el: {
                            type: 'radiogroup',
                            columnsInRow: 4,
                            width: 530,
                            value: -1,
                            widgetName: Constants.settingRadioGroupWD,
                            items: [
                                {
                                    value: Constants.templatePrivileges.NO_VERIFY_NEEDED,
                                    text: FR.i18nText("Template-Privilege_NoControl")
                                },
                                {
                                    value: Constants.templatePrivileges.USER_PASSWORD_VERIFY_NEEDED,
                                    text: FR.i18nText("Template-Privilege_UsernameAndPassword")
                                },
                                {
                                    value: Constants.templatePrivileges.ROLE_VERIFY_NEEDED,
                                    text: FR.i18nText("Template-Privilege_Role")
                                },
                                {
                                    value: Constants.templatePrivileges.DIGITAL_URL,
                                    text: FR.i18nText("Template-Privilege_DigitalSign")
                                }
                            ],
                            listeners: [
                                {eventName: FR.Events.AFTEREDIT,
                                    action: function () {
                                        var value = this.getValue();
                                        var cardLayout = floatPane.getWidgetByName(Constants.templateControlCardWD);
                                        if (value === Constants.templatePrivileges.ROLE_VERIFY_NEEDED) {
                                            cardLayout.showCardByIndex(1);
                                            cardLayout.getWidgetByName(Constants.dataConnectionSwitchWD).setValue(FS.isDataConnectionAuthorityOpen(), false);
                                        } else if(value == Constants.templatePrivileges.DIGITAL_URL) {
                                            cardLayout.showCardByIndex(2);
                                        } else {
                                            cardLayout.showCardByIndex(0);
                                        }
                                    }
                                }
                            ]
                        }
                    }
                ],
                [
                    null,
                    null,
                    {
                        el: {
                            width : 725,
                            height:25,
                            type : "card",
                            items:[
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: {
                                        type: 'absolute',
                                        items: [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    value: FR.i18nText("Template-Privilege_DataConnectionControl")
                                                },
                                                x: 0,
                                                y: 0
                                            },
                                            {
                                                el: {
                                                    type: 'switch',
                                                    widgetName: Constants.dataConnectionSwitchWD
                                                },
                                                x: 100,
                                                y: 0
                                            }
                                        ]
                                    }
                                },
                                {
                                    el: {
                                        type: 'absolute',
                                        items: [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    value: FR.i18nText("Template-Privilege_DigitalSignKeyUrl")
                                                },
                                                x: 0,
                                                y: 0
                                            },
                                            {
                                                el: {
                                                    type: 'text',
                                                    width: 300,
                                                    height: 21,
                                                    widgetName: Constants.keyURLTextEditorWD
                                                },
                                                x: 140,
                                                y: 0
                                            }
                                        ]
                                    }
                                }
                            ],
                            widgetName : Constants.templateControlCardWD,
                            defaultShowIndex : 0
                        }
                    }
                ]
            ];
            if(!FS.isPlatForm()) {
                //platformַּ֧Ȩ༭
                items.splice(1, 0, [
                    null,
                    {
                        el: {
                            type: 'llabel',
                            height: 24,
                            value: FR.i18nText("Grade_Authority_Manager")
                        }
                    },
                    {
                        el: {
                            type: 'tablelayout',
                            vgap: 12,
                            columnSize: [95, 130],
                            rowSize: [24, 24],
                            items: [
                                [
                                    {
                                        el: {
                                            type: 'llabel',
                                            value: FR.i18nText("Grade_Authority")
                                        }
                                    },
                                    {
                                        el: {
                                            type: 'switch',
                                            widgetName: Constants.gradeAuthoritySwitchWD,
                                            onTurnOff: function() {

                                            },
                                            onTurnOn: function() {
                                                if(!FS.hasGradeAuthority()){
                                                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("You_are_using_unregisted_function")+": "+FR.i18nText("Re-Multi-privilege"));
                                                    return false;
                                                }
                                            }
                                        }
                                    }
                                ],
                                [
                                    {
                                        el: {
                                            type: 'llabel',
                                            value: FR.i18nText("Template_Edit")
                                        }
                                    },
                                    {
                                        el: {
                                            type: 'switch',
                                            widgetName: Constants.editReportSwitchWD,
                                            onTurnOff: function() {

                                            },
                                            onTurnOn: function() {
                                                if(!FS.hasGradeAuthority()){
                                                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("You_are_using_unregisted_function")+": "+FR.i18nText("Re-Multi-privilege"));
                                                    return false;
                                                }
                                            }
                                        }

                                    }
                                ]
                            ]
                        }
                    }
                ]);
            }
            if(!FS.isGradeAuthorityOpen() || (FS.config.isAdmin == 'true')) {
                //ֻûּȨ޻ǹԱʱܿ
                var floatPane = FR.createWidget({
                    type: 'floatpane',
                    anchor: anchor,
                    contentHieght: contentHeight,
                    contentWidget: {
                        type: 'confirm',
                        fit: true,
                        doSize: true,
                        closeAfterAction: false,
                        btnsAlignment: 'left',
                        needSeparate: 8,
                        onOK: function() {
                            FSPM.CONTROL.setData(floatPane);
                        },
                        onCancel: function() {
                            floatPane.doSlide();
                        },
                        contentWidget: {
                            type: 'tablelayout',
                            scrolly: true,
                            widgetName: Constants.floatPaneTableLayoutWD,
                            columnSize: [40, 110, 530],
                            rowSize: rowSize,
                            vgap: 15,
                            items: items
                        }
                    }
                });
                FSPM.CONTROL.popSettingData(floatPane);
            }
        },
        //ȨãȨ޿ãûȨ޲鿴/ƽ̨ϵȨ޲鿴tabPane
        createTabPane : function(renderEl) {
            var self = this;
            this.renderEl = renderEl;
            var tabs = [this.privilegeConfig()];
            if(!FS.isPlatForm()) {
                tabs = tabs.concat([this.reportPrivilegeConfig(), this.userPrivilegeView(), this.entryAndModulePrivilegeView()]);
            }
            this.tabPane = new FS.LTabPane({
                width : '100%',
                height : '100%',
                vgap:21,
                items : tabs,
                renderEl : renderEl,
                initAfterActions : [
                    function() {
                        this.getWidgetByName(Constants.privilegeConfigTableWD).doLayout();
                        FSPM.VIEW.reportTableTree = this.getWidgetByName(Constants.entryTableTreeWD);
                        FSPM.VIEW.templateTableTree = this.getWidgetByName(Constants.templateTableTreeInPanelWD)
                            || this.getWidgetByName(Constants.templateTableTreeWD);
                    },
                    function() {
                        this.getWidgetByName(Constants.entryPrivilegeConfigTableWD).doLayout();
                        FSPM.VIEW.departmentTableTree = this.getWidgetByName(Constants.departmentTableTreeWD);
                    },
                    function() {
                        this.getWidgetByName(Constants.userPrivilegeViewHorizontalWD).doLayout();
                    },
                    function() {
                        this.getWidgetByName(Constants.entryAndModulePrivilegeViewHorizontalWD).doLayout();
                    }
                ],
                opAfterActions : [
                    function () {
                        if (!FS.isPlatForm()) {
                            var posAndRoleTab = this.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                            posAndRoleTab.options.afterTabClick[posAndRoleTab.getActiveIndex()].apply();
                        }
                    }, function () {
                        var posAndRoleTab = this.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
                        posAndRoleTab.options.afterTabClick[posAndRoleTab.getActiveIndex()].apply();
                    }, function () {
                        FSPM.VIEW.setUserPanelItemPrivilege();
                    }, function () {
                        this.getWidgetByName(Constants.userListViewOnlyWD).refresh();
                    }
                ],
                marginLeft : 0
            });
            this.renderEl.css("overflow", "hidden");
            this.renderEl.data("onResize", function(width, height) {
                var privilegeConfigPanel = self.tabPane.getWidgetByName(Constants.privilegeConfigPanelWD);
                if(privilegeConfigPanel) {
                    privilegeConfigPanel.doResize({
                        width:width,
                        height:height - 70
                    });
                }
                var entryPrivilegeConfigPanel = self.tabPane.getWidgetByName(Constants.entryPrivilegeConfigPanelWD);
                if(entryPrivilegeConfigPanel) {
                    entryPrivilegeConfigPanel.doResize({
                        width:width,
                        height:height - 70
                    });
                }
                var userPrivilegeHorizontal = self.tabPane.getWidgetByName(Constants.userPrivilegeViewHorizontalWD);
                if(userPrivilegeHorizontal) {
                    userPrivilegeHorizontal.doResize({
                       width: width,
                        height: height - 70
                    });
                }
                var entryAndModulePrivilegeViewHorizontal = self.tabPane.getWidgetByName(Constants.entryAndModulePrivilegeViewHorizontalWD);
                if(entryAndModulePrivilegeViewHorizontal) {
                    entryAndModulePrivilegeViewHorizontal.doResize({
                        width: width,
                        height: height - 70
                    });
                }
            });

        },

        //Ȩ
        privilegeConfig : function() {
            var items = [{el:$('<div/>')},this.privilegeReceptorTabPane()];
            if(!FS.isPlatForm()) {
                items.push(this.entryAndModuleTabPane())
            }
            if(FS.config.templatePrivilegeType == "1") {
                //ɫȨ޿ʱʾ
                if(FS.isDataConnectionAuthorityOpen()) {
                    items.push(this.templateAndDataConnectionTabPane());
                } else {
                    items.push(this.templatePanel());
                }
            }
            return {
                title : FR.i18nText("Privilege-Setting"),
                content : {
                    type: 'confirm',
                    widgetName: Constants.privilegeConfigPanelWD,
                    firstBtnMargin: 40,
                    needSeparate : 8,
                    btnsAlignment: 'left',
                    closeAfterAction: false,
                    width:this.renderEl.width(),
                    height:this.renderEl.height() - 70,
                    onOK : function() {
                        FSPM.CONTROL.saveAuth();
                    },
                    doSize: true,
                    text4Cancel:null,
                    text4OK:FR.i18nText("Save_With_Whitespace"),
                    contentWidget: {
                        type : 'tablelayout',
                        columnSize: [40, 270, 350, 350],
                        rowSize: [400],
                        widgetName : Constants.privilegeConfigTableWD,
                        scrollable: true,
                        items : [items]
                    }
                }
            }
        },

        //Ȩ޿
        reportPrivilegeConfig : function() {
            return {
                title : FR.i18nText("Privilege-Entry_Config"),
                content : {
                    type: 'confirm',
                    widgetName: Constants.entryPrivilegeConfigPanelWD,
                    firstBtnMargin: 40,
                    needSeparate : 8,
                    btnsAlignment: 'left',
                    closeAfterAction: false,
                    width:this.renderEl.width(),
                    height:this.renderEl.height() - 70,
                    onOK : function() {
                        FSPM.CONTROL.saveEntryAuth();
                    },
                    doSize: true,
                    text4Cancel:null,
                    text4OK:FR.i18nText("Save_With_Whitespace"),
                    contentWidget: {
                        type : 'tablelayout',
                        widgetName : Constants.entryPrivilegeConfigTableWD,
                        columnSize: [40, 310, 350],
                        rowSize: [400],
                        items : [[
                            {el:$('<div/>')},
                            this.entryPanel(),
                            this.positionAndCustomRoleTabPaneWithCheck()
                        ]],
                        scrollable: true
                    }
                }
            }
        },

        //ûȨ޲鿴
        userPrivilegeView : function() {
            return {
                title : FR.i18nText("Privilege-User_View"),
                content : {
                    type : 'horizontal',
                    hgap : 40,
                    alignment : "left",
                    scrolly: true,
                    widgetName : Constants.userPrivilegeViewHorizontalWD,
                    items : [
                        {el:$('<div/>'), width:0},
                        this.userPanel(),
                        this.entryAndModuleTabPaneViewOnly()
                    ],
                    height : 400,
                    width : 940
                }
            }
        },

        ///ƽ̨Ȩ޲鿴
        entryAndModulePrivilegeView : function() {
            return {
                title : FR.i18nText("Privilege-View"),
                content : {
                    type: 'horizontal',
                    hgap: 40,
                    alignment: 'left',
                    scrolly: true,
                    widgetName: Constants.entryAndModulePrivilegeViewHorizontalWD,
                    items: [
                        {el:$('<div/>'), width:0},
                        this.entryAndModuleTabPaneNoCheck(),
                        this.userPanelViewOnly()
                    ],
                    height: 400,
                    width: 940
                }
            }
        },

        //Ȩ
        privilegeReceptorTabPane : function() {
            if(FS.isPlatForm()) {
                //ƽ̨ʾְλ
                return this.customRolePanel();
            } else {
                return this.positionAndCustomRoleTabPane()
            }
        },

        //ƽ̨õģԶɫ
        customRolePanel : function() {
            var content = this.TABS._customRoleTab(228, 346, true, false).content;
            return {
                el: {
                    type: 'panel',
                    fit: false,
                    title: FR.i18nText("Role"),
                    width: 230,
                    height: 375,
                    border: true,
                    contentWidget: content,
                    widgetName: 'custonRolePanelWD'
                }
            }
        },

        //ְλ/Զɫ
        positionAndCustomRoleTabPane : function() {
            this.customRoleTab = this.TABS._customRoleTab(230, 342, true, false);
            return {
                el : {
                    type : 'insidetab',
                    items : [this.TABS._departmentAndPositionTab(228, 374, "departmentTableTree", false, FSPM.VIEW.showCompanyRoleAuth),
                        this.customRoleTab],
                    marginLeft : 0,
                    widgetName: Constants.positionAndCustomRoleInsideTabNoCheckWD,
                    width : 230,
                    height : 400,
                    afterTabClick: [
                        function () {
                            setTimeout(function() {
                                var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                FSPM.VIEW.showCompanyRoleAuth(treeNode);
                            }, 50);
                        }, function () {
                            setTimeout(function() {
                                var roleList = FSPM.VIEW.customRoleTab.content.resultWidgets.customRoleListNoCheckWD;
                                var roleId = roleList.getValue(),
                                    roleName = roleList.getText();
                                if (roleId !== null) {
                                    FSPM.VIEW.showCustomRoleAuth({
                                        id: roleId,
                                        name: roleName
                                    })
                                }
                            }, 50);
                        }
                    ]
                }
            };
        },

        //ƽ̨
        entryAndModuleTabPane : function() {
            var authorityTitle = $("<div/>").css({
                'textAlign': 'right',
                'paddingRight': '5px'
            });
            var entryToolLen = 1;
            var moduleToolLen = 1;
            authorityTitle.append(FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Face_View"), function() {
                    var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
                    if(entryAndModuleTab.getActiveIndex() === 0) {
                            if(FSPM.VIEW.reportTableTree.hasNodeSelect(0)) {
                                    FSPM.VIEW.reportTableTree.deSelectAll(0);
                                } else {
                                    FSPM.VIEW.reportTableTree.selectAll(0);
                                }
                            FSPM.VIEW.saveEntryCache();
                        } else {
                            var moduleList = entryAndModuleTab.getWidgetByName(Constants.moduleListWD);
                            if(moduleList.hasNodeSelect(moduleToolLen - 1)) {
                                    moduleList.deSelectAll(moduleToolLen - 1);
                                } else {
                                    moduleList.selectAll(moduleToolLen - 1);
                                }
                            FSPM.VIEW.saveModuleCache();
                        }
               }));
            if(FS.isGradeAuthorityOpen()) {
                entryToolLen ++;
                moduleToolLen ++;
                authorityTitle.append(FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Authorize"), function() {
                        var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
                        if(entryAndModuleTab.getActiveIndex() === 0) {
                                if(FSPM.VIEW.reportTableTree.hasNodeSelect(1)) {
                                        FSPM.VIEW.reportTableTree.deSelectAll(1);
                                    } else {
                                        FSPM.VIEW.reportTableTree.selectAll(1);
                                }
                            FSPM.VIEW.saveEntryCache();
                        } else {
                            var moduleList = entryAndModuleTab.getWidgetByName(Constants.moduleListWD);
                            if(moduleList.hasNodeSelect(0)) {
                                    moduleList.deSelectAll(0);
                                } else {
                                    moduleList.selectAll(0);
                                }
                            FSPM.VIEW.saveModuleCache();
                        }
                }));
            }
            var editPrivilege = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Edit"), function() {
                var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
                if(entryAndModuleTab.getActiveIndex() === 0) {
                        if(FSPM.VIEW.reportTableTree.hasNodeSelect(entryToolLen - 1)) {
                                FSPM.VIEW.reportTableTree.deSelectAll(entryToolLen - 1);
                            } else {
                                FSPM.VIEW.reportTableTree.selectAll(entryToolLen - 1);
                            }
                        FSPM.VIEW.saveEntryCache();
                    }
            });
            if(FS.isEditReportAuthorityOpen()) {
                entryToolLen ++;
                authorityTitle.append(editPrivilege);
            }

            return {
                el : {
                    type : 'insidetab',
                    widgetName: Constants.entryAndModuleInsideTabWD,
                    items : [
                        this.TABS._entryTab(Constants.entryTableTreeWD, 90, 308, 374, "entryTableTree", false, true),
                        this.TABS._moduleTab(Constants.moduleListWD, 100, 308, 374, false, true),
                        {
                            title : authorityTitle,
                            keepActive : true,
                            borderWidth : 2,
                            width : 120
                        }
                    ],
                    afterTabClick: [
                        function() {
                            if(FSPM.VIEW.tabPane) {
                                setTimeout(function() {
                                    editPrivilege.show();
                                    var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                                    var roleId;
                                    if(positionAndCustomRoleInsideTab && positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                        var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                        if(!treeNode) {
                                            return;
                                        }
                                        roleId = treeNode.id;
                                    } else {
                                        var customRoleList;
                                        if(FS.isPlatForm()) {
                                            customRoleList = FSPM.VIEW.tabPane.getWidgetByName(Constants.customRoleListNoCheckWD);
                                        } else {
                                            customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD);
                                        }
                                        roleId = customRoleList.getValue();
                                    }
                                    if(!roleId) {
                                        return ;
                                    }
                                    FSPM.VIEW._showEntryPrivilege(roleId);
                                }, 50);
                            }
                        },
                        function() {
                            if(FSPM.VIEW.tabPane) {
                                setTimeout(function() {
                                    editPrivilege.hide();
                                    var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                                    var entryAndModuleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
                                    if(FS.isGradeAuthorityOpen() && !FSPM.VIEW.depAndCRolePane) {
                                        //ּȨ޿ˣӲ/Զɫ
                                        FSPM.VIEW.depAndCRolePane = FSPM.VIEW.createDepAndCRolePane();
                                        FSPM.VIEW.depAndCRolePane.hide();
                                        entryAndModuleInsideTab.getActiveTab().append(FSPM.VIEW.depAndCRolePane);
                                    }
                                    var roleId;
                                    if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                        var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                        if(!treeNode) {
                                            return;
                                        }
                                        roleId = treeNode.id;
                                    } else {
                                        var customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD);
                                        roleId = customRoleList.getValue();
                                    }
                                    if(!roleId) {
                                        return ;
                                    }
                                    FSPM.VIEW._showModulePrivilege(roleId);
                                }, 50);
                            }
                        }
                    ],
                    marginLeft : 0,
                    width : 310,
                    height : 400
                }
            }
        },

        //ƽֻ̨ܲ鿴
        entryAndModuleTabPaneViewOnly : function() {
            var authorityTitle = $("<div/>").css({
                'textAlign': 'right',
                'paddingRight': '5px'
            });
            var entryText = FR.i18nText("Face_View");
            var moduleText = entryText;
            if(FS.isGradeAuthorityOpen()) {
                entryText = entryText + " " + FR.i18nText("Authorize");
                moduleText = entryText;
            }
            if(FS.isEditReportAuthorityOpen()) {
                entryText = entryText + " " + FR.i18nText("Edit");
            }
            authorityTitle.text(entryText);
            return {
                el : {
                    type : 'insidetab',
                    widgetName: Constants.entryAndModuleViewOnlyTabWD,
                    items : [
                        this.TABS._entryTab(Constants.entryTableTreeViewOnlyWD, 90, 308, 374, "entryTableTreeViewOnly", true, true),
                        this.TABS._moduleTab(Constants.moduleListViewOnlyWD, 100, 308, 374, true, true),
                        {
                            title : authorityTitle,
                            keepActive : true,
                            borderWidth : 2,
                            width : 120
                        }
                    ],
                    afterTabClick: [
                        function() {
                            authorityTitle.text(entryText);
                            if(FSPM.VIEW.userAuth) {
                                FSPM.showUserAuth(FSPM.VIEW.userAuth);
                            }
                        },
                        function() {
                            authorityTitle.text(moduleText);
                            if(FSPM.VIEW.userAuth) {
                                FSPM.showUserAuth(FSPM.VIEW.userAuth);
                            }
                        }
                    ],
                    marginLeft : 0
                },
                width : 310,
                height : 400
            }
        },

        entryAndModuleTabPaneNoCheck : function() {
            return {
                el : {
                    type : 'insidetab',
                    items : [
                        this.TABS._entryTab(Constants.entryTableTreeNoCheckWD, 115, 228, 374, "entryTableTreeNoCheck", true, false, FSPM.showEntryUser),
                        this.TABS._moduleTab(Constants.moduleListNoCheckWD, 115, 228, 374, false, false, FSPM.showModuleUser)
                    ],
                    marginLeft : 0
                },
                width : 230,
                height : 400
            }
        },

        templatePanel: function() {
            return {
                el: {
                    tools: [{
                        text: FR.i18nText("Face_View"),
                        width: 30,
                        iconCls: 'fs_privilegemanager_paneltitle',
                            handler: function() {
                                if(FSPM.VIEW.templateTableTree.hasNodeSelect(0)) {
                                        FSPM.VIEW.templateTableTree.deSelectAll(0);
                                    } else {
                                        FSPM.VIEW.templateTableTree.selectAll(0);
                                    }
                                FSPM.VIEW.saveTemplateCache();
                            }
                    },{
                        text: FR.i18nText("Face_Write"),
                        width: 30,
                        iconCls: 'fs_privilegemanager_paneltitle',
                        handler: function() {
                            if(FSPM.VIEW.templateTableTree.hasNodeSelect(1)) {
                                    FSPM.VIEW.templateTableTree.deSelectAll(1);
                                } else {
                                    FSPM.VIEW.templateTableTree.selectAll(1);
                                }
                            FSPM.VIEW.saveTemplateCache();
                        }
                    },{
                        text: FR.i18nText("Privilege_Design"),
                        width: 30,
                        iconCls: 'fs_privilegemanager_paneltitle',
                        handler: function() {
                            if(FSPM.VIEW.templateTableTree.hasNodeSelect(2)) {
                                    FSPM.VIEW.templateTableTree.deSelectAll(2);
                                } else {
                                    FSPM.VIEW.templateTableTree.selectAll(2);
                                }
                            FSPM.VIEW.saveTemplateCache();
                        }
                    }],
                    type: 'panel',
                    fit: false,
                    title: FR.i18nText("Template"),
                    border: true,
                    titleHeight: 25,
                    width : 310,
                    height : 375,
                    contentWidget: {
                        type: 'fstabletree',
                        height: 374,
                        width : 308,
                        fit: false,
                        treeID: 'templateTableTreeInPanel',
                        widgetName: Constants.templateTableTreeInPanelWD,
                        setting: FSPM.TABLETREESETTINGS.getTemplateTableTreeSetting(),
                        tooltype: 'check',
                        toolMargin:10,
                        tools: [
                            {
                                name: 'page',
                                //༭ť¼
                                onToolClick: function (e, treeNode, isSelect) {
                                    if(!isSelect && (treeNode["design"] !== 0)) {
                                        FSPM.VIEW.templateTableTree.cancelSelectedNodeWithCascade(treeNode, 2);
                                    }
                                    e.stopEvent();
                                }
                            },
                            {
                                name: 'write',
                                //༭ť¼
                                onToolClick: function (e, treeNode, isSelect) {
                                    if(!isSelect && (treeNode["design"] !== 0)) {
                                        FSPM.VIEW.templateTableTree.cancelSelectedNodeWithCascade(treeNode, 2);
                                    }
                                    e.stopEvent();
                                }
                            },
                            {
                                name: 'design',
                                //༭ť¼
                                onToolClick: function (e, treeNode, isSelect) {
                                    if(isSelect) {
                                        if(treeNode["page"] !== 1) {
                                            FSPM.VIEW.templateTableTree.selectNodeWithCascade(treeNode, true, 0);
                                        }
                                        if(treeNode["write"] !== 1) {
                                            FSPM.VIEW.templateTableTree.selectNodeWithCascade(treeNode, true, 1);
                                        }
                                    }
                                    e.stopEvent();
                                }
                            }
                        ],
                        onItemToolClick: function() {
                            var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                            var roleId;
                            if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                //ְλ
                                var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                if(!treeNode) {
                                    return;
                                }
                                roleId = treeNode.id;
                            } else {
                                //Զɫ
                                roleId = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                            }
                            if(roleId) {
                                FSPM.CACHE.setTemplatePrivilege(roleId, FSPM.VIEW.templateTableTree.getSelectedNodes());
                            }
                        }
                    }
                }
            }
        },

        //ģ壬
        templateAndDataConnectionTabPane : function() {
            var pageTitle = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Face_View"), function() {
                var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
                if(templateAndDataConnectionTab.getActiveIndex() === 0) {
                            if(FSPM.VIEW.templateTableTree.hasNodeSelect(0)) {
                                FSPM.VIEW.templateTableTree.deSelectAll(0);
                            } else {
                                FSPM.VIEW.templateTableTree.selectAll(0);
                            }
                        FSPM.VIEW.saveTemplateCache();
                    } else {
                            var dataConnectionList = templateAndDataConnectionTab.getWidgetByName(Constants.dataConnectionListWD);
                        if(dataConnectionList.hasNodeSelect(0)) {
                                dataConnectionList.deSelectAll(0);
                            } else {
                                dataConnectionList.selectAll(0);
                            }
                        FSPM.VIEW.saveDataConnectionCache();
                    }
            });

            var writeTitle = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Face_Write"), function() {
                var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
                if(templateAndDataConnectionTab.getActiveIndex() === 0) {
                            if(FSPM.VIEW.templateTableTree.hasNodeSelect(1)) {
                                FSPM.VIEW.templateTableTree.deSelectAll(1);
                            } else {
                                FSPM.VIEW.templateTableTree.selectAll(1);
                            }
                        FSPM.VIEW.saveTemplateCache();
                    }
            });

            var designTitle = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Privilege_Design"), function() {
                var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
                if(templateAndDataConnectionTab.getActiveIndex() === 0) {
                            if(FSPM.VIEW.templateTableTree.hasNodeSelect(2)) {
                                FSPM.VIEW.templateTableTree.deSelectAll(2);
                            } else {
                                FSPM.VIEW.templateTableTree.selectAll(2);
                            }
                        FSPM.VIEW.saveTemplateCache();
                    }
            });
            var authorityTitle = $("<div/>").css({
                'textAlign': 'right',
                'paddingRight': '5px'
            }).append(pageTitle).append(writeTitle).append(designTitle);


            return {
                el: {
                    type: 'insidetab',
                    widgetName: Constants.templateAndDataConnectionInsideTabWD,
                    items: [
                        this.TABS._templateTab(),
                        this.TABS._dataConnectionTab(),
                        {
                            title : authorityTitle,
                            keepActive : true,
                            borderWidth : 2,
                            width : 145
                        }
                    ],
                    afterTabClick: [
                        function() {
                            setTimeout(function() {
                                if(!FSPM.VIEW.tabPane) {
                                    return ;
                                }
                                writeTitle.show();
                                designTitle.show();
                                var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                                var roleId;
                                if(positionAndCustomRoleInsideTab && positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                    var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                    if(!treeNode) {
                                        return;
                                    }
                                    roleId = treeNode.id;
                                } else {
                                    var customRoleList = FSPM.VIEW._getCustomRoleList();
                                    roleId = customRoleList.getValue();
                                }
                                if(!roleId) {
                                    return ;
                                }
                                FSPM.VIEW._showTemplatePrivilege(roleId);
                            }, 50);
                        }, function() {
                            setTimeout(function() {
                                if(!FSPM.VIEW.tabPane) {
                                    return ;
                                }
                                writeTitle.hide();
                                designTitle.hide();
                                var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                                var roleId;
                                if(positionAndCustomRoleInsideTab && positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                    var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                    if(!treeNode) {
                                        return;
                                    }
                                    roleId = treeNode.id;
                                } else {
                                    var customRoleList = FSPM.VIEW._getCustomRoleList();
                                    roleId = customRoleList.getValue();
                                }
                                if(!roleId) {
                                    return ;
                                }
                                FSPM.VIEW._showDataConnectionPrivilege(roleId);
                            }, 50);
                        }
                    ],
                    marginLeft: 0,
                    width: 310,
                    height: 400
                }
            }
        },

        //
        entryPanel : function() {
            var reportSetting = FSPM.TABLETREESETTINGS.getEntryTableTreeSetting(FSPM.showEntryAuth);
            return {
                el: {
                    type: 'panel',
                    fit: false,
                    title: FR.i18nText("Report"),
                    width: 270,
                    height: 375,
                    border: true,
                    contentWidget: {
                        type: 'fstabletree',
                        height: 374,
                        width : 268,
                        fit: false,
                        treeID: 'entryTableTreeNoCheckInPanel',
                        widgetName: Constants.entryTableTreeNoCheckInPanelWD,
                        setting: reportSetting
                    }
                }
            }
        },

        //û
        userPanel : function() {
            var self = this;
            var items = [
                {
                    region: 'north',
                    el: {
                        type: 'search',
                        width: 230,
                        autoSearch: true,
                        onKeyup: function(e){
                            if(FSPM.VIEW.searchId != null) {
                                clearTimeout(FSPM.VIEW.searchId);
                                FSPM.VIEW.searchId = null;
                            }
                            FSPM.VIEW.searchId = setTimeout(function () {
                                if (!FR.isNavKeyPress(e)) {
                                    var val = this.getValue();
                                    var userList = FSPM.VIEW.tabPane.getWidgetByName(Constants.userListNoCheckWD);
                                    userList.refresh({
                                        async: {
                                            url: FR.servletURL + "?op=fs_set&cmd=auth_getallusers",
                                            data: {
                                                keyword: val
                                            }
                                        }
                                    });
                                }
                            }.createDelegate(this), 200);
                        }
                    },
                    height: 28
                },
                {
                    region: 'center',
                    el : {
                        type: 'quicklist',
                        width: 228,
                        fit: false,
                        scrollLoading: true,
                        widgetName: Constants.userListNoCheckWD,
                        async: {
                            url: FR.servletURL + "?op=fs_set&cmd=auth_getallusers"
                        },
                        dataFilter: function(item){
                            return {
                                text: (item.realname||"")+'('+item.username+')',
                                value: item.id,
                                id: item.id
                            }
                        },
                        itemCanBeSelect: true,
                        onCustomItemSelect: self.setUserPanelItemPrivilege
                    }
                }
            ];

            return {
                el: {
                    type: 'panel',
                    fit: false,
                    title: FR.i18nText("User"),
                    width: 270,
                    height: 375,
                    border: true,
                    contentWidget: {
                        type : 'border',
                        items : items,
                        width: 270
                    }
                },
                width: 270,
                height: 400
            }
        },

        setUserPanelItemPrivilege: function () {
            var dealWithEntryType = function(entries) {
                for(var i = 0; i < entries.length; i ++) {
                    if(entries[i].type !== 0) {
                        entries[i].id = entries[i].type + entries[i].id + "";
                    }
                    if(entries[i].view === 2 || entries[i].design === 2 || entries[i].edit === 2) {
                        entries.splice(i, 1);
                        i = i-1;
                    }
                }
            };
            var userId = FSPM.VIEW.tabPane.getWidgetByName(Constants.userListNoCheckWD).getValue();
            if (userId != null) {
                FSPM.VIEW.userAuth = FS.Trans.getUserAuths(userId);
                dealWithEntryType(FSPM.VIEW.userAuth.entries);
                FSPM.showUserAuth(FSPM.VIEW.userAuth);
            }
        },

        //û壬ֻԲ鿴ӵеı/ƽ̨Ȩ
        userPanelViewOnly : function() {
            var tools = [{
                name:"view",
                width:20
            }
            ];
            if(FS.isGradeAuthorityOpen()) {
                tools.unshift({
                    name:"design",
                    width:20
                });
            }
            if(FS.isEditReportAuthorityOpen()) {
                tools.unshift({
                    name:"edit",
                    width:20
                });
            }
            var panelTools = [{
                text: FR.i18nText("Face_View"),
                width: 30,
                iconCls: 'fs_privilegemanager_paneltitle'
            }];
            if(FS.isGradeAuthorityOpen()) {
                //Ȩ
                panelTools.push({
                    text: FR.i18nText("Authorize"),
                    width: 30,
                    iconCls: 'fs_privilegemanager_paneltitle'
                });
            }
            if(FS.isEditReportAuthorityOpen()) {
                //༭
                panelTools.push({
                    text: FR.i18nText("Edit"),
                    width: 30,
                    iconCls: 'fs_privilegemanager_paneltitle'
                });
            }
            return {
                el: {
                    type: 'panel',
                    fit: false,
                    title: FR.i18nText("User"),
                    width: 350,
                    height: 375,
                    border: true,
                    tools: panelTools,
                    contentWidget: {
                        tooltype: 'check',
                        alwaysShowTools: true,
                        toolMargin:10,
                        tools: tools,
                        toolUnEditAble: true,
                        onItemToolClick: function (toolindex, index, isSelected, e) {
                        },
                        type: 'quicklist',
                        scrollLoading: true,
                        widgetName: Constants.userListViewOnlyWD,
                        height: 374,
                        width: 308,
                        fit: false,
                        itemCanBeSelect: true,
                        async: {
                            url: FR.servletURL + "?op=fs_set&cmd=auth_getEntryUsers"
                        },
                        dataFilter: function(item){
                            return {
                                text: (item.realname||"")+'('+item.username+')',
                                value: item.id,
                                id: item.id,
                                view: item.view,
                                design: item.design,
                                edit: item.edit
                            }
                        }
                    }
                },
                width: 350,
                height: 400
            }
        },

        //ְλбԶɫcheckboxĹ߰ť
        positionAndCustomRoleTabPaneWithCheck : function() {
            var authorityTitle = $("<div/>").css({
                'textAlign': 'right',
                'paddingRight': '5px'
            });
            var toolLen = 1;
            var viewTitle = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Face_View"), function() {
                var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
                if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                            if(FSPM.VIEW.departmentTableTree.hasNodeSelect(0)) {
                                FSPM.VIEW.departmentTableTree.deSelectAll(0);
                            } else {
                                FSPM.VIEW.departmentTableTree.selectAll(0);
                            }
                        FSPM.VIEW.saveEntryDepartmentCache();
                    } else {
                        var customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListWD);
                        if(customRoleList.hasNodeSelect(toolLen - 1)) {
                                customRoleList.deSelectAll(toolLen -1 );
                            } else {
                                customRoleList.selectAll(toolLen - 1);
                            }
                        FSPM.VIEW.saveEntryCustomRoleCache();
                    }
            });

            authorityTitle.append(viewTitle);
            if(FS.isGradeAuthorityOpen()) {
                toolLen ++;
                var designTitle = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Authorize"), function() {
                        var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
                        if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                            if(FSPM.VIEW.departmentTableTree.hasNodeSelect(1)) {
                                FSPM.VIEW.departmentTableTree.deSelectAll(1);
                            } else {
                                FSPM.VIEW.departmentTableTree.selectAll(1);
                            }
                            FSPM.VIEW.saveEntryDepartmentCache();
                        } else {
                            var customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListWD);
                            if(customRoleList.hasNodeSelect(toolLen - 2)) {
                                    customRoleList.deSelectAll(toolLen - 2);
                                } else {
                                    customRoleList.selectAll(toolLen - 2);
                                }
                            FSPM.VIEW.saveEntryCustomRoleCache();
                        }
                });

                authorityTitle.append(designTitle);
            }
            if(FS.isEditReportAuthorityOpen()) {
                toolLen ++;
                var editTitle = FSPM.MODEL.TabTitle.createTitle(FR.i18nText("Edit"), function() {
                        var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
                        if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                    if(FSPM.VIEW.departmentTableTree.hasNodeSelect(toolLen - 1)) {
                                        FSPM.VIEW.departmentTableTree.deSelectAll(toolLen - 1);
                                    } else {
                                        FSPM.VIEW.departmentTableTree.selectAll(toolLen - 1);
                                    }

                            } else {
                            var customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListWD);
                            if(customRoleList.hasNodeSelect(0)) {
                                    customRoleList.deSelectAll(0);
                                } else {
                                    customRoleList.selectAll(0);
                                }
                            FSPM.VIEW.saveEntryCustomRoleCache();
                        }
                });

                authorityTitle.append(editTitle);
            }

            return {
                el : {
                    type: 'insidetab',
                    widgetName: Constants.positionAndCustomRoleInsideTabWD,
                    items: [
                        this.TABS._departmentAndPositionTab(348, 374, "departmentTableTreeWithCheck", true, FR.emptyFn),
                        this.TABS._customRoleTab(350, 374, false, true),
                        {
                            title : authorityTitle,
                            keepActive : true,
                            borderWidth : 2,
                            width : 120
                        }
                    ],
                    width : 350,
                    height : 400,
                    marginLeft : 0,
                    afterTabClick: [
                        function() {
                            setTimeout(function() {
                                var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryTableTreeNoCheckInPanelWD).getSelectedNodes()[0];
                                FSPM.showEntryAuth(null, null, treeNode);
                            }, 50);
                        },
                        function() {
                            if(FSPM.VIEW.tabPane) {
                                setTimeout(function() {
                                    var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryTableTreeNoCheckInPanelWD).getSelectedNodes()[0];
                                    FSPM.showEntryAuth(null, null, treeNode);
                                }, 50);
                            }
                        }
                    ]
                }
            }
        },

        createDepAndCRolePane : function() {
            var pane = $("<div/>").addClass(Constants.depAndCRolePaneCls);
            $("<div/>").addClass(Constants.depAndCRolePaneTitleCls).text(FR.i18nText("Department_or_Roles")).appendTo(pane);
            var filter = function(parentNode, node, newNodes, result) {
                if (!newNodes) {
                    return null;
                }

                if(!result) {
                    result = [];
                }
                for (var i = 0, l = newNodes.length; i < l; i++) {
                    var item = newNodes[i];
                    var zItem = {};
                    zItem.id = item.id;
                    zItem.pId = item.parentID;
                    zItem.name = item.text;
                    zItem.open = false;
                    if(item.ChildNodes && item.ChildNodes.length > 0) {
                        filter(parentNode, node, item.ChildNodes, result);
                    }
                    if(FSPM.CONTROL._alreadyExists(zItem.id, result)) {
                        continue;
                    }
                    result.push(zItem);
                }
                return result;
            };
            FSPM.VIEW.departRoleTableTree = new FS.TableTree({
                treeID: 'departRoleTableTree',
                widgetName: Constants.depAndCRoleTableTreeWD,
                renderEl: pane,
                setting: {
                    view: {
                        showIcon: false,  //ʾÿڵǰICON
                        selectedMulti: true
                    },
                    data : {
                        simpleData : {
                            enable : true,
                            idKey : "id",
                            pidKey : "pId",
                            rootPId : -2
                        }
                    },
                    async: {
                        enable: true,
                        url: FR.servletURL + "?op=fs_set&cmd=auth_getdepandcusrole",
                        dataFilter: filter
                    },
                    callback: {
                        onAsyncSuccess: function() {
                            var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                            if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                                var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                                if(!treeNode) {
                                    return ;
                                }
                                FSPM.VIEW._showDepAndCRolePrivilege(treeNode.id);
                            } else {
                                var customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD);
                                FSPM.VIEW._showDepAndCRolePrivilege(customRoleList.getValue());
                            }
                        }
                    }
                },
                height: '100%',
                width: '100%',
                fit: true,
                tooltype: 'check',
                tools: [
                    {
                        onToolClick: function (e) {
                            e.stopEvent();
                        }
                    }
                ],
                onItemToolClick: function () {
                    var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                    var roleId;
                    if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                        //ְλ
                        var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                        if(!treeNode) {
                            return ;
                        }
                        roleId = treeNode.id;
                    } else {
                        //Զɫ
                        roleId = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                    }
                    FSPM.CACHE.setDepAndCRolePrivilege(roleId, FSPM.VIEW.departRoleTableTree.getFullSelectedNodes());
                }
            });
            return pane;
        },

        _getAllLeafNodesFromTreedata : function(treedata, result) {
            if(!result) {
                result = [];
            }
            for(var i = 0, len = treedata.length; i < len; i ++) {
                var item = treedata[i];
                if(item.ChildNodes) {
                    result.push(item);
                    this._getAllLeafNodesFromTreedata(item.ChildNodes, result);
                } else {
                    result.push(item);
                }
            }
            return result;
        },

        _needShowDepAndCRolePane : function(roleId) {
            var cacheCompanyModulePrivilege = FSPM.CACHE.getModulePrivilege(roleId);
            if(!cacheCompanyModulePrivilege) {
                 return false;
            }
            for(var i = 0; i < cacheCompanyModulePrivilege.length; i ++) {
                if(cacheCompanyModulePrivilege[i] && cacheCompanyModulePrivilege[i].id === 18) {
                    return true;
                }
            }
            return false;
        },

        showCustomRoleAuth : function(customRole) {
            if(!customRole) {
                return ;
            }

            var rolePrivilegeCache = FSPM.CACHE.getRolePrivilege(customRole.id);
            if(!rolePrivilegeCache) {
                var customRolePrivilege = FS.Trans.getCustomRoleAuth(customRole);
                FSPM.CACHE.cachePrivilege(customRole.id, customRolePrivilege);
            }

            if(!FS.isPlatForm()) {
                //ȨǱƽ̨
                var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);

                var privilegeTypes = {
                    Entry: 0,
                    Module: 1
                };
                var privilegeType;
                if(entryAndModuleTab.getActiveIndex() === 0) {
                    privilegeType = privilegeTypes.Entry;
                } else {
                    privilegeType = privilegeTypes.Module;
                }

                if(privilegeType === privilegeTypes.Entry) {
                    FSPM.VIEW._showEntryPrivilege(customRole.id);
                } else {
                    FSPM.VIEW._showModulePrivilege(customRole.id);
                }
            }

            if(FS.isDataConnectionAuthorityOpen()) {
                var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
                if(templateAndDataConnectionTab.getActiveIndex() === 0) {
                    //ģ
                    FSPM.VIEW._showTemplatePrivilege(customRole.id);
                } else {
                    //
                    FSPM.VIEW._showDataConnectionPrivilege(customRole.id);
                }
            } else {
                FSPM.VIEW._showTemplatePrivilege(customRole.id);
            }
        },

        _showEntryPrivilege : function(roleId) {
            var cacheEntryPrivileges = FSPM.CACHE.getEntryPrivilege(roleId);
            FSPM.VIEW.reportTableTree.clearState();
            var reportsForTree = [];
            for(var i = 0; i < cacheEntryPrivileges.length; i ++) {
                //cacheûtypeҪ
                var temp = $.extend({}, cacheEntryPrivileges[i]);
                if(temp.id && !("" + temp.id).startWith("0")) {
                    temp.id = temp.type + "" + temp.id;
                }
                reportsForTree.push(temp);
            }
            FSPM.VIEW.reportTableTree.selectNodesByData(reportsForTree);
        },

        _showModulePrivilege : function(roleId) {
            var cacheCompanyModulePrivilege = FSPM.CACHE.getModulePrivilege(roleId);
            var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
            var moduleList = entryAndModuleTab.getWidgetByName(Constants.moduleListWD);
            moduleList.clearState();
            if(FS.isGradeAuthorityOpen()) {
                FSPM.VIEW._showDepAndCRolePrivilege(roleId);
            }
            moduleList.selectByData(cacheCompanyModulePrivilege);
        },

        _showDepAndCRolePrivilege : function(roleId) {
            if(!roleId) {
                return;
            }
            var cacheDepAndCRolePrivilege = FSPM.CACHE.getDepAndCRolePrivilege(roleId);
            if(!this._needShowDepAndCRolePane(roleId)) {
                FSPM.VIEW.depAndCRolePane.hide();
                return ;
            }
            FSPM.VIEW.departRoleTableTree.clearState();
            FSPM.VIEW.depAndCRolePane.show();
            var nodes = FSPM.VIEW.departRoleTableTree.transformToArray(FSPM.VIEW.departRoleTableTree.getNodes());
            for(var m = 0; m < cacheDepAndCRolePrivilege.length; m ++) {
                for(var i = 0; i < nodes.length; i ++) {
                    if(cacheDepAndCRolePrivilege[m]+"" === nodes[i].id+"") {
                        FSPM.VIEW.departRoleTableTree.selectNodeWithCascade(nodes[i], true, 0);
                        break ;
                    }
                }
            }
        },

        _showTemplatePrivilege : function(roleId) {
            if(FSPM.VIEW.templateTableTree) {
                var templatePrivilege = FSPM.CACHE.getTemplatePrivilege(roleId);
                FSPM.VIEW.templateTableTree.clearState();
                //pop
                FSPM.VIEW.templateTableTree.selectNodesByPath(templatePrivilege);
            }
        },

        _showDataConnectionPrivilege : function(roleId) {
            var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
            var dataConnectionList = templateAndDataConnectionTab.getWidgetByName(Constants.dataConnectionListWD);
            var dataConnectionPrivilege = FSPM.CACHE.getDataConnectionPrivilege(roleId);
            var listdata = [];
            for(var i = 0, len = dataConnectionPrivilege.length; i < len; i ++) {
                listdata.push({
                    text: dataConnectionPrivilege[i],
                    view: 1
                })
            }
            dataConnectionList.clearState();
            dataConnectionList.selectByText(listdata);
        },

        showCompanyRoleAuth : function(treeNode) {
            if(!treeNode) {
                return ;
            }
            //ȨǱƽ̨
            var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);

            var privilegeTypes = {
                Entry: 0,
                Module: 1
            };
            var privilegeType;
            if(entryAndModuleTab.getActiveIndex() === 0) {
                privilegeType = privilegeTypes.Entry;
            } else {
                privilegeType = privilegeTypes.Module;
            }
            var rolePrivilegeCache = FSPM.CACHE.getRolePrivilege(treeNode.id);
            if(!rolePrivilegeCache) {
                var departmentId, postId;
                if(treeNode.isParent) {
                    //ѡǲţְλIdְλ
                    departmentId = treeNode.id.substring(0, treeNode.id.indexOf(Constants.postIdPrefix));
                } else {
                    //ѡְλIDParentNodeID
                    departmentId = treeNode.id.substring(0, treeNode.id.indexOf(Constants.postIdPrefix));
                    postId = treeNode.id.substr(Constants.postIdPrefix.length + treeNode.id.indexOf(Constants.postIdPrefix));
                }
                var companyRolePrivilege = FS.Trans.getCompanyRoleAuth(departmentId, postId);
                FSPM.CACHE.cachePrivilege(treeNode.id, companyRolePrivilege);
            }

            if(privilegeType === privilegeTypes.Entry) {
                FSPM.VIEW._showEntryPrivilege(treeNode.id);
            } else {
                FSPM.VIEW._showModulePrivilege(treeNode.id);
            }
            if(FS.config.templatePrivilegeType == "1") {
                if(FS.isDataConnectionAuthorityOpen()) {
                    var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
                    if(templateAndDataConnectionTab.getActiveIndex() === 0) {
                        //ģ
                        FSPM.VIEW._showTemplatePrivilege(treeNode.id);
                    } else {
                        //
                        FSPM.VIEW._showDataConnectionPrivilege(treeNode.id);
                    }
                } else {
                    FSPM.VIEW._showTemplatePrivilege(treeNode.id);
                }
            }

        },

        TABS : {
            //ְλбTab
            _departmentAndPositionTab : function(contentWidth, contentHeight, treeID, hasTool, clickFunc) {
                function filter(parentNode, node, newNodes, result) {
                    if (!newNodes) {
                        return null;
                    }

                    if(!result) {
                        result = [];
                    }
                    var postAllArray = [];
                    for (var i = 0, l = newNodes.length; i < l; i++) {
                        var item = newNodes[i];
                        if(item.postId) {
                            var postItem = {};
                            postItem.id = item.departmentId + Constants.postIdPrefix + item.postId;
                            postItem.pId = item.departmentId + Constants.postIdPrefix;
                            postItem.open = false;
                            postItem.name = item.postName;
                            if(FSPM.CONTROL._alreadyExists(postItem.id, result)) {
                                continue;
                            }
                            result.push(postItem);
                            var postInDepartAll = {};
                            postInDepartAll.id = Constants.departmentAllID + Constants.postIdPrefix + item.postId;
                            postInDepartAll.pId = Constants.departmentAllID + Constants.postIdPrefix;
                            postInDepartAll.open = false;
                            postInDepartAll.name = item.postName;
                            if(!FSPM.CONTROL._alreadyExists(postInDepartAll.id, result)) {
                                result.push(postInDepartAll);
                            }
                        }
                        //department/entry
                        var zItem = {};
                        zItem.id = item.departmentId + Constants.postIdPrefix;
                        zItem.pId = item.departmentPId + Constants.postIdPrefix;
                        zItem.name = item.departmentName;
                        zItem.open = false;
                        zItem.description = item.description;
                        if(hasTool) {
                            //ְ
                            var postAllInDepartment = {};
                            postAllInDepartment.id = item.departmentId + Constants.postIdPrefix + Constants.postAllID;
                            postAllInDepartment.pId = item.departmentId + Constants.postIdPrefix;
                            postAllInDepartment.name = FR.i18nText("Platform_Post_All");
                            postAllInDepartment.open = false;
                            if(!FSPM.CONTROL._alreadyExists(postAllInDepartment.id, postAllArray)) {
                                postAllArray.push(postAllInDepartment);
                            }
                        }
                        if(item.ChildNodes && item.ChildNodes.length > 0) {
                            filter(parentNode, node, item.ChildNodes, result);
                        }
                        if(!FSPM.CONTROL._alreadyExists(zItem.id, result)) {
                            result.push(zItem);
                        }
                    }
                    //вţְĽڵ
                    var departmentAll = {
                        id: Constants.departmentAllID + Constants.postIdPrefix,
                        pId: "-1",
                        name: FR.i18nText("Platform_Department_All"),
                        open: false
                    };
                    result.push(departmentAll);
                    if(hasTool) {
                        result = result.concat(postAllArray);
                        //ְ
                        var postAll = {};
                        postAll.id = Constants.departmentAllID + Constants.postIdPrefix + Constants.postAllID;
                        postAll.pId = Constants.departmentAllID + Constants.postIdPrefix;
                        postAll.name = FR.i18nText("Platform_Post_All");
                        postAll.open = false;
                        result.push(postAll);
                    }
                    return result;
                };
                var departmentAndPostTreeSetting = {
                    view: {
                        showIcon: false,  //ʾÿڵǰICON
                        selectedMulti: true
                    },
                    data : {
                        simpleData : {
                            enable : true,
                            idKey : "id",
                            pidKey : "pId",
                            rootPId : "-1"
                        }
                    },
                    callback : {
                        onClick: function(e, treeId, treeNode) {
                            clickFunc.call(this, treeNode);
                        },
                        beforeClick: function() {
                            if(hasTool) {
                                return false;
                            }
                        }
                    },
                    async: {
                        enable: true,
                        url: FR.servletURL + "?op=fs_set&cmd=auth_getcompanyrole",
                        dataFilter: filter
                    }
                };
                var result = {
                    title : FR.i18nText("Privilege-Department_And_Post"),
                    content : {
                        type : 'fstabletree',
                        treeID: treeID,
                        height: contentHeight,
                        setting: departmentAndPostTreeSetting,
                        alwaysShowTools: true,
                        toolMargin: 10,
                        width : contentWidth,
                        widgetName: hasTool ? Constants.departmentTableTreeWD : Constants.departmentTableTreeNoCheckWD,
                        fit : false
                    },
                    width : 110
                };

                if(hasTool) {
                    var tools = [{
                        name: 'view',
                        //༭ť¼
                        onToolClick: function (e, treeNode, isSelect) {
                            if(FS.isGradeAuthorityOpen()) {
                                //Ȩ
                                if(!isSelect && (treeNode["design"] !== 0)) {
                                    FSPM.VIEW.departmentTableTree.cancelSelectedNodeWithCascade(treeNode, 1);
                                }
                            }
                            if(FS.isEditReportAuthorityOpen()) {
                                //б༭
                                if(!isSelect && (treeNode["edit"] !== 0)) {
                                    FSPM.VIEW.departmentTableTree.cancelSelectedNodeWithCascade(treeNode, tools.length - 1);
                                }
                            }
                            e.stopEvent();
                        }
                    }];
                    if(FS.isGradeAuthorityOpen()) {
                        //˷ּȨȨ
                        tools.push({
                            name: 'design',
                            //༭ť¼
                            onToolClick: function (e, treeNode, isSelect) {
                                if(isSelect && (treeNode["view"] !== 1)) {
                                    FSPM.VIEW.departmentTableTree.selectNodeWithCascade(treeNode, true, 0);
                                }
                                if(FS.isEditReportAuthorityOpen()) {
                                   if(!isSelect && (treeNode["edit"] !== 0)) {
                                        FSPM.VIEW.departmentTableTree.cancelSelectedNodeWithCascade(treeNode, tools.length - 1);
                                    }
                                }
                                e.stopEvent();
                            }
                        });
                    }
                    if(FS.isEditReportAuthorityOpen()) {
                        tools.push({
                            name: 'edit',
                            onToolClick: function(e, treeNode, isSelect) {
                                if(isSelect) {
                                    if(treeNode["view"] !== 1) {
                                        FSPM.VIEW.departmentTableTree.selectNodeWithCascade(treeNode, true, 0);
                                    }
                                    if(FS.isGradeAuthorityOpen() && treeNode["design"] !== 1) {
                                        FSPM.VIEW.departmentTableTree.selectNodeWithCascade(treeNode, true, 1);
                                    }
                                }
                                e.stopEvent();
                            }
                        });
                    }
                    $.extend(result.content, {
                        tools: tools,
                        tooltype: 'check',
                        onItemToolClick: function() {
                            FSPM.VIEW.saveEntryDepartmentCache();
                        }
                    });
                }
                return result;
            },

            createUnRepeatName : function(name) {
                if (name == null) {
                    name = FR.i18nText("Normal_Role");
                }
                var customRoleList = FSPM.VIEW._getCustomRoleList();
                var allRoles = customRoleList.getAllItemText();
                if(allRoles.length === 0) {
                    return name + "1";
                }
                for(var i = 1; i < 10000; i ++) {
                    var newName = name + i;
                    for(var m = 0; m < allRoles.length; m ++) {
                        if(allRoles[m] == newName) {
                            break ;
                        }
                        if(m == allRoles.length - 1) {
                            return newName;
                        }
                    }
                }
            },

            //ԶɫTab
            _customRoleTab : function(contentWidth, contentHeight, needAddButton, hasTool) {
                //Զɫť
                var self = this;
                var createAddCustomRoleButton = function() {
                    var addButton = new FR.IconButton({
                        imgsrc: Constants.addCustomRoleButtonCls,
                        height: 24,
                        width: 220,
                        text: '&#43;',
                        handler: function() {
                            var roleName = self.createUnRepeatName();
                            FSPM.VIEW._createCustomRoleDialog({
                                name: roleName
                            });
                        }
                    });
                    return addButton.element;
                };
                var items = [];
                //ֻйԱʹԶɫť
                if (needAddButton && FS.config.isAdmin === 'true') {
                    items.push({
                        el : createAddCustomRoleButton()
                    });
                }
                var customRoleList = {
                    type : 'quicklist',
                    scrollLoading: true,
                    async: {
                        url: FR.servletURL + '?op=fs_set&cmd=auth_getcustomrole'
                    },
                    onBeforeItemCreate: function(element, opts) {
                        if(opts.id < 0) {
                            element.addClass(Constants.customRoleListSyncItemCls);
                        }
                    },
                    valueField: 'id',
                    width : contentWidth - 2,
                    height : contentHeight,
                    itemCanBeSelect:true,
                    widgetName: hasTool ? Constants.customRoleListWD : Constants.customRoleListNoCheckWD
                };
                if(hasTool) {
                    var tools = [{
                        name:"view",
                        width:20
                    }];
                    if(FS.isGradeAuthorityOpen()) {
                        tools.unshift({
                            name:"design",
                            width:20
                        });
                    }
                    if(FS.isEditReportAuthorityOpen()) {
                        tools.unshift({
                            name:"edit",
                            width:20
                        });
                    }
                    $.extend(customRoleList, {
                        tools: tools,
                        alwaysShowTools: true,
                        toolMargin:10,
                        tooltype: 'check',
                        itemCanBeSelect: false,
                        onItemToolClick: function (toolindex, index, isSelected, e) {
                            var positionAndCustomRoleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
                            var customRoleList = positionAndCustomRoleTab.getWidgetByName(Constants.customRoleListWD);
                            if(toolindex === tools.length - 1 && !isSelected) {
                                //鿴ȡѡʱȨ༭ҲҪȡѡ
                                if(FS.isGradeAuthorityOpen()) {
                                    customRoleList.options.listItems[index].doUnselect(toolindex - 1);
                                }
                                if(FS.isEditReportAuthorityOpen()) {
                                    customRoleList.options.listItems[index].doUnselect(0);
                                }
                            }
                            if(FS.isGradeAuthorityOpen() && toolindex === tools.length - 2) {
                                if(isSelected) {
                                    //ȨѡУ鿴ҲҪѡ
                                    customRoleList.options.listItems[index].doSelect(tools.length - 1);
                                } else if(FS.isEditReportAuthorityOpen() && !isSelected) {
                                    //Ȩȡ༭ҲҪȡ
                                    customRoleList.options.listItems[index].doUnselect(0);
                                }
                            }
                            if(FS.isEditReportAuthorityOpen() && toolindex < tools.length - 1 && isSelected) {
                                //༭ѡУȨ鿴Ҫѡ
                                customRoleList.options.listItems[index].doSelect(tools.length - 1);
                                if(FS.isGradeAuthorityOpen()) {
                                    customRoleList.options.listItems[index].doSelect(tools.length - 2);
                                }
                            }
                            FSPM.VIEW.saveEntryCustomRoleCache();
                        }
                    });
                } else {
                    contentHeight += 32;
                    //༭ť
                    $.extend(customRoleList, {
                        tools: [
                            {
                                iconCls: 'fs-module-delete-white',
                                iconCls4Hover: 'fs-module-delete-white-hover'
                            },
                            {
                                iconCls: 'fs-module-edit-white',
                                iconCls4Hover: 'fs-module-edit-white-hover'
                            }
                        ],
                        alwaysShowTools: false,
                        onItemToolClick: function (toolindex, index, e) {
                            e.stopEvent();
                            var customRoleList = FSPM.VIEW._getCustomRoleList();

                            if(toolindex === 1) {
                                //༭
                                var customRoleId = customRoleList.getValueAtIndex(index);;
                                var customRoleName = customRoleList.getTextAtIndex(index);
                                FSPM.VIEW._createCustomRoleDialog({
                                    name: customRoleName,
                                    id: customRoleId
                                }, index);
                            } else {
                                //ɾ
                                var roleId = customRoleList.getValueAtIndex(index);
                                if(roleId < 0) {
                                    //ͬĽɫɾ
                                    return ;
                                }
                                FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete") + '?', function (result) {
                                    if (result) {
                                        //̨ɾݣɹwebɾ
                                        FS.Trans.removeRole({
                                            id: roleId
                                        });
                                        //ҲҪ
                                        FSPM.CACHE.delecteCache(roleId);
                                        customRoleList.remove(index);
                                        if(customRoleList.getItemLength() > 0) {
                                            customRoleList.selectItemByIndex(0, true);
                                        } else {
                                            //һ
                                        }
                                    }
                                });
                            }
                        },
                        onCustomItemSelect: function() {
                            var roleId = this.getValue();
                            var roleName = this.getText();
                            FSPM.VIEW.showCustomRoleAuth({
                                id: roleId,
                                name: roleName
                            })
                        }
                    });
                }
                items.push({
                    el : customRoleList
                });
                return {
                    title : FR.i18nText("Role"),
                    content : {
                        type : 'vertical',
                        items : items,
                        width: contentWidth
                    },
                    width : 120
                }
            },

            //Tab
            _entryTab : function(widgetName, tabWidth, contentWidth, contentHeight, treeID, viewOnly, hasTool, clickFunc) {
                var tools = [{
                    name: 'view',
                    //༭ť¼
                    onToolClick: function (e, treeNode, isSelect) {
                        if(FS.isGradeAuthorityOpen()) {
                            //Ȩ
                            if(!isSelect && (treeNode["design"] !== 0)) {
                                FSPM.VIEW.reportTableTree.cancelSelectedNodeWithCascade(treeNode, 1);
                            }
                        }
                        if(FS.isEditReportAuthorityOpen()) {
                            //б༭
                            if(!isSelect && (treeNode["edit"] !== 0)) {
                                FSPM.VIEW.reportTableTree.cancelSelectedNodeWithCascade(treeNode, tools.length - 1);
                            }
                        }
                        e.stopEvent();
                    }
                }];
                if(FS.isGradeAuthorityOpen()) {
                    //˷ּȨȨ
                    tools.push({
                        name: 'design',
                        //༭ť¼
                        onToolClick: function (e, treeNode, isSelect) {
                            if(isSelect && (treeNode["view"] !== 1)) {
                                FSPM.VIEW.reportTableTree.selectNodeWithCascade(treeNode, true, 0);
                            }
                            if(FS.isEditReportAuthorityOpen()) {
                                if(!isSelect && (treeNode["edit"] !== 0)) {
                                    FSPM.VIEW.reportTableTree.cancelSelectedNodeWithCascade(treeNode, tools.length - 1);
                                }
                            }
                            e.stopEvent();
                        }
                    });
                }
                if(FS.isEditReportAuthorityOpen()) {
                    tools.push({
                        name: 'edit',
                        onToolClick: function(e, treeNode, isSelect) {
                            if(isSelect) {
                                if(treeNode["view"] !== 1) {
                                    FSPM.VIEW.reportTableTree.selectNodeWithCascade(treeNode, true, 0);
                                }
                                if(FS.isGradeAuthorityOpen() && treeNode["design"] !== 1) {
                                    FSPM.VIEW.reportTableTree.selectNodeWithCascade(treeNode, true, 1);
                                }
                            }
                            e.stopEvent();
                        }
                    });
                }
                var reportSetting = FSPM.TABLETREESETTINGS.getEntryTableTreeSetting(clickFunc, hasTool ? tools.length : 0);
                var toolConfig = {
                    tooltype: 'check',
                    toolMargin:10,
                    alwaysShowTools: true,
                    tools: tools,
                    onItemToolClick: function() {
                        FSPM.VIEW.saveEntryCache();
                    }
                }
                if(viewOnly) {
                    toolConfig.toolUnEditAble = true;
                }
                var result = {
                    title : FR.i18nText("Report"),
                    content : {
                        type : 'fstabletree',
                        height: contentHeight,
                        width : contentWidth,
                        treeID: treeID,
                        setting: reportSetting,
                        widgetName: widgetName
                    },
                    width : tabWidth
                }
                if(hasTool) {
                    $.extend(result.content, toolConfig);
                }
                return result;
            },

            //ƽ̨Tab
            _moduleTab : function(widgetName, tabWidth, contentWidth, contentHeight, viewOnly, hasTool, onCustomSelect) {
                var tools = [{
                    name:"view",
                    width:20
                }];
                if(FS.isGradeAuthorityOpen()) {
                    tools.unshift({
                        name:"design",
                        width:20
                    });
                }
                var toolConfig = {
                    tooltype: 'check',
                    alwaysShowTools: true,
                    toolMargin:10,
                    tools: tools,
                    beforeSelect:function(toolindex, index, isSelected, e) {
                        var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
                        var moduleList = entryAndModuleTab.getWidgetByName(Constants.moduleListWD);
                        var selectedModule = moduleList.getValueAtIndex(index).value;
                        if(FS.isGradeAuthorityOpen()) {
                            if((selectedModule === 18) && isSelected) {
                                FSPM.VIEW.depAndCRolePane.show();
                            } else if((selectedModule === 18) && (!isSelected) && toolindex === 1) {
                                FSPM.VIEW.depAndCRolePane.hide();
                            }
                        }
                    },
                    onItemToolClick: function (toolindex, index, isSelected, e) {
                        var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
                        var moduleList = entryAndModuleTab.getWidgetByName(Constants.moduleListWD);
                        if((toolindex === 1) && !isSelected) {
                            //鿴ȡѡʱȨҲҪȡѡ
                            moduleList.options.listItems[index].doUnselect(0);
                        }
                        if(toolindex === 0 && isSelected && tools.length > 1) {
                            moduleList.options.listItems[index].doSelect(1);
                        }

                        FSPM.VIEW.saveModuleCache();
                    }
                };
                if(viewOnly) {
                    toolConfig.toolUnEditAble = true;
                }
                var result = {
                    title : FR.i18nText("Platform_Module_FSManager"),
                    content : {
                        type : 'quicklist',
                        height: contentHeight,
                        width : contentWidth,
                        paddingRight: 0,
                        async: {
                            url: FR.servletURL + "?op=fs_set&cmd=auth_getallmodules"
                        },
                        widgetName: widgetName,
                        onAsyncSuccess: function() {
                            if(hasTool && viewOnly) {
                                FSPM.showUserAuth(FSPM.VIEW.userAuth);
                            }
                        }
                    },
                    width : tabWidth
                };
                if(hasTool) {
                    $.extend(result.content, toolConfig);
                }
                if($.isFunction(onCustomSelect)) {
                    result.content.onCustomItemSelect = onCustomSelect;
                }
                if(!hasTool && !viewOnly) {
                    result.content.itemCanBeSelect = true;
                }
                return result;
            },

            //ģTab
            _templateTab : function() {
                return {
                    title: FR.i18nText("Template"),
                    content: {
                        type: 'fstabletree',
                        height: 374,
                        width : 308,
                        fit: false,
                        treeID: 'templateTableTree',
                        setting: FSPM.TABLETREESETTINGS.getTemplateTableTreeSetting(),
                        tooltype: 'check',
                        toolMargin:10,
                        widgetName: Constants.templateTableTreeWD,
                        tools: [
                            {
                                name: 'page',
                                //༭ť¼
                                onToolClick: function (e, treeNode, isSelect) {
                                    if(!isSelect && (treeNode["design"] !== 0)) {
                                        FSPM.VIEW.templateTableTree.cancelSelectedNodeWithCascade(treeNode, 2);
                                    }
                                    e.stopEvent();
                                }
                            },
                            {
                                name: 'write',
                                //༭ť¼
                                onToolClick: function (e, treeNode, isSelect) {
                                    if(!isSelect && (treeNode["design"] !== 0)) {
                                        FSPM.VIEW.templateTableTree.cancelSelectedNodeWithCascade(treeNode, 2);
                                    }
                                    e.stopEvent();
                                }
                            },
                            {
                                name: 'design',
                                //༭ť¼
                                onToolClick: function (e, treeNode, isSelect) {
                                    if(isSelect) {
                                        if(treeNode["page"] !== 1) {
                                            FSPM.VIEW.templateTableTree.selectNodeWithCascade(treeNode, true, 0);
                                        }
                                        if(treeNode["write"] !== 1) {
                                            FSPM.VIEW.templateTableTree.selectNodeWithCascade(treeNode, true, 1);
                                        }
                                    }
                                    e.stopEvent();
                                }
                            }
                        ],
                        onItemToolClick: function() {
                            FSPM.VIEW.saveTemplateCache();
                        }
                    },
                    width: 75
                }
            },

            _dataConnectionTab : function() {
                return {
                    title: FR.i18nText("DashBoard-ConnectionList"),
                    content: {
                        type: 'quicklist',
                        height: 374,
                        width : 308,
                        scrollLoading: true,
                        widgetName: Constants.dataConnectionListWD,
                        fit: false,
                        tooltype: 'check',
                        tools: [
                            {
                                name: 'view',
                                width: 20
                            }
                        ],
                        onItemToolClick: function () {
                            FSPM.VIEW.saveDataConnectionCache();
                        },
                        async: {
                            url: FR.servletURL + "?op=fs_set&cmd=sc_getconnectioninfo",
                                data: {
                                    all: true
                                }
                        },
                        dataFilter: function(item){
                            return {
                                    text: item.name,
                                    value: item.name
                            }
                        }
                    },
                            width: 90
                }
            }
        },

        saveEntryCache: function() {
            var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
            var roleId;
            if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                        var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                    if(!treeNode) {
                            return;
                        }
                    roleId = treeNode.id;
                } else {
                        roleId = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                }
            if(roleId) {
                    FSPM.CACHE.setEntryPrivilege(roleId, FSPM.VIEW.reportTableTree.getSelectedNodes(), true);
                }
        },

        saveModuleCache: function() {
            var entryAndModuleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryAndModuleInsideTabWD);
            var moduleList = entryAndModuleTab.getWidgetByName(Constants.moduleListWD);
            var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
            var roleId;
            if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                        var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                    if(!treeNode) {
                            return;
                        }
                    roleId = treeNode.id;
                } else {
                        roleId = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                }
            if(roleId) {
                    FSPM.CACHE.setModulePrivilege(roleId, moduleList.getValue());
                }
        },

        saveTemplateCache: function() {
            var roleId;
            if(FS.isPlatForm()) {
                roleId = FSPM.VIEW.tabPane.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
            } else {
                var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);

                if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                    var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                    if(!treeNode) {
                        return;
                    }
                    roleId = treeNode.id;
                } else {
                    roleId = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                }
            }
            if(roleId) {
                FSPM.CACHE.setTemplatePrivilege(roleId, FSPM.VIEW.templateTableTree.getSelectedNodes());
            }
        },

            saveDataConnectionCache: function() {
                var templateAndDataConnectionTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.templateAndDataConnectionInsideTabWD);
                var dataConnectionList = templateAndDataConnectionTab.getWidgetByName(Constants.dataConnectionListWD);
                var positionAndCustomRoleInsideTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD);
                var roleId;
                if (!FS.isPlatForm()) {
                    if(positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                        var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeNoCheckWD).getSelectedNodes()[0];
                        if(!treeNode) {
                            return ;
                        }
                        roleId = treeNode.id;
                    } else {
                        roleId = positionAndCustomRoleInsideTab.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                    }
                } else {
                    roleId = FSPM.VIEW.tabPane.getWidgetByName(Constants.customRoleListNoCheckWD).getValue();
                }
                if(roleId) {
                    FSPM.CACHE.setDataConnectionPrivilege(roleId, dataConnectionList.getValue());
                }
            },

            saveEntryDepartmentCache: function() {
                var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryTableTreeNoCheckInPanelWD).getSelectedNodes()[0];
                if(!treeNode) {
                    return;
                }
                var entryId = treeNode.id;
                if(entryId) {
                    FSPM.CACHE.setEntryCache(entryId, FSPM.VIEW.tabPane.getWidgetByName(Constants.departmentTableTreeWD).getAllSelectedLeafNodes(), true);
                }
        },

        saveEntryCustomRoleCache: function() {
            var treeNode = FSPM.VIEW.tabPane.getWidgetByName(Constants.entryTableTreeNoCheckInPanelWD).getSelectedNodes()[0];
            if(!treeNode) {
                return;
            }
            var entryId = treeNode.id;
            if(entryId) {
                var positionAndCustomRoleTab = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabWD);
                var customRoleList = positionAndCustomRoleTab.getWidgetByName(Constants.customRoleListWD);
                FSPM.CACHE.setEntryCache(entryId, customRoleList.getValue(), false);
            }
        },


        /**
         * ӺɾûĶԻ
         * @param data ʼ
         * @private
         */
        _createCustomRoleDialog: function(role, index){
            var isViewOnly = false;
            if(role.id && role.id < 0) {
                //ͬĽɫ
                isViewOnly = true;
            }
            var roleName = role.name;
            var $userOptPane = FS.Tools.createUserOptPane({
                roleName: roleName,
                viewOnly: isViewOnly
            });
            var userDialog = new FR.Dialog({
                confirm: true,
                title: FR.i18nText("Personnel_Management"),
                width: 550,
                height: 445,
                doSize: true,
                destroyOnClose: true,
                text4OK: (isViewOnly ? null : FR.i18nText("OK")),
                contentWidget: {
                    type: 'absolute',
                    items: [
                        {el: {
                            type: 'text',
                            widgetName: Constants.customRoleNameTextWD,
                            wrap: false,
                            width: 230,
                            allowBlank: false,
                            value: roleName,
                            height: 28
                        },x:15,y:12},
                        {el: {
                            type: 'search',
                            width: 230,
                            autoSearch: true,
                            onKeyup: function(e){
                                if (!FR.isNavKeyPress(e)) {
                                    var val = this.getValue();
                                    var dp = {
                                        roleName: roleName
                                    };
                                    if(val){
                                        dp.keyword = val;
                                    }
                                    setTimeout(function () {
                                        $userOptPane.refresh(dp, $userOptPane.seluser, $userOptPane.alluser, function() {
                                            $userOptPane.seluser.empty();
                                            $userOptPane.alluser.empty();
                                        });
                                    }, 100);
                                }
                            }
                        },x:300,y:10},
                        {el: $userOptPane,x:15,y:50}
                    ]
                },
                onOK: function(){
                    var customRoleList = FSPM.VIEW._getCustomRoleList();
                    var roleWD = userDialog.getWidgetByName(Constants.customRoleNameTextWD);
                    if(!roleWD.checkValid()){
                        return false;
                    }
                    role.name = roleWD.getValue();
                    var addids = $userOptPane.getAddlist, delids = $userOptPane.getDellist;
                    var customRole = FS.Trans.updateRoleUsers({
                        role: role,
                        addids: addids.join(','),
                        delids: delids.join(',')
                    });
                    if(!role.id) {
                        //ӽɫ
                        customRoleList.addItem(customRole, true);
                    } else {
                        //༭ɫ
                        customRoleList.setTextAtIndex(index, role.name);
                    }
                }
            });
            userDialog.setVisible(true);
        },

        _getCustomRoleList: function() {
            var customRoleList;
            if(FS.isPlatForm()) {
                customRoleList = FSPM.VIEW.tabPane.getWidgetByName(Constants.customRoleListNoCheckWD);
            } else {
                customRoleList = FSPM.VIEW.tabPane.getWidgetByName(Constants.positionAndCustomRoleInsideTabNoCheckWD).getWidgetByName(Constants.customRoleListNoCheckWD);
            }
            return customRoleList;
        }
    },

    CONTROL : {

        comparateNumber : function(a, b) {
            return a - b;
        },

        comparateString : function(a, b) {
            if(a == b) {
                return 0;
            } else if(a > b) {
                return 1;
            } else {
                return -1;
            }
        },

        comparateEntry : function(a, b) {
            var aid = a.id, bid = b.id;
            var atype = a.type, btype = b.type;

            var r = atype - btype;
            if (r === 0) {
                var a_design = (a.design ? a.design : 0), b_design = (b.design ? b.design : 0);
                var dr = a_design - b_design;
                if(dr === 0) {
                    var a_view = (a.view ? a.view : 0), b_view = (b.view ? b.view : 0);
                    var vr = a_view - b_view;
                    if(vr === 0) {
                        var a_edit = (a.edit ? a.edit : 0), b_edit = (b.edit ? b.edit : 0);
                        var ve = a_edit - b_edit;
                        if(ve === 0) {
                            return aid - bid;
                        } else {
                            return ve;
                        }
                    } else {
                        return vr;
                    }
                } else {
                    return dr;
                }
            } else {
                return r;
            }
        },

        comparateTemplate : function(a, b) {
            var aPath = a.path, bPath = b.path;
            if(aPath === bPath) {
                var aPage = (a.page ? a.page : 0), bPage = (b.page ? b.page : 0);
                var vr = aPage - bPage;
                if(vr === 0) {
                    var aWrite = (a.write ? a.write : 0), bWrite = (b.write ? b.write : 0);
                    var wr = aWrite - bWrite;
                    if(wr === 0) {
                        var aDesign = (a.design ? a.design : 0), bDesign = (b.design ? b.design : 0);
                        return a.design - b.design;
                    } else {
                        return wr;
                    }
                } else {
                    return vr;
                }
            } else {
                return (aPath > bPath) ? 1 : -1;
            }
        },

        comparateModule : function(a, b) {
            var aid = a.id, bid = b.id;
            var r = aid - bid;
            if(r === 0) {
                var a_design = (a.design ? a.design : 0), b_design = (b.design ? b.design : 0);
                var dr = a_design - b_design;
                if(dr === 0) {
                    var a_view = (a.view ? a.view : 0), b_view = (b.view ? b.view : 0);
                    var vr = a_view - b_view;
                    if(vr === 0) {
                        var a_edit = (a.edit ? a.edit : 0), b_edit = (b.edit ? b.edit : 0);
                        return a_edit - b_edit;
                    } else {
                        return vr;
                    }
                } else {
                    return dr;
                }
            } else {
                return r;
            }
        },

        checkPrivilegeArray : function(baseArray, newArray, isEntry) {
            var result = {};
            if (baseArray && newArray) {
                var add = result.add = [];
                var remove = result.remove = [];
                var comparatorFn = isEntry ? ((isEntry === "module") ? this.comparateModule :
                    ((isEntry === "template") ? this.comparateTemplate : ((isEntry === "string") ? this.comparateString : this.comparateEntry))) : this.comparateNumber;
                baseArray = baseArray.sort(comparatorFn);
                newArray = newArray.sort(comparatorFn);

                var bi = 0, ni = 0;
                var cr = 0;
                for (; bi < baseArray.length && ni < newArray.length; bi++) {
                    cr = comparatorFn.call(this, baseArray[bi], newArray[ni]);

                    while (cr > 0) {
                        add[add.length] = newArray[ni];
                        ni ++;
                        if (ni >= newArray.length) {
                            break;
                        }
                        cr = comparatorFn.call(this, baseArray[bi], newArray[ni]);
                    }

                    if (ni >= newArray.length) {
                        break;
                    }

                    if (cr === 0) {
                        ni ++;
                    } else {
                        remove[remove.length] = baseArray[bi];
                    }
                }

                for (; bi < baseArray.length; bi++) {
                    remove[remove.length] = baseArray[bi];
                }
                for (; ni < newArray.length; ni++) {
                    add[add.length] = newArray[ni];
                }
                // һ
                if ((add.length - remove.length) != (newArray.length - baseArray.length)) {
                    throw "checkPrivilegeArray error!";
                }
            }

            return result;
        },

        //privilegeChangesʽ
        // {
        //      roleId:
        //          {
        //              entries:
        //                  {
        //                      add : [],
        //                      remove : []
        //                  },
        //              modules:
        //                  {
        //                      add:[],
        //                      remove:[]
        //                  }
        //          },
        //      roleId2....
        // };
        // ĳ 
        // {
        //      customRole:[{id:,entries:modules:},...],
        //      companyRole:[{departmentId:,postId:,entries:,modules:}]
        // }
        formatPrivilegeData: function(privilegeChanges) {
            var result = {
                "customRole" : [],
                "companyRole": []
            };
            $.each(privilegeChanges, function(key, value){
                var roleId = key;
                if(roleId.indexOf(Constants.postIdPrefix) >= 0) {
                    //Žɫ
                    var departAndPostId = roleId.split(Constants.postIdPrefix);
                    var companyRolePrivilege = {};
                    companyRolePrivilege.departmentId = departAndPostId[0];
                    if(departAndPostId[1]) {
                        companyRolePrivilege.postId = departAndPostId[1];
                    }
                    companyRolePrivilege.entries = value.entries;
                    companyRolePrivilege.modules = value.modules;
                    companyRolePrivilege.templates = value.templates;
                    companyRolePrivilege.depandcroles = value.depandcroles;
                    companyRolePrivilege.dataconnections = value.dataconnections;
                    result.companyRole.push(companyRolePrivilege);
                } else {
                    //Զɫ
                    var customRolePrivilege = {};
                    customRolePrivilege.roleId = key;
                    customRolePrivilege.entries = value.entries;
                    customRolePrivilege.modules = value.modules;
                    customRolePrivilege.templates = value.templates;
                    customRolePrivilege.depandcroles = value.depandcroles;
                    customRolePrivilege.dataconnections = value.dataconnections;
                    result.customRole.push(customRolePrivilege);
                }
            });
            return result;
        },

        saveAuth: function() {
            //ֻҪȽCacheڵݺԭʼȨû𼴿
            var cachePrivileges = FSPM.CACHE.getRoleCache();
            var originalPrivileges = FSPM.CACHE.getOriginalPrivilege();

            //¼޸Ĳ
            var privilegeChanges = {};

            var self = this;

            $.each(originalPrivileges, function(key, value) {
                var roleId = key;
                var originalEntry = value['entries'];
                var newEntry = cachePrivileges[roleId]['entries'];
                var originalModule = value['modules'];
                var newModule = cachePrivileges[roleId]['modules'];
                var originalTemplate = value['templates'];
                var newTemplate = cachePrivileges[roleId]['templates'];
                var originalDepAndCRole = value['depandcroles'];
                var newDepAndCRole = cachePrivileges[roleId]['depandcroles'];
                var originalDataConnection = value['dataconnections'];
                var newDataConnection = cachePrivileges[roleId]['dataconnections'];
                privilegeChanges[roleId] = {};
                privilegeChanges[roleId]['entries'] = self.checkPrivilegeArray(originalEntry, newEntry, true);
                privilegeChanges[roleId]['modules'] = self.checkPrivilegeArray(originalModule, newModule, "module");
                privilegeChanges[roleId]['templates'] = self.checkPrivilegeArray(originalTemplate, newTemplate, "template");
                privilegeChanges[roleId]['depandcroles'] = self.checkPrivilegeArray(originalDepAndCRole, newDepAndCRole, "string");
                privilegeChanges[roleId]['dataconnections'] = self.checkPrivilegeArray(originalDataConnection, newDataConnection, "string");
            });
            privilegeChanges = this.formatPrivilegeData(privilegeChanges);
            if(privilegeChanges["customRole"].length === 0 && privilegeChanges["companyRole"].length === 0) {
                return ;
            }
            var result = FS.Trans.savePrivileges(privilegeChanges);
            if(result == "error") {
                FR.Msg.toast(FR.i18nText("Privilege_Aready_Set"));
            } else {
                FR.Msg.toast(FR.i18nText("Successfully"));
                //originalPrivilege
                FSPM.CACHE.refreshOriginalPrivilege(FR.clone(cachePrivileges));
                FSPM.CACHE.clearEntryCache();
            }
        },

        saveEntryAuth: function() {
            var self = this;

            var cacheEntryPrivileges = FSPM.CACHE.getEntryCache();
            var originalEntryPrivileges = FSPM.CACHE.getOriginalEntryCache();

            //¼޸Ĳ
            var entryPrivilegeChanges = {
                "companyRole": [],
                "customRole": []
            };

            var getPrivilegeJSON = function(addEntry, removeEntry, roleId, isCompanyRole) {
                if (!addEntry && !removeEntry || !roleId) {
                    return null;
                }
                var result = {
                    entries: {
                        add : addEntry ? [addEntry] : [],
                        remove : removeEntry ? [removeEntry] : []
                    },
                    modules: {
                        add : [],
                        remove : []
                    },
                    templates: {
                        add : [],
                        remove : []
                    },
                    depandcroles: {
                        add : [],
                        remove : []
                    },
                    dataconnections: {
                        add : [],
                        remove : []
                    }
                };
                if(isCompanyRole) {
                    if(roleId.indexOf(Constants.postIdPrefix) >= 0) {
                        //Žɫ
                        var departAndPostId = roleId.split(Constants.postIdPrefix);
                        result.departmentId = departAndPostId[0];
                        if(departAndPostId[1]) {
                            result.postId = departAndPostId[1];
                        }
                    } else {
                        result.departmentId = roleId;
                    }
                } else {
                    result.roleId = roleId;
                }
                return result;
            };

            var dealWithRoleChanges = function (key, originalRoles, newRoles, roleType) {
                var role = self.checkPrivilegeArray(
                    originalRoles[roleType], newRoles[roleType], "module"
                );
                var addEntryDict = {};
                if(role.add && role.add.length > 0) {
                    for(var m = 0, len = role.add.length; m < len; m ++) {
                        var addEntry = {
                            "id": key.substr(1),
                            "type": key.charAt(0)
                        };
                        addEntry.view = role.add[m].view;
                        addEntry.design = role.add[m].design;
                        addEntry.edit = role.add[m].edit;
                        addEntryDict[role.add[m].id] = addEntry;
                    }
                }
                var removeEntryDict = {};
                if(role.remove && role.remove.length > 0) {
                    for(var m = 0, len = role.remove.length; m < len; m ++) {
                        var removeEntry = {
                            "id": key.substr(1),
                            "type": key.charAt(0)
                        };
                        removeEntry.view = role.remove[m].view;
                        removeEntry.design = role.remove[m].design;
                        removeEntry.edit = role.remove[m].edit;
                        removeEntryDict[role.remove[m].id] = removeEntry;
                    }
                }
                var isCompanyRole = roleType == "companyRole";
                $.each(addEntryDict, function (id, addEntry) {
                    var removeEntry = null;
                    if (addEntryDict.hasOwnProperty(id)) {
                        removeEntry = removeEntryDict[id];
                        delete removeEntryDict[id];
                    }
                    var RoleChange = getPrivilegeJSON(addEntry, removeEntry, id, isCompanyRole);
                    if (RoleChange) {
                        entryPrivilegeChanges[roleType].push(RoleChange);
                    }
                });
                $.each(removeEntryDict, function (id, removeEntry) {
                    var RoleChange = getPrivilegeJSON(null, removeEntry, id, isCompanyRole);
                    if (RoleChange) {
                        entryPrivilegeChanges[roleType].push(RoleChange);
                    }
                });
            };

            $.each(originalEntryPrivileges, function(key, value) {
                var originalRoles = value;
                var newRoles = cacheEntryPrivileges[key];
                dealWithRoleChanges(key, originalRoles, newRoles, "companyRole");
                dealWithRoleChanges(key, originalRoles, newRoles, "customRole");
            });
            var result = FS.Trans.savePrivileges(entryPrivilegeChanges);
            if(result == "error") {
                FR.Msg.toast(FR.i18nText("Privilege_Aready_Set"));
            } else {
                FR.Msg.toast(FR.i18nText("Successfully"));
                FSPM.CACHE.refreshOriginalEntryCache(FR.clone(cacheEntryPrivileges));
                FSPM.CACHE.clearRoleCache();
            }

        },

        _alreadyExists : function(id, result) {
            for(var i = 0; i < result.length; i ++) {
                if(result[i].id === id) {
                    return true;
                }
            }
            return false;
        },

        popSettingData: function(floatPane) {
            var settings = FS.Trans.getPrivilegeSetting();
            var radioGroup = floatPane.getWidgetByName(Constants.settingRadioGroupWD);
            radioGroup.setValue(settings["rType"], true);
            if(settings["rType"] == Constants.templatePrivileges.DIGITAL_URL){
                floatPane.getWidgetByName(Constants.templateControlCardWD).getWidgetByName(Constants.keyURLTextEditorWD).setValue(settings.keyUrl);
            }
            if(!FS.isPlatForm()) {
                var gradeAuthority = FS.isGradeAuthorityOpen();
                var editReportAuthority = FS.isEditReportAuthorityOpen();
                floatPane.getWidgetByName(Constants.gradeAuthoritySwitchWD).setValue(gradeAuthority, false);
                floatPane.getWidgetByName(Constants.editReportSwitchWD).setValue(editReportAuthority, false);
            }
        },

        setData: function(floatPane) {
            var radioGroup = floatPane.getWidgetByName(Constants.settingRadioGroupWD);
            var jo = {};
            jo.rType = radioGroup.getValue();
            if(jo.rType == Constants.templatePrivileges.DIGITAL_URL) {
                jo.keyUrl = floatPane.getWidgetByName(Constants.templateControlCardWD)
                    .getWidgetByName(Constants.keyURLTextEditorWD).getValue();
                if(!jo.keyUrl) {
                    FR.Msg.alert(FR.i18nText('wrong'), FR.i18nText("Need_Input_Url_Key"));
                    return ;
                }
            } else if(jo.rType == Constants.templatePrivileges.ROLE_VERIFY_NEEDED) {
                jo.isDataConnectionPrivilegeOpen = floatPane.getWidgetByName(Constants.templateControlCardWD)
                    .getWidgetByName(Constants.dataConnectionSwitchWD).getValue();
            }
            if(!FS.isPlatForm()) {
                jo.gradeAuthority = floatPane.getWidgetByName(Constants.gradeAuthoritySwitchWD).getValue();
                jo.editReport = floatPane.getWidgetByName(Constants.editReportSwitchWD).getValue();
            }
            var result = FS.Trans.savePrivilegeSetting(jo);
            if(result == "success") {
                floatPane.doSlide();
                FR.Msg.toast(FR.i18nText("Successfully"));
                //˱䶯ˢȨ޹ǩҳ
                FSPM.CACHE.clearCache();
                if(!FS.isPlatForm()) {
                    FS.setGradeAuthorityOpen(jo.gradeAuthority+"");
                    FS.setEditReportAuthority(jo.editReport+"");
                }
                FS.setTemplatePrivilegeType(jo.rType+"");
                if(jo.rType == Constants.templatePrivileges.ROLE_VERIFY_NEEDED) {
                    FS.setDataConnectionAuthorityOpen(jo.isDataConnectionPrivilegeOpen + "");
                }
                var privilegeModule = {
                    text: FR.i18nText("PM-Privilege_Manager"),
                    id: 18
                }
                FS.Design.showDesign(privilegeModule);
            } else {
                FR.Msg.toast(FR.i18nText("Failed"));
            }
        }
    },

    MODEL : {
        TabTitle: {
            createTitle: function(text, clickFunc) {
                return $("<span/>").text(text).addClass("fs_privilege_manager_tabTitle")
                    .click(function() {
                        if($.isFunction(clickFunc)) {
                                clickFunc.call();
                            }
                    });
            }
        }
    }
}

