$.extend(FS.Trans,  {
		orgnizeTree : FR.servletURL + '?op=fs_entry&cmd=getfolder',
					 	
	 	getAllReports : function() {	
	 		return this.ajax({
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_getallreports"
	 		});
	 	},
	 	
	 	getAllModules : function() {
	 		return this.ajax({
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_getallmodules"
	 		});
	 	},
	 	
	 	getReportParas : function(report) {
	 		return this.ajax({
	 			url : FR.servletURL + "?op=fs_entry&cmd=genparameters",
	 			data : {reportPath : report}
	 		});
	 	},
	 	
	 	getRoles : function() {
	 		return this.ajax({
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_getallrole"
	 		});
	 	},

        getCompanyRoles : function() {
            return this.ajax({
                url : FR.servletURL + "?op=fs_set&cmd=auth_getcompanyrole"
            });
        },

        savePrivileges : function(privileges) {
            return this.ajax({
                returnString : true,
                url : FR.servletURL + "?op=fs_set&cmd=auth_save",
                data : privileges
            });
        },

        getCompanyRoleAuth : function(departmentId, postId) {
            var data = {};
            if(departmentId) {
                data.departmentId = departmentId;
            }
            if(postId) {
                data.postId = postId;
            }
            return this.ajax({
                data : data,
                url : FR.servletURL + "?op=fs_set&cmd=auth_getjroleauth"
            });
        },

        getCustomRoleAuth : function(role) {
            return this.ajax({
                data : role,
                url : FR.servletURL + "?op=fs_set&cmd=auth_getsroleauth"
            });
        },
	 	
	 	removeRole : function(role) {
	 		var url = FR.servletURL + "?op=fs_set&cmd=";
	 		if (role.postid != null || role.departmentid != null) {
	 			url += "auth_removejrole"
	 		} else {
	 			url += "auth_removesrole"
	 		}
	 		FR.ajax({
	 			data : {id : role.id},
	 			url : url,
	 			complete : function() {
	 				role.id = -1;
	 			}
	 		});
	 	},

        updateRoleUsers: function(data){
            return this.ajax({
                data : data,
                url : FR.servletURL + "?op=fs_set&cmd=auth_updatesroleusers"
            });
        },

	 	getSpecialDepart : function() {
	 		return this.ajax({
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_getspecialdepart"
	 		});
	 	},
	 	
	 	addDepart : function(depart) {
	 		return this.ajax({
	 			data : {depart : depart},
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_adddepart"
	 		});	 		
	 	},
	 	
	 	removeDepart : function(id) {
	 		this.ajax({
	 			data : {id : id},
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_removedepart"
	 		});
	 	},

	 	addPost : function(post) {
	 		return this.ajax({
	 			returnString : true,
	 			data : {post : post}, 
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_addpost"
	 		});
	 	},

	 	addEmployee : function(employee) {
	 		return this.ajax({
	 			returnString : true,
	 			data : {employee : employee},
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_addemployee"
	 		});
	 	},
	 	
	 	removeEmployee : function(data) {
	 		return this.ajax({
	 			data : data,
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_removeemployee"
	 		});
	 	},

		addUser : function(user) {
			var encodeUser = {};
			$.each(user, function(key, item) {
				encodeUser[encodeURIComponent(key)] = encodeURIComponent(item);
			});
			return this.ajax({
				data : {user : encodeUser},
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_adduser"
	 		});
		},
		
		removeUser : function(id) {
			this.ajax({
				data : {id : id},
	 			url : FR.servletURL + "?op=fs_set&cmd=auth_removeuser"
	 		});
		},

        getEntryRoles : function(entryId) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getEntryRoles",
                data: {
                    entryId: entryId
                }
            });
        },

        getUserAuths : function(userId) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getUserAuth",
                data: {
                    userId: userId
                }
            });
        },

        getEntryUsers : function(entryId) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getEntryUsers",
                data: {
                    entryId: entryId
                }
            });
        },

        getModuleUsers: function(moduleId) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getModuleUsers",
                data: {
                    moduleId: moduleId
                }
            });
        },

        getPrivilegeSetting: function() {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getTemplatePrivilege"
            });
        },

        savePrivilegeSetting: function(settings) {
            return this.ajax({
                returnString : true,
               url: FR.servletURL + "?op=fs_set&cmd=auth_saveTemplatePrivilege",
               data: settings
            });
        }
	}
);

FS.BarList = FS.extend(FS.Widget, {
	init : function(config) {
		this.element=  $('<div/>').attr('id', 'fs_barlist');
		this.resize(config);
		if (config.title) {
			this.title = $('<span/>').css({color : '#598EB7', 'line-height' : '20px'}).text(config.title).appendTo(this.element);
		}
		if (config.barcontent) {
			this.bar = $('<div/>').addClass('fs_barlist_bar').width(config.width).height(24).append(config.barcontent).appendTo(this.element);
		}
		this.generateList(config);
	},
	
	generateList : function(config) {
		this.content = $('<div/>').addClass('fs_barlist_list').appendTo(this.element);
		this.list = new FS.List({
			width : config.width ? config.width : 160,
			height : config.height ? (config.height - this.bar.height() - (this.title ? 20 : 0)) : 300,
			items : config.items,
			renderEl : this.content
		});
	},
	
	/*b:list add selecteditem change event*/
	on : function(name, callback) {
		this.list.on(name, callback);
	},
	
	popData : function(data) {
		this.list.popData(data);
	},
	
	reName : function(name) {
		var data = this.getSelectedData();
		data.text = name;
		this.list.editItem(data);
	},
	
	reData : function(data) {
		this.list.editItem(data);
	},
	
	clearData : function() {
		this.list.doClear();
	},
	
	getSelectedData : function() {
		return this.list.getSelectedData();
	},
	
	getSelectedItem : function() {
		return this.list.getSelectedItem();
	},
	
	getAll : function () {
		return this.list.getAll();
	},
	
	/*b:list to be editable*/
	addData : function(data, isSelected) {
		this.list.addSimpleData(data);
		if (isSelected){
			this.list.setSelectedIndex(this.list.options.data.getLength() - 1);
		}
	},
	
	editSelectedData : function(data) {
		this.list.editItem(data);
	},
	
	removeSelectedData : function() {
		this.list.removeSelect();
	},
	
	getDataLength : function() {
		return this.list.options.data.getLength();
	},
	
	resize : function(config) {
		this.element.width(config.width).height(config.height);
	}
});

FS.BarTree = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').attr('id', 'fs_bartree');
		this.resize(config);
		if (config.title) {
			this.title = $('<span/>').css({color : '#598EB7', 'line-height' : '20px'}).text(config.title).appendTo(this.element);
		}
		if (config.barcontent) {
			this.bar = $('<div/>').addClass('fs_bartree_bar').height(24).append(config.barcontent).appendTo(this.element);
		}
		this.generateTree(config);
	},
	
	reBuild : function(treeData) {
		this.tree.reBuild(treeData);
	},
	
	getAllData : function () {
    	return this.tree.options.data.getData();
    },
	
	generateTree : function(config) {
		this.content = $('<div/>').addClass('fs_bartree_tree').appendTo(this.element);
		var config = $.extend(config, {
			width : config.width ? config.width : 160,
			height : config.height ? (config.height - this.bar.height() - (this.title ? 20 : 0)) : 300,
			renderEl : this.content
		});
		this.tree = new FS.Tree(config);
	},
	
	/*b: add selecteditem change event*/
	on : function(name, callback) {
		this.tree.on(name, callback);
	},
	
	fireEvent : function(event) {
		this.tree.fireEvent(event);
	},
	
	/*b:to do*/
	popData : function() {
		
	},
	
	clearData : function() {
		
	},
	
	getSelectedData : function() {
		return this.tree.getSelectedData();
	},
	
	/*b:to be editable*/
	addData : function(data) {
		this.tree.addNode(data);
	},
	
	editSelectedData : function(data) {
		
	},
	
	getSelectedName : function() {
		return this.tree.getSelectedData() == null ? null : this.tree.getSelectedData().getShowValue();
	},
	
	reName : function(name) {
		if (this.tree.getSelectedData() == null) {
			return;
		}
		this.tree.getSelectedData().setShowValue(name);
		this.tree.editNode(this.tree.getSelectedData());
	},
	
	removeSelectedData : function() {
		this.tree.removeNode();
	},
	
	resize : function(config) {
		this.element.width(config.width).height(config.height);
	},
	
	selecteByID : function(ids) {
		this.tree.selecteByID(ids);
	}
});

FS.Design = {};

$.extend(FS.Design, {
	initOP : function() {
		if (this.op) {
			return;
		}
		var self = this;
		/*b:IDף̫*/
		this.op = {
            //
            2 : function(designContainer) {
                return self.reportManager(designContainer);
            },
            //û
            3 : function(designContainer) {
				return self.userManager(designContainer);
			},
            //Ȩ޹
            18 : function(designContainer) {
                return self.showPrivilegeManager(designContainer);
            },
            //ʱ
            16 : function(designContainer) {
                return self.showScheduleSetting(designContainer);
            },
            //ϵͳ
            5 : function(designContainer) {
                return self.systemManager(designContainer);
            },
            //ƽ̨
            14 : function (designContainer) {
                return self.plateSetting(designContainer);
            },
            //עϢ
            8 : function(designContainer) {
                return self.registerManager(designContainer);
            },
            //ϵͳ
            9 : function(designContainer) {
                return self.monitorManager(designContainer);
            },
            //B/Sȫ
			7 :  function(designContainer) {
				return self.BSManager(designContainer);
			},
            //̹
            13 : function (designContainer) {
                return self.processManager(designContainer);
            },
            //ƶƽ̨
            17 : function(designContainer) {
                return self.showMobileDevSetting(designContainer);
            },
//			10 : function(designContainer) {
//				//ͳ
//				return self.visitorManager(designContainer);
//			},
//			11 : function(designContainer) {
//				//־
//				return self.logManager(designContainer);
//			},
//			12 : function (designContainer) {
//				//ϵͳ
//				return self.sysexamManager(designContainer);
//			},
			15 : function (designContainer) {
				//BI
				return self.showBIDataSettings(designContainer);
			}
		};
	},

    /**
     * ʾָǩģ
     * @param {Object} module ģϢ
     */
	showDesign : function(module) {
		this.initOP();
		var designContainer = $("<div/>").addClass('fs_design_container');
		var config = {
			title : module.text,
			contentEl : designContainer,
			onResize:function(width, height) {
				var onResizeFunc = designContainer.data("onResize");
				if($.isFunction(onResizeFunc)) {
					onResizeFunc.call(this, width, height);
				}
			}
		};
		var hasTabExisted = FS.tabPane.addItem(config);
        if(this.op[module.id]) {
            this.op[module.id](designContainer);
        }
	},
	
	resize : function() {},

	//
	reportManager : function(designContainer) {
		FR.$defaultImport('/com/fr/fs/web/js/manager/fs_reportmgr.js', 'js');
		FS.REPORTMGR.init(designContainer);
	},
	//û
	userManager : function(designContainer) {
        if(FS.isPlatForm()){
            FR.$defaultImport('/com/fr/fs/web/js/manager/pf_usermgr.js', 'js');
        }else{
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_usermgr.js', 'js');
        }
		FS.USERMGR.init(designContainer);
	},
    //Ȩ޹
    showPrivilegeManager : function(designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_privilegemanager.js', 'js');
        return FS.PRIVILEGEMANAGER.init(designContainer);
    },
    //ʱ
    showScheduleSetting : function(designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_schedule.js', 'js');
        return FS.SCHEDULEMANAGER.init(designContainer);
    },
    //ϵͳ
    systemManager : function(designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmgr.js', 'js');
        FS.SYSMGR.init(designContainer);
    },
    //ƽ̨
    plateSetting : function (designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_configsetting.js', 'js');
        FS.CONFIGSETTING.init(designContainer);
    },
    //עϢ
    registerManager : function(designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_register.js', 'js');
        FS.REGISTER.init(designContainer);
    },
    //ϵͳ
    monitorManager : function(designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmonitor.js', 'js');
        FS.SYSMONITOR.init(designContainer);
    },
    //B/Sȫ
    BSManager : function(designContainer) {
        var src = FR.servletURL + '?op=fr_adhoc&cmd=data_ac_set&needTitle=false';
        $('<iframe/>').css({height : '100%', width : '100%'})
            .attr({frameborder : 0, src : src}).appendTo(designContainer);
    },
    //̹
    processManager : function() {
        FR.$defaultImport('/com/fr/process/web/css/fs_process.css', 'css');
        FR.$defaultImport('/com/fr/process/web/js/jquery.ui.droppable.js', 'js');
        FR.$defaultImport('/com/fr/process/web/js/fs_process_design.js', 'js');
        FR.$defaultImport('/com/fr/process/web/js/fs_process.js', 'js');
        var self = this;
        this.processDiagramPane = new FS.ProcessDiagramPane({
            width : FS.tabPane.panel.width(),
            height : FS.tabPane.panel.height()
        });
        this.processDiagramPane.addProcessButton.click(function() {
            self.processDiagramPane.processPane = new FS.ProcessEditPane({
                width : FS.tabPane.panel.width(),
                height : FS.tabPane.panel.height()
            });
            self.processDiagramPane.processPane.element.data('container', this.processPane);
            FS.tabPane.activePane.children().detach();
            FS.tabPane.activePane.append(self.processDiagramPane.processPane.element);
            var process = FS.ProcessMananger.getNewProcess();
            self.processDiagramPane.processPane.showProcess(process);
        });
        $(window).resize(function() {
            self.processDiagramPane.resize({
                width : FS.tabPane.panel.width(),
                height : FS.tabPane.panel.height()
            });
        });
        return this.processDiagramPane.element;
    },
    //ƶƽ̨
    showMobileDevSetting : function(designContainer) {
        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_mobileplate.js', 'js');
        return FS.MOBILEPLATE.init(designContainer);
    },
//	visitorManager : function(designContainer) {
//        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_user.js', 'js');
//        FS.USER.init(designContainer);
//	},
//	logManager : function(designContainer) {
//		FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmonitor.js', 'js');
//		FS.SYSMONITOR.init(designContainer);
//	},
//	sysexamManager : function(designContainer) {
//		FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysexam.js', 'js');
//		FS.SYSEXAM.init(designContainer);
//	},
	showBIDataSettings : function (designContainer) {
		var src = FR.servletURL + '?op=fr_bi_configure&cmd=init_configure_pane';
		$('<iframe/>').css({height : '100%', width : '100%'})
			.attr({frameborder : 0, src : src}).appendTo(designContainer);
	}
});