/**
 * @author wei
 * fsĳ÷ģȡ
 *
 */
if (window.FS == null) {
    window.FS = {};
}

/**
 * FSؼؼͨextendķʽ̳֮
 * @param config : jsonʽĿؼԡ
 */
FS.Widget = function (config) {
    this.init(config);
}

$.extend(FS.Widget.prototype, {
    init: function () {
        //do something
    },

    //b:configʱ򲻽width,heightҪֱcss
    resize: function (config) {
        if (config) {
            //to richer ﲻôãthis.element.css(config);ΪconfigԻߺҲcss,ᵼ״
            this.element.width(config.width).height(config.height);
        } else {
            var p = this.element.parent();
            this.element.width(p.width()).height(p.height());
        }
    }
});

/**
 * Ƽ̳УnewuiԸӵuiϣµĹ캯
 * @param ui : ԭʼ캯
 * @param newui : µ/
 */
FS.extend = function (ui, newui) {
    var fn = function () {
        ui.apply(this, arguments);
    }
    $.extend(fn.prototype, ui.prototype, newui);
    return fn;
}
/**
 * fsݽʱ߼й
 *  normaldesktop
 *             userinfo
 *             titles: work report, favorite report
 *          specific work /favorite report
 *          report Content ? consider it
 *          portal source
 *  admin: titles: work report, favorite report & design
 *         specific work /favorite report  & design
 *         orgnize/role
 *         users
 *         reports
 *         schedule control
 *         portal source control
 *         bulletion control
 * */

$.extend(FS, {
    /**
     * FS¼
     */
    Events: {
        SELECTDATA: 'SELECTDATA',

        NOSELECT: 'NOSELECT',

        APPENDDATA: 'APPENDDATA',

        EDITDATA: 'EDITDATA',

        REMOVEDATA: 'REMOVEDATA',

        REMOVESELF: 'REMOVESELF',

        REMOVESELFEVENT: 'removeselfevent',

        FAVORITECHOOSE: 'FAVORITECHOOSE',

        RELOADDATA: 'RELOADDATA'
    },

    /**
     * ģ
     */
    Plate: {
        /**
         * Ƿ֧ģ
         */
        hasProcess: function () {
            return FS.hasprocess === "true";
        },
        /**
         * Ƿ֧BI
         */
        hasBi: function () {
            return FS.hasbi === "true";
        }
    },

    /**
     * 
     */
    Style: {
        Black: "black",
        LightBlue: "lightblue",
        DarkBlue: "darkblue",
        /**
         * ʼؼķ񣬸ݲͬķزͬcssļļ·/com/fr/fs/web/css/+
         * @param filename:cssļxxx.css
         * @param style:ؼĬʽ
         * @param needCommonFile:ͬķǷҪһͨļѷԹõĴŵУ
         */
        initWidgetStyle: function (filename, style, needCommonFile) {
            var defaultStyle = FS.Style.LightBlue;
            //ԶķûеĻʹfs
            if (style && this.isFSStyle(style)) {
                defaultStyle = style;
            } else if (FS.config && FS.config.style) {
                defaultStyle = FS.config.style;
            }
            if (!filename) {
                return;
            }
            //Ƿ.cssβ
            if (filename.lastIndexOf(".css") !== filename.length - 4) {
                filename += ".css";
            }
            FR.$defaultImport("/com/fr/fs/web/css/" + defaultStyle.toLowerCase() + "/" + filename, "css");
            if (needCommonFile) {
                FR.$defaultImport("/com/fr/fs/web/css/" + filename, "css");
            }
        },

        /**
         * styleǷfsֽ׶ֵ֧ķ
         * @param style:
         */
        isFSStyle: function (style) {
            $.each(FS.Style, function (idx, item) {
                if (((typeof item) === "string") && item.toLowerCase() === style.toLowerCase()) {
                    return true;
                }
            });
            return false;
        }
    },

    /**
     * ߰ť
     */
    ICons: {
        /**
         * һ༭ť
         */
        getEdit: function () {
            var editButton = new FR.IconButton({
                width: 14,
                height: 14,
                imgsrc: 'edit_item',
                renderEl: $('<div/>')
            });
            return editButton;
        },

        /**
         * һɾť
         */
        getDelete: function () {
            var deleteButton = new FR.IconButton({
                width: 14,
                height: 14,
                imgsrc: 'delete_item',
                renderEl: $('<div/>')
            });
            return deleteButton;
        },

        /**
         * һͼΪimgsrcİť
         */
        getIcon: function (imgsrc) {
            var icon = new FR.IconButton({
                width: 14,
                height: 14,
                imgsrc: imgsrc,
                renderEl: $('<div/>')
            });
            return icon;
        }
    },

    /**
     * 
     */
    Cache: {
        //Ŀ¼汨飬ṹƣ
        /**
         * [{id:1,hasChildren:true,parentid:-1,childNodes:[....]}]
         */
        rootFolder: [],

        /**
         * ʼ
         */
        initCache: function () {
            if(FS.isPlatForm()) {
                this.rootFolder = [];
                return ;
            }
            this.rootFolder = FS.Trans.getSpecificReports(-1);
        },

        /**
         * ȡĿ¼Уṹ
         */
        getRootFolder: function () {
            if (!this.rootFolder || this.rootFolder.length === 0) {
                this.initCache();
            }
            return this.rootFolder;
        },

        /**
         * Ŀ¼idȡĿ¼ṹ
         * @param folderid : Ŀ¼id
         */
        getFolder: function (folderid) {
            if (!folderid) {
                return [];
            }
            if (folderid === -1) {
                return this.getRootFolder();
            }
            if (!this.rootFolder || this.rootFolder.length === 0) {
                this.initCache();
            }
            for (var i = 0; i < this.rootFolder.length; i++) {
                if (this.rootFolder[i].id === folderid) {
                    return this.rootFolder[i].ChildNodes ? this.rootFolder[i].ChildNodes : [];
                }
            }
            return [];
        },

        /**
         * »
         */
        updateCache: function () {
            //TODOԲ̨
            this.initCache();
        }
    },

    /**
     * ÷
     */
    Trans: {

        /**
         * ͬajax
         * @return Ľjson/string
         */
        ajax: function (config) {
            var self = this, returnData;
            FR.ajax({
                url: config.url,
                async: false,
                data: config.data,
                type: config.type ? config.type : 'POST',
                beforeSend: config.beforeSend,
                error: config.error,
                complete: function (res, status) {
                    try {
                        returnData = config.returnString ? res.responseText : FR.jsonDecode(res.responseText);
                    } catch (Error) {
                        FR.Msg.toast("AnalysisData Error!");
                    }
                }
            });
            return returnData;
        },

        /**
         * urlķhttp://
         * @param address:ԭʼַ
         * @private
         */
        _dealWithSrc: function (address) {
            var temp = '';
            var url1 = /[a-zA-z]+:\/\/[^\s]*/;
            var url2 = /\/[^\s]*/;
            if (address.startWith("&fr_check_url") || address.startWith("about:blank")) {
                temp = "";
            } else if (address.match(url1) || address.match(url2)) {
                temp = address;
            } else {
                temp = "http://" + address;
            }
            return temp;
        },

        /**
         * ʼڵ¼
         * @param content : ڵ
         */
        _initEntryClickEvent: function (content) {
            var self = this;
            if (content.type == "0") {
                content.clickFunc = function () {
                    return;
                }
            } else if (content.type == "5") {
                //wei : process
                content.clickFunc = function () {
                    var processid = content.processid;
                    FS.Trans.startProcessById(processid);
                    return;
                }
            }
            // wei : ݲѯ
            else if (content.type == "6") {
                content.clickFunc = function () {
                    FS.startProcessQuery(content);
                    return;
                }
            } else if (content.parentID === "0-0997") {
                //ϵͳ
                content.clickFunc = function () {
                    FR.$defaultImport('/com/fr/fs/web/css/fsdesign.css', 'css');
                    content.id = content.id.substr(1);
                    FS.Design.showDesign(content);
                }
            } else if (content.parentID === "0-0996") {
                //bi
                content.clickFunc = function () {
                    var titleText = content.text;
                    if (content.src == 'init_dezi_pane') {
                        titleText = titleText + '____' + FR.i18nText('Open') + FR.i18nText('Time') + ":" + new Date();
                    }
                    FS.tabPane.addItem({
                        title: titleText,
                        src: '?op=fr_bi_dezi&cmd=' + content.src+"&_=" + new Date().getTime()
                    });
                }
            } else if(content.buildurl) {
                //bsǱõ
                content.clickFunc = function() {
                    FS.tabPane.addItem({
                        title : content.text,
                        src : content.buildurl
                    });
                }
            } else {
                content.clickFunc = function () {
                    var timeStamp = "";
                    if (content.url) {
                        FR.ajax({
                            async: false,
                            url: FR.servletURL + '?op=fs_main&cmd=entry_report&id=' + content.id + '&isTree=true',
                            complete: function (res, status) {
                                timeStamp = (content.url.indexOf('?') > -1 ? '&' : '?') + 'fr_check_url=' + res.responseText;
                            }
                        });
                    } else if (content.bilink) {
                        content.url = content.bilink;
                    }

                    var src = content.url ? content.url + timeStamp : '?op=fs_main&cmd=entry_report&id=' + content.id;
                    FS.tabPane.addItem({
                        'title': content.text,
                        src: src,
                        icon: 'fr-tabs-' + content.nodeicon,
                        type: content.type,
                        need2Close: function (tab, e) {
                            var frame = tab.options.contentHtml;
                            var isWrite = (content.type == "2");
                            if (isWrite && frame.length > 0 && frame[0].contentWindow) {
                                var win = frame[0].contentWindow;
                                var beforeUnload = win.onbeforeunload || (win.document && win.document.body.onbeforeunload);
                                if ($.isFunction(beforeUnload)) {
                                    var info = beforeUnload.call();
                                    if (info) {
                                        var confirm = window.confirm(info + "\n" + FR.i18nText('Sure_To_Leave') + "");
                                        if (!confirm) {
                                            e.stopEvent();
                                            return false;
                                        }
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
            }
        },

        /**
         * ȡIDӦĿ¼ṹ
         * @param id : Ŀ¼id
         * @return {*} Ŀ¼±ṹ
         */
        getSpecificReports: function (id) {
            return this.ajax({
                data: {id: id},
                url: FR.servletURL + "?op=fs_main&cmd=module_getrootreports"
            });
        },

        /**
         * ȡղؼ
         * @return {*} ղݵ
         */
        getFavorite: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_main&cmd=module_getfavorite"
            });
        },

        /**
         * ղ
         * @param id : ڵid
         */
        addFavorite: function (id) {
            return this.ajax({
                returnString: true,
                data: {id: id},
                url: FR.servletURL + "?op=fs_main&cmd=module_addfavorite"
            });
        },

        addPostsToDepart: function(data){
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_addjrole_post"
            });
        },

        removePostsFromDepart: function(data){
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_removejrole_post"
            });
        },
        /**
         * ȡղ
         * @param id : ڵid
         */
        removeFavorite: function (id) {
            this.ajax({
                data: {id: id},
                url: FR.servletURL + "?op=fs_main&cmd=module_removefavorite"
            });
        },

        /**
         * ȡڵΪidģµģ飨ϵͳµݣ
         * @param id : ڵid
         * @return {*} ģ
         */
        getModuleItems: function (id) {
            return this.ajax({
                async: false,
                data: {id: id},
                url: FR.servletURL + "?op=fs_main&cmd=getmoduleitems"
            });
        },

        /**
         * ޸ĵ¼ûԼû(޹Ա)
         * @param {JSON} info ûϢ
         * @return {*} Ƿɹ"true"/"false"
         */
        changePW: function (info) {
            return this.ajax({
                data: info,
                url: FR.servletURL + "?op=fs_main&cmd=user_changepw"
            });
        },

        /**
         * ǳϵͳ
         * @return {*} ǳתurl
         */
        signOut: function () {
            return this.ajax({
                returnString: true,
                url: FR.servletURL + "?op=fs_load&cmd=logout"
            });
        },

        /**
         * رͬݼ
         */
        closeTableDataSync: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=closeTableDataSync"
            })
        },

        /**
         * ͬݼ
         * @returns {Ľ} ǷѾͬݼ
         */
        openTableDataSync: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=openTableDataSync",
                returnString: true
            })
        },

        /**
         * Ƿͬݼ
         * @returns {Ľ} jsonresult.type,1:0:û
         */
        getTableDataSyncState: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=getTableData_sync_state"
            })
        },

        /**
         * ͬݼ
         * @param data Ϣ
         * @returns {*} jsonresult.successʾǷ񱣴ɹ
         */
        saveTableDataSync: function(data){
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=editTabledataSync",
                data: {
                    res: data
                }
            });
        },
        /**
         * ȡLDAP
         * @returns {*} Ľ
         */
        getLdapAttrs: function(){
            return FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_load&cmd=loginLdapAttrs",
                returnString : true
            });
        }
    }
});

/**
 * ûϢ
 */
FS.UserPane = FR.extend(FR.Widget, {
    NAV: {
        UNREG: 1,
        PWD: 2,
        EXIT: 3,
        SYSMSG: 4,
        USERNAME: 5
    },
    _defaultConfig: function () {
        return $.extend(FS.UserPane.superclass._defaultConfig.call(), {
            baseCls: 'fs_userp_normal',
            splitCls: 'fs_userp_split',
            style: "black",
            renderEl: $("#fs_userp")
        });
    },

    /**
     * ʼ
     * @private
     */
    _init: function () {
        FS.UserPane.superclass._init.call(this, arguments);
        var self = this, o = this.options;
        var registerText = "",
            usernameText = FS.config.username,
            passwordText = "",
            exitText = "",
            sysmsgText = "";
        if (FS.config.isRegiste !== 'true') {
            //δעʾϢ
            registerText = "(" + FR.i18nText('Unregistered') + ")";
        }
        if (FS.config.hasnavigation) {
            this.element.addClass('fs_userp_withnavigation');
            usernameText = FR.i18nText('Welcome') + "" + FR.i18nText('Comma') + FS.config.username;
            passwordText = FR.i18nText('FS-Admin_Account_Setting');
            exitText = FR.i18nText('FS_Exit');
            sysmsgText = FR.i18nText('New_Message');
        }
        var $ul = $('<ul/>');
        if (FS.config.hasnavigation) {
            this.element.addClass('fs_userp_withnavigation');
        }
        var NAV = this.NAV;
        this.createItem(registerText, 'fs_userp_register', NAV['UNREG']).appendTo($ul);
        if (!FS.config.hasnavigation) {
            this.createItem(usernameText, 'fs_userp_usericon', NAV['USERNAME']).appendTo($ul);
            this.createItem('', o.splitCls).appendTo($ul);
            if (FS.canModifyPassword()) {
                this.createItem(passwordText, 'fs_userp_password', NAV['PWD']).appendTo($ul);
                this.createItem('', o.splitCls).appendTo($ul);
            }
        } else {
            this.createItem(usernameText, 'fs_userp_username', NAV['USERNAME']).appendTo($ul);
            if (FS.canModifyPassword()) {
                this.createItem(passwordText, 'fs_userp_password', NAV['PWD'], true).appendTo($ul);
            }
        }
        this.createItem(exitText, 'fs_userp_exit', NAV['EXIT'], true).appendTo($ul);
        if(FS.hasReportProcess()){
            if(!FS.config.hasnavigation){
                this.createItem('', o.splitCls).appendTo($ul);
            }
            this.sysmsgText = this.createItem(sysmsgText, 'fs_userp_sysmsg', NAV['SYSMSG'], true).appendTo($ul);
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmsg.js', 'js');
            FR.$defaultImport('/com/fr/fs/web/css/manager/fs_sysmsg.css', 'css');
            FS.SYSMSG.sendSysMsgConn(60000);
        }
        $ul.appendTo(this.element);
        this.bindEvt();
    },

    createItem: function(text, cls, nav, hasIcon){
        var $li = $('<li class="fs_userp_item"/>').data('nav', nav);
        var $a = $('<a/>').addClass(cls).html(text+"&nbsp;").appendTo($li);
        if(hasIcon) {
            $a.css("paddingLeft", "16px");
        }
        return $li;
    },

    bindEvt: function(){
        var NAV = this.NAV, self = this, o = this.options;
        var proxy = function(event){
            var type = event.type;
            var $target = $(event.target).closest('li');
            if($target.length){
                var navitype = $target.data('nav');
            }
            if(!navitype){
                return;
            }
            if (type == 'mouseover') {
                $target.addClass('hover');
            }else if (type == "mouseout") {
                $target.removeClass('hover').removeClass('click');
            }else if (type == 'mousedown'){
                $target.addClass('click');
            }else if (type === "mouseup") {
                $target.removeClass('click');
                switch(navitype){
                    case NAV['UNREG']:
                        //δע
                        if (FS.config.hasRegistePrivilege == 'true') {
                            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_register.js', 'js');
                            var $container = $("<div/>").addClass('fs_design_container');
                            FS.tabPane.addItem({
                                title: FR.i18nText('Platform_Module_RegisterInfo'),
                                contentEl: $container,
                                onResize: function (width, height) {
                                    var onResizeFunc = $container.data("onResize");
                                    if ($.isFunction(onResizeFunc)) {
                                        onResizeFunc.call(this, width, height);
                                    }
                                }
                            });
                            FS.REGISTER.init($container);
                        }
                        break;
                    case NAV['PWD']:
                        //޸
                        FR.$defaultImport('/com/fr/fs/web/js/manager/fs_password.js', 'js');
                        var $container = $("<div/>").addClass('fs_design_container');
                        FS.tabPane.addItem({
                            title: FS.config.isAdmin == "true" ? FR.i18nText('Admin_Account') : FR.i18nText('FS-Admin_Account_Setting'),
                            contentEl: $container
                        });
                        FS.PASSWORD.init($container);
                        break;
                    case NAV['EXIT']:
                        //˳
                        self.signOut();
                        break;
                    case NAV['SYSMSG']:
                        if(!FS.SYSMSG){
                            return;
                        }
                        //ϵͳϢ
                        $target.addClass('fs_userp_sysmsg');
                        var x = $target.offset().left;
                        var y = $target.offset().top + $target.outerHeight() - 1;
                        if(!FS.config.hasnavigation){
                            x = x + $target.outerWidth() - 182;
                        }
                        var $combo = FS.SYSMSG.showSysMsgComboAt(x, y);
                        $(document).bind('click.sysmsg', function(e){
                            if(!$(e.target).isChildAndSelfOf('.fs_userp_sysmsg')){
                                $(document).unbind('click.sysmsg');
                                $target.removeClass('fs_userp_sysmsg');
                                $combo.remove();
                            }
                        });
                        $combo.mouseleave(function(){
                            $(document).unbind('click.sysmsg');
                            $target.removeClass('fs_userp_sysmsg');
                            $combo.remove();
                        });
                        break;
                    case NAV['USERNAME']:
                        $target.addClass('fs_userp_userqr');
                        $(document).bind('click.qrimg', function(e){
                            if(!$(e.target).isChildAndSelfOf('.fs_userp_userqr')){
                                $(document).unbind('click.qrimg');
                                $target.removeClass('fs_userp_userqr');
                                $('.fs_userp_qrdiv').hide();
                            }
                        });
                        FR.ajax({
                            url : FR.servletURL + "?op=fs_mobile_main&cmd=initdata",
                            type : "POST",
                            complete : function(res, status) {
                                if(status == "success") {
                                    var data = FR.jsonDecode(res.responseText);
                                    var qrcodeImageID = data.qrcodeid;
                                    if(!qrcodeImageID) {
                                        return;
                                    }
                                    var x = $target.offset().left;
                                    var y = $target.offset().top + $target.outerHeight() - 1;
                                    var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + qrcodeImageID + '&isAdjust=false');
                                    if($('.fs_userp_qrdiv').length > 0) {
                                        $('.fs_userp_qrdiv').show();
                                    } else {
                                        $("<div/>").append($("<img/>").addClass('fs_userp_qrimg').attr("src", url)).css({
                                            'left': x,
                                            'top': y
                                        }).addClass('fs_userp_qrdiv').appendTo($('body'));
                                    }
                                }
                            }
                        });
                }
            }

        };
        this.element.bind("mousedown", proxy)
            .bind("mouseover", proxy)
            .bind("mouseup", proxy)
            .bind("mouseout", proxy);
    },

    /**
     * ȡռݵĿ
     * @return 
     */
    getOuterWidth: function () {
        return this.element.find('ul').outerWidth();
    },

    /**
     * תǳurl
     */
    signOut: function () {
        window.location.href = FS.Trans.signOut();
    }
});

/**
 * ʼ͹FS
 */
$.extend(FS, {
    /**
     * ʼ
     * @param config:һЩϢͼƬҳû
     */
    init: function (config) {
        this.config = config;
        this.initPlate(config);
        this.embellishFS(config);
        var self = this;
        $(window).resize(function () {
            //wei : ﻹʱִаɣһֱresizeҲ
            if (self.fsresizeid != null) {
                clearTimeout(self.fsresizeid);
                self.fsresizeid = null;
            }
            self.fsresizeid = setTimeout(function () {
                this.layoutPage();
                this.layoutTab();
                if (FS.config.hasnavigation) {
                    this.layoutNavigationBar();
                }
            }.createDelegate(self), 200);
        });
        this.paint(config);

        this.initNavigation();
    },

    isPlatForm : function() {
        return this.config.isPlatForm == "true";
    },

    /**
     * Ƿ޸롣ֻйԱ¼߷ͬݼû¼²ſ޸롣
     * @returns {boolean} Ƿ޸롣
     */
    canModifyPassword: function(){
        return FS.config.isTableDataUser != "true" || FS.config.isAdmin=="true";
    },
    hasReportProcess: function() {
        return FS.config.hasReportProcess == "true" && FS.config.isAdmin!="true";
    },
    isGradeAuthorityOpen : function() {
        return this.config.gradeAuthority == "true";
    },

    hasGradeAuthority: function(){
        return this.config.hasGradeAuthority == 'true';
    },

    isEditReportAuthorityOpen : function() {
        return this.config.editReportAuthority == "true";
    },

    setEditReportAuthority : function(editReportAuthority) {
        this.config.editReportAuthority = editReportAuthority;
    },

    setGradeAuthorityOpen : function(gradeAuthority) {
        this.config.gradeAuthority = gradeAuthority;
    },

    setTemplatePrivilegeType : function(type) {
        this.config.templatePrivilegeType = type;
    },

    isDataConnectionAuthorityOpen: function() {
        return this.config.dataConnectionAuthority == "true";
    },

    setDataConnectionAuthorityOpen: function(dataConnectionAuthority) {
        this.config.dataConnectionAuthority = dataConnectionAuthority;
    },


    /**
     * ʼ
     */
    initNavigation: function () {
        //TODO ﲻʱҲʼ£Ϊƽ̨Ǳߣɡ
        this.initNavigationBar();
        if (FS.config.hasnavigation) {
            this.navigationBar.navigationItems[0].onClick();
        }
    },

    /**
     * ˢµеаť
     */
    refreshAllNavigation: function () {
        var navigationWrapper = $("#fs_navigation_wrapper", this.north);
        navigationWrapper.empty();
        var navigationItems = [];
        var reports = FS.Cache.getRootFolder();
        var maxIconNumber = this.calculateNavigationMaxIcon();
        var len = Math.min(reports.length + FS.defaultNavigationItems.length, maxIconNumber);
        navigationWrapper.width(70 * len);
        if (maxIconNumber < reports.length + FS.defaultNavigationItems.length) {
            //ʾȫҪṩһַʾбٴεNavigationItemʱб鿴״̬
            FS.needMoreNavigation = true;
        } else {
            FS.needMoreNavigation = false;
        }
        for (var i = 0; i < len - FS.defaultNavigationItems.length; i++) {
            var item = {
                text: reports[i].text,
                treefolderid: reports[i].id,
                type: 'navigationitem'
            }
            navigationItems.push(item);
        }

        navigationItems = navigationItems.concat(FS.defaultNavigationItems);
        var index = 0;
        if (navigationItems.length > index) {
            this._initDefaultNavigationIcon(navigationItems, index);
        }
        this._dealWithCustomNaviStyle(navigationItems);
        this.navigationItems = navigationItems;
        this.navigationBar = new FS.NavigationBar({
            renderEl: navigationWrapper,
            items: navigationItems
        });
    },

    calculateNavigationMaxIcon : function() {
        var userPaneWidth = this.userPane.getOuterWidth();
        var userPaneLeftWidth = 280;
        var navigationWrapperRightWidth = 90;
        var navigationWrapperLeftWidth = 35;
        var navigationWrapperWidth = document.body.clientWidth - userPaneWidth - userPaneLeftWidth - navigationWrapperRightWidth - navigationWrapperLeftWidth;
        var maxIconNumber = parseInt(navigationWrapperWidth / 70);
        return maxIconNumber;
    },

    /**
     * ʼ
     */
    initNavigationBar: function () {
        var navigationWrapper = $("<div/>").attr("id", "fs_navigation_wrapper");
        if (FS.config.hasnavigation) {
            navigationWrapper.appendTo(this.north);
        }
        if (FS.config.hasnavigation) {
            this.userPane.element.width(this.userPane.getOuterWidth());
        }
        FS.defaultNavigationItems = [];
        var modules = FR.jsonDecode(FS.config.roots).modules;
        if (modules && modules.length > 0) {
            var moduleItems = {
                text: FR.i18nText('ManagerSystem'),
                managersystem: true,
                treeContent: {
                    modules: modules
                },
                type: 'navigationitem'
            };
            FS.defaultNavigationItems.unshift(moduleItems);
        }
        if (FS.config.hasbi === "true") {
            var biItem = {
                text: "BI",
                bi: true,
                treeContent: {
                    bi: FR.jsonDecode(FS.config.roots).bi
                },
                type: 'navigationitem'
            };
            FS.defaultNavigationItems.unshift(biItem);
        }
        this.refreshAllNavigation();
    },

    /**
     * Զĵť
     * @param navigationItems : Array
     * @private
     */
    _dealWithCustomNaviStyle: function (navigationItems) {
        var customNavigationImgs = [];
        if (FS.config.navigationimgs) {
            customNavigationImgs = FR.jsonDecode(FS.config.navigationimgs);
        }
        for (var i = 0, len = navigationItems.length; i < len; i++) {
            var item = navigationItems[i];
            var type = "";
            if (item.treefolderid) {
                //Ŀ¼
                type = item.treefolderid;
            } else if (item.bi === true) {
                type = "bi";
                //bi
            } else if (item.managersystem === true) {
                type = "manager";
            }
            for (var m = 0, len2 = customNavigationImgs.length; m < len2; m++) {
                if (customNavigationImgs[m].type === type) {
                    if (customNavigationImgs[m].cls) {
                        item.cls = customNavigationImgs[m].cls;
                        item.iconImgID = "";
                    } else if (customNavigationImgs[m].id) {
                        item.iconImgID = customNavigationImgs[m].id;
                        item.cls = "";
                    }
                }
            }
        }
    },

    /**
     * ʼĬϵĵͼ걳Ϣ
     * @param navigationItems:еťϢ
     * @param i:ӵiͼ꿪ʼ
     */
    _initDefaultNavigationIcon: function (navigationItems, i) {
        for (var len = navigationItems.length; i < len; i++) {
            var navigationItem = navigationItems[i];
            if (navigationItem.managersystem === true) {
                //ϵͳ
                navigationItem.cls = "fs_navigation_itemicon_reportmanager";
            } else if (navigationItem.bi === true) {
                //bi
                navigationItem.cls = "fs_navigation_itemicon_bi";
            } else {
                //Ĭ
                navigationItem.cls = "fs_navigation_itemicon_default";
            }
        }
    },

    /**
     * fsĿ¼϶
     */
    _makeBorderResizable: function () {
        var border = this.border;
        var cc = border.element;
        var self = this;
        border.regionField['west'].el.resizable({
            handles: "e",
            minWidth: 245,
            maxWidth: document.body.clientWidth * 2 / 5,
            onStartResize: function (e) {
                if (!self.pmask) {
                    self.pmask = $('<div/>').css({
                        position: 'absolute',
                        filter: 'alpha(opacity=0)',
                        opacity: 0
                    }).insertAfter(border.regionField['west'].el);
                }
                self.pmask.css({
                    zIndex: FR.widget.opts.zIndex++,
                    left: 0,
                    top: 0,
                    width: cc._outerWidth(),
                    height: cc._outerHeight(),
                    background: 'black'
                });
                if (!self.proxy) {
                    self.proxy = $('<div/>')
                        .css({'border-left': 'solid ' + FS.middleMargin + 'px ' + '#6BBFDA',
                            position: 'absolute',
                            overflow: 'hidden'
                        })
                        .insertAfter(border.regionField['west'].el);
                }
                self.proxy.css({
                    zIndex: FR.widget.opts.zIndex++,
                    left: e.data.width,
                    top: e.data.top
                });
                self.proxy._outerWidth(e.data.width);
                self.proxy._outerHeight(e.data.height);
            },
            onResize: function (e) {
                self.proxy.css({
                    left: e.data.width,
                    top: e.data.top
                });
                self.proxy._outerWidth(e.data.width);
                self.proxy._outerHeight(e.data.height);
                return false;
            },
            onStopResize: function (e) {
                border.setRegionWH('west', e.data.width);
                border.doResize();
                self.pmask.remove();
                self.pmask = null;
                self.proxy.remove();
                self.proxy = null;
            }
        });
    },

    /**
     * ʼģϢ
     * @param config:ģϢ
     */
    initPlate: function (config) {
        this.hasprocess = config.hasprocess;
        this.hasbi = config.hasbi;
    },

    /**
     * ʼfsıͼƬ
     * @param backgroundImageID:ͼƬӦID
     */
    initFSBGImg: function (backgroundImageID) {
        var url = FR.servletURL
            + ((backgroundImageID && backgroundImageID != 'null') ? ('?op=fr_attach&cmd=ah_image&id=' + backgroundImageID + '&isAdjust=false') : '?op=resource&resource=/com/fr/fs/web/images/fsbg.jpg');
        $('div#fs_bg')[0].style.backgroundImage = "url(" + url + ")";
    },

    /**
     * FS
     * @param config:Ϣ
     */
    embellishFS: function (config) {
        config.hasnavigation = (config.hasnavigation === "true");
        if (!config.style) {
            config.style = "lightblue";
        }
        FR.$defaultImport("/com/fr/fs/web/css/" + config.style.toLowerCase() + "/fs.css", "css");
        this.initFSBGImg(config.backgroundImageID);
        this.north = $('<div id="fs_navigation_north"/>');
        var northHeight = 60;
        if (config.hasnavigation) {
            northHeight = 87;
        }
        //Sean: ĬlogoͻԶFSıͼƬʹǵĬlogo
        if (config.backgroundImageID == '') {
            var logoTop = 15;
            if (config.hasnavigation) {
                logoTop = 30;
            }
            var logoid = "fs_default_logo";
            if(FS.isPlatForm()){
                logoid = "fs_platform_logo";
            }
            $('<div/>').attr('id', logoid).css({top: logoTop}).appendTo(this.north);
        }
        //Sean: ߵļ࣬Ӧ
        this.fixBorder = 1;
        this.leftMargin = 12 + Math.min(13, Math.max(0, Math.round((document.body.clientWidth - 1024) / 24)));
        this.middleMargin = 1 + Math.min(2, Math.max(0, Math.round((document.body.clientWidth - 1024) / 160)));
        this.rightMargin = this.leftMargin + this.middleMargin + 2 * this.fixBorder;
        this.west = $('#fs_westaccord');
        //Ŀ¼
        this.westBorder = new FR.BorderLayout({
            items: [
                {
                    region: 'west',
                    el: $("<div/>"),
                    width: this.leftMargin
                },
                {
                    region: 'center',
                    el: {
                        type: 'navigationtree',
                        renderEl: this.west,
                        width: 245,
                        items: [],
                        style: FS.config.style,
                        widgetName: 'navigationtree',
                        value: FR.i18nText('SystemMenu')
                    }
                },
                {
                    region: 'east',
                    el: $('<div/>'),
                    width: this.middleMargin
                }
            ],
            renderEl: $('div#fs_west'),
            vgap: 0,
            hgap: -0.5
        });
        this.navigationTree = FS.westBorder.getWidgetByName("navigationtree");

        var reports = FS.Cache.getRootFolder();
        if (!FS.config.hasnavigation) {
            this.navigationTree._setTopText(FR.i18nText('SystemMenu'));
            var treeFolderId = -1;
            if(FS.isPlatForm()) {
                treeFolderId = null;
            }
            var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), treeFolderId);
            this.navigationTree.treeRender.append(reportTree.element);
            reportTree._addOddAndEvenStyle();
        }

        this.center = $('#fs_centertab');
        this.border = new FR.BorderLayout({
            items: [
                {
                    region: 'north',
                    el: this.north,
                    height: northHeight
                },
                {
                    region: 'west',
                    el: this.westBorder.element,
                    width: 245,
                    left: this.leftMargin
                },
                {
                    region: 'center',
                    el: this.center
                },
                {
                    region: 'east',
                    el: $("<div/>"),
                    width: this.rightMargin
                },
                {
                    region: 'south',
                    el: $("<div/>"),
                    height: 9
                }
            ],
            renderEl: $('body')
        });
        this.border.regionField['center'].el.css('overflow', 'visible');
    },

    /**
     * չʾʼû壬tabpanedolayout
     * @param config : fsʼҪϢ
     */
    paint: function (config) {
        this.userPane = new FS.UserPane(config);
        this.layoutPage();
        this.initTab(config.homePageUrl);
        this.layoutTab();
    },

    /**
     * ַɺʡԴ...ַ
     * daniel:FF֧text-overflow:ecllpiscɶjs...ַ
     * @param showText:ԭʼ
     * @param maxlength:
     * @param fontsize:С
     * @param fontfamily:
     * @return 
     */
    getShowText: function (showText, maxlength, fontsize, fontfamily) {
        var t = $('<span style="font-size: ' + fontsize + 'px;font-family:' + fontfamily + '"></span>').appendTo('body');
        t.html(showText);
        var isTooLong = false;
        while (showText.length > 0 && t[0].offsetWidth > maxlength) {
            showText = showText.substr(0, showText.length - 1);
            t.html(showText);
            isTooLong = true;
        }
        if (isTooLong) {
            showText += "...";
        }
        t.remove();
        return showText;
    },

    /**
     * ݲͬģ飬Ϊòͬͼ
     * @param item:ģϢ
     */
    createModuleIcon: function (item) {
        if (!FS.ModuleIcons) {
            FS.ModuleIcons = {2: 'fs_accordion_reportmanager', 3: 'fs_accordion_user',
                5: 'fs_accordion_serverconfig', 7: 'fs_accordion_dataset',
                8: 'fs_accordion_register', 9: 'fs_accordion_monitor', 10: 'fs_accordion_visitor',
                11: 'fs_accordion_log', 12: 'fs_accordion_sysexam', 13: 'fs_accordion_log', 14: 'fs_accordion_title', 15: 'fs_accordion_bi_data',
                16: 'fs_accordion_schedule', 17: 'fs_accordion_mobiledev', 18: 'fs_accordion_privilege'};
        }
        item.icon = FS.ModuleIcons[item.id] ? FS.ModuleIcons[item.id] : FS.ModuleIcons[item.text];
    },

    /**
     * ģӦ
     * @param module:ģϢ
     * @param needParent:ؽǷҪڵ
     * @return ģҪ
     */
    _createModuleTreeData: function (module, needParent) {
        if (module && module.length > 0) {
            this.config.moduleNode = {
                id: '0997',
                text: FR.i18nText('ManagerSystem'),
                parentID: "0-1",
                hasChildren: "hasChildren",
                type: 0
            };
            var items = FS.Trans.getModuleItems(module[0].id).ChildNodes;
            var moduleArray = [];
            for (var i = 0, len = items.length; i < len; i++) {
                this.createModuleIcon(items[i]);
            }
            for (var i = 0, len = items.length; i < len; i++) {
                var module = items[i];
                module.parentID = '0-' + this.config.moduleNode.id;
                module.id = "M" + module.id;
                module.isModule = true;
                moduleArray.push(module);
            }
            this.config.moduleNode.ChildNodes = moduleArray;
            if (needParent === false) {
                return moduleArray;
            }
            return this.config.moduleNode;
        }
    },

    /**
     * BIӦ
     * @param bi:biϢ
     * @param needParent:ؽǷҪڵ
     * @return BIҪ
     */
    _createBITreeData: function (bi, needParent) {
        if (bi) {
            this.config.biNode = {
                id: '0996',
                text: "BI",
                parentID: "0-1",
                hasChildren: "hasChildren",
                type: 0
            };

            var isAdmin = this.isAdmin();
            var items = [];
            items.push({
                icon: '',
                text: FR.i18nText('I_Created'),
                src: 'my_bi_saved',
                id: '20996'
            })
            if (isAdmin == "false") {
                items.push({
                    icon: '',
                    text: FR.i18nText('Shared_To_Me'),
                    src: 'my_bi_shared',
                    id: '20997'
                })
            }
            items.push({
                icon: '',
                text: FR.i18nText('New') + FR.i18nText('Analysis'),
                src: 'init_dezi_pane',
                id: '20998'
            })
            var biArray = [];
            for (var i = 0, len = items.length; i < len; i++) {
                var bi = items[i];
                bi.parentID = '0-' + this.config.biNode.id;
                biArray.push(bi);
            }
            this.config.biNode.ChildNodes = biArray;
            if (needParent === false) {
                return biArray;
            }
            return this.config.biNode;
        }
    },

    /**
     * ղؼнڵ
     * @param needParent:ؽǷҪ
     * @return ղؼݵ
     */
    _createFavoriteTreeData: function (needParent) {
        this.config.favoriteNode = {
            id: '0998',
            text: FR.i18nText('Favorite'),
            parentID: "0-1",
            hasChildren: "hasChidlren",
            type: 0
        };
        var favorite = FS.Trans.getFavorite();
        var favoriteArray = [];
        for (var i = 0; i < favorite.length; i++) {
            var fe = favorite[i].entry;
            fe.parentID = '0-' + this.config.favoriteNode.id;
            fe.isFavorite = true;
            favoriteArray.push(fe);
        }
        this.config.favoriteNode.ChildNodes = favoriteArray;
        if (needParent === false) {
            return favoriteArray;
        }
        return this.config.favoriteNode;
    },

    /**
     * wei:
     * @param roots:ģ/BI
     * @param treefolderid:Ŀ¼IDݴҵڵ㣬ʾӦڵµݣ
     * @param needParent:ɵǷҪڵ
     * @param isFavorite:Ƿղؼ
     * @return Ŀ¼
     */
    createTreeContent: function (roots, treefolderid, needParent, isFavorite) {
// 		var favorite = roots.favorite, module = roots.modules, bi = roots.bi;
        var self = this;
        var treedata = FS.Cache.getFolder(treefolderid);

        var moduleTreeData = this._createModuleTreeData(roots.modules, needParent);
        if (moduleTreeData) {
            treedata = treedata.concat(moduleTreeData);
        }

        var biTreeData = this._createBITreeData(roots.bi, needParent);
        if (biTreeData) {
            treedata = treedata.concat(biTreeData);
        }

        if (isFavorite) {
            var favoriteTreeData = this._createFavoriteTreeData(needParent);
            if (favoriteTreeData) {
                treedata = treedata.concat(favoriteTreeData);
            }
        }

        if (treefolderid == -1) {
            delete FS.treeContentType;
        } else if (treefolderid) {
            FS.treeContentType = treefolderid;
        } else if (moduleTreeData) {
            FS.treeContentType = "M";
        } else if (biTreeData) {
            FS.treeContentType = "B";
        }

        var color = "rgba(51,51,51,0.5)";
        var hovercolor = "rgba(51,51,51,0.8)";
        if ($.browser.msie && $.browser.version < '9.0') {
            color = hovercolor = "rgb(51,51,51)";
        }
        var reportTree = new FS.Tree({
            width: 'auto',
            height: 'auto',
            treedata: treedata,
            favorite: true,
            showstyle: 'ACCORDION',	//fs directory tree
            needLeafIcon: true,
            needFolderIcon: false,
            expand: FS.isPlatForm(),
            style: FS.config.style,
            expandOrClose: function (node) {
                reportTree._addOddAndEvenStyle();
            }
        });
        reportTree.on(FS.Events.FAVORITECHOOSE, function (node) {
            var fid = node.getContent().favoriteid;
            if (fid != null) {
                node.getContent().favoriteid = null;
                FS.Trans.removeFavorite(fid);
                if (FS.favoriteList) {
                    FS.favoriteList.removeByID(fid);
                }
            } else {
                var item = {
                    entry: node.getContent(),
                    titleText: node.getShowValue(),
                    text: FS.getShowText(node.getShowValue(), 90, 13, "Verdana,Arial,sans-serif")
                };

                item.id = FS.Trans.addFavorite(node.getID());
                node.getContent().favoriteid = item.id;
                if (FS.favoriteList) {
                    FS.favoriteList.addSimpleData(item);
                }
            }
            if (node.favorite) {
                treedata.remove(self.favoriteNode);
                self.favoriteNode = {
                    id: '0998',
                    text: FR.i18nText('Favorite'),
                    parentID: "0-1",
                    hasChildren: "hasChidlren",
                    type: 0
                };
                var favorite = FS.Trans.getFavorite();
                var favoriteArray = [];
                for (var i = 0; i < favorite.length; i++) {
                    var fe = favorite[i].entry;
                    fe.parentID = '0-' + self.favoriteNode.id;
                    fe.isFavorite = true;
                    favoriteArray.push(fe);
                }
                self.favoriteNode.ChildNodes = favoriteArray;
                treedata.push(self.favoriteNode);
            }
        });
        reportTree.on(FR.Events.CLICK, function (node) {
            var content = node.getContent();
            var contentClone = $.extend({}, content);
            FS.Trans._initEntryClickEvent(contentClone);
            contentClone.clickFunc.call();
        });
        reportTree.element.css('border', 'none');
        return reportTree;
    },

    /**
     * ½ûǷǹԱ
     */
    isAdmin: function () {
        var isAdmin = false;
        FR.ajax({
            url: FR.servletURL + "?op=fr_bi_dezi&cmd=judge_isAdmin",
            async: false,
            complete: function (res, status) {
                isAdmin = FR.jsonDecode(res.responseText);
                isAdmin = isAdmin["isAdmin"];
            }
        });
        return isAdmin;
    },

    /**
     * ʼtabpane
     * @param homePageURL:ҳַ
     */
    initTab: function (homePageURL) {
        var tabWidth = 130, homeWidth = 70, separatorWidth = 1, rightMargin = 100;
        var home = true, html = null;
        //platformĬϹ̶ҳ,FSԶҳ
        if(FS.isPlatForm()){
            html = this.initPlatformHome();
        }else{
            if (!FS.config.homePageUrl) {
                home = false;
            }
        }

        this.tabPane = new FR.QuickTab({
            renderEl: this.center,
            tabWidth: tabWidth,
            homeWidth: homeWidth,
            separatorWidth: separatorWidth,
            contentHtml: html,
            src: FS.Trans._dealWithSrc(FS.config.homePageUrl),
            style: FS.config.style, // richie:3ʽ darklightblue,navyblue
            home: home, // ҳʾһiframeԪأýʾҳ
            homeText: FR.i18nText('FS-Home_Page'),//ҳť
            width: this.center.width(), // tabĿ
            height: this.center.height() // tabĸ߶
        });
    },
    /**
     * ɹƽ̨ҳ
     */
    initPlatformHome: function(){
        var $bg = $('<div class="platform_home_bg"/>');
        var $fg = $('<div class="platform_home_fg"/>');
        return $bg.append($fg);
    },
    /**
     * ²
     */
    layoutPage: function () {
        this.westBorder.doLayout()
        this.border.doLayout();
        this.navigationTree.doResize();
        this._makeBorderResizable();
    },

    /**
     * tabpane
     */
    layoutTab: function () {
        this.tabPane && this.tabPane.doResize({
            width: this.center.width(),
            height: this.center.height()
        });
    },

    /**
     * 
     */
    layoutNavigationBar: function () {
        $('#fs_navigation_wrapper', this.north).remove();
        this.initNavigationBar();
        if (this.treeContentIsFavorite === true) {
            //ղؼ

        }
        if (this.treeContentType === 'M') {
            //ѡModule
            for (var i = 0; i < this.navigationItems.length; i++) {
                if (this.navigationItems[i].managersystem === true) {
                    this.navigationBar.navigationItems[i].select();
                    return;
                }
            }
        } else if (this.treeContentType === 'B') {
            //ѡBI
            for (var i = 0; i < this.navigationItems.length; i++) {
                if (this.navigationItems[i].bi === true) {
                    this.navigationBar.navigationItems[i].select();
                    return;
                }
            }
        } else if (this.treeContentType) {
            //ѡб
            for (var i = 0; i < this.navigationItems.length; i++) {
                if (this.navigationItems[i].treefolderid == this.treeContentType) {
                    this.navigationBar.navigationItems[i].select();
                    return;
                }
            }
        }
    },

    /**
     * Ա˻ģ
     * @returns {JSON} Ϣ
     */
    adminPwdModule: function () {
        var items = [
            [
                {el: {type: 'llabel', value: FR.i18nText("Username")}},
                {el: {type: 'text', widgetName: 'usernameText', allowBlank: false, value: FS.config.username}},
                null,
                {el: {type: 'llabel', widgetName: 'usernameError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Username_Can_Not_Be_Null")}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS_Old_Password")}},
                {el: {type: 'text', passwordText: true, widgetName: 'oldPwdText'}},
                null,
                {el: {type: 'llabel', widgetName: 'oldPwdError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Old_Password_Error")}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("Enter_New_Password")}},
                {el: {type: 'text', passwordText: true, widgetName: 'newPwdText'}},
                null,
                {el: {type: 'llabel', widgetName: 'enterNewPwdError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Please_Enter_Newpwd")}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("Verify_New_Password")}},
                {el: {type: 'text', passwordText: true, widgetName: 'verifyPwdText'}},
                null,
                {el: {type: 'llabel', widgetName: 'pwdNotMatchError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Passwords_Not_Match")}}
            ]
        ];
        var adminPwd = {
            title: FR.i18nText("Admin_Account"),
            content: {
                type: 'confirm',
                doSize: true,
                text4OK: FR.i18nText("Save"),
                text4Cancel: null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                firstBtnMargin: 0,
                //޸ģȷϰťĵ¼
                onOK: function () {
                    //޸ĹԱ˻û
                    //ȡԱϢ
                    var usernameText = this.getWidgetByName('usernameText'),
                        oldPwdText = this.getWidgetByName('oldPwdText'),
                        verifyPwdText = this.getWidgetByName('verifyPwdText'),
                        newPwdText = this.getWidgetByName('newPwdText'),
                    //Ϣ
                        usernameError = this.getWidgetByName('usernameError'),
                        oldPwdError = this.getWidgetByName('oldPwdError'),
                        enterNewPwdError = this.getWidgetByName('enterNewPwdError'),
                        pwdNotMatchError = this.getWidgetByName('pwdNotMatchError');
                    //ձϢ
                    usernameError.setVisible(false);
                    oldPwdError.setVisible(false);
                    enterNewPwdError.setVisible(false);
                    pwdNotMatchError.setVisible(false);
                    var oldp = oldPwdText.getValue(),
                        np = newPwdText.getValue(),
                        username = usernameText.getValue(),
                        info = {};
                    //жûǷΪ
                    if (!usernameText.checkValid()) {
                        usernameError.setVisible(true);
                        return false;
                    }
                    if (username != FS.config.username) {
                        info.username = username
                    }
                    //벻ΪձʾҪ޸
                    if (!FR.isEmpty(oldp)) {
                        //жǷΪ
                        if (FR.isEmpty(np)) {
                            enterNewPwdError.setVisible(true);
                            return false;
                        }
                        //жǷһ
                        if (np != verifyPwdText.getValue()) {
                            pwdNotMatchError.setVisible(true);
                            return false;
                        }
                        info.oldp = encodeURIComponent(oldp);
                        info.np = encodeURIComponent(np);
                    }
                    //ύû޸,жǷ޸ĳɹ
                    var submitPwd = FS.Trans.changePW(info);
                    if (submitPwd.success) {
                        FR.Msg.toast(FR.i18nText("Successfully"));
                    } else {
                        oldPwdError.setVisible(true);
                        return false;
                    }
                    return true;
                },
                onCancel: function () {
                },
                width: 500,
                height: 206,
                contentWidget: {
                    type: 'tablelayout',
                    widgetName: 'userInfoTablelayout',
                    columnSize: [131, 122 , 6, 'fill'],
                    rowSize: [21, 21, 21, 21],
                    vgap: 19,
                    items: items
                }
            }
        };
        return adminPwd;
    }
});

/**
 * FSҳ澭Ҫʹõıǩɿؼ
 */
FS.LLabel = FR.extend(FR.Label, {
    _defaultConfig: function () {
        return $.extend(FS.LLabel.superclass._defaultConfig.call(), {
            levelStyle: 2,   //ĬΪ⣬ΪFSʹøΪƵ
            firstStyleWidth: 730, //һ»߳
            verticalcenter: true,
            style: null
        });
    },

    /**
     * ʼҪʽ
     */
    _init: function () {
        var opts = this.options;
        switch (opts.levelStyle) {
            case 0:
                break;
            case 1:
                opts.fontfamily = 'SimSun';
                opts.color = '#676767';
                opts.fontsize = '14px';
                break;
            case 2:
                opts.fontfamily = 'SimSun';
                opts.color = '#202020';
                opts.fontsize = '13px';
                break;
            default:
                break;
        }
        FS.LLabel.superclass._init.apply(this, arguments);
        if (opts.levelStyle === 1) {
            this.element.addClass('first_level_style');
            this.element.css('width', opts.firstStyleWidth);
        }
    }
});
$.shortcut("llabel", FS.LLabel);

FS.ListReader = FR.extend(FR.ArrayReader, {
    _init: function () {
        FS.ListReader.superclass._init.apply(this, arguments);
    },

    readObject: function (o) {
        if (o.length == null) {
            o = [o];
        }
        if ($.isArray(o)) {
            if (typeof o[0] == 'string') {
                this.options.showField = this.options.valueField = 'text';
                for (var i = 0, len = o.length; i < len; i++) {
                    o[i] = {text: o[i]};
                }
            }
            var records = [];
            var config = {};
            config.showField = this.options.showField != null ? this.options.showField : 'text';
            config.titleField = this.options.titleField != null ? this.options.titleField : 'titleText';
            config.valueField = this.options.valueField != null ? this.options.valueField : 'value';
            for (var i = 0, len = o.length; i < len; i++) {
                config.data = o[i];
                records.push(new FR.Record(config));
            }
            return records;
        }

    }
});

/**
 * FS.List
 * //TODO ɾFR.List
 */
FS.List = FR.extend(FR.ListEditor, {
    _defaultConfig: function () {
        return $.extend(FS.List.superclass._defaultConfig.call(), {
            fscls: '',
            icon: false,
            multi: false,
            limitData: 2000,
            textAlign: "left"
        });
    },

    _init: function () {
        FS.List.superclass._init.apply(this, arguments);
        this.element.addClass('fs_list').addClass(this.options.fscls);
        if (this.getSelectedIndex() < 0) {
            this.fireEvent(FS.Events.NOSELECT);
        }
        if ($.browser.msie && $.browser.version == '6.0') {
            this.element.css('position', 'relative');
        }
        $('div > ul', this.element).css('overflow', 'hidden');
    },

    initData: function () {
        if (this.options.data) {
            return;
        }
        if (this.options.items) {
            this.options.data = new FR.SynchronData({
                dataSource: new FR.SynchronObjectSource({
                    object: this.options.items
                }),
                dataReader: new FS.ListReader()
            });
            return;
        }
        FS.List.superclass.initData.apply(this);
    },

    reBuild: function (items) {
        this.options.data = null;
        this.element.empty();
        this.options.items = items;
        this.initData();
        this.jlist();
    },

    removeByID: function (id) {
        var index = -1;
        for (var i = 0, len = this.options.data.getLength(); i < len; i++) {
            if (this.options.data.getRecord(i).getContent().id == id) {
                index = i;
                break;
            }
        }
        this.removeItem($("#" + this.id + this.options.cpPrefix + index, this.element));
    },

    popData: function (data) {
        this.doClear();
        this.options.data = new FR.SynchronData({
            dataSource: new FR.SynchronObjectSource({
                object: data
            }),
            dataReader: new FS.ListReader()
        });
        this.jlist();
        if (this.getSelectedIndex() < 0) {
            this.fireEvent(FR.Events.NOSELECT);
        }
    },

    /*b:multi ѡitem*/
    clearChoose: function () {
        var lis = this.selectedLis;
        while (lis && lis.length > 0) {
            lis[0].setSelected(false);
        }
    },

    removeSelect: function () {
        this.removeSelectedItem();
        if (this.getSelectedIndex() < 0) {
            this.fireEvent(FR.Events.NOSELECT);
        }
    },

    /*b:multi ѡitemظ*/
    selecteByID: function (ids) {
        if (!this.options.multi || !ids) {
            return;
        }

        var ali = $('li', this.element);
        for (var i = 0, len = ali.length; i < len; i++) {
            var li = $(ali[i]), index = li.attr('id').split(this.options.cpPrefix)[1];
            if (ids.indexOf(this.options.data.getRecord(index).getContent().id) > -1) {
                li.data('checkbox').setSelected(true);
            } else {
                li.data('checkbox').setSelected(false);
            }
        }
    },

    setValueByID: function (id) {
        var index = -1, data = this.options.data;
        for (var i = 0, len = data.getLength(); i < len; i++) {
            if (data.getRecord(i).getContent().id == id) {
                index = i;
                break;
            }
        }
        var id = this.id + this.options.cpPrefix + index;
        $('#' + id, this.element).triggerHandler('click');
    },

    getSelectedID: function () {
        var records = this.getSelectedItems(), ids = [];
        for (var i = 0, len = records.length; i < len; i++) {
            ids.push(records[i].getContent().id);
        }
        return ids;
    },

    getSelectedDatas: function () {
        var records = this.getSelectedItems(), datas = [];
        for (var i = 0, len = records.length; i < len; i++) {
            datas.push(records[i].getContent());
        }
        return datas;
    }
});
$.shortcut('fslist', FS.List);

/**
 * FS.Combobox
 * //TODO FR.ComboBoxEditor
 */
FS.Combobox = FR.extend(FR.ComboBoxEditor, {
    _init: function () {
        FS.Combobox.superclass._init.apply(this, arguments);
        this.element.addClass('fs_combo');
    },

    checkValidate: function () {
        if (this.isValidate()) {
            return true;
        }
        FR.Msg.toast(this.errorMsg);
    },

    setValueByID: function (id) {
        var index = -1;

        this.shouldReBuildList();
        this.onTriggerClick();
        var data = this.options.data;

        for (var i = 0, len = data.getLength(); i < len; i++) {
            if (data.getRecord(i).getContent().id == id) {
                index = i;
                break;
            }
        }

        this._setSelectedIndex(index);
        this._selectWithoutTriggerEvent();
    },

    getSelectedID: function () {
        return this.options.data.getRecord(this._getSelectedIndex()) == null ? null : this.options.data.getRecord(this._getSelectedIndex()).getContent().id
    },

    reBuild: function (items) {
        this.options.data = null;
        this.options.items = items;
        this.initData();
        this.shouldReBuildList();
    }
});
$.shortcut('fscombo', FS.Combobox);

/**
 * FS.TreeCombo
 * //TODO FR.TreeComboBoxEditor
 */
FS.TreeCombo = FR.extend(FR.TreeComboBoxEditor, {
    _init: function () {
        FS.TreeCombo.superclass._init.apply(this, arguments);
        this.element.addClass('fs_treecombo');
        this.element.addClass('fs_combo');
    },

    setValueByID: function (id, triggerEvent) {
        this.onTriggerClick();
        var id = this.$view.attr('id') + "_" + id;
        $('#' + id, this.$view).triggerHandler('click', triggerEvent);
    },

    getSelectedID: function () {
        return this.$view.getTCT().getID();
    },

    reBuild: function (data) {
        this.options.data = data;
        this.shouldReBuildList();
    }
});
$.shortcut('fstreecombobox', FS.TreeCombo);

//TODO ɾ
FS.ToolbarButton = FR.extend(FR.Button, {
    _defaultConfig: function () {
        return $.extend(FS.ToolbarButton.superclass._defaultConfig.call(), {
            height: 26,
            width: 70
        });
    },

    _init: function () {
        FS.ToolbarButton.superclass._init.apply(this, arguments);
        this.element.addClass('fs_toolbarbutton');

        if (!this.options.noSelected) {
            this.on(FR.Events.CLICK, function () {
                this.element.addClass('fs_button_selected');
            });
        }
    }
});

FS.IconButton = FR.extend(FR.IconButton, {
    _defaultConfig: function () {
        return $.extend(FS.IconButton.superclass._defaultConfig.call(), {
            height: 21,
            width: 21,
            renderEl: $('<span>&nbsp;</span>')
        });
    },

    _init: function () {
        FS.IconButton.superclass._init.apply(this, arguments);
        this.element.addClass('fs_iconbutton');
    }
});

/* b:ɾList,λѡĩβڱѡлʱʾ
 * TODO ɾ
 */
FS.RemoveList = FR.extend(FS.List, {
    _defaultConfig: function () {
        return $.extend(FS.RemoveList.superclass._defaultConfig.apply(), {
            /*b:icon class*/
            removeSelf: 'fs_listremoveself'
        });
    },

    /*b:*/
    _init: function () {
        FS.RemoveList.superclass._init.apply(this, arguments);
    },

    getNames: function () {
        var names = [], data = this.options.data;
        for (var i = 0, len = data.getLength(); i < len; i++) {
            //ʹjs...ʾtitleвʵֵ
            names.push(data.getRecord(i).getTitleValue());
        }
        return names;
    },

    addName: function (name) {
        this.addSimpleData(name);
    }
});

/**
 * wei : FSĿ¼һ⣬лղغͱַʽؼ
 */
FS.NavigationTree = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.NavigationTree.superclass._defaultConfig.call(), {
            topDivCls: "fs_navigationtree_topdiv",
            topDivOverCls: "fs_navigationtree_topdiv_over",
            topDivIconCls: "fs_navigationtree_topdiv_icon",
            topDivTagsCls: "fs_navigationtree_topdiv_tags",
            topDivSplitCls: "fs_navigationtree_topdiv_split",
            topDivOpenIconCls: "fs_navigationtree_topdiv_open_icon",
            topDivIconMaskCls: "fs_navigationtree_topdiv_icon_mask",
            topDivSeparateCls: "fs_navigationtree_topdiv_separate",
            topDivTitleCls: "fs_navigationtree_topdiv_title",
            topDivCollapseCls: "fs_navigationtree_topdiv_collapse",
            topDivCollapseImgCls: "fs_navigationtree_topdiv_collapseimg",
            topDivExpandCls: "fs_navigationtree_expand",
            treeRenderCls: "fs_navigationtree_treerender",
            style: "black"
        });
    },

    _init: function () {
        FS.NavigationTree.superclass._init.apply(this, arguments);
        FR.$defaultImport("/com/fr/fs/web/css/" + this.options.style.toLowerCase() + "/fs.widget.navigationtree.css", "css");
        this._initTop();
        this._initAccordionTree();
    },

    /**
     * ʼ
     * @private
     */
    _initTop: function () {
        var o = this.options;
        this.favoriteOpen = false;
        var self = this;
        this.iconSpan = $('<span/>').addClass(o.topDivIconCls);
        this.topDiv = $("<div/>").addClass(o.topDivCls).appendTo(this.element);
        this.topTagsDiv = $("<div/>").addClass(o.topDivTagsCls)
            .appendTo(this.topDiv)
            .append(this.iconSpan)
            .append($('<span/>').addClass(o.topDivIconMaskCls).click(function () {
                var navigationTree = FS.navigationTree;
                if (self.favoriteOpen) {
                    //رղؼ
                    navigationTree.hideFavorite();
                    self.favoriteOpen = false;
                    self.iconSpan.switchClass(o.topDivOpenIconCls, o.topDivIconCls);
                } else {
                    //ղؼ
                    navigationTree.showFavorite();
                    self.favoriteOpen = true;
                    self.iconSpan.switchClass(o.topDivIconCls, o.topDivOpenIconCls);
                }
            }).mouseover(function () {
                    $(this).addClass(o.topDivOverCls);
                }).mouseout(function () {
                    $(this).removeClass(o.topDivOverCls);
                }))
            .append($('<span/>').addClass(o.topDivSeparateCls))
            .append($('<span unselectable="on"/>').addClass(o.topDivTitleCls).text(o.value).attr('title', o.value));
        this._addCollapseBtn();
        $('<div/>').addClass(o.topDivSplitCls).appendTo(this.topDiv);
    },

    /**
     * ö
     * @private
     */
    _setTopText: function (text) {
        $('.' + this.options.topDivTitleCls, this.topDiv).text(text).attr("title", text);
    },

    /**
     * ʼ
     * @private
     */
    _initAccordionTree: function () {
        var roots = FR.jsonDecode(FS.config.roots);
        this.treeRender = $("<div/>").attr("id", this.options.treeRenderCls).appendTo(this.element);
    },

    /**
     * 
     * @param content:ݶӦjquery
     * @param treefolderid:Ŀ¼id
     */
    _refreshContent: function (content, treefolderid) {
        this.treeRender.empty();
        this.treeRender.append(content);
        this.iconSpan.switchClass(this.options.topDivIconCls);
        this.favoriteOpen = false;
        if (treefolderid) {
            this.treefolderid = treefolderid;
        } else {
            delete this.treefolderid;
        }
    },

    /**
     * չʾղؼ
     */
    showFavorite: function () {
        this.originalContent = {
            text: $('.' + this.options.topDivTitleCls, this.topDiv).text(),
            content: this.treeRender.children()
        };
        this._setTopText(FR.i18nText('Favorite'));
        var reportTree = FS.createTreeContent({}, null, false, true);
        this.favoriteContent = reportTree.element;
        this.originalContent.content.hide();
        this.treeRender.append(this.favoriteContent);
        reportTree._addOddAndEvenStyle();
    },

    /**
     * ղؼ
     */
    hideFavorite: function () {
        this._setTopText(this.originalContent.text);
        this.favoriteContent.remove();
        this.originalContent.content.show();
    },

    /**
     * ť
     * @private
     */
    _addCollapseBtn: function () {
        var o = this.options;
        var collapseBtn = $('<div/>').attr('id', o.topDivCollapseCls).append(
                $('<span/>').attr('id', o.topDivCollapseImgCls)
            ).click(function () {
                var westWidth = FS.border.regionField['west'].width;
                FS.border.setRegionWH('west', FS.leftMargin);
                FS.border.doLayout();
                //չť
                FS.border.regionField['west'].el.resizable({disabled: true});
                var expandBtn = $('<div/>').css({'left': -12}).attr('id', o.topDivExpandCls).click(function () {
                    var self = this;
                    FS.border.setRegionWH('west', westWidth);
                    FS.border.doLayout();
                    $(self).remove();
                    FS.border.regionField['west'].el.resizable({disabled: false});
                }).appendTo(FS.center);
            }).appendTo(this.topDiv);
    },

    /**
     * ıС
     * @param give : ߵjson
     */
    doResize: function (give) {
        this.treeRender.height(this.element.height() - 37 - 1); // -1Ǳ߿
        if (FR.Browser.isIE6()) {
            //ie6¹̶ʾtext-overflow...
            var treewidth = this.element.width();
            if (give && give.width) {
                treewidth = give.width
            }
            var textwraps = $('.fr-tree-node-textwrap', this.treeRender);
            for (var i = 0; i < textwraps.length; i++) {
                var textwrap = $(textwraps[i]);
                var layer = $('img', textwrap.parent()).length;
                textwrap.width(treewidth - 65 - 20 * layer);
            }
        }
    }
});
$.shortcut("navigationtree", FS.NavigationTree);

/**
 * wei : ť
 */
FS.NavigationItem = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.NavigationItem.superclass._defaultConfig.call(), {
            itemCls: "fs_navigation_item",
            iconCls: "fs_navigation_icon",
            editIconCls: "fs_navigation_edit_icon",
            textCls: "fs_navigation_text",
            itemOverCls: "fs_navigation_item_over",
            itemCanEditOverCls: "fs_edit_navigation_item_over",
            itemClickCls: "fs_navigation_item_click",
            itemCanEditClickCls: "fs_edit_navigation_item_click",
            canEditCls: "fs_navigation_item_canedit"
        });
    },

    _init: function () {
        FS.NavigationItem.superclass._init.apply(this, arguments);
        var o = this.options;
        var self = this;
        this.wrap = $("<div/>").addClass(o.itemCls).appendTo(this.element)
            .click(function (e, showSelf) {
                self.onClick(showSelf);
            }).mouseover(function () {
                if (o.canEdit === true) {
                    if (!self.editIcon) {
                        self.eidtOverLayer = $("<div/>").addClass(o.itemCanEditOverCls).appendTo(self.wrap);
                        self.editIcon = $("<div/>").addClass(o.editIconCls).appendTo(self.wrap);
                    }
                    self.eidtOverLayer.addClass(o.itemCanEditOverCls);
                    self.editIcon.addClass(o.editIconCls);
                } else {
                    $(this).addClass(o.itemOverCls);
                }
            }).mouseout(function () {
                $(this).removeClass(o.itemOverCls);
                if (self.editIcon) {
                    self.eidtOverLayer.removeClass(o.itemCanEditOverCls);
                    self.editIcon.removeClass(o.editIconCls);
                }
            });
        var emptyImgsrc = FR.servletURL + '?op=resource&resource=/com/fr/web/core/js/jquerytree/images/s.gif';
        this.icon = $("<img/>").addClass(o.iconCls).appendTo(self.wrap);
        this.icon.attr("src", emptyImgsrc);//ȥ߿
        var text = $("<div/>").addClass(o.textCls)
            .text(o.text).appendTo(self.wrap);
        this._initIcon();
    },

    onClick: function (showSelf) {
        var o = this.options;
        var self = this;
        if (o.canEdit === true) {
            self.eidtOverLayer.addClass(o.itemCanEditClickCls);
        } else {
            if (FS.needMoreNavigation && self.selected && !showSelf) {
                var navigationTree = FS.navigationTree;
                navigationTree._setTopText(FR.i18nText('SystemMenu'));
                var reportTree = FS.createTreeContent(FR.jsonDecode(FS.config.roots), -1);
                navigationTree._refreshContent(reportTree.element);
                reportTree._addOddAndEvenStyle();
                self.removeSelect();
                return;
            }
            self.bar.removeSelect();
            self.wrap.addClass(o.itemClickCls);
            self.selected = true;
        }
        if (o.clickFun) {
            self.eidtOverLayer.addClass(o.itemCanEditClickCls);
            self.editIcon.addClass(o.editIconCls);
            o.clickFun.call(self);
            return;
        }
        var navigationTree = FS.navigationTree;
        navigationTree._setTopText(o.text);
        var reportTree = self._createTreeContent();
        navigationTree._refreshContent(reportTree.element, self.options.treefolderid);
        reportTree._addOddAndEvenStyle();
    },

    /**
     * ѡаť
     */
    select: function () {
        var o = this.options;
        $('.' + o.itemCls, this.element).addClass(o.itemClickCls);
        this.selected = true;
    },

    /**
     * ȡѡ
     */
    removeSelect: function () {
        var o = this.options;
        $('.' + o.itemCls, this.element).removeClass(o.itemOverCls);
        $('.' + o.itemCls, this.element).removeClass(o.itemClickCls);
        $('.' + o.editIconCls, this.element).removeClass(o.editIconCls);
        this.selected = false;
    },

    _initIcon: function () {
        if (this.options.cls) {
            //class
            this.icon.addClass(this.options.cls);
        } else if (this.options.iconImgID) {
            //ԶͼƬ
            var url = FR.servletURL + '?op=fr_attach&cmd=ah_image&id=' + this.options.iconImgID + '&isAdjust=false';
            var isIE6 = $.browser.msie && $.browser.version == '6.0';
            if (isIE6) {
                var filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader" + "(src='" + url + "', sizingMethod='scale')";
                this.icon.css("filter", filter);
            } else {
                this.icon.attr("src", url);
            }
        }
    },

    _createTreeContent: function () {
        if (this.options.treeContent) {
            return FS.createTreeContent(this.options.treeContent, null, false);
        } else if (this.options.treefolderid) {
            var treedata = {};
            return FS.createTreeContent(treedata, this.options.treefolderid);
        }
    }
});
$.shortcut("navigationitem", FS.NavigationItem);

/**
 * wei : 
 */
FS.NavigationBar = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.NavigationBar.superclass._defaultConfig.call(), {

        });
    },

    _init: function () {
        FS.NavigationBar.superclass._init.apply(this, arguments);
        this._createItems();
    },

    _createItems: function () {
        this.navigationItems = [];
        var items = this.options.items;
        if (items && items.length > 0) {
            for (var i = 0, len = items.length; i < len; i++) {
                var navigationItem = new FS.NavigationItem(items[i]);
                navigationItem.bar = this;
                this.navigationItems.push(navigationItem);
                this.element.append(navigationItem.element);
            }
        }
    },

    /**
     * ȡаťѡ״̬
     */
    removeSelect: function () {
        for (var i = 0, len = this.navigationItems.length; i < len; i++) {
            this.navigationItems[i].removeSelect();
        }
    },

    /**
     * idöӦĵť
     */
    getItemByFolderID: function (treefolderid) {
        for (var i = 0; i < this.navigationItems.length; i++) {
            if (this.navigationItems[i].options.treefolderid === treefolderid) {
                return this.navigationItems[i];
            }
        }
    },

    /**
     * ȡϵͳӦĵť
     */
    getManagerItem: function () {
        for (var i = 0; i < this.navigationItems.length; i++) {
            if (this.navigationItems[i].options.managersystem === true) {
                return this.navigationItems[i];
            }
        }
    }
});

/**
 * ˢ£Ӳбؼ
 */
FS.ParameterGrid = FR.extend(FR.Widget, {
    _init: function () {
        FS.ParameterGrid.superclass._init.apply(this, arguments);
        this.createGrid();
        this.createToolBtn();
    },

    createGrid: function () {
        var self = this;
        var parameterGridConfig = {
            type: 'lgrid',
            widgetName: this.options.widgetName,
            pagecount: 1000,
            isFootShow: false,
            width: this.options.width,
            firstColumnPaddingLeft: 0,
            columnsconfig: [
                {
                    text: '',
                    showValue: '',
                    width: 10
                },
                {
                    text: 'name',
                    showValue: FR.i18nText('WF-Name'),
                    width: 80,
                    sort: false,
                    valueToHtml: function (name, item) {
                        var editTask = $("<div/>").text(name).width(80).addClass('fs_paragrid_limitlendiv');
                        editTask.css({'cursor': 'pointer'});
                        return editTask;
                    },
                    clickFunc: function (item, el) {
                        self._clickShow(item, el, "name", 75);
                    }
                },
                {
                    text: 'type',
                    showValue: FR.i18nText('FS_Report_Type'),
                    width: 88,
                    valueToHtml: function (type, item) {
                        var combo = new FR.ComboBoxEditor({
                            type: "combo",
                            width: 88,
                            directEdit: false,
                            allowBlank: false,
                            mode: 'local',
                            items: [
                                {value: "String", text: FR.i18nText('Parameter-String')},
                                {value: "Integer", text: FR.i18nText('Parameter-Integer')},
                                {value: "Double", text: FR.i18nText('Parameter-Double')},
                                {value: "Boolean", text: FR.i18nText('Parameter-Boolean')},
                                {value: "Formula", text: FR.i18nText('Parameter-Formula')}
                            ],
                            listeners: [
                                {
                                    eventName: 'afteredit',
                                    action: function () {
                                        var value = this.getValue();
                                        item['type'] = value;
                                    }
                                }
                            ]
                        });
                        combo.setValue(type);
                        return combo.element;
                    }
                },
                {
                    text: 'value',
                    showValue: FR.i18nText('Value'),
                    width: 120,
                    valueToHtml: function (name, item) {
                        var editTask = $("<div/>").text(name).width(120).addClass('fs_paragrid_limitlendiv');
                        editTask.css({'cursor': 'pointer'});
                        return editTask;
                    },
                    clickFunc: function (item, el) {
                        self._clickShow(item, el, "value", 115);
                    }
                },
                {
                    text: '',
                    showValue: '',
                    width: 45
                },
                {
                    text: '',
                    showValue: '',
                    width: 45,
                    valueToHtml: function () {
                        return $("<div/>").addClass('delete_item');
                    },
                    clickFunc: function (item, el, e, i) {
                        self.grid.removeDataAtIndex(i);
                    }
                }
            ],
            items: []
        };
        this.grid = new FS.LGrid(parameterGridConfig);
        this.grid.element.appendTo(this.element);
    },

    _clickShow: function (item, el, key, width) {
        var value = el.text();
        el.html('');
        var editInput = $('<input />').width(width).val(value).appendTo(el);
        editInput.focus();

        if (editInput[0].attachEvent) {
            editInput[0].attachEvent('onpropertychange', function (e) {
                e.cancelBubble = true;
            });
        }
        editInput.on('click', function (e) {
            e.stopPropagation();
        });
        editInput.blur(function (event) {
            value = editInput.val();
            el.html('');
            el.text(value);
            item[key] = value;
            event.stopPropagation();    //ģȻenterԶǳ֪ԭ
        });
    },

    createToolBtn: function () {
        var self = this;
        var parameters_widget = this.grid;
        var addable_th = $(parameters_widget.element).find('th:last');
        var $add_div = $('<div/>').addClass('add_parameter').appendTo(addable_th);
        var $refresh_th = $(parameters_widget.element).find('th').eq(-2);
        var $refresh_div = $('<div/>').addClass('refresh_parameter').appendTo($refresh_th);
        $add_div.click(function () {
            $add_div.addClass('add_blue-click');
            var parameter_items = parameters_widget.getAllData();
            var blankItem = {'name': '', 'type': 'String', 'value': ''};
            parameter_items.push(blankItem);
            parameters_widget.popData(parameter_items);
        }).mouseover(function () {
                $add_div.addClass('add_blue-hover');
            }).mouseout(function () {
                $add_div.removeClass('add_blue-hover');
                $add_div.removeClass('add_blue-click');
            });
        $refresh_div.click(function () {
            if (!self.reportletPath) {
                return;
            }
            $refresh_div.addClass('refresh_blue-click');
            FR.ajax({
                url: FR.servletURL + "?op=fs_entry&cmd=genparameters",
                type: 'POST',
                asyn: false,
                data: {reportPath: self.reportletPath},
                complete: function (res, status) {
                    if (!res.responseText) {
                        return;
                    }
                    var parameters;
                    try {
                        parameters = FR.jsonDecode(res.responseText);
                    } catch (e) {
                        FR.Msg.toast("Parameter parse error!");
                        return;
                    }
                    parameters_widget.popData(parameters);
                }
            });
        }).mouseover(function () {
                $refresh_div.addClass('refresh_blue-hover');
            }).mouseout(function () {
                $refresh_div.removeClass('refresh_blue-hover');
                $refresh_div.removeClass('refresh_blue-click');
            });
    },

    /**
     * չ
     * @param data : Ҫչֵ
     */
    popData: function (data) {
        this.grid.popData(data);
    },

    /**
     * ȡ
     */
    getData: function () {
        return this.grid.getAllData()
    }
});
$.shortcut("parametergrid", FS.ParameterGrid);