FR.ADHOCCONFIG = {};
$.extend(FS.Trans, {
	getRegList : function(){
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_custom_reg"
		})
	},
	
	addReg : function(regName){
		return FS.Trans.ajax({
			url	: FR.servletURL + "?op=fr_adhoc&cmd=ac_add_customreg",
			data : {regname : regName}
		})
	},
	
	editReg : function(oldRegName, newRegName){
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_edit_customreg",
			data : {oldregname : oldRegName,
					 newregname : newRegName }
		})
	},
	
	removeReg : function(removeRegName) {
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_remove_customreg",
			data : {removeregname : removeRegName}	
		})
	},
	
	getDataPreview : function (dataname) {
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=priview_ac_datasource",
			data : {
				dataname : dataname
			}
		})
	},
	
	getdbTablePreview : function (data) {
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_dbtable_preivew",
			data : data
		})
	}
})
FR.PreviewButton = FR.extend(FR.IconButton, {
	 _defaultConfig : function () {
        return $.extend(FR.PreviewButton.superclass._defaultConfig.apply(), {
            title : "Ԥ",
            imgsrc : 'fr-adhoc-preview'
        });
    },
    
    _init : function() {
        FR.PreviewButton.superclass._init.apply(this, arguments);
        var o = this.options;
        this.on(FR.Events.CLICK, function(e){
        	if ($.isFunction(o.previewHandler)){
        		var loading = {
					overlay_immediately : true,
					text : "..."
				};
				FR.showLoadingDialog(loading);
        		var content = o.previewHandler();
        		if(!content){
        			content = {};
        			content.npe = true;
        			content.colModel = [{'display':'error', 'name':'error', 'align':'center', 'width':420}];
        			content.content = '<table class="frflex"><tr><td>previewHandler returns null, please check your selects</td></tr></table>'
        		}
        		var dialogContent = $('<div style="overflow:auto;' +
        				'width:435px;left:5px;top:5px;right:5px;' +
        				'height:370px;position:absolute"></div>').append(content.content)
	        	var dialog = new FR.Dialog({
	 				title : FR.i18nText("Preview"),
	 				width : 450,
	 				height : 450,
	 				confirm : true,
                    contentHtml : dialogContent
	 			});
                dialog.setVisible(true);
	 			$('.frflex').flexigrid({height:315, 
	 							nowrap : false, 
					 			minheight : 285,
					 			colModel : content.colModel,
					 			resizable : false});
				var waringLabel = $('<span style="color:red">ע:Ԥʾ100</span>').appendTo(dialogContent);
				if(content.npe){
					waringLabel.hide();
				} else {
					waringLabel.show();
				}
				FR.hideLoadingDialog();
	        } else {
	        	alert('a previewHandler option is needed as a function object');
	        }
        });
    }
	
})
$(function() {	
	$.extend(FR.ADHOCCONFIG, {
		northContent : $('<div/>').addClass('adhoc_data_north'),
		
		centerContent : $('<div/>').addClass('adhoc_data_center'),
		
		_initNorth : function() {
			$.extend(this.northContent, {
				logoImg : function() {
					return $('<div/>').addClass('adhoc_data_logo').append($('<img/>').attr('src', FR.servletURL + "?op=resource&resource=/com/fr/base/images/oem/logo_title.png"));
				},
				
				viewDesign : function() {
					var self = this;
					var data = $('<li/>').addClass('adhoc_data_design_module').click(function(e) {
						self.dataFaceShow();
						self.embellishState().createDelegate(this);
					});
					var img = $('<img/>').addClass('adhoc_data_design_img').attr('src', FR.servletURL + '?op=resource&resource=/com/fr/web/images/adhoc/data_design.png');
					return data.append(img).append($('<span/>').addClass('adhoc_data_modulefont').text('Դ'));
				},
				
				defaultState : function() {
					this.vd.addClass('adhoc_module_selected');
					this.dataFaceShow();
				},
				
				embellishState : function() {
					this.siblings.removeClass('adhoc_module_selected');
					this.addClass('adhoc_module_selected');
				},
				
				dataFaceShow : function() {
					FR.ADHOCCONFIG.centerContent.dataFace.visible();
				},
				
				adhocModules : function() {
					this.vd = this.viewDesign();
					return $('<div/>').addClass('adhoc_data_module').append($('<ul/>').addClass('adhoc_data_moduleul').append(this.vd));
				},
				
				_init : function() {
					this.append(this.logoImg()).append(this.adhocModules());	
					this.defaultState();
				}
			});
			
			this.northContent._init();
		},
		
		_initCenter : function() {
			$.extend(this.centerContent, {
					dataFace : {
						_init : function() {
							this.content = $('<div/>').addClass('adhoc_data_design');
							this.ba = this.dataToolbar.getContent();
							this.nl = $('<div/>').append(this.dataNameList.getContent());
							this.pf = this.propertiesFace.getContent();
							this.content.hide();
							if (!this.globePane) {
								this.globePaneInit();
							}				
							this.globePane.show();
						},
						
						getContent : function() {
							if (!this.content) {
								this._init();
							}
							return this.content;
						},
						
						getToolBar : function () {
							if (!this.toolbar) {
								this.barInit();
							}
							return this.toolbar;
						},
						
						getGlobePane : function () {
							if (!this.globePane) {
								this.globePaneInit();
							}
							return this.globePane;
						},
						
						barInit : function() {
							this.toolbar = $('<div/>').attr('id', 'adhoc_authtoolbar');
							var self = this;
							this.dataMingButton = new FS.ToolbarButton({
								text : '',
								height : 24,
								width : 76,
								handler : function() {
									self.globeButton.element.removeClass('fs_button_selected');
									if (self.globePane) {
										self.globePane.hide();
									}
									self.content.show();				
								}
							});
							this.dataMingButton.element.addClass('fs_button_selected');
							this.globeButton = new FS.ToolbarButton({
								text : 'ȫ',
								height : 24,
								width : 84,
								handler : function() {
									self.dataMingButton.element.removeClass('fs_button_selected');
									self.content.hide();
									
									if (!self.globePane) {
										self.globePaneInit();
									}				
									self.globePane.show();
								}
							});
							this.toolbar
							.append(this.dataMingButton.element.addClass('adhoc_databutton'))
							.append(this.globeButton.element.addClass('adhoc_orgnizebutton'));
						},
						
						globePaneInit : function () {
							this.globePane  =  $('<div/>').attr('id', 'adhoc_globe_setting');
						},
						
						globeSettingPane : function (){
							var self = this;
							var globePane = this.globePane;
							var pa = globePane.parent();
							globePane.width(pa.width()).height(pa.height() - 53);
							self.createRegList()
							globePane.append(self.sortReg.element);
						},
						
						createRegList : function() {
							var positionbar = $('<div/>').attr('id', 'adhoc_auth_regbar');
				
							var self = this;
							this.addreg = new FR.IconButton({
				 				title : 'ӹ',
				 				height : 21,
								width : 21,
				 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
				 				baseClass : 'fr_auth_addreg',
				 				disabled : false,
				 				handler : function() {
				 					self.regDialogShow();
				 				}
				 			});
				 			var editreg = new FR.IconButton({
				 				title : '༭',
				 				height : 21,
								width : 21,
				 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
				 				baseClass : 'fr_auth_editreg',
				 				handler : function() {
				 					self.regDialogShow(self.sortReg.getSelectedData().text);
				 				},
				 				disabled : true
				 			}), removereg = new FR.IconButton({
				 				title : 'ɾ',
				 				height : 21,
								width : 21,
				 				renderEl : $('<span>&nbsp;</span>').appendTo(positionbar),
				 				baseClass : 'fr_auth_removereg',
				 				handler : function() {
				 					FR.showAsyncDialog({
				 						callback : function() {
				 							FS.Trans.removeReg(self.sortReg.getSelectedData().text);
				 							self.sortReg.removeSelectedData();
				 						}
				 					});					
				 				},
				 				disabled : true
				 			});
				
							this.sortReg = new FS.BarList({
								title : 'Զ:',
								barcontent : positionbar,
								items : [],
								width : 450,
								height : 450
							});
							var es = FS.Trans.getRegList();
							self.sortReg.popData(es);
							this.sortReg.element.css("margin-top","15px").css("margin-left", "18px");
							this.sortReg.on(FR.Events.CLICK, function() {
								editreg.setEnable(true);
								removereg.setEnable(true);
							});
							this.sortReg.on(FR.Events.NOSELECT, function() {
								editreg.setEnable(false);
								removereg.setEnable(false);				
							});
							this.sortReg.on(FR.Events.APPENDDATA, function(sortReg) {
								FS.Trans.addReg(sortReg.text);
							});
							this.sortReg.on(FR.Events.EDITDATA, function(sortReg) {
								FS.Trans.editReg(sortReg.oldname, sortReg.text);
							});
							this.sortReg.on(FR.Events.REMOVEDATA, function(sortReg) {
							});
						},
						
						regDialogShow : function(reg){
							this.showName = reg;
							var self = this;
                            var dialog = new FR.Dialog({
                                title : reg == null ? 'ӹ' : '޸Ĺ',
                                confirm: true,
                                height: 150,
                                width: 345,
                                contentWidget: {
                                    type: 'absolute',
                                    items: [
                                        {
                                            el: {
                                                type: 'label',
                                                value: 'Զ:'
                                            },
                                            x: 15,
                                            y: 12
                                        },
                                        {
                                            el: {
                                                type: 'text',
                                                height: 22,
                                                width: 180,
                                                widgetName: 'ruleWDName'
                                            },
                                            x: 120,
                                            y: 12
                                        }
                                    ]
                                },
                                onOK: function() {
                                    var value = this.getWidgetByName('ruleWDName').getValue();
                                    if (self.showName == null) {
                                        var newReg = {text : value};
                                        if (newReg) {
                                            self.sortReg.addData(newReg);
                                        }
                                    } else {
                                        var newData = {text : value, oldname : self.showName}
                                        self.sortReg.reData(newData);
                                    }
                                }
                            });
                            dialog.setVisible(true);
						},
						
						borderPane : function() {
							var self = this;
							var content = this.content;
							var pa = content.parent();
							this.toolbar;
							this.content.width(pa.width()).height(pa.height() - 53).css("top","53px");
							var contentLayout = new FR.BorderLayout({
								renderEl : content, items:[{
									region : 'north',
									el : this.ba,
									height:44
								},{
									region : 'west',
									el : this.nl,
									width : 200
								}, {
									region : 'center',
									el : this.pf
								}]});
							contentLayout.doLayout();
														
							$(window).resize(function() {
								content.width(pa.width()).height(pa.height() - 53);
								content.doLayout();
							});
						},
						
						dataToolbar : function() {
							var self = this;
							var bar = $('<div/>').addClass('adhoc_data_design_toolbar');
							var additems = [{
								src : 'SQLͼ',
								handler : function() {
									FR.ADHOCCONFIG.centerContent.dataFace.dataNameList.dsDialogShow('sql');
								}
							}, {
								src : 'ݼ',
								handler : function() {
									FR.ADHOCCONFIG.centerContent.dataFace.dataNameList.dsDialogShow('server');
								}
							}];
							var addConfig = {
								text : '',
								title : '½',
								renderEl : $('<span>&nbsp;</span>'),
								height : 21,
								width : 21,
								baseClass : 'adhoc_data_add',
								handler : function(e) {
									FR.showMenuByEvent({items: additems, destroyOnClose:false}, e||window.event, true);
								}
							};
							
							var editConfig = {
								text : '',
								title : '༭',
								renderEl : $('<span>&nbsp;</span>'),
								height : 21,
								width : 21,
								baseClass : 'adhoc_data_edit',
								handler : function(e) {
									FR.ADHOCCONFIG.centerContent.dataFace.dataNameList.dsDialogShow('edit');
								},
								disabled : true
							};
								
							var deleteConfig = {
								text : '',
								title : 'ɾ',
								renderEl : $('<span>&nbsp;</span>'),
								height : 21,
								width : 21,
								baseClass : 'adhoc_data_remove',
								handler : function() {
									FR.showAsyncDialog({
				 						callback : function() {
				 							FR.ADHOCCONFIG.centerContent.dataFace.dataNameList.removeData();
				 						}
									});
								},
								disabled : true
							};
							
							var addButton = new FR.IconButton(addConfig);
							
							var editButton = new FR.IconButton(editConfig);
							
							var removeButton = new FR.IconButton(deleteConfig);
	
							return {					
								setButtonEnable : function(enable) {
									editButton.setEnable(enable);
									removeButton.setEnable(enable);
								},
								
								createButtonTable : function(buttons) {
									var tr = $('<div/>').addClass('adhoc_data_design_toolbar_buttons');
									$.each(buttons, function(i, button) {
										tr.append(button.element);
									});
									return tr;
								},
								
								getContent : function() {
									return bar.append(this.createButtonTable([addButton, editButton, removeButton]));
								}
							};
						}(),
					
					
					
						dataNameList : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_list');
									config = {
										width : 168,
										height : 460
									};
									config.items = [];
									this.datesourceList = new FS.BarList($.extend({
										//renderEl : this.content,
										barcontent : FR.ADHOCCONFIG.centerContent.dataFace.dataToolbar.getContent()
									}, config));
									this.content.append(this.datesourceList.element);
									this.popuNames();
									var self = this;
									this.datesourceList.on(FR.Events.CLICK, function(e){
										self.clickNode();
									})
									
									this.datesourceList.on(FR.Events.NOSELECT, function() {
										FR.ADHOCCONFIG.centerContent.dataFace.dataToolbar.setButtonEnable(false);			
									});
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									return this.content;
								},
								
								popuNames : function() {
									var self = this;
									FR.ajax({
										url: FR.servletURL + '?op=fr_adhoc&cmd=ac_get_data_name',
										type: 'POST',
										complete : function(res, status) {
											try {
												var names = FR.jsonDecode(res.responseText);
												self.datesourceList.popData(names);
											} catch(e) {
												
											}
										}
									});
								},
								
								dsDialogShow : function (ds){
									var self = this;
									if (ds == 'edit') {	
										var data = self.datesourceList.getSelectedData();			
										this.showDs = data.text;
										this.dsType = data.value;
									} else { 
										this.showDs = null;
										this.dsType = ds =='sql'? 1:0;
									}
									var title = this.dsType == 0 ? '':"sql";
                                    var dialog = new FR.Dialog({
                                        title : this.showDs == null ? '' + title +'Դ' : '޸'+ title+'Դ',
                                        confirm: true,
                                        height: 150,
                                        width: 345,
                                        contentWidget: {
                                            type: 'absolute',
                                            items: [
                                                {
                                                    el: {
                                                        type: 'label',
                                                        value: 'Դ:'
                                                    },
                                                    x: 15,
                                                    y: 12
                                                },
                                                {
                                                    el: {
                                                        type: 'text',
                                                        height: 22,
                                                        width: 180,
                                                        widgetName: 'dataSourceWDName'
                                                    },
                                                    x: 140,
                                                    y: 12
                                                }
                                            ]
                                        },
                                        onOK: function() {
                                            var value = this.getWidgetByName('dataSourceWDName').getValue();
                                            if (self.showDs == null) {
                                                var newDs = {text : value, value:self.dsType, icon:'adhoc_design_list_icon_'+self.dsType};
                                                if (newDs) {
                                                    self.addNN(newDs);
                                                }
                                            } else {
                                                var newData = {text : value, oldname : self.showDs}
                                                self.editData(newData);
                                            }
                                        }
                                    });
                                    dialog.setVisible(true);
								} ,
								
								popuData : function(name) {
									var data = {};
									FR.ajax({
										url: FR.servletURL + '?op=fr_adhoc&cmd=deal_ac_dataname',
										type: 'POST',
										data: {dataname: FR.cjkEncode(name)},
										complete : function(res, status) {
											try {
												data = FR.jsonDecode(res.responseText);
												FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace.popu(data);
											} catch(e) {
												
											}
										}
									});
									return data;
								},							
								
								clickNode : function() {	
									var item = this.datesourceList.getSelectedData().text;	
									if (!item) {
										return;
									}
									
									FR.ADHOCCONFIG.centerContent.dataFace.dataToolbar.setButtonEnable(true);							
									this.popuData(item); 						
								},
								
								addNN : function(node) {
									if (!node.text) {
										return;
									}
									if (this.hasSameName(node.text)) {
										var i = 1;
										var temp = node.text;						
										while(this.hasSameName(node.text)) {
											node.text = temp + "" + i;
											i++;
										}
									}
									node.type = node.value;
									node.oldName = node.text;
									this.addNode(node);	
								},
								
								hasSameName : function (text) {
									var self = this;
									var items = self.datesourceList.getAll();
									var hasValue = false;
									$.each(items, function(idx, item){
									 	if(item.text === text) {
									 		hasValue = true;
									 		return false;
									 	}
									 	
									});
									return hasValue;
								},
								
								addNode : function(data) {
									var self = this;
									FR.ajax({
										url: FR.servletURL + '?op=fr_adhoc&cmd=add_ac_data',
										type: 'POST',
										data : {namedata: data},
										complete : function(res, status) {
											self.datesourceList.addData(data, true);	
										}
									});
								},							
										
								removeData : function() {
									var self = this;
									var name = this.datesourceList.getSelectedData().text;
									FR.ajax({
										url: FR.servletURL + '?op=fr_adhoc&cmd=remove_ac_data',
										type: 'POST',
										data : {dataname: FR.cjkEncode(name)},
										complete : function(res, status) {
											self.datesourceList.removeSelectedData();
										}
									});
								},
								
								editData : function(data) {
									var self = this;
									if (data.text === data.oldname) {
										return;
									}
									if (this.hasSameName(data.text)){
										var i = 1;
										var temp = data.text;						
										while(this.hasSameName(data.text)) {
											data.text = temp + "" + i;
											i++;
										}
									}
									FR.ajax({
										url: FR.servletURL + '?op=fr_adhoc&cmd=edit_ac_data',
										type: 'POST',
										data: {oldname: FR.cjkEncode(data.oldname), newname: FR.cjkEncode(data.text)},
										async : false,
										complete : function(res, status) {
											self.datesourceList.reData(data);
										}
									});
								}
						},
						
						propertiesFace : {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_face');
								this.content.append(this.basicInforFace.getContent());
								this.content.append(this.dataPane.getContent());	
								this.dataPane.unvisible();														
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;
							},
							
							basicInforFace : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_introduce');
									this.generateInforFace();
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();				
									}
									return this.content;
								},
								
								generateInforFace : function() {
									var info = this.getIntro();
									this.content.append($('<p/>').addClass('adhoc_design_intro_title').text(info.title));
									var ul = $('<ul/>').addClass('adhoc_design_intro_ul');
									$.each(info.description, function(i) {
										var li = $('<li/>').addClass('adhoc_design_intro_li').append($('<p/>').text(info.description[i]));
										ul.append(li);
									});
									this.content.append(ul);
								},
																
								getIntro : function() {
									var infor = {};
									infor.title = 'ڴҳʹӡ༭ɾB/SõԴ';
									infor.description = [];
									infor.description.push("B/SԴʱΪ࣬һͨ" +
											"ѡӺдSQLԴһֱʹǵķݼ");
									infor.description.push("ֶʾÿԶB/SԴֶ滻Ӷûݡ");
									infor.description.push("дûʹB/Sʱݵ;");
									
									return infor;
								},
								
								visible : function() {
									this.content.show();
								},
								
								unvisible : function() {
									this.content.hide();
								}
							},
							
							dataPane : {
									_init : function() {
										this.content = $('<div>').addClass('adhoc_design_dataPane');
										this.title = $('<p/>').addClass('adhoc_design_dataPane_title');
										this.content.append(this.title);
										this.content.append(this.generateContent());
									},
									
									generateSubmitButton : function() {
										var submitButton = $('<div/>').addClass('adhoc_design_dataPane_submitButton').css('float','right');
										
										var container =  $('<div/>').addClass('adhoc_design_dataPane_submitButton_container').append(submitButton).width(432).height(26).css('padding-top','6px');
										var self = this;
										new FR.Button({
											renderEl : submitButton,
											text : FR.i18nText("OK"),
											handler : function() {
												var data = FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace.createADHOCData();
												self.addData(data);
											}
										});
										return container;				
									},
									
									addData : function(data) {
										var self = this;
										FR.ajax({
											url : FR.servletURL + '?op=fr_adhoc&cmd=add_ac_data',
											type : 'POST',
											data : {namedata: data},
											complete : function(res, status) {
												if (res.responseText == 'success') {
													FR.Msg.toast(FR.i18nText("Successfully"));
													FR.ADHOCCONFIG.centerContent.dataFace.dataNameList.datesourceList.reData({oldname: self.getOldName(), text : self.getName()});
												} else {
													FR.Msg.toast(FR.i18nText("Failed") +':' + res.responseText);
												}
											}
										});
									},
									
									generateContent : function() {
										var div = $('<div/>').addClass('adhoc_design_dataPane_table');
										var face = FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace;
										var propertiesDIV = $('<div/>').append(this.generatePropertiesTable());
										var submitDIV =  $('<div/>').append(this.generateSubmitButton());
										var bottomDiv = $('<div/>').append(propertiesDIV).append(submitDIV);
										div.append(this.generateNameDIV())
											.append(face.sqlFace.getContent(bottomDiv))
											.append(face.namedFace.getContent(bottomDiv))
										return div;
									},
									
									generateNameDIV : function() {
										var div = $('<div/>').height(26);
										$('<div/>').addClass('adhoc_design_dataPane_field_name').css('float','left').css('line-height','26px').text('Դ:').appendTo(div);
										this.viewName = new FR.TextEditor({
											renderEl : $('<div/>').css('float','left').appendTo(div),
											width:120
										})
										return div;
									},
									
									generateDesTR : function() {
										var tr = $('<tr/>').addClass('adhoc_design_dataPane_table_descriptd');
										var ntd = $('<td/>').addClass('adhoc_design_dataPane_table_nametr')
										$('<div/>').addClass('adhoc_design_dataPane_field_name').text('Դ:').appendTo(ntd);
										//this.description = $('<textarea/>').addClass('adhoc_design_dataPane_descrip').attr({cols : '45', rows : '5'});
										var dtd =$('<td/>').append(this.description);
										this.description = new FR.TextEditor({
											renderEl : dtd,
											multiline : true,
											height:80,
											width:360
										})
										return tr.append(ntd).append(dtd);
									},
									
									generatePropertiesTable : function() {										
										var face = FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace;
										var table = $('<table cellpadding="0" cellspacing="0" border="0"></table>').addClass('adhoc_design_dataPane_propertiestable');
										var tr = $('<tr/>').addClass('adhoc_design_dataPane_propertiestable_tr');
										var semanTD = $('<td/>').attr('colspan','2').addClass('adhoc_design_dataPane_propertiestable_semantd')
											.append(face.semantic.getContent());
										tr.append(semanTD);
										return table.append(tr).append(this.generateDesTR());
									},
									
									setName : function(name) {
										this.oldName = name;
										this.viewName.setValue(name);
									},
									
									getName : function() {
										return this.viewName.getValue();
									},
									
									getOldName : function(){
										return this.oldName;
									},
									
									setDes : function(des) {
										this.description.setValue(des);
									},
									
									getDes : function() {
										return this.description.getValue();
									},
									
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									visible : function() {
										this.content.show();
									},
									
									unvisible : function() {
										this.content.hide();
									},
									
									setTitle : function(value) {
										this.title.val(value);
									}
							},
							
							semantic : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_semantic');
									var table = $('<table cellpadding="0" cellspacing="0" border="0"></table>').addClass('adhoc_design_semantic_table');
									table.append(this.generateTitleTR().height(24));
									table.append(this.generateDataTableTR().height(24));
									table.append(this.generateOTR().height(24));
									this.content.append(table);
								},
								
								generateTitleTR : function() {
									return $('<tr/>').append($('<td colspan="2">ֶʾ</td>').addClass('adhoc_design_semantic_title'));
								},
								
								generateDataTableTR : function() {
									var tr = $('<tr/>');
									var td = $('<td/>')
									var title = $('<div/>').text('ѡֶת:');
									var sitd = $('<div/>').addClass('adhoc_design_semantic_font')
									$('<div/>').addClass('adhoc_design_dataPane_field_name').text(':').appendTo(sitd);
									var link = $('<div/>').addClass('adhoc_design_semantic_link');
									var itd = $('<div/>').append(link);
									var self = this;
									var config = {
										directEdit : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=get_ac_datasource_name'
									};
									this.linkCombo = new FR.ComboBoxEditor($.extend({renderEl : $("<div/>").appendTo(link)}, config));
									this.linkCombo.on(FR.Events.AFTEREDIT, function(e){
										self.tableNameCombo.rebuild({widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=ac_table_name&datalink=' + this.getValue()});
									});
									var sstd = $('<div/>').addClass('adhoc_design_semantic_font').text(':');
									var tn = $('<div/>').addClass('adhoc_design_semantic_tablename');
									var ttd = $('<div/>').append(tn);
									config = {
										directEdit : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=ac_table_name&datalink=' + self.linkCombo.getValue()
									};
									this.tableNameCombo = new FR.ComboBoxEditor($.extend({renderEl : $("<div/>").appendTo(tn)}, config));
									this.tableNameCombo.on(FR.Events.AFTEREDIT, function(e){
										self.oinput.rebuild({widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=ac_tablecol_name&tablename=' + FR.cjkEncode(this.getValue())+'&datalink='+FR.cjkEncode(self.linkCombo.getValue())});
										self.einput.rebuild({widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=ac_tablecol_name&tablename=' + FR.cjkEncode(this.getValue())+'&datalink='+FR.cjkEncode(self.linkCombo.getValue())});
									});
									var ptd = $('<td/>')
									this.previewButton = new FR.PreviewButton({
										renderEl : $('<div/>').appendTo(ptd),
										previewHandler : function(){
											var value = self.linkCombo.getValue();
											var table = self.tableNameCombo.getValue();
											if(value && value != 0 && table && table != 0)
												return FS.Trans.getdbTablePreview({datalink:value,tablename:table});
											else
												return null;
										}
									})
									tr.append(td.append(title).append(sitd).append(itd).append(sstd).append(ttd))
									$('td > div', tr).css('float', 'left').css('line-height','22px').css('padding-left', '8px');
									$('div:eq(0)', tr).css('padding-left','0px');
									return tr.append(ptd);
								},
								
								generateOTR : function() {
									var tr = $('<tr/>');
									var td = $('<td colspan="2"></td>')
									var sotd= $('<div/>').addClass('adhoc_design_semantic_font').text('ԭֶ:');
									var otext = $('<div/>').addClass('adhoc_design_semantic_otext');
									var otd = $('<div/>').append(otext);
									var self = this;
									var config = {
										directEdit : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=ac_tablecol_name&tablename=' + FR.cjkEncode(self.tableNameCombo.getValue())+'&datalink='+FR.cjkEncode(self.linkCombo.getValue())
           							};
									this.oinput = new FR.ComboBoxEditor($.extend({renderEl : $("<div/>").appendTo(otext)}, config));
									var setd= $('<div/>').addClass('adhoc_design_semantic_font').text('Ŀֶ:');
									var etext = $('<div/>').addClass('adhoc_design_semantic_etext');
									var etd = $('<div/>').append(etext);
									config = {
										directEdit : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl :  FR.servletURL + '?op=fr_adhoc&cmd=ac_tablecol_name&tablename=' + FR.cjkEncode(self.tableNameCombo.getValue())+'&datalink='+FR.cjkEncode(self.linkCombo.getValue())
           							};
									this.einput = new FR.ComboBoxEditor($.extend({renderEl : $("<div/>").appendTo(etext)}, config));
									tr.append(td.append(sotd).append(otd).append(setd).append(etd));
									$('td > div', tr).css('float', 'left').css('line-height','22px').css('padding-left', '8px');
									$('div:eq(0)', tr).css('padding-left','0px');
									return tr;
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									return this.content;
								},
								
								popu : function(data) {
									if (!data.semantic) {
										this.cleanState();
										return;
									}
									this.linkCombo.setValue(data.semantic.databaseName);
									this.linkCombo.fireEvent(FR.Events.AFTEREDIT);
									this.tableNameCombo.setValue(data.semantic.tableName);
									this.tableNameCombo.fireEvent(FR.Events.AFTEREDIT);
									this.oinput.setValue(data.semantic.keyIndex);
									this.oinput.fireEvent(FR.Events.AFTEREDIT);
									this.einput.setValue(data.semantic.valueIndex);
									this.einput.fireEvent(FR.Events.AFTEREDIT);
									if (data.semantic.databaseName) {
										this.tableNameCombo.options.widgetUrl = FR.servletURL + '?op=fr_adhoc&cmd=ac_get_data_name&datalink=' + data.semantic.databaseName;
									}
								},
								
								cleanState : function() {
									this.linkCombo.setValue('');
									this.linkCombo.fireEvent(FR.Events.AFTEREDIT);
									this.tableNameCombo.setValue('');
									this.tableNameCombo.fireEvent(FR.Events.AFTEREDIT);
									this.oinput.setValue('');
									this.oinput.fireEvent(FR.Events.AFTEREDIT);
									this.einput.setValue('');
									this.einput.fireEvent(FR.Events.AFTEREDIT);
								},
								
								getSemantic : function() {
									var semantic = {};
									semantic.databaseName = this.linkCombo.getValue();
									semantic.tableName = this.tableNameCombo.getValue();
									semantic.keyIndex = this.oinput.getValue();
									semantic.valueIndex = this.einput.getValue();
									if (semantic.databaseName != null 
										&& semantic.tableName != null
										&& semantic.keyIndex != undefined
										&& semantic.valueIndex != undefined
										&& semantic.databaseName != "" 
										&& semantic.tableName != "") {
										return semantic;
									} else {
										return null;
									}									
								}
							},

							sqlFace : {
								_init : function() {
									this.content = $('<div/>');
									var titleDiv = $('<div>').appendTo(this.content);
									titleDiv.append(this.generateTitleTable());
									var centerDiv = $('<div/>').appendTo(this.content).height(280);
									var leftDiv = $('<div/>').css('float','left').width(200).appendTo(centerDiv);
									leftDiv.append(this.generateLeftTable())
									this.rightDiv = $('<div/>').css('float','left').addClass('adhoc_design_sqlface').appendTo(centerDiv);
									this.rightDiv.append(this.generateRightTable());
								},
								
								generateTitleTable : function(){
									var table = $('<table cellpadding="0" cellspacing="0" border="0"></table>').addClass('adhoc_design_sqlface_table');
									table.append(this.generateDataLinkTR());
									return table;
								},
								
								generateLeftTable : function(){
									var table = $('<table cellpadding="0" cellspacing="0" border="0"></table>').addClass('adhoc_design_sqlface_table');
									table.append(this.generateTableTreeTR());
									return table;
								},
								
								generateRightTable : function() {
									var table = $('<table cellpadding="0" cellspacing="0" border="0"></table>').addClass('adhoc_design_sqlface_table');
									table.append(this.generateSQLTR());
									return table;
								},
								
								generateDataLinkTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_design_sqlface_font');
									$('<div/>').addClass('adhoc_design_dataPane_field_name').text(':').appendTo(std);
									var link = $('<div/>').addClass('adhoc_design_sqlface_link');
									var itd = $('<td/>').append(link);
									
									var config = {
										directEdit : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=get_ac_datasource_name'
									};
									this.linkCombo = new FR.ComboBoxEditor($.extend({renderEl : $("<div/>").appendTo(link)}, config));
									var self = this;
									this.linkCombo.on(FR.Events.AFTEREDIT, function(e){
										self.tableTree.reBulidWidgetUrl(FR.servletURL + "?op=fr_adhoc&cmd=ac_table_produces&datalink=" + this.getValue());
									})
									return tr.append(std).append(itd);
								},
								
								generateTableTreeTR : function () {
									var tr = $('<tr/>');
									var td = $('<td/>').appendTo(tr);
									var div = $("<div/>").addClass('adhoc_design_sqlface_link').appendTo(td).css('background', 'white');
									var config = {
										height:260,
										width:195,
										widgetUrl : FR.servletURL + "?op=fr_adhoc&cmd=ac_table_produces&datalink=" + this.linkCombo.getValue()
									};
									this.tableTree = new FS.Tree($.extend({renderEl : div}, config));
									var self = this;
									this.tableTree.on(FR.Events.CLICK, function(e){
										var data = this.getSelectedData()
										if(data && !data.hasChild()){
											self.sql.editComp.insertAtCaret(data.getShowValue());
										}
									})
									return tr;
								},
								
								generateSQLTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_sqlface_font');
									$('<div/>').addClass('adhoc_design_dataPane_field_name').text('SQL:').appendTo(std);
									var sqltd = $('<td/>');
									this.sql = new FR.TextEditor({
										renderEl : sqltd,
										multiline : true,
										height : 81,
										width: 340
									});
									var ptd = $('<td style="vertical-align:bottom;"></td>')
									var self = this;
									this.previewButton = new FR.PreviewButton({
										renderEl : $('<div/>').appendTo(ptd),
										previewHandler : function(){
											var value = self.linkCombo.getValue();
											var query = self.getSQL();
											if(value && value != 0 && query && query != 0)
												return FS.Trans.getdbTablePreview({datalink:value,query:FR.encrypt(query, 'neilsx')});
											else
												return null;
										}
									});
									return tr.append(std).append(sqltd).append(ptd);
								},
								
								getContent : function(bottomDiv) {
									if (!this.content) {
										this._init();
									}
									this.bottomDiv = bottomDiv
									this.unvisible();
									return this.content;
								},
								
								isvisible : function() {
									return this.isshow;
								},
								
								visible : function() {
									this.isshow = true;
									this.content.show();
									this.rightDiv.append(this.bottomDiv);
								},
																						
								unvisible : function() {
									this.isshow = false;
									this.content.hide();
								},
								
								getSQL : function() {
									var sql = this.sql.getValue();
									if (sql != undefined){
										//daniel xx16032ǿո 160޷ʶ
										sql = sql.replace(new RegExp(String.fromCharCode(160), "gm"), String.fromCharCode(32));
									}
									return sql;
								},
								
								getConnectionName : function() {
									return this.linkCombo.getValue();
								},
								
								popuData : function(data) {
									this.linkCombo.setValue(data.dbConnectionName ? data.dbConnectionName : '');
									this.linkCombo.fireEvent(FR.Events.AFTEREDIT);
									this.sql.setValue(data.query ? data.query : '');
								}
							},
							
							namedFace : {
								_init : function(pane) {
									this.content = $('<div/>');
									var div =  $('<div/>').addClass('adhoc_design_namedface').appendTo(this.content);
									div.append($('<table cellpadding="0" cellspacing="0" border="0"></table>').addClass('adhoc_design_namedface_table').append(this.generateDataLinkTR()));
								},
								
								generateDataLinkTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_design_namedface_font');
									$('<div/>').addClass('adhoc_design_dataPane_field_name').text('ѡݼ:').appendTo(std);
									var link = $('<div/>').addClass('adhoc_design_namedface_link');
									var itd = $('<td/>').append(link);
									var ptd = $('<td/>');
									var config = {
										directEdit : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : FR.servletURL + '?op=fr_adhoc&cmd=ac_tabledata_name'
									};
									var self = this;
									this.previewButton = new FR.PreviewButton({
										renderEl : $('<div/>').appendTo(ptd),
										previewHandler : function(){
											var value = self.linkCombo.getValue();
											if(value && value != 0)
												return FS.Trans.getDataPreview(value);
											else
												return null;
										}
									})
									this.linkCombo = new FR.ComboBoxEditor($.extend({renderEl : $("<div/>").appendTo(link)}, config));
									return tr.append(std).append(itd).append(ptd);
								},
								
								getContent : function(bottomDiv) {
									if (!this.content) {
										this._init();
									}
									this.bottomDiv = bottomDiv;
									this.unvisible();
									return this.content;
								},
								
								isvisible : function() {
									return this.isshow;
								},
								
								visible : function() {
									this.isshow = true;
									this.content.show();
									this.content.append(this.bottomDiv);
								},
																						
								unvisible : function() {
									this.isshow = false;
									this.content.hide();
								},
								
								getTableDataName : function() {
									return this.linkCombo.getValue();
								},
								
								popuData : function(data) {
									this.linkCombo.setValue(data.dbTableDataName ? data.dbTableDataName : '');
								}
							},
																					
							popu : function(data) {
								if (!data) {
									this.showInforFace();
									return;									
								}
								this.showDesignFace();
								this.setViewName(data.text);
								this.setDescription(data.description ? data.description : '');
								this.setTitleInfo(data.type);
								if (data.type == 0) {
									this.namedFace.visible();
									this.namedFace.popuData(data);
									this.sqlFace.unvisible();									
								} else if (data.type == 1) {
									this.namedFace.unvisible();
									this.sqlFace.visible();
									this.sqlFace.popuData(data);
								}
								this.semantic.popu(data);
							},
							
							setTitleInfo : function(type) {
								if (type == 1) {
									this.dataPane.setTitle('SQLԴ');
								} else if (type == 0) {
									this.dataPane.setTitle('ݼԴ');
								}
							},
														
							setViewName : function(name) {
								this.dataPane.setName(name);
							},
							
							setDescription : function(description) {
								this.dataPane.setDes(description);
							},
							
							createADHOCData : function() {
								var data = {};
								data.description = this.dataPane.getDes();
								data.text = this.dataPane.getName();
								data.oldName = this.dataPane.getOldName();
								var semantic = this.semantic.getSemantic();
								if (semantic != null){
									data.semantic = semantic;
								}
								if (this.sqlFace.isvisible()) {
									data.type = 1;
									data.query = this.sqlFace.getSQL();
									data.dbConnectionName = this.sqlFace.getConnectionName();
								} else if (this.namedFace.isvisible()) {
									data.type = 0;
									data.dbTableDataName = this.namedFace.getTableDataName();
								}
								return data;
							},
							
							showInforFace : function() {
								this.basicInforFace.visible();
								this.dataPane.unvisible();
							},
							
							showDesignFace : function() {
								this.basicInforFace.unvisible();
								this.dataPane.visible();
							}
							
						},
		
						visible : function() {
							this.content.show();
						}
				}
			});
			//b:ԺģҪ
			var c = this.centerContent.dataFace.getContent();
			var d = this.centerContent.dataFace.getGlobePane();
			c.show();
			d.hide();
			var bar = this.centerContent.dataFace.getToolBar();
			this.centerContent.append(bar)
			.append(c)
			.append(d);
			//b:border
			this.centerContent.dataFace.borderPane();
//			globeSetting pane
			this.centerContent.dataFace.globeSettingPane();
		},
		
		_init : function(needTitle) {
			var its = [];
			its[0] = {
				region : 'center',
				el : this.centerContent
			};
			if (needTitle != false) {
				this._initNorth();
				$("body").append(this.northContent);
				its[1] = {
					region : 'north',
					el : this.northContent
				};
			}
			var content = $("body").append(this.centerContent);
			var contentLayout = new FR.BorderLayout({renderEl : content, items: its});	
			contentLayout.doLayout();
			window.onresize = function() {
				contentLayout.doLayout();
			};
			this._initCenter();
		}
	});	
});