/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.io.exporter;

import com.fr.base.BaseUtils;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.IconManager;
import com.fr.base.OfflineUtils;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.ResultFormula;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.base.present.DictPresent;
import com.fr.base.present.FormulaPresent;
import com.fr.base.present.Present;
import com.fr.data.DataUtils;
import com.fr.data.Dictionary;
import com.fr.data.impl.FormulaDictionary;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.Inter;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.main.workbook.WriteWorkBook;
import com.fr.page.ReportSettingsProvider;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellInsertPolicyAttr;
import com.fr.report.core.A.H;
import com.fr.report.core.A.J;
import com.fr.report.core.A.M;
import com.fr.report.core.ReportUtils;
import com.fr.report.module.EngineModuleFactory;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.report.WriteECReport;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.button.write.AppendColumnRow;
import com.fr.report.web.button.write.AppendRowButton;
import com.fr.report.web.button.write.Clear;
import com.fr.report.web.button.write.DeleteColumnRow;
import com.fr.report.web.button.write.DeleteRowButton;
import com.fr.report.web.button.write.Redo;
import com.fr.report.web.button.write.Undo;
import com.fr.report.worksheet.CalculatableResWorkSheet;
import com.fr.report.write.ValueVerifier;
import com.fr.script.Calculator;
import com.fr.stable.Actor;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StableUtils;
import com.fr.stable.WriteActor;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.BaseHTMLWriterUtils;
import com.fr.web.Browser;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.A.V;
import com.fr.web.core.A.jD;
import com.fr.web.core.A.l;
import com.fr.web.core.HTMLStreamWriter;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSession;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.ReportWebUtils;
import com.fr.web.core.Reportlet;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplDAO;
import com.fr.web.core.reportcase.AbstractWebReportCase;
import com.fr.web.core.reportcase.WebElementReportCase;
import com.fr.web.reportlet.MultiTemplateReportlet;
import com.fr.web.request.AbstractReportletRequest;
import com.fr.web.utils.WebUtils;
import com.fr.write.ReportWriteAttrProvider;
import com.fr.write.WriteHTMLExporterProvider;
import com.fr.write.core.cal.BCE_Insert;
import com.fr.write.core.cal.BCE_WRITE;
import com.fr.write.web.chwriter.WriteOfflineCellWriter;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class WriteHTMLExporter
extends AbstractAppExporter
implements WriteHTMLExporterProvider {
    private static int BUFFER_LEN = 1024;
    private List resourceList = new ArrayList();
    private List jsList = new ArrayList();
    private String rootName = "GettingStarted";
    private String incName = "inc";
    private String imageRootName = "images";
    private static String recordDelimiter = "-";
    private Map<String, String> configMap = new HashMap<String, String>();

    public void export(OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal) throws Exception {
        if (!VT4FR.isLicAvailable(StableUtils.getBytes()) || !VT4FR.OFFLINE_WRITE.support()) {
            throw new RegistEditionException(VT4FR.OFFLINE_WRITE);
        }
        HttpServletRequest httpServletRequest = reportRepositoryDeal.getHttpServletReques();
        if (WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlets") != null) {
            ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor(reportRepositoryDeal);
            String string = reportSessionIDInfor.getBookPath();
            if (string == null) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            MultiTemplateReportlet.createReportsFromReportlets(string, arrayList, new ArrayList(), arrayList2, AbstractReportletRequest.getInstance(httpServletRequest));
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                this.putReport(this.createRepositoryByReportPath(httpServletRequest, Utils.objectToString(arrayList.get(i2)), (Map)arrayList2.get(i2)), zipOutputStream);
            }
            zipOutputStream.flush();
            zipOutputStream.close();
        } else {
            this.exportSingle(outputStream, reportRepositoryDeal);
        }
    }

    public void exportSingle(OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        this.putReport(reportRepositoryDeal, zipOutputStream);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private void putReport(ReportRepositoryDeal reportRepositoryDeal, ZipOutputStream zipOutputStream) throws Exception {
        ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor(reportRepositoryDeal);
        this.rootName = reportSessionIDInfor.getWebTitle().replaceAll("\\s", "_");
        zipOutputStream.setEncoding("GBK");
        this.resourceList.clear();
        this.jsList.clear();
        zipOutputStream.putNextEntry(new ZipEntry(this.rootName + "/"));
        Map map = reportSessionIDInfor.getParameterMap4Execute();
        map.put("reportConfig", this.createConfig(reportSessionIDInfor, reportRepositoryDeal, zipOutputStream));
        map.put("jsContent", this.createContentJs(reportSessionIDInfor, reportRepositoryDeal, zipOutputStream));
        map.put("DOCTYPE", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        String string = TemplateUtils.renderTemplate("/com/fr/web/core/page_offline.html", map);
        byte[] byArray = string.getBytes();
        zipOutputStream.putNextEntry(new ZipEntry(this.rootName + "/" + this.rootName + ".html"));
        zipOutputStream.write(byArray);
        zipOutputStream.putNextEntry(new ZipEntry(this.getFatherPath()));
        String string2 = this.createJS(reportRepositoryDeal);
        byArray = string2.getBytes();
        zipOutputStream.putNextEntry(new ZipEntry(this.getFatherPath() + "finereport.js"));
        zipOutputStream.write(byArray);
        String string3 = this.createCSS(zipOutputStream, reportRepositoryDeal);
        byArray = string3.getBytes();
        zipOutputStream.putNextEntry(new ZipEntry(this.getFatherPath() + "finereport.css"));
        zipOutputStream.write(byArray);
        this.putOtherReource(zipOutputStream);
    }

    public void export(OutputStream outputStream, HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) throws Exception {
        this.exportSingle(outputStream, new ReportRepositoryDeal(httpServletRequest, sessionIDInfor, 96));
    }

    public void export(OutputStream outputStream, HttpServletRequest httpServletRequest, String string) throws Exception {
        this.export(outputStream, httpServletRequest, string, -1L, -1L);
    }

    public void export(OutputStream outputStream, HttpServletRequest httpServletRequest, String string, long l2, long l3) throws Exception {
        if (!VT4FR.isLicAvailable(StableUtils.getBytes()) || !VT4FR.OFFLINE_WRITE.support()) {
            throw new RegistEditionException(VT4FR.OFFLINE_WRITE);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("REPORTLET", string);
        hashMap.put("TASKID", l2);
        hashMap.put("USERID", l3);
        hashMap.put("USERNAME", ProcessUtils.getUserName(l3));
        try {
            ProcessTaskImpl processTaskImpl = ProcessTaskImplDAO.getInstance().findByID(l2);
            hashMap.put("NODEIDX", processTaskImpl.getCurrentNodeIdx());
            hashMap.put("ROUTEIDX", processTaskImpl.getCurrentRouteIdx());
            this.configMap.put("processConfig", processTaskImpl.createDetailedJSONObject().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exportSingle(outputStream, this.createRepositoryByReportPath(httpServletRequest, string, hashMap));
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
    }

    private ReportRepositoryDeal createRepositoryByReportPath(HttpServletRequest httpServletRequest, String string, Map map) throws Exception {
        Reportlet reportlet = EngineModuleFactory.generateReportlet(string);
        String string2 = WebUtils.getIpAddr(httpServletRequest);
        Map map2 = WebUtils.parameters4SessionIDInforContainMPCache(httpServletRequest);
        map2.putAll(map);
        ReportSessionIDInfor reportSessionIDInfor = new ReportSessionIDInfor(string2, map2, reportlet.createReport(AbstractReportletRequest.getInstance(httpServletRequest)), null, string, new WriteActor(), AuthenticationFactory.exAuth4CommonAccess(httpServletRequest));
        return new ReportRepositoryDeal(httpServletRequest, reportSessionIDInfor, 96);
    }

    private String createConfig(ReportSessionIDInfor reportSessionIDInfor, ReportRepositoryDeal reportRepositoryDeal, ZipOutputStream zipOutputStream) throws Exception {
        JSONObject jSONObject = this.createReportConfig(reportSessionIDInfor, reportRepositoryDeal);
        JSONArray jSONArray = new JSONArray();
        WriteWorkBook writeWorkBook = (WriteWorkBook)reportSessionIDInfor.getWorkBook2Show();
        Calculator calculator = this.createCalculator(reportSessionIDInfor);
        for (int i2 = 0; i2 < writeWorkBook.getReportCount(); ++i2) {
            WriteECReport writeECReport = writeWorkBook.getWriteReport(i2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            JSONObject jSONObject4 = new JSONObject();
            JSONArray jSONArray2 = new JSONArray();
            JSONArray jSONArray3 = new JSONArray();
            JSONArray jSONArray4 = new JSONArray();
            JSONArray jSONArray5 = new JSONArray();
            String string = this.createContent(reportSessionIDInfor, reportRepositoryDeal, i2);
            String string2 = DataUtils.createServletURL(reportRepositoryDeal.getHttpServletReques()) + "?op=resource&resource=";
            string = string.replaceAll(CodeUtils.attributeHtmlEncode(string2), this.incName + "/" + this.imageRootName);
            this.putResource(zipOutputStream, string, false);
            WriteHTMLExporter.collectDependenceConfig(writeECReport, jSONObject4, jSONObject3);
            this.collectColRowArray(writeECReport, jSONArray2, jSONArray3);
            this.collectDelInsRowArray(writeECReport, jSONArray4);
            this.collectDeletedRows(writeECReport, jSONArray5);
            jSONObject2.put(OfflineUtils.HTML, string);
            jSONObject2.put(OfflineUtils.BASE_CELLS, this.createBaseCells(writeECReport, calculator));
            jSONObject2.put(OfflineUtils.RESULT_CELLS, this.createResultCells(writeECReport));
            jSONObject2.put(OfflineUtils.DEPEND_ON_WHO, jSONObject3);
            jSONObject2.put(OfflineUtils.WHO_DEPEND_ON, jSONObject4);
            jSONObject2.put(OfflineUtils.COL_ARRAY, jSONArray2);
            jSONObject2.put(OfflineUtils.ROW_ARRAY, jSONArray3);
            jSONObject2.put(OfflineUtils.ORI_INS_ROW_ARR, jSONArray4);
            jSONObject2.put(OfflineUtils.DELETED_ROWS, jSONArray5);
            jSONObject2.put(OfflineUtils.VERIFY, this.createVerify(writeECReport));
            jSONArray.put(jSONObject2);
        }
        jSONObject.put("lgps", jSONArray);
        return jSONObject.toString();
    }

    private Calculator createCalculator(ReportSessionIDInfor reportSessionIDInfor) {
        Calculator calculator = Calculator.createCalculator();
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(reportSessionIDInfor.getParameterMap4Execute());
        calculator.pushNameSpace(parameterMapNameSpace);
        return calculator;
    }

    private JSONObject createReportConfig(ReportSessionIDInfor reportSessionIDInfor, ReportRepositoryDeal reportRepositoryDeal) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("requestURL", reportRepositoryDeal.getHttpServletReques().getRequestURL());
        Object object = reportSessionIDInfor.getParameterValue("reportlet");
        jSONObject.put("reportlet", object == null ? reportSessionIDInfor.getParameterValue("REPORTNAME") : object);
        jSONObject.put("parameters", this.createParameters(reportSessionIDInfor));
        jSONObject.put("writeShortCuts", !ConfigManager.getInstance().isWriteShortCuts());
        for (String string : this.configMap.keySet()) {
            jSONObject.put(string, this.configMap.get(string));
        }
        return jSONObject;
    }

    private String createContent(ReportSessionIDInfor reportSessionIDInfor, ReportRepositoryDeal reportRepositoryDeal, int n2) {
        ECReport eCReport = (ECReport)((Object)reportSessionIDInfor.getReport2Show(n2));
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(Report.class, eCReport);
        Tag tag = new Tag("div");
        tag.cls("sheet-container");
        HTMLWriter hTMLWriter = HTMLStreamWriter.getInstance();
        WriteOfflineCellWriter writeOfflineCellWriter = new WriteOfflineCellWriter((Repository)reportRepositoryDeal, n2, (WriteECReport)eCReport);
        WebElementReportCase webElementReportCase = new WebElementReportCase(eCReport, reportRepositoryDeal);
        ColumnRow columnRow = this.getFrozenColumnRow(eCReport);
        if (columnRow != null) {
            hTMLWriter.writeFrozenContent(tag, webElementReportCase, columnRow, n2, writeOfflineCellWriter, reportRepositoryDeal);
        } else {
            Tag tag2 = hTMLWriter.clipReport2Html(webElementReportCase, new Rectangle(0, 0, webElementReportCase.getColumnCount(), webElementReportCase.getRowCount()), n2, writeOfflineCellWriter, reportRepositoryDeal);
            int n3 = Math.max(((AbstractWebReportCase)webElementReportCase).getColWidth(), 1);
            int n4 = Math.max(((AbstractWebReportCase)webElementReportCase).getRowHeight(), 1);
            Tag tag3 = new Tag("div");
            if (ReportUtils.getReportSettings(eCReport).getBackground() != null) {
                BaseHTMLWriterUtils.writeBackground(tag3, ReportUtils.getReportSettings(eCReport).getBackground(), new Dimension(n3, n4), false, reportRepositoryDeal);
            }
            tag3.sub(tag2);
            tag.css("width", tag2.getCss("width"));
            tag.sub(tag3);
            jD.dealWithFloatItems(eCReport, reportRepositoryDeal, n3, n4, tag3);
            tag3.css("width", n3 + "px").css("height", n4 + "px");
        }
        jD.__write_editor__with_EditComp(tag, reportRepositoryDeal);
        return tag.toHtml();
    }

    private JSONObject createBaseCells(WriteECReport writeECReport, Calculator calculator) throws Exception {
        JSONObject jSONObject = new JSONObject();
        ArrayList<ColumnRow> arrayList = new ArrayList<ColumnRow>();
        Iterator iterator = writeECReport.cellIterator();
        while (iterator.hasNext()) {
            CellInsertPolicyAttr cellInsertPolicyAttr;
            CellElement cellElement = (CellElement)iterator.next();
            TemplateCellElement templateCellElement = ((BCE_WRITE)cellElement).getBeFrom().get_ce_from();
            ColumnRow columnRow = ColumnRow.valueOf(templateCellElement.getColumn(), templateCellElement.getRow());
            if (arrayList.contains(columnRow)) continue;
            arrayList.add(columnRow);
            JSONObject jSONObject2 = new JSONObject();
            Object object = templateCellElement.getValue();
            Present present = templateCellElement.getPresent();
            jSONObject2.put("cr", columnRow + "");
            jSONObject2.put("value", this.getValueForWeb(object));
            jSONObject2.put("formula", this.getFormulaForWeb(object));
            jSONObject2.put("presentValue", this.getValueForWeb(present));
            jSONObject2.put("presentFormula", this.getPresentFormula(cellElement, calculator));
            jSONObject2.put("oriRowSpan", templateCellElement.getRowSpan());
            jSONObject2.put("oriColSpan", templateCellElement.getColumnSpan());
            CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
            if (cellExpandAttr != null) {
                jSONObject2.put("direction", cellExpandAttr.getDirection());
                jSONObject2.put("leftDefault", cellExpandAttr.isLeftParentDefault());
                jSONObject2.put("upDefault", cellExpandAttr.isUpParentDefault());
                jSONObject2.put("left", cellExpandAttr.getLeftParentColumnRow());
                jSONObject2.put("up", cellExpandAttr.getUpParentColumnRow());
            }
            if ((cellInsertPolicyAttr = templateCellElement.getCellInsertPolicyAttr()) != null) {
                jSONObject2.put("insertPolicy", cellInsertPolicyAttr.getInsertPolicy());
                jSONObject2.put("defaultInsertValue", cellInsertPolicyAttr.getDefaultInsertValue());
            }
            jSONObject.put(columnRow + "", jSONObject2);
        }
        return jSONObject;
    }

    private JSONObject createResultCells(WriteECReport writeECReport) throws Exception {
        JSONObject jSONObject = new JSONObject();
        Iterator iterator = writeECReport.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            ColumnRow columnRow = ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow());
            JSONObject jSONObject2 = new JSONObject();
            Object object = this.getValueForWeb(cellElement.getValue());
            if (ComparatorUtils.equals(object, "")) continue;
            try {
                jSONObject2.put("value", object);
                jSONObject.put(columnRow + "", jSONObject2);
            }
            catch (Exception exception) {}
        }
        return jSONObject;
    }

    private Object getValueForWeb(Object object) {
        if (object instanceof String || object instanceof Number) {
            return object;
        }
        if (object instanceof Formula) {
            Object object2 = null;
            try {
                if (object instanceof ResultFormula) {
                    ResultFormula resultFormula = (ResultFormula)object;
                    object2 = resultFormula.getResult() != null ? resultFormula.getResult() : Calculator.createCalculator().eval(resultFormula.getTransferContent());
                }
                if (object2 == null) {
                    object2 = Calculator.createCalculator().eval((Formula)object);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage());
            }
            if (object2 instanceof String || object2 instanceof Number) {
                return object2;
            }
            if (object2 instanceof FArray && ((FArray)object2).length() > 0) {
                boolean bl = true;
                int n2 = ((FArray)object2).length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object3 = ((FArray)object2).elementAt(i2);
                    if (object3 instanceof String || object3 instanceof Number) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return object2;
                }
            }
        }
        return "";
    }

    private Object getFormulaForWeb(Object object) {
        if (object instanceof Formula) {
            return ((Formula)object).getContent();
        }
        return "";
    }

    private String getPresentFormula(CellElement cellElement, Calculator calculator) {
        if (cellElement instanceof BCE_WRITE) {
            BCE_WRITE bCE_WRITE = (BCE_WRITE)cellElement;
            Present present = bCE_WRITE.getPresent();
            if (present instanceof FormulaPresent) {
                return ((FormulaPresent)present).getFormulaContent();
            }
            if (present instanceof DictPresent) {
                Dictionary dictionary = ((DictPresent)present).getDictionary();
                if (dictionary instanceof FormulaDictionary) {
                    FormulaDictionary formulaDictionary = (FormulaDictionary)dictionary;
                    if (ComparatorUtils.equals(formulaDictionary.getProduceFormula(), "=$$$")) {
                        return formulaDictionary.getExcuteFormula();
                    }
                } else {
                    Iterator iterator = dictionary.entrys(calculator);
                    if (iterator.hasNext()) {
                        String string = "switch($$$,";
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            Dictionary.MV mV = (Dictionary.MV)iterator.next();
                            string = string + "\"" + mV.getModel() + "\",\"" + mV.getView() + "\"";
                            if (!iterator.hasNext()) continue;
                            string = string + ",";
                        }
                        string = string + ")";
                        return string;
                    }
                }
            }
        }
        return "";
    }

    public static void collectDependenceConfig(WriteECReport writeECReport, JSONObject jSONObject, JSONObject jSONObject2) throws Exception {
        H h2 = ((CalculatableResWorkSheet)((Object)writeECReport)).getSE();
        Map map = h2.S();
        for (Object k2 : map.keySet()) {
            ColumnRow columnRow;
            M m2;
            JSONArray jSONArray;
            if (!(k2 instanceof ColumnRow)) continue;
            ColumnRow columnRow2 = (ColumnRow)k2;
            J j2 = (J)map.get(k2);
            if (j2.B() != null) {
                if (jSONObject.opt(columnRow2 + "") != null) {
                    jSONArray = (JSONArray)jSONObject.get(columnRow2 + "");
                } else {
                    jSONArray = new JSONArray();
                    jSONObject.put(columnRow2 + "", jSONArray);
                }
                for (Object e2 : j2.B()) {
                    if (!(e2 instanceof M)) continue;
                    m2 = (M)e2;
                    columnRow = ColumnRow.valueOf(m2.B().getColumn(), m2.B().getRow());
                    jSONArray.put(columnRow + "-" + m2.A());
                }
            }
            if (j2.A() == null) continue;
            if (jSONObject2.opt(columnRow2 + "") != null) {
                jSONArray = (JSONArray)jSONObject2.get(columnRow2 + "");
            } else {
                jSONArray = new JSONArray();
                jSONObject2.put(columnRow2 + "", jSONArray);
            }
            for (Object e2 : j2.A()) {
                if (!(e2 instanceof M)) continue;
                m2 = (M)e2;
                columnRow = ColumnRow.valueOf(m2.B().getColumn(), m2.B().getRow());
                jSONArray.put(columnRow + "-" + m2.A());
            }
        }
    }

    private void collectColRowArray(WriteECReport writeECReport, JSONArray jSONArray, JSONArray jSONArray2) {
        int n2;
        H h2 = ((CalculatableResWorkSheet)((Object)writeECReport)).getSE();
        H._C _C2 = h2.W();
        for (n2 = 0; n2 < _C2.getRowCount(); ++n2) {
            jSONArray2.put(_C2.J(n2));
        }
        for (n2 = 0; n2 < _C2.getColumnCount(); ++n2) {
            jSONArray.put(_C2.I(n2));
        }
    }

    private void collectDelInsRowArray(WriteECReport writeECReport, JSONArray jSONArray) {
        H h2 = ((CalculatableResWorkSheet)((Object)writeECReport)).getSE();
        H._C _C2 = h2.W();
        int[] nArray = _C2.\u00a5();
        Map map = this.getOriInsDelBtnMap(writeECReport);
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Iterator iterator = writeECReport.cellIterator();
        while (iterator.hasNext()) {
            ColumnRow columnRow;
            int n5;
            int n6;
            Object e2 = iterator.next();
            if (!(e2 instanceof BCE_WRITE)) continue;
            BCE_WRITE bCE_WRITE = (BCE_WRITE)e2;
            boolean bl = bCE_WRITE instanceof BCE_Insert;
            boolean bl2 = bCE_WRITE.isDel();
            if (!bl && !bl2) continue;
            ColumnRow columnRow2 = ColumnRow.valueOf(bCE_WRITE.getColumn(), bCE_WRITE.getRow());
            ColumnRow columnRow3 = bCE_WRITE.getColumnRowFrom();
            ColumnRow columnRow4 = columnRow2;
            if (bl && bCE_WRITE.getRow() > n3) {
                n6 = 1;
                n5 = 2;
                columnRow = this.getOriInsDelButton(map, columnRow3, true);
                if (columnRow != null) {
                    n6 = ((AppendRowButton)map.get(columnRow)).getCount();
                    columnRow4 = ColumnRow.valueOf(columnRow.column, ArrayUtils.indexOf(nArray, columnRow.row) + columnRow2.row - ArrayUtils.indexOf(nArray, columnRow3.row) - bCE_WRITE.getRowSpan());
                    n5 = 0;
                }
                n3 = columnRow2.row + n6 - 1;
                jSONArray.put(n2 + recordDelimiter + n6 + recordDelimiter + columnRow4 + recordDelimiter + n5);
                ++n2;
            }
            if (!bl2 || bCE_WRITE.getRow() <= n4) continue;
            n6 = 1;
            n5 = 3;
            columnRow = this.getOriInsDelButton(map, columnRow3, false);
            if (columnRow != null) {
                columnRow4 = ColumnRow.valueOf(columnRow.column, ArrayUtils.indexOf(nArray, columnRow.row) + columnRow2.row - ArrayUtils.indexOf(nArray, columnRow3.row) - bCE_WRITE.getRowSpan());
                n5 = 1;
            }
            n4 = columnRow2.row + n6 - 1;
            jSONArray.put(n2 + recordDelimiter + n6 + recordDelimiter + columnRow4 + recordDelimiter + n5);
            ++n2;
        }
    }

    private Map getOriInsDelBtnMap(WriteECReport writeECReport) {
        HashMap<ColumnRow, Widget> hashMap = new HashMap<ColumnRow, Widget>();
        Iterator iterator = writeECReport.cellIterator();
        while (iterator.hasNext()) {
            ColumnRow columnRow;
            BCE_WRITE bCE_WRITE;
            Widget widget;
            Object e2 = iterator.next();
            if (!(e2 instanceof BCE_WRITE) || !((widget = (bCE_WRITE = (BCE_WRITE)e2).getWidget()) instanceof AppendRowButton) && !(widget instanceof DeleteRowButton) || hashMap.containsKey(columnRow = bCE_WRITE.getColumnRowFrom())) continue;
            hashMap.put(columnRow, widget);
        }
        return hashMap;
    }

    private ColumnRow getOriInsDelButton(Map map, ColumnRow columnRow, boolean bl) {
        for (ColumnRow columnRow2 : map.keySet()) {
            Widget widget = (Widget)map.get(columnRow2);
            if (!(bl ? widget instanceof AppendRowButton && ComparatorUtils.equals(((AppendRowButton)widget).getFixCell(), columnRow) : widget instanceof DeleteRowButton && ComparatorUtils.equals(((DeleteRowButton)widget).getFixCell(), columnRow))) continue;
            return columnRow2;
        }
        return null;
    }

    private void collectDeletedRows(WriteECReport writeECReport, JSONArray jSONArray) {
        Iterator iterator = writeECReport.cellIterator();
        int n2 = -1;
        while (iterator.hasNext()) {
            BCE_WRITE bCE_WRITE;
            int n3;
            Object e2 = iterator.next();
            if (!(e2 instanceof BCE_WRITE) || (n3 = (bCE_WRITE = (BCE_WRITE)e2).getRow()) <= n2) continue;
            if (bCE_WRITE.isDel()) {
                jSONArray.put(n3);
            }
            n2 = n3;
        }
    }

    private JSONArray createVerify(WriteECReport writeECReport) throws Exception {
        JSONArray jSONArray = new JSONArray();
        ReportWriteAttrProvider reportWriteAttrProvider = writeECReport.getReportWriteAttr();
        if (reportWriteAttrProvider == null) {
            return jSONArray;
        }
        int n2 = reportWriteAttrProvider.getVerifierCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            if (reportWriteAttrProvider.getVerifier(i2) instanceof ValueVerifier) {
                object = (ValueVerifier)reportWriteAttrProvider.getVerifier(i2);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("formula", ((ValueVerifier)object).getFormula().getContent());
                jSONObject.put("message", ((ValueVerifier)object).getMessage());
                jSONArray.put(jSONObject);
                continue;
            }
            object = new JSONObject();
            ((JSONObject)object).put("UNSUPPORT", true);
            jSONArray.put(object);
        }
        return jSONArray;
    }

    private JSONObject createParameters(ReportSessionIDInfor reportSessionIDInfor) throws Exception {
        JSONObject jSONObject = new JSONObject();
        Map map = reportSessionIDInfor.getParameterMap4Execute();
        map.remove("FR_USERNAME");
        map.remove("FR_AUTHORITY");
        map.remove("FR_FS_AUTH_KEY");
        map.remove("FR_USERPOSITION");
        map.remove("FR_CURRENT_PRIVILEGE_LOADER");
        Set set = map.keySet();
        for (Object k2 : set) {
            jSONObject.put(k2 + "", map.get(k2));
        }
        return jSONObject;
    }

    private String createContentJs(ReportSessionIDInfor reportSessionIDInfor, Repository repository, ZipOutputStream zipOutputStream) throws Exception {
        Map map = ReportWebUtils.context4CommonPaneTpl(repository.getHttpServletReques(), reportSessionIDInfor);
        Actor actor = reportSessionIDInfor.getActor();
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(Report.class, reportSessionIDInfor.getContextBook());
        JSONObject jSONObject = actor.panelConfig(repository);
        jSONObject.put("type", "write");
        map.put("panel_config", jSONObject.toString());
        map.put("__pi__", String.valueOf(false));
        map.put("loading", this.createLoadJs(repository));
        map.put("toolbar_conf", this.createToolbarJs(repository, actor, calculator));
        String string = TemplateUtils.renderTemplate("/com/fr/web/core/tpl/tpl_script.js", map) + '\n';
        string = string + BaseUtils.readResourceAsString("/com/fr/write/web/js/write.js") + '\n';
        string = string + BaseUtils.readResourceAsString("/com/fr/write/web/js/write_offline.js") + '\n';
        if (this.getProcessTaskId(repository) > 0L) {
            string = string + BaseUtils.readResourceAsString("/com/fr/web/core/process/reportprocess/web/rp_tools.js") + '\n';
        }
        string = this.replaceServletURL(string, false) + '\n';
        this.putResource(zipOutputStream, string, false);
        string = this.dealImportJs(string);
        return string;
    }

    private String createLoadJs(Repository repository) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("rtype", "write");
        int n2 = ((ReportSession)((Object)RepositoryHelper.getSessionIDInfor(repository))).getReportCount();
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = ((ReportSession)((Object)RepositoryHelper.getSessionIDInfor(repository))).getReportName(i2);
            jSONArray.put(new JSONObject().put("id", string + i2).put("lazyload", true).put("closable", true).put("title", string));
        }
        hashMap.put("sheets", jSONArray);
        hashMap.put("param", V.A(repository, false));
        hashMap.put("browserbg", BaseHTMLWriterUtils.jsonBackground(ReportUtils.getBrowserBackgroundFromWorkBook(((ReportSession)((Object)RepositoryHelper.getSessionIDInfor(repository))).getContextBook()), repository));
        return TemplateUtils.renderTemplate("/com/fr/web/core/tpl/loading.tpl", hashMap);
    }

    private String createToolbarJs(Repository repository, Actor actor, Calculator calculator) {
        JSONArray jSONArray = new JSONArray();
        ToolBarManager toolBarManager = ToolBarManager.createDefaultWriteOfflineToolbar();
        ToolBar toolBar = toolBarManager.getToolBar();
        boolean bl = false;
        boolean bl2 = false;
        ToolBarManager[] toolBarManagerArray = actor.toolbarManagers(repository);
        for (int i2 = 0; i2 < toolBarManagerArray.length; ++i2) {
            ToolBar toolBar2 = toolBarManagerArray[i2].getToolBar();
            int n2 = toolBar2.getWidgetSize();
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!bl && toolBar2.getWidget(i3) instanceof AppendColumnRow) {
                    toolBar.addWidget(new AppendColumnRow());
                    bl = true;
                    continue;
                }
                if (bl2 || !(toolBar2.getWidget(i3) instanceof DeleteColumnRow)) continue;
                toolBar.addWidget(new DeleteColumnRow());
                bl2 = true;
            }
        }
        toolBar.addWidget(new Undo());
        toolBar.addWidget(new Redo());
        toolBar.addWidget(new Clear());
        long l2 = this.getProcessTaskId(repository);
        long l3 = this.getAllProcessTaskId(repository);
        if (l2 > 0L) {
            ArrayList<ToolBarManager> arrayList = new ArrayList<ToolBarManager>();
            arrayList.add(toolBarManager);
            ReportWebUtils.dealReportProcessToolbar(repository, new ToolBarManager[]{toolBarManager}, arrayList, l2, l3);
            for (ToolBarManager toolBarManager2 : arrayList) {
                jSONArray.put(toolBarManager2.toJSONConfig(repository, calculator));
            }
        } else {
            jSONArray.put(toolBarManager.toJSONConfig(repository, calculator));
        }
        return jSONArray.toString();
    }

    private String createJS(ReportRepositoryDeal reportRepositoryDeal) throws Exception {
        HttpServletRequest httpServletRequest = reportRepositoryDeal.getHttpServletReques();
        Locale locale = httpServletRequest == null ? FRContext.getLocale() : httpServletRequest.getLocale();
        Map map = (Map)Calculator.getSavedVariables();
        String string = Utils.objectToString(map.get("session_heart_beat"));
        Calculator.setThreadSavedParameter("session_heart_beat", "false");
        String string2 = l.D(httpServletRequest, locale) + '\n';
        Calculator.setThreadSavedParameter("session_heart_beat", string);
        String[] stringArray = this.otherJsFiles();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = this.addJavaScript(string2, stringArray[i2]);
        }
        string2 = this.dealImportJs(string2);
        return string2 + '\n';
    }

    private String[] otherJsFiles() {
        return new String[]{"com/fr/web/core/js/jquery.calculator.js", "com/fr/web/core/js/jquery.function.js"};
    }

    private String createCSS(ZipOutputStream zipOutputStream, ReportRepositoryDeal reportRepositoryDeal) throws Exception {
        String string = "";
        String[] stringArray = StableFactory.getCssFiles4WebClient();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = string + BaseUtils.readResourceAsString(stringArray[i2]) + '\n';
        }
        string = string + BaseUtils.readResourceAsString("/com/fr/write/web/css/write.css") + '\n';
        String[] stringArray2 = this.otherCssFiles();
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            string = string + BaseUtils.readResourceAsString(stringArray2[i3]) + '\n';
        }
        if (this.getProcessTaskId(reportRepositoryDeal) > 0L) {
            string = string + BaseUtils.readResourceAsString("/com/fr/web/core/process/reportprocess/web/rp_tools.css") + '\n';
        }
        string = string.replaceAll("\\$\\{servletURL\\}\\?op=resource&resource=/", this.imageRootName + "/");
        this.putResource(zipOutputStream, string, true);
        string = string + this.dealWithToolbarCss(reportRepositoryDeal, zipOutputStream) + '\n';
        return string;
    }

    private String[] otherCssFiles() {
        return new String[0];
    }

    private void putResource(ZipOutputStream zipOutputStream, String string, boolean bl) throws Exception {
        String string2 = (bl ? "com\\/fr\\/" : this.incName) + "+[\\/\\w&#;.-]+";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group();
            if (string3.indexOf("&#") != -1) {
                string3 = CodeUtils.attributeHtmlDecode(string3);
            }
            if (!bl && string3.indexOf("/com/fr") == -1) continue;
            String string4 = string3;
            if (string3.startsWith(this.incName + "/")) {
                string4 = string3.substring(this.incName.length() + this.imageRootName.length() + 1);
            }
            InputStream inputStream = BaseUtils.readResource(string4);
            byte[] byArray = null;
            if (inputStream == null) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[BUFFER_LEN];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray2, 0, BUFFER_LEN)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            String string5 = this.rootName + "/" + (bl ? this.incName + "/" + this.imageRootName + "/" : "") + string3;
            if (byArray.length <= 0 || this.resourceList.contains(string5)) continue;
            zipOutputStream.putNextEntry(new ZipEntry(string5));
            zipOutputStream.write(byArray);
            this.resourceList.add(string5);
        }
    }

    private String addJavaScript(String string, String string2) {
        string = string + this.replaceServletURL(BaseUtils.readResourceAsString(string2), false) + '\n';
        this.jsList.add(string2);
        return string;
    }

    private String dealImportJs(String string) {
        String string2 = "FR\\.\\$defaultImport\\(+['\\\"\\,\\.\\/ \\w\\r\\n]+\\)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string3;
            String string4 = matcher.group();
            if (!string4.contains(".js") || (string3 = string4.substring(string4.indexOf("(") + 2, string4.indexOf(".js") + 3)).length() <= 0 || this.jsList.contains(string3)) continue;
            string = this.addJavaScript(string, string3);
            this.jsList.add(string3);
        }
        return matcher.replaceAll("");
    }

    private String dealWithToolbarCss(ReportRepositoryDeal reportRepositoryDeal, ZipOutputStream zipOutputStream) throws Exception {
        HttpServletRequest httpServletRequest = reportRepositoryDeal.getHttpServletReques();
        String string = this.imageRootName + "/com/fr/web/images/toolbar-image.png";
        String string2 = IconManager.getIconManager().getCssFile(WebUtils.createServletURL(httpServletRequest), Browser.resolve(httpServletRequest));
        String string3 = DataUtils.createServletURL(reportRepositoryDeal.getHttpServletReques()) + "\\?op=toolbar_icon&id=toolbar-image.png";
        string2 = string2.replaceAll(string3, string);
        byte[] byArray = IconManager.getIconManager().getAllInOneImageBytes(WebUtils.createServletURL(httpServletRequest));
        zipOutputStream.putNextEntry(new ZipEntry(this.getFatherPath() + string));
        zipOutputStream.write(byArray);
        return string2;
    }

    private void putOtherReource(ZipOutputStream zipOutputStream) throws Exception {
        String string = this.imageRootName + "/com/fr/web/core/js/jquerytree/images/s.gif" + '\n' + this.imageRootName + "/com/fr/web/core/js/jquerytree/images/icons/checkbox_0.gif" + '\n' + this.imageRootName + "/com/fr/web/core/js/jquerytree/images/icons/checkbox_1.gif" + '\n' + this.imageRootName + "/com/fr/web/core/js/jquerytree/images/icons/checkbox_2.gif" + '\n';
        String string2 = this.incName + "/" + this.imageRootName + "..." + '\n';
        this.putResource(zipOutputStream, string, true);
        this.putResource(zipOutputStream, string2, false);
        String string3 = Inter.getLocText("Offline-ReadMe");
        byte[] byArray = string3.getBytes();
        zipOutputStream.putNextEntry(new ZipEntry(this.rootName + "/" + "readme.txt"));
        zipOutputStream.write(byArray);
    }

    private ColumnRow getFrozenColumnRow(Report report) {
        ColumnRow columnRow;
        ReportSettingsProvider reportSettingsProvider = report.getReportSettings();
        if (reportSettingsProvider != null && (columnRow = reportSettingsProvider.getWriteFrozenColumnRow()) != null) {
            if (report instanceof WriteECReport) {
                return ((WriteECReport)report).getResultColumnRow(ColumnRow.valueOf(columnRow.column, columnRow.row));
            }
            return ColumnRow.valueOf(columnRow.column, columnRow.row);
        }
        return null;
    }

    private String getFatherPath() {
        return this.rootName + "/" + this.incName + "/";
    }

    private String getImageFatherPath() {
        return this.getFatherPath() + this.imageRootName + "/";
    }

    private String replaceServletURL(String string, boolean bl) {
        String string2 = bl ? this.imageRootName : this.incName + "/" + this.imageRootName;
        return string.replaceAll("FR.servletURL \\+ '\\?op=resource\\&resource=", "'" + string2).replaceAll("FR.servletURL\\+'\\?op=resource\\&resource=", "'" + string2).replaceAll("FR.servletURL \\+ \\\"\\?op=resource\\&resource=", "\"" + string2).replaceAll("FR.servletURL\\+\\\"\\?op=resource\\&resource=", "\"" + string2);
    }

    private long getProcessTaskId(Repository repository) {
        return ProcessUtils.getIdFromStr(WebUtils.getHTTPRequestParameter(repository.getHttpServletReques(), "__processtaskid__"));
    }

    private long getAllProcessTaskId(Repository repository) {
        return ProcessUtils.getIdFromStr(WebUtils.getHTTPRequestParameter(repository.getHttpServletReques(), "__allprocesstaskid__"));
    }
}

