/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.cache.Attachment;
import com.fr.cache.list.IntList;
import com.fr.data.DBFeedback;
import com.fr.data.DataXmlUtils;
import com.fr.data.SubmitJob;
import com.fr.data.condition.ListCondition;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ColumnRowGroup;
import com.fr.stable.ColumnRowRelated;
import com.fr.stable.FormulaProvider;
import com.fr.stable.Mapper;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.js.WidgetName;
import com.fr.stable.script.CalculatorUtils;
import com.fr.stable.xml.FRFile;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.antlr.ANTLRException;
import com.fr.write.DBWritable;
import com.fr.write.DMLConfigJob;
import com.fr.write.DMLReport;
import com.fr.write.NameSubmitJob;
import com.fr.write.config.ColumnConfig;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class DMLConfig
implements XMLable,
ColumnRowRelated {
    public static final String XML_TAG = "DMLConfig";
    protected Table table = null;
    protected Dialect dialect = null;
    protected List<ColumnConfig> columnConfigList = new ArrayList<ColumnConfig>();
    protected List<NameSubmitJob> submitJobList = new ArrayList<NameSubmitJob>();
    protected Condition condition = null;
    private transient ColumnInformation[] columnInformations = null;
    private boolean updateSelected = false;
    private static Mapper toName = new Mapper(){

        public Object map(int n2, Object object, List list) {
            return ((ColumnConfig)object).getColumnName();
        }
    };
    private static Mapper toValue = new Mapper(){

        public Object map(int n2, Object object, List list) {
            return ((ColumnConfig)object).getColumnValue();
        }
    };

    public Dialect getDialect(Connection connection) {
        if (this.dialect == null) {
            this.dialect = DialectFactory.generateDialect(connection);
        }
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Table getTable(Calculator calculator) {
        if (this.table != null) {
            if (calculator == null) {
                return this.table;
            }
            try {
                String string;
                String string2 = this.table.getSchema();
                if (StableUtils.canBeFormula(string2)) {
                    string2 = GeneralUtils.objectToString(calculator.evalValue(string2));
                }
                if (StableUtils.canBeFormula(string = this.table.getName())) {
                    string = GeneralUtils.objectToString(calculator.evalValue(string));
                }
                return new Table(string2, string);
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
            }
        }
        return null;
    }

    public Table getTable() {
        return this.getTable(null);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void addColumnConfig(ColumnConfig columnConfig) {
        this.columnConfigList.add(columnConfig);
    }

    public int getColumnConfigCount() {
        return this.columnConfigList.size();
    }

    public ColumnConfig getColumnConfig(int n2) {
        return this.columnConfigList.get(n2);
    }

    public void clearColumnConfigs() {
        this.columnConfigList.clear();
    }

    public void addSubmitJob(NameSubmitJob nameSubmitJob) {
        this.submitJobList.add(nameSubmitJob);
    }

    public int getSubmitJobCount() {
        return this.submitJobList.size();
    }

    public NameSubmitJob getSubmitJob(int n2) {
        return this.submitJobList.get(n2);
    }

    public void clearSubmitJobs() {
        this.submitJobList.clear();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean isUpdateSelected() {
        return this.updateSelected;
    }

    public void setUpdateSelected(boolean bl) {
        this.updateSelected = bl;
    }

    public ColumnRow[] getRelatedColumnRows() {
        return this.getRelatedColumnRows(-1);
    }

    public ColumnRow[] getRelatedColumnRows(int n2) {
        HashSet<ColumnRow> hashSet = new HashSet<ColumnRow>();
        int n3 = this.getColumnConfigCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            ColumnConfig columnConfig = this.getColumnConfig(i2);
            Object object = columnConfig.getColumnValue();
            if (object instanceof ColumnRowGroup) {
                ColumnRowGroup columnRowGroup = (ColumnRowGroup)object;
                if (n2 < 0 || n2 >= columnRowGroup.getSize()) continue;
                hashSet.add(columnRowGroup.getColumnRow(n2));
                continue;
            }
            if (object instanceof ColumnRowRelated) {
                hashSet.addAll(Arrays.asList(((ColumnRowRelated)object).getRelatedColumnRows()));
                continue;
            }
            if (!(object instanceof String) || !((String)object).startsWith("=")) continue;
            try {
                hashSet.addAll(Arrays.asList(CalculatorUtils.relatedColumnRowArray((String)object)));
                continue;
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
            }
        }
        return hashSet.toArray(new ColumnRow[0]);
    }

    private boolean isColumnRowGroup() {
        int n2 = this.getColumnConfigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getColumnConfig(i2).getColumnValue();
            if (!(object instanceof ColumnRowGroup)) continue;
            return true;
        }
        return false;
    }

    private int getColumnRowGroupSize() {
        int n2 = this.getColumnConfigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getColumnConfig(i2).getColumnValue();
            if (!(object instanceof ColumnRowGroup)) continue;
            return ((ColumnRowGroup)object).getSize();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Calculator calculator) throws Exception {
        ExtractionSubmitter extractionSubmitter = new ExtractionSubmitter(connection);
        calculator.setAttribute(DMLConfig.class, this);
        try {
            this.extractGroup(extractionSubmitter, calculator);
        }
        finally {
            this.closeStatement(connection);
            calculator.removeAttribute(DMLConfig.class);
        }
    }

    public DBFeedback executeAndFeedback(Connection connection, Calculator calculator) throws Exception {
        ExtractionSubmitter extractionSubmitter = new ExtractionSubmitter(connection, new DBFeedback());
        this.extractGroup(extractionSubmitter, calculator);
        return extractionSubmitter.getFeedback();
    }

    private void extractGroup(ExtractionSubmitter extractionSubmitter, Calculator calculator) throws Exception {
        if (this.isColumnRowGroup()) {
            int n2 = this.getColumnRowGroupSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                DMLConfig.extract(calculator, this.getRelatedColumnRows(i2), (ColumnRow)calculator.getAttribute(ColumnRow.class), extractionSubmitter, i2);
            }
        } else {
            DMLConfig.extract(calculator, this.getRelatedColumnRows(), (ColumnRow)calculator.getAttribute(ColumnRow.class), extractionSubmitter, -1);
        }
    }

    private static void extract(Calculator calculator, ColumnRow[] columnRowArray, ColumnRow columnRow, DBWritable.Action action, int n2) throws Exception {
        int n3 = 0;
        DMLReport dMLReport = (DMLReport)calculator.getAttribute(DMLReport.class);
        if (dMLReport != null) {
            n3 = dMLReport.setCurrentColumnRow(columnRowArray, columnRow, calculator, action, n2);
        }
        if (n3 <= 0) {
            action.run(0, calculator, n2);
        }
    }

    private DMLColumnValues[] rebuildDMLConfig(Calculator calculator, int n2) throws CloneNotSupportedException {
        Object[] objectArray = new Object[this.getColumnConfigCount()];
        int n3 = this.getColumnConfigCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            ColumnConfig columnConfig = this.getColumnConfig(i2);
            objectArray[i2] = this.calculateColumnValue2DML(columnConfig.getColumnValue(), calculator, n2);
        }
        return this.extractByValues2Column(objectArray);
    }

    private Object calculateColumnValue2DML(Object object, Calculator calculator, int n2) {
        if (object instanceof Parameter) {
            try {
                object = calculator.evalValue(((Parameter)object).getName());
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                return null;
            }
        }
        if (object instanceof ColumnRow) {
            object = calculator.resolveVariable(object);
        } else if (object instanceof ColumnRowGroup) {
            object = calculator.resolveVariable(((ColumnRowGroup)object).getColumnRow(n2));
        } else {
            if (object instanceof FormulaProvider) {
                try {
                    object = calculator.evalValue(((FormulaProvider)object).getContent());
                }
                catch (UtilEvalError utilEvalError) {
                    FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    return null;
                }
            }
            if (object instanceof WidgetName) {
                try {
                    object = calculator.evalValue(((WidgetName)object).getName());
                }
                catch (UtilEvalError utilEvalError) {
                    FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    return null;
                }
            }
        }
        if (object instanceof String && calculator.resolveVariable("$$_NEWCHAR") != null && calculator.resolveVariable("$$_ORIGINALCHAR") != null) {
            try {
                return new String(((String)object).getBytes((String)calculator.resolveVariable("$$_NEWCHAR")), (String)calculator.resolveVariable("$$_ORIGINALCHAR"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return object;
    }

    private int getPrimaryIndex(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (!this.isAttachmentGroup(object)) continue;
            return i2;
        }
        return -1;
    }

    private boolean isAttachmentGroup(Object object) {
        return object instanceof FArray && ((FArray)object).length() > 0 && ((FArray)object).elementAt(0) instanceof Attachment;
    }

    public DMLColumnValues[] extractByValues2Column(Object[] objectArray) throws CloneNotSupportedException {
        int n2 = this.getPrimaryIndex(objectArray);
        ArrayList<DMLColumnValues> arrayList = new ArrayList<DMLColumnValues>();
        if (n2 == -1) {
            DMLColumnValues dMLColumnValues = new DMLColumnValues();
            arrayList.add(dMLColumnValues);
            this.addDMLConfig2List(dMLColumnValues, 0, objectArray, arrayList);
        } else {
            this.addDMLConfig2ListWithPrimary(arrayList, objectArray, n2);
        }
        return arrayList.toArray(new DMLColumnValues[arrayList.size()]);
    }

    private void addDMLConfig2ListWithPrimary(List list, Object[] objectArray, int n2) throws CloneNotSupportedException {
        FArray fArray = (FArray)objectArray[n2];
        for (int i2 = 0; i2 < fArray.length(); ++i2) {
            DMLColumnValues dMLColumnValues = new DMLColumnValues();
            list.add(dMLColumnValues);
            this.setDMLConfigValues(dMLColumnValues, 0, objectArray, n2, i2);
        }
    }

    private void setDMLConfigValues(DMLColumnValues dMLColumnValues, int n2, Object[] objectArray, int n3, int n4) throws CloneNotSupportedException {
        if (n2 >= objectArray.length) {
            return;
        }
        FArray fArray = (FArray)objectArray[n3];
        Object object = objectArray[n2];
        if (object instanceof FArray) {
            int n5 = ((FArray)object).length();
            object = ((FArray)object).elementAt(n4 < n5 ? n4 : n5 - 1);
        }
        dMLColumnValues.set(n2, object);
        this.setDMLConfigValues(dMLColumnValues, ++n2, objectArray, n3, n4);
    }

    private void addDMLConfig2List(DMLColumnValues dMLColumnValues, int n2, Object[] objectArray, List list) throws CloneNotSupportedException {
        if (n2 >= objectArray.length) {
            return;
        }
        Object object = objectArray[n2];
        if (object instanceof FArray) {
            int n3 = ((FArray)object).length();
            if (n3 == 0) {
                ((FArray)object).add("");
                ++n3;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                DMLColumnValues dMLColumnValues2 = dMLColumnValues;
                Object object2 = ((FArray)object).elementAt(i2);
                if (i2 > 0) {
                    dMLColumnValues2 = (DMLColumnValues)dMLColumnValues2.clone();
                    list.add(dMLColumnValues2);
                }
                dMLColumnValues2.set(n2, object2);
                this.addDMLConfig2List(dMLColumnValues2, n2 + 1, objectArray, list);
            }
        } else {
            dMLColumnValues.set(n2, object);
            this.addDMLConfig2List(dMLColumnValues, n2 + 1, objectArray, list);
        }
    }

    protected abstract int dmlSubmit(Connection var1, Calculator var2, Object[] var3, Map var4) throws SQLException;

    protected abstract boolean isIgnoreUpdate(Calculator var1);

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearColumnConfigs();
            this.clearSubmitJobs();
            this.condition = new ListCondition();
        } else if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Table".equals(string)) {
                this.table = new Table();
                xMLableReader.readXMLObject(this.table);
            } else if ("ColumnConfig".equals(string)) {
                ColumnConfig columnConfig = new ColumnConfig();
                xMLableReader.readXMLObject(columnConfig);
                this.addColumnConfig(columnConfig);
            } else if ("NameSubmitJob".equals(string)) {
                NameSubmitJob nameSubmitJob = new NameSubmitJob();
                xMLableReader.readXMLObject(nameSubmitJob);
                this.addSubmitJob(nameSubmitJob);
            } else if ("SubmitJob".equals(string)) {
                SubmitJob submitJob = DataXmlUtils.readSubmitJob(xMLableReader);
                if (submitJob != null) {
                    NameSubmitJob nameSubmitJob = new NameSubmitJob();
                    nameSubmitJob.setSubmitJob(submitJob);
                    this.addSubmitJob(nameSubmitJob);
                }
            } else if ("Condition".equals(string)) {
                this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
            } else if ("UpdateAttr".equals(string)) {
                this.updateSelected = xMLableReader.getAttrAsBoolean("updateStatus", false);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        if (this.table != null) {
            this.table.writeXML(xMLPrintWriter);
        }
        int n3 = this.getColumnConfigCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ColumnConfig columnConfig = this.getColumnConfig(n2);
            if (columnConfig == null) continue;
            columnConfig.writeXML(xMLPrintWriter);
        }
        n3 = this.getSubmitJobCount();
        for (n2 = 0; n2 < n3; ++n2) {
            this.getSubmitJob(n2).writeXML(xMLPrintWriter);
        }
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
        if (this.updateSelected) {
            xMLPrintWriter.startTAG("UpdateAttr").attr("updateStatus", this.updateSelected).end();
        }
    }

    protected Where generateWhere(Connection connection, Object[] objectArray) {
        Where where = null;
        for (int i2 = 0; i2 < this.getColumnConfigCount(); ++i2) {
            ColumnConfig columnConfig = this.getColumnConfig(i2);
            if (!columnConfig.isKey()) continue;
            if (where == null) {
                where = new Where();
            }
            String string = columnConfig.getColumnName();
            int n2 = this.getColumnType(string, connection);
            where.addColumn(string, n2, 0, objectArray[i2]);
        }
        return where;
    }

    protected int getColumnType(String string, Connection connection) {
        this.checkColumnTypes(connection);
        for (int i2 = 0; i2 < this.columnInformations.length; ++i2) {
            if (!string.equalsIgnoreCase(this.columnInformations[i2].getColumnName())) continue;
            return this.columnInformations[i2].getColumnType();
        }
        return 0;
    }

    private void checkColumnTypes(Connection connection) {
        if (this.columnInformations == null) {
            String string = DataCoreUtils.createSelectSQL(this.table, this.getDialect(connection));
            try {
                this.columnInformations = DBUtils.checkInColumnInformation(connection, string);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                this.columnInformations = new ColumnInformation[0];
            }
        }
    }

    protected void closeStatement(Connection connection) throws SQLException {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getColumnConfigCount();
        if (n2 > 0) {
            stringBuffer.append('(').append(StableUtils.join(StableUtils.map(this.columnConfigList, toName), ", ")).append(") values(").append(StableUtils.join(StableUtils.map(this.columnConfigList, toValue), ", ")).append(')');
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        int n2;
        DMLConfig dMLConfig = (DMLConfig)super.clone();
        if (this.table != null) {
            dMLConfig.table = (Table)this.table.clone();
        }
        if (this.columnConfigList != null) {
            dMLConfig.columnConfigList = new ArrayList<ColumnConfig>();
            for (n2 = 0; n2 < this.getColumnConfigCount(); ++n2) {
                dMLConfig.addColumnConfig((ColumnConfig)this.getColumnConfig(n2).clone());
            }
        }
        if (this.submitJobList != null) {
            dMLConfig.submitJobList = new ArrayList<NameSubmitJob>();
            for (n2 = 0; n2 < this.submitJobList.size(); ++n2) {
                dMLConfig.submitJobList.add((NameSubmitJob)this.getSubmitJob(n2).clone());
            }
        }
        if (this.condition != null) {
            dMLConfig.condition = (Condition)this.condition.clone();
        }
        return dMLConfig;
    }

    protected String getColumnName(int n2) {
        return this.getColumnConfig(n2).getColumnName();
    }

    public static class DMLColumnValues
    implements Serializable,
    Cloneable {
        private ArrayList values = new ArrayList();

        protected void set(int n2, Object object) {
            while (n2 >= this.values.size()) {
                this.values.add(null);
            }
            if (object instanceof FRFile) {
                this.values.set(n2, ((FRFile)object).getBytes());
            } else {
                this.values.set(n2, object);
            }
        }

        public Object get(int n2) {
            return this.values.get(n2);
        }

        protected int size() {
            return this.values.size();
        }

        protected Object[] toArray() {
            return this.values.toArray();
        }

        public Object clone() throws CloneNotSupportedException {
            DMLColumnValues dMLColumnValues = (DMLColumnValues)super.clone();
            dMLColumnValues.values = new ArrayList();
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                dMLColumnValues.set(i2, StableUtils.cloneObject(this.get(i2)));
            }
            return dMLColumnValues;
        }
    }

    public class SimpleDataModel
    implements DataModel {
        List row_list = new ArrayList();
        String[] columnNames;

        public SimpleDataModel(List list, String[] stringArray) {
            this.row_list = list;
            this.columnNames = stringArray;
        }

        public int getColumnCount() throws TableDataException {
            if (!this.row_list.isEmpty()) {
                return ((Object[])this.row_list.get(0)).length;
            }
            return 0;
        }

        public String getColumnName(int n2) throws TableDataException {
            return this.columnNames != null && this.columnNames.length > n2 ? this.columnNames[n2] : "";
        }

        public boolean hasRow(int n2) throws TableDataException {
            return !this.row_list.isEmpty();
        }

        public int getRowCount() throws TableDataException {
            return this.row_list.size();
        }

        public Object getValueAt(int n2, int n3) throws TableDataException {
            Object[] objectArray;
            if (this.row_list != null && this.row_list.size() > n2 && (objectArray = (Object[])this.row_list.get(n2)).length > n3) {
                return objectArray[n3];
            }
            return new Object();
        }

        public void release() throws Exception {
        }
    }

    class ExtractionSubmitter
    implements DBWritable.Action {
        DBFeedback feedback;
        Connection conn;
        private PreparedStatement insertedPreparedStatement = null;

        ExtractionSubmitter(Connection connection) {
            this(connection, null);
        }

        ExtractionSubmitter(Connection connection, DBFeedback dBFeedback) {
            this.conn = connection;
            this.feedback = dBFeedback;
        }

        public DBFeedback getFeedback() {
            return this.feedback;
        }

        PreparedStatement getInsertedPreparedStatement() throws SQLException {
            if (this.insertedPreparedStatement == null) {
                this.insertedPreparedStatement = this.createInsertedPreparedStatement(this.conn);
            }
            return this.insertedPreparedStatement;
        }

        private PreparedStatement createInsertedPreparedStatement(Connection connection) throws SQLException {
            IntList intList = new IntList();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Dialect dialect = DMLConfig.this.getDialect(connection);
            int n2 = DMLConfig.this.getColumnConfigCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(dialect.column2SQL(DMLConfig.this.getColumnConfig(i2).getColumnName()));
                arrayList2.add("?");
                intList.add(i2);
            }
            if (arrayList2.isEmpty()) {
                return null;
            }
            String string = "INSERT INTO " + DMLConfig.this.getTable().toStatementSQLString(dialect) + " (" + StableUtils.join(arrayList, ",") + ")" + " VALUES (" + StableUtils.join(arrayList2, ",") + ")";
            PreparedStatement preparedStatement = connection.prepareStatement(string.toString());
            return preparedStatement;
        }

        public void close() throws SQLException {
            if (this.insertedPreparedStatement != null) {
                this.insertedPreparedStatement.close();
            }
        }

        public void run(int n2, Calculator calculator, int n3) throws Exception {
            HashMap<String, Object> hashMap = null;
            if (this.feedback != null || DMLConfig.this.getSubmitJobCount() > 0) {
                hashMap = new HashMap<String, Object>();
            }
            DMLColumnValues[] dMLColumnValuesArray = DMLConfig.this.rebuildDMLConfig(calculator, n3);
            int n4 = dMLColumnValuesArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5;
                Object[] objectArray = dMLColumnValuesArray[i2].toArray();
                if (this.isAllNull(objectArray) || !this.passCondition(objectArray, calculator)) continue;
                if (hashMap != null) {
                    int n6 = DMLConfig.this.getColumnConfigCount();
                    for (n5 = 0; n5 < n6; ++n5) {
                        hashMap.put(DMLConfig.this.getColumnConfig(n5).getColumnName(), objectArray[n5]);
                    }
                }
                DMLConfig.this.dmlSubmit(this.conn, calculator, objectArray, hashMap);
                n5 = DMLConfig.this.isIgnoreUpdate(calculator) ? 1 : 0;
                if (this.feedback != null) {
                    this.feedback.addFeedbackMap(hashMap);
                }
                if (n5 != 0) continue;
                ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(hashMap);
                calculator.pushNameSpace(parameterMapNameSpace);
                String string = "es_process_tag";
                Object object = calculator.getAttribute(string);
                calculator.removeAttribute(string);
                int n7 = DMLConfig.this.getSubmitJobCount();
                for (int i3 = 0; i3 < n7; ++i3) {
                    SubmitJob submitJob = DMLConfig.this.getSubmitJob(i3).getSubmitJob();
                    submitJob.doJob(calculator);
                    if (!(submitJob instanceof DMLConfigJob) || this.feedback == null) continue;
                    this.feedback.addFeedback(((DMLConfigJob)submitJob).getFeedback());
                }
                if (object != null) {
                    calculator.setAttribute(string, object);
                }
                calculator.removeNameSpace(parameterMapNameSpace);
            }
        }

        public boolean isDynamic() {
            return false;
        }

        private boolean isAllNull(Object[] objectArray) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || objectArray[i2] == Primitive.NULL) continue;
                return false;
            }
            return true;
        }

        private boolean passCondition(Object[] objectArray, Calculator calculator) {
            if (DMLConfig.this.condition != null) {
                Condition condition = DMLConfig.this.condition;
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                arrayList.add(objectArray);
                String[] stringArray = new String[DMLConfig.this.columnConfigList.size()];
                for (int i2 = 0; i2 < DMLConfig.this.columnConfigList.size(); ++i2) {
                    stringArray[i2] = DMLConfig.this.columnConfigList.get(i2).getColumnName();
                }
                SimpleDataModel simpleDataModel = new SimpleDataModel(arrayList, stringArray);
                int[] nArray = condition.evalTableData(simpleDataModel, new int[]{0}, 0, calculator);
                if (nArray != null && nArray.length == 1) {
                    return true;
                }
            }
            return false;
        }
    }
}

