/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.utils;

import com.fr.base.CustomConfigManager;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.data.DataUtils;
import com.fr.file.ExtraClassManager;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.web.ParameterConsts;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.session.PrivilegeInfoSessionMananger;
import com.fr.stable.BaseSessionFilterParameterManager;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.RequestParameterCollector;
import com.fr.web.core.A.WB;
import com.fr.web.core.A.yA;
import com.fr.web.utils.DefaultRequestParameterCollector;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebUtils {
    private WebUtils() {
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String string) {
        return DataUtils.getHTTPRequestParameter(httpServletRequest, string);
    }

    public static int getHTTPRequestIntParameter(HttpServletRequest httpServletRequest, String string) {
        return WebUtils.getHTTPRequestIntParameter(httpServletRequest, string, -1);
    }

    public static int getHTTPRequestIntParameter(HttpServletRequest httpServletRequest, String string, int n2) {
        String string2 = DataUtils.getHTTPRequestParameter(httpServletRequest, string);
        Number number = Utils.string2Number(string2);
        if (number == null) {
            return n2;
        }
        return number.intValue();
    }

    public static String getReportTitleFromRequest(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlet");
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlets");
        }
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resultlet");
        }
        return string;
    }

    public static String createServletURL(HttpServletRequest httpServletRequest) {
        String string = CustomConfigManager.getInstance().getReportPrefix();
        if (!StringUtils.isEmpty(string)) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpServletRequest.getParameterMap().get("__addprefix__") != null || httpSession != null && httpSession.getAttribute("__addprefix__") != null) {
                httpSession.setAttribute("__addprefix__", (Object)true);
                return string + DataUtils.createServletURL(httpServletRequest);
            }
        }
        return DataUtils.createServletURL(httpServletRequest);
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse) throws IOException {
        return DataUtils.createPrintWriter(httpServletResponse);
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse, String string) throws IOException {
        return DataUtils.createPrintWriter(httpServletResponse, string);
    }

    public static void printAsJSON(HttpServletResponse httpServletResponse, JSONObject jSONObject) throws Exception {
        WebUtils.printAsString(httpServletResponse, jSONObject.toString());
    }

    public static void printAsJSON(HttpServletResponse httpServletResponse, JSONArray jSONArray) throws Exception {
        WebUtils.printAsString(httpServletResponse, jSONArray.toString());
    }

    public static void printAsString(HttpServletResponse httpServletResponse, String string) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    public static Object object2JSONable(Object object) throws JSONException {
        return WebUtils.object2JSONable(object, -1, -1);
    }

    public static Object object2JSONable(Object object, int n2, int n3) throws JSONException {
        if (object instanceof Date) {
            return new JSONObject().put("date_milliseconds", new Long(((Date)object).getTime()));
        }
        if (object instanceof Image) {
            if (n3 > 0 && n2 > 0) {
                return yA.O().A((Image)object, n2, n3).toConfig();
            }
            return yA.O().A((Image)object).toConfig();
        }
        if (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN())) {
            return Utils.objectToString(object);
        }
        return object;
    }

    public static void getPageWhenOverflow(HttpServletResponse httpServletResponse, Collection collection) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = StableUtils.getBytes() == null;
        String string = "";
        if (bl) {
            string = "window.open(\"http://www.finereport.com\");";
        }
        hashMap.put("addresses", new FArray(collection));
        hashMap.put("isRegistered", string);
        WebUtils.writeOutTemplate("/com/fr/web/core/overflow.html", httpServletResponse, hashMap);
    }

    public static void dealWithTemplate(String string, HttpServletResponse httpServletResponse) throws IOException {
        WebUtils.writeOutTemplate(string, httpServletResponse, Collections.EMPTY_MAP);
    }

    public static void writeOutTemplate(String string, HttpServletResponse httpServletResponse, Map map) throws IOException {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        WB.A(string, httpServletResponse);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        printWriter.flush();
        printWriter.close();
    }

    public static Map createSessionIDParameterMap(HttpServletRequest httpServletRequest) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (StringUtils.isBlank(string) || WebUtils.isSpecificParameters(string)) continue;
            hashMap.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, string));
        }
        return hashMap;
    }

    private static boolean isSpecificParameters(String string) {
        return "reportlet".equalsIgnoreCase(string) || "format".equalsIgnoreCase(string) || "op".equalsIgnoreCase(string);
    }

    public static Map dealWithExecuteParamMap(Map map) {
        HashMap hashMap = new HashMap();
        if (map != null) {
            for (String string : map.keySet()) {
                Object v2 = map.get(string);
                if (!(v2 instanceof JSONObject)) continue;
                Map map2 = ((JSONObject)v2).toMap();
                for (String string2 : map2.keySet()) {
                    hashMap.put(string2, map2.get(string2));
                }
            }
            hashMap.putAll(map);
        }
        for (int i2 = 0; i2 < ParameterConsts.ALL.length; ++i2) {
            if (!hashMap.containsKey(ParameterConsts.ALL[i2])) continue;
            hashMap.remove(ParameterConsts.ALL[i2]);
        }
        return hashMap;
    }

    public static String getWebINFPath(ServletContext servletContext) {
        String string = servletContext.getRealPath("/");
        if (string == null) {
            return null;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string + "WEB-INF" + File.separator;
    }

    public static Map parameters4SessionIDInforContainMPCache(HttpServletRequest httpServletRequest) {
        Object object;
        Map map = WebUtils.parameters4SessionIDInfor(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null && (object = httpSession.getAttribute("__FR_MOBILE_PARAM_CACHE__")) != null) {
            Map map2 = (Map)object;
            map.putAll(map2);
            httpSession.removeAttribute("__FR_MOBILE_PARAM_CACHE__");
        }
        return map;
    }

    public static Map parameters4SessionIDInfor(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (httpServletRequest == null) {
            return hashMap;
        }
        RequestParameterCollector requestParameterCollector = ExtraClassManager.getInstance().getRequestParameterCollector();
        if (requestParameterCollector == null) {
            requestParameterCollector = DefaultRequestParameterCollector.getInstance();
        }
        hashMap.putAll(requestParameterCollector.getParametersFromSession(httpServletRequest));
        hashMap.putAll(requestParameterCollector.getParametersFromAttribute(httpServletRequest));
        hashMap.putAll(requestParameterCollector.getParametersFromParameter(httpServletRequest));
        hashMap.putAll(requestParameterCollector.getParametersFromJSON(httpServletRequest, hashMap));
        HttpSession httpSession = httpServletRequest.getSession(false);
        hashMap.put("__locale__", httpServletRequest.getLocale());
        String[] stringArray = BaseSessionFilterParameterManager.getFilterParameters();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashMap.remove(stringArray[i2]);
        }
        if (httpSession != null) {
            FArray fArray;
            String string;
            FArray fArray2 = PrivilegeInfoSessionMananger.getCurrentAuthorities(httpSession);
            if (fArray2 != null) {
                hashMap.put("fr_authority", fArray2);
            }
            if ((string = PrivilegeInfoSessionMananger.getCurrentUserName(httpSession)) != null) {
                hashMap.put("fr_username", string);
            }
            if ((fArray = PrivilegeInfoSessionMananger.getCurrentDepartmentAndPost(httpSession)) != null) {
                hashMap.put("fr_userposition", fArray);
            }
        }
        return hashMap;
    }

    private static void readParaFromSession(Map map, HttpSession httpSession) {
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                String string = CodeUtils.decodeText("" + e2);
                map.put(string.toUpperCase(), httpSession.getAttribute("" + e2));
            }
        }
    }

    private static void readParaFromAttr(Map map, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e2);
            try {
                if (map.containsKey(string.toUpperCase())) {
                    map.remove(string.toUpperCase());
                }
                map.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e2));
            }
            catch (Exception exception) {}
        }
    }

    private static void readParaFromParameter(Map map, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e2);
            try {
                if (map.containsKey(string.toUpperCase())) {
                    map.remove(string.toUpperCase());
                }
                map.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e2));
                if ("reportlet".equalsIgnoreCase(string)) {
                    map.put("reportName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e2));
                }
                if ("formlet".equalsIgnoreCase(string)) {
                    map.put("formletName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e2));
                }
                map.put(URLDecoder.decode(string, "UTF-8"), WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e2));
            }
            catch (Exception exception) {}
        }
    }

    private static void readParaFromJSONParameter(Map map) {
        Object v2 = map.get("__parameters__");
        if (v2 instanceof String) {
            try {
                Map map2 = GeneralUtils.jsonString2Map((String)v2);
                for (Map.Entry entry : map2.entrySet()) {
                    String string = (String)entry.getKey();
                    if (!map.containsKey(string.toUpperCase())) continue;
                    map.remove(string.toUpperCase());
                }
                map.putAll(map2);
                map.remove("__parameters__");
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
    }

    public static String getOriginalURL(HttpServletRequest httpServletRequest) {
        return DataUtils.getOriginalURL(httpServletRequest);
    }

    public static String getIpAddr(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }

    public static boolean isLocalHost(String string) {
        return "127.0.0.1".equals(string) || "localhost".equals(string) || string != null && string.startsWith("0:0:0:0:0:0:0:1");
    }

    public static int receivePageNumber(HttpServletRequest httpServletRequest) {
        Number number;
        int n2 = 0;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "pn");
        if (string != null && ((number = Utils.string2Number(string)) == null || (n2 = number.intValue()) < 0)) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    public static boolean isMobileAPPRequest(HttpServletRequest httpServletRequest) {
        return "true".equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "__mobileapp__"));
    }
}

