/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.entry;

import com.fr.data.dao.DAOBean;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.platform.entry.Entry;

public abstract class BaseEntry
extends DAOBean
implements Entry {
    public static final String ID = "id";
    public static final String PARENTID = "parent";
    public static final String DISPLAYNAME = "name";
    public static final String DESCRIPTION = "description";
    public static final int IDTYPE = 4;
    public static final int PARENTIDTYPE = 4;
    public static final int DISPLAYNAMETYPE = 12;
    public static final int DESCRIPTIONTYPE = 12;
    public static final String SORTINDEX = "sortindex";
    public static final int SORTINDEXTYPE = -5;
    private long parentId;
    private String displayName;
    private String description;
    protected long sortindex;

    public BaseEntry() {
    }

    public BaseEntry(String string) {
        this.displayName = string;
    }

    public BaseEntry(String string, String string2) {
        this(string);
        this.description = string2;
    }

    public JSONObject createShowJSONConfig() throws JSONException {
        return this.createJSONConfig();
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(ID, this.getTypePrefix() + this.getId());
        jSONObject.put("type", this.getTypePrefix());
        jSONObject.put("parentId", "0" + this.getParentId());
        jSONObject.put("text", this.getRealDisplayName());
        jSONObject.put("value", this.getTypePrefix() + this.getId());
        jSONObject.put(DESCRIPTION, this.getDescription());
        jSONObject.put(SORTINDEX, this.sortindex);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        this.setDisplayName(jSONObject.getString("text"));
        this.setDescription(jSONObject.getString(DESCRIPTION));
        this.setParentId(jSONObject.getLong("parentId"));
        if (jSONObject.has(SORTINDEX)) {
            this.setSortindex(jSONObject.getLong(SORTINDEX));
        }
        if (jSONObject.has(ID) && StringUtils.isNotBlank(jSONObject.getString(ID))) {
            this.setId(jSONObject.getLong(ID));
        }
    }

    public abstract String getTypePrefix();

    public long getSortindex() {
        return this.sortindex;
    }

    public void setSortindex(long l2) {
        this.sortindex = l2;
    }

    public void setParentId(long l2) {
        this.parentId = l2;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected String getRealDisplayName() {
        return this.displayName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public int getShowType() {
        return -1;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    protected int hashCode4Properties() {
        int n2 = 1;
        n2 = 31 * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = 31 * n2 + (this.displayName == null ? 0 : this.displayName.hashCode());
        n2 = 31 * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = 31 * n2 + (int)(this.parentId ^ this.parentId >>> 32);
        return n2;
    }

    public boolean equals4Properties(Object object) {
        if (!(object instanceof BaseEntry)) {
            return false;
        }
        BaseEntry baseEntry = (BaseEntry)object;
        return baseEntry.id == this.id && baseEntry.parentId == this.parentId && ComparatorUtils.equals(baseEntry.displayName, this.displayName) && ComparatorUtils.equals(baseEntry.description, this.description);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseEntry baseEntry = (BaseEntry)super.clone();
        return baseEntry;
    }
}

