/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.dataModel;

import com.fr.base.FRContext;
import com.fr.file.CacheManager;
import com.fr.json.JSONException;
import com.fr.web.platform.dataModel.PlatFormData;
import com.fr.web.platform.dataModel.ServerDataModel;

public class CacheSetDataModel
extends ServerDataModel {
    protected void loadData(PlatFormData platFormData) throws JSONException {
        platFormData.put("maxElementsInMemory", CacheManager.getInstance().getDbConfig().getMaxElementsInMemory());
        platFormData.put("memoryStoreEvictionPolicy", CacheManager.getInstance().getDbConfig().getMemoryStoreEvictionPolicy());
        platFormData.put("timeToIdleSeconds", CacheManager.getInstance().getDbConfig().getTimeToIdleSeconds());
        platFormData.put("timeToLiveSeconds", CacheManager.getInstance().getDbConfig().getTimeToLiveSeconds());
        platFormData.put("alwaysReloadTpl", CacheManager.getInstance().isAlwaysReloadTpl());
    }

    protected void store(PlatFormData platFormData) throws Exception {
        if (platFormData.getString("maxElementsInMemory") != null) {
            CacheManager.getInstance().getDbConfig().setMaxElementsInMemory(platFormData.getInt("maxElementsInMemory"));
        }
        if (platFormData.getString("memoryStoreEvictionPolicy") != null) {
            CacheManager.getInstance().getDbConfig().setMemoryStoreEvictionPolicy(platFormData.getString("memoryStoreEvictionPolicy"));
        }
        if (platFormData.getString("timeToIdleSeconds") != null) {
            CacheManager.getInstance().getDbConfig().setTimeToIdleSeconds(platFormData.getLong("timeToIdleSeconds"));
        }
        if (platFormData.getString("timeToLiveSeconds") != null) {
            CacheManager.getInstance().getDbConfig().setTimeToLiveSeconds(platFormData.getLong("timeToLiveSeconds"));
        }
        CacheManager.getInstance().setAlwaysReloadTpl(platFormData.getBoolean("alwaysReloadTpl"));
        FRContext.getCurrentEnv().writeResource(CacheManager.getInstance());
    }
}

