/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.data.dao.FCValueMapper;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.FCloneable;
import com.fr.stable.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TransmitParameters
implements FCloneable,
Serializable {
    public static final String STRING = "String";
    public static final String INTEGER = "Integer";
    public static final String DOUBLE = "Double";
    public static final String DATE = "Date";
    public static final String BOOLEAN = "Boolean";
    public static final String FORMULA = "Formula";
    public static final String LONG = "Long";
    public static final String MULTI = "Multi";
    private List parameterList = new ArrayList();
    public static final FCValueMapper TRANPARAM_VALUE_MAPPER = new Mapper();

    public TransmitParameters() {
    }

    public TransmitParameters(Parameter[] parameterArray) {
        for (int i2 = 0; i2 < parameterArray.length; ++i2) {
            this.add(parameterArray[i2]);
        }
    }

    public JSONArray createJSON() throws JSONException {
        return Parameter.parameters2JSONString(this.toArray());
    }

    public static TransmitParameters parseJSON(JSONArray jSONArray) throws JSONException {
        TransmitParameters transmitParameters = new TransmitParameters();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            transmitParameters.add(Parameter.getParameterFromJson(jSONObject));
        }
        return transmitParameters;
    }

    public int size() {
        return this.parameterList.size();
    }

    public Parameter[] toArray() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    public Parameter get(int n2) {
        return (Parameter)this.parameterList.get(n2);
    }

    public void add(Parameter parameter) {
        this.parameterList.add(parameter);
    }

    public void set(int n2, Parameter parameter) {
        this.parameterList.set(n2, parameter);
    }

    public void clear() {
        this.parameterList.clear();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.parameterList == null ? 0 : ((Object)this.parameterList).hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransmitParameters)) {
            return false;
        }
        TransmitParameters transmitParameters = (TransmitParameters)object;
        return ComparatorUtils.equals(this.parameterList, transmitParameters.parameterList);
    }

    public Object clone() throws CloneNotSupportedException {
        TransmitParameters transmitParameters = (TransmitParameters)super.clone();
        if (this.parameterList != null) {
            transmitParameters.parameterList = new ArrayList();
            for (int i2 = 0; i2 < this.parameterList.size(); ++i2) {
                Object object = this.parameterList.get(i2);
                if (object instanceof FCloneable) {
                    object = ((FCloneable)object).clone();
                }
                transmitParameters.parameterList.add(object);
            }
        }
        return transmitParameters;
    }

    private static class Mapper
    implements FCValueMapper {
        private Mapper() {
        }

        public Object value2Field(Object object) {
            String string = (String)object;
            if (StringUtils.isBlank(string)) {
                return null;
            }
            TransmitParameters transmitParameters = null;
            try {
                transmitParameters = TransmitParameters.parseJSON(new JSONArray(string));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
            return transmitParameters;
        }

        public Object field2Value(Object object) {
            if (object == null) {
                return "";
            }
            TransmitParameters transmitParameters = (TransmitParameters)object;
            String string = "";
            try {
                string = transmitParameters.createJSON().toString();
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
            return string;
        }
    }
}

