/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform;

import com.fr.base.FRContext;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.core.PrivilegeVoteImpls;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.platform.SimpleControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PermissionAndAuthorityControl
extends SimpleControl {
    private List authorityNameList = new ArrayList();

    public int getAuthoryryNameCount() {
        return this.authorityNameList.size();
    }

    public JSONArray getAuthorityNameArray() {
        return new JSONArray(this.authorityNameList);
    }

    public void setAuthorityName(JSONArray jSONArray) {
        this.authorityNameList.clear();
        try {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                this.authorityNameList.add(jSONArray.get(i2));
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    public void addAuthorityName(String string) {
        this.authorityNameList.add(string);
    }

    public String getAuthorityName(int n2) {
        if (n2 < 0 || n2 > this.authorityNameList.size() - 1) {
            return null;
        }
        return (String)this.authorityNameList.get(n2);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            this.authorityNameList.clear();
        }
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("NameAttr")) {
            String string2 = xMLableReader.getAttrAsString("names", "");
            Iterator iterator = new FArray(string2.split(",")).iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!StringUtils.isNotBlank(string3)) continue;
                this.authorityNameList.add(string3);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("XMLable");
        if (this.authorityNameList.size() > 0) {
            xMLPrintWriter.startTAG("NameAttr").attr("names", StableUtils.join(this.authorityNameList, ",")).end();
        }
        xMLPrintWriter.end();
    }

    public PrivilegeVote access(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return PrivilegeVoteImpls.MP_AUTH_ERROR;
        }
        Authority[] authorityArray = authentication.getAuthorities();
        if (authorityArray == null || authorityArray.length == 0) {
            return PrivilegeVoteImpls.MP_ROLE_ERROR;
        }
        if (authentication.isRoot()) {
            return PrivilegeVoteImpls.SUCCESS;
        }
        int n2 = authorityArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.authorityNameList.contains(authorityArray[i2].getName())) continue;
            authentication.setAuthorities(new Authority[]{new Authority(authorityArray[i2].getName())});
            return PrivilegeVoteImpls.SUCCESS;
        }
        return PrivilegeVoteImpls.MP_ROLE_ERROR;
    }

    public int getID() {
        return 1;
    }
}

