/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reserve;

import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DeclareRecordType;
import com.fr.general.FRLogManager;
import com.fr.general.Inter;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.CPTExporter;
import com.fr.io.exporter.CSVExporter;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.HTMLExporter;
import com.fr.io.exporter.ImageExporter;
import com.fr.io.exporter.LargeDataPageExcel2007Exporter;
import com.fr.io.exporter.LargeDataPageExcelExporter;
import com.fr.io.exporter.PDFExporter;
import com.fr.io.exporter.PDFExporter2;
import com.fr.io.exporter.PageExcelExporter;
import com.fr.io.exporter.PageToSheetExcelExporter;
import com.fr.io.exporter.SVGExporter;
import com.fr.io.exporter.StreamExcelExporter;
import com.fr.io.exporter.TextExporter;
import com.fr.io.exporter.WordExporter;
import com.fr.log.LogUtils;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.B;
import com.fr.report.core.ReportUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.web.Browser;
import com.fr.web.core.A.YC;
import com.fr.web.core.A.xE;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.utils.ExportUtils;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportService
extends YC {
    private static boolean offlineWriteAble = true;

    public String actionOP() {
        return "export";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        ExportService.dealWithExport(httpServletRequest, httpServletResponse, string, false);
    }

    public static void dealResponse4Export(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "public");
        httpServletResponse.setHeader("Cache-Control", "max-age=3");
        httpServletResponse.reset();
    }

    public static void dealWithExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) throws Exception {
        ReportSessionIDInfor reportSessionIDInfor;
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        }
        if ((reportSessionIDInfor = (ReportSessionIDInfor)SessionDealWith.getSessionIDInfor(string)) == null) {
            return;
        }
        ExportService.dealResponse4Export(httpServletResponse);
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "format");
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "__filename__");
        if (string3 == null) {
            string3 = (String)reportSessionIDInfor.getParameterValue("__filename__");
        }
        if (string3 == null) {
            string3 = reportSessionIDInfor.getWebTitle().replaceAll("\\s", "_");
            string3 = string3.replaceAll(",", "_");
        }
        Browser browser = Browser.resolve(httpServletRequest);
        string3 = browser.getEncodedFileName4Download(string3);
        ExportService.doExport(httpServletRequest, httpServletResponse, reportSessionIDInfor, string2, string3, bl, browser);
        reportSessionIDInfor.setAttribute("genpdfprint", Boolean.FALSE);
    }

    private static void doExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string, String string2, boolean bl, Browser browser) throws Exception {
        AppExporter[] appExporterArray = new AppExporter[]{null};
        DeclareRecordType[] declareRecordTypeArray = new DeclareRecordType[]{null};
        ExportService.getExporterAndType(httpServletRequest, httpServletResponse, reportSessionIDInfor, string, string2, bl, browser, appExporterArray, declareRecordTypeArray);
        AppExporter appExporter = appExporterArray[0];
        DeclareRecordType declareRecordType = declareRecordTypeArray[0];
        if (declareRecordType == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "Cannot recognize the specifed export format:" + string + ",\nThe correct format can be PDF,Excel,Word,SVG,CSV,Text or Image.");
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            LogUtils.exportAndLogRecord(appExporter, (OutputStream)servletOutputStream, new ReportRepositoryDeal(httpServletRequest, reportSessionIDInfor), declareRecordType);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, exception);
        }
        try {
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void getExporterAndType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string, String string2, boolean bl, Browser browser, AppExporter[] appExporterArray, DeclareRecordType[] declareRecordTypeArray) throws Exception {
        if (string.equalsIgnoreCase("PDF")) {
            ExportUtils.setPDFContent(httpServletResponse, string2, bl);
            appExporterArray[0] = ExportService.getPDFExporter(httpServletRequest, reportSessionIDInfor);
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_PDF;
        } else if (string.equalsIgnoreCase("Excel")) {
            ExportService.dealExcelExporter(httpServletRequest, httpServletResponse, reportSessionIDInfor, appExporterArray, declareRecordTypeArray, string2, browser);
        } else if (string.equalsIgnoreCase("Word")) {
            ExportUtils.setWordConetent(httpServletResponse, string2);
            appExporterArray[0] = new WordExporter();
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_WORD;
        } else if (string.equalsIgnoreCase("SVG")) {
            ExportUtils.setSVGContext(httpServletResponse, string2);
            appExporterArray[0] = new SVGExporter();
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_SVG;
        } else if (string.equalsIgnoreCase("CSV")) {
            ExportUtils.setCSVContext(httpServletResponse, string2);
            appExporterArray[0] = new CSVExporter();
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_CSV;
        } else if (string.equalsIgnoreCase("Text")) {
            ExportUtils.setTextContext(httpServletResponse, string2);
            appExporterArray[0] = new TextExporter();
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_TEXT;
        } else if (string.equalsIgnoreCase("image")) {
            declareRecordTypeArray[0] = ExportService.getImageExportType(httpServletRequest);
            appExporterArray[0] = new ImageExporter(declareRecordTypeArray[0].getTypeString(), 96);
            ExportUtils.setImageContext(httpServletResponse, string2, declareRecordTypeArray[0].getTypeString());
        } else if (string.equalsIgnoreCase("cpt")) {
            if (StringUtils.isEmpty(WebUtils.getHTTPRequestParameter(httpServletRequest, "__filename__"))) {
                string2 = (string2 + "/" + DateUtils.DATEFORMAT1.format(new Date())).replaceAll("\\/", "_");
            }
            ExportUtils.setCPTContext(httpServletResponse, string2);
            appExporterArray[0] = new CPTExporter();
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_CPT;
        } else if (string.equalsIgnoreCase("html")) {
            ExportUtils.setHTMLContext(httpServletResponse, string2);
            appExporterArray[0] = new HTMLExporter();
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_HTML;
        } else if (string.equalsIgnoreCase("write_html")) {
            if (!offlineWriteAble) {
                throw new RegistEditionException(VT4FR.OFFLINE_WRITE, false);
            }
            ExportUtils.setZipContext(httpServletResponse, string2, true);
            appExporterArray[0] = (AppExporter)StableFactory.createNewObject("WriterHTMLExporter");
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_WRITE_HTML;
        }
    }

    private static AppExporter getPDFExporter(HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "extype");
        boolean bl = ComparatorUtils.equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "isPDFPrint"), "true");
        reportSessionIDInfor.setAttribute("genpdfprint", bl);
        if (bl) {
            LogUtils.recordPrintInfo(reportSessionIDInfor.getBookPath(), reportSessionIDInfor.getParameterMap4Execute4Consisent(), DeclareRecordType.PRINT_TYPE_PDF, reportSessionIDInfor, FRLogManager.getDeclareSQLContent());
            if (!Browser.resolve(httpServletRequest).isIE()) {
                FRContext.getLogger().error(Inter.getLocText("NS_print_pdf"));
            }
        }
        xE xE2 = new xE();
        float[] fArray = xE2.A(reportSessionIDInfor);
        reportSessionIDInfor.setoffset(bl ? fArray : new float[2]);
        PDFExporter pDFExporter = ComparatorUtils.equals("rs", string) ? new PDFExporter2(bl) : new PDFExporter(bl);
        return pDFExporter;
    }

    private static void dealExcelExporter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, AppExporter[] appExporterArray, DeclareRecordType[] declareRecordTypeArray, String string, Browser browser) {
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "extype");
        ResultWorkBook resultWorkBook = reportSessionIDInfor.getWorkBook2Show();
        boolean bl = true;
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (!(resultWorkBook.getReport(i2) instanceof A) && !(resultWorkBook.getReport(i2) instanceof B)) continue;
            if ("simple".equalsIgnoreCase(string2)) {
                bl = false;
            }
            if ("sheet".equalsIgnoreCase(string2)) break;
            string2 = "ldpage";
            break;
        }
        if ("ldpage".equalsIgnoreCase(string2)) {
            ExportUtils.setZipContext(httpServletResponse, string, browser.shouldSetContentTypeOnZipDownload());
            List<PaperSettingProvider> list = ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook());
            appExporterArray[0] = ExcelUtils.checkPOIJarExist() ? new LargeDataPageExcel2007Exporter(list, bl) : new LargeDataPageExcelExporter(list, bl);
            declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_EXCEL_LARGE;
        } else {
            if (ExcelUtils.checkPOIJarExist()) {
                ExportUtils.setExcel2007Content(httpServletResponse, string);
            } else {
                ExportUtils.setExcelContent(httpServletResponse, string);
            }
            if ("simple".equalsIgnoreCase(string2)) {
                appExporterArray[0] = new ExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
                declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_EXCEL_ORIGINAL;
            } else if ("sheet".equalsIgnoreCase(string2)) {
                appExporterArray[0] = new PageToSheetExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
                declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_EXCEL_PAGESHEET;
            } else if ("stream".equalsIgnoreCase(string2)) {
                appExporterArray[0] = new StreamExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
                declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_EXCEL_ORIGINAL;
            } else {
                appExporterArray[0] = new PageExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(reportSessionIDInfor.getContextBook()));
                declareRecordTypeArray[0] = DeclareRecordType.EXPORT_TYPE_EXCEL_PAGE;
            }
        }
    }

    private static DeclareRecordType getImageExportType(HttpServletRequest httpServletRequest) {
        DeclareRecordType[] declareRecordTypeArray = new DeclareRecordType[]{DeclareRecordType.EXPORT_TYPE_IMAGE_PNG, DeclareRecordType.EXPORT_TYPE_IMAGE_JPG, DeclareRecordType.EXPORT_TYPE_IMAGE_GIF, DeclareRecordType.EXPORT_TYPE_IMAGE_BMP, DeclareRecordType.EXPORT_TYPE_IMAGE_WBMP};
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "extype");
        int n2 = 0;
        if (string != null) {
            for (int i2 = 0; i2 < declareRecordTypeArray.length; ++i2) {
                if (!string.equalsIgnoreCase(declareRecordTypeArray[i2].getTypeString())) continue;
                n2 = i2;
                break;
            }
        }
        return declareRecordTypeArray[n2];
    }

    static {
        offlineWriteAble = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.OFFLINE_WRITE.support();
    }
}

