/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reportcase;

import com.fr.base.DynamicPixList;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.cache.list.IntList;
import com.fr.general.ComparatorUtils;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cellcase.CellCase;
import com.fr.report.core.A.H;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.AbstractECReport;
import com.fr.report.report.ECReport;
import com.fr.stable.ColumnRow;
import com.fr.stable.unit.UNITConstants;
import com.fr.stable.web.Repository;
import com.fr.web.core.reportcase.AbstractWebReportCase;
import com.fr.write.WebWriteByPageReportCaseProvider;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WebWriteByPageReportCase
extends AbstractWebReportCase
implements WebWriteByPageReportCaseProvider {
    private DynamicPixList colPixList;
    private DynamicPixList rowPixList;
    private int resolution;
    private IntList rowList = new IntList();
    private IntList breakRowIndexList = new IntList();
    private int totalPage;
    private IntList headList = new IntList();
    private IntList footList = new IntList();

    public WebWriteByPageReportCase(ElementCase elementCase, Repository repository, int n2) {
        super(elementCase);
        int n3;
        this.cutPageByCellPageAttr((ECReport)elementCase, n2);
        int n4 = this.rowList.size();
        int n5 = elementCase.getColumnCount();
        DynamicUnitList dynamicUnitList = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n5);
        DynamicUnitList dynamicUnitList2 = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n4);
        for (n3 = 0; n3 < n4; ++n3) {
            dynamicUnitList2.set(n3, elementCase.getRowHeightList_DEC().get(this.rowList.get(n3)));
        }
        for (n3 = 0; n3 < n5; ++n3) {
            dynamicUnitList.set(n3, elementCase.getColumnWidthList_DEC().get(n3));
        }
        this.colPixList = dynamicUnitList.toDynamicPixList();
        this.rowPixList = dynamicUnitList2.toDynamicPixList();
        this.resolution = repository.getResolution();
    }

    public IntList getRowList() {
        return this.rowList;
    }

    public int getRowHeight() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.rowPixList.getElementSize(); ++i2) {
            n2 += this.rowPixList.get(i2, this.resolution);
        }
        return n2;
    }

    public int getColWidth() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.colPixList.getElementSize(); ++i2) {
            n2 += this.colPixList.get(i2, this.resolution);
        }
        return n2;
    }

    public int getColumnPixWidth(int n2) {
        return this.colPixList.get(n2, this.resolution);
    }

    public int getRowPixHeight(int n2) {
        return this.rowPixList.get(n2, this.resolution);
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public Iterator getRow(int n2) {
        return new WriteRowIterator(this, n2);
    }

    private void cutPageByCellPageAttr(ECReport eCReport, int n2) {
        ReportPageAttrProvider reportPageAttrProvider = eCReport.getReportPageAttr();
        int n3 = reportPageAttrProvider.getRepeatHeaderRowFrom();
        int n4 = reportPageAttrProvider.getRepeatHeaderRowTo();
        int n5 = reportPageAttrProvider.getRepeatFooterRowFrom();
        int n6 = reportPageAttrProvider.getRepeatFooterRowTo();
        CellCase cellCase = ((AbstractECReport)eCReport).getCellCase();
        H._C _C2 = (H._C)cellCase;
        for (int i2 = 0; i2 < eCReport.getRowCount(); ++i2) {
            int n7 = _C2.J(i2);
            if (n7 >= n3 && n7 <= n4) {
                this.headList.add(i2);
            }
            if (n7 < n5 || n7 > n6) continue;
            this.footList.add(i2);
        }
        Iterator iterator = eCReport.cellIterator();
        while (iterator.hasNext()) {
            int n8;
            CellElement cellElement = (CellElement)iterator.next();
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
            if (cellPageAttr == null || ComparatorUtils.equals(cellPageAttr, CellPageAttr.DEFAULT_CELLPAGEATTR) || !cellPageAttr.isCanBreakOnPaginate()) continue;
            if (cellPageAttr.isPageAfterRow() && (n8 = cellElement.getRow() + cellElement.getRowSpan()) > 0) {
                this.breakRowIndexList.add(n8);
            }
            if (!cellPageAttr.isPageBeforeRow() || (n8 = cellElement.getRow()) <= 0) continue;
            this.breakRowIndexList.add(n8);
        }
        this.createRowList(eCReport, this.breakRowIndexList, n2);
    }

    private void createRowList(ECReport eCReport, IntList intList, int n2) {
        intList.removeEqual();
        intList.sort();
        if (intList.size() > 0 && intList.get(intList.size() - 1) >= eCReport.getRowCount() - this.footList.size()) {
            intList.remove(intList.size() - 1);
        }
        this.totalPage = intList.size() == 0 ? 1 : intList.size() + 1;
        if (n2 < 1 || n2 > intList.size() + 1) {
            n2 = 1;
        }
        int n3 = n2 > 1 && intList.size() > n2 - 2 ? intList.get(n2 - 2) : 0;
        int n4 = n2 <= intList.size() ? intList.get(n2 - 1) : eCReport.getRowCount();
        for (int i2 = n3; i2 < n4; ++i2) {
            this.rowList.add(i2);
        }
        this.rowList.addAll(this.headList);
        this.rowList.addAll(this.footList);
        this.rowList.removeEqual();
        this.rowList.sort();
    }

    private void cutPageByPageSetting(ECReport eCReport, int n2) {
        int n3;
        ReportPageAttrProvider reportPageAttrProvider = eCReport.getReportPageAttr();
        int n4 = reportPageAttrProvider.getRepeatHeaderRowFrom();
        int n5 = reportPageAttrProvider.getRepeatHeaderRowTo();
        int n6 = reportPageAttrProvider.getRepeatFooterRowFrom();
        int n7 = reportPageAttrProvider.getRepeatFooterRowTo();
        DynamicPixList dynamicPixList = eCReport.getRowHeightList_DEC().toDynamicPixList();
        ReportSettingsProvider reportSettingsProvider = eCReport.getReportSettings();
        long l2 = reportSettingsProvider.getPaperSetting().getPaperSize().getHeight().toFU();
        int n8 = 0;
        int n9 = 0;
        int n10 = eCReport.getRowHeightList_DEC().size();
        for (n3 = 0; n3 < n10; ++n3) {
            long l3 = dynamicPixList.getElement(n3);
            if (l3 < l2 * (long)(n2 - 1)) {
                n8 = n3;
                continue;
            }
            if (l3 >= l2 * (long)n2) break;
            n9 = n3;
        }
        this.totalPage = Integer.parseInt(String.valueOf(dynamicPixList.getElement(n10 - 1) / l2)) + 1;
        for (n3 = n8; n3 < n9; ++n3) {
            this.rowList.add(n3);
        }
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getCellPage(ColumnRow columnRow) {
        int n2 = columnRow.row + 1;
        for (int i2 = 0; i2 < this.breakRowIndexList.size(); ++i2) {
            if (n2 > this.breakRowIndexList.get(i2)) continue;
            return i2 + 1;
        }
        return this.breakRowIndexList.size() + 1;
    }

    public int getRowByIdx(int n2) {
        return this.rowList.get(n2);
    }

    public int getIdxByRow(int n2) {
        return this.rowList.indexOf(n2);
    }

    private class WriteRowIterator
    implements Iterator {
        private int rowIndex;
        private WebWriteByPageReportCase reportCase;
        int current_column = -1;
        int next_column = 0;
        CellElement next;

        public WriteRowIterator(WebWriteByPageReportCase webWriteByPageReportCase2, int n2) {
            this.rowIndex = n2;
            this.reportCase = webWriteByPageReportCase2;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            CellElement cellElement = this.next;
            this.findNext();
            return cellElement;
        }

        public void remove() {
        }

        private void findNext() {
            int n2 = this.reportCase.rowList.get(this.rowIndex);
            if (n2 < 0) {
                this.next = null;
                return;
            }
            while (this.next_column < this.reportCase.getColumnCount()) {
                ElementCase elementCase = (ElementCase)this.reportCase.packee;
                CellElement cellElement = elementCase.getCellElement(this.next_column, n2);
                this.current_column = this.next_column++;
                int n3 = this.reportCase.breakRowIndexList.indexOf(n2);
                if (cellElement == null || cellElement.getColumn() != this.current_column || cellElement.getRow() != n2 && n3 == -1) continue;
                try {
                    this.next = cellElement;
                    if (cellElement.getRow() != n2 && n3 != -1) {
                        int n4 = this.reportCase.headList.size() + this.reportCase.footList.size();
                        int n5 = this.reportCase.breakRowIndexList.get(n3);
                        int n6 = this.reportCase.breakRowIndexList.get(0);
                        int n7 = cellElement.getRow() + cellElement.getRowSpan() - n5;
                        int n8 = n7 >= n5 - n4 ? n6 - n4 : n7;
                        this.next = cellElement.clone(this.current_column, n2, cellElement.getColumnSpan(), n8);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage());
                }
                return;
            }
            this.next = null;
        }
    }
}

