/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess.dao;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DAOSession;
import com.fr.web.core.process.reportprocess.ProcessTask;
import com.fr.web.core.process.reportprocess.dao.ProcessDAOManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTaskDAO {
    private static ProcessTaskDAO SC = new ProcessTaskDAO();

    private ProcessTaskDAO() {
    }

    public static ProcessTaskDAO getInstance() {
        return SC;
    }

    private DAOSession createSession() {
        return ProcessDAOManager.createProcessTaskSession();
    }

    public long save(ProcessTask processTask) throws Exception {
        return this.createSession().save(processTask);
    }

    public boolean saveOrUpdate(ProcessTask processTask) throws Exception {
        return this.createSession().saveOrUpdate(processTask);
    }

    public boolean update(ProcessTask processTask) throws Exception {
        return this.createSession().update(processTask);
    }

    public boolean delete(ProcessTask processTask) throws Exception {
        if (processTask == null) {
            return false;
        }
        return this.deleteByID(processTask.getId());
    }

    public boolean deleteByID(long l2) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        return this.createSession().deleteByPrimaryKey(ProcessTask.class, l2);
    }

    public boolean deleteByFields(Map map) throws DAOException {
        return this.createSession().deleteByFields(ProcessTask.class, map);
    }

    public ProcessTask findByID(long l2) throws Exception {
        return (ProcessTask)this.createSession().load(ProcessTask.class, l2);
    }

    public List<ProcessTask> findAll() throws Exception {
        return this.createSession().list(ProcessTask.class);
    }

    public List<ProcessTask> listByFieldValue(String string, Object object) throws Exception {
        return this.createSession().listByFieldValue(ProcessTask.class, string, object);
    }

    public List<ProcessTask> listByFieldsAndSort(String[] stringArray, Object[] objectArray, int[] nArray, String string, boolean bl) throws Exception {
        return this.createSession().listByFieldsAndSort(ProcessTask.class, stringArray, objectArray, nArray, string, bl);
    }

    public boolean updateName(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        return this.createSession().update(ProcessTask.class, l2, hashMap);
    }

    public boolean updateProcessId(long l2, boolean bl) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("processId", bl);
        return this.createSession().update(ProcessTask.class, l2, hashMap);
    }

    public boolean updateIssueControl(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("issueControl", string);
        return this.createSession().update(ProcessTask.class, l2, hashMap);
    }

    public boolean updateRemindControl(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("remindControl", string);
        return this.createSession().update(ProcessTask.class, l2, hashMap);
    }

    public boolean updateDeadline(long l2, Date date) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Date> hashMap = new HashMap<String, Date>();
        hashMap.put("deadLine", date);
        return this.createSession().update(ProcessTask.class, l2, hashMap);
    }

    public boolean updateIssueOver(long l2, boolean bl) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("issueOver", bl);
        return this.createSession().update(ProcessTask.class, l2, hashMap);
    }
}

