/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess.dao;

import com.fr.data.dao.DAOSession;
import com.fr.web.core.process.reportprocess.ProcessNode;
import com.fr.web.core.process.reportprocess.dao.ProcessDAOManager;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessNodeDAO {
    private static ProcessNodeDAO SC = new ProcessNodeDAO();

    private ProcessNodeDAO() {
    }

    public static ProcessNodeDAO getInstance() {
        return SC;
    }

    private DAOSession createSession() {
        return ProcessDAOManager.createProcessNodeSession();
    }

    public long save(ProcessNode processNode) throws Exception {
        return this.createSession().save(processNode);
    }

    public boolean saveOrUpdate(ProcessNode processNode) throws Exception {
        return this.createSession().saveOrUpdate(processNode);
    }

    public boolean update(ProcessNode processNode) throws Exception {
        return this.createSession().update(processNode);
    }

    public boolean delete(ProcessNode processNode) throws Exception {
        if (processNode == null) {
            return false;
        }
        return this.deleteByID(processNode.getId());
    }

    public boolean deleteByID(long l2) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        return this.createSession().deleteByPrimaryKey(ProcessNode.class, l2);
    }

    public ProcessNode findByID(long l2) throws Exception {
        return (ProcessNode)this.createSession().load(ProcessNode.class, l2);
    }

    public List<ProcessNode> listByFieldValue(String string, Object object) throws Exception {
        return this.createSession().listByFieldValue(ProcessNode.class, string, object);
    }

    public List findAll() throws Exception {
        return this.createSession().list(ProcessNode.class);
    }

    public boolean updateName(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateProcessId(long l2, long l3) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("processId", l3);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateDescribe(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("describe", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateAuthority(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("authority", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateReportPath(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("reportControl", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateAlertControl(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("alertControl", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateNeedOfflineReport(long l2, boolean bl) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("needOfflineReport", bl);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }
}

