/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.base.fservice.ToastChecker;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.AlertToast;
import com.fr.web.core.process.reportprocess.RemindToast;
import com.fr.web.core.process.reportprocess.dao.AlertToastDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessToastDAO;
import com.fr.web.core.process.reportprocess.dao.RemindToastDAO;
import com.fr.web.platform.SystemToast;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;

public class ProcessToastChecker
implements ToastChecker {
    private String[] types;
    private RemindToast rt = new RemindToast();
    private AlertToast at = new AlertToast();
    private static ProcessToastChecker SC = new ProcessToastChecker();

    public static ProcessToastChecker getInstance() {
        return SC;
    }

    private ProcessToastChecker() {
        this.types = new String[]{this.rt.getType(), this.at.getType()};
    }

    public String[] getTypes() {
        return this.types;
    }

    public void getFreshResult(JSONArray jSONArray, long l2) {
        this.addResult(jSONArray, l2, true);
    }

    public void getToastedResult(JSONArray jSONArray, long l2) {
        this.addResult(jSONArray, l2, false);
    }

    private void addResult(JSONArray jSONArray, long l2, boolean bl) {
        HashMap<String, Constable> hashMap = new HashMap<String, Constable>();
        hashMap.put("userId", Long.valueOf(l2));
        if (bl) {
            hashMap.put("toasted", Boolean.valueOf(false));
        }
        try {
            List list = AlertToastDAO.getInstance().listByFieldValues(hashMap);
            List list2 = RemindToastDAO.getInstance().listByFieldValues(hashMap);
            list.addAll(list2);
            for (Object e2 : list) {
                jSONArray.put(((SystemToast)e2).createJSONObject());
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on check");
        }
    }

    public void deleteToast(String string, long l2) {
        this.deleteOrMake(string, l2, true);
    }

    public void makeToasted(String string, long l2) {
        this.deleteOrMake(string, l2, false);
    }

    private void deleteOrMake(String string, long l2, boolean bl) {
        try {
            ProcessToastDAO processToastDAO = ComparatorUtils.equals(string, this.rt.getType()) ? RemindToastDAO.getInstance() : AlertToastDAO.getInstance();
            if (bl) {
                processToastDAO.deleteByID(l2);
            } else {
                processToastDAO.updateToasted(l2);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public boolean needCheck(long l2) {
        return ProcessUtils.P().hasProcessTask(l2);
    }

    public void makeAllToasted(long l2) {
        this.makeAllToasted(true, l2);
        this.makeAllToasted(false, l2);
    }

    private void makeAllToasted(boolean bl, long l2) {
        ProcessToastDAO processToastDAO = null;
        processToastDAO = bl ? RemindToastDAO.getInstance() : AlertToastDAO.getInstance();
        try {
            List list = processToastDAO.listByFieldValue("userId", l2);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                processToastDAO.updateToasted(((SystemToast)list.get(i2)).getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteAll(long l2) {
        this.deleteAll(true, l2);
        this.deleteAll(false, l2);
    }

    private void deleteAll(boolean bl, long l2) {
        ProcessToastDAO processToastDAO = null;
        processToastDAO = bl ? RemindToastDAO.getInstance() : AlertToastDAO.getInstance();
        try {
            List list = processToastDAO.listByFieldValue("userId", l2);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                processToastDAO.deleteByID(((SystemToast)list.get(i2)).getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

