/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.base.fservice.FServicePrivilegeProvider;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import java.util.ArrayList;

public class ProcessOperator {
    public static final int TYPE_USER = 1;
    public static final int TYPE_ROLE = 2;
    public static final int TYPE_DATASOURCE = 3;
    public static final int ROLE_COMPANY = 1;
    public static final int ROLE_CUSTOM = 2;
    private static final int TYPE_INDEX = 0;
    private static final int DATASOURCE_INDEX = 1;
    private static final int TABLE_INDEX = 2;
    private static final int MIN_LENGTH = 2;
    private static final int MIN_SOURCE_LENGTH = 4;
    private static final int MAX_SOURCE_LENGTH = 5;
    private static final String OPERATORS_SEPARATOR = ":";
    private int type = 0;
    private int dataSource = 1;
    private String[] ids;
    private ArrayList<String> parentIDs = new ArrayList();
    private JSONObject operateJSON = new JSONObject();

    public ProcessOperator() {
    }

    public ProcessOperator(String string) {
        if (string != null) {
            String[] stringArray = string.split(OPERATORS_SEPARATOR);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2;
                int n2;
                String string2 = stringArray[i2];
                if (!StringUtils.isNotEmpty(string2) || (n2 = (stringArray2 = string2.split("##")).length) <= 2) continue;
                this.dealNodeString(stringArray2, n2, i2);
            }
        }
    }

    public ProcessOperator(String string, String string2) {
        if (string != null) {
            String[] stringArray = string.split(OPERATORS_SEPARATOR);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2;
                int n2;
                String string3 = stringArray[i2];
                if (!StringUtils.isNotEmpty(string3) || (n2 = (stringArray2 = string3.split("##")).length) <= 2) continue;
                this.dealNodeString(stringArray2, n2, i2, string2);
            }
        }
    }

    private void dealNodeString(String[] stringArray, int n2, int n3) {
        JSONArray jSONArray;
        boolean bl;
        this.type = Integer.parseInt(stringArray[0]);
        this.dataSource = Integer.parseInt(stringArray[1]);
        if (this.type == 1) {
            bl = true;
            jSONArray = ProcessUtils.P().getAllUsers(false);
        } else {
            bl = false;
            jSONArray = ProcessUtils.P().getAllRoles();
        }
        if (this.dataSource == 3) {
            this.dealIDS4Node(jSONArray, stringArray, n2, n3, bl);
        } else {
            this.ids = new String[n2 - 2];
            for (int i2 = 0; i2 < n2 - 2; ++i2) {
                this.ids[i2] = stringArray[i2 + 2];
                this.parentIDs.add(this.ids[i2]);
            }
        }
    }

    private void dealNodeString(String[] stringArray, int n2, int n3, String string) {
        JSONArray jSONArray;
        boolean bl;
        this.type = Integer.parseInt(stringArray[0]);
        this.dataSource = Integer.parseInt(stringArray[1]);
        if (this.type == 1) {
            bl = true;
            jSONArray = ProcessUtils.P().getAllUsers(false);
        } else {
            bl = false;
            jSONArray = ProcessUtils.P().getAllRoles();
        }
        if (this.dataSource == 3) {
            this.dealIDS4Node(jSONArray, stringArray, n2, n3, bl, string);
        } else {
            this.ids = new String[n2 - 2];
            for (int i2 = 0; i2 < n2 - 2; ++i2) {
                this.ids[i2] = stringArray[i2 + 2];
                this.parentIDs.add(this.ids[i2]);
            }
        }
    }

    private void dealIDS4Node(JSONArray jSONArray, String[] stringArray, int n2, int n3, boolean bl) {
        try {
            String string = stringArray[2];
            if (StringUtils.isEmpty(string)) {
                return;
            }
            TableData tableData = DatasourceManager.getInstance().getTableData(string);
            Calculator calculator = Calculator.createCalculator();
            DataModel dataModel = tableData.createDataModel(calculator, string);
            int n4 = dataModel.getRowCount();
            if (n2 == 4) {
                String string2 = stringArray[n2 - 1];
                this.dealIDS4FirstNode(n4, dataModel, string2, jSONArray, bl);
            } else if (n2 == 5) {
                String string3 = stringArray[n2 - 2];
                String string4 = stringArray[n2 - 1];
                if (n3 == 0) {
                    this.dealIDS4FirstNode(n4, dataModel, string4, jSONArray, bl);
                } else {
                    this.dealIDS4OtherNode(n4, dataModel, string3, string4, jSONArray, bl);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void dealIDS4Node(JSONArray jSONArray, String[] stringArray, int n2, int n3, boolean bl, String string) {
        try {
            String string2 = stringArray[2];
            if (StringUtils.isEmpty(string2)) {
                return;
            }
            TableData tableData = DatasourceManager.getInstance().getTableData(string2);
            Calculator calculator = Calculator.createCalculator();
            DataModel dataModel = tableData.createDataModel(calculator, string2);
            int n4 = dataModel.getRowCount();
            if (n2 == 4) {
                String string3 = stringArray[n2 - 1];
                this.dealIDS4FirstNode(n4, dataModel, string3, jSONArray, bl, string);
            } else if (n2 == 5) {
                String string4 = stringArray[n2 - 2];
                String string5 = stringArray[n2 - 1];
                if (n3 == 0) {
                    this.dealIDS4FirstNode(n4, dataModel, string5, jSONArray, bl, string);
                } else {
                    this.dealIDS4OtherNode(n4, dataModel, string4, string5, jSONArray, bl, string);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private String getNotEmptyId(DataModel dataModel, int n2, String string) {
        String string2;
        int n3 = Integer.parseInt(string);
        try {
            while (StringUtils.isEmpty(string2 = (String)dataModel.getValueAt(n2, n3))) {
                ++n3;
            }
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private void dealIDS4FirstNode(int n2, DataModel dataModel, String string, JSONArray jSONArray, boolean bl) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = this.getNotEmptyId(dataModel, i2, string);
                int n3 = jSONArray.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string2);
                    String string3 = jSONObject.getString("value");
                    if (!bl2 || this.parentIDs.contains(string3)) continue;
                    this.parentIDs.add(string3);
                    break;
                }
                this.ids = this.parentIDs.toArray(new String[this.parentIDs.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void dealIDS4OtherNode(int n2, DataModel dataModel, String string, String string2, JSONArray jSONArray, boolean bl, String string3) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = (String)dataModel.getValueAt(i2, Integer.parseInt(string2));
                String string5 = (String)dataModel.getValueAt(i2, Integer.parseInt(string2) + 1);
                int n3 = jSONArray.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string4);
                    String string6 = jSONObject.getString("value");
                    if (!bl2 || this.parentIDs.contains(string6) || !ComparatorUtils.equals(string5, string3)) continue;
                    this.parentIDs.add(string6);
                    break;
                }
                this.ids = this.parentIDs.toArray(new String[this.parentIDs.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void dealIDS4FirstNode(int n2, DataModel dataModel, String string, JSONArray jSONArray, boolean bl, String string2) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = (String)dataModel.getValueAt(i2, Integer.parseInt(string));
                String string4 = (String)dataModel.getValueAt(i2, Integer.parseInt(string + 1));
                int n3 = jSONArray.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string3);
                    String string5 = jSONObject.getString("value");
                    if (!bl2 || this.parentIDs.contains(string5) || !ComparatorUtils.equals(string4, string2)) continue;
                    this.parentIDs.add(string5);
                    break;
                }
                this.ids = this.parentIDs.toArray(new String[this.parentIDs.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void dealIDS4OtherNode(int n2, DataModel dataModel, String string, String string2, JSONArray jSONArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = (String)dataModel.getValueAt(i2, Integer.parseInt(string));
                int n3 = jSONArray.length();
                block3: for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string3);
                    String string4 = jSONObject.getString("value");
                    if (!bl2 || !this.parentIDs.contains(string4)) continue;
                    String string5 = (String)dataModel.getValueAt(i2, Integer.parseInt(string2));
                    for (int i4 = 0; i4 < n3; ++i4) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(i4);
                        boolean bl3 = this.isNeedInProcess(jSONObject2, bl, string5);
                        if (!bl3) continue;
                        JSONObject jSONObject3 = new JSONObject();
                        String string6 = jSONObject2.getString("value");
                        if (!arrayList.contains(string6)) {
                            arrayList.add(string6);
                        }
                        if (this.operateJSON.has(string6) && this.operateJSON.get(string6) != null) {
                            jSONObject3 = this.operateJSON.getJSONObject(string6);
                        }
                        jSONObject3.put(string4, ProcessTaskImpl.NOT_COMPLETE);
                        this.operateJSON.put(string6, jSONObject3);
                        continue block3;
                    }
                }
            }
            this.ids = arrayList.toArray(new String[arrayList.size()]);
            this.parentIDs.clear();
            this.parentIDs = arrayList;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private boolean isNeedInProcess(JSONObject jSONObject, boolean bl, String string) throws JSONException {
        return bl ? ComparatorUtils.equals(jSONObject.getString("value"), string) || ComparatorUtils.equals(jSONObject.getString("username"), string) || ComparatorUtils.equals(jSONObject.getString("realname"), string) : ComparatorUtils.equals(jSONObject.getString("value"), string) || ComparatorUtils.equals(jSONObject.getString("departmentname"), string) || ComparatorUtils.equals(jSONObject.getString("postname"), string);
    }

    public ProcessOperator(String string, int n2) {
        String[] stringArray;
        if (string != null && (stringArray = string.split("##")).length > 1) {
            this.type = Integer.parseInt(stringArray[0]);
            if (n2 < 0 || n2 >= stringArray.length - 1) {
                this.ids = new String[stringArray.length - 1];
                for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                    this.ids[i2] = stringArray[i2 + 1];
                }
            } else {
                this.ids = new String[]{stringArray[n2 + 1]};
            }
        }
    }

    public boolean isUser() {
        return this.type == 1;
    }

    public boolean isRole() {
        return !this.isUser();
    }

    public boolean isUseDataSource() {
        return this.dataSource == 3;
    }

    public void setOperateJSON(JSONObject jSONObject) {
        this.operateJSON = jSONObject;
    }

    public JSONObject getOperateJSON() {
        return this.operateJSON;
    }

    public String[] getIds() {
        return this.ids;
    }

    public int getOperatorCount() {
        return ArrayUtils.getLength(this.ids);
    }

    public boolean contains(long l2) {
        return this.contains(l2 + "");
    }

    public boolean contains(String string) {
        if (string != null) {
            return (this.type == 1 || this.type == 2 && string.contains("_")) && this.checkIdContain(string);
        }
        return false;
    }

    private boolean checkIdContain(String string) {
        for (String string2 : this.ids) {
            if (ComparatorUtils.equals(string, string2)) {
                return true;
            }
            String string3 = ProcessUtils.P().getUserIdByName(string2) + "";
            if (!ComparatorUtils.equals(string, string3)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnderTakeBy(long l2) {
        if (this.contains(l2)) {
            return true;
        }
        FServicePrivilegeProvider fServicePrivilegeProvider = ProcessUtils.P();
        long[] lArray = fServicePrivilegeProvider.getCompanyRolesByUserId(l2);
        if (this.checkRolesUnderTake(lArray, true)) {
            return true;
        }
        long[] lArray2 = fServicePrivilegeProvider.getCustomRolesByUserId(l2);
        return this.checkRolesUnderTake(lArray2, false);
    }

    public boolean checkRolesUnderTake(long[] lArray, boolean bl) {
        String string = (bl ? 1 : 2) + "";
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (!this.contains(string + "_" + lArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static int getOperatorType(String string) {
        if (string != null) {
            if (string.contains("_")) {
                return 2;
            }
            return 1;
        }
        return -1;
    }

    public String toString() {
        String string = this.type + "##" + this.dataSource;
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            string = string + "##" + this.ids[i2];
        }
        return string;
    }

    public String toNameString() {
        String string = "";
        if (this.type == 1) {
            string = string + Inter.getLocText("User") + OPERATORS_SEPARATOR;
            for (int i2 = 0; i2 < this.ids.length; ++i2) {
                string = string + ProcessUtils.getUserName(ProcessUtils.getIdFromStr(this.ids[i2]));
                if (i2 >= this.ids.length - 1) continue;
                string = string + ",";
            }
        } else {
            string = string + Inter.getLocText("Role") + OPERATORS_SEPARATOR;
            for (int i3 = 0; i3 < this.ids.length; ++i3) {
                string = string + ProcessOperator.getRoleName(this.ids[i3]);
                if (i3 >= this.ids.length - 1) continue;
                string = string + ",";
            }
        }
        return string;
    }

    public JSONArray toJSONArray(JSONObject jSONObject, boolean bl, long l2, JSONArray jSONArray) {
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            String string = this.ids[i2];
            JSONObject jSONObject2 = ProcessOperator.getOperatorJSON(string);
            if (bl) {
                if (!jSONObject.has(this.ids[i2]) && this.isUseDataSource()) continue;
                jSONArray.put(jSONObject2);
                continue;
            }
            long[] lArray = ProcessOperator.getAllUserId(string);
            if (!ArrayUtils.contains(lArray, l2)) continue;
            jSONArray.put(jSONObject2);
            return jSONArray;
        }
        return jSONArray;
    }

    public long[] getAllUserId() {
        if (this.type == 1) {
            long[] lArray = new long[this.ids.length];
            for (int i2 = 0; i2 < this.ids.length; ++i2) {
                lArray[i2] = ProcessUtils.getIdFromStr(this.ids[i2]);
            }
            return lArray;
        }
        long[] lArray = new long[]{};
        for (int i3 = 0; i3 < this.ids.length; ++i3) {
            lArray = ArrayUtils.addAll(lArray, ProcessOperator.getRoleUserId(this.ids[i3]));
        }
        return ProcessUtils.unique(lArray);
    }

    public static long[] getAllUserId(String string) {
        if (string == null) {
            return new long[0];
        }
        if (string.contains("_")) {
            return ProcessOperator.getRoleUserId(string);
        }
        return new long[]{ProcessUtils.getIdFromStr(string)};
    }

    public static long[] getRoleUserId(String string) {
        if (string == null || !string.contains("_")) {
            return new long[0];
        }
        long[] lArray = new long[]{};
        String[] stringArray = string.split("_");
        if (ProcessOperator.isCompanyRole(string)) {
            lArray = ArrayUtils.addAll(lArray, ProcessUtils.P().getUsersByCompanyRoleId(ProcessUtils.getIdFromStr(stringArray[1])));
        } else if (ProcessOperator.isCustomRole(string)) {
            lArray = ArrayUtils.addAll(lArray, ProcessUtils.P().getUsersByCustomRoleId(ProcessUtils.getIdFromStr(stringArray[1])));
        }
        return lArray;
    }

    public static JSONObject getOperatorJSON(String string) {
        JSONObject jSONObject = new JSONObject();
        if (string == null) {
            return jSONObject;
        }
        try {
            String string2 = "";
            if (string.contains("_")) {
                string2 = ProcessOperator.getRoleName(string);
            } else {
                long l2 = ProcessUtils.getIdFromStr(string);
                string2 = ProcessUtils.getUserName(l2);
            }
            jSONObject.put("value", string);
            jSONObject.put("text", string2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return jSONObject;
    }

    public static boolean isCompanyRole(String string) {
        if (string == null) {
            return false;
        }
        if (!string.contains("_")) {
            return false;
        }
        return Integer.parseInt(string.split("_")[0]) == 1;
    }

    public static boolean isCustomRole(String string) {
        if (string == null) {
            return false;
        }
        if (!string.contains("_")) {
            return false;
        }
        return Integer.parseInt(string.split("_")[0]) == 2;
    }

    public static String getOperatorName(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains("_")) {
            return ProcessUtils.getUserName(ProcessUtils.getIdFromStr(string));
        }
        return ProcessOperator.getRoleName(string);
    }

    public static String getRoleName(String string) {
        String[] stringArray = string.split("_");
        long l2 = ProcessUtils.getIdFromStr(stringArray[stringArray.length - 1]);
        if (ProcessOperator.isCompanyRole(string)) {
            return ProcessUtils.getCompanyRoleName(l2);
        }
        return ProcessUtils.getCustomRoleName(l2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProcessOperator)) {
            return false;
        }
        ProcessOperator processOperator = (ProcessOperator)object;
        if (processOperator.type != this.type) {
            return false;
        }
        if (processOperator.ids == null || this.ids == null) {
            return false;
        }
        if (processOperator.ids.length != this.ids.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            if (!ComparatorUtils.equals(processOperator.ids[i2], this.ids[i2])) continue;
            return false;
        }
        return true;
    }
}

