/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.web.core.process.reportprocess.ProcessOperator;
import com.fr.web.core.process.reportprocess.ReportControl;

public class ProcessNode {
    public static final String PROCESS_ID = "processId";
    public static final String AUTHORITY = "authority";
    public static final String REPORT_CONTROL = "reportControl";
    public static final String NEED_ALL_COMPLETE = "needAllComplete";
    public static final String ALERT_CONTROL = "alertControl";
    public static final String NEED_OFFLINE_REPORT = "needOfflineReport";
    private long id = -1L;
    private long processId = -1L;
    private String name;
    private String describe;
    private String authority;
    private String reportControl;
    private boolean needAllComplete;
    private String alertControl;
    private boolean needOfflineReport;
    public static final ObjectTableMapper TABLE_MAPPER = new ObjectTableMapper(ProcessNode.class, new Table("FR_REPORT_PROCESS_NODE"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", -5, new ColumnSize(8)), new CommonFieldColumnMapper("processId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("name", 12, new ColumnSize(50), false), new CommonFieldColumnMapper("describe", 12, new ColumnSize(1024), true), new CommonFieldColumnMapper("authority", 12, new ColumnSize(255), false), new CommonFieldColumnMapper("reportControl", 12, new ColumnSize(1024), false), new CommonFieldColumnMapper("needAllComplete", 16, new ColumnSize(1), true), new CommonFieldColumnMapper("alertControl", 12, new ColumnSize(50), true), new CommonFieldColumnMapper("needOfflineReport", 16, new ColumnSize(1), true)}, (String[][])new String[][]{{"id"}}, null);

    public ProcessNode() {
    }

    public ProcessNode(JSONObject jSONObject) {
        this.parseJSON(jSONObject);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long l2) {
        this.processId = l2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String string) {
        this.describe = string;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String string) {
        this.authority = string;
    }

    public String getReportControl() {
        return this.reportControl;
    }

    public void setReportControl(String string) {
        this.reportControl = string;
    }

    public boolean isNeedAllComplete() {
        return this.needAllComplete;
    }

    public void setNeedAllComplete(boolean bl) {
        this.needAllComplete = bl;
    }

    public String getAlertControl() {
        return this.alertControl;
    }

    public void setAlertControl(String string) {
        this.alertControl = string;
    }

    public boolean isNeedOfflineReport() {
        return this.needOfflineReport;
    }

    public void setNeedOfflineReport(boolean bl) {
        this.needOfflineReport = bl;
    }

    public JSONObject createJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.id);
        jSONObject.put("name", this.name);
        jSONObject.put("describe", this.describe);
        jSONObject.put(AUTHORITY, this.authority);
        jSONObject.put(REPORT_CONTROL, this.detailedReportControl());
        jSONObject.put(ALERT_CONTROL, this.alertControl);
        jSONObject.put(NEED_ALL_COMPLETE, this.needAllComplete);
        jSONObject.put(NEED_OFFLINE_REPORT, this.needOfflineReport);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) {
        if (jSONObject.has("name")) {
            this.name = jSONObject.optString("name");
        }
        if (jSONObject.has("describe")) {
            this.describe = jSONObject.optString("describe");
        }
        if (jSONObject.has(AUTHORITY)) {
            this.authority = jSONObject.optString(AUTHORITY);
        }
        if (jSONObject.has(REPORT_CONTROL)) {
            this.reportControl = jSONObject.optString(REPORT_CONTROL);
        }
        if (jSONObject.has(ALERT_CONTROL)) {
            this.alertControl = jSONObject.optString(ALERT_CONTROL);
        }
        if (jSONObject.has(NEED_ALL_COMPLETE)) {
            this.needAllComplete = jSONObject.optBoolean(NEED_ALL_COMPLETE);
        }
        if (jSONObject.has(NEED_OFFLINE_REPORT)) {
            this.needOfflineReport = jSONObject.optBoolean(NEED_OFFLINE_REPORT);
        }
    }

    private JSONArray detailedReportControl() throws JSONException {
        JSONArray jSONArray = new JSONArray(this.reportControl);
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            String string = jSONObject.optString("operator");
            ProcessOperator processOperator = new ProcessOperator(string);
            jSONObject.put("operatorName", processOperator.toNameString());
        }
        return jSONArray;
    }

    public long[] getAllRelatedUsers() {
        long[] lArray = new long[]{};
        String string = this.reportControl;
        try {
            JSONArray jSONArray = new JSONArray(string);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                ProcessOperator processOperator = new ProcessOperator(jSONObject.optString("operator"));
                lArray = ArrayUtils.addAll(lArray, processOperator.getAllUserId());
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return lArray;
    }

    public long[] getAllRelatedUsers(String string) {
        long[] lArray = new long[]{};
        String string2 = this.reportControl;
        try {
            JSONArray jSONArray = new JSONArray(string2);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                ProcessOperator processOperator = new ProcessOperator(jSONObject.optString("operator"), string);
                lArray = ArrayUtils.addAll(lArray, processOperator.getAllUserId());
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return lArray;
    }

    public ProcessOperator[] getAllProcessOperator() {
        String string = this.reportControl;
        try {
            JSONArray jSONArray = new JSONArray(string);
            ProcessOperator[] processOperatorArray = new ProcessOperator[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                ProcessOperator processOperator;
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                processOperatorArray[i2] = processOperator = new ProcessOperator(jSONObject.optString("operator"));
            }
            return processOperatorArray;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return new ProcessOperator[0];
        }
    }

    public JSONArray getAllOperator() {
        JSONArray jSONArray = new JSONArray();
        try {
            JSONArray jSONArray2 = new JSONArray(this.reportControl);
            for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                ReportControl reportControl = new ReportControl(jSONArray2.getJSONObject(i2));
                ProcessOperator processOperator = reportControl.getOperator();
                String[] stringArray = processOperator.getIds();
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    jSONArray.put(ProcessOperator.getOperatorJSON(stringArray[i3]));
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return jSONArray;
    }

    public Parameter[] getParameters(int n2) {
        try {
            JSONArray jSONArray = new JSONArray(this.reportControl);
            String string = jSONArray.getString(n2);
            ReportControl reportControl = new ReportControl(string);
            return reportControl.getParameters().toArray();
        }
        catch (Exception exception) {
            return new Parameter[0];
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

