/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.Base64;
import com.fr.base.GraphHelper;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.page.ClippedPageProvider;
import com.fr.page.JSONWriteContent;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.FloatElement;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.core.Converter;
import com.fr.stable.web.Repository;
import com.fr.web.core.JSONWriter;
import com.fr.web.core.cwriter.CellJSONWriter;
import com.fr.web.core.reportcase.WebPageReportCase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class JSONConverter
implements Converter,
JSONWriteContent {
    private JSONObject parent;
    private ReportPageProvider reportPage;
    private CellJSONWriter cellJSONWriter;
    private Repository repo;
    private boolean showHeaderAndFooter;

    public JSONConverter(ReportPageProvider reportPageProvider, CellJSONWriter cellJSONWriter, Repository repository) {
        this.reportPage = reportPageProvider;
        this.cellJSONWriter = cellJSONWriter;
        this.repo = repository;
    }

    public void setParent(JSONObject jSONObject) {
        this.parent = jSONObject;
    }

    public void convert() {
        try {
            this.toJSON();
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    private void toJSON() throws JSONException {
        ReportSettingsProvider reportSettingsProvider = this.reportPage.getReportSettings();
        int n2 = this.repo.getResolution();
        int n3 = this.reportPage.getWebPageWidth();
        int n4 = this.reportPage.getWebPageHeight();
        int n5 = this.reportPage.getMarginTop().toPixI(n2);
        int n6 = this.reportPage.getMarginLeft().toPixI(n2);
        int n7 = this.reportPage.getMarginBottom().toPixI(n2);
        int n8 = this.reportPage.getMarginRight().toPixI(n2);
        int n9 = n5 + (this.showHeaderAndFooter ? reportSettingsProvider.getHeaderHeight().toPixI(n2) : 0);
        this.writeHeaderToJSON(reportSettingsProvider, n5, n6, n8, n3);
        double d2 = n3 - n6 - n8;
        double d3 = (double)(n4 - n5 - n7) - reportSettingsProvider.getHeaderHeight().toPixD(n2) + reportSettingsProvider.getFooterHeight().toPixD(n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n6, n9, d2, d3);
        this.writeReportPageContent(double_);
        this.writeFooterToJSON(reportSettingsProvider, n6, n7, n8, n3, n4);
    }

    private void writeReportPageContent(Rectangle2D rectangle2D) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        this.parent.put("content", jSONObject);
        jSONObject.put("background", JSONUtils.putRectangle(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()).put("image", Base64.encode(this.createBackgroundImage(), "png")));
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("pages", jSONArray);
        ClippedPageProvider[] clippedPageProviderArray = this.reportPage.getPages();
        for (int i2 = 0; i2 < clippedPageProviderArray.length; ++i2) {
            ClippedPageProvider clippedPageProvider = clippedPageProviderArray[i2];
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put(jSONObject2);
            clippedPageProvider.writeJSON(this, jSONObject2, this.repo);
        }
    }

    private BufferedImage createBackgroundImage() {
        return null;
    }

    private void writeHeaderToJSON(ReportSettingsProvider reportSettingsProvider, int n2, int n3, int n4, int n5) throws JSONException {
        Rectangle2D.Double double_;
        ReportHFProvider reportHFProvider = this.reportPage.getHeader();
        if (reportHFProvider != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n3, n2, n5 - n3 - n4, reportSettingsProvider.getHeaderHeight().toPixD(this.repo.getResolution())))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.writeReportHF(this.parent, "header", false, reportHFProvider, double_, this.reportPage, this.repo);
        }
    }

    private void writeFooterToJSON(ReportSettingsProvider reportSettingsProvider, int n2, int n3, int n4, int n5, int n6) throws JSONException {
        Rectangle2D.Double double_;
        ReportHFProvider reportHFProvider = this.reportPage.getFooter();
        if (reportHFProvider != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n2, (double)(n6 - n3) - reportSettingsProvider.getFooterHeight().toPixD(this.repo.getResolution()), n5 - n2 - n4, reportSettingsProvider.getFooterHeight().toPixD(this.repo.getResolution())))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.writeReportHF(this.parent, "footer", false, reportHFProvider, double_, this.reportPage, this.repo);
        }
    }

    private void writeReportHF(JSONObject jSONObject, String string, boolean bl, ReportHFProvider reportHFProvider, Rectangle2D rectangle2D, ReportPageProvider reportPageProvider, Repository repository) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject.put(string, jSONObject2);
        JSONUtils.putRectangle(jSONObject2, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.setPaint(Color.white);
        GraphHelper.fill(graphics2D, double_);
        reportHFProvider.paint(graphics2D, double_, (int)((RectangularShape)double_).getWidth(), reportPageProvider.getCurrentPageNumber(), reportPageProvider.getTotalPages(), reportPageProvider.getFirstPage(), false, repository.getResolution());
        bufferedImage.flush();
        graphics2D.dispose();
        jSONObject2.put("image", Base64.encode(bufferedImage, "png"));
    }

    public void writeContent(JSONObject jSONObject, ClippedPageProvider clippedPageProvider, Repository repository) throws JSONException {
        jSONObject.put("cells", this.createJSONWriter().writeReportToJSON(new WebPageReportCase(clippedPageProvider), 0, this.cellJSONWriter, repository));
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("floats", jSONArray);
        Iterator iterator = clippedPageProvider.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            jSONArray.put(this.writeFloatElement(floatElement));
        }
    }

    protected JSONWriter createJSONWriter() {
        return new JSONWriter();
    }

    private JSONObject writeFloatElement(FloatElement floatElement) {
        return new JSONObject();
    }
}

