/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.Margin;
import com.fr.base.Style;
import com.fr.base.chart.BaseChartPainter;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.page.ClippedPageProvider;
import com.fr.page.HtmlWriteContent;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.FloatElement;
import com.fr.report.core.PaintUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.core.Converter;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.unit.FU;
import com.fr.stable.web.Repository;
import com.fr.web.BaseHTMLWriterUtils;
import com.fr.web.Browser;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.chwriter.CellHtmlWriter;
import com.fr.web.core.reportcase.WebPageReportCase;
import com.fr.web.core.utils.ReportHTMLWriterUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class HTMLConverter
implements Converter,
HtmlWriteContent {
    protected ReportPageProvider reportPage;
    protected Tag resTag;
    protected Repository repo;
    protected ColumnRow frozenColumnRow;
    private CellHtmlWriter cellHtmlWriter;
    private boolean showHeaderAndFooter;

    public HTMLConverter(ReportPageProvider reportPageProvider, CellHtmlWriter cellHtmlWriter, Repository repository) {
        this.reportPage = reportPageProvider;
        this.cellHtmlWriter = cellHtmlWriter;
        this.repo = repository;
    }

    public HTMLConverter(ReportPageProvider reportPageProvider, CellHtmlWriter cellHtmlWriter, Repository repository, Tag tag, ColumnRow columnRow, boolean bl) {
        this.reportPage = reportPageProvider;
        this.cellHtmlWriter = cellHtmlWriter;
        this.repo = repository;
        this.resTag = tag;
        this.frozenColumnRow = columnRow;
        this.showHeaderAndFooter = bl;
    }

    public void setFrozenColumnRow(ColumnRow columnRow) {
        this.frozenColumnRow = columnRow;
    }

    public void setParentTag(Tag tag) {
        this.resTag = tag;
    }

    public void setShowHeaderAndFooter(boolean bl) {
        this.showHeaderAndFooter = bl;
    }

    public void convert() {
        this.toTag();
    }

    private void toTag() {
        ReportSettingsProvider reportSettingsProvider = this.reportPage.getReportSettings();
        int n2 = this.repo.getResolution();
        int n3 = this.reportPage.getWebPageWidth();
        int n4 = this.reportPage.getWebPageHeight();
        int n5 = this.reportPage.getMarginTop().toPixI(n2);
        int n6 = this.reportPage.getMarginLeft().toPixI(n2);
        int n7 = this.reportPage.getMarginBottom().toPixI(n2);
        int n8 = this.reportPage.getMarginRight().toPixI(n2);
        int n9 = n5 + (this.showHeaderAndFooter ? reportSettingsProvider.getHeaderHeight().toPixI(n2) : 0);
        if (this.showHeaderAndFooter && !ColumnRow.validate(this.frozenColumnRow)) {
            this.writeHeaderToHtml(reportSettingsProvider, n5, n6, n8, n3);
        }
        double d2 = n3 - n6 - n8;
        double d3 = (double)(n4 - n5 - n7) - reportSettingsProvider.getHeaderHeight().toPixD(n2) + reportSettingsProvider.getFooterHeight().toPixD(n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n6, n9, d2, d3);
        this.writeReportPageContent(this.resTag, double_);
        if (this.showHeaderAndFooter && !ColumnRow.validate(this.frozenColumnRow)) {
            this.writeFooterToHtml(reportSettingsProvider, n6, n7, n8, n3, n4);
        }
    }

    private void writeHeaderToHtml(ReportSettingsProvider reportSettingsProvider, int n2, int n3, int n4, int n5) {
        Rectangle2D.Double double_;
        ReportHFProvider reportHFProvider = this.reportPage.getHeader();
        if (reportHFProvider != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n3, n2, n5 - n3 - n4, reportSettingsProvider.getHeaderHeight().toPixD(this.repo.getResolution())))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.writeReportHF(this.resTag, "HF-header", ColumnRow.validate(this.frozenColumnRow), reportHFProvider, double_, this.reportPage, this.repo);
        }
    }

    private void writeFooterToHtml(ReportSettingsProvider reportSettingsProvider, int n2, int n3, int n4, int n5, int n6) {
        Rectangle2D.Double double_;
        ReportHFProvider reportHFProvider = this.reportPage.getFooter();
        if (reportHFProvider != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n2, (double)(n6 - n3) - reportSettingsProvider.getFooterHeight().toPixD(this.repo.getResolution()), n5 - n2 - n4, reportSettingsProvider.getFooterHeight().toPixD(this.repo.getResolution())))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.writeReportHF(this.resTag, "HF-footer", ColumnRow.validate(this.frozenColumnRow), reportHFProvider, double_, this.reportPage, this.repo);
        }
    }

    private void writeReportHF(Tag tag, String string, boolean bl, ReportHFProvider reportHFProvider, Rectangle2D rectangle2D, ReportPageProvider reportPageProvider, Repository repository) {
        Tag tag2 = new Tag("div").cls(string);
        tag.sub(tag2);
        tag2.css("overflow", "hidden");
        tag2.css("position", "absolute");
        if (!bl) {
            tag2.css("left", (int)rectangle2D.getX() + "px");
            tag2.css("top", (int)rectangle2D.getY() + "px");
        }
        tag2.css("width", (int)rectangle2D.getWidth() + "px");
        tag2.css("height", (int)rectangle2D.getHeight() + "px");
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.setPaint(Color.white);
        GraphHelper.fill(graphics2D, double_);
        reportHFProvider.paint(graphics2D, double_, (int)((RectangularShape)double_).getWidth(), reportPageProvider.getCurrentPageNumber(), reportPageProvider.getTotalPages(), reportPageProvider.getFirstPage(), false, repository.getResolution());
        bufferedImage.flush();
        graphics2D.dispose();
        ReportHTMLWriterUtils.writeTagBackground(tag2, bufferedImage, repository);
    }

    private void writeReportPageContent(Tag tag, Rectangle2D rectangle2D) {
        Tag tag2 = this.writeBackground(tag, rectangle2D);
        ClippedPageProvider[] clippedPageProviderArray = this.reportPage.getPages();
        for (int i2 = 0; i2 < clippedPageProviderArray.length; ++i2) {
            ClippedPageProvider clippedPageProvider = clippedPageProviderArray[i2];
            clippedPageProvider.writeHTML(this, tag2, rectangle2D, this.repo);
        }
    }

    private Tag writeBackground(Tag tag, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        int n2 = this.reportPage.getContentWidth();
        int n3 = this.reportPage.getContentHeight();
        double d2 = this.reportPage.getWebPageWidth();
        double d3 = this.reportPage.getWebPageHeight();
        double d4 = 0.0;
        double d5 = 0.0;
        ReportSettingsProvider reportSettingsProvider = this.reportPage.getReportSettings();
        PaperSettingProvider paperSettingProvider = reportSettingsProvider.getPaperSetting();
        if (paperSettingProvider != null) {
            if (reportSettingsProvider.isHorizontalCenterOnPage()) {
                d4 = (rectangle2D.getWidth() - (double)n2) / 2.0;
            }
            if (reportSettingsProvider.isVerticalCenterOnPage()) {
                d5 = (rectangle2D.getHeight() - (double)n3) / 2.0;
            }
            int n4 = 96;
            cloneable = paperSettingProvider.getMargin();
            double d6 = ((Margin)cloneable).getTop().add(((Margin)cloneable).getBottom()).add(reportSettingsProvider.getHeaderHeight()).add(reportSettingsProvider.getFooterHeight()).toPixD(n4);
            double d7 = ((Margin)cloneable).getLeft().add(((Margin)cloneable).getRight()).toPixI(n4);
            d2 -= d7;
            d3 -= d6;
        }
        Tag tag2 = new Tag("div").cls("report-background").css("position", "absolute").css("width", d2 + "px").css("height", d3 + "px");
        if (this.repo.getBrowser().shouldWriteResizableFeature() && !this.repo.getBrowser().supportBoxModel()) {
            tag2.css("z-index", "-1");
        }
        cloneable = new Tag("div").cls("fr-page-content").css("position", "absolute").css("width", d2 + "px").css("height", d3 + "px").css("left", d4 + rectangle2D.getX() + "px").css("top", d5 + rectangle2D.getY() + "px");
        ((Tag)cloneable).attr("id", "fr-page-content");
        if (((Browser)this.repo.getBrowser()).isLowIEVersion()) {
            tag2.css("z-index", "-1").css("left", "0px").css("top", "0px");
            tag.sub((Html)cloneable);
            ((Tag)cloneable).sub(tag2);
        } else {
            tag.sub(tag2);
            tag2.css("left", d4 + rectangle2D.getX() + "px").css("top", d5 + rectangle2D.getY() + "px");
        }
        if (reportSettingsProvider.getBackground() != null) {
            BaseHTMLWriterUtils.writeBackground(tag2, reportSettingsProvider.getBackground(), new Dimension((int)d2, (int)d3), false, this.repo);
        }
        if (((Browser)this.repo.getBrowser()).isLowIEVersion()) {
            return cloneable;
        }
        return tag2;
    }

    private Tag prepareWriteContent(Tag tag, ClippedPageProvider clippedPageProvider, Repository repository) {
        int n2 = clippedPageProvider.getContentWidth();
        int n3 = clippedPageProvider.getContentHeight();
        int n4 = clippedPageProvider.getOffsetX().toPixI(repository.getResolution());
        int n5 = clippedPageProvider.getOffsetY().toPixI(repository.getResolution());
        ++n2;
        ++n3;
        Tag tag2 = new Tag("div").cls("page-block");
        tag.sub(tag2);
        tag2.css("position", "absolute");
        tag2.css("left", n4 + "px");
        tag2.css("top", n5 + "px");
        tag2.css("width", n2 + "px");
        tag2.css("height", n3 + "px");
        return tag2;
    }

    public void writeChartContent(Tag tag, BaseChartPainter baseChartPainter, ClippedPageProvider clippedPageProvider, Dimension dimension) {
        Tag tag2 = this.prepareWriteContent(tag, clippedPageProvider, this.repo);
        Tag tag3 = new Tag("td");
        PaintUtils.paintTag(baseChartPainter, this.repo, dimension.width, dimension.height, null, tag3);
        tag2.sub(new Tag("table").cls("x-chart-table").sub(new Tag("tr").sub(tag3)));
    }

    public void writeContent(Tag tag, ClippedPageProvider clippedPageProvider, Repository repository) {
        Tag tag2 = this.prepareWriteContent(tag, clippedPageProvider, repository);
        HTMLWriter hTMLWriter = this.createHTMLWriterCase();
        if (ColumnRow.validate(this.frozenColumnRow)) {
            this.writeFrozenWhenSupport(hTMLWriter, tag2, clippedPageProvider);
        } else {
            this.writeContentWhenNotFrozen(hTMLWriter, tag2, clippedPageProvider);
        }
    }

    private void writeFrozenWhenSupport(HTMLWriter hTMLWriter, Tag tag, ClippedPageProvider clippedPageProvider) {
        tag.cls("frozen-page");
        Tag[] tagArray = hTMLWriter.writeFrozenContentWithCenterCornerNW(tag, new WebPageReportCase(clippedPageProvider), this.frozenColumnRow, 0, this.cellHtmlWriter, this.repo);
        Tag tag2 = tagArray[0];
        Tag tag3 = tagArray[1];
        Iterator iterator = clippedPageProvider.floatIterator();
        while (iterator.hasNext()) {
            Tag tag4;
            int n2;
            FloatElement floatElement = (FloatElement)iterator.next();
            int n3 = 0;
            int n4 = 0;
            n3 = Math.max(floatElement.getLeftDistance_inClippedPage().toPixI(this.repo.getResolution()), 1);
            n4 = Math.max(floatElement.getTopDistance_inClippedPage().toPixI(this.repo.getResolution()), 1);
            int n5 = this.frozenColumnRow.getColumn();
            int n6 = this.frozenColumnRow.getRow();
            int n7 = 0;
            int n8 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                n7 += clippedPageProvider.getColumnWidthDynamicPixList().get(n2);
            }
            for (n2 = 0; n2 < n6; ++n2) {
                n8 += clippedPageProvider.getRowHeightDynamicPixList().get(n2);
            }
            n2 = n3 + floatElement.getWidth().toPixI(this.repo.getResolution()) - n7;
            int n9 = n4 + floatElement.getHeight().toPixI(this.repo.getResolution()) - n8;
            int n10 = n3 - n7;
            int n11 = n4 - n8;
            if (floatElement.getValue() instanceof BaseChartPainter) {
                tag4 = n2 > 0 && n9 > 0 ? tag3 : tag;
                this.writeFloatElementTag(floatElement, tag4, n3, n4, this.repo.getResolution());
                continue;
            }
            int n12 = floatElement.getWidth().toPixI(this.repo.getResolution());
            int n13 = floatElement.getHeight().toPixI(this.repo.getResolution());
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n12, n13, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            Style.paintBackground(graphics2D, floatElement.getStyle(), n12, n13);
            PaintUtils.paintFloatElement(graphics2D, floatElement, n12 - 1, n13 - 1, this.repo.getResolution());
            Style.paintBorder(graphics2D, floatElement.getStyle(), n12, n13);
            bufferedImage.flush();
            graphics2D.dispose();
            if (n2 > 0 && n9 > 0) {
                this.writeFloatElement(floatElement, n10, n11, bufferedImage, tag, n3, n4, tag2, tag3, n8, n7);
                continue;
            }
            tag4 = tag;
            this.writeFloatElementTag(floatElement, tag4, n3, n4, this.repo.getResolution());
        }
    }

    private void writeFloatElement(FloatElement floatElement, int n2, int n3, BufferedImage bufferedImage, Tag tag, int n4, int n5, Tag tag2, Tag tag3, int n6, int n7) {
        int n8 = floatElement.getWidth().toPixI(this.repo.getResolution());
        int n9 = floatElement.getHeight().toPixI(this.repo.getResolution());
        FU fU = floatElement.getWidth();
        FU fU2 = floatElement.getHeight();
        if (n2 < 0 && n3 < 0) {
            BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, n8, -n3);
            BufferedImage bufferedImage3 = bufferedImage.getSubimage(0, -n3, -n2, n9 + n3);
            BufferedImage bufferedImage4 = bufferedImage.getSubimage(-n2, -n3, n8 + n2, n9 + n3);
            Tag tag4 = tag;
            this.writeFloatEl(floatElement, bufferedImage2, fU, FU.valueOfPix(-n3, this.repo.getResolution()), tag4, n4, n5, this.repo.getResolution());
            tag4 = tag2;
            this.writeFloatEl(floatElement, bufferedImage3, FU.valueOfPix(-n2, this.repo.getResolution()), FU.valueOfPix(n9 + n3, this.repo.getResolution()), tag4, n4, 0, this.repo.getResolution());
            tag4 = tag3;
            this.writeFloatEl(floatElement, bufferedImage4, FU.valueOfPix(n8 + n2, this.repo.getResolution()), FU.valueOfPix(n9 + n3, this.repo.getResolution()), tag4, 0, 0, this.repo.getResolution());
        } else if (n2 < 0 && n3 > 0) {
            BufferedImage bufferedImage5 = bufferedImage.getSubimage(0, 0, -n2, n9);
            BufferedImage bufferedImage6 = bufferedImage.getSubimage(-n2, 0, n8 + n2, n9);
            Tag tag5 = tag;
            this.writeFloatEl(floatElement, bufferedImage5, FU.valueOfPix(-n2, this.repo.getResolution()), fU2, tag5, n4, n5, this.repo.getResolution());
            tag5 = tag3;
            this.writeFloatEl(floatElement, bufferedImage6, FU.valueOfPix(n8 + n2, this.repo.getResolution()), fU2, tag5, 0, n5 - n6, this.repo.getResolution());
        } else if (n2 > 0 && n3 < 0) {
            BufferedImage bufferedImage7 = bufferedImage.getSubimage(0, 0, n8, -n3);
            BufferedImage bufferedImage8 = bufferedImage.getSubimage(0, -n3, n8, n9 + n3);
            Tag tag6 = tag;
            this.writeFloatEl(floatElement, bufferedImage7, fU, FU.valueOfPix(-n3, this.repo.getResolution()), tag6, n4, n5, this.repo.getResolution());
            tag6 = tag3;
            this.writeFloatEl(floatElement, bufferedImage8, fU, FU.valueOfPix(n9 + n3, this.repo.getResolution()), tag6, n4 - n7, 0, this.repo.getResolution());
        } else {
            Tag tag7 = tag3;
            this.writeFrozenFloatElementTag(floatElement, tag7, n4, n5, this.repo.getResolution());
        }
    }

    private void writeFloatEl(FloatElement floatElement, BufferedImage bufferedImage, FU fU, FU fU2, Tag tag, int n2, int n3, int n4) {
        floatElement.setValue(bufferedImage);
        floatElement.setWidth(fU);
        floatElement.setHeight(fU2);
        this.writeFrozenFloatElementTag(floatElement, tag, n2, n3, n4);
    }

    private void writeFrozenFloatElementTag(FloatElement floatElement, Tag tag, int n2, int n3, int n4) {
        Tag tag2 = null;
        NameJavaScriptGroup nameJavaScriptGroup = floatElement.getNameHyperlinkGroup();
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            tag2 = new Tag("span");
            String string = "{}";
            try {
                string = BaseUtils.writeJSLinkContent(nameJavaScriptGroup, this.repo);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
            tag2.attr("onclick", "FR.doHyperlink(event ||window.event," + string + ")");
            tag2.css("cursor", "pointer");
        }
        int n5 = floatElement.getWidth().toPixI(n4);
        int n6 = floatElement.getHeight().toPixI(n4);
        Tag tag3 = new Tag("div");
        if (tag2 == null) {
            tag2 = tag3;
        } else {
            tag2.sub(tag3);
        }
        tag2.attr("name", floatElement.getName());
        tag.sub(tag2);
        tag3.css("overflow", "hidden");
        tag3.css("position", "absolute");
        tag3.css("left", n2 + "px");
        tag3.css("top", n3 + "px");
        tag3.css("width", n5 + "px");
        tag3.css("height", n6 + "px");
        tag3.sub(floatElement.toFrozenTag(this.repo));
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            tag3.css("z-index", "20");
        }
    }

    private void writeContentWhenNotFrozen(HTMLWriter hTMLWriter, Tag tag, ClippedPageProvider clippedPageProvider) {
        tag.sub(hTMLWriter.writeReportToHtml(new WebPageReportCase(clippedPageProvider), 0, this.cellHtmlWriter, this.repo));
        Iterator iterator = clippedPageProvider.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            int n2 = floatElement.getLeftDistance_inClippedPage().toPixI(this.repo.getResolution());
            int n3 = floatElement.getTopDistance_inClippedPage().toPixI(this.repo.getResolution());
            this.writeFloatElementTag(floatElement, tag, n2, n3, this.repo.getResolution());
        }
    }

    private void writeFloatElementTag(FloatElement floatElement, Tag tag, int n2, int n3, int n4) {
        Tag tag2 = null;
        NameJavaScriptGroup nameJavaScriptGroup = floatElement.getNameHyperlinkGroup();
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            tag2 = new Tag("span");
            String string = "{}";
            try {
                string = BaseUtils.writeJSLinkContent(nameJavaScriptGroup, this.repo);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
            tag2.attr("onclick", "FR.doHyperlink(event ||window.event," + string + ")");
            tag2.css("cursor", "pointer");
        }
        int n5 = floatElement.getWidth().toPixI(n4);
        int n6 = floatElement.getHeight().toPixI(n4);
        Tag tag3 = new Tag("div");
        if (tag2 == null) {
            tag2 = tag3;
        } else {
            tag2.sub(tag3);
        }
        tag2.attr("name", floatElement.getName());
        tag.sub(tag2);
        tag3.css("overflow", "hidden");
        tag3.css("position", "absolute");
        tag3.css("left", n2 + "px");
        tag3.css("top", n3 + "px");
        tag3.css("width", n5 + "px");
        tag3.css("height", n6 + "px");
        tag3.sub(floatElement.toTag(this.repo));
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            tag3.css("z-index", "20");
        }
    }

    private HTMLWriter createHTMLWriterCase() {
        return HTMLWriter.getInstance();
    }
}

