/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.console;

import com.fr.data.AbstractParameterTableData;
import com.fr.general.VT4FR;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class FunctionListTableData
extends AbstractParameterTableData
implements DataModel {
    private FunctionAndSupport[] datas;
    private String[] names = new String[]{"name", "support", "value"};

    private static FunctionAndSupport as(VT4FR.FUNC fUNC) {
        FunctionAndSupport functionAndSupport = new FunctionAndSupport();
        functionAndSupport.name = fUNC.toString();
        functionAndSupport.support = fUNC.support();
        functionAndSupport.v = fUNC.marker();
        return functionAndSupport;
    }

    public FunctionListTableData() {
        ArrayList<FunctionAndSupport> arrayList = new ArrayList<FunctionAndSupport>();
        Iterator<VT4FR.FUNC> iterator = VT4FR.getAllFunctionIterator();
        while (iterator.hasNext()) {
            arrayList.add(FunctionListTableData.as(iterator.next()));
        }
        this.datas = arrayList.toArray(new FunctionAndSupport[arrayList.size()]);
    }

    public DataModel createDataModel(Calculator calculator) {
        return this;
    }

    public int getColumnCount() throws TableDataException {
        return this.names.length;
    }

    public String getColumnName(int n2) throws TableDataException {
        return this.names[n2];
    }

    public int getRowCount() throws TableDataException {
        return this.datas.length;
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        FunctionAndSupport functionAndSupport = this.datas[n2];
        if (n3 == 0) {
            return functionAndSupport.name;
        }
        if (n3 == 1) {
            return functionAndSupport.support;
        }
        return functionAndSupport.v;
    }

    public boolean hasRow(int n2) throws TableDataException {
        return this.datas.length > n2 && n2 >= 0;
    }

    public void release() throws Exception {
    }

    private static final class FunctionAndSupport {
        String name;
        boolean support;
        BigInteger v;

        private FunctionAndSupport() {
        }
    }
}

