/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.Base64;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.ManagerFactory;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.BrowserProvider;
import com.fr.stable.web.Repository;
import com.fr.web.Browser;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RepositoryDeal
implements Repository {
    private HttpServletRequest req;
    protected SessionIDInfor sessionIDInfor;
    private String servletURL;
    private Browser browser;
    private Calculator i18nCalculator;
    private int resolution = 96;

    public RepositoryDeal(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        this(httpServletRequest, sessionIDInfor, 96);
    }

    public RepositoryDeal(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, int n2) {
        this.req = httpServletRequest;
        this.sessionIDInfor = sessionIDInfor;
        this.servletURL = WebUtils.createServletURL(httpServletRequest);
        this.browser = Browser.resolve(httpServletRequest);
        this.resolution = n2;
        this.initCalculator();
    }

    private void initCalculator() {
        if (this.i18nCalculator == null) {
            this.i18nCalculator = Calculator.createCalculator();
            Locale locale = null;
            String string = (String)this.sessionIDInfor.getParameterValue("fr_locale");
            if (StringUtils.isNotBlank(string)) {
                locale = StableUtils.createLocale(string);
            } else {
                if (this.req != null) {
                    locale = StableUtils.createLocale(WebUtils.getHTTPRequestParameter(this.req, "fr_locale"));
                }
                if (locale == null) {
                    locale = this.req == null ? FRContext.getLocale() : this.req.getLocale();
                }
            }
            this.i18nCalculator.set("__locale__", locale);
            this.i18nCalculator.setAttribute(SessionIDInfor.class, this.sessionIDInfor);
        }
    }

    public BrowserProvider getBrowser() {
        return this.browser;
    }

    public String checkoutObject(Object object, String string) {
        return this.checkoutObject(object, string, true);
    }

    public String checkoutObject(Object object, String string, boolean bl) {
        String string2;
        String string3 = string2 = bl ? this.servletURL : "/" + ManagerFactory.getConfigProvider().getServletMapping();
        if (object == null && "image".equals(string)) {
            return string2 + "?op=resource&resource=/com/fr/web/images/s.gif";
        }
        if (object instanceof String) {
            String string4 = (String)object;
            if ("reportlet".equals(string)) {
                return string2 + "?reportlet=" + CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(string4));
            }
            if ("resource".equals(string)) {
                return string2 + "?reportlet=" + CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(string4));
            }
            if ("widget".equals(string)) {
                return string2 + "?op=widget&widgetname=" + string4 + "&sessionID=" + this.sessionIDInfor.getSessionID();
            }
        } else {
            if (object instanceof Image && "image".equals(string)) {
                Image image = (Image)object;
                if (this.browser.supportIMAGEBase64Decode()) {
                    return "data:image/png;base64," + Base64.encode(image, "png");
                }
                return string2 + "?op=fr_attach&cmd=ah_image&id=" + this.sessionIDInfor.addImage(image);
            }
            if (object instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)object;
                return string2 + "?op=widget" + (string == null ? "" : "&ftype=" + string) + "&location=" + jSONObject.toString() + "&sessionID=" + this.sessionIDInfor.getSessionID();
            }
        }
        return "";
    }

    public String getServletURL() {
        return this.servletURL;
    }

    public HttpServletRequest getHttpServletReques() {
        return this.req;
    }

    public String i18n(String string) {
        if (string == null) {
            return null;
        }
        return TemplateUtils.renderTpl(this.i18nCalculator, string);
    }

    public CalculatorProvider getCalculator() {
        return this.i18nCalculator;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Map getReportParameterMap() {
        return this.sessionIDInfor.getParameterMap4Execute();
    }

    public String getSessionID() {
        return this.sessionIDInfor.getSessionID();
    }
}

