/*
 * Decompiled with CFR 0.152.
 */
package com.fr.transfer.cal;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.sap.SAPTransfer;
import com.fr.report.core.A.w;
import com.fr.transfer.cal.DeleteJober;
import com.fr.transfer.cal.InsertJober;
import com.fr.transfer.cal.IntelliJober;
import com.fr.transfer.cal.SubmitJober;
import com.fr.transfer.cal.UpdateJober;
import java.sql.Connection;
import java.util.Map;

public class SAPTransferSingleRowJob
implements w {
    private SAPTransfer transfer;
    private SubmitJober jober;
    private Connection conn = null;
    private Dialect dialect;
    private Map connectionMap;

    public SAPTransferSingleRowJob(SAPTransfer sAPTransfer, Map map) {
        this.transfer = sAPTransfer;
        if (sAPTransfer.getSubmitType() == 0) {
            this.jober = new InsertJober(sAPTransfer.getExportTable(), sAPTransfer.getColumnConfigs());
        } else if (sAPTransfer.getSubmitType() == 3) {
            this.jober = new DeleteJober(sAPTransfer.getExportTable(), sAPTransfer.getColumnConfigs());
        } else if (sAPTransfer.getSubmitType() == 1) {
            this.jober = new IntelliJober(sAPTransfer.getExportTable(), sAPTransfer.getColumnConfigs());
        } else if (sAPTransfer.getSubmitType() == 2) {
            this.jober = new UpdateJober(sAPTransfer.getExportTable(), sAPTransfer.getColumnConfigs());
        }
        this.connectionMap = map;
    }

    public void doJob(Object[] objectArray) throws Exception {
        if (objectArray.length == this.transfer.getColumnConfigCount()) {
            if (this.conn == null) {
                this.conn = (Connection)this.connectionMap.get(this.transfer.getExportDataBaseName());
                if (this.conn == null) {
                    NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(this.transfer.getExportDataBaseName());
                    this.conn = nameDatabaseConnection.createConnection();
                    this.conn.setAutoCommit(false);
                    this.connectionMap.put(this.transfer.getExportDataBaseName(), this.conn);
                }
                this.dialect = DialectFactory.generateDialect(this.conn);
            }
        } else {
            throw new RuntimeException("SAPTransfer Error: ColSize not compatiable!");
        }
        this.jober.dealSubmit(this.dialect, this.conn, objectArray);
    }
}

