/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.pinyin;

import com.fr.stable.StringUtils;
import com.fr.stable.pinyin.PinyinResource;
import java.util.Map;
import java.util.Properties;

public class ChineseHelper {
    private static final Properties CHINESETABLE = PinyinResource.getChineseTable();

    public static char convertToSimplifiedChinese(char c2) {
        if (ChineseHelper.isTraditionalChinese(c2)) {
            return CHINESETABLE.getProperty(String.valueOf(c2)).charAt(0);
        }
        return c2;
    }

    public static char convertToTraditionalChinese(char c2) {
        String string = String.valueOf(c2);
        if (CHINESETABLE.containsValue(string)) {
            for (Map.Entry<Object, Object> entry : CHINESETABLE.entrySet()) {
                if (!entry.getValue().toString().equals(string)) continue;
                return entry.getKey().toString().charAt(0);
            }
        }
        return c2;
    }

    public static String convertToSimplifiedChinese(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            stringBuilder.append(ChineseHelper.convertToSimplifiedChinese(c2));
        }
        return stringBuilder.toString();
    }

    public static String convertToTraditionalChinese(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            stringBuilder.append(ChineseHelper.convertToTraditionalChinese(c2));
        }
        return stringBuilder.toString();
    }

    public static boolean isTraditionalChinese(char c2) {
        return CHINESETABLE.containsKey(String.valueOf(c2));
    }

    public static boolean isChinese(char c2) {
        String string = "[\\u4e00-\\u9fa5]";
        return String.valueOf(c2).matches(string);
    }

    public static boolean containChinese(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        return !string.matches("[^\u4e00-\u9fa5]*");
    }

    public static final boolean isChineseCharacter(char c2) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        return unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }
}

