/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.loader;

import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class LicenseClassLoader
extends ClassLoader {
    private static Hashtable<String, Class> loadClassHashTable = new Hashtable();

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            Class clazz = this.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            if (string.startsWith("java.")) {
                clazz = this.findSystemClass(string);
                loadClassHashTable.put(string, clazz);
                return clazz;
            }
            try {
                clazz = this.findClass(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl && clazz != null) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.toString());
        }
    }

    public Class findClass(String string) {
        byte[] byArray = new byte[]{};
        try {
            byArray = this.decrypt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        loadClassHashTable.put(string, clazz);
        return clazz;
    }

    private byte[] decrypt(String string) throws Exception {
        String string2 = StringUtils.perfectStart(StableUtils.join(string.split("\\."), "/"), "/") + ".class";
        InputStream inputStream = StableUtils.class.getResourceAsStream(string2);
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        inputStream.close();
        if (string.endsWith("FRCoreContext")) {
            SecureRandom secureRandom = new SecureRandom();
            InputStream inputStream2 = StableUtils.class.getResourceAsStream("/com/fr/stable/loader/key.txt");
            byte[] byArray2 = new byte[inputStream2.available()];
            inputStream2.read(byArray2);
            inputStream2.close();
            DESKeySpec dESKeySpec = new DESKeySpec(byArray2);
            SecretKey secretKey = SecretKeyFactory.getInstance("DES").generateSecret(dESKeySpec);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, (Key)secretKey, secureRandom);
            byte[] byArray3 = cipher.doFinal(byArray);
            return byArray3;
        }
        return byArray;
    }
}

